/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import zombie.ai.states.PathFindState;
import zombie.characters.IsoPlayer;
import zombie.debug.DebugOptions;
import zombie.iso.IsoDirections;
import zombie.iso.Vector2;
import zombie.network.GameClient;
import zombie.vehicles.PathFindBehavior2;

public class MPDebugAI {
    private static final Vector2 tempo = new Vector2();
    private static final Vector2 tempo2 = new Vector2();

    public static IsoPlayer getNearestPlayer(IsoPlayer isoPlayer) {
        IsoPlayer isoPlayer2 = null;
        for (IsoPlayer isoPlayer3 : GameClient.IDToPlayerMap.values()) {
            if (isoPlayer3 == isoPlayer || isoPlayer2 != null && !(isoPlayer2.getDistanceSq(isoPlayer) > isoPlayer3.getDistanceSq(isoPlayer))) continue;
            isoPlayer2 = isoPlayer3;
        }
        return isoPlayer2;
    }

    public static boolean updateMovementFromInput(IsoPlayer isoPlayer, IsoPlayer.MoveVars moveVars) {
        if (GameClient.bClient && isoPlayer.isLocalPlayer() && (DebugOptions.instance.MultiplayerAttackPlayer.getValue() || DebugOptions.instance.MultiplayerFollowPlayer.getValue())) {
            Object object;
            IsoPlayer isoPlayer2 = MPDebugAI.getNearestPlayer(isoPlayer);
            if (isoPlayer2 != null) {
                object = new Vector2(isoPlayer2.x - isoPlayer.x, isoPlayer.y - isoPlayer2.y);
                ((Vector2)object).rotate(-0.7853982f);
                ((Vector2)object).normalize();
                moveVars.moveX = ((Vector2)object).x;
                moveVars.moveY = ((Vector2)object).y;
                moveVars.NewFacing = IsoDirections.fromAngle((Vector2)object);
                if (isoPlayer2.isTeleporting() || isoPlayer2.getDistanceSq(isoPlayer) > 10.0f) {
                    isoPlayer.removeFromSquare();
                    isoPlayer.setX(isoPlayer2.realx);
                    isoPlayer.setY(isoPlayer2.realy);
                    isoPlayer.setZ(isoPlayer2.realz);
                    isoPlayer.setLx(isoPlayer2.realx);
                    isoPlayer.setLy(isoPlayer2.realy);
                    isoPlayer.setLz(isoPlayer2.realz);
                    isoPlayer.ensureOnTile();
                } else if (isoPlayer2.getDistanceSq(isoPlayer) > 5.0f) {
                    isoPlayer.setRunning(true);
                    isoPlayer.setSprinting(true);
                } else if (isoPlayer2.getDistanceSq(isoPlayer) > 2.5f) {
                    isoPlayer.setRunning(true);
                } else if (isoPlayer2.getDistanceSq(isoPlayer) < 1.25f) {
                    moveVars.moveX = 0.0f;
                    moveVars.moveY = 0.0f;
                }
            }
            object = isoPlayer.getPathFindBehavior2();
            if (moveVars.moveX == 0.0f && moveVars.moveY == 0.0f && isoPlayer.getPath2() != null && ((PathFindBehavior2)object).isStrafing() && !((PathFindBehavior2)object).bStopping) {
                Vector2 vector22 = tempo.set(((PathFindBehavior2)object).getTargetX() - isoPlayer.x, ((PathFindBehavior2)object).getTargetY() - isoPlayer.y);
                Vector2 vector23 = tempo2.set(-1.0f, 0.0f);
                float f = 1.0f;
                float f2 = vector22.dot(vector23);
                float f3 = f2 / f;
                vector23 = tempo2.set(0.0f, -1.0f);
                f2 = vector22.dot(vector23);
                float f4 = f2 / f;
                tempo.set(f4, f3);
                tempo.normalize();
                tempo.rotate(0.7853982f);
                moveVars.moveX = MPDebugAI.tempo.x;
                moveVars.moveY = MPDebugAI.tempo.y;
            }
            if (moveVars.moveX != 0.0f || moveVars.moveY != 0.0f) {
                if (isoPlayer.stateMachine.getCurrent() == PathFindState.instance()) {
                    isoPlayer.setDefaultState();
                }
                isoPlayer.setJustMoved(true);
                isoPlayer.setMoveDelta(1.0f);
                if (isoPlayer.isStrafing()) {
                    tempo.set(moveVars.moveX, moveVars.moveY);
                    tempo.normalize();
                    float f = isoPlayer.legsSprite.modelSlot.model.AnimPlayer.getRenderedAngle();
                    f = (float)((double)f + 0.7853981633974483);
                    if ((double)f > Math.PI * 2) {
                        f = (float)((double)f - Math.PI * 2);
                    }
                    if (f < 0.0f) {
                        f = (float)((double)f + Math.PI * 2);
                    }
                    tempo.rotate(f);
                    moveVars.strafeX = MPDebugAI.tempo.x;
                    moveVars.strafeY = MPDebugAI.tempo.y;
                } else {
                    tempo.set(moveVars.moveX, -moveVars.moveY);
                    tempo.normalize();
                    tempo.rotate(-0.7853982f);
                    isoPlayer.setForwardDirection(tempo);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean updateInputState(IsoPlayer isoPlayer, IsoPlayer.InputState inputState) {
        if (GameClient.bClient && isoPlayer.isLocalPlayer() && DebugOptions.instance.MultiplayerAttackPlayer.getValue()) {
            IsoPlayer isoPlayer2 = MPDebugAI.getNearestPlayer(isoPlayer);
            inputState.bMelee = false;
            inputState.isAttacking = false;
            inputState.isCharging = false;
            inputState.isAiming = false;
            inputState.bRunning = false;
            inputState.bSprinting = false;
            if (isoPlayer2 != null) {
                inputState.isCharging = true;
                inputState.isAiming = false;
                if (isoPlayer2.getDistanceSq(isoPlayer) < 0.5f) {
                    inputState.bMelee = true;
                    inputState.isAttacking = true;
                }
            }
            return true;
        }
        if (GameClient.bClient && isoPlayer.isLocalPlayer() && DebugOptions.instance.MultiplayerFollowPlayer.getValue()) {
            IsoPlayer isoPlayer3 = MPDebugAI.getNearestPlayer(isoPlayer);
            inputState.bMelee = false;
            inputState.isAttacking = false;
            inputState.isCharging = false;
            inputState.isAiming = false;
            inputState.bRunning = false;
            inputState.bSprinting = false;
            return true;
        }
        return false;
    }
}

