/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.PersistentOutfits;
import zombie.SandboxOptions;
import zombie.SharedDescriptors;
import zombie.SoundManager;
import zombie.SystemDisabler;
import zombie.VirtualZombieManager;
import zombie.WorldSoundManager;
import zombie.ai.State;
import zombie.ai.ZombieGroupManager;
import zombie.ai.astar.AStarPathFinder;
import zombie.ai.astar.Mover;
import zombie.ai.states.AttackNetworkState;
import zombie.ai.states.AttackState;
import zombie.ai.states.BumpedState;
import zombie.ai.states.BurntToDeath;
import zombie.ai.states.ClimbOverFenceState;
import zombie.ai.states.ClimbOverWallState;
import zombie.ai.states.ClimbThroughWindowState;
import zombie.ai.states.CrawlingZombieTurnState;
import zombie.ai.states.FakeDeadAttackState;
import zombie.ai.states.FakeDeadZombieState;
import zombie.ai.states.IdleState;
import zombie.ai.states.LungeNetworkState;
import zombie.ai.states.LungeState;
import zombie.ai.states.PathFindState;
import zombie.ai.states.PlayerHitReactionState;
import zombie.ai.states.StaggerBackState;
import zombie.ai.states.ThumpState;
import zombie.ai.states.WalkTowardNetworkState;
import zombie.ai.states.WalkTowardState;
import zombie.ai.states.ZombieEatBodyState;
import zombie.ai.states.ZombieFaceTargetState;
import zombie.ai.states.ZombieFallDownState;
import zombie.ai.states.ZombieFallingState;
import zombie.ai.states.ZombieGetDownState;
import zombie.ai.states.ZombieGetUpFromCrawlState;
import zombie.ai.states.ZombieGetUpState;
import zombie.ai.states.ZombieHitReactionState;
import zombie.ai.states.ZombieIdleState;
import zombie.ai.states.ZombieOnGroundState;
import zombie.ai.states.ZombieReanimateState;
import zombie.ai.states.ZombieSittingState;
import zombie.ai.states.ZombieTurnAlerted;
import zombie.audio.parameters.ParameterCharacterInside;
import zombie.audio.parameters.ParameterCharacterMovementSpeed;
import zombie.audio.parameters.ParameterFootstepMaterial;
import zombie.audio.parameters.ParameterFootstepMaterial2;
import zombie.audio.parameters.ParameterPlayerDistance;
import zombie.audio.parameters.ParameterShoeType;
import zombie.audio.parameters.ParameterVehicleHitLocation;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characters.AttachedItems.AttachedItem;
import zombie.characters.AttachedItems.AttachedItems;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.characters.HitReactionNetworkAI;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.NetworkCharacterAI;
import zombie.characters.NetworkZombieAI;
import zombie.characters.SurvivorDesc;
import zombie.characters.SurvivorFactory;
import zombie.characters.UnderwearDefinition;
import zombie.characters.WornItems.WornItem;
import zombie.characters.WornItems.WornItems;
import zombie.characters.ZombieFootstepManager;
import zombie.characters.ZombieGroup;
import zombie.characters.ZombieVocalsManager;
import zombie.characters.ZombiesZoneDefinition;
import zombie.characters.action.ActionContext;
import zombie.characters.action.ActionGroup;
import zombie.characters.skills.PerkFactory;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.core.opengl.RenderSettings;
import zombie.core.opengl.Shader;
import zombie.core.profiling.PerformanceProfileProbe;
import zombie.core.raknet.UdpConnection;
import zombie.core.skinnedmodel.DeadBodyAtlas;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.animation.AnimationPlayer;
import zombie.core.skinnedmodel.animation.sharedskele.SharedSkeleAnimationRepository;
import zombie.core.skinnedmodel.population.Outfit;
import zombie.core.skinnedmodel.population.OutfitManager;
import zombie.core.skinnedmodel.population.OutfitRNG;
import zombie.core.skinnedmodel.visual.BaseVisual;
import zombie.core.skinnedmodel.visual.HumanVisual;
import zombie.core.skinnedmodel.visual.IHumanVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.core.utils.BooleanGrid;
import zombie.core.utils.OnceEvery;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.debug.LogSeverity;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.InventoryContainer;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.LightingJNI;
import zombie.iso.LosUtil;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.areas.IsoBuilding;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoFireManager;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.IsoWindowFrame;
import zombie.iso.objects.IsoZombieGiblets;
import zombie.iso.objects.interfaces.Thumpable;
import zombie.iso.sprite.IsoAnim;
import zombie.iso.sprite.IsoSprite;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.MPStatistics;
import zombie.network.NetworkVariables;
import zombie.network.ServerLOS;
import zombie.network.ServerMap;
import zombie.network.packets.ZombiePacket;
import zombie.popman.NetworkZombieManager;
import zombie.popman.NetworkZombieSimulator;
import zombie.popman.ZombieCountOptimiser;
import zombie.scripting.ScriptManager;
import zombie.ui.TextManager;
import zombie.ui.UIFont;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.util.list.PZArrayUtil;
import zombie.vehicles.AttackVehicleState;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.PolygonalMap2;
import zombie.vehicles.VehiclePart;

public final class IsoZombie
extends IsoGameCharacter
implements IHumanVisual {
    public static final byte SPEED_SPRINTER = 1;
    public static final byte SPEED_FAST_SHAMBLER = 2;
    public static final byte SPEED_SHAMBLER = 3;
    public static final byte SPEED_RANDOM = 4;
    public static final byte HEARING_PINPOINT = 1;
    public static final byte HEARING_NORMAL = 2;
    public static final byte HEARING_POOR = 3;
    public static final byte HEARING_RANDOM = 4;
    public static final byte THUMP_FLAG_GENERIC = 1;
    public static final byte THUMP_FLAG_WINDOW_EXTRA = 2;
    public static final byte THUMP_FLAG_WINDOW = 3;
    public static final byte THUMP_FLAG_METAL = 4;
    public static final byte THUMP_FLAG_GARAGE_DOOR = 5;
    private boolean alwaysKnockedDown = false;
    private boolean onlyJawStab = false;
    private boolean forceEatingAnimation = false;
    private boolean noTeeth = false;
    public static final int AllowRepathDelayMax = 120;
    public static final boolean SPRINTER_FIXES = true;
    public int LastTargetSeenX = -1;
    public int LastTargetSeenY = -1;
    public int LastTargetSeenZ = -1;
    public boolean Ghost = false;
    public float LungeTimer = 0.0f;
    public long LungeSoundTime = 0L;
    public IsoMovingObject target;
    public float TimeSinceSeenFlesh = 100000.0f;
    private float targetSeenTime = 0.0f;
    public int FollowCount = 0;
    public int ZombieID = 0;
    private float BonusSpotTime = 0.0f;
    public boolean bStaggerBack = false;
    private boolean bKnifeDeath = false;
    private boolean bJawStabAttach = false;
    private boolean bBecomeCrawler = false;
    private boolean bFakeDead = false;
    private boolean bForceFakeDead = false;
    private boolean bWasFakeDead = false;
    private boolean bReanimate = false;
    public DeadBodyAtlas.BodyTexture atlasTex = null;
    private boolean bReanimatedPlayer = false;
    public boolean bIndoorZombie = false;
    public int thumpFlag = 0;
    public boolean thumpSent = false;
    private float thumpCondition = 1.0f;
    public static final float EAT_BODY_DIST = 1.0f;
    public static final float EAT_BODY_TIME = 3600.0f;
    public static final float LUNGE_TIME = 180.0f;
    public static final float CRAWLER_DAMAGE_DOT = 0.9f;
    public static final float CRAWLER_DAMAGE_RANGE = 1.5f;
    private boolean useless = false;
    public int speedType = -1;
    public ZombieGroup group;
    public boolean inactive = false;
    public int strength = -1;
    public int cognition = -1;
    public int memory = -1;
    public int sight = -1;
    public int hearing = -1;
    private ArrayList<InventoryItem> itemsToSpawnAtDeath = null;
    private float soundReactDelay = 0.0f;
    private final IsoGameCharacter.Location delayedSound = new IsoGameCharacter.Location(-1, -1, -1);
    private boolean bSoundSourceRepeating = false;
    public Object soundSourceTarget = null;
    public float soundAttract = 0.0f;
    public float soundAttractTimeout = 0.0f;
    private final Vector2 hitAngle = new Vector2();
    public boolean alerted = false;
    private String walkType = null;
    private float footstepVolume = 1.0f;
    protected SharedDescriptors.Descriptor sharedDesc;
    public boolean bDressInRandomOutfit = false;
    public String pendingOutfitName;
    protected final HumanVisual humanVisual = new HumanVisual(this);
    private int crawlerType = 0;
    private String playerAttackPosition = null;
    private float eatSpeed = 1.0f;
    private boolean sitAgainstWall = false;
    private static final int CHECK_FOR_CORPSE_TIMER_MAX = 10000;
    private float checkForCorpseTimer = 10000.0f;
    public IsoDeadBody bodyToEat = null;
    public IsoMovingObject eatBodyTarget;
    private int hitTime = 0;
    private int thumpTimer = 0;
    private boolean hitLegsWhileOnFloor = false;
    public boolean collideWhileHit = true;
    private float m_characterTextureAnimTime = 0.0f;
    private float m_characterTextureAnimDuration = 1.0f;
    public int lastPlayerHit = -1;
    protected final ItemVisuals itemVisuals = new ItemVisuals();
    private int hitHeadWhileOnFloor = 0;
    private BaseVehicle vehicle4testCollision = null;
    public String SpriteName = "BobZ";
    public static final int PALETTE_COUNT = 3;
    public final Vector2 vectorToTarget = new Vector2();
    public float AllowRepathDelay = 0.0f;
    public boolean KeepItReal = false;
    private boolean isSkeleton = false;
    public final ParameterCharacterInside parameterCharacterInside = new ParameterCharacterInside(this);
    private final ParameterCharacterMovementSpeed parameterCharacterMovementSpeed = new ParameterCharacterMovementSpeed(this);
    private final ParameterFootstepMaterial parameterFootstepMaterial = new ParameterFootstepMaterial(this);
    private final ParameterFootstepMaterial2 parameterFootstepMaterial2 = new ParameterFootstepMaterial2(this);
    public final ParameterPlayerDistance parameterPlayerDistance = new ParameterPlayerDistance(this);
    private final ParameterShoeType parameterShoeType = new ParameterShoeType(this);
    private final ParameterVehicleHitLocation parameterVehicleHitLocation = new ParameterVehicleHitLocation();
    public final ParameterZombieState parameterZombieState = new ParameterZombieState(this);
    public boolean scratch = false;
    public boolean laceration = false;
    public final NetworkZombieAI networkAI;
    public UdpConnection authOwner = null;
    public IsoPlayer authOwnerPlayer = null;
    public ZombiePacket zombiePacket = new ZombiePacket();
    public boolean zombiePacketUpdated = false;
    public long lastChangeOwner = -1L;
    private static final SharedSkeleAnimationRepository m_sharedSkeleRepo = new SharedSkeleAnimationRepository();
    public int palette = 0;
    public int AttackAnimTime = 50;
    public static int AttackAnimTimeMax = 50;
    public IsoMovingObject spottedLast = null;
    Aggro[] aggroList = new Aggro[4];
    public int spotSoundDelay = 0;
    public float movex;
    public float movey;
    private int stepFrameLast = -1;
    private OnceEvery networkUpdate = new OnceEvery(1.0f);
    public short lastRemoteUpdate = 0;
    public short OnlineID = (short)-1;
    private static final ArrayList<IsoDeadBody> tempBodies = new ArrayList();
    float timeSinceRespondToSound = 1000000.0f;
    public String walkVariantUse = null;
    public String walkVariant = "ZombieWalk";
    public boolean bLunger;
    public boolean bRunning;
    public boolean bCrawling;
    private boolean bCanCrawlUnderVehicle = true;
    private boolean bCanWalk = true;
    public boolean bRemote;
    private static final FloodFill floodFill = new FloodFill();
    public boolean ImmortalTutorialZombie;

    @Override
    public String getObjectName() {
        return "Zombie";
    }

    @Override
    public short getOnlineID() {
        return this.OnlineID;
    }

    public boolean isRemoteZombie() {
        return this.authOwner == null;
    }

    public void setVehicle4TestCollision(BaseVehicle baseVehicle) {
        this.vehicle4testCollision = baseVehicle;
    }

    public IsoZombie(IsoCell isoCell) {
        this(isoCell, null, -1);
    }

    public IsoZombie(IsoCell isoCell, SurvivorDesc survivorDesc, int n) {
        super(isoCell, 0.0f, 0.0f, 0.0f);
        this.registerVariableCallbacks();
        this.Health = 1.8f + Rand.Next(0.0f, 0.3f);
        this.weight = 0.7f;
        this.dir = IsoDirections.fromIndex(Rand.Next(8));
        this.humanVisual.randomBlood();
        if (survivorDesc != null) {
            this.descriptor = survivorDesc;
            this.palette = n;
        } else {
            this.descriptor = SurvivorFactory.CreateSurvivor();
            this.palette = Rand.Next(3) + 1;
        }
        this.setFemale(this.descriptor.isFemale());
        String string = this.SpriteName = this.isFemale() ? "KateZ" : "BobZ";
        if (this.palette != 1) {
            this.SpriteName = this.SpriteName + this.palette;
        }
        this.InitSpritePartsZombie();
        this.sprite.def.tintr = 0.95f + (float)Rand.Next(5) / 100.0f;
        this.sprite.def.tintg = 0.95f + (float)Rand.Next(5) / 100.0f;
        this.sprite.def.tintb = 0.95f + (float)Rand.Next(5) / 100.0f;
        this.setDefaultState(ZombieIdleState.instance());
        this.setFakeDead(false);
        this.DoZombieStats();
        this.width = 0.3f;
        this.setAlphaAndTarget(0.0f);
        this.finder.maxSearchDistance = 20;
        if (this.isFemale()) {
            this.hurtSound = "FemaleZombieHurt";
        }
        this.initializeStates();
        this.actionContext.setGroup(ActionGroup.getActionGroup("zombie"));
        this.initWornItems("Human");
        this.initAttachedItems("Human");
        this.networkAI = new NetworkZombieAI(this);
        this.clearAggroList();
    }

    public void initializeStates() {
        HashMap<String, State> hashMap = this.getStateUpdateLookup();
        hashMap.clear();
        hashMap.put("attack-network", AttackNetworkState.instance());
        hashMap.put("attackvehicle-network", IdleState.instance());
        hashMap.put("fakedead-attack-network", IdleState.instance());
        hashMap.put("lunge-network", LungeNetworkState.instance());
        hashMap.put("walktoward-network", WalkTowardNetworkState.instance());
        if (this.bCrawling) {
            hashMap.put("attack", AttackState.instance());
            hashMap.put("fakedead", FakeDeadZombieState.instance());
            hashMap.put("fakedead-attack", FakeDeadAttackState.instance());
            hashMap.put("getup", ZombieGetUpFromCrawlState.instance());
            hashMap.put("hitreaction", ZombieHitReactionState.instance());
            hashMap.put("hitreaction-hit", ZombieHitReactionState.instance());
            hashMap.put("idle", ZombieIdleState.instance());
            hashMap.put("onground", ZombieOnGroundState.instance());
            hashMap.put("pathfind", PathFindState.instance());
            hashMap.put("reanimate", ZombieReanimateState.instance());
            hashMap.put("staggerback", StaggerBackState.instance());
            hashMap.put("thump", ThumpState.instance());
            hashMap.put("turn", CrawlingZombieTurnState.instance());
            hashMap.put("walktoward", WalkTowardState.instance());
        } else {
            hashMap.put("attack", AttackState.instance());
            hashMap.put("attackvehicle", AttackVehicleState.instance());
            hashMap.put("bumped", BumpedState.instance());
            hashMap.put("climbfence", ClimbOverFenceState.instance());
            hashMap.put("climbwindow", ClimbThroughWindowState.instance());
            hashMap.put("eatbody", ZombieEatBodyState.instance());
            hashMap.put("falldown", ZombieFallDownState.instance());
            hashMap.put("falling", ZombieFallingState.instance());
            hashMap.put("face-target", ZombieFaceTargetState.instance());
            hashMap.put("fakedead", FakeDeadZombieState.instance());
            hashMap.put("fakedead-attack", FakeDeadAttackState.instance());
            hashMap.put("getdown", ZombieGetDownState.instance());
            hashMap.put("getup", ZombieGetUpState.instance());
            hashMap.put("hitreaction", ZombieHitReactionState.instance());
            hashMap.put("hitreaction-hit", ZombieHitReactionState.instance());
            hashMap.put("idle", ZombieIdleState.instance());
            hashMap.put("lunge", LungeState.instance());
            hashMap.put("onground", ZombieOnGroundState.instance());
            hashMap.put("pathfind", PathFindState.instance());
            hashMap.put("sitting", ZombieSittingState.instance());
            hashMap.put("staggerback", StaggerBackState.instance());
            hashMap.put("thump", ThumpState.instance());
            hashMap.put("turnalerted", ZombieTurnAlerted.instance());
            hashMap.put("walktoward", WalkTowardState.instance());
        }
    }

    private void registerVariableCallbacks() {
        this.setVariable("bClient", () -> GameClient.bClient && this.isRemoteZombie());
        this.setVariable("bMovingNetwork", () -> !(!this.isLocal() && this.isBumped() || !(IsoUtils.DistanceManhatten(this.networkAI.targetX, this.networkAI.targetY, this.x, this.y) > 0.5f) && this.z == (float)this.networkAI.targetZ));
        this.setVariable("hitHeadType", this::getHitHeadWhileOnFloor);
        this.setVariable("realState", this::getRealState);
        this.setVariable("battack", () -> {
            Object object;
            if (SystemDisabler.zombiesDontAttack) {
                return false;
            }
            if (this.target == null || this.target.isZombiesDontAttack()) {
                return false;
            }
            if (this.target instanceof IsoGameCharacter) {
                if (this.target.isOnFloor() && ((IsoGameCharacter)this.target).getCurrentState() != BumpedState.instance()) {
                    this.setTarget(null);
                    return false;
                }
                object = ((IsoGameCharacter)this.target).getVehicle();
                if (object != null) {
                    return false;
                }
                if (((IsoGameCharacter)this.target).ReanimatedCorpse != null) {
                    return false;
                }
                if (((IsoGameCharacter)this.target).getStateMachine().getCurrent() == ClimbOverWallState.instance()) {
                    return false;
                }
            }
            if (this.bReanimate) {
                return false;
            }
            if (Math.abs(this.target.z - this.z) >= 0.2f) {
                return false;
            }
            if (this.target instanceof IsoPlayer && ((IsoPlayer)this.target).isGhostMode()) {
                return false;
            }
            if (this.bFakeDead) {
                return !this.isUnderVehicle() && this.DistTo(this.target) < 1.3f;
            }
            if (this.bCrawling) {
                return !this.isUnderVehicle() && this.DistTo(this.target) < 1.3f;
            }
            object = this.getCurrentSquare();
            IsoGridSquare isoGridSquare = this.target.getCurrentSquare();
            if (object != null && ((IsoGridSquare)object).isSomethingTo(isoGridSquare)) {
                return false;
            }
            float f = this.bCrawling ? 1.4f : 0.72f;
            float f2 = this.vectorToTarget.getLength();
            return f2 <= f;
        });
        this.setVariable("isFacingTarget", this::isFacingTarget);
        this.setVariable("targetSeenTime", this::getTargetSeenTime);
        this.setVariable("battackvehicle", () -> {
            if (this.getVariableBoolean("bPathfind")) {
                return false;
            }
            if (this.isMoving()) {
                return false;
            }
            if (this.target == null) {
                return false;
            }
            if (Math.abs(this.target.z - this.z) >= 0.8f) {
                return false;
            }
            if (this.target instanceof IsoPlayer && ((IsoPlayer)this.target).isGhostMode()) {
                return false;
            }
            if (this.target instanceof IsoGameCharacter) {
                BaseVehicle baseVehicle = ((IsoGameCharacter)this.target).getVehicle();
                return baseVehicle != null && baseVehicle.isCharacterAdjacentTo(this);
            }
            return false;
        });
        this.setVariable("beatbodytarget", () -> {
            if (this.isForceEatingAnimation()) {
                return true;
            }
            if (!GameServer.bServer) {
                this.updateEatBodyTarget();
            }
            return this.getEatBodyTarget() != null;
        });
        this.setVariable("bbecomecrawler", this::isBecomeCrawler, this::setBecomeCrawler);
        this.setVariable("bfakedead", () -> this.bFakeDead);
        this.setVariable("bfalling", () -> this.z > 0.0f && this.fallTime > 2.0f);
        this.setVariable("bhastarget", () -> {
            if (this.target instanceof IsoGameCharacter && ((IsoGameCharacter)this.target).ReanimatedCorpse != null) {
                this.setTarget(null);
            }
            return this.target != null;
        });
        this.setVariable("shouldSprint", () -> {
            if (this.target instanceof IsoGameCharacter && ((IsoGameCharacter)this.target).ReanimatedCorpse != null) {
                this.setTarget(null);
            }
            return this.target != null || this.soundSourceTarget != null && !(this.soundSourceTarget instanceof IsoZombie);
        });
        this.setVariable("bknockeddown", this::isKnockedDown);
        this.setVariable("blunge", () -> {
            if (this.target == null) {
                return false;
            }
            if ((int)this.getZ() != (int)this.target.getZ()) {
                return false;
            }
            if (this.target instanceof IsoGameCharacter) {
                if (((IsoGameCharacter)this.target).getVehicle() != null) {
                    return false;
                }
                if (((IsoGameCharacter)this.target).ReanimatedCorpse != null) {
                    return false;
                }
            }
            if (this.target instanceof IsoPlayer && ((IsoPlayer)this.target).isGhostMode()) {
                this.setTarget(null);
                return false;
            }
            IsoGridSquare isoGridSquare = this.getCurrentSquare();
            IsoGridSquare isoGridSquare2 = this.target.getCurrentSquare();
            if (isoGridSquare2 != null && isoGridSquare2.isSomethingTo(isoGridSquare) && this.getThumpTarget() != null) {
                return false;
            }
            if (this.isCurrentState(ZombieTurnAlerted.instance()) && !this.isFacingTarget()) {
                return false;
            }
            float f = this.vectorToTarget.getLength();
            if (!(!(f > 3.5f) || f <= 4.0f && this.target instanceof IsoGameCharacter && ((IsoGameCharacter)this.target).getVehicle() != null)) {
                return false;
            }
            return !PolygonalMap2.instance.lineClearCollide(this.getX(), this.getY(), this.target.x, this.target.y, (int)this.getZ(), this.target, false, true);
        });
        this.setVariable("bpassengerexposed", () -> AttackVehicleState.instance().isPassengerExposed(this));
        this.setVariable("bistargetissmallvehicle", () -> {
            if (this.target != null && this.target instanceof IsoPlayer && ((IsoPlayer)this.target).getVehicle() != null) {
                return ((IsoPlayer)this.target).getVehicle().getScript().isSmallVehicle;
            }
            return true;
        });
        this.setVariable("breanimate", this::isReanimate, this::setReanimate);
        this.setVariable("bstaggerback", this::isStaggerBack);
        this.setVariable("bthump", () -> {
            IsoObject isoObject;
            if (this.getThumpTarget() instanceof IsoObject && !(this.getThumpTarget() instanceof BaseVehicle) && ((isoObject = (IsoObject)this.getThumpTarget()).getSquare() == null || this.DistToSquared(isoObject.getX() + 0.5f, isoObject.getY() + 0.5f) > 9.0f)) {
                this.setThumpTarget(null);
            }
            if (this.getThumpTimer() > 0) {
                this.setThumpTarget(null);
            }
            return this.getThumpTarget() != null;
        });
        this.setVariable("bundervehicle", this::isUnderVehicle);
        this.setVariable("bBeingSteppedOn", this::isBeingSteppedOn);
        this.setVariable("distancetotarget", () -> {
            if (this.target == null) {
                return "";
            }
            return String.valueOf(this.vectorToTarget.getLength() - this.getWidth() + this.target.getWidth());
        });
        this.setVariable("lasttargetseen", () -> this.LastTargetSeenX != -1);
        this.setVariable("lungetimer", () -> Float.valueOf(this.LungeTimer));
        this.setVariable("reanimatetimer", this::getReanimateTimer);
        this.setVariable("stateeventdelaytimer", this::getStateEventDelayTimer);
        this.setVariable("turndirection", () -> {
            if (this.getPath2() != null) {
                return "";
            }
            if (this.target == null || this.vectorToTarget.getLength() == 0.0f) {
                if (this.isCurrentState(WalkTowardState.instance())) {
                    WalkTowardState.instance().calculateTargetLocation(this, tempo);
                    IsoZombie.tempo.x -= this.getX();
                    IsoZombie.tempo.y -= this.getY();
                    IsoDirections isoDirections = IsoDirections.fromAngle(tempo);
                    if (this.dir == isoDirections) {
                        return "";
                    }
                    boolean bl = CrawlingZombieTurnState.calculateDir(this, isoDirections);
                    return bl ? "left" : "right";
                }
                if (this.isCurrentState(PathFindState.instance())) {
                    // empty if block
                }
                return "";
            }
            if (this.isRemoteZombie()) {
                tempo.set(this.networkAI.targetX - this.x, this.networkAI.targetY - this.y);
            } else {
                tempo.set(this.vectorToTarget);
            }
            IsoDirections isoDirections = IsoDirections.fromAngle(tempo);
            if (this.dir == isoDirections) {
                return "";
            }
            boolean bl = CrawlingZombieTurnState.calculateDir(this, isoDirections);
            return bl ? "left" : "right";
        });
        this.setVariable("hitforce", this::getHitForce);
        this.setVariable("alerted", () -> this.alerted);
        this.setVariable("zombiewalktype", () -> this.walkType);
        this.setVariable("crawlertype", () -> this.crawlerType);
        this.setVariable("bGetUpFromCrawl", this::shouldGetUpFromCrawl);
        this.setVariable("playerattackposition", this::getPlayerAttackPosition);
        this.setVariable("eatspeed", () -> Float.valueOf(this.eatSpeed));
        this.setVariable("issitting", this::isSitAgainstWall);
        this.setVariable("bKnifeDeath", this::isKnifeDeath, this::setKnifeDeath);
        this.setVariable("bJawStabAttach", this::isJawStabAttach, this::setJawStabAttach);
        this.setVariable("bPathFindPrediction", () -> NetworkVariables.PredictionTypes.PathFind.equals((Object)this.networkAI.predictionType));
        this.setVariable("bCrawling", this::isCrawling, this::setCrawler);
    }

    @Override
    public void actionStateChanged(ActionContext actionContext) {
        super.actionStateChanged(actionContext);
        if (this.networkAI != null && GameServer.bServer) {
            this.networkAI.extraUpdate();
        }
    }

    @Override
    public ActionContext getActionContext() {
        return this.actionContext;
    }

    @Override
    protected void onAnimPlayerCreated(AnimationPlayer animationPlayer) {
        super.onAnimPlayerCreated(animationPlayer);
        animationPlayer.setSharedAnimRepo(m_sharedSkeleRepo);
    }

    @Override
    public String GetAnimSetName() {
        return this.bCrawling ? "zombie-crawler" : "zombie";
    }

    public void InitSpritePartsZombie() {
        SurvivorDesc survivorDesc = this.descriptor;
        this.InitSpritePartsZombie(survivorDesc);
    }

    public void InitSpritePartsZombie(SurvivorDesc survivorDesc) {
        this.sprite.AnimMap.clear();
        this.sprite.AnimStack.clear();
        this.sprite.CurrentAnim = new IsoAnim();
        this.sprite.CurrentAnim.name = "REMOVE";
        this.legsSprite = this.sprite;
        this.legsSprite.name = survivorDesc.torso;
        this.ZombieID = Rand.Next(10000);
        this.bUseParts = true;
    }

    @Override
    public void pathToCharacter(IsoGameCharacter isoGameCharacter) {
        if (this.AllowRepathDelay > 0.0f && (this.isCurrentState(PathFindState.instance()) || this.isCurrentState(WalkTowardState.instance()) || this.isCurrentState(WalkTowardNetworkState.instance()))) {
            return;
        }
        super.pathToCharacter(isoGameCharacter);
    }

    @Override
    public void pathToLocationF(float f, float f2, float f3) {
        if (this.AllowRepathDelay > 0.0f && (this.isCurrentState(PathFindState.instance()) || this.isCurrentState(WalkTowardState.instance()) || this.isCurrentState(WalkTowardNetworkState.instance()))) {
            return;
        }
        super.pathToLocationF(f, f2, f3);
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        this.walkVariant = "ZombieWalk";
        this.SpriteName = "BobZ";
        if (this.palette != 1) {
            this.SpriteName = this.SpriteName + this.palette;
        }
        SurvivorDesc survivorDesc = this.descriptor;
        this.setFemale(survivorDesc.isFemale());
        if (this.isFemale()) {
            this.SpriteName = this.palette == 1 ? "KateZ" : "KateZ" + this.palette;
        }
        this.hurtSound = this.isFemale() ? "FemaleZombieHurt" : "MaleZombieHurt";
        this.InitSpritePartsZombie(survivorDesc);
        this.sprite.def.tintr = 0.95f + (float)Rand.Next(5) / 100.0f;
        this.sprite.def.tintg = 0.95f + (float)Rand.Next(5) / 100.0f;
        this.sprite.def.tintb = 0.95f + (float)Rand.Next(5) / 100.0f;
        this.setDefaultState(ZombieIdleState.instance());
        this.DoZombieStats();
        byteBuffer.getFloat();
        this.setWidth(0.3f);
        this.TimeSinceSeenFlesh = byteBuffer.getInt();
        this.setAlpha(0.0f);
        this.setFakeDead(byteBuffer.getInt() == 1);
        ArrayList arrayList = this.savedInventoryItems;
        int n2 = byteBuffer.get();
        for (int i = 0; i < n2; ++i) {
            String string = GameWindow.ReadString(byteBuffer);
            short s = byteBuffer.getShort();
            if (s < 0 || s >= arrayList.size() || this.wornItems.getBodyLocationGroup().getLocation(string) == null) continue;
            this.wornItems.setItem(string, (InventoryItem)arrayList.get(s));
        }
        this.setStateMachineLocked(false);
        this.setDefaultState();
        this.getCell().getZombieList().add(this);
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.putFloat(0.0f);
        byteBuffer.putInt((int)this.TimeSinceSeenFlesh);
        byteBuffer.putInt(this.isFakeDead() ? 1 : 0);
        if (this.wornItems.size() > 127) {
            throw new RuntimeException("too many worn items");
        }
        byteBuffer.put((byte)this.wornItems.size());
        this.wornItems.forEach(wornItem -> {
            GameWindow.WriteString(byteBuffer, wornItem.getLocation());
            byteBuffer.putShort((short)this.savedInventoryItems.indexOf(wornItem.getItem()));
        });
    }

    @Override
    public void collideWith(IsoObject isoObject) {
        if (this.Ghost || isoObject == null) {
            return;
        }
        if (isoObject.rerouteCollide != null) {
            isoObject = this.rerouteCollide;
        }
        State state = this.getCurrentState();
        boolean bl = this.isCurrentState(PathFindState.instance()) || this.isCurrentState(LungeState.instance()) || this.isCurrentState(LungeNetworkState.instance()) || this.isCurrentState(WalkTowardState.instance()) || this.isCurrentState(WalkTowardNetworkState.instance());
        IsoWindow isoWindow = Type.tryCastTo(isoObject, IsoWindow.class);
        if (isoWindow != null && isoWindow.canClimbThrough(this) && bl) {
            if (!this.isFacingObject(isoWindow, 0.8f)) {
                super.collideWith(isoObject);
                return;
            }
            if (state != PathFindState.instance() && !this.bCrawling) {
                this.climbThroughWindow(isoWindow);
            }
        } else if (isoObject instanceof IsoThumpable && ((IsoThumpable)isoObject).canClimbThrough(this) && bl) {
            if (state != PathFindState.instance() && !this.bCrawling) {
                this.climbThroughWindow((IsoThumpable)isoObject);
            }
        } else if (!(isoObject instanceof IsoDoor && ((IsoDoor)isoObject).isHoppable() || isoObject == null || isoObject.getThumpableFor(this) == null || !bl)) {
            boolean bl2;
            boolean bl3 = bl2 = (this.isCurrentState(PathFindState.instance()) || this.isCurrentState(WalkTowardState.instance()) || this.isCurrentState(WalkTowardNetworkState.instance())) && this.getPathFindBehavior2().isGoalSound();
            if (SandboxOptions.instance.Lore.ThumpNoChasing.getValue() || this.target != null || bl2) {
                if (isoObject instanceof IsoThumpable && !SandboxOptions.instance.Lore.ThumpOnConstruction.getValue()) {
                    return;
                }
                Thumpable thumpable = isoObject;
                if (isoObject instanceof IsoWindow && isoObject.getThumpableFor(this) != null && isoObject.isDestroyed()) {
                    thumpable = isoObject.getThumpableFor(this);
                }
                this.setThumpTarget(thumpable);
            } else {
                this.setVariable("bPathfind", false);
                this.setVariable("bMoving", false);
            }
            this.setPath2(null);
        }
        if (!this.bCrawling && IsoWindowFrame.isWindowFrame(isoObject) && bl && state != PathFindState.instance()) {
            this.climbThroughWindowFrame(isoObject);
        }
        super.collideWith(isoObject);
    }

    @Override
    public float Hit(HandWeapon handWeapon, IsoGameCharacter isoGameCharacter, float f, boolean bl, float f2, boolean bl2) {
        if (Core.bTutorial && this.ImmortalTutorialZombie) {
            return 0.0f;
        }
        BodyPartType bodyPartType = BodyPartType.FromIndex(Rand.Next(BodyPartType.ToIndex(BodyPartType.Torso_Upper), BodyPartType.ToIndex(BodyPartType.Torso_Lower) + 1));
        if (Rand.NextBool(7)) {
            bodyPartType = BodyPartType.Head;
        }
        if (isoGameCharacter.isCriticalHit() && Rand.NextBool(3)) {
            bodyPartType = BodyPartType.Head;
        }
        LuaEventManager.triggerEvent("OnHitZombie", this, isoGameCharacter, (Object)bodyPartType, handWeapon);
        float f3 = super.Hit(handWeapon, isoGameCharacter, f, bl, f2, bl2);
        if (GameServer.bServer && !this.isRemoteZombie()) {
            this.addAggro(isoGameCharacter, f3);
        }
        this.TimeSinceSeenFlesh = 0.0f;
        if (!this.isDead() && !this.isOnFloor() && !bl && handWeapon != null && handWeapon.getScriptItem().getCategories().contains("Blade") && isoGameCharacter instanceof IsoPlayer && this.DistToProper(isoGameCharacter) <= 0.9f && (this.isCurrentState(AttackState.instance()) || this.isCurrentState(AttackNetworkState.instance()) || this.isCurrentState(LungeState.instance()) || this.isCurrentState(LungeNetworkState.instance()))) {
            this.setHitForce(0.5f);
            this.changeState(StaggerBackState.instance());
        }
        if (GameServer.bServer || GameClient.bClient && this.isDead()) {
            this.lastPlayerHit = isoGameCharacter.getOnlineID();
        }
        return f3;
    }

    public void onMouseLeftClick() {
        if (IsoPlayer.getInstance() == null || IsoPlayer.getInstance().isAiming()) {
            return;
        }
        if (IsoPlayer.getInstance().IsAttackRange(this.getX(), this.getY(), this.getZ())) {
            Vector2 vector22 = new Vector2(this.getX(), this.getY());
            vector22.x -= IsoPlayer.getInstance().getX();
            vector22.y -= IsoPlayer.getInstance().getY();
            vector22.normalize();
            IsoPlayer.getInstance().DirectionFromVector(vector22);
            IsoPlayer.getInstance().AttemptAttack();
        }
    }

    private void renderAtlasTexture(float f, float f2, float f3) {
        if (this.atlasTex == null) {
            return;
        }
        if (IsoSprite.globalOffsetX == -1.0f) {
            IsoSprite.globalOffsetX = -IsoCamera.frameState.OffX;
            IsoSprite.globalOffsetY = -IsoCamera.frameState.OffY;
        }
        float f4 = IsoUtils.XToScreen(f, f2, f3, 0);
        float f5 = IsoUtils.YToScreen(f, f2, f3, 0);
        this.sx = f4;
        this.sy = f5;
        f4 = this.sx + IsoSprite.globalOffsetX;
        f5 = this.sy + IsoSprite.globalOffsetY;
        ColorInfo colorInfo = inf.set(1.0f, 1.0f, 1.0f, 1.0f);
        if (PerformanceSettings.LightingFrameSkip < 3 && this.getCurrentSquare() != null) {
            this.getCurrentSquare().interpolateLight(colorInfo, f - (float)this.getCurrentSquare().getX(), f2 - (float)this.getCurrentSquare().getY());
        }
        this.atlasTex.render((int)f4, (int)f5, colorInfo.r, colorInfo.g, colorInfo.b, colorInfo.a);
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        if (this.getCurrentState() == FakeDeadZombieState.instance()) {
            if (this.bDressInRandomOutfit) {
                ModelManager.instance.dressInRandomOutfit(this);
            }
            if (this.atlasTex == null) {
                this.atlasTex = DeadBodyAtlas.instance.getBodyTexture(this);
                DeadBodyAtlas.instance.render();
            }
            if (this.atlasTex != null) {
                this.renderAtlasTexture(f, f2, f3);
            }
            return;
        }
        if (this.atlasTex != null) {
            this.atlasTex = null;
        }
        if (IsoCamera.CamCharacter != IsoPlayer.getInstance()) {
            this.setAlphaAndTarget(1.0f);
        }
        super.render(f, f2, f3, colorInfo, bl, bl2, shader);
    }

    @Override
    public void renderlast() {
        super.renderlast();
        if (DebugOptions.instance.ZombieRenderCanCrawlUnderVehicle.getValue() && this.isCanCrawlUnderVehicle()) {
            this.renderTextureOverHead("media/ui/FavoriteStar.png");
        }
        if (DebugOptions.instance.ZombieRenderMemory.getValue()) {
            String string = this.target == null ? "media/ui/Moodles/Moodle_Icon_Bored.png" : (this.BonusSpotTime == 0.0f ? "media/ui/Moodles/Moodle_Icon_Angry.png" : "media/ui/Moodles/Moodle_Icon_Zombie.png");
            this.renderTextureOverHead(string);
            int n = (int)IsoUtils.XToScreenExact(this.x, this.y, this.z, 0);
            int n2 = (int)IsoUtils.YToScreenExact(this.x, this.y, this.z, 0);
            int n3 = TextManager.instance.getFontFromEnum(UIFont.Small).getLineHeight();
            TextManager.instance.DrawString(n, n2 += n3, "AllowRepathDelay : " + this.AllowRepathDelay);
            TextManager.instance.DrawString(n, n2 += n3, "BonusSpotTime : " + this.BonusSpotTime);
            TextManager.instance.DrawString(n, n2 += n3, "TimeSinceSeenFlesh : " + this.TimeSinceSeenFlesh);
        }
    }

    @Override
    protected boolean renderTextureInsteadOfModel(float f, float f2) {
        boolean bl = this.isCurrentState(WalkTowardState.instance()) || this.isCurrentState(PathFindState.instance());
        String string = "zombie";
        String string2 = bl ? "walktoward" : "idle";
        int n = 4;
        int n2 = (int)(this.m_characterTextureAnimTime / this.m_characterTextureAnimDuration * (float)n);
        float f3 = (bl ? 0.67f : 1.0f) * ((float)n2 / (float)n);
        DeadBodyAtlas.BodyTexture bodyTexture = DeadBodyAtlas.instance.getBodyTexture(this.isFemale(), string, string2, this.getDir(), n2, f3);
        if (bodyTexture != null) {
            float f4 = IsoUtils.XToScreen(f, f2, this.getZ(), 0);
            float f5 = IsoUtils.YToScreen(f, f2, this.getZ(), 0);
            int n3 = IsoCamera.frameState.playerIndex;
            bodyTexture.render(f4 -= IsoCamera.getOffX(), f5 -= IsoCamera.getOffY(), 0.0f, 0.0f, 0.0f, this.getAlpha(n3));
        }
        if (DebugOptions.instance.Character.Debug.Render.Angle.getValue()) {
            tempo.set(this.dir.ToVector());
            this.drawDirectionLine(tempo, 1.2f, 0.0f, 1.0f, 0.0f);
        }
        return true;
    }

    private void renderTextureOverHead(String string) {
        float f = this.x;
        float f2 = this.y;
        float f3 = IsoUtils.XToScreen(f, f2, this.getZ(), 0);
        float f4 = IsoUtils.YToScreen(f, f2, this.getZ(), 0);
        f3 = f3 - IsoCamera.getOffX() - this.offsetX;
        f4 = f4 - IsoCamera.getOffY() - this.offsetY;
        f4 -= (float)(128 / (2 / Core.TileScale));
        Texture texture = Texture.getSharedTexture(string);
        float f5 = Core.getInstance().getZoom(IsoCamera.frameState.playerIndex);
        f5 = Math.max(f5, 1.0f);
        int n = (int)((float)texture.getWidth() * f5);
        int n2 = (int)((float)texture.getHeight() * f5);
        texture.render((int)f3 - n / 2, (int)f4 - n2, n, n2);
    }

    @Override
    protected void updateAlpha(int n, float f, float f2) {
        if (this.isFakeDead()) {
            this.setAlphaAndTarget(1.0f);
            return;
        }
        super.updateAlpha(n, f, f2);
    }

    public void RespondToSound() {
        float f;
        float f2;
        if (this.Ghost) {
            return;
        }
        if (this.isUseless()) {
            return;
        }
        if (GameServer.bServer) {
            return;
        }
        if (GameClient.bClient && this.isRemoteZombie()) {
            return;
        }
        if ((this.getCurrentState() == PathFindState.instance() || this.getCurrentState() == WalkTowardState.instance()) && this.getPathFindBehavior2().isGoalSound() && (int)this.z == this.getPathTargetZ() && this.bSoundSourceRepeating && (f2 = this.DistToSquared(this.getPathTargetX(), this.getPathTargetY())) < 25.0f && LosUtil.lineClear(this.getCell(), (int)this.x, (int)this.y, (int)this.z, this.getPathTargetX(), this.getPathTargetY(), (int)this.z, false) != LosUtil.TestResults.Blocked) {
            this.setVariable("bPathfind", false);
            this.setVariable("bMoving", false);
            this.setPath2(null);
        }
        if (this.soundReactDelay > 0.0f) {
            this.soundReactDelay -= GameTime.getInstance().getMultiplier() / 1.6f;
            if (this.soundReactDelay < 0.0f) {
                this.soundReactDelay = 0.0f;
            }
            if (this.soundReactDelay > 0.0f) {
                return;
            }
        }
        f2 = 0.0f;
        Object object = null;
        WorldSoundManager.WorldSound worldSound = WorldSoundManager.instance.getSoundZomb(this);
        float f3 = WorldSoundManager.instance.getSoundAttract(worldSound, this);
        if (f3 <= 0.0f) {
            worldSound = null;
        }
        if (worldSound != null) {
            f2 = f3;
            object = worldSound.source;
            this.soundAttract = f2;
            this.soundAttractTimeout = 60.0f;
        } else if (this.soundAttractTimeout > 0.0f) {
            this.soundAttractTimeout -= GameTime.getInstance().getMultiplier() / 1.6f;
            if (this.soundAttractTimeout < 0.0f) {
                this.soundAttractTimeout = 0.0f;
            }
        }
        WorldSoundManager.ResultBiggestSound resultBiggestSound = WorldSoundManager.instance.getBiggestSoundZomb((int)this.getX(), (int)this.getY(), (int)this.getZ(), true, this);
        if (resultBiggestSound.sound != null && (this.soundAttractTimeout == 0.0f || this.soundAttract * 2.0f < resultBiggestSound.attract)) {
            worldSound = resultBiggestSound.sound;
            f2 = resultBiggestSound.attract;
            object = worldSound.source;
        }
        if (worldSound != null && worldSound.bRepeating && worldSound.z == (int)this.z && (f = this.DistToSquared(worldSound.x, worldSound.y)) < 25.0f && LosUtil.lineClear(this.getCell(), (int)this.x, (int)this.y, (int)this.z, worldSound.x, worldSound.y, (int)this.z, false) != LosUtil.TestResults.Blocked) {
            worldSound = null;
        }
        if (worldSound != null) {
            this.soundAttract = f2;
            this.soundSourceTarget = object;
            this.soundReactDelay = Rand.Next(0, 16);
            this.delayedSound.x = worldSound.x;
            this.delayedSound.y = worldSound.y;
            this.delayedSound.z = worldSound.z;
            this.bSoundSourceRepeating = worldSound.bRepeating;
        }
        if (this.delayedSound.x != -1 && this.soundReactDelay == 0.0f) {
            int n = this.delayedSound.x;
            int n2 = this.delayedSound.y;
            int n3 = this.delayedSound.z;
            this.delayedSound.x = -1;
            float f4 = IsoUtils.DistanceManhatten(this.getX(), this.getY(), n, n2) / 2.5f;
            n += Rand.Next((int)(-f4), (int)f4);
            n2 += Rand.Next((int)(-f4), (int)f4);
            if ((this.getCurrentState() == PathFindState.instance() || this.getCurrentState() == WalkTowardState.instance()) && (this.getPathFindBehavior2().isGoalLocation() || this.getPathFindBehavior2().isGoalSound())) {
                if (!IsoUtils.isSimilarDirection(this, n, n2, this.getPathFindBehavior2().getTargetX(), this.getPathFindBehavior2().getTargetY(), 0.5f)) {
                    this.setTurnAlertedValues(n, n2);
                    this.pathToSound(n, n2, n3);
                    this.setLastHeardSound(this.getPathTargetX(), this.getPathTargetY(), this.getPathTargetZ());
                    this.AllowRepathDelay = 120.0f;
                    this.timeSinceRespondToSound = 0.0f;
                }
                return;
            }
            if (this.timeSinceRespondToSound < 60.0f) {
                return;
            }
            if (!IsoUtils.isSimilarDirection(this, n, n2, this.x + this.getForwardDirection().x, this.y + this.getForwardDirection().y, 0.5f)) {
                this.setTurnAlertedValues(n, n2);
            }
            this.pathToSound(n, n2, n3);
            this.setLastHeardSound(this.getPathTargetX(), this.getPathTargetY(), this.getPathTargetZ());
            this.AllowRepathDelay = 120.0f;
            this.timeSinceRespondToSound = 0.0f;
        }
    }

    public void setTurnAlertedValues(int n, int n2) {
        Vector2 vector22 = new Vector2(this.getX() - ((float)n + 0.5f), this.getY() - ((float)n2 + 0.5f));
        float f = vector22.getDirectionNeg();
        f = f < 0.0f ? Math.abs(f) : new Float(Math.PI * 2 - (double)f).floatValue();
        double d = new Double(Math.toDegrees(f));
        Vector2 vector23 = new Vector2(IsoDirections.reverse((IsoDirections)this.getDir()).ToVector().x, IsoDirections.reverse((IsoDirections)this.getDir()).ToVector().y);
        vector23.normalize();
        float f2 = vector23.getDirectionNeg();
        f2 = f2 < 0.0f ? Math.abs(f2) : (float)Math.PI * 2 - f2;
        double d2 = Math.toDegrees(f2);
        if ((int)d2 == 360) {
            d2 = 0.0;
        }
        if ((int)d == 360) {
            d = 0.0;
        }
        String string = "0";
        int n3 = 0;
        if (d > d2) {
            n3 = (int)(d - d2);
            if (n3 > 350 || n3 <= 35) {
                string = "45R";
            }
            if (n3 > 35 && n3 <= 80) {
                string = "90R";
            }
            if (n3 > 80 && n3 <= 125) {
                string = "135R";
            }
            if (n3 > 125 && n3 <= 170) {
                string = "180R";
            }
            if (n3 > 170 && n3 < 215) {
                string = "180L";
            }
            if (n3 >= 215 && n3 < 260) {
                string = "135L";
            }
            if (n3 >= 260 && n3 < 305) {
                string = "90L";
            }
            if (n3 >= 305 && n3 < 350) {
                string = "45L";
            }
        } else {
            n3 = (int)(d2 - d);
            if (n3 > 10 && n3 <= 55) {
                string = "45L";
            }
            if (n3 > 55 && n3 <= 100) {
                string = "90L";
            }
            if (n3 > 100 && n3 <= 145) {
                string = "135L";
            }
            if (n3 > 145 && n3 <= 190) {
                string = "180L";
            }
            if (n3 > 190 && n3 < 235) {
                string = "180R";
            }
            if (n3 >= 235 && n3 < 280) {
                string = "135R";
            }
            if (n3 >= 280 && n3 < 325) {
                string = "90R";
            }
            if (n3 >= 325 || n3 < 10) {
                string = "45R";
            }
        }
        this.setVariable("turnalertedvalue", string);
        ZombieTurnAlerted.instance().setParams(this, vector22.set((float)n + 0.5f - this.x, (float)n2 + 0.5f - this.y).getDirection());
        this.alerted = true;
        this.networkAI.extraUpdate();
    }

    public void clearAggroList() {
        try {
            Arrays.fill(this.aggroList, null);
        }
        catch (Exception exception) {
            return;
        }
    }

    private void processAggroList() {
        try {
            for (int i = 0; i < this.aggroList.length; ++i) {
                if (this.aggroList[i] == null || !(this.aggroList[i].getAggro() <= 0.0f)) continue;
                this.aggroList[i] = null;
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public void addAggro(IsoMovingObject isoMovingObject, float f) {
        try {
            int n;
            if (this.aggroList[0] == null) {
                this.aggroList[0] = new Aggro(isoMovingObject, f);
                return;
            }
            for (n = 0; n < this.aggroList.length; ++n) {
                if (this.aggroList[n] == null || this.aggroList[n].obj != isoMovingObject) continue;
                this.aggroList[n].addDamage(f);
                return;
            }
            for (n = 0; n < this.aggroList.length; ++n) {
                if (this.aggroList[n] != null) continue;
                this.aggroList[n] = new Aggro(isoMovingObject, f);
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean isLeadAggro(IsoMovingObject isoMovingObject) {
        try {
            if (this.aggroList[0] == null) {
                return false;
            }
            this.processAggroList();
            if (this.aggroList[0] == null) {
                return false;
            }
            IsoMovingObject isoMovingObject2 = this.aggroList[0].obj;
            float f = this.aggroList[0].getAggro();
            for (int i = 1; i < this.aggroList.length; ++i) {
                if (this.aggroList[i] == null) continue;
                if (f >= 1.0f && this.aggroList[i].getAggro() >= 1.0f) {
                    return false;
                }
                if (this.aggroList[i] == null || !(f < this.aggroList[i].getAggro())) continue;
                isoMovingObject2 = this.aggroList[i].obj;
                f = this.aggroList[i].getAggro();
            }
            return isoMovingObject == isoMovingObject2 && f == 1.0f;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void spotted(IsoMovingObject isoMovingObject, boolean bl) {
        float f;
        int n;
        float f2;
        float f3;
        if (GameClient.bClient && this.isRemoteZombie()) {
            if (this.getTarget() != null) {
                this.vectorToTarget.x = this.getTarget().getX();
                this.vectorToTarget.y = this.getTarget().getY();
                this.vectorToTarget.x -= this.getX();
                this.vectorToTarget.y -= this.getY();
            }
            return;
        }
        if (this.getCurrentSquare() == null) {
            return;
        }
        if (isoMovingObject.getCurrentSquare() == null) {
            return;
        }
        if (this.getCurrentSquare().getProperties().Is(IsoFlagType.smoke) || this.isUseless()) {
            this.setTarget(null);
            this.spottedLast = null;
            return;
        }
        if (isoMovingObject instanceof IsoPlayer && ((IsoPlayer)isoMovingObject).isGhostMode()) {
            return;
        }
        IsoGameCharacter isoGameCharacter = Type.tryCastTo(isoMovingObject, IsoGameCharacter.class);
        if (isoGameCharacter == null || isoGameCharacter.isDead()) {
            return;
        }
        if (this.getCurrentSquare() == null) {
            this.ensureOnTile();
        }
        if (isoMovingObject.getCurrentSquare() == null) {
            isoMovingObject.ensureOnTile();
        }
        float f4 = 200.0f;
        int n2 = isoMovingObject instanceof IsoPlayer && !GameServer.bServer ? ((IsoPlayer)isoMovingObject).PlayerIndex : 0;
        float f5 = (isoMovingObject.getCurrentSquare().lighting[n2].lightInfo().r + isoMovingObject.getCurrentSquare().lighting[n2].lightInfo().g + isoMovingObject.getCurrentSquare().lighting[n2].lightInfo().b) / 3.0f;
        float f6 = RenderSettings.getInstance().getAmbientForPlayer(n2);
        float f7 = (this.getCurrentSquare().lighting[n2].lightInfo().r + this.getCurrentSquare().lighting[n2].lightInfo().g + this.getCurrentSquare().lighting[n2].lightInfo().b) / 3.0f;
        f7 = f7 * f7 * f7;
        if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        if (f5 < 0.0f) {
            f5 = 0.0f;
        }
        if (f7 > 1.0f) {
            f7 = 1.0f;
        }
        if (f7 < 0.0f) {
            f7 = 0.0f;
        }
        float f8 = 1.0f - (f5 - f7);
        if (f5 < 0.2f) {
            f5 = 0.2f;
        }
        if (f6 < 0.2f) {
            f6 = 0.2f;
        }
        if (isoMovingObject.getCurrentSquare().getRoom() != this.getCurrentSquare().getRoom()) {
            f4 = 50.0f;
            if (isoMovingObject.getCurrentSquare().getRoom() != null && this.getCurrentSquare().getRoom() == null || isoMovingObject.getCurrentSquare().getRoom() == null && this.getCurrentSquare().getRoom() != null) {
                f4 = 20.0f;
                if (isoGameCharacter.isAiming() || isoGameCharacter.isSneaking()) {
                    f4 = f5 < 0.4f ? 0.0f : 10.0f;
                } else if (isoMovingObject.getMovementLastFrame().getLength() <= 0.04f && f5 < 0.4f) {
                    f4 = 10.0f;
                }
            }
        }
        IsoZombie.tempo.x = isoMovingObject.getX();
        IsoZombie.tempo.y = isoMovingObject.getY();
        IsoZombie.tempo.x -= this.getX();
        IsoZombie.tempo.y -= this.getY();
        if (isoMovingObject.getCurrentSquare().getZ() != this.current.getZ()) {
            int n3 = Math.abs(isoMovingObject.getCurrentSquare().getZ() - this.current.getZ()) * 5;
            f4 /= (float)(++n3);
        }
        float f9 = GameTime.getInstance().getViewDist();
        if (tempo.getLength() > f9) {
            return;
        }
        if (GameServer.bServer) {
            this.bIndoorZombie = false;
        }
        if (tempo.getLength() < f9) {
            f9 = tempo.getLength();
        }
        if ((f9 *= 1.1f) > GameTime.getInstance().getViewDistMax()) {
            f9 = GameTime.getInstance().getViewDistMax();
        }
        tempo.normalize();
        Vector2 vector22 = this.getLookVector(tempo2);
        float f10 = vector22.dot(tempo);
        if (this.DistTo(isoMovingObject) > 20.0f) {
            f4 -= 10000.0f;
        }
        if ((double)f9 > 0.5) {
            if (f10 < -0.4f) {
                f4 = 0.0f;
            } else if (f10 < -0.2f) {
                f4 /= 8.0f;
            } else if (f10 < -0.0f) {
                f4 /= 4.0f;
            } else if (f10 < 0.2f) {
                f4 /= 2.0f;
            } else if (f10 <= 0.4f) {
                f4 *= 2.0f;
            } else if (f10 > 0.4f) {
                f4 *= 8.0f;
            } else if (f10 > 0.6f) {
                f4 *= 16.0f;
            } else if (f10 > 0.8f) {
                f4 *= 32.0f;
            }
        }
        if (f4 > 0.0f && this.target instanceof IsoPlayer) {
            IsoPlayer isoPlayer = (IsoPlayer)this.target;
            if (!GameServer.bServer && isoPlayer.RemoteID == -1 && this.current.isCanSee(isoPlayer.PlayerIndex)) {
                ((IsoPlayer)this.target).targetedByZombie = true;
                ((IsoPlayer)this.target).lastTargeted = 0.0f;
            }
        }
        f4 *= f8;
        int n4 = (int)isoMovingObject.getZ() - (int)this.getZ();
        if (n4 >= 1) {
            f4 /= (float)(n4 * 3);
        }
        float f11 = PZMath.clamp(f9 / GameTime.getInstance().getViewDist(), 0.0f, 1.0f);
        f4 *= 1.0f - f11;
        f4 *= 1.0f - f11;
        f4 *= 1.0f - f11;
        float f12 = PZMath.clamp(f9 / 10.0f, 0.0f, 1.0f);
        f4 *= 1.0f + (1.0f - f12) * 10.0f;
        float f13 = isoMovingObject.getMovementLastFrame().getLength();
        if (f13 == 0.0f && f5 <= 0.2f) {
            f5 = 0.0f;
        }
        if (isoGameCharacter == null) {
            return;
        }
        if (isoGameCharacter.getTorchStrength() > 0.0f) {
            f4 *= 3.0f;
        }
        if (f13 < 0.01f) {
            f4 *= 0.5f;
        } else if (isoGameCharacter.isSneaking()) {
            f4 *= 0.4f;
        } else if (isoGameCharacter.isAiming()) {
            f4 *= 0.75f;
        } else if (f13 < 0.06f) {
            f4 *= 0.8f;
        } else if (f13 >= 0.06f) {
            f4 *= 2.4f;
        }
        if (this.eatBodyTarget != null) {
            f4 *= 0.6f;
        }
        if (f9 < 5.0f && (!isoGameCharacter.isRunning() && !isoGameCharacter.isSneaking() && !isoGameCharacter.isAiming() || isoGameCharacter.isRunning())) {
            f4 *= 3.0f;
        }
        if (this.spottedLast == isoMovingObject && this.TimeSinceSeenFlesh < 120.0f) {
            f4 = 1000.0f;
        }
        f4 *= isoGameCharacter.getSneakSpotMod();
        f4 *= f6;
        if (this.target != isoMovingObject && this.target != null && (f3 = IsoUtils.DistanceManhatten(this.getX(), this.getY(), isoMovingObject.getX(), isoMovingObject.getY())) > (f2 = IsoUtils.DistanceManhatten(this.getX(), this.getY(), this.target.getX(), this.target.getY()))) {
            return;
        }
        f4 *= 0.3f;
        if (bl) {
            f4 = 1000000.0f;
        }
        if (this.BonusSpotTime > 0.0f) {
            f4 = 1000000.0f;
        }
        f4 *= 1.2f;
        if (this.sight == 1) {
            f4 *= 2.5f;
        }
        if (this.sight == 3) {
            f4 *= 0.45f;
        }
        if (this.inactive) {
            f4 *= 0.25f;
        }
        f4 *= 0.25f;
        if (isoMovingObject instanceof IsoPlayer && ((IsoPlayer)isoMovingObject).Traits.Inconspicuous.isSet()) {
            f4 *= 0.5f;
        }
        if (isoMovingObject instanceof IsoPlayer && ((IsoPlayer)isoMovingObject).Traits.Conspicuous.isSet()) {
            f4 *= 2.0f;
        }
        f4 *= 1.6f;
        IsoGridSquare isoGridSquare = null;
        IsoGridSquare isoGridSquare2 = null;
        if (this.getCurrentSquare() != isoMovingObject.getCurrentSquare() && isoMovingObject instanceof IsoPlayer && ((IsoPlayer)isoMovingObject).isSneaking()) {
            int n5;
            n = Math.abs(this.getCurrentSquare().getX() - isoMovingObject.getCurrentSquare().getX());
            if (n > (n5 = Math.abs(this.getCurrentSquare().getY() - isoMovingObject.getCurrentSquare().getY()))) {
                if (this.getCurrentSquare().getX() - isoMovingObject.getCurrentSquare().getX() > 0) {
                    isoGridSquare = isoMovingObject.getCurrentSquare().nav[IsoDirections.E.index()];
                } else {
                    isoGridSquare = isoMovingObject.getCurrentSquare();
                    isoGridSquare2 = isoMovingObject.getCurrentSquare().nav[IsoDirections.W.index()];
                }
            } else if (this.getCurrentSquare().getY() - isoMovingObject.getCurrentSquare().getY() > 0) {
                isoGridSquare = isoMovingObject.getCurrentSquare().nav[IsoDirections.S.index()];
            } else {
                isoGridSquare = isoMovingObject.getCurrentSquare();
                isoGridSquare2 = isoMovingObject.getCurrentSquare().nav[IsoDirections.N.index()];
            }
            if (isoGridSquare != null && isoMovingObject instanceof IsoGameCharacter) {
                f = ((IsoGameCharacter)isoMovingObject).checkIsNearWall();
                if (f == 1.0f && isoGridSquare2 != null) {
                    f = isoGridSquare2.getGridSneakModifier(true);
                }
                if (f > 1.0f) {
                    float f14 = isoMovingObject.DistTo(isoGridSquare.x, isoGridSquare.y);
                    if (f14 > 1.0f) {
                        f /= f14;
                    }
                    f4 /= f;
                }
            }
        }
        f4 = (float)Math.floor(f4);
        n = 0;
        f4 = Math.min(f4, 400.0f);
        f4 /= 400.0f;
        f4 = Math.max(0.0f, f4);
        f4 = Math.min(1.0f, f4);
        float f15 = GameTime.instance.getMultiplier();
        f4 = (float)(1.0 - Math.pow(1.0f - f4, f15));
        f4 *= 100.0f;
        if ((float)Rand.Next(10000) / 100.0f < f4) {
            n = 1;
        }
        if ((GameClient.bClient || GameServer.bServer) && !NetworkZombieManager.canSpotted(this) && isoMovingObject != this.target) {
            return;
        }
        if (n == 0) {
            if (f4 > 20.0f && isoMovingObject instanceof IsoPlayer && f9 < 15.0f) {
                ((IsoPlayer)isoMovingObject).bCouldBeSeenThisFrame = true;
            }
            if (!((IsoPlayer)isoMovingObject).isbCouldBeSeenThisFrame() && !((IsoPlayer)isoMovingObject).isbSeenThisFrame() && ((IsoPlayer)isoMovingObject).isSneaking() && ((IsoPlayer)isoMovingObject).isJustMoved() && Rand.Next((int)(1100.0f * GameTime.instance.getInvMultiplier())) == 0) {
                if (GameServer.bServer) {
                    GameServer.addXp((IsoPlayer)isoMovingObject, PerkFactory.Perks.Sneak, 1);
                } else {
                    ((IsoPlayer)isoMovingObject).getXp().AddXP(PerkFactory.Perks.Sneak, 1.0f);
                }
            }
            if (!((IsoPlayer)isoMovingObject).isbCouldBeSeenThisFrame() && !((IsoPlayer)isoMovingObject).isbSeenThisFrame() && ((IsoPlayer)isoMovingObject).isSneaking() && ((IsoPlayer)isoMovingObject).isJustMoved() && Rand.Next((int)(1100.0f * GameTime.instance.getInvMultiplier())) == 0) {
                if (GameServer.bServer) {
                    GameServer.addXp((IsoPlayer)isoMovingObject, PerkFactory.Perks.Lightfoot, 1);
                } else {
                    ((IsoPlayer)isoMovingObject).getXp().AddXP(PerkFactory.Perks.Lightfoot, 1.0f);
                }
            }
            return;
        }
        if (isoMovingObject instanceof IsoPlayer) {
            ((IsoPlayer)isoMovingObject).setbSeenThisFrame(true);
        }
        if (!bl) {
            this.BonusSpotTime = 120.0f;
        }
        this.LastTargetSeenX = (int)isoMovingObject.getX();
        this.LastTargetSeenY = (int)isoMovingObject.getY();
        this.LastTargetSeenZ = (int)isoMovingObject.getZ();
        if (this.stateMachine.getCurrent() == StaggerBackState.instance()) {
            return;
        }
        if (this.target != isoMovingObject) {
            this.targetSeenTime = 0.0f;
            if (GameServer.bServer && !this.isRemoteZombie()) {
                this.addAggro(isoMovingObject, 1.0f);
            }
        }
        this.setTarget(isoMovingObject);
        this.vectorToTarget.x = isoMovingObject.getX();
        this.vectorToTarget.y = isoMovingObject.getY();
        this.vectorToTarget.x -= this.getX();
        this.vectorToTarget.y -= this.getY();
        f = this.vectorToTarget.getLength();
        if (!bl) {
            this.TimeSinceSeenFlesh = 0.0f;
            this.targetSeenTime += GameTime.getInstance().getRealworldSecondsSinceLastUpdate();
        }
        if (this.target == this.spottedLast && this.getCurrentState() == LungeState.instance() && this.LungeTimer > 0.0f) {
            return;
        }
        if (this.target == this.spottedLast && this.getCurrentState() == AttackVehicleState.instance()) {
            return;
        }
        if ((int)this.getZ() == (int)this.target.getZ() && (f <= 3.5f || this.target instanceof IsoGameCharacter && ((IsoGameCharacter)this.target).getVehicle() != null && f <= 4.0f) && this.getStateEventDelayTimer() <= 0.0f && !PolygonalMap2.instance.lineClearCollide(this.getX(), this.getY(), isoMovingObject.x, isoMovingObject.y, (int)this.getZ(), isoMovingObject)) {
            this.setTarget(isoMovingObject);
            if (this.getCurrentState() == LungeState.instance()) {
                return;
            }
        }
        this.spottedLast = isoMovingObject;
        if (!this.Ghost && !this.getCurrentSquare().getProperties().Is(IsoFlagType.smoke)) {
            this.setTarget(isoMovingObject);
            if (this.AllowRepathDelay > 0.0f) {
                return;
            }
            if (this.target instanceof IsoGameCharacter && ((IsoGameCharacter)this.target).getVehicle() != null) {
                if ((this.getCurrentState() == PathFindState.instance() || this.getCurrentState() == WalkTowardState.instance()) && this.getPathFindBehavior2().getTargetChar() == this.target) {
                    return;
                }
                if (this.getCurrentState() == AttackVehicleState.instance()) {
                    return;
                }
                BaseVehicle baseVehicle = ((IsoGameCharacter)this.target).getVehicle();
                if (Math.abs(baseVehicle.getCurrentSpeedKmHour()) > 0.8f && this.DistToSquared(baseVehicle) <= 16.0f) {
                    return;
                }
                this.pathToCharacter((IsoGameCharacter)this.target);
                this.AllowRepathDelay = 10.0f;
                return;
            }
            this.pathToCharacter(isoGameCharacter);
            if (Rand.Next(5) == 0) {
                this.spotSoundDelay = 200;
            }
            this.AllowRepathDelay = 480.0f;
        }
    }

    @Override
    public void Move(Vector2 vector22) {
        if (GameClient.bClient && this.authOwner == null) {
            return;
        }
        this.nx += vector22.x * GameTime.instance.getMultiplier();
        this.ny += vector22.y * GameTime.instance.getMultiplier();
        this.movex = vector22.x;
        this.movey = vector22.y;
    }

    @Override
    public void MoveUnmodded(Vector2 vector22) {
        float f;
        float f2;
        if (this.speedType == 1 && (this.isCurrentState(LungeState.instance()) || this.isCurrentState(LungeNetworkState.instance()) || this.isCurrentState(AttackState.instance()) || this.isCurrentState(AttackNetworkState.instance()) || this.isCurrentState(StaggerBackState.instance()) || this.isCurrentState(ZombieHitReactionState.instance())) && this.target instanceof IsoGameCharacter) {
            f2 = this.target.nx - this.x;
            float f3 = this.target.ny - this.y;
            f = (float)Math.sqrt(f2 * f2 + f3 * f3);
            f -= this.getWidth() + this.target.getWidth() - 0.1f;
            f = Math.max(0.0f, f);
            if (vector22.getLength() > f) {
                vector22.setLength(f);
            }
        }
        if (this.isRemoteZombie() && (f2 = IsoUtils.DistanceTo(this.realx, this.realy, this.networkAI.targetX, this.networkAI.targetY)) > 1.0f) {
            Vector2 vector23 = new Vector2(this.realx - this.x, this.realy - this.y);
            vector23.normalize();
            f = 0.5f + IsoUtils.smoothstep(0.5f, 1.5f, IsoUtils.DistanceTo(this.x, this.y, this.networkAI.targetX, this.networkAI.targetY) / f2);
            float f4 = vector22.getLength();
            vector22.normalize();
            PZMath.lerp(vector22, vector22, vector23, 0.5f);
            vector22.setLength(f4 * f);
        }
        super.MoveUnmodded(vector22);
    }

    public boolean canBeDeletedUnnoticed(float f) {
        if (!GameClient.bClient) {
            return false;
        }
        float f2 = Float.POSITIVE_INFINITY;
        ArrayList<IsoPlayer> arrayList = GameClient.instance.getPlayers();
        for (int i = 0; i < arrayList.size(); ++i) {
            float f3;
            IsoPlayer isoPlayer = arrayList.get(i);
            float f4 = isoPlayer.getDotWithForwardDirection(this.getX(), this.getY());
            if (f4 > -(f3 = LightingJNI.calculateVisionCone(isoPlayer) + 0.2f)) {
                return false;
            }
            float f5 = IsoUtils.DistanceToSquared(this.x, this.y, isoPlayer.x, isoPlayer.y);
            if (!(f5 < f2)) continue;
            f2 = f5;
        }
        return f2 > f * f;
    }

    @Override
    public void DoFootstepSound(String string) {
        ParameterCharacterMovementSpeed.MovementType movementType = ParameterCharacterMovementSpeed.MovementType.Walk;
        float f = 0.5f;
        switch (string) {
            case "sneak_walk": {
                f = 0.25f;
                movementType = ParameterCharacterMovementSpeed.MovementType.SneakWalk;
                break;
            }
            case "sneak_run": {
                f = 0.25f;
                movementType = ParameterCharacterMovementSpeed.MovementType.SneakRun;
                break;
            }
            case "strafe": {
                f = 0.5f;
                movementType = ParameterCharacterMovementSpeed.MovementType.Strafe;
                break;
            }
            case "walk": {
                f = 0.5f;
                movementType = ParameterCharacterMovementSpeed.MovementType.Walk;
                break;
            }
            case "run": {
                f = 0.75f;
                movementType = ParameterCharacterMovementSpeed.MovementType.Run;
                break;
            }
            case "sprint": {
                f = 1.0f;
                movementType = ParameterCharacterMovementSpeed.MovementType.Sprint;
            }
        }
        if (!GameServer.bServer && !this.getFMODParameters().parameterList.contains(this.parameterCharacterMovementSpeed)) {
            this.getFMODParameters().add(this.parameterCharacterMovementSpeed);
            this.getFMODParameters().add(this.parameterFootstepMaterial);
            this.getFMODParameters().add(this.parameterFootstepMaterial2);
            this.getFMODParameters().add(this.parameterShoeType);
        }
        this.parameterCharacterMovementSpeed.setMovementType(movementType);
        this.DoFootstepSound(f);
    }

    @Override
    public void DoFootstepSound(float f) {
        if (GameServer.bServer) {
            return;
        }
        if (f <= 0.0f) {
            return;
        }
        if (this.getCurrentSquare() == null) {
            return;
        }
        if (GameClient.bClient && this.authOwner == null) {
            if (this.def != null && this.sprite != null && this.sprite.CurrentAnim != null && (this.sprite.CurrentAnim.name.contains("Run") || this.sprite.CurrentAnim.name.contains("Walk"))) {
                boolean bl;
                int n = (int)this.def.Frame;
                if (n >= 0 && n < 5) {
                    bl = this.stepFrameLast < 0 || this.stepFrameLast > 5;
                } else {
                    boolean bl2 = bl = this.stepFrameLast < 5;
                }
                if (bl) {
                    for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                        IsoPlayer isoPlayer = IsoPlayer.players[i];
                        if (isoPlayer == null || !(isoPlayer.DistToSquared(this) < 225.0f)) continue;
                        ZombieFootstepManager.instance.addCharacter(this);
                        break;
                    }
                }
                this.stepFrameLast = n;
            } else {
                this.stepFrameLast = -1;
            }
            return;
        }
        boolean bl = SoundManager.instance.isListenerInRange(this.getX(), this.getY(), 15.0f);
        if (bl) {
            this.footstepVolume = f;
            ZombieFootstepManager.instance.addCharacter(this);
        }
    }

    @Override
    public void preupdate() {
        if (GameServer.bServer && this.thumpSent) {
            this.thumpFlag = 0;
            this.thumpSent = false;
        }
        this.FollowCount = 0;
        if (GameClient.bClient) {
            HitReactionNetworkAI hitReactionNetworkAI;
            this.networkAI.updateHitVehicle();
            if (!this.isLocal()) {
                this.networkAI.preupdate();
            } else if (this.isKnockedDown() && !this.isOnFloor() && (hitReactionNetworkAI = this.getHitReactionNetworkAI()).isSetup() && !hitReactionNetworkAI.isStarted()) {
                hitReactionNetworkAI.start();
            }
        }
        super.preupdate();
    }

    @Override
    public void postupdate() {
        s_performance.postUpdate.invokeAndMeasure(this, IsoZombie::postUpdateInternal);
    }

    private void postUpdateInternal() {
        IsoPlayer isoPlayer;
        if (this.target instanceof IsoPlayer) {
            ++((IsoPlayer)this.target).getStats().NumChasingZombies;
        }
        super.postupdate();
        if (!(this.current != null || GameClient.bClient && this.authOwner == null)) {
            this.removeFromWorld();
            this.removeFromSquare();
        }
        if (!GameServer.bServer && (isoPlayer = this.getReanimatedPlayer()) != null) {
            isoPlayer.setX(this.getX());
            isoPlayer.setY(this.getY());
            isoPlayer.setZ(this.getZ());
            isoPlayer.setDir(this.getDir());
            isoPlayer.setForwardDirection(this.getForwardDirection());
            AnimationPlayer animationPlayer = this.getAnimationPlayer();
            AnimationPlayer animationPlayer2 = isoPlayer.getAnimationPlayer();
            if (animationPlayer != null && animationPlayer.isReady() && animationPlayer2 != null && animationPlayer2.isReady()) {
                animationPlayer2.setTargetAngle(animationPlayer.getAngle());
                animationPlayer2.setAngleToTarget();
            }
            isoPlayer.setCurrent(this.getCell().getGridSquare((int)isoPlayer.x, (int)isoPlayer.y, (int)isoPlayer.z));
            isoPlayer.updateLightInfo();
            if (isoPlayer.soundListener != null) {
                isoPlayer.soundListener.setPos(isoPlayer.getX(), isoPlayer.getY(), isoPlayer.getZ());
                isoPlayer.soundListener.tick();
            }
            IsoPlayer isoPlayer2 = IsoPlayer.getInstance();
            IsoPlayer.setInstance(isoPlayer);
            isoPlayer.updateLOS();
            IsoPlayer.setInstance(isoPlayer2);
            if (GameClient.bClient && this.authOwner == null && this.networkUpdate.Check()) {
                GameClient.instance.sendPlayer(isoPlayer);
            }
            isoPlayer.dirtyRecalcGridStackTime = 2.0f;
        }
        if (this.targetSeenTime > 0.0f && !this.isTargetVisible()) {
            this.targetSeenTime = 0.0f;
        }
    }

    @Override
    public boolean isSolidForSeparate() {
        if (this.getCurrentState() == FakeDeadZombieState.instance() || this.getCurrentState() == ZombieFallDownState.instance() || this.getCurrentState() == ZombieOnGroundState.instance() || this.getCurrentState() == ZombieGetUpState.instance() || this.getCurrentState() == ZombieHitReactionState.instance() && this.speedType != 1) {
            return false;
        }
        if (this.isSitAgainstWall()) {
            return false;
        }
        return super.isSolidForSeparate();
    }

    @Override
    public boolean isPushableForSeparate() {
        if (this.getCurrentState() == ThumpState.instance() || this.getCurrentState() == AttackState.instance() || this.getCurrentState() == AttackVehicleState.instance() || this.getCurrentState() == ZombieEatBodyState.instance() || this.getCurrentState() == ZombieFaceTargetState.instance()) {
            return false;
        }
        if (this.isSitAgainstWall()) {
            return false;
        }
        return super.isPushableForSeparate();
    }

    @Override
    public boolean isPushedByForSeparate(IsoMovingObject isoMovingObject) {
        if (isoMovingObject instanceof IsoZombie && ((IsoZombie)isoMovingObject).getCurrentState() == ZombieHitReactionState.instance() && !((IsoZombie)isoMovingObject).collideWhileHit) {
            return false;
        }
        if (this.getCurrentState() == ZombieHitReactionState.instance() && !this.collideWhileHit) {
            return false;
        }
        if (GameClient.bClient && isoMovingObject instanceof IsoZombie && !NetworkZombieSimulator.getInstance().isZombieSimulated(this.getOnlineID())) {
            return false;
        }
        return super.isPushedByForSeparate(isoMovingObject);
    }

    @Override
    public void update() {
        s_performance.update.invokeAndMeasure(this, IsoZombie::updateInternal);
    }

    private void updateInternal() {
        Object object;
        BaseVehicle baseVehicle;
        if (GameClient.bClient && !this.isRemoteZombie()) {
            ZombieCountOptimiser.incrementZombie(this);
            MPStatistics.clientZombieUpdated();
        } else if (GameServer.bServer) {
            MPStatistics.serverZombieUpdated();
        }
        if (SandboxOptions.instance.Lore.ActiveOnly.getValue() > 1) {
            if (SandboxOptions.instance.Lore.ActiveOnly.getValue() == 2 && (GameTime.instance.getHour() >= 20 || GameTime.instance.getHour() <= 8) || SandboxOptions.instance.Lore.ActiveOnly.getValue() == 3 && GameTime.instance.getHour() > 8 && GameTime.instance.getHour() < 20) {
                this.makeInactive(false);
            } else {
                this.makeInactive(true);
            }
        }
        if (this.bCrawling) {
            if (this.actionContext.getGroup() != ActionGroup.getActionGroup("zombie-crawler")) {
                this.advancedAnimator.OnAnimDataChanged(false);
                this.initializeStates();
                this.actionContext.setGroup(ActionGroup.getActionGroup("zombie-crawler"));
            }
        } else if (this.actionContext.getGroup() != ActionGroup.getActionGroup("zombie")) {
            this.advancedAnimator.OnAnimDataChanged(false);
            this.initializeStates();
            this.actionContext.setGroup(ActionGroup.getActionGroup("zombie"));
        }
        if (this.getThumpTimer() > 0) {
            --this.thumpTimer;
        }
        if ((baseVehicle = this.getNearVehicle()) != null) {
            if (this.target == null && baseVehicle.hasLightbar() && baseVehicle.lightbarSirenMode.get() > 0 && (object = baseVehicle.getUseablePart(this, false)) != null && ((VehiclePart)object).getSquare().DistTo(this) < 0.7f) {
                this.setThumpTarget(baseVehicle);
            }
            if (baseVehicle.isAlarmed() && !baseVehicle.isPreviouslyEntered() && Rand.Next(10000) < 1) {
                baseVehicle.triggerAlarm();
            }
        }
        this.doDeferredMovement();
        this.updateEmitter();
        if (this.spotSoundDelay > 0) {
            --this.spotSoundDelay;
        }
        if (GameClient.bClient && this.authOwner == null) {
            if (this.lastRemoteUpdate > 800 && (this.legsSprite.CurrentAnim.name.equals("ZombieDeath") || this.legsSprite.CurrentAnim.name.equals("ZombieStaggerBack") || this.legsSprite.CurrentAnim.name.equals("ZombieGetUp"))) {
                DebugLog.log(DebugType.Zombie, "removing stale zombie 800 id=" + this.OnlineID);
                VirtualZombieManager.instance.removeZombieFromWorld(this);
                return;
            }
            if (GameClient.bFastForward) {
                VirtualZombieManager.instance.removeZombieFromWorld(this);
                return;
            }
        }
        if (GameClient.bClient && this.authOwner == null && this.lastRemoteUpdate < 2000 && this.lastRemoteUpdate + 1000 / PerformanceSettings.getLockFPS() > 2000) {
            DebugLog.log(DebugType.Zombie, "lastRemoteUpdate 2000+ id=" + this.OnlineID);
        }
        this.lastRemoteUpdate = (short)(this.lastRemoteUpdate + 1000 / PerformanceSettings.getLockFPS());
        if (GameClient.bClient && this.authOwner == null && (!this.bRemote || this.lastRemoteUpdate > 5000)) {
            DebugLog.log(DebugType.Zombie, "removing stale zombie 5000 id=" + this.OnlineID);
            DebugLog.log("Zombie: removing stale zombie 5000 id=" + this.OnlineID);
            VirtualZombieManager.instance.removeZombieFromWorld(this);
            return;
        }
        this.sprite = this.legsSprite;
        if (this.sprite == null) {
            return;
        }
        this.updateCharacterTextureAnimTime();
        if (GameServer.bServer && this.bIndoorZombie) {
            super.update();
            return;
        }
        this.BonusSpotTime = PZMath.clamp(this.BonusSpotTime - GameTime.instance.getMultiplier(), 0.0f, Float.MAX_VALUE);
        this.TimeSinceSeenFlesh = PZMath.clamp(this.TimeSinceSeenFlesh + GameTime.instance.getMultiplier(), 0.0f, Float.MAX_VALUE);
        if (this.getStateMachine().getCurrent() == ClimbThroughWindowState.instance() || this.getStateMachine().getCurrent() == ClimbOverFenceState.instance() || this.getStateMachine().getCurrent() == CrawlingZombieTurnState.instance() || this.getStateMachine().getCurrent() == ZombieHitReactionState.instance() || this.getStateMachine().getCurrent() == ZombieFallDownState.instance()) {
            super.update();
            return;
        }
        this.setCollidable(true);
        LuaEventManager.triggerEvent("OnZombieUpdate", this);
        if (Core.bLastStand && this.getStateMachine().getCurrent() != ThumpState.instance() && this.getStateMachine().getCurrent() != AttackState.instance() && this.TimeSinceSeenFlesh > 120.0f && Rand.Next(36000) == 0) {
            object = null;
            float f = 1000000.0f;
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                if (IsoPlayer.players[i] == null || !(IsoPlayer.players[i].DistTo(this) < f) || IsoPlayer.players[i].isDead()) continue;
                f = IsoPlayer.players[i].DistTo(this);
                object = IsoPlayer.players[i];
            }
            if (object != null) {
                this.AllowRepathDelay = -1.0f;
                this.pathToCharacter((IsoGameCharacter)object);
            }
            return;
        }
        if (GameServer.bServer) {
            this.vehicle4testCollision = null;
        } else if (GameClient.bClient) {
            if (this.vehicle4testCollision != null && this.vehicle4testCollision.updateHitByVehicle(this)) {
                super.update();
                this.vehicle4testCollision = null;
                return;
            }
        } else if (this.Health > 0.0f && this.vehicle4testCollision != null && this.testCollideWithVehicles(this.vehicle4testCollision)) {
            this.vehicle4testCollision = null;
            return;
        }
        this.vehicle4testCollision = null;
        if (this.BonusSpotTime > 0.0f && this.spottedLast != null && !((IsoGameCharacter)this.spottedLast).isDead()) {
            this.spotted(this.spottedLast, true);
        }
        if (GameServer.bServer && this.getStateMachine().getCurrent() == BurntToDeath.instance()) {
            DebugLog.log(DebugType.Zombie, "Zombie is burning " + this.OnlineID);
        }
        super.update();
        if (VirtualZombieManager.instance.isReused(this)) {
            DebugLog.log(DebugType.Zombie, "Zombie added to ReusableZombies after super.update - RETURNING " + this);
            return;
        }
        if (this.getStateMachine().getCurrent() == ClimbThroughWindowState.instance() || this.getStateMachine().getCurrent() == ClimbOverFenceState.instance() || this.getStateMachine().getCurrent() == CrawlingZombieTurnState.instance()) {
            return;
        }
        this.ensureOnTile();
        object = this.stateMachine.getCurrent();
        if (object == StaggerBackState.instance() || object == BurntToDeath.instance() || object == FakeDeadZombieState.instance() || object == ZombieFallDownState.instance() || object == ZombieOnGroundState.instance() || object == ZombieHitReactionState.instance() || object == ZombieGetUpState.instance()) {
            return;
        }
        if (GameServer.bServer && this.OnlineID == -1) {
            this.OnlineID = ServerMap.instance.getUniqueZombieId();
        } else if (object == PathFindState.instance() && this.finder.progress == AStarPathFinder.PathFindProgress.notyetfound) {
            if (this.bCrawling) {
                this.PlayAnim("ZombieCrawl");
                this.def.AnimFrameIncrease = 0.0f;
            } else {
                this.PlayAnim("ZombieIdle");
                this.def.AnimFrameIncrease = 0.08f + (float)Rand.Next(1000) / 8000.0f;
                this.def.AnimFrameIncrease *= 0.5f;
            }
        } else if (object != AttackState.instance() && object != AttackVehicleState.instance() && (this.nx != this.x || this.ny != this.y)) {
            if (this.walkVariantUse == null || object != LungeState.instance() && object != LungeNetworkState.instance()) {
                this.walkVariantUse = this.walkVariant;
            }
            if (this.bCrawling) {
                this.walkVariantUse = "ZombieCrawl";
            }
            if (object != ZombieIdleState.instance() && object != StaggerBackState.instance() && object != ThumpState.instance() && object != FakeDeadZombieState.instance()) {
                if (this.bRunning) {
                    this.PlayAnim("Run");
                    this.def.setFrameSpeedPerFrame(0.33f);
                } else {
                    this.PlayAnim(this.walkVariantUse);
                    this.def.setFrameSpeedPerFrame(0.26f);
                    this.def.AnimFrameIncrease *= this.speedMod;
                }
                this.setShootable(true);
            }
        }
        this.shootable = true;
        this.solid = true;
        this.tryThump(null);
        this.damageSheetRope();
        this.AllowRepathDelay = PZMath.clamp(this.AllowRepathDelay - GameTime.instance.getMultiplier(), 0.0f, Float.MAX_VALUE);
        if (this.TimeSinceSeenFlesh > (float)this.memory && this.target != null) {
            this.setTarget(null);
        }
        if (this.target instanceof IsoGameCharacter && ((IsoGameCharacter)this.target).ReanimatedCorpse != null) {
            this.setTarget(null);
        }
        if (this.target != null) {
            this.vectorToTarget.x = this.target.getX();
            this.vectorToTarget.y = this.target.getY();
            this.vectorToTarget.x -= this.getX();
            this.vectorToTarget.y -= this.getY();
            this.updateZombieTripping();
        }
        if (this.getCurrentState() != PathFindState.instance() && this.getCurrentState() != WalkTowardState.instance() && this.getCurrentState() != ClimbThroughWindowState.instance()) {
            this.setLastHeardSound(-1, -1, -1);
        }
        if (this.TimeSinceSeenFlesh > 240.0f && this.timeSinceRespondToSound > 5.0f) {
            this.RespondToSound();
        }
        this.timeSinceRespondToSound += GameTime.getInstance().getMultiplier() / 1.6f;
        this.separate();
        this.updateSearchForCorpse();
        if (this.TimeSinceSeenFlesh > 2000.0f && this.timeSinceRespondToSound > 2000.0f) {
            ZombieGroupManager.instance.update(this);
        }
    }

    @Override
    protected void calculateStats() {
    }

    private void updateZombieTripping() {
        if (this.speedType == 1 && StringUtils.isNullOrEmpty(this.getBumpType()) && this.target != null && Rand.NextBool(Rand.AdjustForFramerate(750))) {
            this.setBumpType("trippingFromSprint");
        }
    }

    public void updateVocalProperties() {
        if (GameServer.bServer) {
            return;
        }
        boolean bl = SoundManager.instance.isListenerInRange(this.getX(), this.getY(), 20.0f);
        if (this.vocalEvent != 0L && !this.getEmitter().isPlaying(this.vocalEvent)) {
            this.vocalEvent = 0L;
        }
        if (!this.isDead() && !this.isFakeDead() && bl) {
            ZombieVocalsManager.instance.addCharacter(this);
        }
        if (this.vocalEvent != 0L && !this.isDead() && this.isFakeDead() && this.getEmitter().isPlaying(this.vocalEvent)) {
            this.getEmitter().stopSoundLocal(this.vocalEvent);
            this.vocalEvent = 0L;
        }
    }

    public void setVehicleHitLocation(BaseVehicle baseVehicle) {
        if (!this.getFMODParameters().parameterList.contains(this.parameterVehicleHitLocation)) {
            this.getFMODParameters().add(this.parameterVehicleHitLocation);
        }
        ParameterVehicleHitLocation.HitLocation hitLocation = ParameterVehicleHitLocation.calculateLocation(baseVehicle, this.getX(), this.getY(), this.getZ());
        this.parameterVehicleHitLocation.setLocation(hitLocation);
    }

    private void updateSearchForCorpse() {
        if (this.bCrawling || this.target != null || this.eatBodyTarget != null) {
            this.checkForCorpseTimer = 10000.0f;
            this.bodyToEat = null;
            return;
        }
        if (this.bodyToEat != null) {
            if (this.bodyToEat.getStaticMovingObjectIndex() == -1) {
                this.bodyToEat = null;
            } else if (!this.isEatingOther(this.bodyToEat) && this.bodyToEat.getEatingZombies().size() >= 3) {
                this.bodyToEat = null;
            }
        }
        if (this.bodyToEat == null) {
            this.checkForCorpseTimer -= GameTime.getInstance().getMultiplier() / 1.6f;
            if (this.checkForCorpseTimer <= 0.0f) {
                this.checkForCorpseTimer = 10000.0f;
                tempBodies.clear();
                for (int i = -10; i < 10; ++i) {
                    for (int j = -10; j < 10; ++j) {
                        IsoDeadBody isoDeadBody;
                        IsoGridSquare isoGridSquare = this.getCell().getGridSquare(this.getX() + (float)i, this.getY() + (float)j, this.getZ());
                        if (isoGridSquare == null || (isoDeadBody = isoGridSquare.getDeadBody()) == null || isoDeadBody.isSkeleton() || isoDeadBody.isZombie() || isoDeadBody.getEatingZombies().size() >= 3 || PolygonalMap2.instance.lineClearCollide(this.getX(), this.getY(), isoDeadBody.x, isoDeadBody.y, (int)this.getZ(), null, false, true)) continue;
                        tempBodies.add(isoDeadBody);
                    }
                }
                if (!tempBodies.isEmpty()) {
                    this.bodyToEat = PZArrayUtil.pickRandom(tempBodies);
                    tempBodies.clear();
                }
            }
        }
        if (this.bodyToEat == null || !this.isCurrentState(ZombieIdleState.instance())) {
            return;
        }
        if (this.DistToSquared(this.bodyToEat) > 1.0f) {
            Vector2 vector22 = tempo.set(this.x - this.bodyToEat.x, this.y - this.bodyToEat.y);
            vector22.setLength(0.5f);
            this.pathToLocationF(this.bodyToEat.getX() + vector22.x, this.bodyToEat.getY() + vector22.y, this.bodyToEat.getZ());
        }
    }

    private void damageSheetRope() {
        IsoObject isoObject;
        if (Rand.Next(30) == 0 && this.current != null && (this.current.Is(IsoFlagType.climbSheetN) || this.current.Is(IsoFlagType.climbSheetE) || this.current.Is(IsoFlagType.climbSheetS) || this.current.Is(IsoFlagType.climbSheetW)) && (isoObject = this.current.getSheetRope()) != null) {
            isoObject.sheetRopeHealth -= (float)Rand.Next(5, 15);
            if (isoObject.sheetRopeHealth < 40.0f) {
                this.current.damageSpriteSheetRopeFromBottom(null, this.current.Is(IsoFlagType.climbSheetN) || this.current.Is(IsoFlagType.climbSheetS));
                this.current.RecalcProperties();
            }
            if (isoObject.sheetRopeHealth <= 0.0f) {
                this.current.removeSheetRopeFromBottom(null, this.current.Is(IsoFlagType.climbSheetN) || this.current.Is(IsoFlagType.climbSheetS));
            }
        }
    }

    public void getZombieWalkTowardSpeed(float f, float f2, Vector2 vector22) {
        float f3 = 1.0f;
        f3 = f2 / 24.0f;
        if (f3 < 1.0f) {
            f3 = 1.0f;
        }
        if (f3 > 1.3f) {
            f3 = 1.3f;
        }
        vector22.setLength((f * this.getSpeedMod() + 0.006f) * f3);
        if (SandboxOptions.instance.Lore.Speed.getValue() == 1 && !this.inactive || this.speedType == 1) {
            vector22.setLength(0.08f);
            this.bRunning = true;
        }
        if (vector22.getLength() > f2) {
            vector22.setLength(f2);
        }
    }

    public void getZombieLungeSpeed() {
        this.bRunning = SandboxOptions.instance.Lore.Speed.getValue() == 1 && !this.inactive || this.speedType == 1;
    }

    public boolean tryThump(IsoGridSquare isoGridSquare) {
        boolean bl;
        if (this.Ghost) {
            return false;
        }
        if (this.bCrawling) {
            return false;
        }
        boolean bl2 = bl = this.isCurrentState(PathFindState.instance()) || this.isCurrentState(LungeState.instance()) || this.isCurrentState(LungeNetworkState.instance()) || this.isCurrentState(WalkTowardState.instance()) || this.isCurrentState(WalkTowardNetworkState.instance());
        if (!bl) {
            return false;
        }
        IsoGridSquare isoGridSquare2 = isoGridSquare != null ? isoGridSquare : this.getFeelerTile(this.getFeelersize());
        if (isoGridSquare2 == null || this.current == null) {
            return false;
        }
        IsoObject isoObject = this.current.testCollideSpecialObjects(isoGridSquare2);
        IsoDoor isoDoor = Type.tryCastTo(isoObject, IsoDoor.class);
        IsoThumpable isoThumpable = Type.tryCastTo(isoObject, IsoThumpable.class);
        IsoWindow isoWindow = Type.tryCastTo(isoObject, IsoWindow.class);
        if (isoWindow != null && isoWindow.canClimbThrough(this)) {
            if (!this.isFacingObject(isoWindow, 0.8f)) {
                return false;
            }
            this.climbThroughWindow(isoWindow);
            return true;
        }
        if (isoThumpable != null && isoThumpable.canClimbThrough(this)) {
            this.climbThroughWindow(isoThumpable);
            return true;
        }
        if (isoThumpable != null && isoThumpable.getThumpableFor(this) != null || isoWindow != null && isoWindow.getThumpableFor(this) != null || isoDoor != null && isoDoor.getThumpableFor(this) != null) {
            int n = isoGridSquare2.getX() - this.current.getX();
            int n2 = isoGridSquare2.getY() - this.current.getY();
            IsoDirections isoDirections = IsoDirections.N;
            if (n < 0 && Math.abs(n) > Math.abs(n2)) {
                isoDirections = IsoDirections.S;
            }
            if (n < 0 && Math.abs(n) <= Math.abs(n2)) {
                isoDirections = IsoDirections.SW;
            }
            if (n > 0 && Math.abs(n) > Math.abs(n2)) {
                isoDirections = IsoDirections.W;
            }
            if (n > 0 && Math.abs(n) <= Math.abs(n2)) {
                isoDirections = IsoDirections.SE;
            }
            if (n2 < 0 && Math.abs(n) < Math.abs(n2)) {
                isoDirections = IsoDirections.N;
            }
            if (n2 < 0 && Math.abs(n) >= Math.abs(n2)) {
                isoDirections = IsoDirections.NW;
            }
            if (n2 > 0 && Math.abs(n) < Math.abs(n2)) {
                isoDirections = IsoDirections.E;
            }
            if (n2 > 0 && Math.abs(n) >= Math.abs(n2)) {
                isoDirections = IsoDirections.NE;
            }
            if (this.getDir() == isoDirections) {
                boolean bl3;
                boolean bl4 = bl3 = this.getPathFindBehavior2().isGoalSound() && (this.isCurrentState(PathFindState.instance()) || this.isCurrentState(WalkTowardState.instance()) || this.isCurrentState(WalkTowardNetworkState.instance()));
                if (SandboxOptions.instance.Lore.ThumpNoChasing.getValue() || this.target != null || bl3) {
                    if (isoWindow != null && isoWindow.getThumpableFor(this) != null) {
                        isoObject = (IsoObject)isoWindow.getThumpableFor(this);
                    }
                    this.setThumpTarget(isoObject);
                    this.setPath2(null);
                }
            }
            return true;
        }
        if (isoObject != null && IsoWindowFrame.isWindowFrame(isoObject)) {
            this.climbThroughWindowFrame(isoObject);
            return true;
        }
        return false;
    }

    public void Wander() {
        this.changeState(ZombieIdleState.instance());
    }

    public void DoZombieInventory() {
        this.DoZombieInventory(false);
    }

    public void DoCorpseInventory() {
        this.DoZombieInventory(true);
    }

    private void DoZombieInventory(boolean bl) {
        InventoryItem inventoryItem;
        Object object;
        if (this.isReanimatedPlayer() || this.wasFakeDead()) {
            return;
        }
        if (GameServer.bServer && !bl) {
            return;
        }
        this.getInventory().removeAllItems();
        this.getInventory().setSourceGrid(this.getCurrentSquare());
        this.wornItems.setFromItemVisuals(this.itemVisuals);
        this.wornItems.addItemsToItemContainer(this.getInventory());
        for (int i = 0; i < this.attachedItems.size(); ++i) {
            object = this.attachedItems.get(i);
            inventoryItem = ((AttachedItem)object).getItem();
            if (this.getInventory().contains(inventoryItem)) continue;
            inventoryItem.setContainer(this.getInventory());
            this.getInventory().getItems().add(inventoryItem);
        }
        IsoBuilding isoBuilding = this.getCurrentBuilding();
        if (isoBuilding != null && isoBuilding.getDef() != null && isoBuilding.getDef().getKeyId() != -1 && Rand.Next(4) == 0) {
            if (Rand.Next(10) != 1) {
                object = "Base.Key" + (Rand.Next(5) + 1);
                inventoryItem = this.inventory.AddItem((String)object);
                inventoryItem.setKeyId(isoBuilding.getDef().getKeyId());
            } else {
                object = this.inventory.AddItem("Base.KeyRing");
                if (object instanceof InventoryContainer) {
                    inventoryItem = (InventoryContainer)object;
                    String string = "Base.Key" + (Rand.Next(5) + 1);
                    InventoryItem inventoryItem2 = ((InventoryContainer)inventoryItem).getInventory().AddItem(string);
                    inventoryItem2.setKeyId(isoBuilding.getDef().getKeyId());
                }
            }
        }
        if (this.itemsToSpawnAtDeath != null && !this.itemsToSpawnAtDeath.isEmpty()) {
            for (int i = 0; i < this.itemsToSpawnAtDeath.size(); ++i) {
                this.inventory.AddItem(this.itemsToSpawnAtDeath.get(i));
            }
            this.itemsToSpawnAtDeath.clear();
        }
        DebugLog.Death.trace("id=%d, inventory=%d", this.getOnlineID(), this.getInventory().getItems().size());
    }

    public void DoZombieStats() {
        if (SandboxOptions.instance.Lore.Cognition.getValue() == 1) {
            this.cognition = 1;
        }
        if (SandboxOptions.instance.Lore.Cognition.getValue() == 4) {
            this.cognition = Rand.Next(0, 2);
        }
        if (this.strength == -1 && SandboxOptions.instance.Lore.Strength.getValue() == 1) {
            this.strength = 5;
        }
        if (this.strength == -1 && SandboxOptions.instance.Lore.Strength.getValue() == 2) {
            this.strength = 3;
        }
        if (this.strength == -1 && SandboxOptions.instance.Lore.Strength.getValue() == 3) {
            this.strength = 1;
        }
        if (this.strength == -1 && SandboxOptions.instance.Lore.Strength.getValue() == 4) {
            this.strength = Rand.Next(1, 5);
        }
        int n = SandboxOptions.instance.Lore.Memory.getValue();
        int n2 = -1;
        if (n == 5) {
            n2 = Rand.Next(4);
        }
        if (this.memory == -1 && n == 1 || n2 == 0) {
            this.memory = 1250;
        }
        if (this.memory == -1 && n == 2 || n2 == 1) {
            this.memory = 800;
        }
        if (this.memory == -1 && n == 3 || n2 == 2) {
            this.memory = 500;
        }
        if (this.memory == -1 && n == 4 || n2 == 3) {
            this.memory = 25;
        }
        this.sight = SandboxOptions.instance.Lore.Sight.getValue() == 4 ? Rand.Next(1, 4) : SandboxOptions.instance.Lore.Sight.getValue();
        this.hearing = SandboxOptions.instance.Lore.Hearing.getValue() == 4 ? Rand.Next(1, 4) : SandboxOptions.instance.Lore.Hearing.getValue();
        if (this.speedType == -1) {
            this.speedType = SandboxOptions.instance.Lore.Speed.getValue();
            if (this.speedType == 4) {
                this.speedType = Rand.Next(2);
            }
            if (this.inactive) {
                this.speedType = 3;
            }
        }
        if (this.bCrawling) {
            this.speedMod = 0.3f;
            this.speedMod += (float)Rand.Next(1500) / 10000.0f;
            this.def.AnimFrameIncrease *= 0.8f;
        } else if (SandboxOptions.instance.Lore.Speed.getValue() == 3 || this.speedType == 3 || Rand.Next(3) != 0) {
            this.speedMod = 0.55f;
            this.speedMod += (float)Rand.Next(1500) / 10000.0f;
            this.walkVariant = this.walkVariant + "1";
            this.def.setFrameSpeedPerFrame(0.24f);
            this.def.AnimFrameIncrease *= this.speedMod;
        } else if (SandboxOptions.instance.Lore.Speed.getValue() != 3 || this.speedType != 3) {
            this.bLunger = true;
            this.speedMod = 0.85f;
            this.walkVariant = this.walkVariant + "2";
            this.speedMod += (float)Rand.Next(1500) / 10000.0f;
            this.def.setFrameSpeedPerFrame(0.24f);
            this.def.AnimFrameIncrease *= this.speedMod;
        }
        this.walkType = Integer.toString(Rand.Next(5) + 1);
        if (this.speedType == 1) {
            this.setTurnDelta(1.0f);
            this.walkType = "sprint" + this.walkType;
        }
        if (this.speedType == 3) {
            this.walkType = Integer.toString(Rand.Next(3) + 1);
            this.walkType = "slow" + this.walkType;
        }
        this.initCanCrawlUnderVehicle();
    }

    public void setWalkType(String string) {
        this.walkType = string;
    }

    public void DoZombieSpeeds(float f) {
        if (this.bCrawling) {
            this.speedMod = f;
            this.def.AnimFrameIncrease *= 0.8f;
        } else if (Rand.Next(3) != 0 || SandboxOptions.instance.Lore.Speed.getValue() == 3) {
            this.speedMod = f;
            this.speedMod += (float)Rand.Next(1500) / 10000.0f;
            this.walkVariant = this.walkVariant + "1";
            this.def.setFrameSpeedPerFrame(0.24f);
            this.def.AnimFrameIncrease *= this.speedMod;
        } else if (SandboxOptions.instance.Lore.Speed.getValue() != 3) {
            this.bLunger = true;
            this.speedMod = f;
            this.walkVariant = this.walkVariant + "2";
            this.def.setFrameSpeedPerFrame(0.24f);
            this.def.AnimFrameIncrease *= this.speedMod;
        }
    }

    public boolean isFakeDead() {
        return this.bFakeDead;
    }

    public void setFakeDead(boolean bl) {
        if (bl && Rand.Next(2) == 0) {
            this.setCrawlerType(2);
        }
        this.bFakeDead = bl;
    }

    public boolean isForceFakeDead() {
        return this.bForceFakeDead;
    }

    public void setForceFakeDead(boolean bl) {
        this.bForceFakeDead = bl;
    }

    public float Hit(BaseVehicle baseVehicle, float f, boolean bl, Vector2 vector22) {
        float f2 = 0.0f;
        this.AttackedBy = baseVehicle.getDriver();
        this.setHitDir(vector22);
        this.setHitForce(f * 0.15f);
        int n = (int)(f * 6.0f);
        this.setTarget(baseVehicle.getCharacter(0));
        if (this.bStaggerBack || this.isOnFloor() || this.getCurrentState() == ZombieGetUpState.instance() || this.getCurrentState() == ZombieOnGroundState.instance()) {
            if (this.isFakeDead()) {
                this.setFakeDead(false);
            }
            this.setHitReaction("Floor");
            f2 = f / 5.0f;
            if (!GameServer.bServer && !GameClient.bClient) {
                this.Health -= f2;
                if (this.isDead()) {
                    this.Kill(baseVehicle.getDriver());
                }
            }
        } else {
            boolean bl2 = this.isStaggerBack();
            boolean bl3 = this.isKnockedDown();
            boolean bl4 = this.isBecomeCrawler();
            if (bl) {
                this.setHitFromBehind(true);
                if (Rand.Next(100) <= n) {
                    if (Rand.Next(5) == 0) {
                        bl4 = true;
                    }
                    bl2 = true;
                    bl3 = true;
                } else {
                    bl2 = true;
                }
            } else if (f < 3.0f) {
                if (Rand.Next(100) <= n) {
                    if (Rand.Next(8) == 0) {
                        bl4 = true;
                    }
                    bl2 = true;
                    bl3 = true;
                } else {
                    bl2 = true;
                }
            } else if (f < 10.0f) {
                if (Rand.Next(8) == 0) {
                    bl4 = true;
                }
                bl2 = true;
                bl3 = true;
            } else {
                f2 = this.getHealth();
                if (!GameServer.bServer && !GameClient.bClient) {
                    this.Health -= f2;
                    this.Kill(baseVehicle.getDriver());
                }
            }
            if (DebugOptions.instance.MultiplayerZombieCrawler.getValue()) {
                bl4 = true;
            }
            if (!GameServer.bServer) {
                this.setStaggerBack(bl2);
                this.setKnockedDown(bl3);
                this.setBecomeCrawler(bl4);
            }
        }
        if (!GameServer.bServer && !GameClient.bClient) {
            this.addBlood(f);
        }
        return f2;
    }

    @Override
    public void addBlood(float f) {
        int n;
        int n2;
        if ((float)Rand.Next(10) > f) {
            return;
        }
        float f2 = 0.6f;
        if (SandboxOptions.instance.BloodLevel.getValue() > 1) {
            n2 = Rand.Next(4, 10);
            if (n2 < 1) {
                n2 = 1;
            }
            if (Core.bLastStand) {
                n2 *= 3;
            }
            switch (SandboxOptions.instance.BloodLevel.getValue()) {
                case 2: {
                    n2 /= 2;
                    break;
                }
                case 4: {
                    n2 *= 2;
                    break;
                }
                case 5: {
                    n2 *= 5;
                }
            }
            for (n = 0; n < n2; ++n) {
                this.splatBlood(2, 0.3f);
            }
        }
        if (SandboxOptions.instance.BloodLevel.getValue() > 1) {
            this.splatBloodFloorBig();
        }
        if (SandboxOptions.instance.BloodLevel.getValue() > 1) {
            this.playBloodSplatterSound();
            new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f2, this.getHitDir().x * 1.5f, this.getHitDir().y * 1.5f);
            IsoZombie.tempo.x = this.getHitDir().x;
            IsoZombie.tempo.y = this.getHitDir().y;
            n2 = 3;
            n = 0;
            int n3 = 1;
            switch (SandboxOptions.instance.BloodLevel.getValue()) {
                case 1: {
                    n3 = 0;
                    break;
                }
                case 2: {
                    n3 = 1;
                    n2 = 5;
                    n = 2;
                    break;
                }
                case 4: {
                    n3 = 3;
                    n2 = 2;
                    break;
                }
                case 5: {
                    n3 = 10;
                    n2 = 0;
                }
            }
            for (int i = 0; i < n3; ++i) {
                if (Rand.Next(this.isCloseKilled() ? 8 : n2) == 0) {
                    new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f2, this.getHitDir().x * 1.5f, this.getHitDir().y * 1.5f);
                }
                if (Rand.Next(this.isCloseKilled() ? 8 : n2) == 0) {
                    new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f2, this.getHitDir().x * 1.8f, this.getHitDir().y * 1.8f);
                }
                if (Rand.Next(this.isCloseKilled() ? 8 : n2) == 0) {
                    new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f2, this.getHitDir().x * 1.9f, this.getHitDir().y * 1.9f);
                }
                if (Rand.Next(this.isCloseKilled() ? 4 : n) == 0) {
                    new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f2, this.getHitDir().x * 3.9f, this.getHitDir().y * 3.9f);
                }
                if (Rand.Next(this.isCloseKilled() ? 4 : n) == 0) {
                    new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f2, this.getHitDir().x * 3.8f, this.getHitDir().y * 3.8f);
                }
                if (Rand.Next(this.isCloseKilled() ? 9 : 6) != 0) continue;
                new IsoZombieGiblets(IsoZombieGiblets.GibletType.Eye, this.getCell(), this.getX(), this.getY(), this.getZ() + f2, this.getHitDir().x * 0.8f, this.getHitDir().y * 0.8f);
            }
        }
    }

    private void processHitDirection(HandWeapon handWeapon, IsoGameCharacter isoGameCharacter) {
        Object object = isoGameCharacter.getVariableString("ZombieHitReaction");
        if ("Shot".equals(object)) {
            int n;
            object = "ShotBelly";
            isoGameCharacter.setCriticalHit(Rand.Next(100) < ((IsoPlayer)isoGameCharacter).calculateCritChance(this));
            Vector2 vector22 = isoGameCharacter.getForwardDirection();
            Vector2 vector23 = this.getHitAngle();
            double d = vector22.x * vector23.y - vector22.y * vector23.x;
            double d2 = d >= 0.0 ? 1.0 : -1.0;
            double d3 = vector22.x * vector23.x + vector22.y * vector23.y;
            double d4 = Math.acos(d3) * d2;
            if (d4 < 0.0) {
                d4 += Math.PI * 2;
            }
            String string = "";
            if (Math.toDegrees(d4) < 45.0) {
                this.setHitFromBehind(true);
                string = "S";
                n = Rand.Next(9);
                if (n > 6) {
                    string = "L";
                }
                if (n > 4) {
                    string = "R";
                }
            }
            if (Math.toDegrees(d4) > 45.0 && Math.toDegrees(d4) < 90.0) {
                this.setHitFromBehind(true);
                string = Rand.Next(4) == 0 ? "S" : "R";
            }
            if (Math.toDegrees(d4) > 90.0 && Math.toDegrees(d4) < 135.0) {
                string = "R";
            }
            if (Math.toDegrees(d4) > 135.0 && Math.toDegrees(d4) < 180.0) {
                string = Rand.Next(4) == 0 ? "N" : "R";
            }
            if (Math.toDegrees(d4) > 180.0 && Math.toDegrees(d4) < 225.0) {
                string = "N";
                n = Rand.Next(9);
                if (n > 6) {
                    string = "L";
                }
                if (n > 4) {
                    string = "R";
                }
            }
            if (Math.toDegrees(d4) > 225.0 && Math.toDegrees(d4) < 270.0) {
                string = Rand.Next(4) == 0 ? "N" : "L";
            }
            if (Math.toDegrees(d4) > 270.0 && Math.toDegrees(d4) < 315.0) {
                this.setHitFromBehind(true);
                string = "L";
            }
            if (Math.toDegrees(d4) > 315.0) {
                string = Rand.Next(4) == 0 ? "S" : "L";
            }
            if ("N".equals(string)) {
                if (this.isHitFromBehind()) {
                    object = "ShotBellyStep";
                } else {
                    n = Rand.Next(2);
                    switch (n) {
                        case 0: {
                            object = "ShotBelly";
                            break;
                        }
                        case 1: {
                            object = "ShotBellyStep";
                        }
                    }
                }
            }
            if ("S".equals(string)) {
                object = "ShotBellyStep";
            }
            if ("L".equals(string) || "R".equals(string)) {
                if (this.isHitFromBehind()) {
                    n = Rand.Next(3);
                    switch (n) {
                        case 0: {
                            object = "ShotChest";
                            break;
                        }
                        case 1: {
                            object = "ShotLeg";
                            break;
                        }
                        case 2: {
                            object = "ShotShoulderStep";
                        }
                    }
                } else {
                    n = Rand.Next(5);
                    switch (n) {
                        case 0: {
                            object = "ShotChest";
                            break;
                        }
                        case 1: {
                            object = "ShotChestStep";
                            break;
                        }
                        case 2: {
                            object = "ShotLeg";
                            break;
                        }
                        case 3: {
                            object = "ShotShoulder";
                            break;
                        }
                        case 4: {
                            object = "ShotShoulderStep";
                        }
                    }
                }
                object = (String)object + string;
            }
            if (isoGameCharacter.isCriticalHit()) {
                if ("S".equals(string)) {
                    object = "ShotHeadFwd";
                }
                if ("N".equals(string)) {
                    object = "ShotHeadBwd";
                }
                if (("L".equals(string) || "R".equals(string)) && Rand.Next(4) == 0) {
                    object = "ShotHeadBwd";
                }
            }
            if (((String)object).contains("Head")) {
                this.addBlood(BloodBodyPartType.Head, false, true, true);
            } else if (((String)object).contains("Chest")) {
                this.addBlood(BloodBodyPartType.Torso_Upper, !this.isCriticalHit(), this.isCriticalHit(), true);
            } else if (((String)object).contains("Belly")) {
                this.addBlood(BloodBodyPartType.Torso_Lower, !this.isCriticalHit(), this.isCriticalHit(), true);
            } else if (((String)object).contains("Leg")) {
                int n2 = n = Rand.Next(2) == 0 ? 1 : 0;
                if ("L".equals(string)) {
                    this.addBlood(n != 0 ? BloodBodyPartType.LowerLeg_L : BloodBodyPartType.UpperLeg_L, !this.isCriticalHit(), this.isCriticalHit(), true);
                } else {
                    this.addBlood(n != 0 ? BloodBodyPartType.LowerLeg_R : BloodBodyPartType.UpperLeg_R, !this.isCriticalHit(), this.isCriticalHit(), true);
                }
            } else if (((String)object).contains("Shoulder")) {
                int n3 = n = Rand.Next(2) == 0 ? 1 : 0;
                if ("L".equals(string)) {
                    this.addBlood(n != 0 ? BloodBodyPartType.ForeArm_L : BloodBodyPartType.UpperArm_L, !this.isCriticalHit(), this.isCriticalHit(), true);
                } else {
                    this.addBlood(n != 0 ? BloodBodyPartType.ForeArm_R : BloodBodyPartType.UpperArm_R, !this.isCriticalHit(), this.isCriticalHit(), true);
                }
            }
        } else if (handWeapon.getCategories().contains("Blunt")) {
            this.addBlood(BloodBodyPartType.FromIndex(Rand.Next(BloodBodyPartType.UpperArm_L.index(), BloodBodyPartType.Groin.index())), false, false, true);
        } else if (!handWeapon.getCategories().contains("Unarmed")) {
            this.addBlood(BloodBodyPartType.FromIndex(Rand.Next(BloodBodyPartType.UpperArm_L.index(), BloodBodyPartType.Groin.index())), false, true, true);
        }
        if ("ShotHeadFwd".equals(object) && Rand.Next(2) == 0) {
            object = "ShotHeadFwd02";
        }
        if (this.getEatBodyTarget() != null) {
            object = this.getVariableBoolean("onknees") ? "OnKnees" : "Eating";
        }
        if ("Floor".equalsIgnoreCase((String)object) && this.isCurrentState(ZombieGetUpState.instance()) && this.isFallOnFront()) {
            object = "GettingUpFront";
        }
        if (object != null && !"".equals(object)) {
            this.setHitReaction((String)object);
        } else {
            this.setStaggerBack(true);
            this.setHitReaction("");
            if ("LEFT".equals(this.getPlayerAttackPosition()) || "RIGHT".equals(this.getPlayerAttackPosition())) {
                isoGameCharacter.setCriticalHit(false);
            }
        }
    }

    @Override
    public void hitConsequences(HandWeapon handWeapon, IsoGameCharacter isoGameCharacter, boolean bl, float f, boolean bl2) {
        if (this.isOnlyJawStab() && !this.isCloseKilled()) {
            return;
        }
        super.hitConsequences(handWeapon, isoGameCharacter, bl, f, bl2);
        if (Core.bDebug) {
            DebugLog.Combat.debugln("Zombie #" + this.OnlineID + " got hit for " + f);
        }
        this.actionContext.reportEvent("wasHit");
        if (!bl2) {
            this.processHitDirection(handWeapon, isoGameCharacter);
        }
        if (!GameClient.bClient || this.target == null || isoGameCharacter == this.target || !(IsoUtils.DistanceToSquared(this.x, this.y, this.target.x, this.target.y) < 10.0f)) {
            this.setTarget(isoGameCharacter);
        }
        if (!GameServer.bServer && !GameClient.bClient || GameClient.bClient && isoGameCharacter instanceof IsoPlayer && ((IsoPlayer)isoGameCharacter).isLocalPlayer() && !this.isRemoteZombie()) {
            this.setKnockedDown(isoGameCharacter.isCriticalHit() || this.isOnFloor() || this.isAlwaysKnockedDown());
        }
        this.checkClimbOverFenceHit();
        this.checkClimbThroughWindowHit();
        if (this.shouldBecomeCrawler(isoGameCharacter)) {
            this.setBecomeCrawler(true);
        }
    }

    @Override
    public void playHurtSound() {
    }

    private void checkClimbOverFenceHit() {
        if (this.isOnFloor()) {
            return;
        }
        if (!this.isCurrentState(ClimbOverFenceState.instance()) || !this.getVariableBoolean("ClimbFenceStarted") || this.isVariable("ClimbFenceOutcome", "fall") || this.getVariableBoolean("ClimbFenceFlopped")) {
            return;
        }
        HashMap hashMap = (HashMap)this.StateMachineParams.get(ClimbOverFenceState.instance());
        int n = 3;
        int n2 = 4;
        int n3 = (Integer)hashMap.get(n);
        int n4 = (Integer)hashMap.get(n2);
        this.climbFenceWindowHit(n3, n4);
    }

    private void checkClimbThroughWindowHit() {
        if (this.isOnFloor()) {
            return;
        }
        if (!this.isCurrentState(ClimbThroughWindowState.instance()) || !this.getVariableBoolean("ClimbWindowStarted") || this.isVariable("ClimbWindowOutcome", "fall") || this.getVariableBoolean("ClimbWindowFlopped")) {
            return;
        }
        HashMap hashMap = (HashMap)this.StateMachineParams.get(ClimbThroughWindowState.instance());
        int n = 12;
        int n2 = 13;
        int n3 = (Integer)hashMap.get(n);
        int n4 = (Integer)hashMap.get(n2);
        this.climbFenceWindowHit(n3, n4);
    }

    private void climbFenceWindowHit(int n, int n2) {
        if (this.getDir() == IsoDirections.W) {
            this.setX((float)n + 0.9f);
            this.setLx(this.getX());
        } else if (this.getDir() == IsoDirections.E) {
            this.setX((float)n + 0.1f);
            this.setLx(this.getX());
        } else if (this.getDir() == IsoDirections.N) {
            this.setY((float)n2 + 0.9f);
            this.setLy(this.getY());
        } else if (this.getDir() == IsoDirections.S) {
            this.setY((float)n2 + 0.1f);
            this.setLy(this.getY());
        }
        this.setStaggerBack(false);
        this.setKnockedDown(true);
        this.setOnFloor(true);
        this.setFallOnFront(true);
        this.setHitReaction("FenceWindow");
    }

    private boolean shouldBecomeCrawler(IsoGameCharacter isoGameCharacter) {
        if (DebugOptions.instance.MultiplayerZombieCrawler.getValue()) {
            return true;
        }
        if (this.isBecomeCrawler()) {
            return true;
        }
        if (this.isCrawling()) {
            return false;
        }
        if (Core.bLastStand) {
            return false;
        }
        if (this.isDead()) {
            return false;
        }
        if (this.isCloseKilled()) {
            return false;
        }
        IsoPlayer isoPlayer = Type.tryCastTo(isoGameCharacter, IsoPlayer.class);
        if (isoPlayer != null && !isoPlayer.isAimAtFloor() && isoPlayer.bDoShove) {
            return false;
        }
        int n = 30;
        if (isoPlayer != null && isoPlayer.isAimAtFloor() && isoPlayer.bDoShove) {
            n = this.isHitLegsWhileOnFloor() ? 7 : 15;
        }
        return Rand.NextBool(n);
    }

    @Override
    public void removeFromWorld() {
        this.getEmitter().stopOrTriggerSoundByName("BurningFlesh");
        this.clearAggroList();
        VirtualZombieManager.instance.RemoveZombie(this);
        this.setPath2(null);
        PolygonalMap2.instance.cancelRequest(this);
        if (this.getFinder().progress != AStarPathFinder.PathFindProgress.notrunning && this.getFinder().progress != AStarPathFinder.PathFindProgress.found) {
            this.getFinder().progress = AStarPathFinder.PathFindProgress.notrunning;
        }
        if (this.group != null) {
            this.group.remove(this);
            this.group = null;
        }
        if (GameServer.bServer && this.OnlineID != -1) {
            ServerMap.instance.ZombieMap.remove(this.OnlineID);
            this.OnlineID = (short)-1;
        }
        if (GameClient.bClient) {
            GameClient.instance.removeZombieFromCache(this);
        }
        this.getCell().getZombieList().remove(this);
        if (GameServer.bServer) {
            if (this.authOwner != null || this.authOwnerPlayer != null) {
                NetworkZombieManager.getInstance().moveZombie(this, null, null);
            }
            this.zombiePacketUpdated = false;
        }
        super.removeFromWorld();
    }

    public void resetForReuse() {
        this.setCrawler(false);
        this.initializeStates();
        this.actionContext.setGroup(ActionGroup.getActionGroup("zombie"));
        this.advancedAnimator.OnAnimDataChanged(false);
        this.setStateMachineLocked(false);
        this.setDefaultState();
        if (this.vocalEvent != 0L) {
            this.getEmitter().stopSoundLocal(this.vocalEvent);
            this.vocalEvent = 0L;
        }
        this.parameterZombieState.setState(ParameterZombieState.State.Idle);
        this.setSceneCulled(true);
        this.releaseAnimationPlayer();
        Arrays.fill(this.IsVisibleToPlayer, false);
        this.setCurrent(null);
        this.setLast(null);
        this.setOnFloor(false);
        this.setCanWalk(true);
        this.setFallOnFront(false);
        this.setHitTime(0);
        this.strength = -1;
        this.setImmortalTutorialZombie(false);
        this.setOnlyJawStab(false);
        this.setAlwaysKnockedDown(false);
        this.setForceEatingAnimation(false);
        this.setNoTeeth(false);
        this.cognition = -1;
        this.speedType = -1;
        this.bodyToEat = null;
        this.checkForCorpseTimer = 10000.0f;
        this.clearAttachedItems();
        this.target = null;
        this.setEatBodyTarget(null, false);
        this.setSkeleton(false);
        this.setReanimatedPlayer(false);
        this.setBecomeCrawler(false);
        this.setWasFakeDead(false);
        this.setKnifeDeath(false);
        this.setJawStabAttach(false);
        this.setReanimate(false);
        this.DoZombieStats();
        this.alerted = false;
        this.BonusSpotTime = 0.0f;
        this.TimeSinceSeenFlesh = 100000.0f;
        this.soundReactDelay = 0.0f;
        this.delayedSound.z = -1;
        this.delayedSound.y = -1;
        this.delayedSound.x = -1;
        this.bSoundSourceRepeating = false;
        this.soundSourceTarget = null;
        this.soundAttract = 0.0f;
        this.soundAttractTimeout = 0.0f;
        if (SandboxOptions.instance.Lore.Toughness.getValue() == 1) {
            this.setHealth(3.5f + Rand.Next(0.0f, 0.3f));
        }
        if (SandboxOptions.instance.Lore.Toughness.getValue() == 2) {
            this.setHealth(1.8f + Rand.Next(0.0f, 0.3f));
        }
        if (SandboxOptions.instance.Lore.Toughness.getValue() == 3) {
            this.setHealth(0.5f + Rand.Next(0.0f, 0.3f));
        }
        if (SandboxOptions.instance.Lore.Toughness.getValue() == 4) {
            this.setHealth(Rand.Next(0.5f, 3.5f) + Rand.Next(0.0f, 0.3f));
        }
        this.setCollidable(true);
        this.setShootable(true);
        if (this.isOnFire()) {
            IsoFireManager.RemoveBurningCharacter(this);
            this.setOnFire(false);
        }
        if (this.AttachedAnimSprite != null) {
            this.AttachedAnimSprite.clear();
        }
        this.OnlineID = (short)-1;
        this.bIndoorZombie = false;
        this.setVehicle4TestCollision(null);
        this.clearItemsToSpawnAtDeath();
        this.m_persistentOutfitId = 0;
        this.m_bPersistentOutfitInit = false;
        this.sharedDesc = null;
    }

    public boolean wasFakeDead() {
        return this.bWasFakeDead;
    }

    public void setWasFakeDead(boolean bl) {
        this.bWasFakeDead = bl;
    }

    public void setCrawler(boolean bl) {
        this.bCrawling = bl;
    }

    public boolean isBecomeCrawler() {
        return this.bBecomeCrawler;
    }

    public void setBecomeCrawler(boolean bl) {
        this.bBecomeCrawler = bl;
    }

    public boolean isReanimate() {
        return this.bReanimate;
    }

    public void setReanimate(boolean bl) {
        this.bReanimate = bl;
    }

    public boolean isReanimatedPlayer() {
        return this.bReanimatedPlayer;
    }

    public void setReanimatedPlayer(boolean bl) {
        this.bReanimatedPlayer = bl;
    }

    public IsoPlayer getReanimatedPlayer() {
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoPlayer.ReanimatedCorpse != this) continue;
            return isoPlayer;
        }
        return null;
    }

    public void setFemaleEtc(boolean bl) {
        this.setFemale(bl);
        if (this.getDescriptor() != null) {
            this.getDescriptor().setFemale(bl);
        }
        this.SpriteName = bl ? "KateZ" : "BobZ";
        String string = this.hurtSound = bl ? "FemaleZombieHurt" : "MaleZombieHurt";
        if (this.vocalEvent != 0L) {
            String string2;
            String string3 = string2 = bl ? "FemaleZombieCombined" : "MaleZombieCombined";
            if (this.getEmitter() != null && !this.getEmitter().isPlaying(string2)) {
                this.getEmitter().stopSoundLocal(this.vocalEvent);
                this.vocalEvent = 0L;
            }
        }
    }

    public void addRandomBloodDirtHolesEtc() {
        int n;
        this.addBlood(null, false, true, false);
        this.addDirt(null, OutfitRNG.Next(5, 10), false);
        this.addRandomVisualDamages();
        this.addRandomVisualBandages();
        int n2 = Math.max(8 - (int)IsoWorld.instance.getWorldAgeDays() / 30, 0);
        for (n = 0; n < 5; ++n) {
            if (!OutfitRNG.NextBool(n2)) continue;
            this.addBlood(null, false, true, false);
            this.addDirt(null, null, false);
        }
        for (n = 0; n < 8; ++n) {
            if (!OutfitRNG.NextBool(n2)) continue;
            BloodBodyPartType bloodBodyPartType = BloodBodyPartType.FromIndex(OutfitRNG.Next(0, BloodBodyPartType.MAX.index()));
            this.addHole(bloodBodyPartType);
            this.addBlood(bloodBodyPartType, true, false, false);
        }
    }

    public void useDescriptor(SharedDescriptors.Descriptor descriptor) {
        this.getHumanVisual().clear();
        this.itemVisuals.clear();
        this.m_persistentOutfitId = descriptor == null ? 0 : descriptor.getPersistentOutfitID();
        this.m_bPersistentOutfitInit = true;
        this.sharedDesc = descriptor;
        if (descriptor == null) {
            return;
        }
        this.setFemaleEtc(descriptor.isFemale());
        this.getHumanVisual().copyFrom(descriptor.getHumanVisual());
        this.getWornItems().setFromItemVisuals(descriptor.itemVisuals);
        this.onWornItemsChanged();
    }

    public SharedDescriptors.Descriptor getSharedDescriptor() {
        return this.sharedDesc;
    }

    public int getSharedDescriptorID() {
        return this.getPersistentOutfitID();
    }

    public int getScreenProperX(int n) {
        return (int)(IsoUtils.XToScreen(this.x, this.y, this.z, 0) - IsoCamera.cameras[n].getOffX());
    }

    public int getScreenProperY(int n) {
        return (int)(IsoUtils.YToScreen(this.x, this.y, this.z, 0) - IsoCamera.cameras[n].getOffY());
    }

    @Override
    public BaseVisual getVisual() {
        return this.humanVisual;
    }

    @Override
    public HumanVisual getHumanVisual() {
        return this.humanVisual;
    }

    @Override
    public ItemVisuals getItemVisuals() {
        this.getItemVisuals(this.itemVisuals);
        return this.itemVisuals;
    }

    @Override
    public void getItemVisuals(ItemVisuals itemVisuals) {
        if (this.isUsingWornItems()) {
            this.getWornItems().getItemVisuals(itemVisuals);
        } else if (itemVisuals != this.itemVisuals) {
            itemVisuals.clear();
            itemVisuals.addAll(this.itemVisuals);
        }
    }

    @Override
    public boolean isUsingWornItems() {
        return this.isOnKillDone() || this.isOnDeathDone() || this.isReanimatedPlayer() || this.wasFakeDead();
    }

    public void setAsSurvivor() {
        String string = "Survivalist";
        switch (Rand.Next(3)) {
            case 1: {
                string = "Survivalist02";
                break;
            }
            case 2: {
                string = "Survivalist03";
            }
        }
        this.dressInPersistentOutfit(string);
    }

    @Override
    public void dressInRandomOutfit() {
        ZombiesZoneDefinition.dressInRandomOutfit(this);
    }

    @Override
    public void dressInNamedOutfit(String string) {
        Outfit outfit;
        this.wornItems.clear();
        this.getHumanVisual().clear();
        this.itemVisuals.clear();
        Outfit outfit2 = outfit = this.isFemale() ? OutfitManager.instance.FindFemaleOutfit(string) : OutfitManager.instance.FindMaleOutfit(string);
        if (outfit == null) {
            return;
        }
        if (outfit.isEmpty()) {
            outfit.loadItems();
            this.pendingOutfitName = string;
            return;
        }
        this.getHumanVisual().dressInNamedOutfit(string, this.itemVisuals);
        this.getHumanVisual().synchWithOutfit(this.getHumanVisual().getOutfit());
        UnderwearDefinition.addRandomUnderwear(this);
        this.onWornItemsChanged();
    }

    @Override
    public void dressInPersistentOutfitID(int n) {
        this.getHumanVisual().clear();
        this.itemVisuals.clear();
        this.m_persistentOutfitId = n;
        this.m_bPersistentOutfitInit = true;
        if (n == 0) {
            return;
        }
        this.bDressInRandomOutfit = false;
        PersistentOutfits.instance.dressInOutfit(this, n);
        this.onWornItemsChanged();
    }

    @Override
    public void dressInClothingItem(String string) {
        this.wornItems.clear();
        this.getHumanVisual().dressInClothingItem(string, this.itemVisuals);
        this.onWornItemsChanged();
    }

    @Override
    public void onWornItemsChanged() {
        this.parameterShoeType.setShoeType(null);
    }

    @Override
    public void clothingItemChanged(String string) {
        super.clothingItemChanged(string);
        if (!StringUtils.isNullOrWhitespace(this.pendingOutfitName)) {
            Outfit outfit;
            Outfit outfit2 = outfit = this.isFemale() ? OutfitManager.instance.FindFemaleOutfit(this.pendingOutfitName) : OutfitManager.instance.FindMaleOutfit(this.pendingOutfitName);
            if (outfit != null && !outfit.isEmpty()) {
                this.dressInNamedOutfit(this.pendingOutfitName);
                this.pendingOutfitName = null;
                this.resetModelNextFrame();
            }
        }
    }

    public boolean WanderFromWindow() {
        if (this.getCurrentSquare() == null) {
            return false;
        }
        FloodFill floodFill = IsoZombie.floodFill;
        floodFill.calculate(this, this.getCurrentSquare());
        IsoGridSquare isoGridSquare = floodFill.choose();
        floodFill.reset();
        if (isoGridSquare != null) {
            this.pathToLocation(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ());
            return true;
        }
        return false;
    }

    public boolean isUseless() {
        return this.useless;
    }

    public void setUseless(boolean bl) {
        this.useless = bl;
    }

    public void setImmortalTutorialZombie(boolean bl) {
        this.ImmortalTutorialZombie = bl;
    }

    public boolean isTargetInCone(float f, float f2) {
        if (this.target == null) {
            return false;
        }
        tempo.set(this.target.getX() - this.getX(), this.target.getY() - this.getY());
        float f3 = tempo.getLength();
        if (f3 == 0.0f) {
            return true;
        }
        if (f3 > f) {
            return false;
        }
        tempo.normalize();
        this.getVectorFromDirection(tempo2);
        float f4 = tempo.dot(tempo2);
        return f4 >= f2;
    }

    public boolean testCollideWithVehicles(BaseVehicle baseVehicle) {
        if (this.Health <= 0.0f) {
            return false;
        }
        if (this.isProne()) {
            int n;
            if (baseVehicle.getDriver() == null) {
                return false;
            }
            int n2 = n = baseVehicle.isEngineRunning() ? baseVehicle.testCollisionWithProneCharacter(this, true) : 0;
            if (n > 0) {
                if (!this.emitter.isPlaying(this.getHurtSound())) {
                    this.playHurtSound();
                }
                this.AttackedBy = baseVehicle.getDriver();
                baseVehicle.hitCharacter(this);
                if (!GameServer.bServer && !GameClient.bClient && this.isDead()) {
                    this.Kill(baseVehicle.getDriver());
                }
                super.update();
                return true;
            }
            return false;
        }
        if (baseVehicle.shouldCollideWithCharacters()) {
            Vector2 vector22 = (Vector2)BaseVehicle.TL_vector2_pool.get().alloc();
            if (baseVehicle.testCollisionWithCharacter(this, 0.3f, vector22) != null) {
                BaseVehicle.TL_vector2_pool.get().release(vector22);
                baseVehicle.hitCharacter(this);
                super.update();
                return true;
            }
            BaseVehicle.TL_vector2_pool.get().release(vector22);
        }
        return false;
    }

    public boolean isCrawling() {
        return this.bCrawling;
    }

    public boolean isCanCrawlUnderVehicle() {
        return this.bCanCrawlUnderVehicle;
    }

    public void setCanCrawlUnderVehicle(boolean bl) {
        this.bCanCrawlUnderVehicle = bl;
    }

    public boolean isCanWalk() {
        return this.bCanWalk;
    }

    public void setCanWalk(boolean bl) {
        this.bCanWalk = bl;
    }

    public void initCanCrawlUnderVehicle() {
        int n = 100;
        switch (SandboxOptions.instance.Lore.CrawlUnderVehicle.getValue()) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 5;
                break;
            }
            case 3: {
                n = 10;
                break;
            }
            case 4: {
                n = 25;
                break;
            }
            case 5: {
                n = 50;
                break;
            }
            case 6: {
                n = 75;
                break;
            }
            case 7: {
                n = 100;
            }
        }
        this.setCanCrawlUnderVehicle(Rand.Next(100) < n);
    }

    public boolean shouldGetUpFromCrawl() {
        float f;
        float f2;
        if (this.isCurrentState(ZombieGetUpFromCrawlState.instance())) {
            return true;
        }
        if (this.isCurrentState(ZombieGetUpState.instance())) {
            return this.stateMachine.getPrevious() == ZombieGetUpFromCrawlState.instance();
        }
        if (!this.isCrawling()) {
            return false;
        }
        if (!this.isCanWalk()) {
            return false;
        }
        if (this.isCurrentState(PathFindState.instance())) {
            if (this.stateMachine.getPrevious() == ZombieGetDownState.instance() && ZombieGetDownState.instance().isNearStartXY(this)) {
                return false;
            }
            return this.getPathFindBehavior2().shouldGetUpFromCrawl();
        }
        if (this.isCurrentState(WalkTowardState.instance()) && this.DistToSquared(f2 = this.getPathFindBehavior2().getTargetX(), f = this.getPathFindBehavior2().getTargetY()) > 0.010000001f && PolygonalMap2.instance.lineClearCollide(this.x, this.y, f2, f, (int)this.z, null)) {
            return false;
        }
        if (this.isCurrentState(ZombieGetDownState.instance())) {
            return false;
        }
        return PolygonalMap2.instance.canStandAt(this.x, this.y, (int)this.z, null, false, true);
    }

    public void toggleCrawling() {
        boolean bl = this.bCanCrawlUnderVehicle;
        if (this.bCrawling) {
            this.setCrawler(false);
            this.setKnockedDown(false);
            this.setStaggerBack(false);
            this.setFallOnFront(false);
            this.setOnFloor(false);
            this.DoZombieStats();
        } else {
            this.setCrawler(true);
            this.setOnFloor(true);
            this.DoZombieStats();
            this.walkVariant = "ZombieWalk";
        }
        this.bCanCrawlUnderVehicle = bl;
    }

    public void knockDown(boolean bl) {
        this.setKnockedDown(true);
        this.setStaggerBack(true);
        this.setHitReaction("");
        this.setPlayerAttackPosition(bl ? "BEHIND" : null);
        this.setHitForce(1.0f);
        this.reportEvent("wasHit");
    }

    public void addItemToSpawnAtDeath(InventoryItem inventoryItem) {
        if (this.itemsToSpawnAtDeath == null) {
            this.itemsToSpawnAtDeath = new ArrayList();
        }
        this.itemsToSpawnAtDeath.add(inventoryItem);
    }

    public void clearItemsToSpawnAtDeath() {
        if (this.itemsToSpawnAtDeath != null) {
            this.itemsToSpawnAtDeath.clear();
        }
    }

    public IsoMovingObject getEatBodyTarget() {
        return this.eatBodyTarget;
    }

    public float getEatSpeed() {
        return this.eatSpeed;
    }

    public void setEatBodyTarget(IsoMovingObject isoMovingObject, boolean bl) {
        this.setEatBodyTarget(isoMovingObject, bl, Rand.Next(0.8f, 1.2f) * GameTime.getAnimSpeedFix());
    }

    public void setEatBodyTarget(IsoMovingObject isoMovingObject, boolean bl, float f) {
        if (isoMovingObject == this.eatBodyTarget) {
            return;
        }
        if (!bl && isoMovingObject != null && isoMovingObject.getEatingZombies().size() >= 3) {
            return;
        }
        if (this.eatBodyTarget != null) {
            this.eatBodyTarget.getEatingZombies().remove(this);
        }
        this.eatBodyTarget = isoMovingObject;
        if (isoMovingObject == null) {
            return;
        }
        this.eatBodyTarget.getEatingZombies().add(this);
        this.eatSpeed = f;
    }

    private void updateEatBodyTarget() {
        IsoPlayer isoPlayer;
        if (this.bodyToEat != null && this.isCurrentState(ZombieIdleState.instance()) && this.DistToSquared(this.bodyToEat) <= 1.0f && (int)this.getZ() == (int)this.bodyToEat.getZ()) {
            this.setEatBodyTarget(this.bodyToEat, false);
            this.bodyToEat = null;
        }
        if (this.eatBodyTarget == null) {
            return;
        }
        if (this.eatBodyTarget instanceof IsoDeadBody && this.eatBodyTarget.getStaticMovingObjectIndex() == -1) {
            this.setEatBodyTarget(null, false);
        }
        if (this.target != null && !this.target.isOnFloor() && this.target != this.eatBodyTarget) {
            this.setEatBodyTarget(null, false);
        }
        if ((isoPlayer = Type.tryCastTo(this.eatBodyTarget, IsoPlayer.class)) != null && isoPlayer.ReanimatedCorpse != null) {
            this.setEatBodyTarget(null, false);
        }
        if (isoPlayer != null && isoPlayer.isAlive() && !isoPlayer.isOnFloor() && !isoPlayer.isCurrentState(PlayerHitReactionState.instance())) {
            this.setEatBodyTarget(null, false);
        }
        if (!this.isCurrentState(ZombieEatBodyState.instance()) && this.eatBodyTarget != null && this.DistToSquared(this.eatBodyTarget) > 1.0f) {
            this.setEatBodyTarget(null, false);
        }
        if (this.eatBodyTarget != null && this.eatBodyTarget.getSquare() != null && this.current != null && this.current.isSomethingTo(this.eatBodyTarget.getSquare())) {
            this.setEatBodyTarget(null, false);
        }
    }

    private void updateCharacterTextureAnimTime() {
        boolean bl = this.isCurrentState(WalkTowardState.instance()) || this.isCurrentState(PathFindState.instance());
        this.m_characterTextureAnimDuration = bl ? 0.67f : 2.0f;
        this.m_characterTextureAnimTime += GameTime.getInstance().getTimeDelta();
        if (this.m_characterTextureAnimTime > this.m_characterTextureAnimDuration) {
            this.m_characterTextureAnimTime %= this.m_characterTextureAnimDuration;
        }
    }

    public Vector2 getHitAngle() {
        return this.hitAngle;
    }

    public void setHitAngle(Vector2 vector22) {
        if (vector22 == null) {
            return;
        }
        this.hitAngle.set(vector22);
    }

    public int getCrawlerType() {
        return this.crawlerType;
    }

    public void setCrawlerType(int n) {
        this.crawlerType = n;
    }

    public void addRandomVisualBandages() {
        if ("Tutorial".equals(Core.getInstance().getGameMode())) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            if (OutfitRNG.Next(10) != 0) continue;
            BodyPartType bodyPartType = BodyPartType.getRandom();
            String string = bodyPartType.getBandageModel() + "_Blood";
            this.addBodyVisualFromItemType(string);
        }
    }

    public void addVisualBandage(BodyPartType bodyPartType, boolean bl) {
        String string = bodyPartType.getBandageModel() + (bl ? "_Blood" : "");
        this.addBodyVisualFromItemType(string);
    }

    public void addRandomVisualDamages() {
        for (int i = 0; i < 5; ++i) {
            if (OutfitRNG.Next(5) != 0) continue;
            String string = OutfitRNG.pickRandom(ScriptManager.instance.getZedDmgMap());
            this.addBodyVisualFromItemType("Base." + string);
        }
    }

    public String getPlayerAttackPosition() {
        return this.playerAttackPosition;
    }

    public void setPlayerAttackPosition(String string) {
        this.playerAttackPosition = string;
    }

    public boolean isSitAgainstWall() {
        return this.sitAgainstWall;
    }

    public void setSitAgainstWall(boolean bl) {
        this.sitAgainstWall = bl;
        this.networkAI.extraUpdate();
    }

    @Override
    public boolean isSkeleton() {
        if (Core.bDebug && DebugOptions.instance.ModelSkeleton.getValue()) {
            this.getHumanVisual().setSkinTextureIndex(2);
            return true;
        }
        return this.isSkeleton;
    }

    @Override
    public boolean isZombie() {
        return true;
    }

    public void setSkeleton(boolean bl) {
        this.isSkeleton = bl;
        if (bl) {
            this.getHumanVisual().setHairModel("");
            this.getHumanVisual().setBeardModel("");
            ModelManager.instance.Reset(this);
        }
    }

    public int getHitTime() {
        return this.hitTime;
    }

    public void setHitTime(int n) {
        this.hitTime = n;
    }

    public int getThumpTimer() {
        return this.thumpTimer;
    }

    public void setThumpTimer(int n) {
        this.thumpTimer = n;
    }

    public IsoMovingObject getTarget() {
        return this.target;
    }

    public void setTargetSeenTime(float f) {
        this.targetSeenTime = f;
    }

    public float getTargetSeenTime() {
        return this.targetSeenTime;
    }

    public boolean isTargetVisible() {
        IsoPlayer isoPlayer = Type.tryCastTo(this.target, IsoPlayer.class);
        if (isoPlayer == null || this.getCurrentSquare() == null) {
            return false;
        }
        return GameServer.bServer ? ServerLOS.instance.isCouldSee(isoPlayer, this.getCurrentSquare()) : this.getCurrentSquare().isCouldSee(isoPlayer.getPlayerNum());
    }

    @Override
    public float getTurnDelta() {
        return this.m_turnDeltaNormal;
    }

    @Override
    public boolean isAttacking() {
        return this.isZombieAttacking();
    }

    @Override
    public boolean isZombieAttacking() {
        State state = this.getCurrentState();
        return state != null && state.isAttacking(this);
    }

    @Override
    public boolean isZombieAttacking(IsoMovingObject isoMovingObject) {
        if (GameClient.bClient && this.authOwner == null) {
            return this.legsSprite != null && this.legsSprite.CurrentAnim != null && "ZombieBite".equals(this.legsSprite.CurrentAnim.name);
        }
        return isoMovingObject == this.target && this.isCurrentState(AttackState.instance());
    }

    public int getHitHeadWhileOnFloor() {
        return this.hitHeadWhileOnFloor;
    }

    public String getRealState() {
        return this.realState.toString();
    }

    public void setHitHeadWhileOnFloor(int n) {
        this.hitHeadWhileOnFloor = n;
        this.networkAI.extraUpdate();
    }

    public boolean isHitLegsWhileOnFloor() {
        return this.hitLegsWhileOnFloor;
    }

    public void setHitLegsWhileOnFloor(boolean bl) {
        this.hitLegsWhileOnFloor = bl;
    }

    public void makeInactive(boolean bl) {
        if (bl == this.inactive) {
            return;
        }
        if (bl) {
            this.walkType = Integer.toString(Rand.Next(3) + 1);
            this.walkType = "slow" + this.walkType;
            this.bRunning = false;
            this.inactive = true;
            this.speedType = 3;
        } else {
            this.speedType = -1;
            this.inactive = false;
            this.DoZombieStats();
        }
    }

    public float getFootstepVolume() {
        return this.footstepVolume;
    }

    public boolean isFacingTarget() {
        if (this.target == null) {
            return false;
        }
        if (GameClient.bClient && !this.isLocal() && this.isBumped()) {
            return false;
        }
        tempo.set(this.target.x - this.x, this.target.y - this.y).normalize();
        if (tempo.getLength() == 0.0f) {
            return true;
        }
        this.getLookVector(tempo2);
        float f = Vector2.dot(IsoZombie.tempo.x, IsoZombie.tempo.y, IsoZombie.tempo2.x, IsoZombie.tempo2.y);
        return (double)f >= 0.8;
    }

    public boolean isTargetLocationKnown() {
        if (this.target == null) {
            return false;
        }
        if (this.BonusSpotTime > 0.0f) {
            return true;
        }
        return this.TimeSinceSeenFlesh < 1.0f;
    }

    protected int getSandboxMemoryDuration() {
        int n = SandboxOptions.instance.Lore.Memory.getValue();
        int n2 = 160;
        if (this.inactive) {
            n2 = 5;
        } else if (n == 1) {
            n2 = 250;
        } else if (n == 3) {
            n2 = 100;
        } else if (n == 4) {
            n2 = 5;
        }
        return n2 *= 5;
    }

    public boolean shouldDoFenceLunge() {
        if (!SandboxOptions.instance.Lore.ZombiesFenceLunge.getValue()) {
            return false;
        }
        if (Rand.NextBool(3)) {
            return false;
        }
        IsoGameCharacter isoGameCharacter = Type.tryCastTo(this.target, IsoGameCharacter.class);
        if (isoGameCharacter == null || (int)isoGameCharacter.getZ() != (int)this.getZ()) {
            return false;
        }
        if (isoGameCharacter.getVehicle() != null) {
            return false;
        }
        return (double)this.DistTo(isoGameCharacter) < 3.9;
    }

    @Override
    public boolean isProne() {
        if (!this.isOnFloor()) {
            return false;
        }
        if (this.bCrawling) {
            return true;
        }
        return this.isCurrentState(ZombieOnGroundState.instance()) || this.isCurrentState(FakeDeadZombieState.instance());
    }

    public void setTarget(IsoMovingObject isoMovingObject) {
        if (this.target == isoMovingObject) {
            return;
        }
        this.target = isoMovingObject;
        this.networkAI.extraUpdate();
    }

    public boolean isAlwaysKnockedDown() {
        return this.alwaysKnockedDown;
    }

    public void setAlwaysKnockedDown(boolean bl) {
        this.alwaysKnockedDown = bl;
    }

    public void setDressInRandomOutfit(boolean bl) {
        this.bDressInRandomOutfit = bl;
    }

    public void setBodyToEat(IsoDeadBody isoDeadBody) {
        this.bodyToEat = isoDeadBody;
    }

    public boolean isForceEatingAnimation() {
        return this.forceEatingAnimation;
    }

    public void setForceEatingAnimation(boolean bl) {
        this.forceEatingAnimation = bl;
    }

    public boolean isOnlyJawStab() {
        return this.onlyJawStab;
    }

    public void setOnlyJawStab(boolean bl) {
        this.onlyJawStab = bl;
    }

    public boolean isNoTeeth() {
        return this.noTeeth;
    }

    public void setNoTeeth(boolean bl) {
        this.noTeeth = bl;
    }

    public void setThumpFlag(int n) {
        if (this.thumpFlag == n) {
            return;
        }
        this.thumpFlag = n;
        this.networkAI.extraUpdate();
    }

    public void setThumpCondition(float f) {
        this.thumpCondition = PZMath.clamp_01(f);
    }

    public void setThumpCondition(int n, int n2) {
        if (n2 <= 0) {
            this.thumpCondition = 0.0f;
            return;
        }
        n = PZMath.clamp(n, 0, n2);
        this.thumpCondition = (float)n / (float)n2;
    }

    @Override
    public float getThumpCondition() {
        return this.thumpCondition;
    }

    public boolean isStaggerBack() {
        return this.bStaggerBack;
    }

    public void setStaggerBack(boolean bl) {
        this.bStaggerBack = bl;
    }

    public boolean isKnifeDeath() {
        return this.bKnifeDeath;
    }

    public void setKnifeDeath(boolean bl) {
        this.bKnifeDeath = bl;
    }

    public boolean isJawStabAttach() {
        return this.bJawStabAttach;
    }

    public void setJawStabAttach(boolean bl) {
        this.bJawStabAttach = bl;
    }

    @Override
    public void writeInventory(ByteBuffer byteBuffer) {
        String string = this.isFemale() ? "inventoryfemale" : "inventorymale";
        GameWindow.WriteString(byteBuffer, string);
        if (this.getInventory() != null) {
            byteBuffer.put((byte)1);
            try {
                Object object;
                int n;
                int n2 = -1;
                for (InventoryItem inventoryItem : this.getInventory().getItems()) {
                    if (!PersistentOutfits.instance.isHatFallen(this.getPersistentOutfitID()) || inventoryItem.getScriptItem() == null || inventoryItem.getScriptItem().getChanceToFall() <= 0) continue;
                    n2 = inventoryItem.id;
                }
                if (n2 != -1) {
                    this.getInventory().removeItemWithID(n2);
                }
                ArrayList<InventoryItem> arrayList = this.getInventory().save(byteBuffer);
                WornItems wornItems = this.getWornItems();
                if (wornItems == null) {
                    var5_7 = 0;
                    byteBuffer.put((byte)var5_7);
                } else {
                    var5_7 = wornItems.size();
                    if (var5_7 > 127) {
                        DebugLog.Multiplayer.warn("Too many worn items");
                        var5_7 = 127;
                    }
                    byteBuffer.put((byte)var5_7);
                    for (n = 0; n < var5_7; ++n) {
                        object = wornItems.get(n);
                        if (PersistentOutfits.instance.isHatFallen(this.getPersistentOutfitID()) && ((WornItem)object).getItem().getScriptItem() != null && ((WornItem)object).getItem().getScriptItem().getChanceToFall() > 0) {
                            GameWindow.WriteStringUTF(byteBuffer, "");
                            byteBuffer.putShort((short)-1);
                            continue;
                        }
                        GameWindow.WriteStringUTF(byteBuffer, ((WornItem)object).getLocation());
                        byteBuffer.putShort((short)arrayList.indexOf(((WornItem)object).getItem()));
                    }
                }
                object = this.getAttachedItems();
                if (object == null) {
                    n = 0;
                    byteBuffer.put((byte)n);
                }
                n = ((AttachedItems)object).size();
                if (n > 127) {
                    DebugLog.Multiplayer.warn("Too many attached items");
                    n = 127;
                }
                byteBuffer.put((byte)n);
                for (int i = 0; i < n; ++i) {
                    AttachedItem attachedItem = ((AttachedItems)object).get(i);
                    GameWindow.WriteStringUTF(byteBuffer, attachedItem.getLocation());
                    byteBuffer.putShort((short)arrayList.indexOf(attachedItem.getItem()));
                }
            }
            catch (IOException iOException) {
                DebugLog.Multiplayer.printException(iOException, "WriteInventory error for zombie " + this.getOnlineID(), LogSeverity.Error);
            }
        } else {
            byteBuffer.put((byte)0);
        }
    }

    public void Kill(IsoGameCharacter isoGameCharacter, boolean bl) {
        if (this.isOnKillDone()) {
            return;
        }
        super.Kill(isoGameCharacter);
        if (this.shouldDoInventory()) {
            this.DoZombieInventory();
        }
        LuaEventManager.triggerEvent("OnZombieDead", this);
        if (isoGameCharacter == null) {
            this.DoDeath(null, null, bl);
        } else if (isoGameCharacter.getPrimaryHandItem() instanceof HandWeapon) {
            this.DoDeath((HandWeapon)isoGameCharacter.getPrimaryHandItem(), isoGameCharacter, bl);
        } else {
            this.DoDeath(this.getUseHandWeapon(), isoGameCharacter, bl);
        }
    }

    @Override
    public void Kill(IsoGameCharacter isoGameCharacter) {
        this.Kill(isoGameCharacter, true);
    }

    @Override
    public boolean shouldDoInventory() {
        return !GameClient.bClient || this.getAttackedBy() instanceof IsoPlayer && ((IsoPlayer)this.getAttackedBy()).isLocalPlayer() || this.getAttackedBy() == IsoWorld.instance.CurrentCell.getFakeZombieForHit() && (this.wasLocal() || this.isLocal());
    }

    @Override
    public void becomeCorpse() {
        if (this.isOnDeathDone()) {
            return;
        }
        if (!this.shouldBecomeCorpse()) {
            return;
        }
        super.becomeCorpse();
        if (GameClient.bClient && this.shouldDoInventory()) {
            GameClient.sendZombieDeath(this);
        }
        if (!GameClient.bClient) {
            IsoDeadBody isoDeadBody = new IsoDeadBody(this);
            if (this.isFakeDead()) {
                isoDeadBody.setCrawling(true);
            }
            if (GameServer.bServer) {
                GameServer.sendBecomeCorpse(isoDeadBody);
            }
        }
    }

    @Override
    public HitReactionNetworkAI getHitReactionNetworkAI() {
        return this.networkAI.hitReaction;
    }

    @Override
    public NetworkCharacterAI getNetworkCharacterAI() {
        return this.networkAI;
    }

    public boolean wasLocal() {
        return this.getNetworkCharacterAI() == null || this.getNetworkCharacterAI().wasLocal();
    }

    @Override
    public boolean isLocal() {
        return super.isLocal() || !this.isRemoteZombie();
    }

    @Override
    public boolean isVehicleCollisionActive(BaseVehicle baseVehicle) {
        if (!super.isVehicleCollisionActive(baseVehicle)) {
            return false;
        }
        return !this.isCurrentState(ZombieFallDownState.instance()) && !this.isCurrentState(ZombieFallingState.instance());
    }

    public void applyDamageFromVehicle(float f, float f2) {
        this.addBlood(f);
        this.Health -= f2;
        if (this.Health < 0.0f) {
            this.Health = 0.0f;
        }
    }

    @Override
    public float Hit(BaseVehicle baseVehicle, float f, boolean bl, float f2, float f3) {
        float f4 = this.Hit(baseVehicle, f, bl, this.getHitDir().set(f2, f3));
        this.applyDamageFromVehicle(f, f4);
        super.Hit(baseVehicle, f, bl, f2, f3);
        return f4;
    }

    @Override
    public Float calcHitDir(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon, Vector2 vector22) {
        Float f = super.calcHitDir(isoGameCharacter, handWeapon, vector22);
        if (this.getAnimationPlayer() != null) {
            f = Float.valueOf(this.getAnimAngleRadians());
        }
        return f;
    }

    private static class Aggro {
        IsoMovingObject obj;
        float damage;
        long lastDamage;

        public Aggro(IsoMovingObject isoMovingObject, float f) {
            this.obj = isoMovingObject;
            this.damage = f;
            this.lastDamage = System.currentTimeMillis();
        }

        public void addDamage(float f) {
            this.damage += f;
            this.lastDamage = System.currentTimeMillis();
        }

        public float getAggro() {
            float f = System.currentTimeMillis() - this.lastDamage;
            float f2 = Math.min(1.0f, Math.max(0.0f, (10000.0f - f) / 5000.0f));
            f2 = Math.min(1.0f, Math.max(0.0f, f2 * this.damage * 0.5f));
            return f2;
        }
    }

    private static class s_performance {
        static final PerformanceProfileProbe update = new PerformanceProfileProbe("IsoZombie.update");
        static final PerformanceProfileProbe postUpdate = new PerformanceProfileProbe("IsoZombie.postUpdate");

        private s_performance() {
        }
    }

    private static final class FloodFill {
        private IsoGridSquare start = null;
        private final int FLOOD_SIZE = 11;
        private final BooleanGrid visited = new BooleanGrid(11, 11);
        private final Stack<IsoGridSquare> stack = new Stack();
        private IsoBuilding building = null;
        private Mover mover = null;
        private final ArrayList<IsoGridSquare> choices = new ArrayList(121);

        private FloodFill() {
        }

        void calculate(Mover mover, IsoGridSquare isoGridSquare) {
            this.start = isoGridSquare;
            this.mover = mover;
            if (this.start.getRoom() != null) {
                this.building = this.start.getRoom().getBuilding();
            }
            boolean bl = false;
            boolean bl2 = false;
            this.push(this.start.getX(), this.start.getY());
            while ((isoGridSquare = this.pop()) != null) {
                int n = isoGridSquare.getX();
                int n2 = isoGridSquare.getY();
                while (this.shouldVisit(n, n2, n, n2 - 1)) {
                    --n2;
                }
                bl2 = false;
                bl = false;
                do {
                    this.visited.setValue(this.gridX(n), this.gridY(n2), true);
                    IsoGridSquare isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, this.start.getZ());
                    if (isoGridSquare2 != null) {
                        this.choices.add(isoGridSquare2);
                    }
                    if (!bl && this.shouldVisit(n, n2, n - 1, n2)) {
                        this.push(n - 1, n2);
                        bl = true;
                    } else if (bl && !this.shouldVisit(n, n2, n - 1, n2)) {
                        bl = false;
                    } else if (bl && !this.shouldVisit(n - 1, n2, n - 1, n2 - 1)) {
                        this.push(n - 1, n2);
                    }
                    if (!bl2 && this.shouldVisit(n, n2, n + 1, n2)) {
                        this.push(n + 1, n2);
                        bl2 = true;
                        continue;
                    }
                    if (bl2 && !this.shouldVisit(n, n2, n + 1, n2)) {
                        bl2 = false;
                        continue;
                    }
                    if (!bl2 || this.shouldVisit(n + 1, n2, n + 1, n2 - 1)) continue;
                    this.push(n + 1, n2);
                } while (this.shouldVisit(n, ++n2 - 1, n, n2));
            }
        }

        boolean shouldVisit(int n, int n2, int n3, int n4) {
            if (this.gridX(n3) >= 11 || this.gridX(n3) < 0) {
                return false;
            }
            if (this.gridY(n4) >= 11 || this.gridY(n4) < 0) {
                return false;
            }
            if (this.visited.getValue(this.gridX(n3), this.gridY(n4))) {
                return false;
            }
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n3, n4, this.start.getZ());
            if (isoGridSquare == null) {
                return false;
            }
            if (isoGridSquare.Has(IsoObjectType.stairsBN) || isoGridSquare.Has(IsoObjectType.stairsMN) || isoGridSquare.Has(IsoObjectType.stairsTN)) {
                return false;
            }
            if (isoGridSquare.Has(IsoObjectType.stairsBW) || isoGridSquare.Has(IsoObjectType.stairsMW) || isoGridSquare.Has(IsoObjectType.stairsTW)) {
                return false;
            }
            if (isoGridSquare.getRoom() != null && this.building == null) {
                return false;
            }
            if (isoGridSquare.getRoom() == null && this.building != null) {
                return false;
            }
            return !IsoWorld.instance.CurrentCell.blocked(this.mover, n3, n4, this.start.getZ(), n, n2, this.start.getZ());
        }

        void push(int n, int n2) {
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, this.start.getZ());
            this.stack.push(isoGridSquare);
        }

        IsoGridSquare pop() {
            return this.stack.isEmpty() ? null : this.stack.pop();
        }

        int gridX(int n) {
            return n - (this.start.getX() - 5);
        }

        int gridY(int n) {
            return n - (this.start.getY() - 5);
        }

        int gridX(IsoGridSquare isoGridSquare) {
            return isoGridSquare.getX() - (this.start.getX() - 5);
        }

        int gridY(IsoGridSquare isoGridSquare) {
            return isoGridSquare.getY() - (this.start.getY() - 5);
        }

        IsoGridSquare choose() {
            if (this.choices.isEmpty()) {
                return null;
            }
            int n = Rand.Next(this.choices.size());
            return this.choices.get(n);
        }

        void reset() {
            this.building = null;
            this.choices.clear();
            this.stack.clear();
            this.visited.clear();
        }
    }

    public static enum ZombieSound {
        Burned(10),
        DeadCloseKilled(10),
        DeadNotCloseKilled(10),
        Hurt(10),
        Idle(15),
        Lunge(40),
        MAX(-1);

        private int radius;
        private static final ZombieSound[] values;

        private ZombieSound(int n2) {
            this.radius = n2;
        }

        public int radius() {
            return this.radius;
        }

        public static ZombieSound fromIndex(int n) {
            return n >= 0 && n < values.length ? values[n] : MAX;
        }

        static {
            values = ZombieSound.values();
        }
    }
}

