/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import fmod.fmod.FMODManager;
import fmod.fmod.FMOD_STUDIO_PARAMETER_DESCRIPTION;
import fmod.fmod.IFMODParameterUpdater;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.UUID;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import se.krka.kahlua.vm.KahluaTable;
import zombie.AmbientStreamManager;
import zombie.DebugFileWatcher;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaHookManager;
import zombie.Lua.LuaManager;
import zombie.PersistentOutfits;
import zombie.PredicatedFileWatcher;
import zombie.SandboxOptions;
import zombie.SoundManager;
import zombie.SystemDisabler;
import zombie.VirtualZombieManager;
import zombie.WorldSoundManager;
import zombie.ZomboidFileSystem;
import zombie.ZomboidGlobals;
import zombie.ai.GameCharacterAIBrain;
import zombie.ai.MapKnowledge;
import zombie.ai.State;
import zombie.ai.StateMachine;
import zombie.ai.astar.AStarPathFinder;
import zombie.ai.astar.AStarPathFinderResult;
import zombie.ai.sadisticAIDirector.SleepingEventData;
import zombie.ai.states.AttackNetworkState;
import zombie.ai.states.AttackState;
import zombie.ai.states.BumpedState;
import zombie.ai.states.ClimbDownSheetRopeState;
import zombie.ai.states.ClimbOverFenceState;
import zombie.ai.states.ClimbOverWallState;
import zombie.ai.states.ClimbSheetRopeState;
import zombie.ai.states.ClimbThroughWindowState;
import zombie.ai.states.CloseWindowState;
import zombie.ai.states.CollideWithWallState;
import zombie.ai.states.FakeDeadZombieState;
import zombie.ai.states.IdleState;
import zombie.ai.states.LungeNetworkState;
import zombie.ai.states.LungeState;
import zombie.ai.states.OpenWindowState;
import zombie.ai.states.PathFindState;
import zombie.ai.states.PlayerFallDownState;
import zombie.ai.states.PlayerGetUpState;
import zombie.ai.states.PlayerHitReactionPVPState;
import zombie.ai.states.PlayerHitReactionState;
import zombie.ai.states.PlayerKnockedDown;
import zombie.ai.states.PlayerOnGroundState;
import zombie.ai.states.SmashWindowState;
import zombie.ai.states.StaggerBackState;
import zombie.ai.states.SwipeStatePlayer;
import zombie.ai.states.ThumpState;
import zombie.ai.states.WalkTowardState;
import zombie.ai.states.ZombieFallDownState;
import zombie.ai.states.ZombieFallingState;
import zombie.ai.states.ZombieHitReactionState;
import zombie.ai.states.ZombieOnGroundState;
import zombie.audio.BaseSoundEmitter;
import zombie.audio.FMODParameter;
import zombie.audio.FMODParameterList;
import zombie.audio.GameSoundClip;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characterTextures.BloodClothingType;
import zombie.characters.AnimStateTriggerXmlFile;
import zombie.characters.AttachedItems.AttachedItem;
import zombie.characters.AttachedItems.AttachedItems;
import zombie.characters.AttachedItems.AttachedLocationGroup;
import zombie.characters.AttachedItems.AttachedLocations;
import zombie.characters.BaseCharacterSoundEmitter;
import zombie.characters.BodyDamage.BodyDamage;
import zombie.characters.BodyDamage.BodyPart;
import zombie.characters.BodyDamage.BodyPartLast;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.characters.BodyDamage.Metabolics;
import zombie.characters.BodyDamage.Nutrition;
import zombie.characters.CharacterSoundEmitter;
import zombie.characters.CharacterTimedActions.BaseAction;
import zombie.characters.CharacterTimedActions.LuaTimedActionNew;
import zombie.characters.ClothingWetness;
import zombie.characters.DummyCharacterSoundEmitter;
import zombie.characters.Faction;
import zombie.characters.HaloTextHelper;
import zombie.characters.HitReactionNetworkAI;
import zombie.characters.ILuaGameCharacter;
import zombie.characters.ILuaVariableSource;
import zombie.characters.IsoLivingCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoSurvivor;
import zombie.characters.IsoZombie;
import zombie.characters.Moodles.MoodleType;
import zombie.characters.Moodles.Moodles;
import zombie.characters.MoveDeltaModifiers;
import zombie.characters.NetworkCharacter;
import zombie.characters.NetworkCharacterAI;
import zombie.characters.NetworkTeleport;
import zombie.characters.Safety;
import zombie.characters.Stats;
import zombie.characters.SurvivorDesc;
import zombie.characters.Talker;
import zombie.characters.TriggerXmlFile;
import zombie.characters.WornItems.BodyLocationGroup;
import zombie.characters.WornItems.BodyLocations;
import zombie.characters.WornItems.WornItem;
import zombie.characters.WornItems.WornItems;
import zombie.characters.ZombiesZoneDefinition;
import zombie.characters.action.ActionContext;
import zombie.characters.action.ActionState;
import zombie.characters.action.ActionStateSnapshot;
import zombie.characters.action.IActionStateChanged;
import zombie.characters.skills.PerkFactory;
import zombie.characters.traits.TraitCollection;
import zombie.characters.traits.TraitFactory;
import zombie.chat.ChatElement;
import zombie.chat.ChatElementOwner;
import zombie.chat.ChatManager;
import zombie.chat.ChatMessage;
import zombie.core.BoxedStaticValues;
import zombie.core.Color;
import zombie.core.Colors;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.Rand;
import zombie.core.SpriteRenderer;
import zombie.core.Translator;
import zombie.core.logger.ExceptionLogger;
import zombie.core.logger.LoggerManager;
import zombie.core.math.PZMath;
import zombie.core.opengl.Shader;
import zombie.core.profiling.PerformanceProfileProbe;
import zombie.core.raknet.UdpConnection;
import zombie.core.skinnedmodel.ModelManager;
import zombie.core.skinnedmodel.advancedanimation.AdvancedAnimator;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.core.skinnedmodel.advancedanimation.AnimLayer;
import zombie.core.skinnedmodel.advancedanimation.AnimNode;
import zombie.core.skinnedmodel.advancedanimation.AnimState;
import zombie.core.skinnedmodel.advancedanimation.AnimationSet;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableHandle;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableSlotCallbackBool;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableSlotCallbackFloat;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableSlotCallbackInt;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableSlotCallbackString;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableSource;
import zombie.core.skinnedmodel.advancedanimation.AnimationVariableType;
import zombie.core.skinnedmodel.advancedanimation.IAnimEventCallback;
import zombie.core.skinnedmodel.advancedanimation.IAnimatable;
import zombie.core.skinnedmodel.advancedanimation.IAnimationVariableMap;
import zombie.core.skinnedmodel.advancedanimation.IAnimationVariableSlot;
import zombie.core.skinnedmodel.advancedanimation.LiveAnimNode;
import zombie.core.skinnedmodel.advancedanimation.debug.AnimatorDebugMonitor;
import zombie.core.skinnedmodel.animation.AnimationClip;
import zombie.core.skinnedmodel.animation.AnimationMultiTrack;
import zombie.core.skinnedmodel.animation.AnimationPlayer;
import zombie.core.skinnedmodel.animation.AnimationTrack;
import zombie.core.skinnedmodel.animation.debug.AnimationPlayerRecorder;
import zombie.core.skinnedmodel.model.Model;
import zombie.core.skinnedmodel.model.ModelInstance;
import zombie.core.skinnedmodel.model.ModelInstanceTextureCreator;
import zombie.core.skinnedmodel.population.BeardStyle;
import zombie.core.skinnedmodel.population.BeardStyles;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.population.ClothingItemReference;
import zombie.core.skinnedmodel.population.HairStyle;
import zombie.core.skinnedmodel.population.HairStyles;
import zombie.core.skinnedmodel.population.IClothingItemListener;
import zombie.core.skinnedmodel.population.Outfit;
import zombie.core.skinnedmodel.population.OutfitManager;
import zombie.core.skinnedmodel.population.OutfitRNG;
import zombie.core.skinnedmodel.visual.BaseVisual;
import zombie.core.skinnedmodel.visual.HumanVisual;
import zombie.core.skinnedmodel.visual.IHumanVisual;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.core.textures.ColorInfo;
import zombie.core.utils.UpdateLimit;
import zombie.core.znet.SteamUtils;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.debug.LineDrawer;
import zombie.debug.LogSeverity;
import zombie.gameStates.IngameState;
import zombie.input.Mouse;
import zombie.interfaces.IUpdater;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.types.Clothing;
import zombie.inventory.types.Drainable;
import zombie.inventory.types.Food;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.InventoryContainer;
import zombie.inventory.types.Literature;
import zombie.inventory.types.Radio;
import zombie.inventory.types.WeaponType;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoLightSource;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoObjectPicker;
import zombie.iso.IsoRoofFixer;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.LightingJNI;
import zombie.iso.LosUtil;
import zombie.iso.RoomDef;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.Vector3;
import zombie.iso.areas.IsoBuilding;
import zombie.iso.areas.IsoRoom;
import zombie.iso.areas.NonPvpZone;
import zombie.iso.objects.IsoBall;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoFallingClothing;
import zombie.iso.objects.IsoFireManager;
import zombie.iso.objects.IsoMolotovCocktail;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoTree;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.IsoWindowFrame;
import zombie.iso.objects.IsoZombieGiblets;
import zombie.iso.objects.RainManager;
import zombie.iso.objects.interfaces.BarricadeAble;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteInstance;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.NetworkVariables;
import zombie.network.PacketValidator;
import zombie.network.ServerGUI;
import zombie.network.ServerMap;
import zombie.network.ServerOptions;
import zombie.network.Userlog;
import zombie.network.chat.ChatServer;
import zombie.network.chat.ChatType;
import zombie.network.packets.hit.AttackVars;
import zombie.network.packets.hit.HitInfo;
import zombie.popman.ObjectPool;
import zombie.profanity.ProfanityFilter;
import zombie.radio.ZomboidRadio;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.scripting.objects.Recipe;
import zombie.scripting.objects.VehicleScript;
import zombie.ui.TextDrawObject;
import zombie.ui.TextManager;
import zombie.ui.TutorialManager;
import zombie.ui.UIElement;
import zombie.ui.UIFont;
import zombie.ui.UIManager;
import zombie.util.Pool;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.util.list.PZArrayUtil;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.PathFindBehavior2;
import zombie.vehicles.PolygonalMap2;
import zombie.vehicles.VehicleLight;
import zombie.vehicles.VehiclePart;

public abstract class IsoGameCharacter
extends IsoMovingObject
implements Talker,
ChatElementOwner,
IAnimatable,
IAnimationVariableMap,
IClothingItemListener,
IActionStateChanged,
IAnimEventCallback,
IFMODParameterUpdater,
ILuaVariableSource,
ILuaGameCharacter {
    private boolean ignoreAimingInput = false;
    public boolean doRenderShadow = true;
    private boolean doDeathSound = true;
    private boolean canShout = true;
    public boolean doDirtBloodEtc = true;
    private static int IID = 0;
    public static final int RENDER_OFFSET_X = 1;
    public static final int RENDER_OFFSET_Y = -89;
    public static final float s_maxPossibleTwist = 70.0f;
    private static final HashMap<Integer, SurvivorDesc> SurvivorMap = new HashMap();
    private static final int[] LevelUpLevels = new int[]{25, 75, 150, 225, 300, 400, 500, 600, 700, 800, 900, 1000, 1200, 1400, 1600, 1800, 2000, 2200, 2400, 2600, 2800, 3000, 3200, 3400, 3600, 3800, 4000, 4400, 4800, 5200, 5600, 6000};
    protected static final Vector2 tempo = new Vector2();
    protected static final ColorInfo inf = new ColorInfo();
    public long vocalEvent;
    public long removedFromWorldMS = 0L;
    private boolean bAutoWalk = false;
    private final Vector2 autoWalkDirection = new Vector2();
    private boolean bSneaking = false;
    protected static final Vector2 tempo2 = new Vector2();
    private static final Vector2 tempVector2_1 = new Vector2();
    private static final Vector2 tempVector2_2 = new Vector2();
    private static String sleepText = null;
    protected final ArrayList<InventoryItem> savedInventoryItems = new ArrayList();
    private final String instancename;
    protected GameCharacterAIBrain GameCharacterAIBrain;
    public final ArrayList<String> amputations = new ArrayList();
    public ModelInstance hair;
    public ModelInstance beard;
    public ModelInstance primaryHandModel;
    public ModelInstance secondaryHandModel;
    public final ActionContext actionContext = new ActionContext(this);
    public final BaseCharacterSoundEmitter emitter;
    private final FMODParameterList fmodParameters = new FMODParameterList();
    private final AnimationVariableSource m_GameVariables = new AnimationVariableSource();
    private AnimationVariableSource m_PlaybackGameVariables = null;
    private boolean bRunning = false;
    private boolean bSprinting = false;
    private boolean m_godMod = false;
    private boolean m_invisible = false;
    private boolean m_avoidDamage = false;
    public boolean callOut = false;
    public IsoGameCharacter ReanimatedCorpse;
    public int ReanimatedCorpseID = -1;
    private AnimationPlayer m_animPlayer = null;
    public final AdvancedAnimator advancedAnimator;
    public final HashMap<State, HashMap<Object, Object>> StateMachineParams = new HashMap();
    public long clientIgnoreCollision = 0L;
    private boolean isCrit = false;
    private boolean bKnockedDown = false;
    public int bumpNbr = 0;
    public boolean upKillCount = true;
    private final ArrayList<PerkInfo> PerkList = new ArrayList();
    private final Vector2 m_forwardDirection = new Vector2();
    public boolean Asleep = false;
    public boolean blockTurning = false;
    public float speedMod = 1.0f;
    public IsoSprite legsSprite;
    private boolean bFemale = true;
    public float knockbackAttackMod = 1.0f;
    public final boolean[] IsVisibleToPlayer = new boolean[4];
    public float savedVehicleX;
    public float savedVehicleY;
    public short savedVehicleSeat = (short)-1;
    public boolean savedVehicleRunning;
    private static final float RecoilDelayDecrease = 0.625f;
    protected static final float BeenMovingForIncrease = 1.25f;
    protected static final float BeenMovingForDecrease = 0.625f;
    private IsoGameCharacter FollowingTarget = null;
    private final ArrayList<IsoMovingObject> LocalList = new ArrayList();
    private final ArrayList<IsoMovingObject> LocalNeutralList = new ArrayList();
    private final ArrayList<IsoMovingObject> LocalGroupList = new ArrayList();
    private final ArrayList<IsoMovingObject> LocalRelevantEnemyList = new ArrayList();
    private float dangerLevels = 0.0f;
    private static final Vector2 tempVector2 = new Vector2();
    private float leaveBodyTimedown = 0.0f;
    protected boolean AllowConversation = true;
    private float ReanimateTimer;
    private int ReanimAnimFrame;
    private int ReanimAnimDelay;
    private boolean Reanim = false;
    private boolean VisibleToNPCs = true;
    private int DieCount = 0;
    private float llx = 0.0f;
    private float lly = 0.0f;
    private float llz = 0.0f;
    protected int RemoteID = -1;
    protected int NumSurvivorsInVicinity = 0;
    private float LevelUpMultiplier = 2.5f;
    protected XP xp = null;
    private int LastLocalEnemies = 0;
    private final ArrayList<IsoMovingObject> VeryCloseEnemyList = new ArrayList();
    private final HashMap<String, Location> LastKnownLocation = new HashMap();
    protected IsoGameCharacter AttackedBy = null;
    protected boolean IgnoreStaggerBack = false;
    protected boolean AttackWasSuperAttack = false;
    private int TimeThumping = 0;
    private int PatienceMax = 150;
    private int PatienceMin = 20;
    private int Patience = 20;
    protected final Stack<BaseAction> CharacterActions = new Stack();
    private int ZombieKills = 0;
    private int SurvivorKills = 0;
    private int LastZombieKills = 0;
    protected boolean superAttack = false;
    protected float ForceWakeUpTime = -1.0f;
    private float fullSpeedMod = 1.0f;
    protected float runSpeedModifier = 1.0f;
    private float walkSpeedModifier = 1.0f;
    private float combatSpeedModifier = 1.0f;
    private boolean bRangedWeaponEmpty = false;
    public ArrayList<InventoryContainer> bagsWorn;
    protected boolean ForceWakeUp;
    protected final BodyDamage BodyDamage;
    private BodyDamage BodyDamageRemote = null;
    private State defaultState;
    protected WornItems wornItems = null;
    protected AttachedItems attachedItems = null;
    protected ClothingWetness clothingWetness = null;
    protected SurvivorDesc descriptor;
    private final Stack<IsoBuilding> FamiliarBuildings = new Stack();
    protected final AStarPathFinderResult finder = new AStarPathFinderResult();
    private float FireKillRate = 0.0038f;
    private int FireSpreadProbability = 6;
    protected float Health = 1.0f;
    protected boolean bDead = false;
    protected boolean bKill = false;
    protected boolean bPlayingDeathSound = false;
    private boolean bDeathDragDown = false;
    protected String hurtSound = "MaleZombieHurt";
    protected ItemContainer inventory = new ItemContainer();
    protected InventoryItem leftHandItem;
    private int NextWander = 200;
    private boolean OnFire = false;
    private int pathIndex = 0;
    protected InventoryItem rightHandItem;
    protected Color SpeakColour = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    protected float slowFactor = 0.0f;
    protected float slowTimer = 0.0f;
    protected boolean bUseParts = false;
    protected boolean Speaking = false;
    private float SpeakTime = 0.0f;
    private float staggerTimeMod = 1.0f;
    protected final StateMachine stateMachine;
    protected final Moodles Moodles;
    protected final Stats stats = new Stats();
    private final Stack<String> UsedItemsOn = new Stack();
    protected HandWeapon useHandWeapon = null;
    protected IsoGridSquare attackTargetSquare;
    private float BloodImpactX = 0.0f;
    private float BloodImpactY = 0.0f;
    private float BloodImpactZ = 0.0f;
    private IsoSprite bloodSplat;
    private boolean bOnBed = false;
    private final Vector2 moveForwardVec = new Vector2();
    protected boolean pathing = false;
    protected ChatElement chatElement;
    private final Stack<IsoGameCharacter> LocalEnemyList = new Stack();
    protected final Stack<IsoGameCharacter> EnemyList = new Stack();
    public final CharacterTraits Traits = new CharacterTraits();
    private int maxWeight = 8;
    private int maxWeightBase = 8;
    private float SleepingTabletDelta = 1.0f;
    private float BetaEffect = 0.0f;
    private float DepressEffect = 0.0f;
    private float SleepingTabletEffect = 0.0f;
    private float BetaDelta = 0.0f;
    private float DepressDelta = 0.0f;
    private float DepressFirstTakeTime = -1.0f;
    private float PainEffect = 0.0f;
    private float PainDelta = 0.0f;
    private boolean bDoDefer = true;
    private float haloDispTime = 128.0f;
    protected TextDrawObject userName;
    private TextDrawObject haloNote;
    private final HashMap<String, String> namesPrefix = new HashMap();
    private static final String namePvpSuffix = " [img=media/ui/Skull.png]";
    private static final String nameCarKeySuffix = " [img=media/ui/CarKey.png";
    private static final String voiceSuffix = "[img=media/ui/voiceon.png] ";
    private static final String voiceMuteSuffix = "[img=media/ui/voicemuted.png] ";
    protected IsoPlayer isoPlayer = null;
    private boolean hasInitTextObjects = false;
    private boolean canSeeCurrent = false;
    private boolean drawUserName = false;
    private final Location LastHeardSound = new Location(-1, -1, -1);
    private float lrx = 0.0f;
    private float lry = 0.0f;
    protected boolean bClimbing = false;
    private boolean lastCollidedW = false;
    private boolean lastCollidedN = false;
    protected float fallTime = 0.0f;
    protected float lastFallSpeed = 0.0f;
    protected boolean bFalling = false;
    protected BaseVehicle vehicle = null;
    boolean isNPC = false;
    private long lastBump = 0L;
    private IsoGameCharacter bumpedChr = null;
    private boolean m_isCulled = true;
    private int age = 25;
    private int lastHitCount = 0;
    private Safety safety = new Safety(this);
    private float meleeDelay = 0.0f;
    private float RecoilDelay = 0.0f;
    private float BeenMovingFor = 0.0f;
    private float BeenSprintingFor = 0.0f;
    private boolean forceShove = false;
    private String clickSound = null;
    private float reduceInfectionPower = 0.0f;
    private final List<String> knownRecipes = new ArrayList<String>();
    private final HashSet<String> knownMediaLines = new HashSet();
    private int lastHourSleeped = 0;
    protected float timeOfSleep = 0.0f;
    protected float delayToActuallySleep = 0.0f;
    private String bedType = "averageBed";
    private IsoObject bed = null;
    private boolean isReading = false;
    private float timeSinceLastSmoke = 0.0f;
    private boolean wasOnStairs = false;
    private ChatMessage lastChatMessage;
    private String lastSpokenLine;
    private boolean unlimitedEndurance = false;
    private boolean unlimitedCarry = false;
    private boolean buildCheat = false;
    private boolean farmingCheat = false;
    private boolean healthCheat = false;
    private boolean mechanicsCheat = false;
    private boolean movablesCheat = false;
    private boolean timedActionInstantCheat = false;
    private boolean showAdminTag = true;
    private long isAnimForecasted = 0L;
    private boolean fallOnFront = false;
    private boolean hitFromBehind = false;
    private String hitReaction = "";
    private String bumpType = "";
    private boolean m_isBumpDone = false;
    private boolean m_bumpFall = false;
    private boolean m_bumpStaggered = false;
    private String m_bumpFallType = "";
    private int sleepSpeechCnt = 0;
    private Radio equipedRadio;
    private InventoryItem leftHandCache;
    private InventoryItem rightHandCache;
    private final ArrayList<ReadBook> ReadBooks = new ArrayList();
    private final LightInfo lightInfo = new LightInfo();
    private final LightInfo lightInfo2 = new LightInfo();
    private PolygonalMap2.Path path2;
    private final MapKnowledge mapKnowledge = new MapKnowledge();
    public final AttackVars attackVars = new AttackVars();
    public final ArrayList<HitInfo> hitList = new ArrayList();
    private final PathFindBehavior2 pfb2 = new PathFindBehavior2(this);
    private final InventoryItem[] cacheEquiped = new InventoryItem[2];
    private boolean bAimAtFloor = false;
    protected int m_persistentOutfitId = 0;
    protected boolean m_bPersistentOutfitInit = false;
    private boolean bUpdateModelTextures = false;
    private ModelInstanceTextureCreator textureCreator = null;
    public boolean bUpdateEquippedTextures = false;
    private final ArrayList<ModelInstance> readyModelData = new ArrayList();
    private boolean sitOnGround = false;
    private boolean ignoreMovement = false;
    private boolean hideWeaponModel = false;
    private boolean isAiming = false;
    private float beardGrowTiming = -1.0f;
    private float hairGrowTiming = -1.0f;
    private float m_moveDelta = 1.0f;
    protected float m_turnDeltaNormal = 1.0f;
    protected float m_turnDeltaRunning = 0.8f;
    protected float m_turnDeltaSprinting = 0.75f;
    private float m_maxTwist = 15.0f;
    private boolean m_isMoving = false;
    private boolean m_isTurning = false;
    private boolean m_isTurningAround = false;
    private boolean m_isTurning90 = false;
    public long lastAutomaticShoot = 0L;
    public int shootInARow = 0;
    private boolean invincible = false;
    private float lungeFallTimer = 0.0f;
    private SleepingEventData m_sleepingEventData;
    private final int HAIR_GROW_TIME = 20;
    private final int BEARD_GROW_TIME = 5;
    public float realx = 0.0f;
    public float realy = 0.0f;
    public byte realz = 0;
    public NetworkVariables.ZombieState realState = NetworkVariables.ZombieState.Idle;
    public IsoDirections realdir = IsoDirections.fromIndex(0);
    public String overridePrimaryHandModel = null;
    public String overrideSecondaryHandModel = null;
    public boolean forceNullOverride = false;
    protected final UpdateLimit ulBeatenVehicle = new UpdateLimit(200L);
    private float m_momentumScalar = 0.0f;
    private final HashMap<String, State> m_stateUpdateLookup = new HashMap();
    private boolean attackAnim = false;
    private NetworkTeleport teleport = null;
    @Deprecated
    public ArrayList<Integer> invRadioFreq = new ArrayList();
    private final PredicatedFileWatcher m_animStateTriggerWatcher;
    private final AnimationPlayerRecorder m_animationRecorder;
    private final String m_UID;
    private boolean m_bDebugVariablesRegistered = false;
    private float effectiveEdibleBuffTimer = 0.0f;
    private float m_shadowFM = 0.0f;
    private float m_shadowBM = 0.0f;
    private long shadowTick = -1L;
    private static final ItemVisuals tempItemVisuals = new ItemVisuals();
    private static final ArrayList<IsoMovingObject> movingStatic = new ArrayList();
    private long m_muzzleFlash = -1L;
    private static final Bandages s_bandages = new Bandages();
    private static final Vector3 tempVector = new Vector3();
    private static final Vector3 tempVectorBonePos = new Vector3();
    public final NetworkCharacter networkCharacter = new NetworkCharacter();

    public IsoGameCharacter(IsoCell isoCell, float f, float f2, float f3) {
        super(isoCell, false);
        this.m_UID = String.format("%s-%s", this.getClass().getSimpleName(), UUID.randomUUID().toString());
        this.registerVariableCallbacks();
        this.instancename = "Character" + IID;
        ++IID;
        this.emitter = !(this instanceof IsoSurvivor) ? (Core.SoundDisabled || GameServer.bServer ? new DummyCharacterSoundEmitter(this) : new CharacterSoundEmitter(this)) : null;
        if (f != 0.0f || f2 != 0.0f || f3 != 0.0f) {
            if (this.getCell().isSafeToAdd()) {
                this.getCell().getObjectList().add(this);
            } else {
                this.getCell().getAddList().add(this);
            }
        }
        if (this.def == null) {
            this.def = IsoSpriteInstance.get(this.sprite);
        }
        if (this instanceof IsoPlayer) {
            this.BodyDamage = new BodyDamage(this);
            this.Moodles = new Moodles(this);
            this.xp = new XP(this);
        } else {
            this.BodyDamage = null;
            this.Moodles = null;
            this.xp = null;
        }
        this.Patience = Rand.Next(this.PatienceMin, this.PatienceMax);
        this.x = f + 0.5f;
        this.y = f2 + 0.5f;
        this.z = f3;
        this.lx = this.nx = f;
        this.scriptnx = this.nx;
        this.ly = this.ny = f2;
        this.scriptny = this.ny;
        if (isoCell != null) {
            this.current = this.getCell().getGridSquare((int)f, (int)f2, (int)f3);
        }
        this.offsetY = 0.0f;
        this.offsetX = 0.0f;
        this.stateMachine = new StateMachine(this);
        this.setDefaultState(IdleState.instance());
        this.inventory.parent = this;
        this.inventory.setExplored(true);
        this.chatElement = new ChatElement(this, 1, "character");
        if (GameClient.bClient || GameServer.bServer) {
            this.namesPrefix.put("admin", "[col=255,0,0]Admin[/] ");
            this.namesPrefix.put("moderator", "[col=0,128,47]Moderator[/] ");
            this.namesPrefix.put("overseer", "[col=26,26,191]Overseer[/] ");
            this.namesPrefix.put("gm", "[col=213,123,23]GM[/] ");
            this.namesPrefix.put("observer", "[col=128,128,128]Observer[/] ");
        }
        this.m_animationRecorder = new AnimationPlayerRecorder(this);
        this.advancedAnimator = new AdvancedAnimator();
        this.advancedAnimator.init(this);
        this.advancedAnimator.animCallbackHandlers.add(this);
        this.advancedAnimator.SetAnimSet(AnimationSet.GetAnimationSet(this.GetAnimSetName(), false));
        this.advancedAnimator.setRecorder(this.m_animationRecorder);
        this.actionContext.onStateChanged.add(this);
        this.m_animStateTriggerWatcher = new PredicatedFileWatcher(ZomboidFileSystem.instance.getMessagingDirSub("Trigger_SetAnimState.xml"), AnimStateTriggerXmlFile.class, this::onTrigger_setAnimStateToTriggerFile);
    }

    private void registerVariableCallbacks() {
        this.setVariable("hitreaction", this::getHitReaction, this::setHitReaction);
        this.setVariable("collidetype", this::getCollideType, this::setCollideType);
        this.setVariable("footInjuryType", this::getFootInjuryType);
        this.setVariable("bumptype", this::getBumpType, this::setBumpType);
        this.setVariable("sitonground", this::isSitOnGround, this::setSitOnGround);
        this.setVariable("canclimbdownrope", this::canClimbDownSheetRopeInCurrentSquare);
        this.setVariable("frombehind", this::isHitFromBehind, this::setHitFromBehind);
        this.setVariable("fallonfront", this::isFallOnFront, this::setFallOnFront);
        this.setVariable("hashitreaction", this::hasHitReaction);
        this.setVariable("intrees", this::isInTreesNoBush);
        this.setVariable("bumped", this::isBumped);
        this.setVariable("BumpDone", false, this::isBumpDone, this::setBumpDone);
        this.setVariable("BumpFall", false, this::isBumpFall, this::setBumpFall);
        this.setVariable("BumpFallType", "", this::getBumpFallType, this::setBumpFallType);
        this.setVariable("BumpStaggered", false, this::isBumpStaggered, this::setBumpStaggered);
        this.setVariable("bonfloor", this::isOnFloor, this::setOnFloor);
        this.setVariable("rangedweaponempty", this::isRangedWeaponEmpty, this::setRangedWeaponEmpty);
        this.setVariable("footInjury", this::hasFootInjury);
        this.setVariable("ChopTreeSpeed", 1.0f, this::getChopTreeSpeed);
        this.setVariable("MoveDelta", 1.0f, this::getMoveDelta, this::setMoveDelta);
        this.setVariable("TurnDelta", 1.0f, this::getTurnDelta, this::setTurnDelta);
        this.setVariable("angle", this::getDirectionAngle, this::setDirectionAngle);
        this.setVariable("animAngle", this::getAnimAngle);
        this.setVariable("twist", this::getTwist);
        this.setVariable("targetTwist", this::getTargetTwist);
        this.setVariable("maxTwist", this.m_maxTwist, this::getMaxTwist, this::setMaxTwist);
        this.setVariable("shoulderTwist", this::getShoulderTwist);
        this.setVariable("excessTwist", this::getExcessTwist);
        this.setVariable("angleStepDelta", this::getAnimAngleStepDelta);
        this.setVariable("angleTwistDelta", this::getAnimAngleTwistDelta);
        this.setVariable("isTurning", false, this::isTurning, this::setTurning);
        this.setVariable("isTurning90", false, this::isTurning90, this::setTurning90);
        this.setVariable("isTurningAround", false, this::isTurningAround, this::setTurningAround);
        this.setVariable("bMoving", false, this::isMoving, this::setMoving);
        this.setVariable("beenMovingFor", this::getBeenMovingFor);
        this.setVariable("previousState", this::getPreviousActionContextStateName);
        this.setVariable("momentumScalar", this::getMomentumScalar, this::setMomentumScalar);
        this.setVariable("hasTimedActions", this::hasTimedActions);
        if (DebugOptions.instance.Character.Debug.RegisterDebugVariables.getValue()) {
            this.registerDebugGameVariables();
        }
        this.setVariable("CriticalHit", this::isCriticalHit, this::setCriticalHit);
        this.setVariable("bKnockedDown", this::isKnockedDown, this::setKnockedDown);
        this.setVariable("bdead", this::isDead);
    }

    public void updateRecoilVar() {
        this.setVariable("recoilVarY", 0.0f);
        this.setVariable("recoilVarX", 0.0f + (float)this.getPerkLevel(PerkFactory.Perks.Aiming) / 10.0f);
    }

    private void registerDebugGameVariables() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.dbgRegisterAnimTrackVariable(i, j);
            }
        }
        this.setVariable("dbg.anm.dx", () -> Float.valueOf(this.getDeferredMovement((Vector2)IsoGameCharacter.tempo).x / GameTime.instance.getMultiplier()));
        this.setVariable("dbg.anm.dy", () -> Float.valueOf(this.getDeferredMovement((Vector2)IsoGameCharacter.tempo).y / GameTime.instance.getMultiplier()));
        this.setVariable("dbg.anm.da", () -> Float.valueOf(this.getDeferredAngleDelta() / GameTime.instance.getMultiplier()));
        this.setVariable("dbg.anm.daw", this::getDeferredRotationWeight);
        this.setVariable("dbg.forward", () -> this.getForwardDirection().x + "; " + this.getForwardDirection().y);
        this.setVariable("dbg.anm.blend.fbx_x", () -> Float.valueOf(DebugOptions.instance.Animation.BlendUseFbx.getValue() ? 1.0f : 0.0f));
        this.m_bDebugVariablesRegistered = true;
    }

    private void dbgRegisterAnimTrackVariable(int n, int n2) {
        this.setVariable(String.format("dbg.anm.track%d%d", n, n2), () -> this.dbgGetAnimTrackName(n, n2));
        this.setVariable(String.format("dbg.anm.t.track%d%d", n, n2), () -> Float.valueOf(this.dbgGetAnimTrackTime(n, n2)));
        this.setVariable(String.format("dbg.anm.w.track%d%d", n, n2), () -> Float.valueOf(this.dbgGetAnimTrackWeight(n, n2)));
    }

    public float getMomentumScalar() {
        return this.m_momentumScalar;
    }

    public void setMomentumScalar(float f) {
        this.m_momentumScalar = f;
    }

    public Vector2 getDeferredMovement(Vector2 vector22) {
        if (this.m_animPlayer == null) {
            vector22.set(0.0f, 0.0f);
            return vector22;
        }
        this.m_animPlayer.getDeferredMovement(vector22);
        return vector22;
    }

    public float getDeferredAngleDelta() {
        if (this.m_animPlayer == null) {
            return 0.0f;
        }
        return this.m_animPlayer.getDeferredAngleDelta() * 57.295776f;
    }

    public float getDeferredRotationWeight() {
        if (this.m_animPlayer == null) {
            return 0.0f;
        }
        return this.m_animPlayer.getDeferredRotationWeight();
    }

    public boolean isStrafing() {
        if (this.getPath2() != null && this.pfb2.isStrafing()) {
            return true;
        }
        return this.isAiming();
    }

    public AnimationTrack dbgGetAnimTrack(int n, int n2) {
        if (this.m_animPlayer == null) {
            return null;
        }
        AnimationPlayer animationPlayer = this.m_animPlayer;
        AnimationMultiTrack animationMultiTrack = animationPlayer.getMultiTrack();
        List<AnimationTrack> list = animationMultiTrack.getTracks();
        AnimationTrack animationTrack = null;
        int n3 = 0;
        int n4 = list.size();
        for (int i = 0; i < n4; ++i) {
            AnimationTrack animationTrack2 = list.get(i);
            int n5 = animationTrack2.getLayerIdx();
            if (n5 != n) continue;
            if (n3 == n2) {
                animationTrack = animationTrack2;
                break;
            }
            ++n3;
        }
        return animationTrack;
    }

    public String dbgGetAnimTrackName(int n, int n2) {
        AnimationTrack animationTrack = this.dbgGetAnimTrack(n, n2);
        return animationTrack != null ? animationTrack.name : "";
    }

    public float dbgGetAnimTrackTime(int n, int n2) {
        AnimationTrack animationTrack = this.dbgGetAnimTrack(n, n2);
        return animationTrack != null ? animationTrack.getCurrentTime() : 0.0f;
    }

    public float dbgGetAnimTrackWeight(int n, int n2) {
        AnimationTrack animationTrack = this.dbgGetAnimTrack(n, n2);
        return animationTrack != null ? animationTrack.BlendDelta : 0.0f;
    }

    public float getTwist() {
        if (this.m_animPlayer != null) {
            return 57.295776f * this.m_animPlayer.getTwistAngle();
        }
        return 0.0f;
    }

    public float getShoulderTwist() {
        if (this.m_animPlayer != null) {
            return 57.295776f * this.m_animPlayer.getShoulderTwistAngle();
        }
        return 0.0f;
    }

    public float getMaxTwist() {
        return this.m_maxTwist;
    }

    public void setMaxTwist(float f) {
        this.m_maxTwist = f;
    }

    public float getExcessTwist() {
        if (this.m_animPlayer != null) {
            return 57.295776f * this.m_animPlayer.getExcessTwistAngle();
        }
        return 0.0f;
    }

    public float getAbsoluteExcessTwist() {
        return Math.abs(this.getExcessTwist());
    }

    public float getAnimAngleTwistDelta() {
        return this.m_animPlayer != null ? this.m_animPlayer.angleTwistDelta : 0.0f;
    }

    public float getAnimAngleStepDelta() {
        return this.m_animPlayer != null ? this.m_animPlayer.angleStepDelta : 0.0f;
    }

    public float getTargetTwist() {
        return this.m_animPlayer != null ? 57.295776f * this.m_animPlayer.getTargetTwistAngle() : 0.0f;
    }

    @Override
    public boolean isRangedWeaponEmpty() {
        return this.bRangedWeaponEmpty;
    }

    @Override
    public void setRangedWeaponEmpty(boolean bl) {
        this.bRangedWeaponEmpty = bl;
    }

    public boolean hasFootInjury() {
        return !StringUtils.isNullOrWhitespace(this.getFootInjuryType());
    }

    public boolean isInTrees2(boolean bl) {
        if (this.isCurrentState(BumpedState.instance())) {
            return false;
        }
        IsoGridSquare isoGridSquare = this.getCurrentSquare();
        if (isoGridSquare != null) {
            Object object;
            if (isoGridSquare.Has(IsoObjectType.tree) && ((object = isoGridSquare.getTree()) == null || bl && ((IsoTree)object).getSize() > 2 || !bl)) {
                return true;
            }
            object = isoGridSquare.getProperties().Val("Movement");
            if ("HedgeLow".equalsIgnoreCase((String)object) || "HedgeHigh".equalsIgnoreCase((String)object)) {
                return true;
            }
            return !bl && isoGridSquare.getProperties().Is("Bush");
        }
        return false;
    }

    public boolean isInTreesNoBush() {
        return this.isInTrees2(true);
    }

    public boolean isInTrees() {
        return this.isInTrees2(false);
    }

    public static HashMap<Integer, SurvivorDesc> getSurvivorMap() {
        return SurvivorMap;
    }

    public static int[] getLevelUpLevels() {
        return LevelUpLevels;
    }

    public static Vector2 getTempo() {
        return tempo;
    }

    public static ColorInfo getInf() {
        return inf;
    }

    public GameCharacterAIBrain getBrain() {
        return this.GameCharacterAIBrain;
    }

    public boolean getIsNPC() {
        return this.isNPC;
    }

    public void setIsNPC(boolean bl) {
        this.isNPC = bl;
    }

    @Override
    public BaseCharacterSoundEmitter getEmitter() {
        return this.emitter;
    }

    public void updateEmitter() {
        this.getFMODParameters().update();
        if (!IsoWorld.instance.emitterUpdate && !this.emitter.hasSoundsToStart()) {
            return;
        }
        if (this.isZombie() && this.isProne()) {
            SwipeStatePlayer.getBoneWorldPos(this, "Bip01_Head", tempVectorBonePos);
            this.emitter.set(IsoGameCharacter.tempVectorBonePos.x, IsoGameCharacter.tempVectorBonePos.y, this.z);
            this.emitter.tick();
            return;
        }
        this.emitter.set(this.x, this.y, this.z);
        this.emitter.tick();
    }

    protected void doDeferredMovement() {
        AnimationPlayer animationPlayer;
        if (GameClient.bClient && this.getHitReactionNetworkAI() != null) {
            if (this.getHitReactionNetworkAI().isStarted()) {
                this.getHitReactionNetworkAI().move();
                return;
            }
            if (this.isDead() && this.getHitReactionNetworkAI().isDoSkipMovement()) {
                return;
            }
        }
        if ((animationPlayer = this.getAnimationPlayer()) == null) {
            return;
        }
        if (this.getPath2() != null && !this.isCurrentState(ClimbOverFenceState.instance()) && !this.isCurrentState(ClimbThroughWindowState.instance())) {
            if (this.isCurrentState(WalkTowardState.instance())) {
                DebugLog.General.warn("WalkTowardState but path2 != null");
                this.setPath2(null);
            }
            return;
        }
        if (GameClient.bClient && (this instanceof IsoZombie && ((IsoZombie)this).isRemoteZombie() ? this.getCurrentState() != ClimbOverFenceState.instance() && this.getCurrentState() != ClimbThroughWindowState.instance() && this.getCurrentState() != ClimbOverWallState.instance() && this.getCurrentState() != StaggerBackState.instance() && this.getCurrentState() != ZombieHitReactionState.instance() && this.getCurrentState() != ZombieFallDownState.instance() && this.getCurrentState() != ZombieFallingState.instance() && this.getCurrentState() != ZombieOnGroundState.instance() && this.getCurrentState() != AttackNetworkState.instance() : this instanceof IsoPlayer && !((IsoPlayer)this).isLocalPlayer() && !this.isCurrentState(CollideWithWallState.instance()) && !this.isCurrentState(PlayerGetUpState.instance()) && !this.isCurrentState(BumpedState.instance()))) {
            return;
        }
        Vector2 vector22 = tempo;
        this.getDeferredMovement(vector22);
        if (GameClient.bClient && this instanceof IsoZombie && this.isCurrentState(StaggerBackState.instance())) {
            float f = vector22.getLength();
            vector22.set(this.getHitDir());
            vector22.setLength(f);
        }
        this.MoveUnmodded(vector22);
    }

    @Override
    public ActionContext getActionContext() {
        return null;
    }

    public String getPreviousActionContextStateName() {
        ActionContext actionContext = this.getActionContext();
        return actionContext == null ? "" : actionContext.getPreviousStateName();
    }

    public String getCurrentActionContextStateName() {
        ActionContext actionContext = this.getActionContext();
        return actionContext == null ? "" : actionContext.getCurrentStateName();
    }

    public boolean hasAnimationPlayer() {
        return this.m_animPlayer != null;
    }

    @Override
    public AnimationPlayer getAnimationPlayer() {
        Model model = ModelManager.instance.getBodyModel(this);
        boolean bl = false;
        if (this.m_animPlayer != null && this.m_animPlayer.getModel() != model) {
            bl = this.m_animPlayer.getMultiTrack().getTrackCount() > 0;
            this.m_animPlayer = Pool.tryRelease(this.m_animPlayer);
        }
        if (this.m_animPlayer == null) {
            this.m_animPlayer = AnimationPlayer.alloc(model);
            this.onAnimPlayerCreated(this.m_animPlayer);
            if (bl) {
                this.getAdvancedAnimator().OnAnimDataChanged(false);
            }
        }
        return this.m_animPlayer;
    }

    public void releaseAnimationPlayer() {
        this.m_animPlayer = Pool.tryRelease(this.m_animPlayer);
    }

    protected void onAnimPlayerCreated(AnimationPlayer animationPlayer) {
        animationPlayer.setRecorder(this.m_animationRecorder);
        animationPlayer.setTwistBones("Bip01_Pelvis", "Bip01_Spine", "Bip01_Spine1", "Bip01_Neck", "Bip01_Head");
        animationPlayer.setCounterRotationBone("Bip01");
    }

    protected void updateAnimationRecorderState() {
        boolean bl;
        boolean bl2;
        if (this.m_animPlayer == null) {
            return;
        }
        if (IsoWorld.isAnimRecorderDiscardTriggered()) {
            this.m_animPlayer.discardRecording();
        }
        boolean bl3 = bl2 = (bl = IsoWorld.isAnimRecorderActive()) && !this.isSceneCulled();
        if (bl2) {
            this.getAnimationPlayerRecorder().logCharacterPos();
        }
        this.m_animPlayer.setRecording(bl2);
    }

    @Override
    public AdvancedAnimator getAdvancedAnimator() {
        return this.advancedAnimator;
    }

    @Override
    public ModelInstance getModelInstance() {
        if (this.legsSprite == null) {
            return null;
        }
        if (this.legsSprite.modelSlot == null) {
            return null;
        }
        return this.legsSprite.modelSlot.model;
    }

    public String getCurrentStateName() {
        return this.stateMachine.getCurrent() == null ? null : this.stateMachine.getCurrent().getName();
    }

    public String getPreviousStateName() {
        return this.stateMachine.getPrevious() == null ? null : this.stateMachine.getPrevious().getName();
    }

    public String getAnimationDebug() {
        if (this.advancedAnimator != null) {
            return this.instancename + "\n" + this.advancedAnimator.GetDebug();
        }
        return this.instancename + "\n - No Animator";
    }

    @Override
    public String getTalkerType() {
        return this.chatElement.getTalkerType();
    }

    public boolean isAnimForecasted() {
        return System.currentTimeMillis() < this.isAnimForecasted;
    }

    public void setAnimForecasted(int n) {
        this.isAnimForecasted = System.currentTimeMillis() + (long)n;
    }

    @Override
    public void resetModel() {
        ModelManager.instance.Reset(this);
    }

    @Override
    public void resetModelNextFrame() {
        ModelManager.instance.ResetNextFrame(this);
    }

    protected void onTrigger_setClothingToXmlTriggerFile(TriggerXmlFile triggerXmlFile) {
        OutfitManager.Reload();
        if (!StringUtils.isNullOrWhitespace(triggerXmlFile.outfitName)) {
            String string = triggerXmlFile.outfitName;
            DebugLog.Clothing.debugln("Desired outfit name: " + string);
            Outfit outfit = triggerXmlFile.isMale ? OutfitManager.instance.FindMaleOutfit(string) : OutfitManager.instance.FindFemaleOutfit(string);
            if (outfit == null) {
                DebugLog.Clothing.error("Could not find outfit: " + string);
                return;
            }
            if (this.bFemale == triggerXmlFile.isMale && this instanceof IHumanVisual) {
                ((IHumanVisual)((Object)this)).getHumanVisual().clear();
            }
            boolean bl = this.bFemale = !triggerXmlFile.isMale;
            if (this.descriptor != null) {
                this.descriptor.setFemale(this.bFemale);
            }
            this.dressInNamedOutfit(outfit.m_Name);
            this.advancedAnimator.OnAnimDataChanged(false);
            if (this instanceof IsoPlayer) {
                LuaEventManager.triggerEvent("OnClothingUpdated", this);
            }
        } else if (!StringUtils.isNullOrWhitespace(triggerXmlFile.clothingItemGUID)) {
            String string = "game";
            this.dressInClothingItem(string + "-" + triggerXmlFile.clothingItemGUID);
            if (this instanceof IsoPlayer) {
                LuaEventManager.triggerEvent("OnClothingUpdated", this);
            }
        }
        ModelManager.instance.Reset(this);
    }

    protected void onTrigger_setAnimStateToTriggerFile(AnimStateTriggerXmlFile animStateTriggerXmlFile) {
        String string = this.GetAnimSetName();
        if (!StringUtils.equalsIgnoreCase(string, animStateTriggerXmlFile.animSet)) {
            this.setVariable("dbgForceAnim", false);
            this.restoreAnimatorStateToActionContext();
            return;
        }
        DebugOptions.instance.Animation.AnimLayer.AllowAnimNodeOverride.setValue(animStateTriggerXmlFile.forceAnim);
        if (this.advancedAnimator.containsState(animStateTriggerXmlFile.stateName)) {
            this.setVariable("dbgForceAnim", animStateTriggerXmlFile.forceAnim);
            this.setVariable("dbgForceAnimStateName", animStateTriggerXmlFile.stateName);
            this.setVariable("dbgForceAnimNodeName", animStateTriggerXmlFile.nodeName);
            this.setVariable("dbgForceAnimScalars", animStateTriggerXmlFile.setScalarValues);
            this.setVariable("dbgForceScalar", animStateTriggerXmlFile.scalarValue);
            this.setVariable("dbgForceScalar2", animStateTriggerXmlFile.scalarValue2);
            this.advancedAnimator.SetState(animStateTriggerXmlFile.stateName);
        } else {
            DebugLog.Animation.error("State not found: " + animStateTriggerXmlFile.stateName);
            this.restoreAnimatorStateToActionContext();
        }
    }

    private void restoreAnimatorStateToActionContext() {
        if (this.actionContext.getCurrentState() != null) {
            this.advancedAnimator.SetState(this.actionContext.getCurrentStateName(), PZArrayUtil.listConvert(this.actionContext.getChildStates(), actionState -> actionState.name));
        }
    }

    @Override
    public void clothingItemChanged(String string) {
        if (this.wornItems != null) {
            for (int i = 0; i < this.wornItems.size(); ++i) {
                InventoryItem inventoryItem = this.wornItems.getItemByIndex(i);
                ClothingItem clothingItem = inventoryItem.getClothingItem();
                if (clothingItem == null || !clothingItem.isReady() || !clothingItem.m_GUID.equals(string)) continue;
                ClothingItemReference clothingItemReference = new ClothingItemReference();
                clothingItemReference.itemGUID = string;
                clothingItemReference.randomize();
                inventoryItem.getVisual().synchWithOutfit(clothingItemReference);
                inventoryItem.synchWithVisual();
                this.resetModelNextFrame();
            }
        }
    }

    public void reloadOutfit() {
        ModelManager.instance.Reset(this);
    }

    public boolean isSceneCulled() {
        return this.m_isCulled;
    }

    public void setSceneCulled(boolean bl) {
        if (this.isSceneCulled() == bl) {
            return;
        }
        try {
            if (bl) {
                ModelManager.instance.Remove(this);
            } else {
                ModelManager.instance.Add(this);
            }
        }
        catch (Exception exception) {
            System.err.println("Error in IsoGameCharacter.setSceneCulled(" + bl + "):");
            ExceptionLogger.logException(exception);
            ModelManager.instance.Remove(this);
            this.legsSprite.modelSlot = null;
        }
    }

    public void onCullStateChanged(ModelManager modelManager, boolean bl) {
        this.m_isCulled = bl;
        if (!bl) {
            this.restoreAnimatorStateToActionContext();
            DebugFileWatcher.instance.add(this.m_animStateTriggerWatcher);
            OutfitManager.instance.addClothingItemListener(this);
        } else {
            DebugFileWatcher.instance.remove(this.m_animStateTriggerWatcher);
            OutfitManager.instance.removeClothingItemListener(this);
        }
    }

    public void dressInRandomOutfit() {
        Outfit outfit;
        if (DebugLog.isEnabled(DebugType.Clothing)) {
            DebugLog.Clothing.println("IsoGameCharacter.dressInRandomOutfit>");
        }
        if ((outfit = OutfitManager.instance.GetRandomOutfit(this.isFemale())) != null) {
            this.dressInNamedOutfit(outfit.m_Name);
        }
    }

    @Override
    public void dressInNamedOutfit(String string) {
    }

    @Override
    public void dressInPersistentOutfit(String string) {
        int n = PersistentOutfits.instance.pickOutfit(string, this.isFemale());
        this.dressInPersistentOutfitID(n);
    }

    @Override
    public void dressInPersistentOutfitID(int n) {
    }

    @Override
    public String getOutfitName() {
        if (this instanceof IHumanVisual) {
            HumanVisual humanVisual = ((IHumanVisual)((Object)this)).getHumanVisual();
            Outfit outfit = humanVisual.getOutfit();
            return outfit == null ? null : outfit.m_Name;
        }
        return null;
    }

    public void dressInClothingItem(String string) {
    }

    public Outfit getRandomDefaultOutfit() {
        IsoGridSquare isoGridSquare = this.getCurrentSquare();
        IsoRoom isoRoom = isoGridSquare == null ? null : isoGridSquare.getRoom();
        String string = isoRoom == null ? null : isoRoom.getName();
        return ZombiesZoneDefinition.getRandomDefaultOutfit(this.isFemale(), string);
    }

    public ModelInstance getModel() {
        if (this.legsSprite != null && this.legsSprite.modelSlot != null) {
            return this.legsSprite.modelSlot.model;
        }
        return null;
    }

    public boolean hasActiveModel() {
        return this.legsSprite != null && this.legsSprite.hasActiveModel();
    }

    @Override
    public boolean hasItems(String string, int n) {
        int n2 = this.inventory.getItemCount(string);
        return n <= n2;
    }

    public int getLevelUpLevels(int n) {
        if (LevelUpLevels.length <= n) {
            return LevelUpLevels[LevelUpLevels.length - 1];
        }
        return LevelUpLevels[n];
    }

    public int getLevelMaxForXp() {
        return LevelUpLevels.length;
    }

    @Override
    public int getXpForLevel(int n) {
        if (n < LevelUpLevels.length) {
            return (int)((float)LevelUpLevels[n] * this.LevelUpMultiplier);
        }
        return (int)((float)(LevelUpLevels[LevelUpLevels.length - 1] + (n - LevelUpLevels.length + 1) * 400) * this.LevelUpMultiplier);
    }

    public void DoDeath(HandWeapon handWeapon, IsoGameCharacter isoGameCharacter) {
        this.DoDeath(handWeapon, isoGameCharacter, true);
    }

    public void DoDeath(HandWeapon handWeapon, IsoGameCharacter isoGameCharacter, boolean bl) {
        this.OnDeath();
        if (this.getAttackedBy() instanceof IsoPlayer && GameServer.bServer && this instanceof IsoPlayer) {
            Object object = "";
            Object object2 = "";
            if (SteamUtils.isSteamModeEnabled()) {
                object = " (" + ((IsoPlayer)this.getAttackedBy()).getSteamID() + ") ";
                object2 = " (" + ((IsoPlayer)this).getSteamID() + ") ";
            }
            LoggerManager.getLogger("pvp").write("user " + ((IsoPlayer)this.getAttackedBy()).username + (String)object + " killed " + ((IsoPlayer)this).username + (String)object2 + " " + LoggerManager.getPlayerCoords((IsoPlayer)this), "IMPORTANT");
            if (ServerOptions.instance.AnnounceDeath.getValue()) {
                ChatServer.getInstance().sendMessageToServerChat(((IsoPlayer)this.getAttackedBy()).username + " killed " + ((IsoPlayer)this).username + ".");
            }
            ChatServer.getInstance().sendMessageToAdminChat("user " + ((IsoPlayer)this.getAttackedBy()).username + " killed " + ((IsoPlayer)this).username);
        } else {
            if (GameServer.bServer && this instanceof IsoPlayer) {
                LoggerManager.getLogger("user").write("user " + ((IsoPlayer)this).username + " died at " + LoggerManager.getPlayerCoords((IsoPlayer)this) + " (non pvp)");
            }
            if (ServerOptions.instance.AnnounceDeath.getValue() && this instanceof IsoPlayer && GameServer.bServer) {
                ChatServer.getInstance().sendMessageToServerChat(((IsoPlayer)this).username + " is dead.");
            }
        }
        if (this.isDead()) {
            int n;
            float f = 0.5f;
            if (this.isZombie() && (((IsoZombie)this).bCrawling || this.getCurrentState() == ZombieOnGroundState.instance())) {
                f = 0.2f;
            }
            if (GameServer.bServer && bl) {
                boolean bl2 = this.isOnFloor() && isoGameCharacter instanceof IsoPlayer && handWeapon != null && "BareHands".equals(handWeapon.getType());
                GameServer.sendBloodSplatter(handWeapon, this.getX(), this.getY(), this.getZ() + f, this.getHitDir(), this.isCloseKilled(), bl2);
            }
            if (handWeapon != null && SandboxOptions.instance.BloodLevel.getValue() > 1 && bl) {
                int n2 = handWeapon.getSplatNumber();
                if (n2 < 1) {
                    n2 = 1;
                }
                if (Core.bLastStand) {
                    n2 *= 3;
                }
                switch (SandboxOptions.instance.BloodLevel.getValue()) {
                    case 2: {
                        n2 /= 2;
                        break;
                    }
                    case 4: {
                        n2 *= 2;
                        break;
                    }
                    case 5: {
                        n2 *= 5;
                    }
                }
                for (n = 0; n < n2; ++n) {
                    this.splatBlood(3, 0.3f);
                }
            }
            if (handWeapon != null && SandboxOptions.instance.BloodLevel.getValue() > 1 && bl) {
                this.splatBloodFloorBig();
            }
            if (isoGameCharacter != null && isoGameCharacter.xp != null) {
                isoGameCharacter.xp.AddXP(handWeapon, 3);
            }
            if (SandboxOptions.instance.BloodLevel.getValue() > 1 && this.isOnFloor() && isoGameCharacter instanceof IsoPlayer && handWeapon == ((IsoPlayer)isoGameCharacter).bareHands && bl) {
                this.playBloodSplatterSound();
                for (int i = -1; i <= 1; ++i) {
                    for (n = -1; n <= 1; ++n) {
                        if (i == 0 && n == 0) continue;
                        new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f, (float)i * Rand.Next(0.25f, 0.5f), (float)n * Rand.Next(0.25f, 0.5f));
                    }
                }
                new IsoZombieGiblets(IsoZombieGiblets.GibletType.Eye, this.getCell(), this.getX(), this.getY(), this.getZ() + f, this.getHitDir().x * 0.8f, this.getHitDir().y * 0.8f);
            } else if (SandboxOptions.instance.BloodLevel.getValue() > 1 && bl) {
                this.playBloodSplatterSound();
                new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f, this.getHitDir().x * 1.5f, this.getHitDir().y * 1.5f);
                IsoGameCharacter.tempo.x = this.getHitDir().x;
                IsoGameCharacter.tempo.y = this.getHitDir().y;
                int n3 = 3;
                n = 0;
                int n4 = 1;
                switch (SandboxOptions.instance.BloodLevel.getValue()) {
                    case 1: {
                        n4 = 0;
                        break;
                    }
                    case 2: {
                        n4 = 1;
                        n3 = 5;
                        n = 2;
                        break;
                    }
                    case 4: {
                        n4 = 3;
                        n3 = 2;
                        break;
                    }
                    case 5: {
                        n4 = 10;
                        n3 = 0;
                    }
                }
                for (int i = 0; i < n4; ++i) {
                    if (Rand.Next(this.isCloseKilled() ? 8 : n3) == 0) {
                        new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f, this.getHitDir().x * 1.5f, this.getHitDir().y * 1.5f);
                    }
                    if (Rand.Next(this.isCloseKilled() ? 8 : n3) == 0) {
                        new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f, this.getHitDir().x * 1.5f, this.getHitDir().y * 1.5f);
                    }
                    if (Rand.Next(this.isCloseKilled() ? 8 : n3) == 0) {
                        new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f, this.getHitDir().x * 1.8f, this.getHitDir().y * 1.8f);
                    }
                    if (Rand.Next(this.isCloseKilled() ? 8 : n3) == 0) {
                        new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f, this.getHitDir().x * 1.9f, this.getHitDir().y * 1.9f);
                    }
                    if (Rand.Next(this.isCloseKilled() ? 4 : n) == 0) {
                        new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f, this.getHitDir().x * 3.5f, this.getHitDir().y * 3.5f);
                    }
                    if (Rand.Next(this.isCloseKilled() ? 4 : n) == 0) {
                        new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f, this.getHitDir().x * 3.8f, this.getHitDir().y * 3.8f);
                    }
                    if (Rand.Next(this.isCloseKilled() ? 4 : n) == 0) {
                        new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f, this.getHitDir().x * 3.9f, this.getHitDir().y * 3.9f);
                    }
                    if (Rand.Next(this.isCloseKilled() ? 4 : n) == 0) {
                        new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f, this.getHitDir().x * 1.5f, this.getHitDir().y * 1.5f);
                    }
                    if (Rand.Next(this.isCloseKilled() ? 4 : n) == 0) {
                        new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f, this.getHitDir().x * 3.8f, this.getHitDir().y * 3.8f);
                    }
                    if (Rand.Next(this.isCloseKilled() ? 4 : n) == 0) {
                        new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, this.getCell(), this.getX(), this.getY(), this.getZ() + f, this.getHitDir().x * 3.9f, this.getHitDir().y * 3.9f);
                    }
                    if (Rand.Next(this.isCloseKilled() ? 9 : 6) != 0) continue;
                    new IsoZombieGiblets(IsoZombieGiblets.GibletType.Eye, this.getCell(), this.getX(), this.getY(), this.getZ() + f, this.getHitDir().x * 0.8f, this.getHitDir().y * 0.8f);
                }
            }
        }
        if (this.isDoDeathSound()) {
            this.playDeadSound();
        }
        this.setDoDeathSound(false);
    }

    private boolean TestIfSeen(int n) {
        float f;
        IsoPlayer isoPlayer = IsoPlayer.players[n];
        if (isoPlayer == null || this == isoPlayer || GameServer.bServer) {
            return false;
        }
        float f2 = this.DistToProper(isoPlayer);
        if (f2 > GameTime.getInstance().getViewDist()) {
            return false;
        }
        boolean bl = this.current.isCanSee(n);
        if (!bl && this.current.isCouldSee(n)) {
            boolean bl2 = bl = f2 < isoPlayer.getSeeNearbyCharacterDistance();
        }
        if (!bl) {
            return false;
        }
        ColorInfo colorInfo = this.getCurrentSquare().lighting[n].lightInfo();
        float f3 = (colorInfo.r + colorInfo.g + colorInfo.b) / 3.0f;
        if (f3 > 0.6f) {
            f3 = 1.0f;
        }
        float f4 = 1.0f - f2 / GameTime.getInstance().getViewDist();
        if (f3 == 1.0f && f4 > 0.3f) {
            f4 = 1.0f;
        }
        if ((f = isoPlayer.getDotWithForwardDirection(this.getX(), this.getY())) < 0.5f) {
            f = 0.5f;
        }
        if ((f3 *= f) < 0.0f) {
            f3 = 0.0f;
        }
        if (f2 <= 1.0f) {
            f4 = 1.0f;
            f3 *= 2.0f;
        }
        f3 *= f4;
        return (f3 *= 100.0f) > 0.025f;
    }

    private void DoLand() {
        if (this.fallTime < 20.0f || this.isClimbing()) {
            return;
        }
        if (this instanceof IsoPlayer) {
            if (GameServer.bServer) {
                return;
            }
            if (GameClient.bClient && ((IsoPlayer)this).bRemote) {
                return;
            }
            if (((IsoPlayer)this).isGhostMode()) {
                return;
            }
        }
        if (this.isZombie()) {
            if (this.fallTime > 50.0f) {
                this.hitDir.y = 0.0f;
                this.hitDir.x = 0.0f;
                if (!((IsoZombie)this).bCrawling && (Rand.Next(100) < 80 || this.fallTime > 80.0f)) {
                    this.setVariable("bHardFall", true);
                }
                this.playHurtSound();
                float f = (float)Rand.Next(150) / 1000.0f;
                this.Health -= f * this.fallTime / 50.0f;
                this.setAttackedBy(null);
            }
            return;
        }
        boolean bl = Rand.Next(80) == 0;
        float f = this.fallTime;
        f *= Math.min(1.8f, this.getInventory().getCapacityWeight() / this.getInventory().getMaxWeight());
        if (this.getCurrentSquare().getFloor() != null && this.getCurrentSquare().getFloor().getSprite().getName() != null && this.getCurrentSquare().getFloor().getSprite().getName().startsWith("blends_natural")) {
            f *= 0.8f;
            if (!bl) {
                boolean bl2 = bl = Rand.Next(65) == 0;
            }
        }
        if (bl) {
            return;
        }
        if (this.Traits.Obese.isSet() || this.Traits.Emaciated.isSet()) {
            f *= 1.4f;
        }
        if (this.Traits.Overweight.isSet() || this.Traits.VeryUnderweight.isSet()) {
            f *= 1.2f;
        }
        f *= Math.max(0.1f, 1.0f - (float)this.getPerkLevel(PerkFactory.Perks.Fitness) * 0.1f);
        if (this.fallTime > 135.0f) {
            f = 1000.0f;
        }
        this.BodyDamage.ReduceGeneralHealth(f);
        LuaEventManager.triggerEvent("OnPlayerGetDamage", this, "FALLDOWN", Float.valueOf(f));
        if (this.fallTime > 70.0f) {
            int n = 100 - (int)((double)this.fallTime * 0.6);
            if (this.getInventory().getMaxWeight() - this.getInventory().getCapacityWeight() < 2.0f) {
                n = (int)((float)n - this.getInventory().getCapacityWeight() / this.getInventory().getMaxWeight() * 100.0f / 5.0f);
            }
            if (this.Traits.Obese.isSet() || this.Traits.Emaciated.isSet()) {
                n -= 20;
            }
            if (this.Traits.Overweight.isSet() || this.Traits.VeryUnderweight.isSet()) {
                n -= 10;
            }
            if (this.getPerkLevel(PerkFactory.Perks.Fitness) > 4) {
                n += (this.getPerkLevel(PerkFactory.Perks.Fitness) - 4) * 3;
            }
            if (Rand.Next(100) >= n) {
                if (!SandboxOptions.instance.BoneFracture.getValue()) {
                    return;
                }
                float f2 = Rand.Next(50, 80);
                if (this.Traits.FastHealer.isSet()) {
                    f2 = Rand.Next(30, 50);
                } else if (this.Traits.SlowHealer.isSet()) {
                    f2 = Rand.Next(80, 150);
                }
                switch (SandboxOptions.instance.InjurySeverity.getValue()) {
                    case 1: {
                        f2 *= 0.5f;
                        break;
                    }
                    case 3: {
                        f2 *= 1.5f;
                    }
                }
                this.getBodyDamage().getBodyPart(BodyPartType.FromIndex(Rand.Next(BodyPartType.ToIndex(BodyPartType.UpperLeg_L), BodyPartType.ToIndex(BodyPartType.Foot_R) + 1))).setFractureTime(f2);
            } else if (Rand.Next(100) >= n - 10) {
                this.getBodyDamage().getBodyPart(BodyPartType.FromIndex(Rand.Next(BodyPartType.ToIndex(BodyPartType.UpperLeg_L), BodyPartType.ToIndex(BodyPartType.Foot_R) + 1))).generateDeepWound();
            }
        }
    }

    public IsoGameCharacter getFollowingTarget() {
        return this.FollowingTarget;
    }

    public void setFollowingTarget(IsoGameCharacter isoGameCharacter) {
        this.FollowingTarget = isoGameCharacter;
    }

    public ArrayList<IsoMovingObject> getLocalList() {
        return this.LocalList;
    }

    public ArrayList<IsoMovingObject> getLocalNeutralList() {
        return this.LocalNeutralList;
    }

    public ArrayList<IsoMovingObject> getLocalGroupList() {
        return this.LocalGroupList;
    }

    public ArrayList<IsoMovingObject> getLocalRelevantEnemyList() {
        return this.LocalRelevantEnemyList;
    }

    public float getDangerLevels() {
        return this.dangerLevels;
    }

    public void setDangerLevels(float f) {
        this.dangerLevels = f;
    }

    public ArrayList<PerkInfo> getPerkList() {
        return this.PerkList;
    }

    public float getLeaveBodyTimedown() {
        return this.leaveBodyTimedown;
    }

    public void setLeaveBodyTimedown(float f) {
        this.leaveBodyTimedown = f;
    }

    public boolean isAllowConversation() {
        return this.AllowConversation;
    }

    public void setAllowConversation(boolean bl) {
        this.AllowConversation = bl;
    }

    public float getReanimateTimer() {
        return this.ReanimateTimer;
    }

    public void setReanimateTimer(float f) {
        this.ReanimateTimer = f;
    }

    public int getReanimAnimFrame() {
        return this.ReanimAnimFrame;
    }

    public void setReanimAnimFrame(int n) {
        this.ReanimAnimFrame = n;
    }

    public int getReanimAnimDelay() {
        return this.ReanimAnimDelay;
    }

    public void setReanimAnimDelay(int n) {
        this.ReanimAnimDelay = n;
    }

    public boolean isReanim() {
        return this.Reanim;
    }

    public void setReanim(boolean bl) {
        this.Reanim = bl;
    }

    public boolean isVisibleToNPCs() {
        return this.VisibleToNPCs;
    }

    public void setVisibleToNPCs(boolean bl) {
        this.VisibleToNPCs = bl;
    }

    public int getDieCount() {
        return this.DieCount;
    }

    public void setDieCount(int n) {
        this.DieCount = n;
    }

    public float getLlx() {
        return this.llx;
    }

    public void setLlx(float f) {
        this.llx = f;
    }

    public float getLly() {
        return this.lly;
    }

    public void setLly(float f) {
        this.lly = f;
    }

    public float getLlz() {
        return this.llz;
    }

    public void setLlz(float f) {
        this.llz = f;
    }

    public int getRemoteID() {
        return this.RemoteID;
    }

    public void setRemoteID(int n) {
        this.RemoteID = n;
    }

    public int getNumSurvivorsInVicinity() {
        return this.NumSurvivorsInVicinity;
    }

    public void setNumSurvivorsInVicinity(int n) {
        this.NumSurvivorsInVicinity = n;
    }

    public float getLevelUpMultiplier() {
        return this.LevelUpMultiplier;
    }

    public void setLevelUpMultiplier(float f) {
        this.LevelUpMultiplier = f;
    }

    @Override
    public XP getXp() {
        return this.xp;
    }

    @Deprecated
    public void setXp(XP xP) {
        this.xp = xP;
    }

    public int getLastLocalEnemies() {
        return this.LastLocalEnemies;
    }

    public void setLastLocalEnemies(int n) {
        this.LastLocalEnemies = n;
    }

    public ArrayList<IsoMovingObject> getVeryCloseEnemyList() {
        return this.VeryCloseEnemyList;
    }

    public HashMap<String, Location> getLastKnownLocation() {
        return this.LastKnownLocation;
    }

    public IsoGameCharacter getAttackedBy() {
        return this.AttackedBy;
    }

    public void setAttackedBy(IsoGameCharacter isoGameCharacter) {
        this.AttackedBy = isoGameCharacter;
    }

    public boolean isIgnoreStaggerBack() {
        return this.IgnoreStaggerBack;
    }

    public void setIgnoreStaggerBack(boolean bl) {
        this.IgnoreStaggerBack = bl;
    }

    public boolean isAttackWasSuperAttack() {
        return this.AttackWasSuperAttack;
    }

    public void setAttackWasSuperAttack(boolean bl) {
        this.AttackWasSuperAttack = bl;
    }

    public int getTimeThumping() {
        return this.TimeThumping;
    }

    public void setTimeThumping(int n) {
        this.TimeThumping = n;
    }

    public int getPatienceMax() {
        return this.PatienceMax;
    }

    public void setPatienceMax(int n) {
        this.PatienceMax = n;
    }

    public int getPatienceMin() {
        return this.PatienceMin;
    }

    public void setPatienceMin(int n) {
        this.PatienceMin = n;
    }

    public int getPatience() {
        return this.Patience;
    }

    public void setPatience(int n) {
        this.Patience = n;
    }

    @Override
    public Stack<BaseAction> getCharacterActions() {
        return this.CharacterActions;
    }

    public boolean hasTimedActions() {
        return !this.CharacterActions.isEmpty() || this.getVariableBoolean("IsPerformingAnAction");
    }

    public Vector2 getForwardDirection() {
        return this.m_forwardDirection;
    }

    public void setForwardDirection(Vector2 vector22) {
        if (vector22 == null) {
            return;
        }
        this.setForwardDirection(vector22.x, vector22.y);
    }

    public void setForwardDirection(float f, float f2) {
        this.m_forwardDirection.x = f;
        this.m_forwardDirection.y = f2;
    }

    public void zeroForwardDirectionX() {
        this.setForwardDirection(0.0f, 1.0f);
    }

    public void zeroForwardDirectionY() {
        this.setForwardDirection(1.0f, 0.0f);
    }

    public float getDirectionAngle() {
        return 57.295776f * this.getForwardDirection().getDirection();
    }

    public void setDirectionAngle(float f) {
        float f2 = (float)Math.PI / 180 * f;
        Vector2 vector22 = this.getForwardDirection();
        vector22.setDirection(f2);
    }

    public float getAnimAngle() {
        if (this.m_animPlayer == null || !this.m_animPlayer.isReady() || this.m_animPlayer.isBoneTransformsNeedFirstFrame()) {
            return this.getDirectionAngle();
        }
        return 57.295776f * this.m_animPlayer.getAngle();
    }

    public float getAnimAngleRadians() {
        if (this.m_animPlayer == null || !this.m_animPlayer.isReady() || this.m_animPlayer.isBoneTransformsNeedFirstFrame()) {
            return this.m_forwardDirection.getDirection();
        }
        return this.m_animPlayer.getAngle();
    }

    public Vector2 getAnimVector(Vector2 vector22) {
        return vector22.setLengthAndDirection(this.getAnimAngleRadians(), 1.0f);
    }

    public float getLookAngleRadians() {
        if (this.m_animPlayer == null || !this.m_animPlayer.isReady()) {
            return this.getForwardDirection().getDirection();
        }
        return this.m_animPlayer.getAngle() + this.m_animPlayer.getTwistAngle();
    }

    public Vector2 getLookVector(Vector2 vector22) {
        return vector22.setLengthAndDirection(this.getLookAngleRadians(), 1.0f);
    }

    public float getDotWithForwardDirection(Vector3 vector3) {
        return this.getDotWithForwardDirection(vector3.x, vector3.y);
    }

    public float getDotWithForwardDirection(float f, float f2) {
        Vector2 vector22 = L_getDotWithForwardDirection.v1.set(f - this.getX(), f2 - this.getY());
        vector22.normalize();
        Vector2 vector23 = this.getLookVector(L_getDotWithForwardDirection.v2);
        vector23.normalize();
        return vector22.dot(vector23);
    }

    @Override
    public boolean isAsleep() {
        return this.Asleep;
    }

    @Override
    public void setAsleep(boolean bl) {
        this.Asleep = bl;
    }

    @Override
    public int getZombieKills() {
        return this.ZombieKills;
    }

    public void setZombieKills(int n) {
        this.ZombieKills = n;
    }

    public int getLastZombieKills() {
        return this.LastZombieKills;
    }

    public void setLastZombieKills(int n) {
        this.LastZombieKills = n;
    }

    public boolean isSuperAttack() {
        return this.superAttack;
    }

    public void setSuperAttack(boolean bl) {
        this.superAttack = bl;
    }

    public float getForceWakeUpTime() {
        return this.ForceWakeUpTime;
    }

    @Override
    public void setForceWakeUpTime(float f) {
        this.ForceWakeUpTime = f;
    }

    public void forceAwake() {
        if (this.isAsleep()) {
            this.ForceWakeUp = true;
        }
    }

    @Override
    public BodyDamage getBodyDamage() {
        return this.BodyDamage;
    }

    @Override
    public BodyDamage getBodyDamageRemote() {
        if (this.BodyDamageRemote == null) {
            this.BodyDamageRemote = new BodyDamage(null);
        }
        return this.BodyDamageRemote;
    }

    public void resetBodyDamageRemote() {
        this.BodyDamageRemote = null;
    }

    public State getDefaultState() {
        return this.defaultState;
    }

    public void setDefaultState(State state) {
        this.defaultState = state;
    }

    @Override
    public SurvivorDesc getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void setDescriptor(SurvivorDesc survivorDesc) {
        this.descriptor = survivorDesc;
    }

    @Override
    public String getFullName() {
        if (this.descriptor != null) {
            return this.descriptor.forename + " " + this.descriptor.surname;
        }
        return "Bob Smith";
    }

    @Override
    public BaseVisual getVisual() {
        throw new RuntimeException("subclasses must implement this");
    }

    public ItemVisuals getItemVisuals() {
        throw new RuntimeException("subclasses must implement this");
    }

    public void getItemVisuals(ItemVisuals itemVisuals) {
        this.getWornItems().getItemVisuals(itemVisuals);
    }

    public boolean isUsingWornItems() {
        return this.wornItems != null;
    }

    public Stack<IsoBuilding> getFamiliarBuildings() {
        return this.FamiliarBuildings;
    }

    public AStarPathFinderResult getFinder() {
        return this.finder;
    }

    public float getFireKillRate() {
        return this.FireKillRate;
    }

    public void setFireKillRate(float f) {
        this.FireKillRate = f;
    }

    public int getFireSpreadProbability() {
        return this.FireSpreadProbability;
    }

    public void setFireSpreadProbability(int n) {
        this.FireSpreadProbability = n;
    }

    @Override
    public float getHealth() {
        return this.Health;
    }

    @Override
    public void setHealth(float f) {
        this.Health = f;
    }

    @Override
    public boolean isOnDeathDone() {
        return this.bDead;
    }

    @Override
    public void setOnDeathDone(boolean bl) {
        this.bDead = bl;
    }

    @Override
    public boolean isOnKillDone() {
        return this.bKill;
    }

    @Override
    public void setOnKillDone(boolean bl) {
        this.bKill = bl;
    }

    @Override
    public boolean isDeathDragDown() {
        return this.bDeathDragDown;
    }

    @Override
    public void setDeathDragDown(boolean bl) {
        this.bDeathDragDown = bl;
    }

    @Override
    public boolean isPlayingDeathSound() {
        return this.bPlayingDeathSound;
    }

    @Override
    public void setPlayingDeathSound(boolean bl) {
        this.bPlayingDeathSound = bl;
    }

    public String getHurtSound() {
        return this.hurtSound;
    }

    public void setHurtSound(String string) {
        this.hurtSound = string;
    }

    @Deprecated
    public boolean isIgnoreMovementForDirection() {
        return false;
    }

    @Override
    public ItemContainer getInventory() {
        return this.inventory;
    }

    public void setInventory(ItemContainer itemContainer) {
        itemContainer.parent = this;
        this.inventory = itemContainer;
        this.inventory.setExplored(true);
    }

    public boolean isPrimaryEquipped(String string) {
        if (this.leftHandItem == null) {
            return false;
        }
        return this.leftHandItem.getFullType().equals(string) || this.leftHandItem.getType().equals(string);
    }

    @Override
    public InventoryItem getPrimaryHandItem() {
        return this.leftHandItem;
    }

    @Override
    public void setPrimaryHandItem(InventoryItem inventoryItem) {
        this.setEquipParent(this.leftHandItem, inventoryItem);
        this.leftHandItem = inventoryItem;
        if (GameClient.bClient && this instanceof IsoPlayer && ((IsoPlayer)this).isLocalPlayer()) {
            GameClient.instance.equip((IsoPlayer)this, 0);
        }
        LuaEventManager.triggerEvent("OnEquipPrimary", this, inventoryItem);
        this.resetEquippedHandsModels();
        this.setVariable("Weapon", WeaponType.getWeaponType((IsoGameCharacter)this).type);
        if (inventoryItem != null && inventoryItem instanceof HandWeapon && !StringUtils.isNullOrEmpty(((HandWeapon)inventoryItem).getFireMode())) {
            this.setVariable("FireMode", ((HandWeapon)inventoryItem).getFireMode());
        } else {
            this.clearVariable("FireMode");
        }
    }

    protected void setEquipParent(InventoryItem inventoryItem, InventoryItem inventoryItem2) {
        if (inventoryItem != null) {
            inventoryItem.setEquipParent(null);
        }
        if (inventoryItem2 != null) {
            inventoryItem2.setEquipParent(this);
        }
    }

    public void initWornItems(String string) {
        BodyLocationGroup bodyLocationGroup = BodyLocations.getGroup(string);
        this.wornItems = new WornItems(bodyLocationGroup);
    }

    @Override
    public WornItems getWornItems() {
        return this.wornItems;
    }

    @Override
    public void setWornItems(WornItems wornItems) {
        this.wornItems = new WornItems(wornItems);
    }

    @Override
    public InventoryItem getWornItem(String string) {
        return this.wornItems.getItem(string);
    }

    @Override
    public void setWornItem(String string, InventoryItem inventoryItem) {
        this.setWornItem(string, inventoryItem, true);
    }

    public void setWornItem(String string, InventoryItem inventoryItem, boolean bl) {
        InventoryItem inventoryItem2 = this.wornItems.getItem(string);
        if (inventoryItem == inventoryItem2) {
            return;
        }
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        if (inventoryItem2 != null && isoCell != null) {
            isoCell.addToProcessItemsRemove(inventoryItem2);
        }
        this.wornItems.setItem(string, inventoryItem);
        if (inventoryItem != null && isoCell != null) {
            if (inventoryItem.getContainer() != null) {
                inventoryItem.getContainer().parent = this;
            }
            isoCell.addToProcessItems(inventoryItem);
        }
        if (bl && inventoryItem2 != null && this instanceof IsoPlayer && !this.getInventory().hasRoomFor(this, inventoryItem2)) {
            IsoGridSquare isoGridSquare = this.getCurrentSquare();
            isoGridSquare = this.getSolidFloorAt(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z);
            if (isoGridSquare != null) {
                float f = Rand.Next(0.1f, 0.9f);
                float f2 = Rand.Next(0.1f, 0.9f);
                float f3 = isoGridSquare.getApparentZ(f, f2) - (float)isoGridSquare.getZ();
                isoGridSquare.AddWorldInventoryItem(inventoryItem2, f, f2, f3);
                this.getInventory().Remove(inventoryItem2);
            }
        }
        this.resetModelNextFrame();
        if (this.clothingWetness != null) {
            this.clothingWetness.changed = true;
        }
        if (GameClient.bClient && this instanceof IsoPlayer && ((IsoPlayer)this).isLocalPlayer()) {
            GameClient.instance.sendClothing((IsoPlayer)this, string, inventoryItem);
        }
        this.onWornItemsChanged();
    }

    @Override
    public void removeWornItem(InventoryItem inventoryItem) {
        this.removeWornItem(inventoryItem, true);
    }

    public void removeWornItem(InventoryItem inventoryItem, boolean bl) {
        String string = this.wornItems.getLocation(inventoryItem);
        if (string == null) {
            return;
        }
        this.setWornItem(string, null, bl);
    }

    @Override
    public void clearWornItems() {
        if (this.wornItems == null) {
            return;
        }
        this.wornItems.clear();
        if (this.clothingWetness != null) {
            this.clothingWetness.changed = true;
        }
        this.onWornItemsChanged();
    }

    @Override
    public BodyLocationGroup getBodyLocationGroup() {
        if (this.wornItems == null) {
            return null;
        }
        return this.wornItems.getBodyLocationGroup();
    }

    public void onWornItemsChanged() {
    }

    public void initAttachedItems(String string) {
        AttachedLocationGroup attachedLocationGroup = AttachedLocations.getGroup(string);
        this.attachedItems = new AttachedItems(attachedLocationGroup);
    }

    @Override
    public AttachedItems getAttachedItems() {
        return this.attachedItems;
    }

    @Override
    public void setAttachedItems(AttachedItems attachedItems) {
        this.attachedItems = new AttachedItems(attachedItems);
    }

    @Override
    public InventoryItem getAttachedItem(String string) {
        return this.attachedItems.getItem(string);
    }

    @Override
    public void setAttachedItem(String string, InventoryItem inventoryItem) {
        Object object;
        InventoryItem inventoryItem2 = this.attachedItems.getItem(string);
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        if (inventoryItem2 != null && isoCell != null) {
            isoCell.addToProcessItemsRemove(inventoryItem2);
        }
        this.attachedItems.setItem(string, inventoryItem);
        if (inventoryItem != null && isoCell != null) {
            object = Type.tryCastTo(inventoryItem, InventoryContainer.class);
            if (object != null && ((InventoryContainer)object).getInventory() != null) {
                ((InventoryContainer)object).getInventory().parent = this;
            }
            isoCell.addToProcessItems(inventoryItem);
        }
        this.resetEquippedHandsModels();
        object = Type.tryCastTo(this, IsoPlayer.class);
        if (GameClient.bClient && object != null && ((IsoPlayer)object).isLocalPlayer()) {
            GameClient.instance.sendAttachedItem((IsoPlayer)object, string, inventoryItem);
        }
        if (!GameServer.bServer && object != null && ((IsoPlayer)object).isLocalPlayer()) {
            LuaEventManager.triggerEvent("OnClothingUpdated", this);
        }
    }

    @Override
    public void removeAttachedItem(InventoryItem inventoryItem) {
        String string = this.attachedItems.getLocation(inventoryItem);
        if (string == null) {
            return;
        }
        this.setAttachedItem(string, null);
    }

    @Override
    public void clearAttachedItems() {
        if (this.attachedItems == null) {
            return;
        }
        this.attachedItems.clear();
    }

    @Override
    public AttachedLocationGroup getAttachedLocationGroup() {
        if (this.attachedItems == null) {
            return null;
        }
        return this.attachedItems.getGroup();
    }

    public ClothingWetness getClothingWetness() {
        return this.clothingWetness;
    }

    public InventoryItem getClothingItem_Head() {
        return this.getWornItem("Hat");
    }

    @Override
    public void setClothingItem_Head(InventoryItem inventoryItem) {
        this.setWornItem("Hat", inventoryItem);
    }

    public InventoryItem getClothingItem_Torso() {
        return this.getWornItem("Tshirt");
    }

    @Override
    public void setClothingItem_Torso(InventoryItem inventoryItem) {
        this.setWornItem("Tshirt", inventoryItem);
    }

    public InventoryItem getClothingItem_Back() {
        return this.getWornItem("Back");
    }

    @Override
    public void setClothingItem_Back(InventoryItem inventoryItem) {
        this.setWornItem("Back", inventoryItem);
    }

    public InventoryItem getClothingItem_Hands() {
        return this.getWornItem("Hands");
    }

    @Override
    public void setClothingItem_Hands(InventoryItem inventoryItem) {
        this.setWornItem("Hands", inventoryItem);
    }

    public InventoryItem getClothingItem_Legs() {
        return this.getWornItem("Pants");
    }

    @Override
    public void setClothingItem_Legs(InventoryItem inventoryItem) {
        this.setWornItem("Pants", inventoryItem);
    }

    public InventoryItem getClothingItem_Feet() {
        return this.getWornItem("Shoes");
    }

    @Override
    public void setClothingItem_Feet(InventoryItem inventoryItem) {
        this.setWornItem("Shoes", inventoryItem);
    }

    public int getNextWander() {
        return this.NextWander;
    }

    public void setNextWander(int n) {
        this.NextWander = n;
    }

    @Override
    public boolean isOnFire() {
        return this.OnFire;
    }

    public void setOnFire(boolean bl) {
        this.OnFire = bl;
        if (GameServer.bServer) {
            if (bl) {
                IsoFireManager.addCharacterOnFire(this);
            } else {
                IsoFireManager.deleteCharacterOnFire(this);
            }
        }
    }

    @Override
    public void removeFromWorld() {
        if (GameServer.bServer) {
            IsoFireManager.deleteCharacterOnFire(this);
        }
        super.removeFromWorld();
    }

    public int getPathIndex() {
        return this.pathIndex;
    }

    public void setPathIndex(int n) {
        this.pathIndex = n;
    }

    public int getPathTargetX() {
        return (int)this.getPathFindBehavior2().getTargetX();
    }

    public int getPathTargetY() {
        return (int)this.getPathFindBehavior2().getTargetY();
    }

    public int getPathTargetZ() {
        return (int)this.getPathFindBehavior2().getTargetZ();
    }

    @Override
    public InventoryItem getSecondaryHandItem() {
        return this.rightHandItem;
    }

    @Override
    public void setSecondaryHandItem(InventoryItem inventoryItem) {
        this.setEquipParent(this.rightHandItem, inventoryItem);
        this.rightHandItem = inventoryItem;
        if (GameClient.bClient && this instanceof IsoPlayer && ((IsoPlayer)this).isLocalPlayer()) {
            GameClient.instance.equip((IsoPlayer)this, 1);
        }
        LuaEventManager.triggerEvent("OnEquipSecondary", this, inventoryItem);
        this.resetEquippedHandsModels();
        this.setVariable("Weapon", WeaponType.getWeaponType((IsoGameCharacter)this).type);
    }

    @Override
    public boolean isHandItem(InventoryItem inventoryItem) {
        return this.isPrimaryHandItem(inventoryItem) || this.isSecondaryHandItem(inventoryItem);
    }

    @Override
    public boolean isPrimaryHandItem(InventoryItem inventoryItem) {
        return inventoryItem != null && this.getPrimaryHandItem() == inventoryItem;
    }

    @Override
    public boolean isSecondaryHandItem(InventoryItem inventoryItem) {
        return inventoryItem != null && this.getSecondaryHandItem() == inventoryItem;
    }

    @Override
    public boolean isItemInBothHands(InventoryItem inventoryItem) {
        return this.isPrimaryHandItem(inventoryItem) && this.isSecondaryHandItem(inventoryItem);
    }

    @Override
    public boolean removeFromHands(InventoryItem inventoryItem) {
        boolean bl = true;
        if (this.isPrimaryHandItem(inventoryItem)) {
            this.setPrimaryHandItem(null);
        }
        if (this.isSecondaryHandItem(inventoryItem)) {
            this.setSecondaryHandItem(null);
        }
        return bl;
    }

    public Color getSpeakColour() {
        return this.SpeakColour;
    }

    public void setSpeakColour(Color color) {
        this.SpeakColour = color;
    }

    @Override
    public void setSpeakColourInfo(ColorInfo colorInfo) {
        this.SpeakColour = new Color(colorInfo.r, colorInfo.g, colorInfo.b, 1.0f);
    }

    public float getSlowFactor() {
        return this.slowFactor;
    }

    public void setSlowFactor(float f) {
        this.slowFactor = f;
    }

    public float getSlowTimer() {
        return this.slowTimer;
    }

    public void setSlowTimer(float f) {
        this.slowTimer = f;
    }

    public boolean isbUseParts() {
        return this.bUseParts;
    }

    public void setbUseParts(boolean bl) {
        this.bUseParts = bl;
    }

    @Override
    public boolean isSpeaking() {
        return this.IsSpeaking();
    }

    public void setSpeaking(boolean bl) {
        this.Speaking = bl;
    }

    public float getSpeakTime() {
        return this.SpeakTime;
    }

    public void setSpeakTime(int n) {
        this.SpeakTime = n;
    }

    public float getSpeedMod() {
        return this.speedMod;
    }

    public void setSpeedMod(float f) {
        this.speedMod = f;
    }

    public float getStaggerTimeMod() {
        return this.staggerTimeMod;
    }

    public void setStaggerTimeMod(float f) {
        this.staggerTimeMod = f;
    }

    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    @Override
    public Moodles getMoodles() {
        return this.Moodles;
    }

    @Override
    public Stats getStats() {
        return this.stats;
    }

    public Stack<String> getUsedItemsOn() {
        return this.UsedItemsOn;
    }

    public HandWeapon getUseHandWeapon() {
        return this.useHandWeapon;
    }

    public void setUseHandWeapon(HandWeapon handWeapon) {
        this.useHandWeapon = handWeapon;
    }

    public IsoSprite getLegsSprite() {
        return this.legsSprite;
    }

    public void setLegsSprite(IsoSprite isoSprite) {
        this.legsSprite = isoSprite;
    }

    public IsoGridSquare getAttackTargetSquare() {
        return this.attackTargetSquare;
    }

    public void setAttackTargetSquare(IsoGridSquare isoGridSquare) {
        this.attackTargetSquare = isoGridSquare;
    }

    public float getBloodImpactX() {
        return this.BloodImpactX;
    }

    public void setBloodImpactX(float f) {
        this.BloodImpactX = f;
    }

    public float getBloodImpactY() {
        return this.BloodImpactY;
    }

    public void setBloodImpactY(float f) {
        this.BloodImpactY = f;
    }

    public float getBloodImpactZ() {
        return this.BloodImpactZ;
    }

    public void setBloodImpactZ(float f) {
        this.BloodImpactZ = f;
    }

    public IsoSprite getBloodSplat() {
        return this.bloodSplat;
    }

    public void setBloodSplat(IsoSprite isoSprite) {
        this.bloodSplat = isoSprite;
    }

    public boolean isbOnBed() {
        return this.bOnBed;
    }

    public void setbOnBed(boolean bl) {
        this.bOnBed = bl;
    }

    public Vector2 getMoveForwardVec() {
        return this.moveForwardVec;
    }

    public void setMoveForwardVec(Vector2 vector22) {
        this.moveForwardVec.set(vector22);
    }

    public boolean isPathing() {
        return this.pathing;
    }

    public void setPathing(boolean bl) {
        this.pathing = bl;
    }

    public Stack<IsoGameCharacter> getLocalEnemyList() {
        return this.LocalEnemyList;
    }

    public Stack<IsoGameCharacter> getEnemyList() {
        return this.EnemyList;
    }

    @Override
    public TraitCollection getTraits() {
        return this.getCharacterTraits();
    }

    public CharacterTraits getCharacterTraits() {
        return this.Traits;
    }

    @Override
    public int getMaxWeight() {
        return this.maxWeight;
    }

    public void setMaxWeight(int n) {
        this.maxWeight = n;
    }

    public int getMaxWeightBase() {
        return this.maxWeightBase;
    }

    public void setMaxWeightBase(int n) {
        this.maxWeightBase = n;
    }

    public float getSleepingTabletDelta() {
        return this.SleepingTabletDelta;
    }

    public void setSleepingTabletDelta(float f) {
        this.SleepingTabletDelta = f;
    }

    public float getBetaEffect() {
        return this.BetaEffect;
    }

    public void setBetaEffect(float f) {
        this.BetaEffect = f;
    }

    public float getDepressEffect() {
        return this.DepressEffect;
    }

    public void setDepressEffect(float f) {
        this.DepressEffect = f;
    }

    @Override
    public float getSleepingTabletEffect() {
        return this.SleepingTabletEffect;
    }

    @Override
    public void setSleepingTabletEffect(float f) {
        this.SleepingTabletEffect = f;
    }

    public float getBetaDelta() {
        return this.BetaDelta;
    }

    public void setBetaDelta(float f) {
        this.BetaDelta = f;
    }

    public float getDepressDelta() {
        return this.DepressDelta;
    }

    public void setDepressDelta(float f) {
        this.DepressDelta = f;
    }

    public float getPainEffect() {
        return this.PainEffect;
    }

    public void setPainEffect(float f) {
        this.PainEffect = f;
    }

    public float getPainDelta() {
        return this.PainDelta;
    }

    public void setPainDelta(float f) {
        this.PainDelta = f;
    }

    public boolean isbDoDefer() {
        return this.bDoDefer;
    }

    public void setbDoDefer(boolean bl) {
        this.bDoDefer = bl;
    }

    public Location getLastHeardSound() {
        return this.LastHeardSound;
    }

    public void setLastHeardSound(int n, int n2, int n3) {
        this.LastHeardSound.x = n;
        this.LastHeardSound.y = n2;
        this.LastHeardSound.z = n3;
    }

    public float getLrx() {
        return this.lrx;
    }

    public void setLrx(float f) {
        this.lrx = f;
    }

    public float getLry() {
        return this.lry;
    }

    public void setLry(float f) {
        this.lry = f;
    }

    public boolean isClimbing() {
        return this.bClimbing;
    }

    public void setbClimbing(boolean bl) {
        this.bClimbing = bl;
    }

    public boolean isLastCollidedW() {
        return this.lastCollidedW;
    }

    public void setLastCollidedW(boolean bl) {
        this.lastCollidedW = bl;
    }

    public boolean isLastCollidedN() {
        return this.lastCollidedN;
    }

    public void setLastCollidedN(boolean bl) {
        this.lastCollidedN = bl;
    }

    public float getFallTime() {
        return this.fallTime;
    }

    public void setFallTime(float f) {
        this.fallTime = f;
    }

    public float getLastFallSpeed() {
        return this.lastFallSpeed;
    }

    public void setLastFallSpeed(float f) {
        this.lastFallSpeed = f;
    }

    public boolean isbFalling() {
        return this.bFalling;
    }

    public void setbFalling(boolean bl) {
        this.bFalling = bl;
    }

    @Override
    public IsoBuilding getCurrentBuilding() {
        if (this.current == null) {
            return null;
        }
        if (this.current.getRoom() == null) {
            return null;
        }
        return this.current.getRoom().building;
    }

    public BuildingDef getCurrentBuildingDef() {
        if (this.current == null) {
            return null;
        }
        if (this.current.getRoom() == null) {
            return null;
        }
        if (this.current.getRoom().building != null) {
            return this.current.getRoom().building.def;
        }
        return null;
    }

    public RoomDef getCurrentRoomDef() {
        if (this.current == null) {
            return null;
        }
        if (this.current.getRoom() != null) {
            return this.current.getRoom().def;
        }
        return null;
    }

    public float getTorchStrength() {
        return 0.0f;
    }

    @Override
    public void OnAnimEvent(AnimLayer animLayer, AnimEvent animEvent) {
        if (animEvent.m_EventName == null) {
            return;
        }
        if (animEvent.m_EventName.equalsIgnoreCase("SetVariable") && animEvent.m_SetVariable1 != null) {
            this.setVariable(animEvent.m_SetVariable1, animEvent.m_SetVariable2);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("ClearVariable")) {
            this.clearVariable(animEvent.m_ParameterValue);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("PlaySound")) {
            this.getEmitter().playSoundImpl(animEvent.m_ParameterValue, this);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("Footstep")) {
            this.DoFootstepSound(animEvent.m_ParameterValue);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("DamageWhileInTrees")) {
            this.damageWhileInTrees();
        }
        int n = animLayer.getDepth();
        this.actionContext.reportEvent(n, animEvent.m_EventName);
        this.stateMachine.stateAnimEvent(n, animEvent);
    }

    private void damageWhileInTrees() {
        if (this.isZombie() || "Tutorial".equals(Core.GameMode)) {
            return;
        }
        int n = 50;
        int n2 = Rand.Next(0, BodyPartType.ToIndex(BodyPartType.MAX));
        if (this.isRunning()) {
            n = 30;
        }
        if (this.Traits.Outdoorsman.isSet()) {
            n += 50;
        }
        if (Rand.NextBool(n += (int)this.getBodyPartClothingDefense(n2, false, false))) {
            this.addHole(BloodBodyPartType.FromIndex(n2));
            n = 6;
            if (this.Traits.ThickSkinned.isSet()) {
                n += 7;
            }
            if (this.Traits.ThinSkinned.isSet()) {
                n -= 3;
            }
            if (Rand.NextBool(n) && (int)this.getBodyPartClothingDefense(n2, false, false) < 100) {
                BodyPart bodyPart = this.getBodyDamage().getBodyParts().get(n2);
                if (Rand.NextBool(n + 10)) {
                    bodyPart.setCut(true, true);
                } else {
                    bodyPart.setScratched(true, true);
                }
            }
        }
    }

    @Override
    public float getHammerSoundMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Woodwork);
        if (n == 2) {
            return 0.8f;
        }
        if (n == 3) {
            return 0.6f;
        }
        if (n == 4) {
            return 0.4f;
        }
        if (n >= 5) {
            return 0.4f;
        }
        return 1.0f;
    }

    @Override
    public float getWeldingSoundMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.MetalWelding);
        if (n == 2) {
            return 0.8f;
        }
        if (n == 3) {
            return 0.6f;
        }
        if (n == 4) {
            return 0.4f;
        }
        if (n >= 5) {
            return 0.4f;
        }
        return 1.0f;
    }

    public float getBarricadeTimeMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Woodwork);
        if (n == 1) {
            return 0.8f;
        }
        if (n == 2) {
            return 0.7f;
        }
        if (n == 3) {
            return 0.62f;
        }
        if (n == 4) {
            return 0.56f;
        }
        if (n == 5) {
            return 0.5f;
        }
        if (n == 6) {
            return 0.42f;
        }
        if (n == 7) {
            return 0.36f;
        }
        if (n == 8) {
            return 0.3f;
        }
        if (n == 9) {
            return 0.26f;
        }
        if (n == 10) {
            return 0.2f;
        }
        return 0.7f;
    }

    public float getMetalBarricadeStrengthMod() {
        switch (this.getPerkLevel(PerkFactory.Perks.MetalWelding)) {
            case 2: {
                return 1.1f;
            }
            case 3: {
                return 1.14f;
            }
            case 4: {
                return 1.18f;
            }
            case 5: {
                return 1.22f;
            }
            case 6: {
                return 1.16f;
            }
            case 7: {
                return 1.3f;
            }
            case 8: {
                return 1.34f;
            }
            case 9: {
                return 1.4f;
            }
            case 10: {
                return 1.5f;
            }
        }
        int n = this.getPerkLevel(PerkFactory.Perks.Woodwork);
        if (n == 2) {
            return 1.1f;
        }
        if (n == 3) {
            return 1.14f;
        }
        if (n == 4) {
            return 1.18f;
        }
        if (n == 5) {
            return 1.22f;
        }
        if (n == 6) {
            return 1.26f;
        }
        if (n == 7) {
            return 1.3f;
        }
        if (n == 8) {
            return 1.34f;
        }
        if (n == 9) {
            return 1.4f;
        }
        if (n == 10) {
            return 1.5f;
        }
        return 1.0f;
    }

    public float getBarricadeStrengthMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Woodwork);
        if (n == 2) {
            return 1.1f;
        }
        if (n == 3) {
            return 1.14f;
        }
        if (n == 4) {
            return 1.18f;
        }
        if (n == 5) {
            return 1.22f;
        }
        if (n == 6) {
            return 1.26f;
        }
        if (n == 7) {
            return 1.3f;
        }
        if (n == 8) {
            return 1.34f;
        }
        if (n == 9) {
            return 1.4f;
        }
        if (n == 10) {
            return 1.5f;
        }
        return 1.0f;
    }

    public float getSneakSpotMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Sneak);
        float f = 0.95f;
        if (n == 1) {
            f = 0.9f;
        }
        if (n == 2) {
            f = 0.8f;
        }
        if (n == 3) {
            f = 0.75f;
        }
        if (n == 4) {
            f = 0.7f;
        }
        if (n == 5) {
            f = 0.65f;
        }
        if (n == 6) {
            f = 0.6f;
        }
        if (n == 7) {
            f = 0.55f;
        }
        if (n == 8) {
            f = 0.5f;
        }
        if (n == 9) {
            f = 0.45f;
        }
        if (n == 10) {
            f = 0.4f;
        }
        return f *= 1.2f;
    }

    public float getNimbleMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Nimble);
        if (n == 1) {
            return 1.1f;
        }
        if (n == 2) {
            return 1.14f;
        }
        if (n == 3) {
            return 1.18f;
        }
        if (n == 4) {
            return 1.22f;
        }
        if (n == 5) {
            return 1.26f;
        }
        if (n == 6) {
            return 1.3f;
        }
        if (n == 7) {
            return 1.34f;
        }
        if (n == 8) {
            return 1.38f;
        }
        if (n == 9) {
            return 1.42f;
        }
        if (n == 10) {
            return 1.5f;
        }
        return 1.0f;
    }

    @Override
    public float getFatigueMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Fitness);
        if (n == 1) {
            return 0.95f;
        }
        if (n == 2) {
            return 0.92f;
        }
        if (n == 3) {
            return 0.89f;
        }
        if (n == 4) {
            return 0.87f;
        }
        if (n == 5) {
            return 0.85f;
        }
        if (n == 6) {
            return 0.83f;
        }
        if (n == 7) {
            return 0.81f;
        }
        if (n == 8) {
            return 0.79f;
        }
        if (n == 9) {
            return 0.77f;
        }
        if (n == 10) {
            return 0.75f;
        }
        return 1.0f;
    }

    public float getLightfootMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Lightfoot);
        if (n == 1) {
            return 0.9f;
        }
        if (n == 2) {
            return 0.79f;
        }
        if (n == 3) {
            return 0.71f;
        }
        if (n == 4) {
            return 0.65f;
        }
        if (n == 5) {
            return 0.59f;
        }
        if (n == 6) {
            return 0.52f;
        }
        if (n == 7) {
            return 0.45f;
        }
        if (n == 8) {
            return 0.37f;
        }
        if (n == 9) {
            return 0.3f;
        }
        if (n == 10) {
            return 0.2f;
        }
        return 0.99f;
    }

    public float getPacingMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Fitness);
        if (n == 1) {
            return 0.8f;
        }
        if (n == 2) {
            return 0.75f;
        }
        if (n == 3) {
            return 0.7f;
        }
        if (n == 4) {
            return 0.65f;
        }
        if (n == 5) {
            return 0.6f;
        }
        if (n == 6) {
            return 0.57f;
        }
        if (n == 7) {
            return 0.53f;
        }
        if (n == 8) {
            return 0.49f;
        }
        if (n == 9) {
            return 0.46f;
        }
        if (n == 10) {
            return 0.43f;
        }
        return 0.9f;
    }

    public float getHyperthermiaMod() {
        float f = 1.0f;
        if (this.getMoodles().getMoodleLevel(MoodleType.Hyperthermia) > 1) {
            f = 1.0f;
            if (this.getMoodles().getMoodleLevel(MoodleType.Hyperthermia) == 4) {
                f = 2.0f;
            }
        }
        return f;
    }

    public float getHittingMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Strength);
        if (n == 1) {
            return 0.8f;
        }
        if (n == 2) {
            return 0.85f;
        }
        if (n == 3) {
            return 0.9f;
        }
        if (n == 4) {
            return 0.95f;
        }
        if (n == 5) {
            return 1.0f;
        }
        if (n == 6) {
            return 1.05f;
        }
        if (n == 7) {
            return 1.1f;
        }
        if (n == 8) {
            return 1.15f;
        }
        if (n == 9) {
            return 1.2f;
        }
        if (n == 10) {
            return 1.25f;
        }
        return 0.75f;
    }

    public float getShovingMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Strength);
        if (n == 1) {
            return 0.8f;
        }
        if (n == 2) {
            return 0.85f;
        }
        if (n == 3) {
            return 0.9f;
        }
        if (n == 4) {
            return 0.95f;
        }
        if (n == 5) {
            return 1.0f;
        }
        if (n == 6) {
            return 1.05f;
        }
        if (n == 7) {
            return 1.1f;
        }
        if (n == 8) {
            return 1.15f;
        }
        if (n == 9) {
            return 1.2f;
        }
        if (n == 10) {
            return 1.25f;
        }
        return 0.75f;
    }

    public float getRecoveryMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Fitness);
        float f = 0.0f;
        if (n == 0) {
            f = 0.7f;
        }
        if (n == 1) {
            f = 0.8f;
        }
        if (n == 2) {
            f = 0.9f;
        }
        if (n == 3) {
            f = 1.0f;
        }
        if (n == 4) {
            f = 1.1f;
        }
        if (n == 5) {
            f = 1.2f;
        }
        if (n == 6) {
            f = 1.3f;
        }
        if (n == 7) {
            f = 1.4f;
        }
        if (n == 8) {
            f = 1.5f;
        }
        if (n == 9) {
            f = 1.55f;
        }
        if (n == 10) {
            f = 1.6f;
        }
        if (this.Traits.Obese.isSet()) {
            f = (float)((double)f * 0.4);
        }
        if (this.Traits.Overweight.isSet()) {
            f = (float)((double)f * 0.7);
        }
        if (this.Traits.VeryUnderweight.isSet()) {
            f = (float)((double)f * 0.7);
        }
        if (this.Traits.Emaciated.isSet()) {
            f = (float)((double)f * 0.3);
        }
        if (this instanceof IsoPlayer) {
            if (((IsoPlayer)this).getNutrition().getLipids() < -1500.0f) {
                f = (float)((double)f * 0.2);
            } else if (((IsoPlayer)this).getNutrition().getLipids() < -1000.0f) {
                f = (float)((double)f * 0.5);
            }
            if (((IsoPlayer)this).getNutrition().getProteins() < -1500.0f) {
                f = (float)((double)f * 0.2);
            } else if (((IsoPlayer)this).getNutrition().getProteins() < -1000.0f) {
                f = (float)((double)f * 0.5);
            }
        }
        return f;
    }

    public float getWeightMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Strength);
        if (n == 1) {
            return 0.9f;
        }
        if (n == 2) {
            return 1.07f;
        }
        if (n == 3) {
            return 1.24f;
        }
        if (n == 4) {
            return 1.41f;
        }
        if (n == 5) {
            return 1.58f;
        }
        if (n == 6) {
            return 1.75f;
        }
        if (n == 7) {
            return 1.92f;
        }
        if (n == 8) {
            return 2.09f;
        }
        if (n == 9) {
            return 2.26f;
        }
        if (n == 10) {
            return 2.5f;
        }
        return 0.8f;
    }

    public int getHitChancesMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Aiming);
        if (n == 1) {
            return 1;
        }
        if (n == 2) {
            return 1;
        }
        if (n == 3) {
            return 2;
        }
        if (n == 4) {
            return 2;
        }
        if (n == 5) {
            return 3;
        }
        if (n == 6) {
            return 3;
        }
        if (n == 7) {
            return 4;
        }
        if (n == 8) {
            return 4;
        }
        if (n == 9) {
            return 5;
        }
        if (n == 10) {
            return 5;
        }
        return 1;
    }

    public float getSprintMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Sprinting);
        if (n == 1) {
            return 1.1f;
        }
        if (n == 2) {
            return 1.15f;
        }
        if (n == 3) {
            return 1.2f;
        }
        if (n == 4) {
            return 1.25f;
        }
        if (n == 5) {
            return 1.3f;
        }
        if (n == 6) {
            return 1.35f;
        }
        if (n == 7) {
            return 1.4f;
        }
        if (n == 8) {
            return 1.45f;
        }
        if (n == 9) {
            return 1.5f;
        }
        if (n == 10) {
            return 1.6f;
        }
        return 0.9f;
    }

    @Override
    public int getPerkLevel(PerkFactory.Perk perk) {
        PerkInfo perkInfo = this.getPerkInfo(perk);
        if (perkInfo != null) {
            return perkInfo.level;
        }
        return 0;
    }

    @Override
    public void setPerkLevelDebug(PerkFactory.Perk perk, int n) {
        PerkInfo perkInfo = this.getPerkInfo(perk);
        if (perkInfo != null) {
            perkInfo.level = n;
        }
        if (GameClient.bClient && this instanceof IsoPlayer) {
            GameClient.sendPerks((IsoPlayer)this);
        }
    }

    @Override
    public void LoseLevel(PerkFactory.Perk perk) {
        PerkInfo perkInfo = this.getPerkInfo(perk);
        if (perkInfo != null) {
            --perkInfo.level;
            if (perkInfo.level < 0) {
                perkInfo.level = 0;
            }
            LuaEventManager.triggerEvent("LevelPerk", this, perk, perkInfo.level, false);
            if (perk == PerkFactory.Perks.Sneak && GameClient.bClient && this instanceof IsoPlayer) {
                GameClient.sendPerks((IsoPlayer)this);
            }
            return;
        }
        LuaEventManager.triggerEvent("LevelPerk", this, perk, 0, false);
    }

    @Override
    public void LevelPerk(PerkFactory.Perk perk, boolean bl) {
        Objects.requireNonNull(perk, "perk is null");
        if (perk == PerkFactory.Perks.MAX) {
            throw new IllegalArgumentException("perk == Perks.MAX");
        }
        IsoPlayer isoPlayer = Type.tryCastTo(this, IsoPlayer.class);
        PerkInfo perkInfo = this.getPerkInfo(perk);
        if (perkInfo != null) {
            ++perkInfo.level;
            if (isoPlayer != null && !"Tutorial".equals(Core.GameMode) && this.getHoursSurvived() > 0.016666666666666666) {
                HaloTextHelper.addTextWithArrow(isoPlayer, "+1 " + perk.getName(), true, HaloTextHelper.getColorGreen());
            }
            if (perkInfo.level > 10) {
                perkInfo.level = 10;
            }
            if (GameClient.bClient && isoPlayer != null) {
                GameClient.instance.sendSyncXp(isoPlayer);
            }
            LuaEventManager.triggerEventGarbage("LevelPerk", this, perk, perkInfo.level, true);
            if (GameClient.bClient && isoPlayer != null) {
                GameClient.sendPerks(isoPlayer);
            }
            return;
        }
        perkInfo = new PerkInfo();
        perkInfo.perk = perk;
        perkInfo.level = 1;
        this.PerkList.add(perkInfo);
        if (isoPlayer != null && !"Tutorial".equals(Core.GameMode) && this.getHoursSurvived() > 0.016666666666666666) {
            HaloTextHelper.addTextWithArrow(isoPlayer, "+1 " + perk.getName(), true, HaloTextHelper.getColorGreen());
        }
        if (GameClient.bClient && this instanceof IsoPlayer) {
            GameClient.instance.sendSyncXp(isoPlayer);
        }
        LuaEventManager.triggerEvent("LevelPerk", this, perk, perkInfo.level, true);
    }

    @Override
    public void LevelPerk(PerkFactory.Perk perk) {
        this.LevelPerk(perk, true);
    }

    public void level0(PerkFactory.Perk perk) {
        PerkInfo perkInfo = this.getPerkInfo(perk);
        if (perkInfo != null) {
            perkInfo.level = 0;
        }
    }

    public Location getLastKnownLocationOf(String string) {
        if (this.LastKnownLocation.containsKey(string)) {
            return this.LastKnownLocation.get(string);
        }
        return null;
    }

    @Override
    public void ReadLiterature(Literature literature) {
        this.stats.stress += literature.getStressChange();
        this.getBodyDamage().JustReadSomething(literature);
        if (literature.getTeachedRecipes() != null) {
            for (int i = 0; i < literature.getTeachedRecipes().size(); ++i) {
                if (this.getKnownRecipes().contains(literature.getTeachedRecipes().get(i))) continue;
                this.getKnownRecipes().add(literature.getTeachedRecipes().get(i));
            }
        }
        literature.Use();
    }

    public void OnDeath() {
        LuaEventManager.triggerEvent("OnCharacterDeath", this);
    }

    public void splatBloodFloorBig() {
        if (this.getCurrentSquare() != null && this.getCurrentSquare().getChunk() != null) {
            this.getCurrentSquare().getChunk().addBloodSplat(this.x, this.y, this.z, Rand.Next(20));
        }
    }

    public void splatBloodFloor() {
        if (this.getCurrentSquare() == null) {
            return;
        }
        if (this.getCurrentSquare().getChunk() == null) {
            return;
        }
        if (this.isDead() && Rand.Next(10) == 0) {
            this.getCurrentSquare().getChunk().addBloodSplat(this.x, this.y, this.z, Rand.Next(20));
        }
        if (Rand.Next(14) == 0) {
            this.getCurrentSquare().getChunk().addBloodSplat(this.x, this.y, this.z, Rand.Next(8));
        }
        if (Rand.Next(50) == 0) {
            this.getCurrentSquare().getChunk().addBloodSplat(this.x, this.y, this.z, Rand.Next(20));
        }
    }

    public int getThreatLevel() {
        int n = this.LocalRelevantEnemyList.size();
        if ((n += this.VeryCloseEnemyList.size() * 10) > 20) {
            return 3;
        }
        if (n > 10) {
            return 2;
        }
        if (n > 0) {
            return 1;
        }
        return 0;
    }

    public boolean isDead() {
        return this.Health <= 0.0f || this.BodyDamage != null && this.BodyDamage.getHealth() <= 0.0f;
    }

    public boolean isAlive() {
        return !this.isDead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Seen(Stack<IsoMovingObject> stack) {
        ArrayList<IsoMovingObject> arrayList = this.LocalList;
        synchronized (arrayList) {
            this.LocalList.clear();
            this.LocalList.addAll(stack);
        }
    }

    public boolean CanSee(IsoMovingObject isoMovingObject) {
        return LosUtil.lineClear(this.getCell(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), (int)isoMovingObject.getX(), (int)isoMovingObject.getY(), (int)isoMovingObject.getZ(), false) != LosUtil.TestResults.Blocked;
    }

    public IsoGridSquare getLowDangerInVicinity(int n, int n2) {
        float f = -1000000.0f;
        IsoGridSquare isoGridSquare = null;
        for (int i = 0; i < n; ++i) {
            float f2 = 0.0f;
            int n3 = Rand.Next(-n2, n2);
            int n4 = Rand.Next(-n2, n2);
            IsoGridSquare isoGridSquare2 = this.getCell().getGridSquare((int)this.getX() + n3, (int)this.getY() + n4, (int)this.getZ());
            if (isoGridSquare2 == null || !isoGridSquare2.isFree(true)) continue;
            float f3 = isoGridSquare2.getMovingObjects().size();
            if (isoGridSquare2.getE() != null) {
                f3 += (float)isoGridSquare2.getE().getMovingObjects().size();
            }
            if (isoGridSquare2.getS() != null) {
                f3 += (float)isoGridSquare2.getS().getMovingObjects().size();
            }
            if (isoGridSquare2.getW() != null) {
                f3 += (float)isoGridSquare2.getW().getMovingObjects().size();
            }
            if (isoGridSquare2.getN() != null) {
                f3 += (float)isoGridSquare2.getN().getMovingObjects().size();
            }
            if (!((f2 -= f3 * 1000.0f) > f)) continue;
            f = f2;
            isoGridSquare = isoGridSquare2;
        }
        return isoGridSquare;
    }

    public void Anger(int n) {
        float f = 10.0f;
        if ((float)Rand.Next(100) < f) {
            n *= 2;
        }
        n = (int)((float)n * (this.stats.getStress() + 1.0f));
        n = (int)((float)n * (this.BodyDamage.getUnhappynessLevel() / 100.0f + 1.0f));
        this.stats.Anger += (float)n / 100.0f;
    }

    @Override
    public boolean hasEquipped(String string) {
        if (string.contains(".")) {
            string = string.split("\\.")[1];
        }
        if (this.leftHandItem != null && this.leftHandItem.getType().equals(string)) {
            return true;
        }
        return this.rightHandItem != null && this.rightHandItem.getType().equals(string);
    }

    @Override
    public boolean hasEquippedTag(String string) {
        if (this.leftHandItem != null && this.leftHandItem.hasTag(string)) {
            return true;
        }
        return this.rightHandItem != null && this.rightHandItem.hasTag(string);
    }

    @Override
    public void setDir(IsoDirections isoDirections) {
        this.dir = isoDirections;
        this.getVectorFromDirection(this.m_forwardDirection);
    }

    public void Callout(boolean bl) {
        if (!this.isCanShout()) {
            return;
        }
        this.Callout();
        if (bl) {
            this.playEmote("shout");
        }
    }

    @Override
    public void Callout() {
        String string = "";
        int n = 30;
        if (Core.getInstance().getGameMode().equals("Tutorial")) {
            string = Translator.getText("IGUI_PlayerText_CalloutTutorial");
        } else if (this.isSneaking()) {
            n = 6;
            switch (Rand.Next(3)) {
                case 0: {
                    string = Translator.getText("IGUI_PlayerText_Callout1Sneak");
                    break;
                }
                case 1: {
                    string = Translator.getText("IGUI_PlayerText_Callout2Sneak");
                    break;
                }
                case 2: {
                    string = Translator.getText("IGUI_PlayerText_Callout3Sneak");
                }
            }
        } else {
            switch (Rand.Next(3)) {
                case 0: {
                    string = Translator.getText("IGUI_PlayerText_Callout1New");
                    break;
                }
                case 1: {
                    string = Translator.getText("IGUI_PlayerText_Callout2New");
                    break;
                }
                case 2: {
                    string = Translator.getText("IGUI_PlayerText_Callout3New");
                }
            }
        }
        WorldSoundManager.instance.addSound(this, (int)this.x, (int)this.y, (int)this.z, n, n);
        this.SayShout(string);
        this.callOut = true;
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        int n2;
        int n3;
        int n4;
        super.load(byteBuffer, n, bl);
        this.getVectorFromDirection(this.m_forwardDirection);
        if (byteBuffer.get() == 1) {
            this.descriptor = new SurvivorDesc(true);
            this.descriptor.load(byteBuffer, n, this);
            this.bFemale = this.descriptor.isFemale();
        }
        this.getVisual().load(byteBuffer, n);
        ArrayList<InventoryItem> arrayList = this.inventory.load(byteBuffer, n);
        this.savedInventoryItems.clear();
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            this.savedInventoryItems.add(arrayList.get(n4));
        }
        this.Asleep = byteBuffer.get() == 1;
        this.ForceWakeUpTime = byteBuffer.getFloat();
        if (!this.isZombie()) {
            this.stats.load(byteBuffer, n);
            this.BodyDamage.load(byteBuffer, n);
            this.xp.load(byteBuffer, n);
            ArrayList<InventoryItem> arrayList2 = this.inventory.IncludingObsoleteItems;
            n3 = byteBuffer.getInt();
            if (n3 >= 0 && n3 < arrayList2.size()) {
                this.leftHandItem = arrayList2.get(n3);
            }
            if ((n3 = byteBuffer.getInt()) >= 0 && n3 < arrayList2.size()) {
                this.rightHandItem = arrayList2.get(n3);
            }
            this.setEquipParent(null, this.leftHandItem);
            this.setEquipParent(null, this.rightHandItem);
        }
        int n5 = n4 = byteBuffer.get() == 1 ? 1 : 0;
        if (n4 != 0) {
            this.SetOnFire();
        }
        this.DepressEffect = byteBuffer.getFloat();
        this.DepressFirstTakeTime = byteBuffer.getFloat();
        this.BetaEffect = byteBuffer.getFloat();
        this.BetaDelta = byteBuffer.getFloat();
        this.PainEffect = byteBuffer.getFloat();
        this.PainDelta = byteBuffer.getFloat();
        this.SleepingTabletEffect = byteBuffer.getFloat();
        this.SleepingTabletDelta = byteBuffer.getFloat();
        n3 = byteBuffer.getInt();
        for (n2 = 0; n2 < n3; ++n2) {
            ReadBook readBook = new ReadBook();
            readBook.fullType = GameWindow.ReadString(byteBuffer);
            readBook.alreadyReadPages = byteBuffer.getInt();
            this.ReadBooks.add(readBook);
        }
        this.reduceInfectionPower = byteBuffer.getFloat();
        n2 = byteBuffer.getInt();
        for (int i = 0; i < n2; ++i) {
            this.knownRecipes.add(GameWindow.ReadString(byteBuffer));
        }
        this.lastHourSleeped = byteBuffer.getInt();
        this.timeSinceLastSmoke = byteBuffer.getFloat();
        this.beardGrowTiming = byteBuffer.getFloat();
        this.hairGrowTiming = byteBuffer.getFloat();
        this.setUnlimitedCarry(byteBuffer.get() == 1);
        this.setBuildCheat(byteBuffer.get() == 1);
        this.setHealthCheat(byteBuffer.get() == 1);
        this.setMechanicsCheat(byteBuffer.get() == 1);
        if (n >= 176) {
            this.setMovablesCheat(byteBuffer.get() == 1);
            this.setFarmingCheat(byteBuffer.get() == 1);
            this.setTimedActionInstantCheat(byteBuffer.get() == 1);
            this.setUnlimitedEndurance(byteBuffer.get() == 1);
        }
        if (n >= 161) {
            this.setSneaking(byteBuffer.get() == 1);
            this.setDeathDragDown(byteBuffer.get() == 1);
        }
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        Object object;
        int n;
        super.save(byteBuffer, bl);
        if (this.descriptor == null) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            this.descriptor.save(byteBuffer);
        }
        this.getVisual().save(byteBuffer);
        ArrayList<InventoryItem> arrayList = this.inventory.save(byteBuffer, this);
        this.savedInventoryItems.clear();
        for (n = 0; n < arrayList.size(); ++n) {
            this.savedInventoryItems.add(arrayList.get(n));
        }
        byteBuffer.put(this.Asleep ? (byte)1 : 0);
        byteBuffer.putFloat(this.ForceWakeUpTime);
        if (!this.isZombie()) {
            this.stats.save(byteBuffer);
            this.BodyDamage.save(byteBuffer);
            this.xp.save(byteBuffer);
            if (this.leftHandItem != null) {
                byteBuffer.putInt(this.inventory.getItems().indexOf(this.leftHandItem));
            } else {
                byteBuffer.putInt(-1);
            }
            if (this.rightHandItem != null) {
                byteBuffer.putInt(this.inventory.getItems().indexOf(this.rightHandItem));
            } else {
                byteBuffer.putInt(-1);
            }
        }
        byteBuffer.put(this.OnFire ? (byte)1 : 0);
        byteBuffer.putFloat(this.DepressEffect);
        byteBuffer.putFloat(this.DepressFirstTakeTime);
        byteBuffer.putFloat(this.BetaEffect);
        byteBuffer.putFloat(this.BetaDelta);
        byteBuffer.putFloat(this.PainEffect);
        byteBuffer.putFloat(this.PainDelta);
        byteBuffer.putFloat(this.SleepingTabletEffect);
        byteBuffer.putFloat(this.SleepingTabletDelta);
        byteBuffer.putInt(this.ReadBooks.size());
        for (n = 0; n < this.ReadBooks.size(); ++n) {
            object = this.ReadBooks.get(n);
            GameWindow.WriteString(byteBuffer, ((ReadBook)object).fullType);
            byteBuffer.putInt(((ReadBook)object).alreadyReadPages);
        }
        byteBuffer.putFloat(this.reduceInfectionPower);
        byteBuffer.putInt(this.knownRecipes.size());
        for (n = 0; n < this.knownRecipes.size(); ++n) {
            object = this.knownRecipes.get(n);
            GameWindow.WriteString(byteBuffer, (String)object);
        }
        byteBuffer.putInt(this.lastHourSleeped);
        byteBuffer.putFloat(this.timeSinceLastSmoke);
        byteBuffer.putFloat(this.beardGrowTiming);
        byteBuffer.putFloat(this.hairGrowTiming);
        byteBuffer.put(this.isUnlimitedCarry() ? (byte)1 : 0);
        byteBuffer.put(this.isBuildCheat() ? (byte)1 : 0);
        byteBuffer.put(this.isHealthCheat() ? (byte)1 : 0);
        byteBuffer.put(this.isMechanicsCheat() ? (byte)1 : 0);
        byteBuffer.put(this.isMovablesCheat() ? (byte)1 : 0);
        byteBuffer.put(this.isFarmingCheat() ? (byte)1 : 0);
        byteBuffer.put(this.isTimedActionInstantCheat() ? (byte)1 : 0);
        byteBuffer.put(this.isUnlimitedEndurance() ? (byte)1 : 0);
        byteBuffer.put(this.isSneaking() ? (byte)1 : 0);
        byteBuffer.put(this.isDeathDragDown() ? (byte)1 : 0);
    }

    public ChatElement getChatElement() {
        return this.chatElement;
    }

    @Override
    public void StartAction(BaseAction baseAction) {
        this.CharacterActions.clear();
        this.CharacterActions.push(baseAction);
        if (baseAction.valid()) {
            baseAction.waitToStart();
        }
    }

    public void QueueAction(BaseAction baseAction) {
    }

    @Override
    public void StopAllActionQueue() {
        if (this.CharacterActions.isEmpty()) {
            return;
        }
        BaseAction baseAction = (BaseAction)this.CharacterActions.get(0);
        if (baseAction.bStarted) {
            baseAction.stop();
        }
        this.CharacterActions.clear();
        if (this == IsoPlayer.players[0] || this == IsoPlayer.players[1] || this == IsoPlayer.players[2] || this == IsoPlayer.players[3]) {
            UIManager.getProgressBar(((IsoPlayer)this).getPlayerNum()).setValue(0.0f);
        }
    }

    public void StopAllActionQueueRunning() {
        if (this.CharacterActions.isEmpty()) {
            return;
        }
        BaseAction baseAction = (BaseAction)this.CharacterActions.get(0);
        if (!baseAction.StopOnRun) {
            return;
        }
        if (baseAction.bStarted) {
            baseAction.stop();
        }
        this.CharacterActions.clear();
        if (this == IsoPlayer.players[0] || this == IsoPlayer.players[1] || this == IsoPlayer.players[2] || this == IsoPlayer.players[3]) {
            UIManager.getProgressBar(((IsoPlayer)this).getPlayerNum()).setValue(0.0f);
        }
    }

    public void StopAllActionQueueAiming() {
        if (this.CharacterActions.size() == 0) {
            return;
        }
        BaseAction baseAction = (BaseAction)this.CharacterActions.get(0);
        if (!baseAction.StopOnAim) {
            return;
        }
        if (baseAction.bStarted) {
            baseAction.stop();
        }
        this.CharacterActions.clear();
        if (this == IsoPlayer.players[0] || this == IsoPlayer.players[1] || this == IsoPlayer.players[2] || this == IsoPlayer.players[3]) {
            UIManager.getProgressBar(((IsoPlayer)this).getPlayerNum()).setValue(0.0f);
        }
    }

    public void StopAllActionQueueWalking() {
        if (this.CharacterActions.size() == 0) {
            return;
        }
        BaseAction baseAction = (BaseAction)this.CharacterActions.get(0);
        if (!baseAction.StopOnWalk) {
            return;
        }
        if (baseAction.bStarted) {
            baseAction.stop();
        }
        this.CharacterActions.clear();
        if (this == IsoPlayer.players[0] || this == IsoPlayer.players[1] || this == IsoPlayer.players[2] || this == IsoPlayer.players[3]) {
            UIManager.getProgressBar(((IsoPlayer)this).getPlayerNum()).setValue(0.0f);
        }
    }

    @Override
    public String GetAnimSetName() {
        return "Base";
    }

    public void SleepingTablet(float f) {
        this.SleepingTabletEffect = 6600.0f;
        this.SleepingTabletDelta += f;
    }

    public void BetaBlockers(float f) {
        this.BetaEffect = 6600.0f;
        this.BetaDelta += f;
    }

    public void BetaAntiDepress(float f) {
        if (this.DepressEffect == 0.0f) {
            this.DepressFirstTakeTime = 10000.0f;
        }
        this.DepressEffect = 6600.0f;
        this.DepressDelta += f;
    }

    public void PainMeds(float f) {
        this.PainEffect = 5400.0f;
        this.PainDelta += f;
    }

    @Override
    public void initSpritePartsEmpty() {
        this.InitSpriteParts(this.descriptor);
    }

    public void InitSpriteParts(SurvivorDesc survivorDesc) {
        this.sprite.AnimMap.clear();
        this.sprite.AnimStack.clear();
        this.sprite.CurrentAnim = null;
        this.legsSprite = this.sprite;
        this.legsSprite.name = survivorDesc.torso;
        this.bUseParts = true;
    }

    @Override
    public boolean HasTrait(String string) {
        return this.Traits.contains(string);
    }

    public void ApplyInBedOffset(boolean bl) {
        if (bl) {
            if (!this.bOnBed) {
                this.offsetX -= 20.0f;
                this.offsetY += 21.0f;
                this.bOnBed = true;
            }
        } else if (this.bOnBed) {
            this.offsetX += 20.0f;
            this.offsetY -= 21.0f;
            this.bOnBed = false;
        }
    }

    @Override
    public void Dressup(SurvivorDesc survivorDesc) {
        if (this.isZombie()) {
            return;
        }
        if (this.wornItems == null) {
            return;
        }
        ItemVisuals itemVisuals = new ItemVisuals();
        survivorDesc.getItemVisuals(itemVisuals);
        this.wornItems.setFromItemVisuals(itemVisuals);
        this.wornItems.addItemsToItemContainer(this.inventory);
        survivorDesc.wornItems.clear();
        this.onWornItemsChanged();
    }

    @Override
    public void PlayAnim(String string) {
    }

    @Override
    public void PlayAnimWithSpeed(String string, float f) {
    }

    @Override
    public void PlayAnimUnlooped(String string) {
    }

    public void DirectionFromVector(Vector2 vector22) {
        this.dir = IsoDirections.fromAngle(vector22);
    }

    public void DoFootstepSound(String string) {
        float f = 1.0f;
        switch (string) {
            case "sneak_walk": {
                f = 0.2f;
                break;
            }
            case "sneak_run": {
                f = 0.5f;
                break;
            }
            case "strafe": {
                f = this.bSneaking ? 0.2f : 0.3f;
                break;
            }
            case "walk": {
                f = 0.5f;
                break;
            }
            case "run": {
                f = 1.3f;
                break;
            }
            case "sprint": {
                f = 1.8f;
            }
        }
        this.DoFootstepSound(f);
    }

    public void DoFootstepSound(float f) {
        IsoPlayer isoPlayer = Type.tryCastTo(this, IsoPlayer.class);
        if (GameClient.bClient && isoPlayer != null && isoPlayer.networkAI != null) {
            isoPlayer.networkAI.footstepSoundRadius = 0;
        }
        if (isoPlayer != null && isoPlayer.isGhostMode() && !DebugOptions.instance.Character.Debug.PlaySoundWhenInvisible.getValue()) {
            return;
        }
        if (this.getCurrentSquare() == null) {
            return;
        }
        if (f <= 0.0f) {
            return;
        }
        float f2 = f;
        f *= 1.4f;
        if (this.Traits.Graceful.isSet()) {
            f *= 0.6f;
        }
        if (this.Traits.Clumsy.isSet()) {
            f *= 1.2f;
        }
        if (this.getWornItem("Shoes") == null) {
            f *= 0.5f;
        }
        f *= this.getLightfootMod();
        f *= 2.0f - this.getNimbleMod();
        if (this.bSneaking) {
            f *= this.getSneakSpotMod();
        }
        if (f > 0.0f) {
            this.emitter.playFootsteps("HumanFootstepsCombined", f2);
            if (isoPlayer != null && isoPlayer.isGhostMode()) {
                return;
            }
            int n = (int)Math.ceil(f * 10.0f);
            if (this.bSneaking) {
                n = Math.max(1, n);
            }
            if (this.getCurrentSquare().getRoom() != null) {
                n = (int)((float)n * 0.5f);
            }
            int n2 = 2;
            if (this.bSneaking) {
                n2 = Math.min(12, 4 + this.getPerkLevel(PerkFactory.Perks.Lightfoot));
            }
            if (GameClient.bClient && isoPlayer != null && isoPlayer.networkAI != null) {
                isoPlayer.networkAI.footstepSoundRadius = (byte)n;
            }
            if (Rand.Next(n2) == 0) {
                WorldSoundManager.instance.addSound(this, (int)this.getX(), (int)this.getY(), (int)this.getZ(), n, n, false, 0.0f, 1.0f, false, false, false);
            }
        }
    }

    @Override
    public boolean Eat(InventoryItem inventoryItem, float f) {
        Object object;
        float f2;
        Object object2;
        Food food = Type.tryCastTo(inventoryItem, Food.class);
        if (food == null) {
            return false;
        }
        f = PZMath.clamp(f, 0.0f, 1.0f);
        if (food.getRequireInHandOrInventory() != null) {
            InventoryItem inventoryItem2 = null;
            for (int i = 0; i < food.getRequireInHandOrInventory().size(); ++i) {
                object2 = food.getRequireInHandOrInventory().get(i);
                inventoryItem2 = this.getInventory().FindAndReturn((String)object2);
                if (inventoryItem2 == null) continue;
                inventoryItem2.Use();
                break;
            }
        }
        float f3 = f;
        if (food.getBaseHunger() != 0.0f && food.getHungChange() != 0.0f) {
            float f4 = food.getBaseHunger() * f;
            float f5 = f4 / food.getHungChange();
            f = f5 = PZMath.clamp(f5, 0.0f, 1.0f);
        }
        if (food.getHungChange() < 0.0f && food.getHungChange() * (1.0f - f) > -0.01f) {
            f = 1.0f;
        }
        if (food.getHungChange() == 0.0f && food.getThirstChange() < 0.0f && food.getThirstChange() * (1.0f - f) > -0.01f) {
            f = 1.0f;
        }
        this.stats.thirst += food.getThirstChange() * f;
        if (this.stats.thirst < 0.0f) {
            this.stats.thirst = 0.0f;
        }
        this.stats.hunger += food.getHungerChange() * f;
        this.stats.endurance += food.getEnduranceChange() * f;
        this.stats.stress += food.getStressChange() * f;
        this.stats.fatigue += food.getFatigueChange() * f;
        IsoPlayer isoPlayer = Type.tryCastTo(this, IsoPlayer.class);
        if (isoPlayer != null) {
            object2 = isoPlayer.getNutrition();
            ((Nutrition)object2).setCalories(((Nutrition)object2).getCalories() + food.getCalories() * f);
            ((Nutrition)object2).setCarbohydrates(((Nutrition)object2).getCarbohydrates() + food.getCarbohydrates() * f);
            ((Nutrition)object2).setProteins(((Nutrition)object2).getProteins() + food.getProteins() * f);
            ((Nutrition)object2).setLipids(((Nutrition)object2).getLipids() + food.getLipids() * f);
        }
        this.BodyDamage.setPainReduction(this.BodyDamage.getPainReduction() + food.getPainReduction() * f);
        this.BodyDamage.setColdReduction(this.BodyDamage.getColdReduction() + (float)food.getFluReduction() * f);
        if (this.BodyDamage.getFoodSicknessLevel() > 0.0f && (float)food.getReduceFoodSickness() > 0.0f && this.effectiveEdibleBuffTimer <= 0.0f) {
            float f6 = this.BodyDamage.getFoodSicknessLevel();
            this.BodyDamage.setFoodSicknessLevel(this.BodyDamage.getFoodSicknessLevel() - (float)food.getReduceFoodSickness() * f);
            if (this.BodyDamage.getFoodSicknessLevel() < 0.0f) {
                this.BodyDamage.setFoodSicknessLevel(0.0f);
            }
            f2 = this.BodyDamage.getPoisonLevel();
            this.BodyDamage.setPoisonLevel(this.BodyDamage.getPoisonLevel() - (float)food.getReduceFoodSickness() * f);
            if (this.BodyDamage.getPoisonLevel() < 0.0f) {
                this.BodyDamage.setPoisonLevel(0.0f);
            }
            this.effectiveEdibleBuffTimer = this.Traits.IronGut.isSet() ? Rand.Next(80.0f, 150.0f) : (this.Traits.WeakStomach.isSet() ? Rand.Next(120.0f, 230.0f) : Rand.Next(200.0f, 280.0f));
        }
        this.BodyDamage.JustAteFood(food, f);
        if (GameClient.bClient && this instanceof IsoPlayer && ((IsoPlayer)this).isLocalPlayer()) {
            GameClient.instance.eatFood((IsoPlayer)this, food, f);
        }
        if (food.getOnEat() != null && (object = LuaManager.getFunctionObject(food.getOnEat())) != null) {
            LuaManager.caller.pcallvoid(LuaManager.thread, object, (Object)inventoryItem, (Object)this, (Object)BoxedStaticValues.toDouble(f));
        }
        if (f == 1.0f) {
            food.setHungChange(0.0f);
            food.UseItem();
        } else {
            float f7 = food.getHungChange();
            f2 = food.getThirstChange();
            food.multiplyFoodValues(1.0f - f);
            if (!(f7 < 0.0f) || (double)food.getHungerChange() > -0.00999) {
                // empty if block
            }
            if (f7 == 0.0f && f2 < 0.0f && food.getThirstChange() > -0.01f) {
                food.setHungChange(0.0f);
                food.UseItem();
                return true;
            }
            float f8 = 0.0f;
            if (food.isCustomWeight()) {
                Item item;
                String string = food.getReplaceOnUseFullType();
                Item item2 = item = string == null ? null : ScriptManager.instance.getItem(string);
                if (item != null) {
                    f8 = item.getActualWeight();
                }
                food.setWeight(food.getWeight() - f8 - f3 * (food.getWeight() - f8) + f8);
            }
        }
        return true;
    }

    @Override
    public boolean Eat(InventoryItem inventoryItem) {
        return this.Eat(inventoryItem, 1.0f);
    }

    public void FireCheck() {
        if (this.OnFire) {
            return;
        }
        if (GameServer.bServer && this instanceof IsoPlayer) {
            return;
        }
        if (GameClient.bClient && this.isZombie() && this instanceof IsoZombie && ((IsoZombie)this).isRemoteZombie()) {
            return;
        }
        if (this.isZombie() && VirtualZombieManager.instance.isReused((IsoZombie)this)) {
            DebugLog.log(DebugType.Zombie, "FireCheck running on REUSABLE ZOMBIE - IGNORED " + this);
            return;
        }
        if (this.getVehicle() != null) {
            return;
        }
        if (this.square != null && !GameServer.bServer && (!GameClient.bClient || this instanceof IsoPlayer && ((IsoPlayer)this).isLocalPlayer() || this instanceof IsoZombie && !((IsoZombie)this).isRemoteZombie()) && this.square.getProperties().Is(IsoFlagType.burning)) {
            if (this instanceof IsoPlayer && Rand.Next(Rand.AdjustForFramerate(70)) == 0 || this.isZombie()) {
                this.SetOnFire();
            } else {
                if (!(this instanceof IsoPlayer)) {
                    this.Health -= this.FireKillRate * GameTime.instance.getMultiplier() / 2.0f;
                    this.setAttackedBy(null);
                } else {
                    float f = this.FireKillRate * GameTime.instance.getMultiplier() * GameTime.instance.getMinutesPerDay() / 1.6f / 2.0f;
                    this.BodyDamage.ReduceGeneralHealth(f);
                    LuaEventManager.triggerEvent("OnPlayerGetDamage", this, "FIRE", Float.valueOf(f));
                    this.BodyDamage.OnFire(true);
                    this.forceAwake();
                }
                if (this.isDead()) {
                    IsoFireManager.RemoveBurningCharacter(this);
                    if (this.isZombie()) {
                        LuaEventManager.triggerEvent("OnZombieDead", this);
                        if (GameClient.bClient) {
                            this.setAttackedBy(IsoWorld.instance.CurrentCell.getFakeZombieForHit());
                        }
                    }
                }
            }
        }
    }

    public String getPrimaryHandType() {
        if (this.leftHandItem == null) {
            return null;
        }
        return this.leftHandItem.getType();
    }

    @Override
    public float getGlobalMovementMod(boolean bl) {
        if (this.getCurrentState() == ClimbOverFenceState.instance() || this.getCurrentState() == ClimbThroughWindowState.instance() || this.getCurrentState() == ClimbOverWallState.instance()) {
            return 1.0f;
        }
        return super.getGlobalMovementMod(bl);
    }

    public float getMoveSpeed() {
        IsoGameCharacter.tempo2.x = this.getX() - this.getLx();
        IsoGameCharacter.tempo2.y = this.getY() - this.getLy();
        return tempo2.getLength();
    }

    public String getSecondaryHandType() {
        if (this.rightHandItem == null) {
            return null;
        }
        return this.rightHandItem.getType();
    }

    public boolean HasItem(String string) {
        if (string == null) {
            return true;
        }
        return string.equals(this.getSecondaryHandType()) || string.equals(this.getPrimaryHandType()) || this.inventory.contains(string);
    }

    @Override
    public void changeState(State state) {
        this.stateMachine.changeState(state, null);
    }

    @Override
    public State getCurrentState() {
        return this.stateMachine.getCurrent();
    }

    @Override
    public boolean isCurrentState(State state) {
        if (this.stateMachine.isSubstate(state)) {
            return true;
        }
        return this.stateMachine.getCurrent() == state;
    }

    public HashMap<Object, Object> getStateMachineParams(State state2) {
        return this.StateMachineParams.computeIfAbsent(state2, state -> new HashMap());
    }

    public void setStateMachineLocked(boolean bl) {
        this.stateMachine.setLocked(bl);
    }

    @Override
    public float Hit(HandWeapon handWeapon, IsoGameCharacter isoGameCharacter, float f, boolean bl, float f2) {
        return this.Hit(handWeapon, isoGameCharacter, f, bl, f2, false);
    }

    @Override
    public float Hit(HandWeapon handWeapon, IsoGameCharacter isoGameCharacter, float f, boolean bl, float f2, boolean bl2) {
        float f3;
        if (isoGameCharacter == null || handWeapon == null) {
            return 0.0f;
        }
        if (!bl && this.isZombie()) {
            IsoZombie isoZombie = (IsoZombie)this;
            isoZombie.setHitTime(isoZombie.getHitTime() + 1);
            if (isoZombie.getHitTime() >= 4 && !bl2) {
                f = (float)((double)f * ((double)(isoZombie.getHitTime() - 2) * 1.5));
            }
        }
        if (isoGameCharacter instanceof IsoPlayer && ((IsoPlayer)isoGameCharacter).bDoShove && !((IsoPlayer)isoGameCharacter).isAimAtFloor()) {
            bl = true;
            f2 *= 1.5f;
        }
        LuaEventManager.triggerEvent("OnWeaponHitCharacter", isoGameCharacter, this, handWeapon, Float.valueOf(f));
        LuaEventManager.triggerEvent("OnPlayerGetDamage", this, "WEAPONHIT", Float.valueOf(f));
        if (LuaHookManager.TriggerHook("WeaponHitCharacter", isoGameCharacter, this, handWeapon, Float.valueOf(f))) {
            return 0.0f;
        }
        if (this.m_avoidDamage) {
            this.m_avoidDamage = false;
            return 0.0f;
        }
        if (this.noDamage) {
            bl = true;
            this.noDamage = false;
        }
        if (this instanceof IsoSurvivor && !this.EnemyList.contains(isoGameCharacter)) {
            this.EnemyList.add(isoGameCharacter);
        }
        this.staggerTimeMod = handWeapon.getPushBackMod() * handWeapon.getKnockbackMod(isoGameCharacter) * isoGameCharacter.getShovingMod();
        if (!this.isZombie() || Rand.Next(3) != 0 || GameServer.bServer) {
            // empty if block
        }
        isoGameCharacter.addWorldSoundUnlessInvisible(5, 1, false);
        this.hitDir.x = this.getX();
        this.hitDir.y = this.getY();
        this.hitDir.x -= isoGameCharacter.getX();
        this.hitDir.y -= isoGameCharacter.getY();
        this.getHitDir().normalize();
        this.hitDir.x *= handWeapon.getPushBackMod();
        this.hitDir.y *= handWeapon.getPushBackMod();
        this.hitDir.rotate(handWeapon.HitAngleMod);
        this.setAttackedBy(isoGameCharacter);
        float f4 = f;
        if (!bl2) {
            f4 = this.processHitDamage(handWeapon, isoGameCharacter, f, bl, f2);
        }
        float f5 = 0.0f;
        if (handWeapon.isTwoHandWeapon() && (isoGameCharacter.getPrimaryHandItem() != handWeapon || isoGameCharacter.getSecondaryHandItem() != handWeapon)) {
            f5 = handWeapon.getWeight() / 1.5f / 10.0f;
        }
        float f6 = (handWeapon.getWeight() * 0.28f * handWeapon.getFatigueMod(isoGameCharacter) * this.getFatigueMod() * handWeapon.getEnduranceMod() * 0.3f + f5) * 0.04f;
        if (isoGameCharacter instanceof IsoPlayer && isoGameCharacter.isAimAtFloor() && ((IsoPlayer)isoGameCharacter).bDoShove) {
            f6 *= 2.0f;
        }
        float f7 = f4;
        f7 = handWeapon.isAimedFirearm() ? f4 * 0.7f : f4 * 0.15f;
        if (this.getHealth() < f4) {
            f7 = this.getHealth();
        }
        if ((f3 = f7 / handWeapon.getMaxDamage()) > 1.0f) {
            f3 = 1.0f;
        }
        if (this.isCloseKilled()) {
            f3 = 0.2f;
        }
        if (handWeapon.isUseEndurance()) {
            if (f4 <= 0.0f) {
                f3 = 1.0f;
            }
            isoGameCharacter.getStats().endurance -= f6 * f3;
        }
        this.hitConsequences(handWeapon, isoGameCharacter, bl, f4, bl2);
        return f4;
    }

    public float processHitDamage(HandWeapon handWeapon, IsoGameCharacter isoGameCharacter, float f, boolean bl, float f2) {
        float f3;
        float f4 = f;
        float f5 = f4 *= f2;
        if (bl) {
            f5 /= 2.7f;
        }
        if ((f3 = f5 * isoGameCharacter.getShovingMod()) > 1.0f) {
            f3 = 1.0f;
        }
        this.setHitForce(f3);
        if (isoGameCharacter.Traits.Strong.isSet() && !handWeapon.isRanged()) {
            this.setHitForce(this.getHitForce() * 1.4f);
        }
        if (isoGameCharacter.Traits.Weak.isSet() && !handWeapon.isRanged()) {
            this.setHitForce(this.getHitForce() * 0.6f);
        }
        float f6 = IsoUtils.DistanceTo(isoGameCharacter.getX(), isoGameCharacter.getY(), this.getX(), this.getY());
        f6 -= handWeapon.getMinRange();
        f6 /= handWeapon.getMaxRange(isoGameCharacter);
        if ((f6 = 1.0f - f6) > 1.0f) {
            f6 = 1.0f;
        }
        float f7 = isoGameCharacter.stats.endurance;
        if ((f7 *= isoGameCharacter.knockbackAttackMod) < 0.5f) {
            if ((f7 *= 1.3f) < 0.4f) {
                f7 = 0.4f;
            }
            this.setHitForce(this.getHitForce() * f7);
        }
        if (!handWeapon.isRangeFalloff()) {
            f6 = 1.0f;
        }
        if (!handWeapon.isShareDamage()) {
            f = 1.0f;
        }
        if (isoGameCharacter instanceof IsoPlayer && !bl) {
            this.setHitForce(this.getHitForce() * 2.0f);
        }
        if (isoGameCharacter instanceof IsoPlayer && !((IsoPlayer)isoGameCharacter).bDoShove) {
            Vector2 vector22 = tempVector2_1.set(this.getX(), this.getY());
            Vector2 vector23 = tempVector2_2.set(isoGameCharacter.getX(), isoGameCharacter.getY());
            vector22.x -= vector23.x;
            vector22.y -= vector23.y;
            Vector2 vector24 = this.getVectorFromDirection(tempVector2_2);
            vector22.normalize();
            float f8 = vector22.dot(vector24);
            if (f8 > -0.3f) {
                f4 *= 1.5f;
            }
        }
        f4 = this instanceof IsoPlayer ? (f4 *= 0.4f) : (f4 *= 1.5f);
        int n = isoGameCharacter.getWeaponLevel();
        switch (n) {
            case -1: {
                f4 *= 0.3f;
                break;
            }
            case 0: {
                f4 *= 0.3f;
                break;
            }
            case 1: {
                f4 *= 0.4f;
                break;
            }
            case 2: {
                f4 *= 0.5f;
                break;
            }
            case 3: {
                f4 *= 0.6f;
                break;
            }
            case 4: {
                f4 *= 0.7f;
                break;
            }
            case 5: {
                f4 *= 0.8f;
                break;
            }
            case 6: {
                f4 *= 0.9f;
                break;
            }
            case 7: {
                f4 *= 1.0f;
                break;
            }
            case 8: {
                f4 *= 1.1f;
                break;
            }
            case 9: {
                f4 *= 1.2f;
                break;
            }
            case 10: {
                f4 *= 1.3f;
            }
        }
        if (isoGameCharacter instanceof IsoPlayer && isoGameCharacter.isAimAtFloor() && !bl && !((IsoPlayer)isoGameCharacter).bDoShove) {
            f4 *= Math.max(5.0f, handWeapon.getCritDmgMultiplier());
        }
        if (isoGameCharacter.isCriticalHit() && !bl) {
            f4 *= Math.max(2.0f, handWeapon.getCritDmgMultiplier());
        }
        if (handWeapon.isTwoHandWeapon() && !isoGameCharacter.isItemInBothHands(handWeapon)) {
            f4 *= 0.5f;
        }
        return f4;
    }

    public void hitConsequences(HandWeapon handWeapon, IsoGameCharacter isoGameCharacter, boolean bl, float f, boolean bl2) {
        if (!bl) {
            this.Health = handWeapon.isAimedFirearm() ? (this.Health -= f * 0.7f) : (this.Health -= f * 0.15f);
        }
        if (this.isDead()) {
            if (!this.isOnKillDone() && this.shouldDoInventory()) {
                this.Kill(isoGameCharacter);
            }
            if (this instanceof IsoZombie && ((IsoZombie)this).upKillCount) {
                isoGameCharacter.setZombieKills(isoGameCharacter.getZombieKills() + 1);
            }
            return;
        }
        if (handWeapon.isSplatBloodOnNoDeath()) {
            this.splatBlood(2, 0.2f);
        }
        if (handWeapon.isKnockBackOnNoDeath() && isoGameCharacter.xp != null) {
            isoGameCharacter.xp.AddXP(PerkFactory.Perks.Strength, 2.0f);
        }
    }

    public boolean IsAttackRange(float f, float f2, float f3) {
        InventoryItem inventoryItem;
        float f4 = 1.0f;
        float f5 = 0.0f;
        if (this.leftHandItem != null && (inventoryItem = this.leftHandItem) instanceof HandWeapon) {
            f4 = ((HandWeapon)inventoryItem).getMaxRange(this);
            f5 = ((HandWeapon)inventoryItem).getMinRange();
            f4 *= ((HandWeapon)this.leftHandItem).getRangeMod(this);
        }
        if (Math.abs(f3 - this.getZ()) > 0.3f) {
            return false;
        }
        float f6 = IsoUtils.DistanceTo(f, f2, this.getX(), this.getY());
        return f6 < f4 && f6 > f5;
    }

    public boolean IsAttackRange(HandWeapon handWeapon, IsoMovingObject isoMovingObject, Vector3 vector3, boolean bl) {
        IsoZombie isoZombie;
        if (handWeapon == null) {
            return false;
        }
        float f = Math.abs(isoMovingObject.getZ() - this.getZ());
        if (!handWeapon.isRanged() && f >= 0.5f) {
            return false;
        }
        if (f > 3.3f) {
            return false;
        }
        float f2 = handWeapon.getMaxRange(this);
        f2 *= handWeapon.getRangeMod(this);
        float f3 = IsoUtils.DistanceToSquared(this.x, this.y, vector3.x, vector3.y);
        if (bl && (isoZombie = Type.tryCastTo(isoMovingObject, IsoZombie.class)) != null && f3 < 4.0f && isoZombie.target == this && (isoZombie.isCurrentState(LungeState.instance()) || isoZombie.isCurrentState(LungeNetworkState.instance()))) {
            f2 += 1.0f;
        }
        return f3 < f2 * f2;
    }

    @Override
    public boolean IsSpeaking() {
        return this.chatElement.IsSpeaking();
    }

    public void MoveForward(float f, float f2, float f3, float f4) {
        if (this.isCurrentState(SwipeStatePlayer.instance())) {
            return;
        }
        float f5 = GameTime.instance.getMultiplier();
        this.setNx(this.getNx() + f2 * f * f5);
        this.setNy(this.getNy() + f3 * f * f5);
        this.DoFootstepSound(f);
        if (!this.isZombie()) {
            // empty if block
        }
    }

    private void pathToAux(float f, float f2, float f3) {
        boolean bl = true;
        if ((int)f3 == (int)this.getZ() && IsoUtils.DistanceManhatten(f, f2, this.x, this.y) <= 30.0f) {
            IsoChunk isoChunk;
            int n = (int)f / 10;
            int n2 = (int)f2 / 10;
            IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(n, n2) : IsoWorld.instance.CurrentCell.getChunkForGridSquare((int)f, (int)f2, (int)f3);
            if (isoChunk != null) {
                int n3 = 1;
                n3 |= 2;
                if (!this.isZombie()) {
                    n3 |= 4;
                }
                boolean bl2 = bl = !PolygonalMap2.instance.lineClearCollide(this.getX(), this.getY(), f, f2, (int)f3, this.getPathFindBehavior2().getTargetChar(), n3);
            }
        }
        if (bl && this.current != null && this.current.HasStairs() && !this.current.isSameStaircase((int)f, (int)f2, (int)f3)) {
            bl = false;
        }
        if (bl) {
            this.setVariable("bPathfind", false);
            this.setMoving(true);
        } else {
            this.setVariable("bPathfind", true);
            this.setMoving(false);
        }
    }

    public void pathToCharacter(IsoGameCharacter isoGameCharacter) {
        this.getPathFindBehavior2().pathToCharacter(isoGameCharacter);
        this.pathToAux(isoGameCharacter.getX(), isoGameCharacter.getY(), isoGameCharacter.getZ());
    }

    @Override
    public void pathToLocation(int n, int n2, int n3) {
        this.getPathFindBehavior2().pathToLocation(n, n2, n3);
        this.pathToAux((float)n + 0.5f, (float)n2 + 0.5f, n3);
    }

    @Override
    public void pathToLocationF(float f, float f2, float f3) {
        this.getPathFindBehavior2().pathToLocationF(f, f2, f3);
        this.pathToAux(f, f2, f3);
    }

    public void pathToSound(int n, int n2, int n3) {
        this.getPathFindBehavior2().pathToSound(n, n2, n3);
        this.pathToAux((float)n + 0.5f, (float)n2 + 0.5f, n3);
    }

    @Override
    public boolean CanAttack() {
        if (this.isAttackAnim() || this.getVariableBoolean("IsRacking") || this.getVariableBoolean("IsUnloading") || !StringUtils.isNullOrEmpty(this.getVariableString("RackWeapon"))) {
            return false;
        }
        if (GameClient.bClient && this instanceof IsoPlayer && ((IsoPlayer)this).isLocalPlayer() && (this.isCurrentState(PlayerHitReactionState.instance()) || this.isCurrentState(PlayerHitReactionPVPState.instance()))) {
            return false;
        }
        if (this.isSitOnGround()) {
            return false;
        }
        InventoryItem inventoryItem = this.leftHandItem;
        if (inventoryItem instanceof HandWeapon && inventoryItem.getSwingAnim() != null) {
            this.useHandWeapon = (HandWeapon)inventoryItem;
        }
        if (this.useHandWeapon == null) {
            return true;
        }
        if (this.useHandWeapon.getCondition() <= 0) {
            this.useHandWeapon = null;
            if (this.rightHandItem == this.leftHandItem) {
                this.setSecondaryHandItem(null);
            }
            this.setPrimaryHandItem(null);
            if (this.getInventory() != null) {
                this.getInventory().setDrawDirty(true);
            }
            return false;
        }
        float f = 12.0f;
        int n = this.Moodles.getMoodleLevel(MoodleType.Endurance);
        return !this.useHandWeapon.isCantAttackWithLowestEndurance() || n != 4;
    }

    public void ReduceHealthWhenBurning() {
        if (!this.OnFire) {
            return;
        }
        if (this.isGodMod()) {
            this.StopBurning();
            return;
        }
        if (GameClient.bClient && this.isZombie() && this instanceof IsoZombie && ((IsoZombie)this).isRemoteZombie()) {
            return;
        }
        if (GameClient.bClient && this instanceof IsoPlayer && ((IsoPlayer)this).bRemote) {
            return;
        }
        if (this.isAlive()) {
            if (!(this instanceof IsoPlayer)) {
                if (this.isZombie()) {
                    this.Health -= this.FireKillRate / 20.0f * GameTime.instance.getMultiplier();
                    this.setAttackedBy(null);
                } else {
                    this.Health -= this.FireKillRate * GameTime.instance.getMultiplier();
                }
            } else {
                float f = this.FireKillRate * GameTime.instance.getMultiplier() * GameTime.instance.getMinutesPerDay() / 1.6f;
                this.BodyDamage.ReduceGeneralHealth(f);
                LuaEventManager.triggerEvent("OnPlayerGetDamage", this, "FIRE", Float.valueOf(f));
                this.BodyDamage.OnFire(true);
            }
            if (this.isDead()) {
                IsoFireManager.RemoveBurningCharacter(this);
                if (this.isZombie()) {
                    LuaEventManager.triggerEvent("OnZombieDead", this);
                    if (GameClient.bClient) {
                        this.setAttackedBy(IsoWorld.instance.CurrentCell.getFakeZombieForHit());
                    }
                }
            }
        }
        if (this instanceof IsoPlayer && Rand.Next(Rand.AdjustForFramerate(((IsoPlayer)this).IsRunning() ? 150 : 400)) == 0) {
            this.StopBurning();
        }
    }

    public void DrawSneezeText() {
        if (this.BodyDamage.IsSneezingCoughing() > 0) {
            String string = null;
            if (this.BodyDamage.IsSneezingCoughing() == 1) {
                string = Translator.getText("IGUI_PlayerText_Sneeze");
            }
            if (this.BodyDamage.IsSneezingCoughing() == 2) {
                string = Translator.getText("IGUI_PlayerText_Cough");
            }
            if (this.BodyDamage.IsSneezingCoughing() == 3) {
                string = Translator.getText("IGUI_PlayerText_SneezeMuffled");
            }
            if (this.BodyDamage.IsSneezingCoughing() == 4) {
                string = Translator.getText("IGUI_PlayerText_CoughMuffled");
            }
            float f = this.sx;
            float f2 = this.sy;
            f = (int)f;
            f2 = (int)f2;
            f -= (float)((int)IsoCamera.getOffX());
            f2 -= (float)((int)IsoCamera.getOffY());
            f2 -= 48.0f;
            if (string != null) {
                TextManager.instance.DrawStringCentre(UIFont.Dialogue, (int)f, (int)f2, string, this.SpeakColour.r, this.SpeakColour.g, this.SpeakColour.b, this.SpeakColour.a);
            }
        }
    }

    @Override
    public IsoSpriteInstance getSpriteDef() {
        if (this.def == null) {
            this.def = new IsoSpriteInstance();
        }
        return this.def;
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        Object object;
        int n;
        IsoGridSquare isoGridSquare;
        if (this.isAlphaAndTargetZero()) {
            return;
        }
        if (this.isSeatedInVehicle() && !this.getVehicle().showPassenger(this)) {
            return;
        }
        if (this.isSpriteInvisible()) {
            return;
        }
        if (this.isAlphaZero()) {
            return;
        }
        if (!this.bUseParts && this.def == null) {
            this.def = new IsoSpriteInstance(this.sprite);
        }
        SpriteRenderer.instance.glDepthMask(true);
        if (this.bDoDefer && f3 - (float)((int)f3) > 0.2f && (isoGridSquare = this.getCell().getGridSquare((int)f, (int)f2, (int)f3 + 1)) != null) {
            isoGridSquare.addDeferredCharacter(this);
        }
        isoGridSquare = this.getCurrentSquare();
        if (PerformanceSettings.LightingFrameSkip < 3 && isoGridSquare != null) {
            isoGridSquare.interpolateLight(inf, f - (float)isoGridSquare.getX(), f2 - (float)isoGridSquare.getY());
        } else {
            IsoGameCharacter.inf.r = colorInfo.r;
            IsoGameCharacter.inf.g = colorInfo.g;
            IsoGameCharacter.inf.b = colorInfo.b;
            IsoGameCharacter.inf.a = colorInfo.a;
        }
        if (Core.bDebug && DebugOptions.instance.PathfindRenderWaiting.getValue() && this.hasActiveModel()) {
            if (this.getCurrentState() == PathFindState.instance() && this.finder.progress == AStarPathFinder.PathFindProgress.notyetfound) {
                this.legsSprite.modelSlot.model.tintR = 1.0f;
                this.legsSprite.modelSlot.model.tintG = 0.0f;
                this.legsSprite.modelSlot.model.tintB = 0.0f;
            } else {
                this.legsSprite.modelSlot.model.tintR = 1.0f;
                this.legsSprite.modelSlot.model.tintG = 1.0f;
                this.legsSprite.modelSlot.model.tintB = 1.0f;
            }
        }
        if (this.dir == IsoDirections.Max) {
            this.dir = IsoDirections.N;
        }
        if (this.sprite != null && !this.legsSprite.hasActiveModel()) {
            this.checkDrawWeaponPre(f, f2, f3, colorInfo);
        }
        lastRenderedRendered = lastRendered;
        lastRendered = this;
        this.checkUpdateModelTextures();
        float f4 = Core.TileScale;
        float f5 = this.offsetX + 1.0f * f4;
        float f6 = this.offsetY + -89.0f * f4;
        if (this.sprite != null) {
            this.def.setScale(f4, f4);
            if (!this.bUseParts) {
                this.sprite.render(this.def, this, f, f2, f3, this.dir, f5, f6, inf, true);
            } else if (this.legsSprite.hasActiveModel()) {
                this.legsSprite.renderActiveModel();
            } else if (!this.renderTextureInsteadOfModel(f, f2)) {
                this.def.Flip = false;
                IsoGameCharacter.inf.r = 1.0f;
                IsoGameCharacter.inf.g = 1.0f;
                IsoGameCharacter.inf.b = 1.0f;
                IsoGameCharacter.inf.a = this.def.alpha * 0.4f;
                this.legsSprite.renderCurrentAnim(this.def, this, f, f2, f3, this.dir, f5, f6, inf, false, null);
            }
        }
        if (this.AttachedAnimSprite != null) {
            for (n = 0; n < this.AttachedAnimSprite.size(); ++n) {
                object = (IsoSpriteInstance)this.AttachedAnimSprite.get(n);
                ((IsoSpriteInstance)object).update();
                float f7 = IsoGameCharacter.inf.a;
                IsoGameCharacter.inf.a = ((IsoSpriteInstance)object).alpha;
                ((IsoSpriteInstance)object).SetTargetAlpha(this.getTargetAlpha());
                ((IsoSpriteInstance)object).render(this, f, f2, f3, this.dir, f5, f6, inf);
                IsoGameCharacter.inf.a = f7;
            }
        }
        for (n = 0; n < this.inventory.Items.size(); ++n) {
            object = this.inventory.Items.get(n);
            if (!(object instanceof IUpdater)) continue;
            ((IUpdater)object).render();
        }
    }

    public void renderServerGUI() {
        if (this instanceof IsoPlayer) {
            this.setSceneCulled(false);
        }
        if (this.bUpdateModelTextures && this.hasActiveModel()) {
            this.bUpdateModelTextures = false;
            this.textureCreator = ModelInstanceTextureCreator.alloc();
            this.textureCreator.init(this);
        }
        float f = Core.TileScale;
        float f2 = this.offsetX + 1.0f * f;
        float f3 = this.offsetY + -89.0f * f;
        if (this.sprite != null) {
            this.def.setScale(f, f);
            IsoGameCharacter.inf.r = 1.0f;
            IsoGameCharacter.inf.g = 1.0f;
            IsoGameCharacter.inf.b = 1.0f;
            IsoGameCharacter.inf.a = this.def.alpha * 0.4f;
            if (!this.isbUseParts()) {
                this.sprite.render(this.def, this, this.x, this.y, this.z, this.dir, f2, f3, inf, true);
            } else {
                this.def.Flip = false;
                this.legsSprite.render(this.def, this, this.x, this.y, this.z, this.dir, f2, f3, inf, true);
            }
        }
        if (Core.bDebug && this.hasActiveModel()) {
            if (this instanceof IsoZombie) {
                int n = (int)IsoUtils.XToScreenExact(this.x, this.y, this.z, 0);
                int n2 = (int)IsoUtils.YToScreenExact(this.x, this.y, this.z, 0);
                TextManager.instance.DrawString(n, n2, "ID: " + this.getOnlineID());
                TextManager.instance.DrawString(n, n2 + 10, "State: " + this.getCurrentStateName());
                TextManager.instance.DrawString(n, n2 + 20, "Health: " + this.getHealth());
            }
            Vector2 vector22 = tempo;
            this.getDeferredMovement(vector22);
            this.drawDirectionLine(vector22, 1000.0f * vector22.getLength() / GameTime.instance.getMultiplier() * 2.0f, 1.0f, 0.5f, 0.5f);
        }
    }

    @Override
    protected float getAlphaUpdateRateMul() {
        float f = super.getAlphaUpdateRateMul();
        if (IsoCamera.CamCharacter.Traits.ShortSighted.isSet()) {
            f /= 2.0f;
        }
        if (IsoCamera.CamCharacter.Traits.EagleEyed.isSet()) {
            f *= 1.5f;
        }
        return f;
    }

    @Override
    protected boolean isUpdateAlphaEnabled() {
        return !this.isTeleporting();
    }

    @Override
    protected boolean isUpdateAlphaDuringRender() {
        return false;
    }

    public boolean isSeatedInVehicle() {
        return this.vehicle != null && this.vehicle.getSeat(this) != -1;
    }

    @Override
    public void renderObjectPicker(float f, float f2, float f3, ColorInfo colorInfo) {
        if (!this.bUseParts) {
            this.sprite.renderObjectPicker(this.def, this, this.dir);
        } else {
            this.legsSprite.renderObjectPicker(this.def, this, this.dir);
        }
    }

    static Vector2 closestpointonline(double d, double d2, double d3, double d4, double d5, double d6, Vector2 vector22) {
        double d7;
        double d8;
        double d9 = d4 - d2;
        double d10 = d - d3;
        double d11 = (d4 - d2) * d + (d - d3) * d2;
        double d12 = -d10 * d5 + d9 * d6;
        double d13 = d9 * d9 - -d10 * d10;
        if (d13 != 0.0) {
            d8 = (d9 * d11 - d10 * d12) / d13;
            d7 = (d9 * d12 - -d10 * d11) / d13;
        } else {
            d8 = d5;
            d7 = d6;
        }
        return vector22.set((float)d8, (float)d7);
    }

    public void renderShadow(float f, float f2, float f3) {
        Object object;
        if (!this.doRenderShadow) {
            return;
        }
        if (this.isAlphaAndTargetZero()) {
            return;
        }
        if (this.isSeatedInVehicle()) {
            return;
        }
        IsoGridSquare isoGridSquare = this.getCurrentSquare();
        if (isoGridSquare == null) {
            return;
        }
        int n = IsoCamera.frameState.playerIndex;
        Vector3f vector3f = L_renderShadow.forward;
        Vector2 vector22 = this.getAnimVector(tempo2);
        vector3f.set(vector22.x, vector22.y, 0.0f);
        float f4 = 0.45f;
        float f5 = 1.4f;
        float f6 = 1.125f;
        float f7 = this.getAlpha(n);
        if (this.hasActiveModel() && this.hasAnimationPlayer() && this.getAnimationPlayer().isReady()) {
            object = this.getAnimationPlayer();
            Vector3 vector3 = L_renderShadow.v1;
            Model.BoneToWorldCoords(this, ((AnimationPlayer)object).getSkinningBoneIndex("Bip01_Head", -1), vector3);
            float f8 = vector3.x;
            float f9 = vector3.y;
            Model.BoneToWorldCoords(this, ((AnimationPlayer)object).getSkinningBoneIndex("Bip01_L_Foot", -1), vector3);
            float f10 = vector3.x;
            float f11 = vector3.y;
            Model.BoneToWorldCoords(this, ((AnimationPlayer)object).getSkinningBoneIndex("Bip01_R_Foot", -1), vector3);
            float f12 = vector3.x;
            float f13 = vector3.y;
            Vector3f vector3f2 = L_renderShadow.v3;
            float f14 = 0.0f;
            float f15 = 0.0f;
            Vector2 vector23 = IsoGameCharacter.closestpointonline(f, f2, f + vector3f.x, f2 + vector3f.y, f8, f9, tempo);
            float f16 = vector23.x;
            float f17 = vector23.y;
            float f18 = vector23.set(f16 - f, f17 - f2).getLength();
            if (f18 > 0.001f) {
                vector3f2.set(f16 - f, f17 - f2, 0.0f).normalize();
                if (vector3f.dot((Vector3fc)vector3f2) > 0.0f) {
                    f14 = Math.max(f14, f18);
                } else {
                    f15 = Math.max(f15, f18);
                }
            }
            if ((f18 = (vector23 = IsoGameCharacter.closestpointonline(f, f2, f + vector3f.x, f2 + vector3f.y, f10, f11, tempo)).set((f16 = vector23.x) - f, (f17 = vector23.y) - f2).getLength()) > 0.001f) {
                vector3f2.set(f16 - f, f17 - f2, 0.0f).normalize();
                if (vector3f.dot((Vector3fc)vector3f2) > 0.0f) {
                    f14 = Math.max(f14, f18);
                } else {
                    f15 = Math.max(f15, f18);
                }
            }
            if ((f18 = (vector23 = IsoGameCharacter.closestpointonline(f, f2, f + vector3f.x, f2 + vector3f.y, f12, f13, tempo)).set((f16 = vector23.x) - f, (f17 = vector23.y) - f2).getLength()) > 0.001f) {
                vector3f2.set(f16 - f, f17 - f2, 0.0f).normalize();
                if (vector3f.dot((Vector3fc)vector3f2) > 0.0f) {
                    f14 = Math.max(f14, f18);
                } else {
                    f15 = Math.max(f15, f18);
                }
            }
            f5 = (f14 + 0.35f) * 1.35f;
            f6 = (f15 + 0.35f) * 1.35f;
            float f19 = 0.1f * (GameTime.getInstance().getMultiplier() / 1.6f);
            f19 = PZMath.clamp(f19, 0.0f, 1.0f);
            if (this.shadowTick != IngameState.instance.numberTicks - 1L) {
                this.m_shadowFM = f5;
                this.m_shadowBM = f6;
            }
            this.shadowTick = IngameState.instance.numberTicks;
            f5 = this.m_shadowFM = PZMath.lerp(this.m_shadowFM, f5, f19);
            f6 = this.m_shadowBM = PZMath.lerp(this.m_shadowBM, f6, f19);
        } else if (this.isZombie() && this.isCurrentState(FakeDeadZombieState.instance())) {
            f7 = 1.0f;
        } else if (this.isSceneCulled()) {
            return;
        }
        object = isoGridSquare.lighting[n].lightInfo();
        IsoDeadBody.renderShadow(f, f2, f3, vector3f, f4, f5, f6, (ColorInfo)object, f7);
    }

    public void checkUpdateModelTextures() {
        if (this.bUpdateModelTextures && this.hasActiveModel()) {
            this.bUpdateModelTextures = false;
            this.textureCreator = ModelInstanceTextureCreator.alloc();
            this.textureCreator.init(this);
        }
        if (this.bUpdateEquippedTextures && this.hasActiveModel()) {
            this.bUpdateEquippedTextures = false;
            if (this.primaryHandModel != null && this.primaryHandModel.getTextureInitializer() != null) {
                this.primaryHandModel.getTextureInitializer().setDirty();
            }
            if (this.secondaryHandModel != null && this.secondaryHandModel.getTextureInitializer() != null) {
                this.secondaryHandModel.getTextureInitializer().setDirty();
            }
        }
    }

    @Override
    public boolean isMaskClicked(int n, int n2, boolean bl) {
        if (this.sprite == null) {
            return false;
        }
        if (!this.bUseParts) {
            return super.isMaskClicked(n, n2, bl);
        }
        return this.legsSprite.isMaskClicked(this.dir, n, n2, bl);
    }

    @Override
    public void setHaloNote(String string) {
        this.setHaloNote(string, this.haloDispTime);
    }

    @Override
    public void setHaloNote(String string, float f) {
        this.setHaloNote(string, 0, 255, 0, f);
    }

    @Override
    public void setHaloNote(String string, int n, int n2, int n3, float f) {
        if (this.haloNote != null && string != null) {
            this.haloDispTime = f;
            this.haloNote.setDefaultColors(n, n2, n3);
            this.haloNote.ReadString(string);
            this.haloNote.setInternalTickClock(this.haloDispTime);
        }
    }

    public float getHaloTimerCount() {
        if (this.haloNote != null) {
            return this.haloNote.getInternalClock();
        }
        return 0.0f;
    }

    public void DoSneezeText() {
        if (this.BodyDamage == null) {
            return;
        }
        if (this.BodyDamage.IsSneezingCoughing() > 0) {
            String string = null;
            int n = 0;
            if (this.BodyDamage.IsSneezingCoughing() == 1) {
                string = Translator.getText("IGUI_PlayerText_Sneeze");
                n = Rand.Next(2) + 1;
                this.setVariable("Ext", "Sneeze" + n);
            }
            if (this.BodyDamage.IsSneezingCoughing() == 2) {
                string = Translator.getText("IGUI_PlayerText_Cough");
                this.setVariable("Ext", "Cough");
            }
            if (this.BodyDamage.IsSneezingCoughing() == 3) {
                string = Translator.getText("IGUI_PlayerText_SneezeMuffled");
                n = Rand.Next(2) + 1;
                this.setVariable("Ext", "Sneeze" + n);
            }
            if (this.BodyDamage.IsSneezingCoughing() == 4) {
                string = Translator.getText("IGUI_PlayerText_CoughMuffled");
                this.setVariable("Ext", "Cough");
            }
            if (string != null) {
                this.Say(string);
                this.reportEvent("EventDoExt");
                if (GameClient.bClient && this instanceof IsoPlayer && ((IsoPlayer)this).isLocalPlayer()) {
                    GameClient.sendSneezingCoughing(this.getOnlineID(), this.BodyDamage.IsSneezingCoughing(), (byte)n);
                }
            }
        }
    }

    @Override
    public String getSayLine() {
        return this.chatElement.getSayLine();
    }

    public void setSayLine(String string) {
        this.Say(string);
    }

    public ChatMessage getLastChatMessage() {
        return this.lastChatMessage;
    }

    public void setLastChatMessage(ChatMessage chatMessage) {
        this.lastChatMessage = chatMessage;
    }

    public String getLastSpokenLine() {
        return this.lastSpokenLine;
    }

    public void setLastSpokenLine(String string) {
        this.lastSpokenLine = string;
    }

    protected void doSleepSpeech() {
        ++this.sleepSpeechCnt;
        if ((float)this.sleepSpeechCnt > (float)(250 * PerformanceSettings.getLockFPS()) / 30.0f) {
            this.sleepSpeechCnt = 0;
            if (sleepText == null) {
                sleepText = "ZzzZZZzzzz";
                ChatElement.addNoLogText(sleepText);
            }
            this.SayWhisper(sleepText);
        }
    }

    public void SayDebug(String string) {
        this.chatElement.SayDebug(0, string);
    }

    public void SayDebug(int n, String string) {
        this.chatElement.SayDebug(n, string);
    }

    public int getMaxChatLines() {
        return this.chatElement.getMaxChatLines();
    }

    @Override
    public void Say(String string) {
        if (this.isZombie()) {
            return;
        }
        this.ProcessSay(string, this.SpeakColour.r, this.SpeakColour.g, this.SpeakColour.b, 30.0f, 0, "default");
    }

    @Override
    public void Say(String string, float f, float f2, float f3, UIFont uIFont, float f4, String string2) {
        this.ProcessSay(string, f, f2, f3, f4, 0, string2);
    }

    public void SayWhisper(String string) {
        this.ProcessSay(string, this.SpeakColour.r, this.SpeakColour.g, this.SpeakColour.b, 10.0f, 0, "whisper");
    }

    public void SayShout(String string) {
        this.ProcessSay(string, this.SpeakColour.r, this.SpeakColour.g, this.SpeakColour.b, 60.0f, 0, "shout");
    }

    public void SayRadio(String string, float f, float f2, float f3, UIFont uIFont, float f4, int n, String string2) {
        this.ProcessSay(string, f, f2, f3, f4, n, string2);
    }

    private void ProcessSay(String string, float f, float f2, float f3, float f4, int n, String string2) {
        if (!this.AllowConversation) {
            return;
        }
        if (TutorialManager.instance.ProfanityFilter) {
            string = ProfanityFilter.getInstance().filterString(string);
        }
        if (string2.equals("default")) {
            ChatManager.getInstance().showInfoMessage(((IsoPlayer)this).getUsername(), string);
            this.lastSpokenLine = string;
        } else if (string2.equals("whisper")) {
            this.lastSpokenLine = string;
        } else if (string2.equals("shout")) {
            ChatManager.getInstance().sendMessageToChat(((IsoPlayer)this).getUsername(), ChatType.shout, string);
            this.lastSpokenLine = string;
        } else if (string2.equals("radio")) {
            UIFont uIFont = UIFont.Medium;
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = true;
            this.chatElement.addChatLine(string, f, f2, f3, uIFont, f4, string2, bl, bl2, bl3, bl4, bl5, bl6);
            if (ZomboidRadio.isStaticSound(string)) {
                ChatManager.getInstance().showStaticRadioSound(string);
            } else {
                ChatManager.getInstance().showRadioMessage(string, n);
            }
        }
    }

    public void addLineChatElement(String string) {
        this.addLineChatElement(string, 1.0f, 1.0f, 1.0f);
    }

    public void addLineChatElement(String string, float f, float f2, float f3) {
        this.addLineChatElement(string, f, f2, f3, UIFont.Dialogue, 30.0f, "default");
    }

    public void addLineChatElement(String string, float f, float f2, float f3, UIFont uIFont, float f4, String string2) {
        this.addLineChatElement(string, f, f2, f3, uIFont, f4, string2, false, false, false, false, false, true);
    }

    public void addLineChatElement(String string, float f, float f2, float f3, UIFont uIFont, float f4, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.chatElement.addChatLine(string, f, f2, f3, uIFont, f4, string2, bl, bl2, bl3, bl4, bl5, bl6);
    }

    protected boolean playerIsSelf() {
        return IsoPlayer.getInstance() == this;
    }

    public int getUserNameHeight() {
        if (!GameClient.bClient) {
            return 0;
        }
        if (this.userName != null) {
            return this.userName.getHeight();
        }
        return 0;
    }

    protected void initTextObjects() {
        this.hasInitTextObjects = true;
        if (this instanceof IsoPlayer) {
            this.chatElement.setMaxChatLines(5);
            if (IsoPlayer.getInstance() != null) {
                System.out.println("FirstNAME:" + IsoPlayer.getInstance().username);
            }
            this.isoPlayer = (IsoPlayer)this;
            if (this.isoPlayer.username != null) {
                this.userName = new TextDrawObject();
                this.userName.setAllowAnyImage(true);
                this.userName.setDefaultFont(UIFont.Small);
                this.userName.setDefaultColors(255, 255, 255, 255);
                this.updateUserName();
            }
            if (this.haloNote == null) {
                this.haloNote = new TextDrawObject();
                this.haloNote.setDefaultFont(UIFont.Small);
                this.haloNote.setDefaultColors(0, 255, 0);
                this.haloNote.setDrawBackground(true);
                this.haloNote.setAllowImages(true);
                this.haloNote.setAllowAnyImage(true);
                this.haloNote.setOutlineColors(0.0f, 0.0f, 0.0f, 0.33f);
            }
        }
    }

    protected void updateUserName() {
        if (this.userName != null && this.isoPlayer != null) {
            BaseVehicle baseVehicle;
            boolean bl;
            Object object = this.isoPlayer.getUsername(true);
            if (this != IsoPlayer.getInstance() && this.isInvisible() && IsoPlayer.getInstance() != null && IsoPlayer.getInstance().accessLevel.equals("") && (!Core.bDebug || !DebugOptions.instance.CheatPlayerSeeEveryone.getValue())) {
                this.userName.ReadString("");
                return;
            }
            Faction faction = Faction.getPlayerFaction(this.isoPlayer);
            if (faction != null) {
                if (this.isoPlayer.showTag || this.isoPlayer == IsoPlayer.getInstance() || Faction.getPlayerFaction(IsoPlayer.getInstance()) == faction) {
                    this.isoPlayer.tagPrefix = faction.getTag();
                    if (faction.getTagColor() != null) {
                        this.isoPlayer.setTagColor(faction.getTagColor());
                    }
                } else {
                    this.isoPlayer.tagPrefix = "";
                }
            } else {
                this.isoPlayer.tagPrefix = "";
            }
            boolean bl2 = this.isoPlayer != null && this.isoPlayer.bRemote || Core.getInstance().isShowYourUsername();
            boolean bl3 = IsoCamera.CamCharacter instanceof IsoPlayer && !((IsoPlayer)IsoCamera.CamCharacter).accessLevel.equals("");
            boolean bl4 = bl = IsoCamera.CamCharacter instanceof IsoPlayer && ((IsoPlayer)IsoCamera.CamCharacter).canSeeAll;
            if (!(ServerOptions.instance.DisplayUserName.getValue() || ServerOptions.instance.ShowFirstAndLastName.getValue() || bl)) {
                bl2 = false;
            }
            if (!bl2) {
                object = "";
            }
            if (bl2 && this.isoPlayer.tagPrefix != null && !this.isoPlayer.tagPrefix.equals("")) {
                object = "[col=" + new Float(this.isoPlayer.getTagColor().r * 255.0f).intValue() + "," + new Float(this.isoPlayer.getTagColor().g * 255.0f).intValue() + "," + new Float(this.isoPlayer.getTagColor().b * 255.0f).intValue() + "][" + this.isoPlayer.tagPrefix + "][/] " + (String)object;
            }
            if (bl2 && !this.isoPlayer.accessLevel.equals("") && this.isoPlayer.isShowAdminTag()) {
                object = this.namesPrefix.get(this.isoPlayer.accessLevel) + (String)object;
            }
            if (bl2 && !this.isoPlayer.getSafety().isEnabled() && ServerOptions.instance.ShowSafety.getValue() && NonPvpZone.getNonPvpZone(PZMath.fastfloor(this.isoPlayer.x), PZMath.fastfloor(this.isoPlayer.y)) == null) {
                object = (String)object + namePvpSuffix;
            }
            if (this.isoPlayer.isSpeek && !this.isoPlayer.isVoiceMute) {
                object = voiceSuffix + (String)object;
            }
            if (this.isoPlayer.isVoiceMute) {
                object = voiceMuteSuffix + (String)object;
            }
            BaseVehicle baseVehicle2 = baseVehicle = IsoCamera.CamCharacter == this.isoPlayer ? this.isoPlayer.getNearVehicle() : null;
            if (this.getVehicle() == null && baseVehicle != null && (this.isoPlayer.getInventory().haveThisKeyId(baseVehicle.getKeyId()) != null || baseVehicle.isHotwired() || SandboxOptions.getInstance().VehicleEasyUse.getValue())) {
                Color color = Color.HSBtoRGB(baseVehicle.colorHue, baseVehicle.colorSaturation * 0.5f, baseVehicle.colorValue);
                object = " [img=media/ui/CarKey.png," + color.getRedByte() + "," + color.getGreenByte() + "," + color.getBlueByte() + "]" + (String)object;
            }
            if (!((String)object).equals(this.userName.getOriginal())) {
                this.userName.ReadString((String)object);
            }
        }
    }

    public void updateTextObjects() {
        if (GameServer.bServer) {
            return;
        }
        if (!this.hasInitTextObjects) {
            this.initTextObjects();
        }
        if (!this.Speaking) {
            this.DoSneezeText();
            if (this.isAsleep() && this.getCurrentSquare() != null && this.getCurrentSquare().getCanSee(0)) {
                this.doSleepSpeech();
            }
        }
        if (this.isoPlayer != null) {
            this.radioEquipedCheck();
        }
        this.Speaking = false;
        this.drawUserName = false;
        this.canSeeCurrent = false;
        if (this.haloNote != null && this.haloNote.getInternalClock() > 0.0f) {
            this.haloNote.updateInternalTickClock();
        }
        this.legsSprite.PlayAnim("ZombieWalk1");
        this.chatElement.update();
        this.Speaking = this.chatElement.IsSpeaking();
        if (!this.Speaking || this.isDead()) {
            this.Speaking = false;
            this.callOut = false;
        }
    }

    @Override
    public void renderlast() {
        block73: {
            block74: {
                float f;
                super.renderlast();
                int n = IsoCamera.frameState.playerIndex;
                float f2 = this.x;
                float f3 = this.y;
                if (this.sx == 0.0f && this.def != null) {
                    this.sx = IsoUtils.XToScreen(f2 + this.def.offX, f3 + this.def.offY, this.z + this.def.offZ, 0);
                    this.sy = IsoUtils.YToScreen(f2 + this.def.offX, f3 + this.def.offY, this.z + this.def.offZ, 0);
                    this.sx -= this.offsetX - 8.0f;
                    this.sy -= this.offsetY - 60.0f;
                }
                if (this.hasInitTextObjects && this.isoPlayer != null || this.chatElement.getHasChatToDisplay()) {
                    int n2;
                    Object object;
                    float f4 = IsoUtils.XToScreen(f2, f3, this.getZ(), 0);
                    float f5 = IsoUtils.YToScreen(f2, f3, this.getZ(), 0);
                    f4 = f4 - IsoCamera.getOffX() - this.offsetX;
                    f5 = f5 - IsoCamera.getOffY() - this.offsetY;
                    f5 -= (float)(128 / (2 / Core.TileScale));
                    f = Core.getInstance().getZoom(n);
                    f4 /= f;
                    f5 /= f;
                    this.canSeeCurrent = true;
                    this.drawUserName = false;
                    if (this.isoPlayer != null && (this == IsoCamera.frameState.CamCharacter || this.getCurrentSquare() != null && this.getCurrentSquare().getCanSee(n)) || IsoPlayer.getInstance().isCanSeeAll()) {
                        if (this == IsoPlayer.getInstance()) {
                            this.canSeeCurrent = true;
                        }
                        if (GameClient.bClient && this.userName != null && this.doRenderShadow) {
                            this.drawUserName = false;
                            if (ServerOptions.getInstance().MouseOverToSeeDisplayName.getValue() && this != IsoPlayer.getInstance() && !IsoPlayer.getInstance().isCanSeeAll()) {
                                object = IsoObjectPicker.Instance.ContextPick(Mouse.getXA(), Mouse.getYA());
                                if (object != null && ((IsoObjectPicker.ClickObject)object).tile != null) {
                                    block0: for (n2 = ((IsoObjectPicker.ClickObject)object).tile.square.getX() - 1; n2 < ((IsoObjectPicker.ClickObject)object).tile.square.getX() + 2; ++n2) {
                                        for (int i = ((IsoObjectPicker.ClickObject)object).tile.square.getY() - 1; i < ((IsoObjectPicker.ClickObject)object).tile.square.getY() + 2; ++i) {
                                            IsoGridSquare object2 = IsoCell.getInstance().getGridSquare(n2, i, ((IsoObjectPicker.ClickObject)object).tile.square.getZ());
                                            if (object2 != null) {
                                                for (int j = 0; j < object2.getMovingObjects().size(); ++j) {
                                                    IsoMovingObject isoMovingObject = object2.getMovingObjects().get(j);
                                                    if (!(isoMovingObject instanceof IsoPlayer) || this != isoMovingObject) continue;
                                                    this.drawUserName = true;
                                                    break;
                                                }
                                                if (this.drawUserName) continue block0;
                                            }
                                            if (this.drawUserName) continue block0;
                                        }
                                    }
                                }
                            } else {
                                this.drawUserName = true;
                            }
                            if (this.drawUserName) {
                                this.updateUserName();
                            }
                        }
                        if (!GameClient.bClient && this.isoPlayer != null && this.isoPlayer.getVehicle() == null) {
                            object = "";
                            BaseVehicle baseVehicle = this.isoPlayer.getNearVehicle();
                            if (this.getVehicle() == null && baseVehicle != null && baseVehicle.getPartById("Engine") != null && (this.isoPlayer.getInventory().haveThisKeyId(baseVehicle.getKeyId()) != null || baseVehicle.isHotwired() || SandboxOptions.getInstance().VehicleEasyUse.getValue()) && UIManager.VisibleAllUI) {
                                Color color = Color.HSBtoRGB(baseVehicle.colorHue, baseVehicle.colorSaturation * 0.5f, baseVehicle.colorValue, L_renderLast.color);
                                object = " [img=media/ui/CarKey.png," + color.getRedByte() + "," + color.getGreenByte() + "," + color.getBlueByte() + "]";
                            }
                            if (!((String)object).equals("")) {
                                this.userName.ReadString((String)object);
                                this.drawUserName = true;
                            }
                        }
                    }
                    if (this.isoPlayer != null && this.hasInitTextObjects && (this.playerIsSelf() || this.canSeeCurrent)) {
                        if (this.canSeeCurrent && this.drawUserName) {
                            this.userName.AddBatchedDraw((int)f4, (int)(f5 -= (float)this.userName.getHeight()), true);
                        }
                        if (this.playerIsSelf() && (object = UIManager.getProgressBar(n)) != null && ((UIElement)object).isVisible().booleanValue()) {
                            f5 -= (float)(((UIElement)object).getHeight().intValue() + 2);
                        }
                        if (this.playerIsSelf() && this.haloNote != null && this.haloNote.getInternalClock() > 0.0f) {
                            float f6 = this.haloNote.getInternalClock() / (this.haloDispTime / 4.0f);
                            f6 = PZMath.min(f6, 1.0f);
                            this.haloNote.AddBatchedDraw((int)f4, (int)(f5 -= (float)(this.haloNote.getHeight() + 2)), true, f6);
                        }
                    }
                    boolean bl = false;
                    if (IsoPlayer.getInstance() != this && this.equipedRadio != null && this.equipedRadio.getDeviceData() != null && this.equipedRadio.getDeviceData().getHeadphoneType() >= 0) {
                        bl = true;
                    }
                    if (this.equipedRadio != null && this.equipedRadio.getDeviceData() != null && !this.equipedRadio.getDeviceData().getIsTurnedOn()) {
                        bl = true;
                    }
                    int n3 = n2 = GameClient.bClient && IsoCamera.CamCharacter instanceof IsoPlayer && !((IsoPlayer)IsoCamera.CamCharacter).accessLevel.equals("") ? 1 : 0;
                    if (!this.m_invisible || this == IsoCamera.frameState.CamCharacter || n2 != 0) {
                        this.chatElement.renderBatched(IsoPlayer.getPlayerIndex(), (int)f4, (int)f5, bl);
                    }
                }
                if (Core.bDebug && DebugOptions.instance.Character.Debug.Render.Angle.getValue() && this.hasActiveModel()) {
                    Vector2 vector22 = tempo;
                    AnimationPlayer animationPlayer = this.getAnimationPlayer();
                    vector22.set(this.dir.ToVector());
                    this.drawDirectionLine(vector22, 2.4f, 0.0f, 1.0f, 0.0f);
                    vector22.setLengthAndDirection(this.getLookAngleRadians(), 1.0f);
                    this.drawDirectionLine(vector22, 2.0f, 1.0f, 1.0f, 1.0f);
                    vector22.setLengthAndDirection(this.getAnimAngleRadians(), 1.0f);
                    this.drawDirectionLine(vector22, 2.0f, 1.0f, 1.0f, 0.0f);
                    f = this.getForwardDirection().getDirection();
                    vector22.setLengthAndDirection(f, 1.0f);
                    this.drawDirectionLine(vector22, 2.0f, 0.0f, 0.0f, 1.0f);
                }
                if (Core.bDebug && DebugOptions.instance.Character.Debug.Render.DeferredMovement.getValue() && this.hasActiveModel()) {
                    Vector2 vector23 = tempo;
                    AnimationPlayer animationPlayer = this.getAnimationPlayer();
                    this.getDeferredMovement(vector23);
                    this.drawDirectionLine(vector23, 1000.0f * vector23.getLength() / GameTime.instance.getMultiplier() * 2.0f, 1.0f, 0.5f, 0.5f);
                }
                if (Core.bDebug && DebugOptions.instance.Character.Debug.Render.DeferredAngles.getValue() && this.hasActiveModel()) {
                    Vector2 vector24 = tempo;
                    AnimationPlayer animationPlayer = this.getAnimationPlayer();
                    this.getDeferredMovement(vector24);
                    this.drawDirectionLine(vector24, 1000.0f * vector24.getLength() / GameTime.instance.getMultiplier() * 2.0f, 1.0f, 0.5f, 0.5f);
                }
                if (Core.bDebug && DebugOptions.instance.Character.Debug.Render.AimCone.getValue()) {
                    this.debugAim();
                }
                if (Core.bDebug && DebugOptions.instance.Character.Debug.Render.TestDotSide.getValue()) {
                    this.debugTestDotSide();
                }
                if (Core.bDebug && DebugOptions.instance.Character.Debug.Render.Vision.getValue()) {
                    this.debugVision();
                }
                if (!Core.bDebug) break block73;
                if (DebugOptions.instance.MultiplayerShowZombieMultiplier.getValue() && this instanceof IsoZombie) {
                    IsoZombie isoZombie = (IsoZombie)this;
                    byte by = isoZombie.canHaveMultipleHits();
                    Color color = by == 0 ? Colors.Green : (by == 1 ? Colors.Yellow : Colors.Red);
                    LineDrawer.DrawIsoCircle(this.x, this.y, this.z, 0.45f, 4, color.r, color.g, color.b, 0.5f);
                    TextManager.instance.DrawStringCentre(UIFont.DebugConsole, IsoUtils.XToScreenExact(this.x + 0.4f, this.y + 0.4f, this.z, 0), IsoUtils.YToScreenExact(this.x + 0.4f, this.y - 1.4f, this.z, 0), String.valueOf(isoZombie.OnlineID), color.r, color.g, color.b, color.a);
                }
                if (DebugOptions.instance.MultiplayerShowZombieOwner.getValue() && this instanceof IsoZombie) {
                    IsoZombie isoZombie = (IsoZombie)this;
                    Color color = isoZombie.isDead() ? Colors.Yellow : (isoZombie.isRemoteZombie() ? Colors.OrangeRed : Colors.Chartreuse);
                    LineDrawer.DrawIsoCircle(this.x, this.y, this.z, 0.45f, 4, color.r, color.g, color.b, 0.5f);
                    TextManager.instance.DrawStringCentre(UIFont.DebugConsole, IsoUtils.XToScreenExact(this.x + 0.4f, this.y + 0.4f, this.z, 0), IsoUtils.YToScreenExact(this.x + 0.4f, this.y - 1.4f, this.z, 0), String.valueOf(isoZombie.OnlineID), color.r, color.g, color.b, color.a);
                }
                if (DebugOptions.instance.MultiplayerShowZombiePrediction.getValue() && this instanceof IsoZombie) {
                    IsoZombie isoZombie = (IsoZombie)this;
                    LineDrawer.DrawIsoTransform(this.realx, this.realy, this.z, this.realdir.ToVector().x, this.realdir.ToVector().y, 0.35f, 16, Colors.Blue.r, Colors.Blue.g, Colors.Blue.b, 0.35f, 1);
                    if (isoZombie.networkAI.DebugInterfaceActive) {
                        LineDrawer.DrawIsoCircle(this.x, this.y, this.z, 0.4f, 4, 1.0f, 0.1f, 0.1f, 0.35f);
                    } else if (!isoZombie.isRemoteZombie()) {
                        LineDrawer.DrawIsoCircle(this.x, this.y, this.z, 0.3f, 3, Colors.Magenta.r, Colors.Magenta.g, Colors.Magenta.b, 0.35f);
                    } else {
                        LineDrawer.DrawIsoCircle(this.x, this.y, this.z, 0.3f, 5, Colors.Magenta.r, Colors.Magenta.g, Colors.Magenta.b, 0.35f);
                    }
                    LineDrawer.DrawIsoTransform(isoZombie.networkAI.targetX, isoZombie.networkAI.targetY, this.z, 1.0f, 0.0f, 0.4f, 16, Colors.LimeGreen.r, Colors.LimeGreen.g, Colors.LimeGreen.b, 0.35f, 1);
                    LineDrawer.DrawIsoLine(this.x, this.y, this.z, isoZombie.networkAI.targetX, isoZombie.networkAI.targetY, this.z, Colors.LimeGreen.r, Colors.LimeGreen.g, Colors.LimeGreen.b, 0.35f, 1);
                    if (IsoUtils.DistanceToSquared(this.x, this.y, this.realx, this.realy) > 4.5f) {
                        LineDrawer.DrawIsoLine(this.realx, this.realy, this.z, this.x, this.y, this.z, Colors.Magenta.r, Colors.Magenta.g, Colors.Magenta.b, 0.35f, 1);
                    } else {
                        LineDrawer.DrawIsoLine(this.realx, this.realy, this.z, this.x, this.y, this.z, Colors.Blue.r, Colors.Blue.g, Colors.Blue.b, 0.35f, 1);
                    }
                }
                if (DebugOptions.instance.MultiplayerShowZombieDesync.getValue() && this instanceof IsoZombie) {
                    IsoZombie isoZombie = (IsoZombie)this;
                    float f7 = IsoUtils.DistanceTo(this.getX(), this.getY(), this.realx, this.realy);
                    if (isoZombie.isRemoteZombie() && f7 > 1.0f) {
                        LineDrawer.DrawIsoLine(this.realx, this.realy, this.z, this.x, this.y, this.z, Colors.Blue.r, Colors.Blue.g, Colors.Blue.b, 0.9f, 1);
                        LineDrawer.DrawIsoTransform(this.realx, this.realy, this.z, this.realdir.ToVector().x, this.realdir.ToVector().y, 0.35f, 16, Colors.Blue.r, Colors.Blue.g, Colors.Blue.b, 0.9f, 1);
                        LineDrawer.DrawIsoCircle(this.x, this.y, this.z, 0.4f, 4, 1.0f, 1.0f, 1.0f, 0.9f);
                        float f8 = IsoUtils.DistanceTo(this.realx, this.realy, isoZombie.networkAI.targetX, isoZombie.networkAI.targetY);
                        float f9 = IsoUtils.DistanceTo(this.x, this.y, isoZombie.networkAI.targetX, isoZombie.networkAI.targetY) / f8;
                        float f10 = IsoUtils.XToScreenExact(this.x, this.y, this.z, 0);
                        float f11 = IsoUtils.YToScreenExact(this.x, this.y, this.z, 0);
                        TextManager.instance.DrawStringCentre(UIFont.DebugConsole, f10, f11, String.format("dist:%f scale1:%f", Float.valueOf(f7), Float.valueOf(f9)), Colors.NavajoWhite.r, Colors.NavajoWhite.g, Colors.NavajoWhite.b, 0.9f);
                    }
                }
                if (DebugOptions.instance.MultiplayerShowHit.getValue() && this.getHitReactionNetworkAI() != null && this.getHitReactionNetworkAI().isSetup()) {
                    LineDrawer.DrawIsoLine(this.x, this.y, this.z, this.x + this.getHitDir().getX(), this.y + this.getHitDir().getY(), this.z, Colors.BlueViolet.r, Colors.BlueViolet.g, Colors.BlueViolet.b, 0.8f, 1);
                    LineDrawer.DrawIsoLine(this.getHitReactionNetworkAI().startPosition.x, this.getHitReactionNetworkAI().startPosition.y, this.z, this.getHitReactionNetworkAI().finalPosition.x, this.getHitReactionNetworkAI().finalPosition.y, this.z, Colors.Salmon.r, Colors.Salmon.g, Colors.Salmon.b, 0.8f, 1);
                    LineDrawer.DrawIsoTransform(this.getHitReactionNetworkAI().startPosition.x, this.getHitReactionNetworkAI().startPosition.y, this.z, this.getHitReactionNetworkAI().startDirection.x, this.getHitReactionNetworkAI().startDirection.y, 0.4f, 16, Colors.Salmon.r - 0.2f, Colors.Salmon.g + 0.2f, Colors.Salmon.b, 0.8f, 1);
                    LineDrawer.DrawIsoTransform(this.getHitReactionNetworkAI().finalPosition.x, this.getHitReactionNetworkAI().finalPosition.y, this.z, this.getHitReactionNetworkAI().finalDirection.x, this.getHitReactionNetworkAI().finalDirection.y, 0.4f, 16, Colors.Salmon.r, Colors.Salmon.g - 0.2f, Colors.Salmon.b, 0.8f, 1);
                }
                if (DebugOptions.instance.MultiplayerShowPlayerPrediction.getValue() && this instanceof IsoPlayer) {
                    if (this.isoPlayer != null && this.isoPlayer.networkAI != null && this.isoPlayer.networkAI.footstepSoundRadius != 0) {
                        LineDrawer.DrawIsoCircle(this.x, this.y, this.z, this.isoPlayer.networkAI.footstepSoundRadius, 32, Colors.Violet.r, Colors.Violet.g, Colors.Violet.b, 0.5f);
                    }
                    if (this.isoPlayer != null && this.isoPlayer.bRemote) {
                        LineDrawer.DrawIsoCircle(this.x, this.y, this.z, 0.3f, 16, Colors.OrangeRed.r, Colors.OrangeRed.g, Colors.OrangeRed.b, 0.5f);
                        tempo.set(this.realdir.ToVector());
                        LineDrawer.DrawIsoTransform(this.realx, this.realy, this.z, IsoGameCharacter.tempo.x, IsoGameCharacter.tempo.y, 0.35f, 16, Colors.Blue.r, Colors.Blue.g, Colors.Blue.b, 0.5f, 1);
                        LineDrawer.DrawIsoLine(this.realx, this.realy, this.z, this.x, this.y, this.z, Colors.Blue.r, Colors.Blue.g, Colors.Blue.b, 0.5f, 1);
                        tempo.set(((IsoPlayer)this).networkAI.targetX, ((IsoPlayer)this).networkAI.targetY);
                        LineDrawer.DrawIsoTransform(IsoGameCharacter.tempo.x, IsoGameCharacter.tempo.y, this.z, 1.0f, 0.0f, 0.4f, 16, Colors.LimeGreen.r, Colors.LimeGreen.g, Colors.LimeGreen.b, 0.5f, 1);
                        LineDrawer.DrawIsoLine(this.x, this.y, this.z, IsoGameCharacter.tempo.x, IsoGameCharacter.tempo.y, this.z, Colors.LimeGreen.r, Colors.LimeGreen.g, Colors.LimeGreen.b, 0.5f, 1);
                    }
                }
                if (DebugOptions.instance.MultiplayerShowTeleport.getValue() && this.getNetworkCharacterAI() != null) {
                    NetworkTeleport.NetworkTeleportDebug networkTeleportDebug = this.getNetworkCharacterAI().getTeleportDebug();
                    if (networkTeleportDebug != null) {
                        LineDrawer.DrawIsoLine(networkTeleportDebug.lx, networkTeleportDebug.ly, networkTeleportDebug.lz, networkTeleportDebug.nx, networkTeleportDebug.ny, networkTeleportDebug.nz, Colors.NavajoWhite.r, Colors.NavajoWhite.g, Colors.NavajoWhite.b, 0.7f, 3);
                        LineDrawer.DrawIsoCircle(networkTeleportDebug.nx, networkTeleportDebug.ny, networkTeleportDebug.nz, 0.2f, 16, Colors.NavajoWhite.r, Colors.NavajoWhite.g, Colors.NavajoWhite.b, 0.7f);
                        float f12 = IsoUtils.XToScreenExact(networkTeleportDebug.lx, networkTeleportDebug.ly, networkTeleportDebug.lz, 0);
                        float f13 = IsoUtils.YToScreenExact(networkTeleportDebug.lx, networkTeleportDebug.ly, networkTeleportDebug.lz, 0);
                        TextManager.instance.DrawStringCentre(UIFont.DebugConsole, f12, f13, String.format("%s id=%d", this instanceof IsoPlayer ? ((IsoPlayer)this).getUsername() : this.getClass().getSimpleName(), networkTeleportDebug.id), Colors.NavajoWhite.r, Colors.NavajoWhite.g, Colors.NavajoWhite.b, 0.7f);
                        TextManager.instance.DrawStringCentre(UIFont.DebugConsole, f12, f13 + 10.0f, networkTeleportDebug.type.name(), Colors.NavajoWhite.r, Colors.NavajoWhite.g, Colors.NavajoWhite.b, 0.7f);
                    }
                } else if (this.getNetworkCharacterAI() != null) {
                    this.getNetworkCharacterAI().clearTeleportDebug();
                }
                if (DebugOptions.instance.MultiplayerShowZombieStatus.getValue() && this instanceof IsoZombie) break block74;
                if (!DebugOptions.instance.MultiplayerShowPlayerStatus.getValue() || !(this instanceof IsoPlayer) || ((IsoPlayer)this).isGodMod()) break block73;
            }
            TextManager.StringDrawer stringDrawer = TextManager.instance::DrawString;
            if (this instanceof IsoPlayer && this.isLocal()) {
                stringDrawer = TextManager.instance::DrawStringRight;
            }
            float f = IsoUtils.XToScreenExact(this.x, this.y, this.z, 0);
            float f14 = IsoUtils.YToScreenExact(this.x, this.y, this.z, 0);
            float f15 = 10.0f;
            Serializable serializable = Colors.GreenYellow;
            stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("%d %s : %.03f / %.03f", this.getOnlineID(), this.isFemale() ? "F" : "M", Float.valueOf(this.getHealth()), Float.valueOf(this instanceof IsoZombie ? 0.0f : this.getBodyDamage().getOverallBodyHealth())), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, ((Color)serializable).a);
            stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("x=%09.3f ", Float.valueOf(this.x)) + String.format("y=%09.3f ", Float.valueOf(this.y)) + String.format("z=%d", (byte)this.z), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, ((Color)serializable).a);
            if (this instanceof IsoPlayer) {
                serializable = (IsoPlayer)this;
                Color color = Colors.NavajoWhite;
                stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 18.0f), String.format("IdleSpeed: %s , targetDist: %s ", ((IsoGameCharacter)serializable).getVariableString("IdleSpeed"), ((IsoGameCharacter)serializable).getVariableString("targetDist")), color.r, color.g, color.b, 1.0);
                stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("WalkInjury: %s , WalkSpeed: %s", ((IsoGameCharacter)serializable).getVariableString("WalkInjury"), ((IsoGameCharacter)serializable).getVariableString("WalkSpeed")), color.r, color.g, color.b, 1.0);
                stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("DeltaX: %s , DeltaY: %s", ((IsoGameCharacter)serializable).getVariableString("DeltaX"), ((IsoGameCharacter)serializable).getVariableString("DeltaY")), color.r, color.g, color.b, 1.0);
                stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("AttackVariationX: %s , AttackVariationY: %s", ((IsoGameCharacter)serializable).getVariableString("AttackVariationX"), ((IsoGameCharacter)serializable).getVariableString("AttackVariationY")), color.r, color.g, color.b, 1.0);
                stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("autoShootVarX: %s , autoShootVarY: %s", ((IsoGameCharacter)serializable).getVariableString("autoShootVarX"), ((IsoGameCharacter)serializable).getVariableString("autoShootVarY")), color.r, color.g, color.b, 1.0);
                stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("recoilVarX: %s , recoilVarY: %s", ((IsoGameCharacter)serializable).getVariableString("recoilVarX"), ((IsoGameCharacter)serializable).getVariableString("recoilVarY")), color.r, color.g, color.b, 1.0);
                stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("ShoveAimX: %s , ShoveAimY: %s", ((IsoGameCharacter)serializable).getVariableString("ShoveAimX"), ((IsoGameCharacter)serializable).getVariableString("ShoveAimY")), color.r, color.g, color.b, 1.0);
            }
            serializable = Colors.Yellow;
            stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 18.0f), String.format("isHitFromBehind=%b/%b", this.isHitFromBehind(), this.getVariableBoolean("frombehind")), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
            stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("bKnockedDown=%b/%b", this.isKnockedDown(), this.getVariableBoolean("bknockeddown")), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
            stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("isFallOnFront=%b/%b", this.isFallOnFront(), this.getVariableBoolean("fallonfront")), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
            stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("isOnFloor=%b/%b", this.isOnFloor(), this.getVariableBoolean("bonfloor")), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
            stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("isDead=%b/%b", this.isDead(), this.getVariableBoolean("bdead")), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
            if (this instanceof IsoZombie) {
                stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("bThump=%b", this.getVariableString("bThump")), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
                stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("ThumpType=%s", this.getVariableString("ThumpType")), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
                stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("onknees=%b", this.getVariableBoolean("onknees")), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
            } else {
                stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("isBumped=%b/%s", this.isBumped(), this.getBumpType()), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
            }
            serializable = Colors.OrangeRed;
            if (this.getReanimateTimer() <= 0.0f) {
                serializable = Colors.LimeGreen;
            } else if (this.isBeingSteppedOn()) {
                serializable = Colors.Blue;
            }
            stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 18.0f), "Reanimate: " + this.getReanimateTimer(), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
            if (this.advancedAnimator.getRootLayer() != null) {
                serializable = Colors.Pink;
                stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 18.0f), "Animation set: " + this.advancedAnimator.animSet.m_Name, ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
                stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), "Animation state: " + this.advancedAnimator.getCurrentStateName(), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
                stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), "Animation node: " + this.advancedAnimator.getRootLayer().getDebugNodeName(), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
            }
            serializable = Colors.LightBlue;
            stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("Previous state: %s ( %s )", this.getPreviousStateName(), this.getPreviousActionContextStateName()), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
            stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("Current state: %s ( %s )", this.getCurrentStateName(), this.getCurrentActionContextStateName()), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
            stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("Child state: %s", this.getActionContext() != null && this.getActionContext().getChildStates() != null && this.getActionContext().getChildStates().size() > 0 && this.getActionContext().getChildStateAt(0) != null ? this.getActionContext().getChildStateAt(0).getName() : "\"\""), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
            if (this.CharacterActions != null) {
                stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("Character actions: %d", this.CharacterActions.size()), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
                for (BaseAction baseAction : this.CharacterActions) {
                    if (!(baseAction instanceof LuaTimedActionNew)) continue;
                    stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("Action: %s", ((LuaTimedActionNew)baseAction).getMetaType()), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
                }
            }
            if (this instanceof IsoZombie) {
                serializable = Colors.GreenYellow;
                IsoZombie isoZombie = (IsoZombie)this;
                stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 18.0f), "Prediction: " + this.getNetworkCharacterAI().predictionType, ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
                stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), String.format("Real state: %s", new Object[]{isoZombie.realState}), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
                if (isoZombie.target instanceof IsoPlayer) {
                    stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), "Target: " + ((IsoPlayer)isoZombie.target).username + "  =" + isoZombie.vectorToTarget.getLength(), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
                } else {
                    stringDrawer.draw(UIFont.DebugConsole, f, f14 + (f15 += 11.0f), "Target: " + isoZombie.target + "  =" + isoZombie.vectorToTarget.getLength(), ((Color)serializable).r, ((Color)serializable).g, ((Color)serializable).b, 1.0);
                }
            }
        }
        if (this.inventory == null) {
            return;
        }
        for (int i = 0; i < this.inventory.Items.size(); ++i) {
            InventoryItem inventoryItem = this.inventory.Items.get(i);
            if (!(inventoryItem instanceof IUpdater)) continue;
            ((IUpdater)((Object)inventoryItem)).renderlast();
        }
        if (Core.bDebug && DebugOptions.instance.PathfindRenderPath.getValue() && this.pfb2 != null) {
            this.pfb2.render();
        }
        if (Core.bDebug && DebugOptions.instance.CollideWithObstaclesRenderRadius.getValue()) {
            float f = 0.3f;
            float f16 = 1.0f;
            float f17 = 1.0f;
            float f18 = 1.0f;
            if (!this.isCollidable()) {
                f18 = 0.0f;
            }
            if ((int)this.z != (int)IsoCamera.frameState.CamCharacterZ) {
                f18 = 0.5f;
                f17 = 0.5f;
                f16 = 0.5f;
            }
            LineDrawer.DrawIsoCircle(this.x, this.y, this.z, f, 16, f16, f17, f18, 1.0f);
        }
        if (DebugOptions.instance.Animation.Debug.getValue() && this.hasActiveModel()) {
            int n = (int)IsoUtils.XToScreenExact(this.x, this.y, this.z, 0);
            int n4 = (int)IsoUtils.YToScreenExact(this.x, this.y, this.z, 0);
            TextManager.instance.DrawString(n, n4, this.getAnimationDebug());
        }
        if (this.getIsNPC() && this.GameCharacterAIBrain != null) {
            this.GameCharacterAIBrain.renderlast();
        }
    }

    protected boolean renderTextureInsteadOfModel(float f, float f2) {
        return false;
    }

    public void drawDirectionLine(Vector2 vector22, float f, float f2, float f3, float f4) {
        float f5 = this.x + vector22.x * f;
        float f6 = this.y + vector22.y * f;
        float f7 = IsoUtils.XToScreenExact(this.x, this.y, this.z, 0);
        float f8 = IsoUtils.YToScreenExact(this.x, this.y, this.z, 0);
        float f9 = IsoUtils.XToScreenExact(f5, f6, this.z, 0);
        float f10 = IsoUtils.YToScreenExact(f5, f6, this.z, 0);
        LineDrawer.drawLine(f7, f8, f9, f10, f2, f3, f4, 0.5f, 1);
    }

    public void drawDebugTextBelow(String string) {
        int n = TextManager.instance.MeasureStringX(UIFont.Small, string) + 32;
        int n2 = TextManager.instance.getFontHeight(UIFont.Small);
        int n3 = (int)Math.ceil((double)n2 * 1.25);
        float f = IsoUtils.XToScreenExact(this.getX() + 0.25f, this.getY() + 0.25f, this.getZ(), 0);
        float f2 = IsoUtils.YToScreenExact(this.getX() + 0.25f, this.getY() + 0.25f, this.getZ(), 0);
        SpriteRenderer.instance.renderi(null, (int)(f - (float)(n / 2)), (int)(f2 - (float)((n3 - n2) / 2)), n, n3, 0.0f, 0.0f, 0.0f, 0.5f, null);
        TextManager.instance.DrawStringCentre(UIFont.Small, f, f2, string, 1.0, 1.0, 1.0, 1.0);
    }

    public Radio getEquipedRadio() {
        return this.equipedRadio;
    }

    private void radioEquipedCheck() {
        if (this.leftHandItem != this.leftHandCache) {
            this.leftHandCache = this.leftHandItem;
            if (this.leftHandItem != null && (this.equipedRadio == null || this.equipedRadio != this.rightHandItem) && this.leftHandItem instanceof Radio) {
                this.equipedRadio = (Radio)this.leftHandItem;
            } else if (this.equipedRadio != null && this.equipedRadio != this.rightHandItem) {
                if (this.equipedRadio.getDeviceData() != null) {
                    this.equipedRadio.getDeviceData().cleanSoundsAndEmitter();
                }
                this.equipedRadio = null;
            }
        }
        if (this.rightHandItem != this.rightHandCache) {
            this.rightHandCache = this.rightHandItem;
            if (this.rightHandItem != null && this.rightHandItem instanceof Radio) {
                this.equipedRadio = (Radio)this.rightHandItem;
            } else if (this.equipedRadio != null && this.equipedRadio != this.leftHandItem) {
                if (this.equipedRadio.getDeviceData() != null) {
                    this.equipedRadio.getDeviceData().cleanSoundsAndEmitter();
                }
                this.equipedRadio = null;
            }
        }
    }

    private void debugAim() {
        if (this != IsoPlayer.getInstance()) {
            return;
        }
        IsoPlayer isoPlayer = (IsoPlayer)this;
        if (!isoPlayer.IsAiming()) {
            return;
        }
        HandWeapon handWeapon = Type.tryCastTo(this.getPrimaryHandItem(), HandWeapon.class);
        if (handWeapon == null) {
            handWeapon = isoPlayer.bareHands;
        }
        float f = handWeapon.getMaxRange(isoPlayer) * handWeapon.getRangeMod(isoPlayer);
        float f2 = this.getLookAngleRadians();
        LineDrawer.drawDirectionLine(this.x, this.y, this.z, f, f2, 1.0f, 1.0f, 1.0f, 0.5f, 1);
        float f3 = handWeapon.getMinAngle();
        LineDrawer.drawDotLines(this.x, this.y, this.z, f, f2, f3 -= handWeapon.getAimingPerkMinAngleModifier() * ((float)this.getPerkLevel(PerkFactory.Perks.Aiming) / 2.0f), 1.0f, 1.0f, 1.0f, 0.5f, 1);
        float f4 = handWeapon.getMinRange();
        LineDrawer.drawArc(this.x, this.y, this.z, f4, f2, f3, 6, 1.0f, 1.0f, 1.0f, 0.5f);
        if (f4 != f) {
            LineDrawer.drawArc(this.x, this.y, this.z, f, f2, f3, 6, 1.0f, 1.0f, 1.0f, 0.5f);
        }
        float f5 = PZMath.min(f + 1.0f, 2.0f);
        LineDrawer.drawArc(this.x, this.y, this.z, f5, f2, f3, 6, 0.75f, 0.75f, 0.75f, 0.5f);
        float f6 = Core.getInstance().getIgnoreProneZombieRange();
        if (f6 > 0.0f) {
            LineDrawer.drawArc(this.x, this.y, this.z, f6, f2, 0.0f, 12, 0.0f, 0.0f, 1.0f, 0.25f);
            LineDrawer.drawDotLines(this.x, this.y, this.z, f6, f2, 0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 1);
        }
        AttackVars attackVars = new AttackVars();
        ArrayList<HitInfo> arrayList = new ArrayList<HitInfo>();
        SwipeStatePlayer.instance().CalcAttackVars((IsoLivingCharacter)this, attackVars);
        SwipeStatePlayer.instance().CalcHitList(this, false, attackVars, arrayList);
        if (attackVars.targetOnGround.getMovingObject() != null) {
            var11_11 = attackVars.targetsProne.get(0);
            LineDrawer.DrawIsoCircle(var11_11.x, var11_11.y, var11_11.z, 0.1f, 8, 1.0f, 1.0f, 0.0f, 1.0f);
        } else if (attackVars.targetsStanding.size() > 0) {
            var11_11 = attackVars.targetsStanding.get(0);
            LineDrawer.DrawIsoCircle(var11_11.x, var11_11.y, var11_11.z, 0.1f, 8, 1.0f, 1.0f, 0.0f, 1.0f);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            HitInfo hitInfo = arrayList.get(i);
            IsoMovingObject isoMovingObject = hitInfo.getObject();
            if (isoMovingObject != null) {
                int n = hitInfo.chance;
                float f7 = 1.0f - (float)n / 100.0f;
                float f8 = 1.0f - f7;
                float f9 = Math.max(0.2f, (float)n / 100.0f) / 2.0f;
                float f10 = IsoUtils.XToScreenExact(isoMovingObject.x - f9, isoMovingObject.y + f9, isoMovingObject.z, 0);
                float f11 = IsoUtils.YToScreenExact(isoMovingObject.x - f9, isoMovingObject.y + f9, isoMovingObject.z, 0);
                float f12 = IsoUtils.XToScreenExact(isoMovingObject.x - f9, isoMovingObject.y - f9, isoMovingObject.z, 0);
                float f13 = IsoUtils.YToScreenExact(isoMovingObject.x - f9, isoMovingObject.y - f9, isoMovingObject.z, 0);
                float f14 = IsoUtils.XToScreenExact(isoMovingObject.x + f9, isoMovingObject.y - f9, isoMovingObject.z, 0);
                float f15 = IsoUtils.YToScreenExact(isoMovingObject.x + f9, isoMovingObject.y - f9, isoMovingObject.z, 0);
                float f16 = IsoUtils.XToScreenExact(isoMovingObject.x + f9, isoMovingObject.y + f9, isoMovingObject.z, 0);
                float f17 = IsoUtils.YToScreenExact(isoMovingObject.x + f9, isoMovingObject.y + f9, isoMovingObject.z, 0);
                SpriteRenderer.instance.renderPoly(f10, f11, f12, f13, f14, f15, f16, f17, f7, f8, 0.0f, 0.5f);
                UIFont uIFont = UIFont.DebugConsole;
                TextManager.instance.DrawStringCentre(uIFont, f16, f17, String.valueOf(hitInfo.dot), 1.0, 1.0, 1.0, 1.0);
                TextManager.instance.DrawStringCentre(uIFont, f16, f17 + (float)TextManager.instance.getFontHeight(uIFont), hitInfo.chance + "%", 1.0, 1.0, 1.0, 1.0);
                f7 = 1.0f;
                f8 = 1.0f;
                float f18 = 1.0f;
                float f19 = PZMath.sqrt(hitInfo.distSq);
                if (f19 < handWeapon.getMinRange()) {
                    f18 = 0.0f;
                    f7 = 0.0f;
                }
                TextManager.instance.DrawStringCentre(uIFont, f16, f17 + (float)(TextManager.instance.getFontHeight(uIFont) * 2), "DIST: " + f19, f7, f8, f18, 1.0);
            }
            if (hitInfo.window.getObject() == null) continue;
            hitInfo.window.getObject().setHighlighted(true);
        }
    }

    private void debugTestDotSide() {
        if (this != IsoPlayer.getInstance()) {
            return;
        }
        float f = this.getLookAngleRadians();
        float f2 = 2.0f;
        float f3 = 0.7f;
        LineDrawer.drawDotLines(this.x, this.y, this.z, f2, f, f3, 1.0f, 1.0f, 1.0f, 0.5f, 1);
        f3 = -0.5f;
        LineDrawer.drawDotLines(this.x, this.y, this.z, f2, f, f3, 1.0f, 1.0f, 1.0f, 0.5f, 1);
        LineDrawer.drawArc(this.x, this.y, this.z, f2, f, -1.0f, 16, 1.0f, 1.0f, 1.0f, 0.5f);
        ArrayList<IsoZombie> arrayList = this.getCell().getZombieList();
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoMovingObject isoMovingObject = arrayList.get(i);
            if (!(this.DistToSquared(isoMovingObject) < f2 * f2)) continue;
            LineDrawer.DrawIsoCircle(isoMovingObject.x, isoMovingObject.y, isoMovingObject.z, 0.3f, 1.0f, 1.0f, 1.0f, 1.0f);
            float f4 = 0.2f;
            float f5 = IsoUtils.XToScreenExact(isoMovingObject.x + f4, isoMovingObject.y + f4, isoMovingObject.z, 0);
            float f6 = IsoUtils.YToScreenExact(isoMovingObject.x + f4, isoMovingObject.y + f4, isoMovingObject.z, 0);
            UIFont uIFont = UIFont.DebugConsole;
            int n = TextManager.instance.getFontHeight(uIFont);
            TextManager.instance.DrawStringCentre(uIFont, f5, f6 + (float)n, "SIDE: " + this.testDotSide(isoMovingObject), 1.0, 1.0, 1.0, 1.0);
            Vector2 vector22 = this.getLookVector(tempo2);
            Vector2 vector23 = tempo.set(isoMovingObject.x - this.x, isoMovingObject.y - this.y);
            vector23.normalize();
            float f7 = PZMath.wrap(vector23.getDirection() - vector22.getDirection(), 0.0f, (float)Math.PI * 2);
            TextManager.instance.DrawStringCentre(uIFont, f5, f6 + (float)(n * 2), "ANGLE (0-360): " + PZMath.radToDeg(f7), 1.0, 1.0, 1.0, 1.0);
            f7 = (float)Math.acos(this.getDotWithForwardDirection(isoMovingObject.x, isoMovingObject.y));
            TextManager.instance.DrawStringCentre(uIFont, f5, f6 + (float)(n * 3), "ANGLE (0-180): " + PZMath.radToDeg(f7), 1.0, 1.0, 1.0, 1.0);
        }
    }

    private void debugVision() {
        if (this != IsoPlayer.getInstance()) {
            return;
        }
        float f = LightingJNI.calculateVisionCone(this);
        LineDrawer.drawDotLines(this.x, this.y, this.z, GameTime.getInstance().getViewDist(), this.getLookAngleRadians(), -f, 1.0f, 1.0f, 1.0f, 0.5f, 1);
        LineDrawer.drawArc(this.x, this.y, this.z, GameTime.getInstance().getViewDist(), this.getLookAngleRadians(), -f, 16, 1.0f, 1.0f, 1.0f, 0.5f);
        float f2 = 3.5f - this.stats.getFatigue();
        LineDrawer.drawArc(this.x, this.y, this.z, f2, this.getLookAngleRadians(), -1.0f, 32, 1.0f, 1.0f, 1.0f, 0.5f);
    }

    public void setDefaultState() {
        this.stateMachine.changeState(this.defaultState, null);
    }

    public void SetOnFire() {
        if (this.OnFire) {
            return;
        }
        this.setOnFire(true);
        float f = Core.TileScale;
        this.AttachAnim("Fire", "01", 4, IsoFireManager.FireAnimDelay, (int)(-(this.offsetX + 1.0f * f)) + (8 - Rand.Next(16)), (int)(-(this.offsetY + -89.0f * f)) + (int)((float)(10 + Rand.Next(20)) * f), true, 0, false, 0.7f, IsoFireManager.FireTintMod);
        IsoFireManager.AddBurningCharacter(this);
        int n = Rand.Next(BodyPartType.ToIndex(BodyPartType.Hand_L), BodyPartType.ToIndex(BodyPartType.MAX));
        if (this instanceof IsoPlayer) {
            this.getBodyDamage().getBodyParts().get(n).setBurned();
        }
        if (f == 2.0f) {
            int n2 = this.AttachedAnimSprite.size() - 1;
            ((IsoSpriteInstance)this.AttachedAnimSprite.get(n2)).setScale(f, f);
        }
        if (!this.getEmitter().isPlaying("BurningFlesh")) {
            this.getEmitter().playSoundImpl("BurningFlesh", this);
        }
    }

    @Override
    public void StopBurning() {
        if (!this.OnFire) {
            return;
        }
        IsoFireManager.RemoveBurningCharacter(this);
        this.setOnFire(false);
        if (this.AttachedAnimSprite != null) {
            this.AttachedAnimSprite.clear();
        }
        this.getEmitter().stopOrTriggerSoundByName("BurningFlesh");
    }

    @Override
    public void sendStopBurning() {
        if (GameClient.bClient) {
            IsoGameCharacter isoGameCharacter;
            if (this instanceof IsoPlayer) {
                isoGameCharacter = (IsoPlayer)this;
                if (isoGameCharacter.isLocalPlayer()) {
                    this.StopBurning();
                } else {
                    GameClient.sendStopFire(isoGameCharacter);
                }
            }
            if (this.isZombie()) {
                isoGameCharacter = (IsoZombie)this;
                GameClient.sendStopFire(isoGameCharacter);
            }
        }
    }

    public void SpreadFireMP() {
        if (!(this.OnFire && GameServer.bServer && SandboxOptions.instance.FireSpread.getValue())) {
            return;
        }
        IsoGridSquare isoGridSquare = ServerMap.instance.getGridSquare((int)this.x, (int)this.y, (int)this.z);
        if (isoGridSquare != null && !isoGridSquare.getProperties().Is(IsoFlagType.burning) && Rand.Next(Rand.AdjustForFramerate(3000)) < this.FireSpreadProbability) {
            IsoFireManager.StartFire(this.getCell(), isoGridSquare, false, 80);
        }
    }

    public void SpreadFire() {
        if (!this.OnFire || GameServer.bServer || GameClient.bClient || !SandboxOptions.instance.FireSpread.getValue()) {
            return;
        }
        if (this.square != null && !this.square.getProperties().Is(IsoFlagType.burning) && Rand.Next(Rand.AdjustForFramerate(3000)) < this.FireSpreadProbability) {
            IsoFireManager.StartFire(this.getCell(), this.square, false, 80);
        }
    }

    public void Throw(HandWeapon handWeapon) {
        float f;
        float f2;
        if (this instanceof IsoPlayer && ((IsoPlayer)this).getJoypadBind() != -1) {
            Vector2 vector22 = tempo.set(this.m_forwardDirection);
            vector22.setLength(handWeapon.getMaxRange());
            this.attackTargetSquare = this.getCell().getGridSquare(this.getX() + vector22.getX(), this.getY() + vector22.getY(), this.getZ());
            if (this.attackTargetSquare == null) {
                this.attackTargetSquare = this.getCell().getGridSquare(this.getX() + vector22.getX(), this.getY() + vector22.getY(), 0.0);
            }
        }
        if ((f2 = (float)this.attackTargetSquare.getX() - this.getX()) > 0.0f) {
            if ((float)this.attackTargetSquare.getX() - this.getX() > handWeapon.getMaxRange()) {
                f2 = handWeapon.getMaxRange();
            }
        } else if ((float)this.attackTargetSquare.getX() - this.getX() < -handWeapon.getMaxRange()) {
            f2 = -handWeapon.getMaxRange();
        }
        if ((f = (float)this.attackTargetSquare.getY() - this.getY()) > 0.0f) {
            if ((float)this.attackTargetSquare.getY() - this.getY() > handWeapon.getMaxRange()) {
                f = handWeapon.getMaxRange();
            }
        } else if ((float)this.attackTargetSquare.getY() - this.getY() < -handWeapon.getMaxRange()) {
            f = -handWeapon.getMaxRange();
        }
        if (handWeapon.getPhysicsObject().equals("Ball")) {
            IsoBall isoBall = new IsoBall(this.getCell(), this.getX(), this.getY(), this.getZ() + 0.6f, f2 * 0.4f, f * 0.4f, handWeapon, this);
        } else {
            IsoMolotovCocktail isoMolotovCocktail = new IsoMolotovCocktail(this.getCell(), this.getX(), this.getY(), this.getZ() + 0.6f, f2 * 0.4f, f * 0.4f, handWeapon, this);
        }
        if (this instanceof IsoPlayer) {
            ((IsoPlayer)this).setAttackAnimThrowTimer(0L);
        }
    }

    public void serverRemoveItemFromZombie(String string) {
        if (!GameServer.bServer) {
            return;
        }
        IsoZombie isoZombie = Type.tryCastTo(this, IsoZombie.class);
        this.getItemVisuals(tempItemVisuals);
        for (int i = 0; i < tempItemVisuals.size(); ++i) {
            ItemVisual itemVisual = (ItemVisual)tempItemVisuals.get(i);
            Item item = itemVisual.getScriptItem();
            if (item == null || !item.name.equals(string)) continue;
            tempItemVisuals.remove(i--);
            isoZombie.itemVisuals.clear();
            isoZombie.itemVisuals.addAll(tempItemVisuals);
        }
    }

    public boolean helmetFall(boolean bl) {
        return this.helmetFall(bl, null);
    }

    public boolean helmetFall(boolean bl, String string) {
        IsoPlayer isoPlayer = Type.tryCastTo(this, IsoPlayer.class);
        boolean bl2 = false;
        InventoryItem inventoryItem = null;
        IsoZombie isoZombie = Type.tryCastTo(this, IsoZombie.class);
        if (isoZombie != null && !isoZombie.isUsingWornItems()) {
            this.getItemVisuals(tempItemVisuals);
            for (int i = 0; i < tempItemVisuals.size(); ++i) {
                InventoryItem inventoryItem2;
                ItemVisual itemVisual = (ItemVisual)tempItemVisuals.get(i);
                Item item = itemVisual.getScriptItem();
                if (item == null || item.getType() != Item.Type.Clothing || item.getChanceToFall() <= 0) continue;
                int n = item.getChanceToFall();
                if (bl) {
                    n += 40;
                }
                if (item.name.equals(string)) {
                    n = 100;
                }
                if (Rand.Next(100) <= n || (inventoryItem2 = InventoryItemFactory.CreateItem(item.getFullName())) == null) continue;
                if (inventoryItem2.getVisual() != null) {
                    inventoryItem2.getVisual().copyFrom(itemVisual);
                    inventoryItem2.synchWithVisual();
                }
                IsoFallingClothing isoFallingClothing = new IsoFallingClothing(this.getCell(), this.getX(), this.getY(), PZMath.min(this.getZ() + 0.4f, (float)((int)this.getZ()) + 0.95f), 0.2f, 0.2f, inventoryItem2);
                if (!StringUtils.isNullOrEmpty(string)) {
                    isoFallingClothing.addWorldItem = false;
                }
                tempItemVisuals.remove(i--);
                isoZombie.itemVisuals.clear();
                isoZombie.itemVisuals.addAll(tempItemVisuals);
                this.resetModelNextFrame();
                this.onWornItemsChanged();
                bl2 = true;
                inventoryItem = inventoryItem2;
            }
        } else if (this.getWornItems() != null && !this.getWornItems().isEmpty()) {
            for (int i = 0; i < this.getWornItems().size(); ++i) {
                WornItem wornItem = this.getWornItems().get(i);
                InventoryItem inventoryItem3 = wornItem.getItem();
                String string2 = wornItem.getLocation();
                if (!(inventoryItem3 instanceof Clothing)) continue;
                int n = ((Clothing)inventoryItem3).getChanceToFall();
                if (bl) {
                    n += 40;
                }
                if (inventoryItem3.getType().equals(string)) {
                    n = 100;
                }
                if (((Clothing)inventoryItem3).getChanceToFall() <= 0 || Rand.Next(100) > n) continue;
                IsoFallingClothing isoFallingClothing = new IsoFallingClothing(this.getCell(), this.getX(), this.getY(), PZMath.min(this.getZ() + 0.4f, (float)((int)this.getZ()) + 0.95f), Rand.Next(-0.2f, 0.2f), Rand.Next(-0.2f, 0.2f), inventoryItem3);
                if (!StringUtils.isNullOrEmpty(string)) {
                    isoFallingClothing.addWorldItem = false;
                }
                this.getInventory().Remove(inventoryItem3);
                this.getWornItems().remove(inventoryItem3);
                inventoryItem = inventoryItem3;
                this.resetModelNextFrame();
                this.onWornItemsChanged();
                bl2 = true;
                if (!GameClient.bClient || isoPlayer == null || !isoPlayer.isLocalPlayer() || !StringUtils.isNullOrEmpty(string)) continue;
                GameClient.instance.sendClothing(isoPlayer, string2, null);
            }
        }
        if (bl2 && GameClient.bClient && StringUtils.isNullOrEmpty(string) && IsoPlayer.getInstance().isLocalPlayer()) {
            GameClient.sendZombieHelmetFall(IsoPlayer.getInstance(), this, inventoryItem);
        }
        if (bl2 && isoPlayer != null && isoPlayer.isLocalPlayer()) {
            LuaEventManager.triggerEvent("OnClothingUpdated", this);
        }
        if (bl2 && this.isZombie()) {
            PersistentOutfits.instance.setFallenHat(this, true);
        }
        return bl2;
    }

    @Override
    public void smashCarWindow(VehiclePart vehiclePart) {
        HashMap<Object, Object> hashMap = this.getStateMachineParams(SmashWindowState.instance());
        hashMap.clear();
        hashMap.put(0, vehiclePart.getWindow());
        hashMap.put(1, vehiclePart.getVehicle());
        hashMap.put(2, vehiclePart);
        this.actionContext.reportEvent("EventSmashWindow");
    }

    @Override
    public void smashWindow(IsoWindow isoWindow) {
        if (!isoWindow.isInvincible()) {
            HashMap<Object, Object> hashMap = this.getStateMachineParams(SmashWindowState.instance());
            hashMap.clear();
            hashMap.put(0, isoWindow);
            this.actionContext.reportEvent("EventSmashWindow");
        }
    }

    @Override
    public void openWindow(IsoWindow isoWindow) {
        if (!isoWindow.isInvincible()) {
            OpenWindowState.instance().setParams(this, isoWindow);
            this.actionContext.reportEvent("EventOpenWindow");
        }
    }

    @Override
    public void closeWindow(IsoWindow isoWindow) {
        if (!isoWindow.isInvincible()) {
            HashMap<Object, Object> hashMap = this.getStateMachineParams(CloseWindowState.instance());
            hashMap.clear();
            hashMap.put(0, isoWindow);
            this.actionContext.reportEvent("EventCloseWindow");
        }
    }

    @Override
    public void climbThroughWindow(IsoWindow isoWindow) {
        if (isoWindow.canClimbThrough(this)) {
            float f = this.x - (float)((int)this.x);
            float f2 = this.y - (float)((int)this.y);
            int n = 0;
            int n2 = 0;
            if (isoWindow.getX() > this.x && !isoWindow.north) {
                n = -1;
            }
            if (isoWindow.getY() > this.y && isoWindow.north) {
                n2 = -1;
            }
            this.x = isoWindow.getX() + f + (float)n;
            this.y = isoWindow.getY() + f2 + (float)n2;
            ClimbThroughWindowState.instance().setParams(this, isoWindow);
            this.actionContext.reportEvent("EventClimbWindow");
        }
    }

    @Override
    public void climbThroughWindow(IsoWindow isoWindow, Integer n) {
        if (isoWindow.canClimbThrough(this)) {
            ClimbThroughWindowState.instance().setParams(this, isoWindow);
            this.actionContext.reportEvent("EventClimbWindow");
        }
    }

    public boolean isClosingWindow(IsoWindow isoWindow) {
        if (isoWindow == null) {
            return false;
        }
        if (!this.isCurrentState(CloseWindowState.instance())) {
            return false;
        }
        return CloseWindowState.instance().getWindow(this) == isoWindow;
    }

    public boolean isClimbingThroughWindow(IsoWindow isoWindow) {
        if (isoWindow == null) {
            return false;
        }
        if (!this.isCurrentState(ClimbThroughWindowState.instance())) {
            return false;
        }
        if (!this.getVariableBoolean("BlockWindow")) {
            return false;
        }
        return ClimbThroughWindowState.instance().getWindow(this) == isoWindow;
    }

    @Override
    public void climbThroughWindowFrame(IsoObject isoObject) {
        if (IsoWindowFrame.canClimbThrough(isoObject, this)) {
            ClimbThroughWindowState.instance().setParams(this, isoObject);
            this.actionContext.reportEvent("EventClimbWindow");
        }
    }

    @Override
    public void climbSheetRope() {
        if (!this.canClimbSheetRope(this.current)) {
            return;
        }
        HashMap<Object, Object> hashMap = this.getStateMachineParams(ClimbSheetRopeState.instance());
        hashMap.clear();
        this.actionContext.reportEvent("EventClimbRope");
    }

    @Override
    public void climbDownSheetRope() {
        if (!this.canClimbDownSheetRope(this.current)) {
            return;
        }
        this.dropHeavyItems();
        HashMap<Object, Object> hashMap = this.getStateMachineParams(ClimbDownSheetRopeState.instance());
        hashMap.clear();
        this.actionContext.reportEvent("EventClimbDownRope");
    }

    @Override
    public boolean canClimbSheetRope(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return false;
        }
        int n = isoGridSquare.getZ();
        while (isoGridSquare != null) {
            if (!IsoWindow.isSheetRopeHere(isoGridSquare)) {
                return false;
            }
            if (!IsoWindow.canClimbHere(isoGridSquare)) {
                return false;
            }
            if (isoGridSquare.TreatAsSolidFloor() && isoGridSquare.getZ() > n) {
                return false;
            }
            if (IsoWindow.isTopOfSheetRopeHere(isoGridSquare)) {
                return true;
            }
            isoGridSquare = this.getCell().getGridSquare(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ() + 1);
        }
        return false;
    }

    @Override
    public boolean canClimbDownSheetRopeInCurrentSquare() {
        return this.canClimbDownSheetRope(this.current);
    }

    @Override
    public boolean canClimbDownSheetRope(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return false;
        }
        int n = isoGridSquare.getZ();
        while (isoGridSquare != null) {
            if (!IsoWindow.isSheetRopeHere(isoGridSquare)) {
                return false;
            }
            if (!IsoWindow.canClimbHere(isoGridSquare)) {
                return false;
            }
            if (isoGridSquare.TreatAsSolidFloor()) {
                return isoGridSquare.getZ() < n;
            }
            isoGridSquare = this.getCell().getGridSquare(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ() - 1);
        }
        return false;
    }

    @Override
    public void climbThroughWindow(IsoThumpable isoThumpable) {
        if (isoThumpable.canClimbThrough(this)) {
            float f = this.x - (float)((int)this.x);
            float f2 = this.y - (float)((int)this.y);
            int n = 0;
            int n2 = 0;
            if (isoThumpable.getX() > this.x && !isoThumpable.north) {
                n = -1;
            }
            if (isoThumpable.getY() > this.y && isoThumpable.north) {
                n2 = -1;
            }
            this.x = isoThumpable.getX() + f + (float)n;
            this.y = isoThumpable.getY() + f2 + (float)n2;
            ClimbThroughWindowState.instance().setParams(this, isoThumpable);
            this.actionContext.reportEvent("EventClimbWindow");
        }
    }

    @Override
    public void climbThroughWindow(IsoThumpable isoThumpable, Integer n) {
        if (isoThumpable.canClimbThrough(this)) {
            ClimbThroughWindowState.instance().setParams(this, isoThumpable);
            this.actionContext.reportEvent("EventClimbWindow");
        }
    }

    @Override
    public void climbOverFence(IsoDirections isoDirections) {
        if (this.current == null) {
            return;
        }
        IsoGridSquare isoGridSquare = this.current.nav[isoDirections.index()];
        if (!IsoWindow.canClimbThroughHelper(this, this.current, isoGridSquare, isoDirections == IsoDirections.N || isoDirections == IsoDirections.S)) {
            return;
        }
        ClimbOverFenceState.instance().setParams(this, isoDirections);
        this.actionContext.reportEvent("EventClimbFence");
    }

    @Override
    public boolean isAboveTopOfStairs() {
        if (this.z == 0.0f || (double)(this.z - (float)((int)this.z)) > 0.01 || this.current != null && this.current.TreatAsSolidFloor()) {
            return false;
        }
        IsoGridSquare isoGridSquare = this.getCell().getGridSquare(this.x, this.y, this.z - 1.0f);
        return isoGridSquare != null && (isoGridSquare.Has(IsoObjectType.stairsTN) || isoGridSquare.Has(IsoObjectType.stairsTW));
    }

    @Override
    public void preupdate() {
        super.preupdate();
        if (!this.m_bDebugVariablesRegistered && DebugOptions.instance.Character.Debug.RegisterDebugVariables.getValue()) {
            this.registerDebugGameVariables();
        }
        this.updateAnimationRecorderState();
        if (this.isAnimationRecorderActive()) {
            int n = IsoWorld.instance.getFrameNo();
            this.m_animationRecorder.beginLine(n);
        }
        if (GameServer.bServer) {
            this.getXp().update();
        }
    }

    public void setTeleport(NetworkTeleport networkTeleport) {
        this.teleport = networkTeleport;
    }

    public NetworkTeleport getTeleport() {
        return this.teleport;
    }

    public boolean isTeleporting() {
        return this.teleport != null;
    }

    @Override
    public void update() {
        s_performance.update.invokeAndMeasure(this, IsoGameCharacter::updateInternal);
    }

    private void updateInternal() {
        Object object;
        int n;
        if (this.current == null) {
            return;
        }
        if (this.teleport != null) {
            this.teleport.process(IsoPlayer.getPlayerIndex());
        }
        this.updateAlpha();
        if (this.isNPC) {
            if (this.GameCharacterAIBrain == null) {
                this.GameCharacterAIBrain = new GameCharacterAIBrain(this);
            }
            this.GameCharacterAIBrain.update();
        }
        if (this.sprite != null) {
            this.legsSprite = this.sprite;
        }
        if (this.isDead() && (this.current == null || !this.current.getMovingObjects().contains(this))) {
            return;
        }
        if (!GameClient.bClient && !this.m_invisible && this.getCurrentSquare().getTrapPositionX() > -1 && this.getCurrentSquare().getTrapPositionY() > -1 && this.getCurrentSquare().getTrapPositionZ() > -1) {
            this.getCurrentSquare().explodeTrap();
        }
        if (this.getBodyDamage() != null && this.getCurrentBuilding() != null && this.getCurrentBuilding().isToxic()) {
            float f = GameTime.getInstance().getMultiplier() / 1.6f;
            if (this.getStats().getFatigue() < 1.0f) {
                this.getStats().setFatigue(this.getStats().getFatigue() + 1.0E-4f * f);
            }
            if ((double)this.getStats().getFatigue() > 0.8) {
                this.getBodyDamage().getBodyPart(BodyPartType.Head).ReduceHealth(0.1f * f);
            }
            this.getBodyDamage().getBodyPart(BodyPartType.Torso_Upper).ReduceHealth(0.1f * f);
        }
        if (this.lungeFallTimer > 0.0f) {
            this.lungeFallTimer -= GameTime.getInstance().getMultiplier() / 1.6f;
        }
        if (this.getMeleeDelay() > 0.0f) {
            this.setMeleeDelay(this.getMeleeDelay() - 0.625f * GameTime.getInstance().getMultiplier());
        }
        if (this.getRecoilDelay() > 0.0f) {
            this.setRecoilDelay(this.getRecoilDelay() - 0.625f * GameTime.getInstance().getMultiplier());
        }
        this.sx = 0.0f;
        this.sy = 0.0f;
        if (this.current.getRoom() != null && this.current.getRoom().building.def.bAlarmed && (!this.isZombie() || Core.bTutorial) && !GameClient.bClient) {
            boolean bl = false;
            if (this instanceof IsoPlayer && (((IsoPlayer)this).isInvisible() || ((IsoPlayer)this).isGhostMode())) {
                bl = true;
            }
            if (!bl) {
                AmbientStreamManager.instance.doAlarm(this.current.getRoom().def);
            }
        }
        this.updateSeenVisibility();
        this.llx = this.getLx();
        this.lly = this.getLy();
        this.setLx(this.getX());
        this.setLy(this.getY());
        this.setLz(this.getZ());
        this.updateBeardAndHair();
        this.updateFalling();
        if (this.descriptor != null) {
            this.descriptor.Instance = this;
        }
        if (!this.isZombie()) {
            int n2;
            if (this.Traits.Agoraphobic.isSet() && !this.getCurrentSquare().isInARoom()) {
                this.stats.Panic += 0.5f * (GameTime.getInstance().getMultiplier() / 1.6f);
            }
            if (this.Traits.Claustophobic.isSet() && this.getCurrentSquare().isInARoom() && (n2 = this.getCurrentSquare().getRoomSize()) > 0) {
                float f;
                float f2 = 1.0f;
                f2 = 1.0f - (float)n2 / 70.0f;
                if (f2 < 0.0f) {
                    f2 = 0.0f;
                }
                if ((f = 0.6f * f2 * (GameTime.getInstance().getMultiplier() / 1.6f)) > 0.6f) {
                    f = 0.6f;
                }
                this.stats.Panic += f;
            }
            if (this.Moodles != null) {
                this.Moodles.Update();
            }
            if (this.Asleep) {
                this.BetaEffect = 0.0f;
                this.SleepingTabletEffect = 0.0f;
                this.StopAllActionQueue();
            }
            if (this.BetaEffect > 0.0f) {
                this.BetaEffect -= GameTime.getInstance().getMultiplier() / 1.6f;
                this.stats.Panic -= 0.6f * (GameTime.getInstance().getMultiplier() / 1.6f);
                if (this.stats.Panic < 0.0f) {
                    this.stats.Panic = 0.0f;
                }
            } else {
                this.BetaDelta = 0.0f;
            }
            if (this.DepressFirstTakeTime > 0.0f || this.DepressEffect > 0.0f) {
                this.DepressFirstTakeTime -= GameTime.getInstance().getMultiplier() / 1.6f;
                if (this.DepressFirstTakeTime < 0.0f) {
                    this.DepressFirstTakeTime = -1.0f;
                    this.DepressEffect -= GameTime.getInstance().getMultiplier() / 1.6f;
                    this.getBodyDamage().setUnhappynessLevel(this.getBodyDamage().getUnhappynessLevel() - 0.03f * (GameTime.getInstance().getMultiplier() / 1.6f));
                    if (this.getBodyDamage().getUnhappynessLevel() < 0.0f) {
                        this.getBodyDamage().setUnhappynessLevel(0.0f);
                    }
                }
            }
            if (this.DepressEffect < 0.0f) {
                this.DepressEffect = 0.0f;
            }
            if (this.SleepingTabletEffect > 0.0f) {
                this.SleepingTabletEffect -= GameTime.getInstance().getMultiplier() / 1.6f;
                this.stats.fatigue += 0.0016666667f * this.SleepingTabletDelta * (GameTime.getInstance().getMultiplier() / 1.6f);
            } else {
                this.SleepingTabletDelta = 0.0f;
            }
            int n3 = this.Moodles.getMoodleLevel(MoodleType.Panic);
            if (n3 == 2) {
                this.stats.Sanity -= 3.2E-7f;
            } else if (n3 == 3) {
                this.stats.Sanity -= 4.8000004E-7f;
            } else if (n3 == 4) {
                this.stats.Sanity -= 8.0E-7f;
            } else if (n3 == 0) {
                this.stats.Sanity += 1.0E-7f;
            }
            n = this.Moodles.getMoodleLevel(MoodleType.Tired);
            if (n == 4) {
                this.stats.Sanity -= 2.0E-6f;
            }
            if (this.stats.Sanity < 0.0f) {
                this.stats.Sanity = 0.0f;
            }
            if (this.stats.Sanity > 1.0f) {
                this.stats.Sanity = 1.0f;
            }
        }
        if (!this.CharacterActions.isEmpty()) {
            BaseAction baseAction = (BaseAction)this.CharacterActions.get(0);
            n = baseAction.valid();
            if (n != 0 && !baseAction.bStarted) {
                baseAction.waitToStart();
            } else if (!(n == 0 || baseAction.finished() || baseAction.forceComplete || baseAction.forceStop)) {
                baseAction.update();
            }
            if (n == 0 || baseAction.finished() || baseAction.forceComplete || baseAction.forceStop) {
                if (baseAction.finished() || baseAction.forceComplete) {
                    baseAction.perform();
                    n = 1;
                }
                if (baseAction.finished() && !baseAction.loopAction || baseAction.forceComplete || baseAction.forceStop || n == 0) {
                    if (baseAction.bStarted && (baseAction.forceStop || n == 0)) {
                        baseAction.stop();
                    }
                    this.CharacterActions.removeElement(baseAction);
                    if (this == IsoPlayer.players[0] || this == IsoPlayer.players[1] || this == IsoPlayer.players[2] || this == IsoPlayer.players[3]) {
                        UIManager.getProgressBar(((IsoPlayer)this).getPlayerNum()).setValue(0.0f);
                    }
                }
            }
            for (int i = 0; i < this.EnemyList.size(); ++i) {
                object = (IsoGameCharacter)this.EnemyList.get(i);
                if (!((IsoGameCharacter)object).isDead()) continue;
                this.EnemyList.remove(object);
                --i;
            }
        }
        if (SystemDisabler.doCharacterStats && this.BodyDamage != null) {
            this.BodyDamage.Update();
            this.updateBandages();
        }
        if (this == IsoPlayer.getInstance()) {
            if (this.leftHandItem != null && this.leftHandItem.getUses() <= 0) {
                this.leftHandItem = null;
            }
            if (this.rightHandItem != null && this.rightHandItem.getUses() <= 0) {
                this.rightHandItem = null;
            }
        }
        if (SystemDisabler.doCharacterStats) {
            this.calculateStats();
        }
        this.moveForwardVec.x = 0.0f;
        this.moveForwardVec.y = 0.0f;
        if (!this.Asleep || !(this instanceof IsoPlayer)) {
            this.setLx(this.getX());
            this.setLy(this.getY());
            this.setLz(this.getZ());
            this.square = this.getCurrentSquare();
            if (this.sprite != null) {
                if (!this.bUseParts) {
                    this.sprite.update(this.def);
                } else {
                    this.legsSprite.update(this.def);
                }
            }
            this.setStateEventDelayTimer(this.getStateEventDelayTimer() - GameTime.getInstance().getMultiplier() / 1.6f);
        }
        this.stateMachine.update();
        if (this.isZombie() && VirtualZombieManager.instance.isReused((IsoZombie)this)) {
            DebugLog.log(DebugType.Zombie, "Zombie added to ReusableZombies after stateMachine.update - RETURNING " + this);
            return;
        }
        if (this instanceof IsoPlayer) {
            this.ensureOnTile();
        }
        if ((this instanceof IsoPlayer || this instanceof IsoSurvivor) && this.RemoteID == -1 && this instanceof IsoPlayer && ((IsoPlayer)this).isLocalPlayer()) {
            RainManager.SetPlayerLocation(((IsoPlayer)this).getPlayerNum(), this.getCurrentSquare());
        }
        this.FireCheck();
        this.SpreadFire();
        this.ReduceHealthWhenBurning();
        this.updateTextObjects();
        if (this.stateMachine.getCurrent() == StaggerBackState.instance()) {
            if (this.getStateEventDelayTimer() > 20.0f) {
                this.BloodImpactX = this.getX();
                this.BloodImpactY = this.getY();
                this.BloodImpactZ = this.getZ();
            }
        } else {
            this.BloodImpactX = this.getX();
            this.BloodImpactY = this.getY();
            this.BloodImpactZ = this.getZ();
        }
        if (!this.isZombie()) {
            this.recursiveItemUpdater(this.inventory);
        }
        this.LastZombieKills = this.ZombieKills;
        if (this.AttachedAnimSprite != null) {
            int n4 = this.AttachedAnimSprite.size();
            for (n = 0; n < n4; ++n) {
                IsoSpriteInstance isoSpriteInstance = (IsoSpriteInstance)this.AttachedAnimSprite.get(n);
                object = isoSpriteInstance.parentSprite;
                isoSpriteInstance.update();
                isoSpriteInstance.Frame += isoSpriteInstance.AnimFrameIncrease * (GameTime.instance.getMultipliedSecondsSinceLastUpdate() * 60.0f);
                if ((int)isoSpriteInstance.Frame < ((IsoSprite)object).CurrentAnim.Frames.size() || !((IsoSprite)object).Loop || !isoSpriteInstance.Looped) continue;
                isoSpriteInstance.Frame = 0.0f;
            }
        }
        if (this.isGodMod()) {
            this.getStats().setFatigue(0.0f);
            this.getStats().setEndurance(1.0f);
            this.getBodyDamage().setTemperature(37.0f);
            this.getStats().setHunger(0.0f);
        }
        this.updateMovementMomentum();
        if (this.effectiveEdibleBuffTimer > 0.0f) {
            this.effectiveEdibleBuffTimer -= GameTime.getInstance().getMultiplier() * 0.015f;
            if (this.effectiveEdibleBuffTimer < 0.0f) {
                this.effectiveEdibleBuffTimer = 0.0f;
            }
        }
        if (!GameServer.bServer || GameClient.bClient) {
            this.updateDirt();
        }
    }

    private void updateSeenVisibility() {
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            this.updateSeenVisibility(i);
        }
    }

    private void updateSeenVisibility(int n) {
        IsoPlayer isoPlayer = IsoPlayer.players[n];
        if (isoPlayer == null) {
            return;
        }
        this.IsVisibleToPlayer[n] = this.TestIfSeen(n);
        if (this.IsVisibleToPlayer[n]) {
            return;
        }
        if (this instanceof IsoPlayer) {
            return;
        }
        if (isoPlayer.isSeeEveryone()) {
            return;
        }
        this.setTargetAlpha(n, 0.0f);
    }

    private void recursiveItemUpdater(ItemContainer itemContainer) {
        for (int i = 0; i < itemContainer.Items.size(); ++i) {
            InventoryItem inventoryItem = itemContainer.Items.get(i);
            if (inventoryItem instanceof InventoryContainer) {
                this.recursiveItemUpdater((InventoryContainer)inventoryItem);
            }
            if (!(inventoryItem instanceof IUpdater)) continue;
            inventoryItem.update();
        }
    }

    private void recursiveItemUpdater(InventoryContainer inventoryContainer) {
        for (int i = 0; i < inventoryContainer.getInventory().getItems().size(); ++i) {
            InventoryItem inventoryItem = inventoryContainer.getInventory().getItems().get(i);
            if (inventoryItem instanceof InventoryContainer) {
                this.recursiveItemUpdater((InventoryContainer)inventoryItem);
            }
            if (!(inventoryItem instanceof IUpdater)) continue;
            inventoryItem.update();
        }
    }

    private void updateDirt() {
        IsoPlayer isoPlayer;
        float f;
        if (this.isZombie() || this.getBodyDamage() == null) {
            return;
        }
        int n = 0;
        if (this.isRunning() && Rand.NextBool(Rand.AdjustForFramerate(3500))) {
            n = 1;
        }
        if (this.isSprinting() && Rand.NextBool(Rand.AdjustForFramerate(2500))) {
            n += Rand.Next(1, 3);
        }
        if (this.getBodyDamage().getTemperature() > 37.0f && Rand.NextBool(Rand.AdjustForFramerate(5000))) {
            ++n;
        }
        if (this.getBodyDamage().getTemperature() > 38.0f && Rand.NextBool(Rand.AdjustForFramerate(3000))) {
            ++n;
        }
        float f2 = f = this.square == null ? 0.0f : this.square.getPuddlesInGround();
        if (this.isMoving() && f > 0.09f && Rand.NextBool(Rand.AdjustForFramerate(1500))) {
            ++n;
        }
        if (n > 0) {
            this.addDirt(null, n, true);
        }
        if ((isoPlayer = Type.tryCastTo(this, IsoPlayer.class)) != null && isoPlayer.isPlayerMoving() || isoPlayer == null && this.isMoving()) {
            n = 0;
            if (f > 0.09f && Rand.NextBool(Rand.AdjustForFramerate(1500))) {
                ++n;
            }
            if (this.isInTrees() && Rand.NextBool(Rand.AdjustForFramerate(1500))) {
                ++n;
            }
            if (n > 0) {
                this.addDirt(null, n, false);
            }
        }
    }

    protected void updateMovementMomentum() {
        float f = GameTime.instance.getTimeDelta();
        if (this.isPlayerMoving() && !this.isAiming()) {
            float f2 = this.m_momentumScalar * 0.55f;
            if (f2 >= 0.55f) {
                this.m_momentumScalar = 1.0f;
                return;
            }
            float f3 = f2 + f;
            float f4 = f3 / 0.55f;
            this.m_momentumScalar = PZMath.clamp(f4, 0.0f, 1.0f);
        } else {
            float f5 = (1.0f - this.m_momentumScalar) * 0.25f;
            if (f5 >= 0.25f) {
                this.m_momentumScalar = 0.0f;
                return;
            }
            float f6 = f5 + f;
            float f7 = f6 / 0.25f;
            float f8 = PZMath.clamp(f7, 0.0f, 1.0f);
            this.m_momentumScalar = 1.0f - f8;
        }
    }

    @Override
    public double getHoursSurvived() {
        return GameTime.instance.getWorldAgeHours();
    }

    private void updateBeardAndHair() {
        int n;
        ArrayList<Object> arrayList;
        int n2;
        Object object;
        if (this.isZombie()) {
            return;
        }
        if (this instanceof IsoPlayer && !((IsoPlayer)this).isLocalPlayer()) {
            return;
        }
        float f = (float)this.getHoursSurvived();
        if (this.beardGrowTiming < 0.0f || this.beardGrowTiming > f) {
            this.beardGrowTiming = f;
        }
        if (this.hairGrowTiming < 0.0f || this.hairGrowTiming > f) {
            this.hairGrowTiming = f;
        }
        boolean bl = !GameClient.bClient && !GameServer.bServer || ServerOptions.instance.SleepAllowed.getValue() && ServerOptions.instance.SleepNeeded.getValue();
        boolean bl2 = false;
        if ((this.isAsleep() || !bl) && f - this.beardGrowTiming > 120.0f) {
            this.beardGrowTiming = f;
            object = BeardStyles.instance.FindStyle(((HumanVisual)this.getVisual()).getBeardModel());
            n2 = 1;
            if (object != null) {
                n2 = ((BeardStyle)object).level;
            }
            arrayList = BeardStyles.instance.getAllStyles();
            for (n = 0; n < arrayList.size(); ++n) {
                if (!arrayList.get((int)n).growReference || ((BeardStyle)arrayList.get((int)n)).level != n2 + 1) continue;
                ((HumanVisual)this.getVisual()).setBeardModel(((BeardStyle)arrayList.get((int)n)).name);
                bl2 = true;
                break;
            }
        }
        if ((this.isAsleep() || !bl) && f - this.hairGrowTiming > 480.0f) {
            this.hairGrowTiming = f;
            object = HairStyles.instance.FindMaleStyle(((HumanVisual)this.getVisual()).getHairModel());
            if (this.isFemale()) {
                object = HairStyles.instance.FindFemaleStyle(((HumanVisual)this.getVisual()).getHairModel());
            }
            n2 = 1;
            if (object != null) {
                n2 = ((HairStyle)object).level;
            }
            arrayList = HairStyles.instance.m_MaleStyles;
            if (this.isFemale()) {
                arrayList = HairStyles.instance.m_FemaleStyles;
            }
            for (n = 0; n < arrayList.size(); ++n) {
                HairStyle hairStyle = (HairStyle)arrayList.get(n);
                if (!hairStyle.growReference || hairStyle.level != n2 + 1) continue;
                ((HumanVisual)this.getVisual()).setHairModel(hairStyle.name);
                ((HumanVisual)this.getVisual()).setNonAttachedHair(null);
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            this.resetModelNextFrame();
            LuaEventManager.triggerEvent("OnClothingUpdated", this);
            if (GameClient.bClient) {
                GameClient.instance.sendVisual((IsoPlayer)this);
            }
        }
    }

    private void updateFalling() {
        if (this instanceof IsoPlayer && !this.isClimbing()) {
            IsoRoofFixer.FixRoofsAt(this.current);
        }
        if (this.isSeatedInVehicle()) {
            this.fallTime = 0.0f;
            this.lastFallSpeed = 0.0f;
            this.bFalling = false;
            this.wasOnStairs = false;
            return;
        }
        if (this.z > 0.0f) {
            IsoDirections isoDirections = IsoDirections.Max;
            if (!this.isZombie() && this.isClimbing()) {
                if (this.current.Is(IsoFlagType.climbSheetW) || this.current.Is(IsoFlagType.climbSheetTopW)) {
                    isoDirections = IsoDirections.W;
                }
                if (this.current.Is(IsoFlagType.climbSheetE) || this.current.Is(IsoFlagType.climbSheetTopE)) {
                    isoDirections = IsoDirections.E;
                }
                if (this.current.Is(IsoFlagType.climbSheetN) || this.current.Is(IsoFlagType.climbSheetTopN)) {
                    isoDirections = IsoDirections.N;
                }
                if (this.current.Is(IsoFlagType.climbSheetS) || this.current.Is(IsoFlagType.climbSheetTopS)) {
                    isoDirections = IsoDirections.S;
                }
            }
            float f = 0.125f * (GameTime.getInstance().getMultiplier() / 1.6f);
            if (this.bClimbing) {
                f = 0.0f;
            }
            if (this.getCurrentState() == ClimbOverFenceState.instance() || this.getCurrentState() == ClimbThroughWindowState.instance()) {
                this.fallTime = 0.0f;
                f = 0.0f;
            }
            this.lastFallSpeed = f;
            if (!this.current.TreatAsSolidFloor()) {
                if (isoDirections != IsoDirections.Max) {
                    this.dir = isoDirections;
                }
                float f2 = 6.0f * (GameTime.getInstance().getMultiplier() / 1.6f);
                float f3 = this.getHeightAboveFloor();
                if (f > f3) {
                    f2 *= f3 / f;
                }
                this.fallTime += f2;
                if (isoDirections != IsoDirections.Max) {
                    this.fallTime = 0.0f;
                }
                if (this.fallTime < 20.0f && f3 < 0.2f) {
                    this.fallTime = 0.0f;
                }
                this.setZ(this.getZ() - f);
            } else if (this.getZ() > (float)((int)this.getZ()) || f < 0.0f) {
                if (isoDirections != IsoDirections.Max) {
                    this.dir = isoDirections;
                }
                if (!this.current.HasStairs()) {
                    if (!this.wasOnStairs) {
                        float f4 = 6.0f * (GameTime.getInstance().getMultiplier() / 1.6f);
                        float f5 = this.getHeightAboveFloor();
                        if (f > f5) {
                            f4 *= f5 / f;
                        }
                        this.fallTime += f4;
                        if (isoDirections != IsoDirections.Max) {
                            this.fallTime = 0.0f;
                        }
                        this.setZ(this.getZ() - f);
                        if (this.z < (float)((int)this.llz)) {
                            this.z = (int)this.llz;
                            this.DoLand();
                            this.fallTime = 0.0f;
                            this.bFalling = false;
                        }
                    } else {
                        this.wasOnStairs = false;
                    }
                } else {
                    this.fallTime = 0.0f;
                    this.bFalling = false;
                    this.wasOnStairs = true;
                }
            } else {
                this.DoLand();
                this.fallTime = 0.0f;
                this.bFalling = false;
            }
        } else {
            this.DoLand();
            this.fallTime = 0.0f;
            this.bFalling = false;
        }
        this.llz = this.lz;
    }

    private float getHeightAboveFloor() {
        if (this.current == null) {
            return 1.0f;
        }
        if (this.current.HasStairs()) {
            float f = this.current.getApparentZ(this.x - (float)((int)this.x), this.y - (float)((int)this.y));
            if (this.getZ() >= f) {
                return this.getZ() - f;
            }
        }
        if (this.current.TreatAsSolidFloor()) {
            return this.getZ() - (float)((int)this.getZ());
        }
        if (this.current.z == 0) {
            return this.getZ();
        }
        IsoGridSquare isoGridSquare = this.getCell().getGridSquare(this.current.x, this.current.y, this.current.z - 1);
        if (isoGridSquare != null && isoGridSquare.HasStairs()) {
            float f = isoGridSquare.getApparentZ(this.x - (float)((int)this.x), this.y - (float)((int)this.y));
            return this.getZ() - f;
        }
        return 1.0f;
    }

    protected void updateMovementRates() {
    }

    protected float calculateIdleSpeed() {
        float f = 0.01f;
        f = (float)((double)f + (double)this.getMoodles().getMoodleLevel(MoodleType.Endurance) * 2.5 / 10.0);
        return f *= GameTime.getAnimSpeedFix();
    }

    public float calculateBaseSpeed() {
        int n;
        float f = 0.8f;
        float f2 = 1.0f;
        if (this.getMoodles() != null) {
            f -= (float)this.getMoodles().getMoodleLevel(MoodleType.Endurance) * 0.15f;
            f -= (float)this.getMoodles().getMoodleLevel(MoodleType.HeavyLoad) * 0.15f;
        }
        if (this.getMoodles().getMoodleLevel(MoodleType.Panic) >= 3 && this.Traits.AdrenalineJunkie.isSet()) {
            n = this.getMoodles().getMoodleLevel(MoodleType.Panic) + 1;
            f += (float)n / 20.0f;
        }
        for (n = BodyPartType.ToIndex(BodyPartType.Torso_Upper); n < BodyPartType.ToIndex(BodyPartType.Neck) + 1; ++n) {
            BodyPart bodyPart = this.getBodyDamage().getBodyPart(BodyPartType.FromIndex(n));
            if (bodyPart.HasInjury()) {
                f -= 0.1f;
            }
            if (!bodyPart.bandaged()) continue;
            f += 0.05f;
        }
        BodyPart bodyPart = this.getBodyDamage().getBodyPart(BodyPartType.UpperLeg_L);
        if (bodyPart.getAdditionalPain(true) > 20.0f) {
            f -= (bodyPart.getAdditionalPain(true) - 20.0f) / 100.0f;
        }
        for (int i = 0; i < this.bagsWorn.size(); ++i) {
            InventoryContainer inventoryContainer = this.bagsWorn.get(i);
            f2 += this.calcRunSpeedModByBag(inventoryContainer);
        }
        if (this.getPrimaryHandItem() != null && this.getPrimaryHandItem() instanceof InventoryContainer) {
            f2 += this.calcRunSpeedModByBag((InventoryContainer)this.getPrimaryHandItem());
        }
        if (this.getSecondaryHandItem() != null && this.getSecondaryHandItem() instanceof InventoryContainer) {
            f2 += this.calcRunSpeedModByBag((InventoryContainer)this.getSecondaryHandItem());
        }
        this.fullSpeedMod = this.runSpeedModifier + (f2 - 1.0f);
        return f * (1.0f - Math.abs(1.0f - this.fullSpeedMod) / 2.0f);
    }

    private float calcRunSpeedModByClothing() {
        float f = 0.0f;
        int n = 0;
        for (int i = 0; i < this.wornItems.size(); ++i) {
            InventoryItem inventoryItem = this.wornItems.getItemByIndex(i);
            if (!(inventoryItem instanceof Clothing) || ((Clothing)inventoryItem).getRunSpeedModifier() == 1.0f) continue;
            f += ((Clothing)inventoryItem).getRunSpeedModifier();
            ++n;
        }
        if (f == 0.0f && n == 0) {
            f = 1.0f;
            n = 1;
        }
        if (this.getWornItem("Shoes") == null) {
            f *= 0.8f;
        }
        return f / (float)n;
    }

    private float calcRunSpeedModByBag(InventoryContainer inventoryContainer) {
        float f = inventoryContainer.getScriptItem().runSpeedModifier - 1.0f;
        float f2 = inventoryContainer.getContentsWeight() / (float)inventoryContainer.getEffectiveCapacity(this);
        return f *= 1.0f + f2 / 2.0f;
    }

    protected float calculateCombatSpeed() {
        boolean bl = true;
        float f = 1.0f;
        InventoryItem inventoryItem = null;
        if (this.getPrimaryHandItem() != null && this.getPrimaryHandItem() instanceof HandWeapon) {
            inventoryItem = (HandWeapon)this.getPrimaryHandItem();
            f *= ((HandWeapon)this.getPrimaryHandItem()).getBaseSpeed();
        }
        WeaponType weaponType = WeaponType.getWeaponType(this);
        if (inventoryItem != null && inventoryItem.isTwoHandWeapon() && this.getSecondaryHandItem() != inventoryItem) {
            f *= 0.77f;
        }
        if (inventoryItem != null && this.Traits.Axeman.isSet() && ((HandWeapon)inventoryItem).getCategories().contains("Axe")) {
            f *= this.getChopTreeSpeed();
            bl = false;
        }
        f -= (float)this.getMoodles().getMoodleLevel(MoodleType.Endurance) * 0.07f;
        f -= (float)this.getMoodles().getMoodleLevel(MoodleType.HeavyLoad) * 0.07f;
        f += (float)this.getWeaponLevel() * 0.03f;
        f += (float)this.getPerkLevel(PerkFactory.Perks.Fitness) * 0.02f;
        if (this.getSecondaryHandItem() != null && this.getSecondaryHandItem() instanceof InventoryContainer) {
            f *= 0.95f;
        }
        f *= Rand.Next(1.1f, 1.2f);
        f *= this.combatSpeedModifier;
        f *= this.getArmsInjurySpeedModifier();
        if (this.getBodyDamage() != null && this.getBodyDamage().getThermoregulator() != null) {
            f *= this.getBodyDamage().getThermoregulator().getCombatModifier();
        }
        f = Math.min(1.6f, f);
        f = Math.max(0.8f, f);
        if (inventoryItem != null && inventoryItem.isTwoHandWeapon() && weaponType.type.equalsIgnoreCase("heavy")) {
            f *= 1.2f;
        }
        return f * (bl ? GameTime.getAnimSpeedFix() : 1.0f);
    }

    private float getArmsInjurySpeedModifier() {
        float f = 1.0f;
        float f2 = 0.0f;
        BodyPart bodyPart = this.getBodyDamage().getBodyPart(BodyPartType.Hand_R);
        f2 = this.calculateInjurySpeed(bodyPart, true);
        if (f2 > 0.0f) {
            f -= f2;
        }
        if ((f2 = this.calculateInjurySpeed(bodyPart = this.getBodyDamage().getBodyPart(BodyPartType.ForeArm_R), true)) > 0.0f) {
            f -= f2;
        }
        if ((f2 = this.calculateInjurySpeed(bodyPart = this.getBodyDamage().getBodyPart(BodyPartType.UpperArm_R), true)) > 0.0f) {
            f -= f2;
        }
        return f;
    }

    private float getFootInjurySpeedModifier() {
        float f = 0.0f;
        boolean bl = true;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = BodyPartType.ToIndex(BodyPartType.Groin); i < BodyPartType.ToIndex(BodyPartType.MAX); ++i) {
            f = this.calculateInjurySpeed(this.getBodyDamage().getBodyPart(BodyPartType.FromIndex(i)), false);
            if (bl) {
                f2 += f;
            } else {
                f3 += f;
            }
            bl = !bl;
        }
        if (f2 > f3) {
            return -(f2 + f3);
        }
        return f2 + f3;
    }

    private float calculateInjurySpeed(BodyPart bodyPart, boolean bl) {
        float f = bodyPart.getScratchSpeedModifier();
        float f2 = bodyPart.getCutSpeedModifier();
        float f3 = bodyPart.getBurnSpeedModifier();
        float f4 = bodyPart.getDeepWoundSpeedModifier();
        float f5 = 0.0f;
        if ((bodyPart.getType() == BodyPartType.Foot_L || bodyPart.getType() == BodyPartType.Foot_R) && (bodyPart.getBurnTime() > 5.0f || bodyPart.getBiteTime() > 0.0f || bodyPart.deepWounded() || bodyPart.isSplint() || bodyPart.getFractureTime() > 0.0f || bodyPart.haveGlass())) {
            f5 = 1.0f;
            if (bodyPart.bandaged()) {
                f5 = 0.7f;
            }
            if (bodyPart.getFractureTime() > 0.0f) {
                f5 = this.calcFractureInjurySpeed(bodyPart);
            }
        }
        if (bodyPart.haveBullet()) {
            return 1.0f;
        }
        if (bodyPart.getScratchTime() > 2.0f || bodyPart.getCutTime() > 5.0f || bodyPart.getBurnTime() > 0.0f || bodyPart.getDeepWoundTime() > 0.0f || bodyPart.isSplint() || bodyPart.getFractureTime() > 0.0f || bodyPart.getBiteTime() > 0.0f) {
            f5 += bodyPart.getScratchTime() / f + bodyPart.getCutTime() / f2 + bodyPart.getBurnTime() / f3 + bodyPart.getDeepWoundTime() / f4;
            f5 += bodyPart.getBiteTime() / 20.0f;
            if (bodyPart.bandaged()) {
                f5 /= 2.0f;
            }
            if (bodyPart.getFractureTime() > 0.0f) {
                f5 = this.calcFractureInjurySpeed(bodyPart);
            }
        }
        if (bl && bodyPart.getPain() > 20.0f) {
            f5 += bodyPart.getPain() / 10.0f;
        }
        return f5;
    }

    private float calcFractureInjurySpeed(BodyPart bodyPart) {
        float f = 0.4f;
        if (bodyPart.getFractureTime() > 10.0f) {
            f = 0.7f;
        }
        if (bodyPart.getFractureTime() > 20.0f) {
            f = 1.0f;
        }
        if (bodyPart.getSplintFactor() > 0.0f) {
            f -= 0.2f;
            f -= Math.min(bodyPart.getSplintFactor() / 10.0f, 0.8f);
        }
        return Math.max(0.0f, f);
    }

    protected void calculateWalkSpeed() {
        IsoTree isoTree;
        IsoGridSquare isoGridSquare;
        if (this instanceof IsoPlayer && !((IsoPlayer)this).isLocalPlayer()) {
            return;
        }
        float f = 0.0f;
        float f2 = this.getFootInjurySpeedModifier();
        this.setVariable("WalkInjury", f2);
        f = this.calculateBaseSpeed();
        if (this.bRunning || this.bSprinting) {
            f -= 0.15f;
            f *= this.fullSpeedMod;
            f += (float)this.getPerkLevel(PerkFactory.Perks.Sprinting) / 20.0f;
            f = (float)((double)f - Math.abs((double)f2 / 1.5));
            if ("Tutorial".equals(Core.GameMode)) {
                f = Math.max(1.0f, f);
            }
        } else {
            f *= this.walkSpeedModifier;
        }
        if (this.getSlowFactor() > 0.0f) {
            f *= 0.05f;
        }
        f = Math.min(1.0f, f);
        if (this.getBodyDamage() != null && this.getBodyDamage().getThermoregulator() != null) {
            f *= this.getBodyDamage().getThermoregulator().getMovementModifier();
        }
        if (this.isAiming()) {
            float f3 = Math.min(0.9f + (float)this.getPerkLevel(PerkFactory.Perks.Nimble) / 10.0f, 1.5f);
            float f4 = Math.min(f * 2.5f, 1.0f);
            f3 *= f4;
            f3 = Math.max(f3, 0.6f);
            this.setVariable("StrafeSpeed", f3 * GameTime.getAnimSpeedFix());
        }
        if (this.isInTreesNoBush() && (isoGridSquare = this.getCurrentSquare()) != null && isoGridSquare.Has(IsoObjectType.tree) && (isoTree = isoGridSquare.getTree()) != null) {
            f *= isoTree.getSlowFactor(this);
        }
        this.setVariable("WalkSpeed", f * GameTime.getAnimSpeedFix());
    }

    public void updateSpeedModifiers() {
        this.runSpeedModifier = 1.0f;
        this.walkSpeedModifier = 1.0f;
        this.combatSpeedModifier = 1.0f;
        this.bagsWorn = new ArrayList();
        for (int i = 0; i < this.getWornItems().size(); ++i) {
            InventoryItem inventoryItem;
            InventoryItem inventoryItem2 = this.getWornItems().getItemByIndex(i);
            if (inventoryItem2 instanceof Clothing) {
                inventoryItem = (Clothing)inventoryItem2;
                this.combatSpeedModifier += ((Clothing)inventoryItem).getCombatSpeedModifier() - 1.0f;
            }
            if (!(inventoryItem2 instanceof InventoryContainer)) continue;
            inventoryItem = (InventoryContainer)inventoryItem2;
            this.combatSpeedModifier += inventoryItem.getScriptItem().combatSpeedModifier - 1.0f;
            this.bagsWorn.add((InventoryContainer)inventoryItem);
        }
        InventoryItem inventoryItem = this.getWornItems().getItem("Shoes");
        if (inventoryItem == null || inventoryItem.getCondition() == 0) {
            this.runSpeedModifier *= 0.85f;
            this.walkSpeedModifier *= 0.85f;
        }
    }

    public void DoFloorSplat(IsoGridSquare isoGridSquare, String string, boolean bl, float f, float f2) {
        Object object;
        if (isoGridSquare == null) {
            return;
        }
        isoGridSquare.DirtySlice();
        IsoObject isoObject = null;
        for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
            object = isoGridSquare.getObjects().get(i);
            if (((IsoObject)object).sprite == null || !((IsoObject)object).sprite.getProperties().Is(IsoFlagType.solidfloor) || isoObject != null) continue;
            isoObject = object;
        }
        if (isoObject != null && isoObject.sprite != null && (isoObject.sprite.getProperties().Is(IsoFlagType.vegitation) || isoObject.sprite.getProperties().Is(IsoFlagType.solidfloor))) {
            IsoSprite isoSprite = IsoSprite.getSprite(IsoSpriteManager.instance, string, 0);
            if (isoSprite == null) {
                return;
            }
            if (isoObject.AttachedAnimSprite.size() > 7) {
                return;
            }
            object = IsoSpriteInstance.get(isoSprite);
            isoObject.AttachedAnimSprite.add((IsoSpriteInstance)object);
            isoObject.AttachedAnimSprite.get((int)(isoObject.AttachedAnimSprite.size() - 1)).Flip = bl;
            isoObject.AttachedAnimSprite.get((int)(isoObject.AttachedAnimSprite.size() - 1)).tintr = 0.5f + (float)Rand.Next(100) / 2000.0f;
            isoObject.AttachedAnimSprite.get((int)(isoObject.AttachedAnimSprite.size() - 1)).tintg = 0.7f + (float)Rand.Next(300) / 1000.0f;
            isoObject.AttachedAnimSprite.get((int)(isoObject.AttachedAnimSprite.size() - 1)).tintb = 0.7f + (float)Rand.Next(300) / 1000.0f;
            isoObject.AttachedAnimSprite.get(isoObject.AttachedAnimSprite.size() - 1).SetAlpha(0.4f * f2 * 0.6f);
            isoObject.AttachedAnimSprite.get(isoObject.AttachedAnimSprite.size() - 1).SetTargetAlpha(0.4f * f2 * 0.6f);
            isoObject.AttachedAnimSprite.get((int)(isoObject.AttachedAnimSprite.size() - 1)).offZ = -f;
            isoObject.AttachedAnimSprite.get((int)(isoObject.AttachedAnimSprite.size() - 1)).offX = 0.0f;
        }
    }

    void DoSplat(IsoGridSquare isoGridSquare, String string, boolean bl, IsoFlagType isoFlagType, float f, float f2, float f3) {
        if (isoGridSquare == null) {
            return;
        }
        isoGridSquare.DoSplat(string, bl, isoFlagType, f, f2, f3);
    }

    @Override
    public boolean onMouseLeftClick(int n, int n2) {
        if (IsoCamera.CamCharacter != IsoPlayer.getInstance() && Core.bDebug) {
            IsoCamera.CamCharacter = this;
        }
        return super.onMouseLeftClick(n, n2);
    }

    protected void calculateStats() {
        if (GameServer.bServer) {
            this.stats.fatigue = 0.0f;
        } else if (!(!GameClient.bClient || ServerOptions.instance.SleepAllowed.getValue() && ServerOptions.instance.SleepNeeded.getValue())) {
            this.stats.fatigue = 0.0f;
        }
        if (LuaHookManager.TriggerHook("CalculateStats", this)) {
            return;
        }
        this.updateEndurance();
        this.updateTripping();
        this.updateThirst();
        this.updateStress();
        this.updateStats_WakeState();
        this.stats.endurance = PZMath.clamp(this.stats.endurance, 0.0f, 1.0f);
        this.stats.hunger = PZMath.clamp(this.stats.hunger, 0.0f, 1.0f);
        this.stats.stress = PZMath.clamp(this.stats.stress, 0.0f, 1.0f);
        this.stats.fatigue = PZMath.clamp(this.stats.fatigue, 0.0f, 1.0f);
        this.updateMorale();
        this.updateFitness();
    }

    protected void updateStats_WakeState() {
        if (IsoPlayer.getInstance() == this && this.Asleep) {
            this.updateStats_Sleeping();
        } else {
            this.updateStats_Awake();
        }
    }

    protected void updateStats_Sleeping() {
    }

    protected void updateStats_Awake() {
        double d;
        this.stats.stress = (float)((double)this.stats.stress - ZomboidGlobals.StressReduction * (double)GameTime.instance.getMultiplier() * (double)GameTime.instance.getDeltaMinutesPerDay());
        float f = 1.0f - this.stats.endurance;
        if (f < 0.3f) {
            f = 0.3f;
        }
        float f2 = 1.0f;
        if (this.Traits.NeedsLessSleep.isSet()) {
            f2 = 0.7f;
        }
        if (this.Traits.NeedsMoreSleep.isSet()) {
            f2 = 1.3f;
        }
        if ((d = SandboxOptions.instance.getStatsDecreaseMultiplier()) < 1.0) {
            d = 1.0;
        }
        this.stats.fatigue = (float)((double)this.stats.fatigue + ZomboidGlobals.FatigueIncrease * SandboxOptions.instance.getStatsDecreaseMultiplier() * (double)f * (double)GameTime.instance.getMultiplier() * (double)GameTime.instance.getDeltaMinutesPerDay() * (double)f2 * this.getFatiqueMultiplier());
        float f3 = this.getAppetiteMultiplier();
        this.stats.hunger = this instanceof IsoPlayer && ((IsoPlayer)this).IsRunning() && this.isPlayerMoving() || this.isCurrentState(SwipeStatePlayer.instance()) ? (this.Moodles.getMoodleLevel(MoodleType.FoodEaten) == 0 ? (float)((double)this.stats.hunger + ZomboidGlobals.HungerIncreaseWhenExercise / 3.0 * SandboxOptions.instance.getStatsDecreaseMultiplier() * (double)f3 * (double)GameTime.instance.getMultiplier() * (double)GameTime.instance.getDeltaMinutesPerDay() * this.getHungerMultiplier()) : (float)((double)this.stats.hunger + ZomboidGlobals.HungerIncreaseWhenExercise * SandboxOptions.instance.getStatsDecreaseMultiplier() * (double)f3 * (double)GameTime.instance.getMultiplier() * (double)GameTime.instance.getDeltaMinutesPerDay() * this.getHungerMultiplier())) : (this.Moodles.getMoodleLevel(MoodleType.FoodEaten) == 0 ? (float)((double)this.stats.hunger + ZomboidGlobals.HungerIncrease * SandboxOptions.instance.getStatsDecreaseMultiplier() * (double)f3 * (double)GameTime.instance.getMultiplier() * (double)GameTime.instance.getDeltaMinutesPerDay() * this.getHungerMultiplier()) : (float)((double)this.stats.hunger + (double)((float)ZomboidGlobals.HungerIncreaseWhenWellFed) * SandboxOptions.instance.getStatsDecreaseMultiplier() * (double)GameTime.instance.getMultiplier() * (double)GameTime.instance.getDeltaMinutesPerDay() * this.getHungerMultiplier()));
        if (this.getCurrentSquare() == this.getLastSquare() && !this.isReading()) {
            this.stats.idleboredom += 5.0E-5f * GameTime.instance.getMultiplier() * GameTime.instance.getDeltaMinutesPerDay();
            this.stats.idleboredom += 0.00125f * GameTime.instance.getMultiplier() * GameTime.instance.getDeltaMinutesPerDay();
        }
        if (this.getCurrentSquare() != null && this.getLastSquare() != null && this.getCurrentSquare().getRoom() == this.getLastSquare().getRoom() && this.getCurrentSquare().getRoom() != null && !this.isReading()) {
            this.stats.idleboredom += 1.0E-4f * GameTime.instance.getMultiplier() * GameTime.instance.getDeltaMinutesPerDay();
            this.stats.idleboredom += 0.00125f * GameTime.instance.getMultiplier() * GameTime.instance.getDeltaMinutesPerDay();
        }
    }

    private void updateMorale() {
        float f = 1.0f - this.stats.getStress() - 0.5f;
        if ((f *= 1.0E-4f) > 0.0f) {
            f += 0.5f;
        }
        this.stats.morale += f;
        this.stats.morale = PZMath.clamp(this.stats.morale, 0.0f, 1.0f);
    }

    private void updateFitness() {
        this.stats.fitness = (float)this.getPerkLevel(PerkFactory.Perks.Fitness) / 5.0f - 1.0f;
        if (this.stats.fitness > 1.0f) {
            this.stats.fitness = 1.0f;
        }
        if (this.stats.fitness < -1.0f) {
            this.stats.fitness = -1.0f;
        }
    }

    private void updateTripping() {
        this.stats.TrippingRotAngle = this.stats.Tripping ? (this.stats.TrippingRotAngle += 0.06f) : (this.stats.TrippingRotAngle += 0.0f);
    }

    protected float getAppetiteMultiplier() {
        float f = 1.0f - this.stats.hunger;
        if (this.Traits.HeartyAppitite.isSet()) {
            f *= 1.5f;
        }
        if (this.Traits.LightEater.isSet()) {
            f *= 0.75f;
        }
        return f;
    }

    private void updateStress() {
        float f = 1.0f;
        if (this.Traits.Cowardly.isSet()) {
            f = 2.0f;
        }
        if (this.Traits.Brave.isSet()) {
            f = 0.3f;
        }
        if (this.stats.Panic > 100.0f) {
            this.stats.Panic = 100.0f;
        }
        this.stats.stress = (float)((double)this.stats.stress + (double)WorldSoundManager.instance.getStressFromSounds((int)this.getX(), (int)this.getY(), (int)this.getZ()) * ZomboidGlobals.StressFromSoundsMultiplier);
        if (this.BodyDamage.getNumPartsBitten() > 0) {
            this.stats.stress = (float)((double)this.stats.stress + ZomboidGlobals.StressFromBiteOrScratch * (double)GameTime.instance.getMultiplier() * (double)GameTime.instance.getDeltaMinutesPerDay());
        }
        if (this.BodyDamage.getNumPartsScratched() > 0) {
            this.stats.stress = (float)((double)this.stats.stress + ZomboidGlobals.StressFromBiteOrScratch * (double)GameTime.instance.getMultiplier() * (double)GameTime.instance.getDeltaMinutesPerDay());
        }
        if (this.BodyDamage.IsInfected() || this.BodyDamage.IsFakeInfected()) {
            this.stats.stress = (float)((double)this.stats.stress + ZomboidGlobals.StressFromBiteOrScratch * (double)GameTime.instance.getMultiplier() * (double)GameTime.instance.getDeltaMinutesPerDay());
        }
        if (this.Traits.Hemophobic.isSet()) {
            this.stats.stress = (float)((double)this.stats.stress + (double)this.getTotalBlood() * ZomboidGlobals.StressFromHemophobic * (double)(GameTime.instance.getMultiplier() / 0.8f) * (double)GameTime.instance.getDeltaMinutesPerDay());
        }
        this.stats.Anger = this.Traits.Brooding.isSet() ? (float)((double)this.stats.Anger - ZomboidGlobals.AngerDecrease * ZomboidGlobals.BroodingAngerDecreaseMultiplier * (double)GameTime.instance.getMultiplier() * (double)GameTime.instance.getDeltaMinutesPerDay()) : (float)((double)this.stats.Anger - ZomboidGlobals.AngerDecrease * (double)GameTime.instance.getMultiplier() * (double)GameTime.instance.getDeltaMinutesPerDay());
        this.stats.Anger = PZMath.clamp(this.stats.Anger, 0.0f, 1.0f);
    }

    private void updateEndurance() {
        this.stats.endurancelast = this.stats.endurance = PZMath.clamp(this.stats.endurance, 0.0f, 1.0f);
        if (this.isUnlimitedEndurance()) {
            this.stats.endurance = 1.0f;
        }
    }

    private void updateThirst() {
        float f = 1.0f;
        if (this.Traits.HighThirst.isSet()) {
            f = (float)((double)f * 2.0);
        }
        if (this.Traits.LowThirst.isSet()) {
            f = (float)((double)f * 0.5);
        }
        if (IsoPlayer.getInstance() == this && !IsoPlayer.getInstance().isGhostMode()) {
            this.stats.thirst = this.Asleep ? (float)((double)this.stats.thirst + ZomboidGlobals.ThirstSleepingIncrease * SandboxOptions.instance.getStatsDecreaseMultiplier() * (double)GameTime.instance.getMultiplier() * (double)GameTime.instance.getDeltaMinutesPerDay() * (double)f) : (float)((double)this.stats.thirst + ZomboidGlobals.ThirstIncrease * SandboxOptions.instance.getStatsDecreaseMultiplier() * (double)GameTime.instance.getMultiplier() * this.getRunningThirstReduction() * (double)GameTime.instance.getDeltaMinutesPerDay() * (double)f * this.getThirstMultiplier());
            if (this.stats.thirst > 1.0f) {
                this.stats.thirst = 1.0f;
            }
        }
        this.autoDrink();
    }

    private double getRunningThirstReduction() {
        if (this == IsoPlayer.getInstance() && IsoPlayer.getInstance().IsRunning()) {
            return 1.2;
        }
        return 1.0;
    }

    public void faceLocation(float f, float f2) {
        IsoGameCharacter.tempo.x = f + 0.5f;
        IsoGameCharacter.tempo.y = f2 + 0.5f;
        IsoGameCharacter.tempo.x -= this.getX();
        IsoGameCharacter.tempo.y -= this.getY();
        this.DirectionFromVector(tempo);
        this.getVectorFromDirection(this.m_forwardDirection);
        AnimationPlayer animationPlayer = this.getAnimationPlayer();
        if (animationPlayer != null && animationPlayer.isReady()) {
            animationPlayer.UpdateDir(this);
        }
    }

    public void faceLocationF(float f, float f2) {
        IsoGameCharacter.tempo.x = f;
        IsoGameCharacter.tempo.y = f2;
        IsoGameCharacter.tempo.x -= this.getX();
        IsoGameCharacter.tempo.y -= this.getY();
        if (tempo.getLengthSquared() == 0.0f) {
            return;
        }
        this.DirectionFromVector(tempo);
        tempo.normalize();
        this.m_forwardDirection.set(IsoGameCharacter.tempo.x, IsoGameCharacter.tempo.y);
        AnimationPlayer animationPlayer = this.getAnimationPlayer();
        if (animationPlayer != null && animationPlayer.isReady()) {
            animationPlayer.UpdateDir(this);
        }
    }

    public boolean isFacingLocation(float f, float f2, float f3) {
        Vector2 vector22 = BaseVehicle.allocVector2().set(f - this.getX(), f2 - this.getY());
        vector22.normalize();
        Vector2 vector23 = this.getLookVector(BaseVehicle.allocVector2());
        float f4 = vector22.dot(vector23);
        BaseVehicle.releaseVector2(vector22);
        BaseVehicle.releaseVector2(vector23);
        return f4 >= f3;
    }

    public boolean isFacingObject(IsoObject isoObject, float f) {
        Vector2 vector22 = BaseVehicle.allocVector2();
        isoObject.getFacingPosition(vector22);
        boolean bl = this.isFacingLocation(vector22.x, vector22.y, f);
        BaseVehicle.releaseVector2(vector22);
        return bl;
    }

    private void checkDrawWeaponPre(float f, float f2, float f3, ColorInfo colorInfo) {
        if (this.sprite == null) {
            return;
        }
        if (this.sprite.CurrentAnim == null) {
            return;
        }
        if (this.sprite.CurrentAnim.name == null) {
            return;
        }
        if (this.dir == IsoDirections.S || this.dir == IsoDirections.SE || this.dir == IsoDirections.E || this.dir == IsoDirections.NE || this.dir == IsoDirections.SW) {
            return;
        }
        if (!this.sprite.CurrentAnim.name.contains("Attack_")) {
            return;
        }
    }

    public void splatBlood(int n, float f) {
        if (this.getCurrentSquare() == null) {
            return;
        }
        this.getCurrentSquare().splatBlood(n, f);
    }

    @Override
    public boolean isOutside() {
        if (this.getCurrentSquare() == null) {
            return false;
        }
        return this.getCurrentSquare().isOutside();
    }

    @Override
    public boolean isFemale() {
        return this.bFemale;
    }

    @Override
    public void setFemale(boolean bl) {
        this.bFemale = bl;
    }

    @Override
    public boolean isZombie() {
        return false;
    }

    @Override
    public int getLastHitCount() {
        return this.lastHitCount;
    }

    @Override
    public void setLastHitCount(int n) {
        this.lastHitCount = n;
    }

    public int getSurvivorKills() {
        return this.SurvivorKills;
    }

    public void setSurvivorKills(int n) {
        this.SurvivorKills = n;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int n) {
        this.age = n;
    }

    public void exert(float f) {
        if (this.Traits.PlaysFootball.isSet()) {
            f *= 0.9f;
        }
        if (this.Traits.Jogger.isSet()) {
            f *= 0.9f;
        }
        this.stats.endurance -= f;
    }

    @Override
    public PerkInfo getPerkInfo(PerkFactory.Perk perk) {
        for (int i = 0; i < this.PerkList.size(); ++i) {
            PerkInfo perkInfo = this.PerkList.get(i);
            if (perkInfo.perk != perk) continue;
            return perkInfo;
        }
        return null;
    }

    @Override
    public boolean isEquipped(InventoryItem inventoryItem) {
        return this.isEquippedClothing(inventoryItem) || this.isHandItem(inventoryItem);
    }

    @Override
    public boolean isEquippedClothing(InventoryItem inventoryItem) {
        return this.wornItems.contains(inventoryItem);
    }

    @Override
    public boolean isAttachedItem(InventoryItem inventoryItem) {
        return this.getAttachedItems().contains(inventoryItem);
    }

    @Override
    public void faceThisObject(IsoObject isoObject) {
        if (isoObject == null) {
            return;
        }
        Vector2 vector22 = tempo;
        BaseVehicle baseVehicle = Type.tryCastTo(isoObject, BaseVehicle.class);
        BarricadeAble barricadeAble = Type.tryCastTo(isoObject, BarricadeAble.class);
        if (baseVehicle != null) {
            baseVehicle.getFacingPosition(this, vector22);
            vector22.x -= this.getX();
            vector22.y -= this.getY();
            this.DirectionFromVector(vector22);
            vector22.normalize();
            this.m_forwardDirection.set(vector22.x, vector22.y);
        } else if (barricadeAble != null && this.current == barricadeAble.getSquare()) {
            this.dir = barricadeAble.getNorth() ? IsoDirections.N : IsoDirections.W;
            this.getVectorFromDirection(this.m_forwardDirection);
        } else if (barricadeAble != null && this.current == barricadeAble.getOppositeSquare()) {
            this.dir = barricadeAble.getNorth() ? IsoDirections.S : IsoDirections.E;
            this.getVectorFromDirection(this.m_forwardDirection);
        } else {
            isoObject.getFacingPosition(vector22);
            vector22.x -= this.getX();
            vector22.y -= this.getY();
            this.DirectionFromVector(vector22);
            this.getVectorFromDirection(this.m_forwardDirection);
        }
        AnimationPlayer animationPlayer = this.getAnimationPlayer();
        if (animationPlayer != null && animationPlayer.isReady()) {
            animationPlayer.UpdateDir(this);
        }
    }

    @Override
    public void facePosition(int n, int n2) {
        IsoGameCharacter.tempo.x = n;
        IsoGameCharacter.tempo.y = n2;
        IsoGameCharacter.tempo.x -= this.getX();
        IsoGameCharacter.tempo.y -= this.getY();
        this.DirectionFromVector(tempo);
        this.getVectorFromDirection(this.m_forwardDirection);
        AnimationPlayer animationPlayer = this.getAnimationPlayer();
        if (animationPlayer != null && animationPlayer.isReady()) {
            animationPlayer.UpdateDir(this);
        }
    }

    @Override
    public void faceThisObjectAlt(IsoObject isoObject) {
        if (isoObject == null) {
            return;
        }
        isoObject.getFacingPositionAlt(tempo);
        IsoGameCharacter.tempo.x -= this.getX();
        IsoGameCharacter.tempo.y -= this.getY();
        this.DirectionFromVector(tempo);
        this.getVectorFromDirection(this.m_forwardDirection);
        AnimationPlayer animationPlayer = this.getAnimationPlayer();
        if (animationPlayer != null && animationPlayer.isReady()) {
            animationPlayer.UpdateDir(this);
        }
    }

    public void setAnimated(boolean bl) {
        this.legsSprite.Animate = true;
    }

    public void playHurtSound() {
        this.getEmitter().playVocals(this.getHurtSound());
    }

    public void playDeadSound() {
        if (this.isCloseKilled()) {
            this.getEmitter().playSoundImpl("HeadStab", this);
        } else {
            this.getEmitter().playSoundImpl("HeadSmash", this);
        }
        if (this.isZombie()) {
            ((IsoZombie)this).parameterZombieState.setState(ParameterZombieState.State.Death);
        }
    }

    @Override
    public void saveChange(String string, KahluaTable kahluaTable, ByteBuffer byteBuffer) {
        super.saveChange(string, kahluaTable, byteBuffer);
        if ("addItem".equals(string)) {
            if (kahluaTable != null && kahluaTable.rawget((Object)"item") instanceof InventoryItem) {
                InventoryItem inventoryItem = (InventoryItem)kahluaTable.rawget((Object)"item");
                try {
                    inventoryItem.saveWithSize(byteBuffer, false);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else if ("addItemOfType".equals(string)) {
            if (kahluaTable != null && kahluaTable.rawget((Object)"type") instanceof String) {
                GameWindow.WriteStringUTF(byteBuffer, (String)kahluaTable.rawget((Object)"type"));
                if (kahluaTable.rawget((Object)"count") instanceof Double) {
                    byteBuffer.putShort(((Double)kahluaTable.rawget((Object)"count")).shortValue());
                } else {
                    byteBuffer.putShort((short)1);
                }
            }
        } else if ("AddRandomDamageFromZombie".equals(string)) {
            if (kahluaTable != null && kahluaTable.rawget((Object)"zombie") instanceof Double) {
                byteBuffer.putShort(((Double)kahluaTable.rawget((Object)"zombie")).shortValue());
            }
        } else if (!"AddZombieKill".equals(string)) {
            if ("DamageFromWeapon".equals(string)) {
                if (kahluaTable != null && kahluaTable.rawget((Object)"weapon") instanceof String) {
                    GameWindow.WriteStringUTF(byteBuffer, (String)kahluaTable.rawget((Object)"weapon"));
                }
            } else if ("removeItem".equals(string)) {
                if (kahluaTable != null && kahluaTable.rawget((Object)"item") instanceof Double) {
                    byteBuffer.putInt(((Double)kahluaTable.rawget((Object)"item")).intValue());
                }
            } else if ("removeItemID".equals(string)) {
                if (kahluaTable != null && kahluaTable.rawget((Object)"id") instanceof Double) {
                    byteBuffer.putInt(((Double)kahluaTable.rawget((Object)"id")).intValue());
                }
                if (kahluaTable != null && kahluaTable.rawget((Object)"type") instanceof String) {
                    GameWindow.WriteStringUTF(byteBuffer, (String)kahluaTable.rawget((Object)"type"));
                } else {
                    GameWindow.WriteStringUTF(byteBuffer, null);
                }
            } else if ("removeItemType".equals(string)) {
                if (kahluaTable != null && kahluaTable.rawget((Object)"type") instanceof String) {
                    GameWindow.WriteStringUTF(byteBuffer, (String)kahluaTable.rawget((Object)"type"));
                    if (kahluaTable.rawget((Object)"count") instanceof Double) {
                        byteBuffer.putShort(((Double)kahluaTable.rawget((Object)"count")).shortValue());
                    } else {
                        byteBuffer.putShort((short)1);
                    }
                }
            } else if ("removeOneOf".equals(string)) {
                if (kahluaTable != null && kahluaTable.rawget((Object)"type") instanceof String) {
                    GameWindow.WriteStringUTF(byteBuffer, (String)kahluaTable.rawget((Object)"type"));
                }
            } else if ("reanimatedID".equals(string)) {
                if (kahluaTable != null && kahluaTable.rawget((Object)"ID") instanceof Double) {
                    int n = ((Double)kahluaTable.rawget((Object)"ID")).intValue();
                    byteBuffer.putInt(n);
                }
            } else if ("Shove".equals(string)) {
                if (kahluaTable != null && kahluaTable.rawget((Object)"hitDirX") instanceof Double && kahluaTable.rawget((Object)"hitDirY") instanceof Double && kahluaTable.rawget((Object)"force") instanceof Double) {
                    byteBuffer.putFloat(((Double)kahluaTable.rawget((Object)"hitDirX")).floatValue());
                    byteBuffer.putFloat(((Double)kahluaTable.rawget((Object)"hitDirY")).floatValue());
                    byteBuffer.putFloat(((Double)kahluaTable.rawget((Object)"force")).floatValue());
                }
            } else if ("addXp".equals(string)) {
                if (kahluaTable != null && kahluaTable.rawget((Object)"perk") instanceof Double && kahluaTable.rawget((Object)"xp") instanceof Double) {
                    byteBuffer.putInt(((Double)kahluaTable.rawget((Object)"perk")).intValue());
                    byteBuffer.putInt(((Double)kahluaTable.rawget((Object)"xp")).intValue());
                    Object object = kahluaTable.rawget((Object)"noMultiplier");
                    byteBuffer.put((byte)(Boolean.TRUE.equals(object) ? 1 : 0));
                }
            } else if (!"wakeUp".equals(string) && "mechanicActionDone".equals(string) && kahluaTable != null) {
                byteBuffer.put((Boolean)kahluaTable.rawget((Object)"success") != false ? (byte)1 : 0);
                byteBuffer.putInt(((Double)kahluaTable.rawget((Object)"vehicleId")).intValue());
                GameWindow.WriteString(byteBuffer, (String)kahluaTable.rawget((Object)"partId"));
                byteBuffer.put((Boolean)kahluaTable.rawget((Object)"installing") != false ? (byte)1 : 0);
                byteBuffer.putLong(((Double)kahluaTable.rawget((Object)"itemId")).longValue());
            }
        }
    }

    @Override
    public void loadChange(String string, ByteBuffer byteBuffer) {
        super.loadChange(string, byteBuffer);
        if ("addItem".equals(string)) {
            try {
                InventoryItem inventoryItem = InventoryItem.loadItem(byteBuffer, 195);
                if (inventoryItem != null) {
                    this.getInventory().AddItem(inventoryItem);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if ("addItemOfType".equals(string)) {
            String string2 = GameWindow.ReadStringUTF(byteBuffer);
            int n = byteBuffer.getShort();
            for (int i = 0; i < n; ++i) {
                this.getInventory().AddItem(string2);
            }
        } else if ("AddRandomDamageFromZombie".equals(string)) {
            short s = byteBuffer.getShort();
            IsoZombie isoZombie = GameClient.getZombie(s);
            if (isoZombie != null && !this.isDead()) {
                this.getBodyDamage().AddRandomDamageFromZombie(isoZombie, null);
                this.getBodyDamage().Update();
                if (this.isDead()) {
                    if (this.isFemale()) {
                        isoZombie.getEmitter().playSound("FemaleBeingEatenDeath");
                    } else {
                        isoZombie.getEmitter().playSound("MaleBeingEatenDeath");
                    }
                }
            }
        } else if ("AddZombieKill".equals(string)) {
            this.setZombieKills(this.getZombieKills() + 1);
        } else if ("DamageFromWeapon".equals(string)) {
            String string3 = GameWindow.ReadStringUTF(byteBuffer);
            InventoryItem inventoryItem = InventoryItemFactory.CreateItem(string3);
            if (inventoryItem instanceof HandWeapon) {
                this.getBodyDamage().DamageFromWeapon((HandWeapon)inventoryItem);
            }
        } else if ("exitVehicle".equals(string)) {
            BaseVehicle baseVehicle = this.getVehicle();
            if (baseVehicle != null) {
                baseVehicle.exit(this);
                this.setVehicle(null);
            }
        } else if ("removeItem".equals(string)) {
            int n = byteBuffer.getInt();
            if (n >= 0 && n < this.getInventory().getItems().size()) {
                InventoryItem inventoryItem = this.getInventory().getItems().get(n);
                this.removeFromHands(inventoryItem);
                this.getInventory().Remove(inventoryItem);
            }
        } else if ("removeItemID".equals(string)) {
            int n = byteBuffer.getInt();
            String string4 = GameWindow.ReadStringUTF(byteBuffer);
            InventoryItem inventoryItem = this.getInventory().getItemWithID(n);
            if (inventoryItem != null && inventoryItem.getFullType().equals(string4)) {
                this.removeFromHands(inventoryItem);
                this.getInventory().Remove(inventoryItem);
            }
        } else if ("removeItemType".equals(string)) {
            String string5 = GameWindow.ReadStringUTF(byteBuffer);
            int n = byteBuffer.getShort();
            for (int i = 0; i < n; ++i) {
                this.getInventory().RemoveOneOf(string5);
            }
        } else if ("removeOneOf".equals(string)) {
            String string6 = GameWindow.ReadStringUTF(byteBuffer);
            this.getInventory().RemoveOneOf(string6);
        } else if ("reanimatedID".equals(string)) {
            this.ReanimatedCorpseID = byteBuffer.getInt();
        } else if (!"Shove".equals(string)) {
            if ("StopBurning".equals(string)) {
                this.StopBurning();
            } else if ("addXp".equals(string)) {
                boolean bl;
                PerkFactory.Perk perk = PerkFactory.Perks.fromIndex(byteBuffer.getInt());
                int n = byteBuffer.getInt();
                boolean bl2 = bl = byteBuffer.get() == 1;
                if (bl) {
                    this.getXp().AddXPNoMultiplier(perk, n);
                } else {
                    this.getXp().AddXP(perk, (float)n);
                }
            } else if ("wakeUp".equals(string)) {
                if (this.isAsleep()) {
                    this.Asleep = false;
                    this.ForceWakeUpTime = -1.0f;
                    TutorialManager.instance.StealControl = false;
                    if (this instanceof IsoPlayer && ((IsoPlayer)this).isLocalPlayer()) {
                        UIManager.setFadeBeforeUI(((IsoPlayer)this).getPlayerNum(), true);
                        UIManager.FadeIn(((IsoPlayer)this).getPlayerNum(), 2.0);
                        GameClient.instance.sendPlayer((IsoPlayer)this);
                    }
                }
            } else if ("mechanicActionDone".equals(string)) {
                boolean bl = byteBuffer.get() == 1;
                int n = byteBuffer.getInt();
                String string7 = GameWindow.ReadString(byteBuffer);
                boolean bl3 = byteBuffer.get() == 1;
                long l = byteBuffer.getLong();
                LuaEventManager.triggerEvent("OnMechanicActionDone", this, bl, n, string7, l, bl3);
            } else if ("vehicleNoKey".equals(string)) {
                this.SayDebug(" [img=media/ui/CarKey_none.png]");
            }
        }
    }

    @Override
    public int getAlreadyReadPages(String string) {
        for (int i = 0; i < this.ReadBooks.size(); ++i) {
            ReadBook readBook = this.ReadBooks.get(i);
            if (!readBook.fullType.equals(string)) continue;
            return readBook.alreadyReadPages;
        }
        return 0;
    }

    @Override
    public void setAlreadyReadPages(String string, int n) {
        for (int i = 0; i < this.ReadBooks.size(); ++i) {
            ReadBook readBook = this.ReadBooks.get(i);
            if (!readBook.fullType.equals(string)) continue;
            readBook.alreadyReadPages = n;
            return;
        }
        ReadBook readBook = new ReadBook();
        readBook.fullType = string;
        readBook.alreadyReadPages = n;
        this.ReadBooks.add(readBook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLightInfo() {
        if (!GameServer.bServer) {
            return;
        }
        if (this.isZombie()) {
            return;
        }
        LightInfo lightInfo = this.lightInfo;
        synchronized (lightInfo) {
            this.lightInfo.square = this.movingSq;
            if (this.lightInfo.square == null) {
                this.lightInfo.square = this.getCell().getGridSquare((int)this.x, (int)this.y, (int)this.z);
            }
            if (this.ReanimatedCorpse != null) {
                this.lightInfo.square = this.getCell().getGridSquare((int)this.x, (int)this.y, (int)this.z);
            }
            this.lightInfo.x = this.getX();
            this.lightInfo.y = this.getY();
            this.lightInfo.z = this.getZ();
            this.lightInfo.angleX = this.getForwardDirection().getX();
            this.lightInfo.angleY = this.getForwardDirection().getY();
            this.lightInfo.torches.clear();
            this.lightInfo.night = GameTime.getInstance().getNight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LightInfo initLightInfo2() {
        LightInfo lightInfo = this.lightInfo;
        synchronized (lightInfo) {
            for (int i = 0; i < this.lightInfo2.torches.size(); ++i) {
                TorchInfo.release(this.lightInfo2.torches.get(i));
            }
            this.lightInfo2.initFrom(this.lightInfo);
        }
        return this.lightInfo2;
    }

    public LightInfo getLightInfo2() {
        return this.lightInfo2;
    }

    @Override
    public void postupdate() {
        s_performance.postUpdate.invokeAndMeasure(this, IsoGameCharacter::postUpdateInternal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postUpdateInternal() {
        super.postupdate();
        Object object = this.getAnimationPlayer();
        ((AnimationPlayer)object).UpdateDir(this);
        boolean bl = this.shouldBeTurning();
        this.setTurning(bl);
        boolean bl2 = this.shouldBeTurning90();
        this.setTurning90(bl2);
        boolean bl3 = this.shouldBeTurningAround();
        this.setTurningAround(bl3);
        this.actionContext.update();
        if (this.getCurrentSquare() != null) {
            this.advancedAnimator.update();
        }
        this.actionContext.clearEvent("ActiveAnimFinished");
        this.actionContext.clearEvent("ActiveAnimFinishing");
        this.actionContext.clearEvent("ActiveAnimLooped");
        object = this.getAnimationPlayer();
        if (object != null) {
            State state;
            MoveDeltaModifiers moveDeltaModifiers = L_postUpdate.moveDeltas;
            moveDeltaModifiers.moveDelta = this.getMoveDelta();
            moveDeltaModifiers.turnDelta = this.getTurnDelta();
            bl2 = this.hasPath();
            bl3 = this instanceof IsoPlayer;
            if (bl3 && bl2 && this.isRunning()) {
                moveDeltaModifiers.turnDelta = Math.max(moveDeltaModifiers.turnDelta, 2.0f);
            }
            if ((state = this.getCurrentState()) != null) {
                state.getDeltaModifiers(this, moveDeltaModifiers);
            }
            if (moveDeltaModifiers.twistDelta == -1.0f) {
                moveDeltaModifiers.twistDelta = moveDeltaModifiers.turnDelta * 1.8f;
            }
            if (!this.isTurning()) {
                moveDeltaModifiers.turnDelta = 0.0f;
            }
            float f = Math.max(1.0f - moveDeltaModifiers.moveDelta / 2.0f, 0.0f);
            ((AnimationPlayer)object).angleStepDelta = f * moveDeltaModifiers.turnDelta;
            ((AnimationPlayer)object).angleTwistDelta = f * moveDeltaModifiers.twistDelta;
            ((AnimationPlayer)object).setMaxTwistAngle((float)Math.PI / 180 * this.getMaxTwist());
        }
        if (this.hasActiveModel()) {
            try {
                object = this.legsSprite.modelSlot;
                ((ModelManager.ModelSlot)object).Update();
            }
            catch (Throwable throwable) {
                ExceptionLogger.logException(throwable);
            }
        } else {
            object = this.getAnimationPlayer();
            ((AnimationPlayer)object).bUpdateBones = false;
            bl = PerformanceSettings.InterpolateAnims;
            PerformanceSettings.InterpolateAnims = false;
            try {
                ((AnimationPlayer)object).UpdateDir(this);
                ((AnimationPlayer)object).Update();
            }
            catch (Throwable throwable) {
                ExceptionLogger.logException(throwable);
            }
            finally {
                ((AnimationPlayer)object).bUpdateBones = true;
                PerformanceSettings.InterpolateAnims = bl;
            }
        }
        this.updateLightInfo();
        if (this.isAnimationRecorderActive()) {
            this.m_animationRecorder.logVariables(this);
            this.m_animationRecorder.endLine();
        }
    }

    public boolean shouldBeTurning() {
        boolean bl;
        float f = this.getTargetTwist();
        float f2 = PZMath.abs(f);
        boolean bl2 = bl = f2 > 1.0f;
        if (this.isZombie() && this.getCurrentState() == ZombieFallDownState.instance()) {
            return false;
        }
        if (this.blockTurning) {
            return false;
        }
        if (this.isBehaviourMoving()) {
            return bl;
        }
        if (this.isPlayerMoving()) {
            return bl;
        }
        if (this.isAttacking()) {
            return !this.bAimAtFloor;
        }
        float f3 = this.getAbsoluteExcessTwist();
        if (f3 > 1.0f) {
            return true;
        }
        if (this.isTurning()) {
            return bl;
        }
        return false;
    }

    public boolean shouldBeTurning90() {
        if (!this.isTurning()) {
            return false;
        }
        if (this.isTurning90()) {
            return true;
        }
        float f = this.getTargetTwist();
        float f2 = Math.abs(f);
        return f2 > 65.0f;
    }

    public boolean shouldBeTurningAround() {
        if (!this.isTurning()) {
            return false;
        }
        if (this.isTurningAround()) {
            return true;
        }
        float f = this.getTargetTwist();
        float f2 = Math.abs(f);
        return f2 > 110.0f;
    }

    private boolean isTurning() {
        return this.m_isTurning;
    }

    private void setTurning(boolean bl) {
        this.m_isTurning = bl;
    }

    private boolean isTurningAround() {
        return this.m_isTurningAround;
    }

    private void setTurningAround(boolean bl) {
        this.m_isTurningAround = bl;
    }

    private boolean isTurning90() {
        return this.m_isTurning90;
    }

    private void setTurning90(boolean bl) {
        this.m_isTurning90 = bl;
    }

    public boolean hasPath() {
        return this.getPath2() != null;
    }

    @Override
    public boolean isAnimationRecorderActive() {
        return this.m_animationRecorder != null && this.m_animationRecorder.isRecording();
    }

    @Override
    public AnimationPlayerRecorder getAnimationPlayerRecorder() {
        return this.m_animationRecorder;
    }

    @Override
    public float getMeleeDelay() {
        return this.meleeDelay;
    }

    @Override
    public void setMeleeDelay(float f) {
        this.meleeDelay = Math.max(f, 0.0f);
    }

    @Override
    public float getRecoilDelay() {
        return this.RecoilDelay;
    }

    @Override
    public void setRecoilDelay(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.RecoilDelay = f;
    }

    public float getBeenMovingFor() {
        return this.BeenMovingFor;
    }

    public void setBeenMovingFor(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 70.0f) {
            f = 70.0f;
        }
        this.BeenMovingFor = f;
    }

    public boolean isForceShove() {
        return this.forceShove;
    }

    public void setForceShove(boolean bl) {
        this.forceShove = bl;
    }

    public String getClickSound() {
        return this.clickSound;
    }

    public void setClickSound(String string) {
        this.clickSound = string;
    }

    public int getMeleeCombatMod() {
        int n = this.getWeaponLevel();
        if (n == 1) {
            return -2;
        }
        if (n == 2) {
            return 0;
        }
        if (n == 3) {
            return 1;
        }
        if (n == 4) {
            return 2;
        }
        if (n == 5) {
            return 3;
        }
        if (n == 6) {
            return 4;
        }
        if (n == 7) {
            return 5;
        }
        if (n == 8) {
            return 5;
        }
        if (n == 9) {
            return 6;
        }
        if (n == 10) {
            return 7;
        }
        return -5;
    }

    public int getWeaponLevel() {
        WeaponType weaponType = WeaponType.getWeaponType(this);
        int n = -1;
        if (weaponType != null && weaponType != WeaponType.barehand) {
            if (((HandWeapon)this.getPrimaryHandItem()).getCategories().contains("Axe")) {
                n = this.getPerkLevel(PerkFactory.Perks.Axe);
            }
            if (((HandWeapon)this.getPrimaryHandItem()).getCategories().contains("Spear")) {
                n += this.getPerkLevel(PerkFactory.Perks.Spear);
            }
            if (((HandWeapon)this.getPrimaryHandItem()).getCategories().contains("SmallBlade")) {
                n += this.getPerkLevel(PerkFactory.Perks.SmallBlade);
            }
            if (((HandWeapon)this.getPrimaryHandItem()).getCategories().contains("LongBlade")) {
                n += this.getPerkLevel(PerkFactory.Perks.LongBlade);
            }
            if (((HandWeapon)this.getPrimaryHandItem()).getCategories().contains("Blunt")) {
                n += this.getPerkLevel(PerkFactory.Perks.Blunt);
            }
            if (((HandWeapon)this.getPrimaryHandItem()).getCategories().contains("SmallBlunt")) {
                n += this.getPerkLevel(PerkFactory.Perks.SmallBlunt);
            }
        }
        if (n == -1) {
            return 0;
        }
        return n;
    }

    @Override
    public int getMaintenanceMod() {
        int n = this.getPerkLevel(PerkFactory.Perks.Maintenance);
        return (n += this.getWeaponLevel() / 2) / 2;
    }

    @Override
    public BaseVehicle getVehicle() {
        return this.vehicle;
    }

    @Override
    public void setVehicle(BaseVehicle baseVehicle) {
        this.vehicle = baseVehicle;
    }

    public boolean isUnderVehicle() {
        int n = ((int)this.x - 4) / 10;
        int n2 = ((int)this.y - 4) / 10;
        int n3 = (int)Math.ceil((this.x + 4.0f) / 10.0f);
        int n4 = (int)Math.ceil((this.y + 4.0f) / 10.0f);
        Vector2 vector22 = (Vector2)BaseVehicle.TL_vector2_pool.get().alloc();
        for (int i = n2; i < n4; ++i) {
            for (int j = n; j < n3; ++j) {
                IsoChunk isoChunk;
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(j, i) : IsoWorld.instance.CurrentCell.getChunkForGridSquare(j * 10, i * 10, 0);
                if (isoChunk == null) continue;
                for (int k = 0; k < isoChunk.vehicles.size(); ++k) {
                    BaseVehicle baseVehicle = isoChunk.vehicles.get(k);
                    Vector2 vector23 = baseVehicle.testCollisionWithCharacter(this, 0.3f, vector22);
                    if (vector23 == null || vector23.x == -1.0f) continue;
                    BaseVehicle.TL_vector2_pool.get().release(vector22);
                    return true;
                }
            }
        }
        BaseVehicle.TL_vector2_pool.get().release(vector22);
        return false;
    }

    public boolean isProne() {
        return this.isOnFloor();
    }

    public boolean isBeingSteppedOn() {
        if (!this.isOnFloor()) {
            return false;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                IsoGridSquare isoGridSquare = this.getCell().getGridSquare((int)this.x + j, (int)this.y + i, (int)this.z);
                if (isoGridSquare == null) continue;
                ArrayList<IsoMovingObject> arrayList = isoGridSquare.getMovingObjects();
                for (int k = 0; k < arrayList.size(); ++k) {
                    IsoGameCharacter isoGameCharacter;
                    IsoMovingObject isoMovingObject = arrayList.get(k);
                    if (isoMovingObject == this || (isoGameCharacter = Type.tryCastTo(isoMovingObject, IsoGameCharacter.class)) == null || isoGameCharacter.getVehicle() != null || isoMovingObject.isOnFloor() || !ZombieOnGroundState.isCharacterStandingOnOther(isoGameCharacter, this)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public float getTemperature() {
        return this.getBodyDamage().getTemperature();
    }

    @Override
    public void setTemperature(float f) {
        this.getBodyDamage().setTemperature(f);
    }

    @Override
    public float getReduceInfectionPower() {
        return this.reduceInfectionPower;
    }

    @Override
    public void setReduceInfectionPower(float f) {
        this.reduceInfectionPower = f;
    }

    @Override
    public float getInventoryWeight() {
        if (this.getInventory() == null) {
            return 0.0f;
        }
        float f = 0.0f;
        ArrayList<InventoryItem> arrayList = this.getInventory().getItems();
        for (int i = 0; i < arrayList.size(); ++i) {
            InventoryItem inventoryItem = arrayList.get(i);
            if (inventoryItem.getAttachedSlot() > -1 && !this.isEquipped(inventoryItem)) {
                f += inventoryItem.getHotbarEquippedWeight();
                continue;
            }
            if (this.isEquipped(inventoryItem)) {
                f += inventoryItem.getEquippedWeight();
                continue;
            }
            f += inventoryItem.getUnequippedWeight();
        }
        return f;
    }

    public void dropHandItems() {
        if ("Tutorial".equals(Core.GameMode)) {
            return;
        }
        if (this instanceof IsoPlayer && !((IsoPlayer)this).isLocalPlayer()) {
            return;
        }
        this.dropHeavyItems();
        IsoGridSquare isoGridSquare = this.getCurrentSquare();
        if (isoGridSquare == null) {
            return;
        }
        InventoryItem inventoryItem = this.getPrimaryHandItem();
        InventoryItem inventoryItem2 = this.getSecondaryHandItem();
        if (inventoryItem == null && inventoryItem2 == null) {
            return;
        }
        isoGridSquare = this.getSolidFloorAt(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z);
        if (isoGridSquare == null) {
            return;
        }
        float f = Rand.Next(0.1f, 0.9f);
        float f2 = Rand.Next(0.1f, 0.9f);
        float f3 = isoGridSquare.getApparentZ(f, f2) - (float)isoGridSquare.getZ();
        boolean bl = false;
        if (inventoryItem2 == inventoryItem) {
            bl = true;
        }
        if (inventoryItem != null) {
            this.setPrimaryHandItem(null);
            this.getInventory().DoRemoveItem(inventoryItem);
            isoGridSquare.AddWorldInventoryItem(inventoryItem, f, f2, f3);
            LuaEventManager.triggerEvent("OnContainerUpdate");
            LuaEventManager.triggerEvent("onItemFall", inventoryItem);
        }
        if (inventoryItem2 != null) {
            this.setSecondaryHandItem(null);
            if (!bl) {
                this.getInventory().DoRemoveItem(inventoryItem2);
                isoGridSquare.AddWorldInventoryItem(inventoryItem2, f, f2, f3);
                LuaEventManager.triggerEvent("OnContainerUpdate");
                LuaEventManager.triggerEvent("onItemFall", inventoryItem2);
            }
        }
        this.resetEquippedHandsModels();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldBecomeZombieAfterDeath() {
        switch (SandboxOptions.instance.Lore.Transmission.getValue()) {
            case 1: {
                if (this.getBodyDamage().IsFakeInfected()) return false;
                if (!(this.getBodyDamage().getInfectionLevel() >= 0.001f)) return false;
                return true;
            }
            case 2: {
                if (this.getBodyDamage().IsFakeInfected()) return false;
                if (!(this.getBodyDamage().getInfectionLevel() >= 0.001f)) return false;
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return false;
            }
        }
        return false;
    }

    public void applyTraits(ArrayList<String> arrayList) {
        Object object;
        if (arrayList == null) {
            return;
        }
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        hashMap.put(PerkFactory.Perks.Fitness, 5);
        hashMap.put(PerkFactory.Perks.Strength, 5);
        for (int i = 0; i < arrayList.size(); ++i) {
            TraitFactory.Trait entry;
            String string = arrayList.get(i);
            if (string == null || string.isEmpty() || (entry = TraitFactory.getTrait(string)) == null) continue;
            if (!this.HasTrait(string)) {
                this.getTraits().add(string);
            }
            if ((object = entry.getXPBoostMap()) == null) continue;
            for (Map.Entry entry2 : ((HashMap)object).entrySet()) {
                PerkFactory.Perk perk = (PerkFactory.Perk)entry2.getKey();
                int n = (Integer)entry2.getValue();
                if (hashMap.containsKey(perk)) {
                    n += ((Integer)hashMap.get(perk)).intValue();
                }
                hashMap.put(perk, n);
            }
        }
        if (this instanceof IsoPlayer) {
            ((IsoPlayer)this).getNutrition().applyWeightFromTraits();
        }
        HashMap<PerkFactory.Perk, Integer> hashMap2 = this.getDescriptor().getXPBoostMap();
        for (Map.Entry entry : hashMap2.entrySet()) {
            object = (PerkFactory.Perk)entry.getKey();
            int n = (Integer)entry.getValue();
            if (hashMap.containsKey(object)) {
                n += ((Integer)hashMap.get(object)).intValue();
            }
            hashMap.put(object, n);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (PerkFactory.Perk)entry.getKey();
            int n = (Integer)entry.getValue();
            n = Math.max(0, n);
            n = Math.min(10, n);
            this.getDescriptor().getXPBoostMap().put((PerkFactory.Perk)object, Math.min(3, n));
            for (int i = 0; i < n; ++i) {
                this.LevelPerk((PerkFactory.Perk)object);
            }
            this.getXp().setXPToLevel((PerkFactory.Perk)object, this.getPerkLevel((PerkFactory.Perk)object));
        }
    }

    public void createKeyRing() {
        RoomDef roomDef;
        InventoryItem inventoryItem = this.getInventory().AddItem("Base.KeyRing");
        if (inventoryItem == null || !(inventoryItem instanceof InventoryContainer)) {
            return;
        }
        InventoryContainer inventoryContainer = (InventoryContainer)inventoryItem;
        inventoryContainer.setName(Translator.getText("IGUI_KeyRingName", this.getDescriptor().getForename(), this.getDescriptor().getSurname()));
        if (Rand.Next(100) < 40 && (roomDef = IsoWorld.instance.MetaGrid.getRoomAt((int)this.getX(), (int)this.getY(), (int)this.getZ())) != null && roomDef.getBuilding() != null) {
            String string = "Base.Key" + (Rand.Next(5) + 1);
            InventoryItem inventoryItem2 = inventoryContainer.getInventory().AddItem(string);
            inventoryItem2.setKeyId(roomDef.getBuilding().getKeyId());
        }
    }

    public void autoDrink() {
        if (GameServer.bServer) {
            return;
        }
        if (GameClient.bClient && !((IsoPlayer)this).isLocalPlayer()) {
            return;
        }
        if (!Core.getInstance().getOptionAutoDrink()) {
            return;
        }
        if (LuaHookManager.TriggerHook("AutoDrink", this)) {
            return;
        }
        if (this.stats.thirst <= 0.1f) {
            return;
        }
        InventoryItem inventoryItem = this.getWaterSource(this.getInventory().getItems());
        if (inventoryItem != null) {
            this.stats.thirst -= 0.1f;
            if (GameClient.bClient) {
                GameClient.instance.drink((IsoPlayer)this, 0.1f);
            }
            inventoryItem.Use();
        }
    }

    public InventoryItem getWaterSource(ArrayList<InventoryItem> arrayList) {
        InventoryItem inventoryItem = null;
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            InventoryItem inventoryItem2 = arrayList.get(i);
            if (!inventoryItem2.isWaterSource() || inventoryItem2.isBeingFilled() || inventoryItem2.isTaintedWater()) continue;
            if (inventoryItem2 instanceof Drainable) {
                if (!(((Drainable)((Object)inventoryItem2)).getUsedDelta() > 0.0f)) continue;
                inventoryItem = inventoryItem2;
                break;
            }
            if (inventoryItem2 instanceof InventoryContainer) continue;
            inventoryItem = inventoryItem2;
            break;
        }
        return inventoryItem;
    }

    @Override
    public List<String> getKnownRecipes() {
        return this.knownRecipes;
    }

    @Override
    public boolean isRecipeKnown(Recipe recipe) {
        if (DebugOptions.instance.CheatRecipeKnowAll.getValue()) {
            return true;
        }
        return !recipe.needToBeLearn() || this.getKnownRecipes().contains(recipe.getOriginalname());
    }

    @Override
    public boolean isRecipeKnown(String string) {
        Recipe recipe = ScriptManager.instance.getRecipe(string);
        if (recipe == null) {
            if (DebugOptions.instance.CheatRecipeKnowAll.getValue()) {
                return true;
            }
            return this.getKnownRecipes().contains(string);
        }
        return this.isRecipeKnown(recipe);
    }

    public boolean learnRecipe(String string) {
        if (!this.isRecipeKnown(string)) {
            this.getKnownRecipes().add(string);
            return true;
        }
        return false;
    }

    @Override
    public void addKnownMediaLine(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return;
        }
        this.knownMediaLines.add(string.trim());
    }

    @Override
    public void removeKnownMediaLine(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return;
        }
        this.knownMediaLines.remove(string.trim());
    }

    @Override
    public void clearKnownMediaLines() {
        this.knownMediaLines.clear();
    }

    @Override
    public boolean isKnownMediaLine(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return false;
        }
        return this.knownMediaLines.contains(string.trim());
    }

    protected void saveKnownMediaLines(ByteBuffer byteBuffer) {
        byteBuffer.putShort((short)this.knownMediaLines.size());
        for (String string : this.knownMediaLines) {
            GameWindow.WriteStringUTF(byteBuffer, string);
        }
    }

    protected void loadKnownMediaLines(ByteBuffer byteBuffer, int n) {
        this.knownMediaLines.clear();
        int n2 = byteBuffer.getShort();
        for (int i = 0; i < n2; ++i) {
            String string = GameWindow.ReadStringUTF(byteBuffer);
            this.knownMediaLines.add(string);
        }
    }

    public boolean isMoving() {
        if (this instanceof IsoPlayer && !((IsoPlayer)this).isAttackAnimThrowTimeOut()) {
            return false;
        }
        return this.m_isMoving;
    }

    public boolean isBehaviourMoving() {
        State state = this.getCurrentState();
        return state != null && state.isMoving(this);
    }

    public boolean isPlayerMoving() {
        return false;
    }

    public void setMoving(boolean bl) {
        this.m_isMoving = bl;
        if (GameClient.bClient && this instanceof IsoPlayer && ((IsoPlayer)this).bRemote) {
            ((IsoPlayer)this).m_isPlayerMoving = bl;
            ((IsoPlayer)this).setJustMoved(bl);
        }
    }

    private boolean isFacingNorthWesterly() {
        return this.dir == IsoDirections.W || this.dir == IsoDirections.NW || this.dir == IsoDirections.N || this.dir == IsoDirections.NE;
    }

    public boolean isAttacking() {
        return false;
    }

    public boolean isZombieAttacking() {
        return false;
    }

    public boolean isZombieAttacking(IsoMovingObject isoMovingObject) {
        return false;
    }

    private boolean isZombieThumping() {
        if (this.isZombie()) {
            return this.getCurrentState() == ThumpState.instance();
        }
        return false;
    }

    public int compareMovePriority(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter == null) {
            return 1;
        }
        if (this.isZombieThumping() && !isoGameCharacter.isZombieThumping()) {
            return 1;
        }
        if (!this.isZombieThumping() && isoGameCharacter.isZombieThumping()) {
            return -1;
        }
        if (isoGameCharacter instanceof IsoPlayer) {
            if (GameClient.bClient && this.isZombieAttacking(isoGameCharacter)) {
                return -1;
            }
            return 0;
        }
        if (this.isZombieAttacking() && !isoGameCharacter.isZombieAttacking()) {
            return 1;
        }
        if (!this.isZombieAttacking() && isoGameCharacter.isZombieAttacking()) {
            return -1;
        }
        if (this.isBehaviourMoving() && !isoGameCharacter.isBehaviourMoving()) {
            return 1;
        }
        if (!this.isBehaviourMoving() && isoGameCharacter.isBehaviourMoving()) {
            return -1;
        }
        if (this.isFacingNorthWesterly() && !isoGameCharacter.isFacingNorthWesterly()) {
            return 1;
        }
        if (!this.isFacingNorthWesterly() && isoGameCharacter.isFacingNorthWesterly()) {
            return -1;
        }
        return 0;
    }

    @Override
    public long playSound(String string) {
        return this.getEmitter().playSound(string);
    }

    @Override
    public long playSoundLocal(String string) {
        return this.getEmitter().playSoundImpl(string, null);
    }

    @Override
    public void stopOrTriggerSound(long l) {
        this.getEmitter().stopOrTriggerSound(l);
    }

    @Override
    public void addWorldSoundUnlessInvisible(int n, int n2, boolean bl) {
        if (this.isInvisible()) {
            return;
        }
        WorldSoundManager.instance.addSound(this, (int)this.getX(), (int)this.getY(), (int)this.getZ(), n, n2, bl);
    }

    @Override
    public boolean isKnownPoison(InventoryItem inventoryItem) {
        if (inventoryItem.hasTag("NoDetect")) {
            return false;
        }
        if (inventoryItem instanceof Food) {
            Food food = (Food)inventoryItem;
            if (food.getPoisonPower() <= 0) {
                return false;
            }
            if (food.getHerbalistType() != null && !food.getHerbalistType().isEmpty()) {
                return this.isRecipeKnown("Herbalist");
            }
            if (food.getPoisonDetectionLevel() >= 0 && this.getPerkLevel(PerkFactory.Perks.Cooking) >= 10 - food.getPoisonDetectionLevel()) {
                return true;
            }
            return food.getPoisonLevelForRecipe() != null;
        }
        return false;
    }

    @Override
    public int getLastHourSleeped() {
        return this.lastHourSleeped;
    }

    @Override
    public void setLastHourSleeped(int n) {
        this.lastHourSleeped = n;
    }

    @Override
    public void setTimeOfSleep(float f) {
        this.timeOfSleep = f;
    }

    public void setDelayToSleep(float f) {
        this.delayToActuallySleep = f;
    }

    @Override
    public String getBedType() {
        return this.bedType;
    }

    @Override
    public void setBedType(String string) {
        this.bedType = string;
    }

    public void enterVehicle(BaseVehicle baseVehicle, int n, Vector3f vector3f) {
        if (this.vehicle != null) {
            this.vehicle.exit(this);
        }
        if (baseVehicle != null) {
            baseVehicle.enter(n, this, vector3f);
        }
    }

    @Override
    public float Hit(BaseVehicle baseVehicle, float f, boolean bl, float f2, float f3) {
        this.setHitFromBehind(bl);
        if (GameClient.bClient) {
            this.setAttackedBy(GameClient.IDToPlayerMap.get(baseVehicle.getNetPlayerId()));
        } else if (GameServer.bServer) {
            this.setAttackedBy(GameServer.IDToPlayerMap.get(baseVehicle.getNetPlayerId()));
        } else {
            this.setAttackedBy(baseVehicle.getDriver());
        }
        this.getHitDir().set(f2, f3);
        if (!this.isKnockedDown()) {
            this.setHitForce(Math.max(0.5f, f * 0.15f));
        } else {
            this.setHitForce(Math.min(2.5f, f * 0.15f));
        }
        if (GameClient.bClient) {
            HitReactionNetworkAI.CalcHitReactionVehicle(this, baseVehicle);
        }
        DebugLog.Damage.noise("Vehicle id=%d hit %s id=%d: speed=%f force=%f hitDir=%s", baseVehicle.getId(), this.getClass().getSimpleName(), this.getOnlineID(), Float.valueOf(f), Float.valueOf(this.getHitForce()), this.getHitDir());
        return this.getHealth();
    }

    @Override
    public PolygonalMap2.Path getPath2() {
        return this.path2;
    }

    @Override
    public void setPath2(PolygonalMap2.Path path) {
        this.path2 = path;
    }

    @Override
    public PathFindBehavior2 getPathFindBehavior2() {
        return this.pfb2;
    }

    public MapKnowledge getMapKnowledge() {
        return this.mapKnowledge;
    }

    @Override
    public IsoObject getBed() {
        if (this.isAsleep()) {
            return this.bed;
        }
        return null;
    }

    @Override
    public void setBed(IsoObject isoObject) {
        this.bed = isoObject;
    }

    public boolean avoidDamage() {
        return this.m_avoidDamage;
    }

    public void setAvoidDamage(boolean bl) {
        this.m_avoidDamage = bl;
    }

    @Override
    public boolean isReading() {
        return this.isReading;
    }

    @Override
    public void setReading(boolean bl) {
        this.isReading = bl;
    }

    @Override
    public float getTimeSinceLastSmoke() {
        return this.timeSinceLastSmoke;
    }

    @Override
    public void setTimeSinceLastSmoke(float f) {
        this.timeSinceLastSmoke = PZMath.clamp(f, 0.0f, 10.0f);
    }

    @Override
    public boolean isInvisible() {
        return this.m_invisible;
    }

    @Override
    public void setInvisible(boolean bl) {
        this.m_invisible = bl;
    }

    @Override
    public boolean isDriving() {
        return this.getVehicle() != null && this.getVehicle().getDriver() == this && !this.getVehicle().isStopped();
    }

    @Override
    public boolean isInARoom() {
        return this.square != null && this.square.isInARoom();
    }

    @Override
    public boolean isGodMod() {
        return this.m_godMod;
    }

    @Override
    public void setGodMod(boolean bl) {
        if (!this.isDead()) {
            this.m_godMod = bl;
            if (this instanceof IsoPlayer && GameClient.bClient && ((IsoPlayer)this).isLocalPlayer()) {
                this.updateMovementRates();
                GameClient.sendPlayerInjuries((IsoPlayer)this);
                GameClient.sendPlayerDamage((IsoPlayer)this);
            }
        }
    }

    @Override
    public boolean isUnlimitedCarry() {
        return this.unlimitedCarry;
    }

    @Override
    public void setUnlimitedCarry(boolean bl) {
        this.unlimitedCarry = bl;
    }

    @Override
    public boolean isBuildCheat() {
        return this.buildCheat;
    }

    @Override
    public void setBuildCheat(boolean bl) {
        this.buildCheat = bl;
    }

    @Override
    public boolean isFarmingCheat() {
        return this.farmingCheat;
    }

    @Override
    public void setFarmingCheat(boolean bl) {
        this.farmingCheat = bl;
    }

    @Override
    public boolean isHealthCheat() {
        return this.healthCheat;
    }

    @Override
    public void setHealthCheat(boolean bl) {
        this.healthCheat = bl;
    }

    @Override
    public boolean isMechanicsCheat() {
        return this.mechanicsCheat;
    }

    @Override
    public void setMechanicsCheat(boolean bl) {
        this.mechanicsCheat = bl;
    }

    @Override
    public boolean isMovablesCheat() {
        return this.movablesCheat;
    }

    @Override
    public void setMovablesCheat(boolean bl) {
        this.movablesCheat = bl;
    }

    @Override
    public boolean isTimedActionInstantCheat() {
        return this.timedActionInstantCheat;
    }

    @Override
    public void setTimedActionInstantCheat(boolean bl) {
        this.timedActionInstantCheat = bl;
    }

    @Override
    public boolean isTimedActionInstant() {
        if (Core.bDebug && DebugOptions.instance.CheatTimedActionInstant.getValue()) {
            return true;
        }
        return this.isTimedActionInstantCheat();
    }

    @Override
    public boolean isShowAdminTag() {
        return this.showAdminTag;
    }

    @Override
    public void setShowAdminTag(boolean bl) {
        this.showAdminTag = bl;
    }

    @Override
    public IAnimationVariableSlot getVariable(AnimationVariableHandle animationVariableHandle) {
        return this.getGameVariablesInternal().getVariable(animationVariableHandle);
    }

    @Override
    public IAnimationVariableSlot getVariable(String string) {
        return this.getGameVariablesInternal().getVariable(string);
    }

    @Override
    public IAnimationVariableSlot getOrCreateVariable(String string) {
        return this.getGameVariablesInternal().getOrCreateVariable(string);
    }

    @Override
    public void setVariable(IAnimationVariableSlot iAnimationVariableSlot) {
        this.getGameVariablesInternal().setVariable(iAnimationVariableSlot);
    }

    @Override
    public void setVariable(String string, String string2) {
        this.getGameVariablesInternal().setVariable(string, string2);
    }

    @Override
    public void setVariable(String string, boolean bl) {
        this.getGameVariablesInternal().setVariable(string, bl);
    }

    @Override
    public void setVariable(String string, float f) {
        this.getGameVariablesInternal().setVariable(string, f);
    }

    protected void setVariable(String string, AnimationVariableSlotCallbackBool.CallbackGetStrongTyped callbackGetStrongTyped) {
        this.getGameVariablesInternal().setVariable(string, callbackGetStrongTyped);
    }

    protected void setVariable(String string, AnimationVariableSlotCallbackBool.CallbackGetStrongTyped callbackGetStrongTyped, AnimationVariableSlotCallbackBool.CallbackSetStrongTyped callbackSetStrongTyped) {
        this.getGameVariablesInternal().setVariable(string, callbackGetStrongTyped, callbackSetStrongTyped);
    }

    protected void setVariable(String string, AnimationVariableSlotCallbackString.CallbackGetStrongTyped callbackGetStrongTyped) {
        this.getGameVariablesInternal().setVariable(string, callbackGetStrongTyped);
    }

    protected void setVariable(String string, AnimationVariableSlotCallbackString.CallbackGetStrongTyped callbackGetStrongTyped, AnimationVariableSlotCallbackString.CallbackSetStrongTyped callbackSetStrongTyped) {
        this.getGameVariablesInternal().setVariable(string, callbackGetStrongTyped, callbackSetStrongTyped);
    }

    protected void setVariable(String string, AnimationVariableSlotCallbackFloat.CallbackGetStrongTyped callbackGetStrongTyped) {
        this.getGameVariablesInternal().setVariable(string, callbackGetStrongTyped);
    }

    protected void setVariable(String string, AnimationVariableSlotCallbackFloat.CallbackGetStrongTyped callbackGetStrongTyped, AnimationVariableSlotCallbackFloat.CallbackSetStrongTyped callbackSetStrongTyped) {
        this.getGameVariablesInternal().setVariable(string, callbackGetStrongTyped, callbackSetStrongTyped);
    }

    protected void setVariable(String string, AnimationVariableSlotCallbackInt.CallbackGetStrongTyped callbackGetStrongTyped) {
        this.getGameVariablesInternal().setVariable(string, callbackGetStrongTyped);
    }

    protected void setVariable(String string, AnimationVariableSlotCallbackInt.CallbackGetStrongTyped callbackGetStrongTyped, AnimationVariableSlotCallbackInt.CallbackSetStrongTyped callbackSetStrongTyped) {
        this.getGameVariablesInternal().setVariable(string, callbackGetStrongTyped, callbackSetStrongTyped);
    }

    public void setVariable(String string, boolean bl, AnimationVariableSlotCallbackBool.CallbackGetStrongTyped callbackGetStrongTyped) {
        this.getGameVariablesInternal().setVariable(string, bl, callbackGetStrongTyped);
    }

    public void setVariable(String string, boolean bl, AnimationVariableSlotCallbackBool.CallbackGetStrongTyped callbackGetStrongTyped, AnimationVariableSlotCallbackBool.CallbackSetStrongTyped callbackSetStrongTyped) {
        this.getGameVariablesInternal().setVariable(string, bl, callbackGetStrongTyped, callbackSetStrongTyped);
    }

    public void setVariable(String string, String string2, AnimationVariableSlotCallbackString.CallbackGetStrongTyped callbackGetStrongTyped) {
        this.getGameVariablesInternal().setVariable(string, string2, callbackGetStrongTyped);
    }

    public void setVariable(String string, String string2, AnimationVariableSlotCallbackString.CallbackGetStrongTyped callbackGetStrongTyped, AnimationVariableSlotCallbackString.CallbackSetStrongTyped callbackSetStrongTyped) {
        this.getGameVariablesInternal().setVariable(string, string2, callbackGetStrongTyped, callbackSetStrongTyped);
    }

    public void setVariable(String string, float f, AnimationVariableSlotCallbackFloat.CallbackGetStrongTyped callbackGetStrongTyped) {
        this.getGameVariablesInternal().setVariable(string, f, callbackGetStrongTyped);
    }

    public void setVariable(String string, float f, AnimationVariableSlotCallbackFloat.CallbackGetStrongTyped callbackGetStrongTyped, AnimationVariableSlotCallbackFloat.CallbackSetStrongTyped callbackSetStrongTyped) {
        this.getGameVariablesInternal().setVariable(string, f, callbackGetStrongTyped, callbackSetStrongTyped);
    }

    public void setVariable(String string, int n, AnimationVariableSlotCallbackInt.CallbackGetStrongTyped callbackGetStrongTyped) {
        this.getGameVariablesInternal().setVariable(string, n, callbackGetStrongTyped);
    }

    public void setVariable(String string, int n, AnimationVariableSlotCallbackInt.CallbackGetStrongTyped callbackGetStrongTyped, AnimationVariableSlotCallbackInt.CallbackSetStrongTyped callbackSetStrongTyped) {
        this.getGameVariablesInternal().setVariable(string, n, callbackGetStrongTyped, callbackSetStrongTyped);
    }

    @Override
    public void clearVariable(String string) {
        this.getGameVariablesInternal().clearVariable(string);
    }

    @Override
    public void clearVariables() {
        this.getGameVariablesInternal().clearVariables();
    }

    @Override
    public String getVariableString(String string) {
        return this.getGameVariablesInternal().getVariableString(string);
    }

    private String getFootInjuryType() {
        if (!(this instanceof IsoPlayer)) {
            return "";
        }
        BodyPart bodyPart = this.getBodyDamage().getBodyPart(BodyPartType.Foot_L);
        BodyPart bodyPart2 = this.getBodyDamage().getBodyPart(BodyPartType.Foot_R);
        if (!this.bRunning) {
            if (bodyPart.haveBullet() || bodyPart.getBurnTime() > 5.0f || bodyPart.bitten() || bodyPart.deepWounded() || bodyPart.isSplint() || bodyPart.getFractureTime() > 0.0f || bodyPart.haveGlass()) {
                return "leftheavy";
            }
            if (bodyPart2.haveBullet() || bodyPart2.getBurnTime() > 5.0f || bodyPart2.bitten() || bodyPart2.deepWounded() || bodyPart2.isSplint() || bodyPart2.getFractureTime() > 0.0f || bodyPart2.haveGlass()) {
                return "rightheavy";
            }
        }
        if (bodyPart.getScratchTime() > 5.0f || bodyPart.getCutTime() > 7.0f || bodyPart.getBurnTime() > 0.0f) {
            return "leftlight";
        }
        if (bodyPart2.getScratchTime() > 5.0f || bodyPart2.getCutTime() > 7.0f || bodyPart2.getBurnTime() > 0.0f) {
            return "rightlight";
        }
        return "";
    }

    @Override
    public float getVariableFloat(String string, float f) {
        return this.getGameVariablesInternal().getVariableFloat(string, f);
    }

    @Override
    public boolean getVariableBoolean(String string) {
        return this.getGameVariablesInternal().getVariableBoolean(string);
    }

    @Override
    public boolean getVariableBoolean(String string, boolean bl) {
        return this.getGameVariablesInternal().getVariableBoolean(this.name, bl);
    }

    @Override
    public boolean isVariable(String string, String string2) {
        return this.getGameVariablesInternal().isVariable(string, string2);
    }

    @Override
    public boolean containsVariable(String string) {
        return this.getGameVariablesInternal().containsVariable(string);
    }

    @Override
    public Iterable<IAnimationVariableSlot> getGameVariables() {
        return this.getGameVariablesInternal().getGameVariables();
    }

    private AnimationVariableSource getGameVariablesInternal() {
        if (this.m_PlaybackGameVariables != null) {
            return this.m_PlaybackGameVariables;
        }
        return this.m_GameVariables;
    }

    public AnimationVariableSource startPlaybackGameVariables() {
        if (this.m_PlaybackGameVariables != null) {
            DebugLog.General.error("Error! PlaybackGameVariables is already active.");
            return this.m_PlaybackGameVariables;
        }
        AnimationVariableSource animationVariableSource = new AnimationVariableSource();
        block6: for (IAnimationVariableSlot iAnimationVariableSlot : this.getGameVariables()) {
            AnimationVariableType animationVariableType = iAnimationVariableSlot.getType();
            switch (animationVariableType) {
                case String: {
                    animationVariableSource.setVariable(iAnimationVariableSlot.getKey(), iAnimationVariableSlot.getValueString());
                    continue block6;
                }
                case Float: {
                    animationVariableSource.setVariable(iAnimationVariableSlot.getKey(), iAnimationVariableSlot.getValueFloat());
                    continue block6;
                }
                case Boolean: {
                    animationVariableSource.setVariable(iAnimationVariableSlot.getKey(), iAnimationVariableSlot.getValueBool());
                    continue block6;
                }
                case Void: {
                    continue block6;
                }
            }
            DebugLog.General.error("Error! Variable type not handled: %s", animationVariableType.toString());
        }
        this.m_PlaybackGameVariables = animationVariableSource;
        return this.m_PlaybackGameVariables;
    }

    public void endPlaybackGameVariables(AnimationVariableSource animationVariableSource) {
        if (this.m_PlaybackGameVariables != animationVariableSource) {
            DebugLog.General.error("Error! Playback GameVariables do not match.");
        }
        this.m_PlaybackGameVariables = null;
    }

    public void playbackSetCurrentStateSnapshot(ActionStateSnapshot actionStateSnapshot) {
        if (this.actionContext == null) {
            return;
        }
        this.actionContext.setPlaybackStateSnapshot(actionStateSnapshot);
    }

    public ActionStateSnapshot playbackRecordCurrentStateSnapshot() {
        if (this.actionContext == null) {
            return null;
        }
        return this.actionContext.getPlaybackStateSnapshot();
    }

    @Override
    public String GetVariable(String string) {
        return this.getVariableString(string);
    }

    @Override
    public void SetVariable(String string, String string2) {
        this.setVariable(string, string2);
    }

    @Override
    public void ClearVariable(String string) {
        this.clearVariable(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionStateChanged(ActionContext actionContext) {
        ArrayList<String> arrayList = L_actionStateChanged.stateNames;
        PZArrayUtil.listConvert(actionContext.getChildStates(), arrayList, actionState -> actionState.name);
        this.advancedAnimator.SetState(actionContext.getCurrentStateName(), arrayList);
        try {
            ++this.stateMachine.activeStateChanged;
            State state = this.m_stateUpdateLookup.get(actionContext.getCurrentStateName().toLowerCase());
            if (state == null) {
                state = this.defaultState;
            }
            ArrayList<State> arrayList2 = L_actionStateChanged.states;
            PZArrayUtil.listConvert(actionContext.getChildStates(), arrayList2, this.m_stateUpdateLookup, (actionState, hashMap) -> (State)hashMap.get(actionState.name.toLowerCase()));
            this.stateMachine.changeState(state, arrayList2);
        }
        finally {
            --this.stateMachine.activeStateChanged;
        }
    }

    public boolean isFallOnFront() {
        return this.fallOnFront;
    }

    public void setFallOnFront(boolean bl) {
        this.fallOnFront = bl;
    }

    public boolean isHitFromBehind() {
        return this.hitFromBehind;
    }

    public void setHitFromBehind(boolean bl) {
        this.hitFromBehind = bl;
    }

    @Override
    public void reportEvent(String string) {
        this.actionContext.reportEvent(string);
    }

    @Override
    public void StartTimedActionAnim(String string) {
        this.StartTimedActionAnim(string, null);
    }

    @Override
    public void StartTimedActionAnim(String string, String string2) {
        this.reportEvent(string);
        if (string2 != null) {
            this.setVariable("TimedActionType", string2);
        }
        this.resetModelNextFrame();
    }

    @Override
    public void StopTimedActionAnim() {
        this.clearVariable("TimedActionType");
        this.reportEvent("Event_TA_Exit");
        this.resetModelNextFrame();
    }

    public boolean hasHitReaction() {
        return !StringUtils.isNullOrEmpty(this.getHitReaction());
    }

    public String getHitReaction() {
        return this.hitReaction;
    }

    public void setHitReaction(String string) {
        this.hitReaction = string;
    }

    public void CacheEquipped() {
        this.cacheEquiped[0] = this.getPrimaryHandItem();
        this.cacheEquiped[1] = this.getSecondaryHandItem();
    }

    public InventoryItem GetPrimaryEquippedCache() {
        return this.cacheEquiped[0] != null && this.inventory.contains(this.cacheEquiped[0]) ? this.cacheEquiped[0] : null;
    }

    public InventoryItem GetSecondaryEquippedCache() {
        return this.cacheEquiped[1] != null && this.inventory.contains(this.cacheEquiped[1]) ? this.cacheEquiped[1] : null;
    }

    public void ClearEquippedCache() {
        this.cacheEquiped[0] = null;
        this.cacheEquiped[1] = null;
    }

    public boolean isBehind(IsoGameCharacter isoGameCharacter) {
        Vector2 vector22 = tempVector2_1.set(this.getX(), this.getY());
        Vector2 vector23 = tempVector2_2.set(isoGameCharacter.getX(), isoGameCharacter.getY());
        vector23.x -= vector22.x;
        vector23.y -= vector22.y;
        Vector2 vector24 = isoGameCharacter.getForwardDirection();
        vector23.normalize();
        vector24.normalize();
        float f = vector23.dot(vector24);
        return (double)f > 0.6;
    }

    public void resetEquippedHandsModels() {
        if (GameServer.bServer && !ServerGUI.isCreated()) {
            return;
        }
        if (!this.hasActiveModel()) {
            return;
        }
        ModelManager.instance.ResetEquippedNextFrame(this);
    }

    @Override
    public AnimatorDebugMonitor getDebugMonitor() {
        return this.advancedAnimator.getDebugMonitor();
    }

    @Override
    public void setDebugMonitor(AnimatorDebugMonitor animatorDebugMonitor) {
        this.advancedAnimator.setDebugMonitor(animatorDebugMonitor);
    }

    public boolean isAimAtFloor() {
        return this.bAimAtFloor;
    }

    public void setAimAtFloor(boolean bl) {
        this.bAimAtFloor = bl;
    }

    public String testDotSide(IsoMovingObject isoMovingObject) {
        Vector2 vector22 = this.getLookVector(l_testDotSide.v1);
        Vector2 vector23 = l_testDotSide.v2.set(this.getX(), this.getY());
        Vector2 vector24 = l_testDotSide.v3.set(isoMovingObject.x - vector23.x, isoMovingObject.y - vector23.y);
        vector24.normalize();
        float f = Vector2.dot(vector24.x, vector24.y, vector22.x, vector22.y);
        if ((double)f > 0.7) {
            return "FRONT";
        }
        if (f < 0.0f && (double)f < -0.5) {
            return "BEHIND";
        }
        float f2 = isoMovingObject.x;
        float f3 = vector23.x;
        float f4 = vector23.y + vector22.y;
        float f5 = vector23.y;
        float f6 = isoMovingObject.y;
        float f7 = vector23.x + vector22.x;
        float f8 = (f2 - f3) * (f4 - f5) - (f6 - f5) * (f7 - f3);
        if (f8 > 0.0f) {
            return "RIGHT";
        }
        return "LEFT";
    }

    public void addBasicPatch(BloodBodyPartType bloodBodyPartType) {
        if (!(this instanceof IHumanVisual)) {
            return;
        }
        if (bloodBodyPartType == null) {
            bloodBodyPartType = BloodBodyPartType.FromIndex(Rand.Next(0, BloodBodyPartType.MAX.index()));
        }
        HumanVisual humanVisual = ((IHumanVisual)((Object)this)).getHumanVisual();
        this.getItemVisuals(tempItemVisuals);
        BloodClothingType.addBasicPatch(bloodBodyPartType, humanVisual, tempItemVisuals);
        this.bUpdateModelTextures = true;
        this.bUpdateEquippedTextures = true;
        if (!GameServer.bServer && this instanceof IsoPlayer && ((IsoPlayer)this).isLocalPlayer()) {
            LuaEventManager.triggerEvent("OnClothingUpdated", this);
        }
    }

    @Override
    public boolean addHole(BloodBodyPartType bloodBodyPartType) {
        return this.addHole(bloodBodyPartType, false);
    }

    public boolean addHole(BloodBodyPartType bloodBodyPartType, boolean bl) {
        if (!(this instanceof IHumanVisual)) {
            return false;
        }
        if (bloodBodyPartType == null) {
            bloodBodyPartType = BloodBodyPartType.FromIndex(OutfitRNG.Next(0, BloodBodyPartType.MAX.index()));
        }
        HumanVisual humanVisual = ((IHumanVisual)((Object)this)).getHumanVisual();
        this.getItemVisuals(tempItemVisuals);
        boolean bl2 = BloodClothingType.addHole(bloodBodyPartType, humanVisual, tempItemVisuals, bl);
        this.bUpdateModelTextures = true;
        if (!GameServer.bServer && this instanceof IsoPlayer && ((IsoPlayer)this).isLocalPlayer()) {
            LuaEventManager.triggerEvent("OnClothingUpdated", this);
            if (GameClient.bClient) {
                GameClient.instance.sendClothing((IsoPlayer)this, "", null);
            }
        }
        return bl2;
    }

    public void addDirt(BloodBodyPartType bloodBodyPartType, Integer n, boolean bl) {
        HumanVisual humanVisual = ((IHumanVisual)((Object)this)).getHumanVisual();
        if (n == null) {
            n = OutfitRNG.Next(5, 10);
        }
        boolean bl2 = false;
        if (bloodBodyPartType == null) {
            bl2 = true;
        }
        this.getItemVisuals(tempItemVisuals);
        for (int i = 0; i < n; ++i) {
            if (bl2) {
                bloodBodyPartType = BloodBodyPartType.FromIndex(OutfitRNG.Next(0, BloodBodyPartType.MAX.index()));
            }
            BloodClothingType.addDirt(bloodBodyPartType, humanVisual, tempItemVisuals, bl);
        }
        this.bUpdateModelTextures = true;
        if (!GameServer.bServer && this instanceof IsoPlayer && ((IsoPlayer)this).isLocalPlayer()) {
            LuaEventManager.triggerEvent("OnClothingUpdated", this);
        }
    }

    @Override
    public void addBlood(BloodBodyPartType bloodBodyPartType, boolean bl, boolean bl2, boolean bl3) {
        HumanVisual humanVisual = ((IHumanVisual)((Object)this)).getHumanVisual();
        int n = 1;
        boolean bl4 = false;
        if (bloodBodyPartType == null) {
            bl4 = true;
        }
        if (this.getPrimaryHandItem() instanceof HandWeapon) {
            n = ((HandWeapon)this.getPrimaryHandItem()).getSplatNumber();
            if (OutfitRNG.Next(15) < this.getWeaponLevel()) {
                --n;
            }
        }
        if (bl2) {
            n = 20;
        }
        if (bl) {
            n = 5;
        }
        if (this.isZombie()) {
            n += 8;
        }
        this.getItemVisuals(tempItemVisuals);
        for (int i = 0; i < n; ++i) {
            if (bl4) {
                HandWeapon handWeapon;
                bloodBodyPartType = BloodBodyPartType.FromIndex(OutfitRNG.Next(0, BloodBodyPartType.MAX.index()));
                if (this.getPrimaryHandItem() != null && this.getPrimaryHandItem() instanceof HandWeapon && (handWeapon = (HandWeapon)this.getPrimaryHandItem()).getBloodLevel() < 1.0f) {
                    float f = handWeapon.getBloodLevel() + 0.02f;
                    handWeapon.setBloodLevel(f);
                    this.bUpdateEquippedTextures = true;
                }
            }
            BloodClothingType.addBlood(bloodBodyPartType, humanVisual, (ArrayList<ItemVisual>)tempItemVisuals, bl3);
        }
        this.bUpdateModelTextures = true;
        if (!GameServer.bServer && this instanceof IsoPlayer && ((IsoPlayer)this).isLocalPlayer()) {
            LuaEventManager.triggerEvent("OnClothingUpdated", this);
        }
    }

    public float getBodyPartClothingDefense(Integer n, boolean bl, boolean bl2) {
        float f = 0.0f;
        this.getItemVisuals(tempItemVisuals);
        block0: for (int i = tempItemVisuals.size() - 1; i >= 0; --i) {
            InventoryItem inventoryItem;
            ArrayList<BloodBodyPartType> arrayList;
            ArrayList<BloodClothingType> arrayList2;
            ItemVisual itemVisual = (ItemVisual)tempItemVisuals.get(i);
            Item item = itemVisual.getScriptItem();
            if (item == null || (arrayList2 = item.getBloodClothingType()) == null || (arrayList = BloodClothingType.getCoveredParts(arrayList2)) == null || (inventoryItem = itemVisual.getInventoryItem()) == null && (inventoryItem = InventoryItemFactory.CreateItem(itemVisual.getItemType())) == null) continue;
            for (int j = 0; j < arrayList.size(); ++j) {
                if (!(inventoryItem instanceof Clothing) || arrayList.get(j).index() != n.intValue() || itemVisual.getHole(arrayList.get(j)) != 0.0f) continue;
                Clothing clothing = (Clothing)inventoryItem;
                f += clothing.getDefForPart(arrayList.get(j), bl, bl2);
                continue block0;
            }
        }
        f = Math.min(100.0f, f);
        return f;
    }

    @Override
    public boolean isBumped() {
        return !StringUtils.isNullOrWhitespace(this.getBumpType());
    }

    public boolean isBumpDone() {
        return this.m_isBumpDone;
    }

    public void setBumpDone(boolean bl) {
        this.m_isBumpDone = bl;
    }

    public boolean isBumpFall() {
        return this.m_bumpFall;
    }

    public void setBumpFall(boolean bl) {
        this.m_bumpFall = bl;
    }

    public boolean isBumpStaggered() {
        return this.m_bumpStaggered;
    }

    public void setBumpStaggered(boolean bl) {
        this.m_bumpStaggered = bl;
    }

    @Override
    public String getBumpType() {
        return this.bumpType;
    }

    public void setBumpType(String string) {
        if (StringUtils.equalsIgnoreCase(this.bumpType, string)) {
            this.bumpType = string;
            return;
        }
        boolean bl = this.isBumped();
        this.bumpType = string;
        boolean bl2 = this.isBumped();
        if (bl2 != bl) {
            this.setBumpStaggered(bl2);
        }
    }

    public String getBumpFallType() {
        return this.m_bumpFallType;
    }

    public void setBumpFallType(String string) {
        this.m_bumpFallType = string;
    }

    public IsoGameCharacter getBumpedChr() {
        return this.bumpedChr;
    }

    public void setBumpedChr(IsoGameCharacter isoGameCharacter) {
        this.bumpedChr = isoGameCharacter;
    }

    public long getLastBump() {
        return this.lastBump;
    }

    public void setLastBump(long l) {
        this.lastBump = l;
    }

    public boolean isSitOnGround() {
        return this.sitOnGround;
    }

    public void setSitOnGround(boolean bl) {
        this.sitOnGround = bl;
    }

    @Override
    public String getUID() {
        return this.m_UID;
    }

    protected HashMap<String, State> getStateUpdateLookup() {
        return this.m_stateUpdateLookup;
    }

    public boolean isRunning() {
        if (this.getMoodles() != null && this.getMoodles().getMoodleLevel(MoodleType.Endurance) >= 3) {
            return false;
        }
        return this.bRunning;
    }

    public void setRunning(boolean bl) {
        this.bRunning = bl;
    }

    public boolean isSprinting() {
        if (this.bSprinting && !this.canSprint()) {
            return false;
        }
        return this.bSprinting;
    }

    public void setSprinting(boolean bl) {
        this.bSprinting = bl;
    }

    public boolean canSprint() {
        if (this instanceof IsoPlayer && !((IsoPlayer)this).isAllowSprint()) {
            return false;
        }
        if ("Tutorial".equals(Core.GameMode)) {
            return true;
        }
        InventoryItem inventoryItem = this.getPrimaryHandItem();
        if (inventoryItem != null && inventoryItem.isEquippedNoSprint()) {
            return false;
        }
        inventoryItem = this.getSecondaryHandItem();
        if (inventoryItem != null && inventoryItem.isEquippedNoSprint()) {
            return false;
        }
        return this.getMoodles() == null || this.getMoodles().getMoodleLevel(MoodleType.Endurance) < 2;
    }

    public void postUpdateModelTextures() {
        this.bUpdateModelTextures = true;
    }

    public ModelInstanceTextureCreator getTextureCreator() {
        return this.textureCreator;
    }

    public void setTextureCreator(ModelInstanceTextureCreator modelInstanceTextureCreator) {
        this.textureCreator = modelInstanceTextureCreator;
    }

    public void postUpdateEquippedTextures() {
        this.bUpdateEquippedTextures = true;
    }

    public ArrayList<ModelInstance> getReadyModelData() {
        return this.readyModelData;
    }

    public boolean getIgnoreMovement() {
        return this.ignoreMovement;
    }

    public void setIgnoreMovement(boolean bl) {
        if (this instanceof IsoPlayer && bl) {
            ((IsoPlayer)this).networkAI.needToUpdate();
        }
        this.ignoreMovement = bl;
    }

    public boolean isAutoWalk() {
        return this.bAutoWalk;
    }

    public void setAutoWalk(boolean bl) {
        this.bAutoWalk = bl;
    }

    public void setAutoWalkDirection(Vector2 vector22) {
        this.autoWalkDirection.set(vector22);
    }

    public Vector2 getAutoWalkDirection() {
        return this.autoWalkDirection;
    }

    public boolean isSneaking() {
        if (this.getVariableFloat("WalkInjury", 0.0f) > 0.5f) {
            return false;
        }
        return this.bSneaking;
    }

    public void setSneaking(boolean bl) {
        this.bSneaking = bl;
    }

    public GameCharacterAIBrain getGameCharacterAIBrain() {
        return this.GameCharacterAIBrain;
    }

    public float getMoveDelta() {
        return this.m_moveDelta;
    }

    public void setMoveDelta(float f) {
        this.m_moveDelta = f;
    }

    public float getTurnDelta() {
        if (this.isSprinting()) {
            return this.m_turnDeltaSprinting;
        }
        if (this.isRunning()) {
            return this.m_turnDeltaRunning;
        }
        return this.m_turnDeltaNormal;
    }

    public void setTurnDelta(float f) {
        this.m_turnDeltaNormal = f;
    }

    public float getChopTreeSpeed() {
        return (this.Traits.Axeman.isSet() ? 1.25f : 1.0f) * GameTime.getAnimSpeedFix();
    }

    public boolean testDefense(IsoZombie isoZombie) {
        if (!this.testDotSide(isoZombie).equals("FRONT") || isoZombie.bCrawling || this.getSurroundingAttackingZombies() > 3) {
            return false;
        }
        int n = 0;
        if ("KnifeDeath".equals(this.getVariableString("ZombieHitReaction"))) {
            n += 30;
        }
        n += this.getWeaponLevel() * 3;
        n += this.getPerkLevel(PerkFactory.Perks.Fitness) * 2;
        n += this.getPerkLevel(PerkFactory.Perks.Strength) * 2;
        n -= this.getSurroundingAttackingZombies() * 5;
        n -= this.getMoodles().getMoodleLevel(MoodleType.Endurance) * 2;
        n -= this.getMoodles().getMoodleLevel(MoodleType.HeavyLoad) * 2;
        n -= this.getMoodles().getMoodleLevel(MoodleType.Tired) * 3;
        if (SandboxOptions.instance.Lore.Strength.getValue() == 1) {
            n -= 7;
        }
        if (SandboxOptions.instance.Lore.Strength.getValue() == 3) {
            n += 7;
        }
        if (Rand.Next(100) < n) {
            this.setAttackedBy(isoZombie);
            this.setHitReaction(isoZombie.getVariableString("PlayerHitReaction") + "Defended");
            return true;
        }
        return false;
    }

    public int getSurroundingAttackingZombies() {
        movingStatic.clear();
        IsoGridSquare isoGridSquare = this.getCurrentSquare();
        if (isoGridSquare == null) {
            return 0;
        }
        movingStatic.addAll(isoGridSquare.getMovingObjects());
        if (isoGridSquare.n != null) {
            movingStatic.addAll(isoGridSquare.n.getMovingObjects());
        }
        if (isoGridSquare.s != null) {
            movingStatic.addAll(isoGridSquare.s.getMovingObjects());
        }
        if (isoGridSquare.e != null) {
            movingStatic.addAll(isoGridSquare.e.getMovingObjects());
        }
        if (isoGridSquare.w != null) {
            movingStatic.addAll(isoGridSquare.w.getMovingObjects());
        }
        if (isoGridSquare.nw != null) {
            movingStatic.addAll(isoGridSquare.nw.getMovingObjects());
        }
        if (isoGridSquare.sw != null) {
            movingStatic.addAll(isoGridSquare.sw.getMovingObjects());
        }
        if (isoGridSquare.se != null) {
            movingStatic.addAll(isoGridSquare.se.getMovingObjects());
        }
        if (isoGridSquare.ne != null) {
            movingStatic.addAll(isoGridSquare.ne.getMovingObjects());
        }
        int n = 0;
        for (int i = 0; i < movingStatic.size(); ++i) {
            IsoZombie isoZombie = Type.tryCastTo(movingStatic.get(i), IsoZombie.class);
            if (isoZombie == null || isoZombie.target != this || this.DistToSquared(isoZombie) >= 0.80999994f || !isoZombie.isCurrentState(AttackState.instance()) && !isoZombie.isCurrentState(AttackNetworkState.instance()) && !isoZombie.isCurrentState(LungeState.instance()) && !isoZombie.isCurrentState(LungeNetworkState.instance())) continue;
            ++n;
        }
        return n;
    }

    public float checkIsNearWall() {
        if (!this.bSneaking || this.getCurrentSquare() == null) {
            this.setVariable("nearWallCrouching", false);
            return 0.0f;
        }
        IsoGridSquare isoGridSquare = this.getCurrentSquare().nav[IsoDirections.N.index()];
        IsoGridSquare isoGridSquare2 = this.getCurrentSquare().nav[IsoDirections.S.index()];
        IsoGridSquare isoGridSquare3 = this.getCurrentSquare().nav[IsoDirections.E.index()];
        IsoGridSquare isoGridSquare4 = this.getCurrentSquare().nav[IsoDirections.W.index()];
        float f = 0.0f;
        float f2 = 0.0f;
        if (isoGridSquare != null && (f = isoGridSquare.getGridSneakModifier(true)) > 1.0f) {
            this.setVariable("nearWallCrouching", true);
            return f;
        }
        if (isoGridSquare2 != null) {
            f = isoGridSquare2.getGridSneakModifier(false);
            f2 = isoGridSquare2.getGridSneakModifier(true);
            if (f > 1.0f || f2 > 1.0f) {
                this.setVariable("nearWallCrouching", true);
                return f > 1.0f ? f : f2;
            }
        }
        if (isoGridSquare3 != null) {
            f = isoGridSquare3.getGridSneakModifier(false);
            f2 = isoGridSquare3.getGridSneakModifier(true);
            if (f > 1.0f || f2 > 1.0f) {
                this.setVariable("nearWallCrouching", true);
                return f > 1.0f ? f : f2;
            }
        }
        if (isoGridSquare4 != null) {
            f = isoGridSquare4.getGridSneakModifier(false);
            f2 = isoGridSquare4.getGridSneakModifier(true);
            if (f > 1.0f || f2 > 1.0f) {
                this.setVariable("nearWallCrouching", true);
                return f > 1.0f ? f : f2;
            }
        }
        if ((f = this.getCurrentSquare().getGridSneakModifier(false)) > 1.0f) {
            this.setVariable("nearWallCrouching", true);
            return f;
        }
        if (this instanceof IsoPlayer && ((IsoPlayer)this).isNearVehicle().booleanValue()) {
            this.setVariable("nearWallCrouching", true);
            return 6.0f;
        }
        this.setVariable("nearWallCrouching", false);
        return 0.0f;
    }

    public float getBeenSprintingFor() {
        return this.BeenSprintingFor;
    }

    public void setBeenSprintingFor(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 100.0f) {
            f = 100.0f;
        }
        this.BeenSprintingFor = f;
    }

    public boolean isHideWeaponModel() {
        return this.hideWeaponModel;
    }

    public void setHideWeaponModel(boolean bl) {
        if (this.hideWeaponModel != bl) {
            this.hideWeaponModel = bl;
            this.resetEquippedHandsModels();
        }
    }

    public void setIsAiming(boolean bl) {
        if (this.ignoreAimingInput) {
            bl = false;
        }
        if (this instanceof IsoPlayer && !((IsoPlayer)this).isAttackAnimThrowTimeOut() || this.isAttackAnim() || this.getVariableBoolean("ShoveAnim")) {
            bl = true;
        }
        this.isAiming = bl;
    }

    @Override
    public boolean isAiming() {
        if (GameClient.bClient && this instanceof IsoPlayer && ((IsoPlayer)this).isLocalPlayer() && DebugOptions.instance.MultiplayerAttackPlayer.getValue()) {
            return false;
        }
        if (this.isNPC) {
            return this.NPCGetAiming();
        }
        return this.isAiming;
    }

    @Override
    public void resetBeardGrowingTime() {
        this.beardGrowTiming = (float)this.getHoursSurvived();
        if (GameClient.bClient && this instanceof IsoPlayer) {
            GameClient.instance.sendVisual((IsoPlayer)this);
        }
    }

    @Override
    public void resetHairGrowingTime() {
        this.hairGrowTiming = (float)this.getHoursSurvived();
        if (GameClient.bClient && this instanceof IsoPlayer) {
            GameClient.instance.sendVisual((IsoPlayer)this);
        }
    }

    public void fallenOnKnees() {
        if (this instanceof IsoPlayer && !((IsoPlayer)this).isLocalPlayer()) {
            return;
        }
        if (this.isInvincible()) {
            return;
        }
        this.helmetFall(false);
        BloodBodyPartType bloodBodyPartType = BloodBodyPartType.FromIndex(Rand.Next(BloodBodyPartType.Hand_L.index(), BloodBodyPartType.Torso_Upper.index()));
        if (Rand.NextBool(2)) {
            bloodBodyPartType = BloodBodyPartType.FromIndex(Rand.Next(BloodBodyPartType.UpperLeg_L.index(), BloodBodyPartType.Back.index()));
        }
        for (int i = 0; i < 4; ++i) {
            BloodBodyPartType bloodBodyPartType2 = BloodBodyPartType.FromIndex(Rand.Next(BloodBodyPartType.Hand_L.index(), BloodBodyPartType.Torso_Upper.index()));
            if (Rand.NextBool(2)) {
                bloodBodyPartType2 = BloodBodyPartType.FromIndex(Rand.Next(BloodBodyPartType.UpperLeg_L.index(), BloodBodyPartType.Back.index()));
            }
            this.addDirt(bloodBodyPartType2, Rand.Next(2, 6), false);
        }
        if (!Rand.NextBool(2)) {
            return;
        }
        if (Rand.NextBool(4)) {
            this.dropHandItems();
        }
        this.addHole(bloodBodyPartType);
        this.addBlood(bloodBodyPartType, true, false, false);
        BodyPart bodyPart = this.getBodyDamage().getBodyPart(BodyPartType.FromIndex(bloodBodyPartType.index()));
        if (bodyPart.scratched()) {
            bodyPart.generateDeepWound();
        } else {
            bodyPart.setScratched(true, true);
        }
    }

    public void addVisualDamage(String string) {
        this.addBodyVisualFromItemType("Base." + string);
    }

    protected ItemVisual addBodyVisualFromItemType(String string) {
        Item item = ScriptManager.instance.getItem(string);
        if (item == null || StringUtils.isNullOrWhitespace(item.getClothingItem())) {
            return null;
        }
        return this.addBodyVisualFromClothingItemName(item.getClothingItem());
    }

    protected ItemVisual addBodyVisualFromClothingItemName(String string) {
        IHumanVisual iHumanVisual = Type.tryCastTo(this, IHumanVisual.class);
        if (iHumanVisual == null) {
            return null;
        }
        String string2 = ScriptManager.instance.getItemTypeForClothingItem(string);
        if (string2 == null) {
            return null;
        }
        Item item = ScriptManager.instance.getItem(string2);
        if (item == null) {
            return null;
        }
        ClothingItem clothingItem = item.getClothingItemAsset();
        if (clothingItem == null) {
            return null;
        }
        ClothingItemReference clothingItemReference = new ClothingItemReference();
        clothingItemReference.itemGUID = clothingItem.m_GUID;
        clothingItemReference.randomize();
        ItemVisual itemVisual = new ItemVisual();
        itemVisual.setItemType(string2);
        itemVisual.synchWithOutfit(clothingItemReference);
        if (!this.isDuplicateBodyVisual(itemVisual)) {
            ItemVisuals itemVisuals = iHumanVisual.getHumanVisual().getBodyVisuals();
            itemVisuals.add(itemVisual);
            return itemVisual;
        }
        return null;
    }

    protected boolean isDuplicateBodyVisual(ItemVisual itemVisual) {
        IHumanVisual iHumanVisual = Type.tryCastTo(this, IHumanVisual.class);
        if (iHumanVisual == null) {
            return false;
        }
        ItemVisuals itemVisuals = iHumanVisual.getHumanVisual().getBodyVisuals();
        for (int i = 0; i < itemVisuals.size(); ++i) {
            ItemVisual itemVisual2 = (ItemVisual)itemVisuals.get(i);
            if (!itemVisual.getClothingItemName().equals(itemVisual2.getClothingItemName()) || itemVisual.getTextureChoice() != itemVisual2.getTextureChoice() || itemVisual.getBaseTexture() != itemVisual2.getBaseTexture()) continue;
            return true;
        }
        return false;
    }

    public boolean isCriticalHit() {
        return this.isCrit;
    }

    public void setCriticalHit(boolean bl) {
        this.isCrit = bl;
    }

    public float getRunSpeedModifier() {
        return this.runSpeedModifier;
    }

    public void startMuzzleFlash() {
        float f = GameTime.getInstance().getNight() * 0.8f;
        f = Math.max(f, 0.2f);
        IsoLightSource isoLightSource = new IsoLightSource((int)this.getX(), (int)this.getY(), (int)this.getZ(), 0.8f * f, 0.8f * f, 0.6f * f, 18, 6);
        IsoWorld.instance.CurrentCell.getLamppostPositions().add(isoLightSource);
        this.m_muzzleFlash = System.currentTimeMillis();
    }

    public boolean isMuzzleFlash() {
        if (Core.bDebug && DebugOptions.instance.ModelRenderMuzzleflash.getValue()) {
            return true;
        }
        return this.m_muzzleFlash > System.currentTimeMillis() - 50L;
    }

    public boolean isNPC() {
        return this.isNPC;
    }

    public void setNPC(boolean bl) {
        if (bl && this.GameCharacterAIBrain == null) {
            this.GameCharacterAIBrain = new GameCharacterAIBrain(this);
        }
        this.isNPC = bl;
    }

    public void NPCSetRunning(boolean bl) {
        this.GameCharacterAIBrain.HumanControlVars.bRunning = bl;
    }

    public boolean NPCGetRunning() {
        return this.GameCharacterAIBrain.HumanControlVars.bRunning;
    }

    public void NPCSetJustMoved(boolean bl) {
        this.GameCharacterAIBrain.HumanControlVars.JustMoved = bl;
    }

    public void NPCSetAiming(boolean bl) {
        this.GameCharacterAIBrain.HumanControlVars.bAiming = bl;
    }

    public boolean NPCGetAiming() {
        return this.GameCharacterAIBrain.HumanControlVars.bAiming;
    }

    public void NPCSetAttack(boolean bl) {
        this.GameCharacterAIBrain.HumanControlVars.initiateAttack = bl;
    }

    public void NPCSetMelee(boolean bl) {
        this.GameCharacterAIBrain.HumanControlVars.bMelee = bl;
    }

    public void setMetabolicTarget(Metabolics metabolics) {
        if (metabolics != null) {
            this.setMetabolicTarget(metabolics.getMet());
        }
    }

    public void setMetabolicTarget(float f) {
        if (this.getBodyDamage() != null && this.getBodyDamage().getThermoregulator() != null) {
            this.getBodyDamage().getThermoregulator().setMetabolicTarget(f);
        }
    }

    public double getThirstMultiplier() {
        if (this.getBodyDamage() != null && this.getBodyDamage().getThermoregulator() != null) {
            return this.getBodyDamage().getThermoregulator().getFluidsMultiplier();
        }
        return 1.0;
    }

    public double getHungerMultiplier() {
        return 1.0;
    }

    public double getFatiqueMultiplier() {
        if (this.getBodyDamage() != null && this.getBodyDamage().getThermoregulator() != null) {
            return this.getBodyDamage().getThermoregulator().getFatigueMultiplier();
        }
        return 1.0;
    }

    public float getTimedActionTimeModifier() {
        return 1.0f;
    }

    public boolean addHoleFromZombieAttacks(BloodBodyPartType bloodBodyPartType, boolean bl) {
        Object object;
        Object object2;
        this.getItemVisuals(tempItemVisuals);
        ItemVisual itemVisual = null;
        for (int i = tempItemVisuals.size() - 1; i >= 0; --i) {
            ItemVisual itemVisual2 = (ItemVisual)tempItemVisuals.get(i);
            object2 = itemVisual2.getScriptItem();
            if (object2 == null || (object = ((Item)object2).getBloodClothingType()) == null) continue;
            ArrayList<BloodBodyPartType> arrayList = BloodClothingType.getCoveredParts(object);
            for (int j = 0; j < arrayList.size(); ++j) {
                BloodBodyPartType bloodBodyPartType2 = arrayList.get(j);
                if (bloodBodyPartType != bloodBodyPartType2) continue;
                itemVisual = itemVisual2;
                break;
            }
            if (itemVisual != null) break;
        }
        float f = 0.0f;
        boolean bl2 = false;
        if (itemVisual != null && itemVisual.getInventoryItem() != null && itemVisual.getInventoryItem() instanceof Clothing) {
            object2 = (Clothing)itemVisual.getInventoryItem();
            object = ((Clothing)object2).getPatchType(bloodBodyPartType);
            f = Math.max(30.0f, 100.0f - ((Clothing)object2).getDefForPart(bloodBodyPartType, !bl, false) / 1.5f);
        }
        if ((float)Rand.Next(100) < f) {
            boolean bl3 = this.addHole(bloodBodyPartType);
            if (bl3) {
                this.getEmitter().playSoundImpl("ZombieRipClothing", null);
            }
            bl2 = true;
        }
        return bl2;
    }

    protected void updateBandages() {
        s_bandages.update(this);
    }

    public float getTotalBlood() {
        float f = 0.0f;
        if (this.getWornItems() == null) {
            return f;
        }
        for (int i = 0; i < this.getWornItems().size(); ++i) {
            InventoryItem inventoryItem = this.getWornItems().get(i).getItem();
            if (!(inventoryItem instanceof Clothing)) continue;
            f += ((Clothing)inventoryItem).getBloodlevel();
        }
        return f += ((HumanVisual)this.getVisual()).getTotalBlood();
    }

    public void attackFromWindowsLunge(IsoZombie isoZombie) {
        if (this.lungeFallTimer > 0.0f || (int)this.getZ() != (int)isoZombie.getZ() || isoZombie.isDead() || this.getCurrentSquare() == null || this.getCurrentSquare().isDoorBlockedTo(isoZombie.getCurrentSquare()) || this.getCurrentSquare().isWallTo(isoZombie.getCurrentSquare()) || this.getCurrentSquare().isWindowTo(isoZombie.getCurrentSquare())) {
            return;
        }
        if (this.getVehicle() != null) {
            return;
        }
        boolean bl = this.DoSwingCollisionBoneCheck(isoZombie, isoZombie.getAnimationPlayer().getSkinningBoneIndex("Bip01_R_Hand", -1), 1.0f);
        if (!bl) {
            return;
        }
        isoZombie.playSound("ZombieCrawlLungeHit");
        this.lungeFallTimer = 200.0f;
        this.setIsAiming(false);
        boolean bl2 = false;
        int n = 30;
        n += this.getMoodles().getMoodleLevel(MoodleType.Endurance) * 3;
        n += this.getMoodles().getMoodleLevel(MoodleType.HeavyLoad) * 5;
        n -= this.getPerkLevel(PerkFactory.Perks.Fitness) * 2;
        BodyPart bodyPart = this.getBodyDamage().getBodyPart(BodyPartType.Torso_Lower);
        if (bodyPart.getAdditionalPain(true) > 20.0f) {
            n = (int)((float)n + (bodyPart.getAdditionalPain(true) - 20.0f) / 10.0f);
        }
        if (this.Traits.Clumsy.isSet()) {
            n += 10;
        }
        if (this.Traits.Graceful.isSet()) {
            n -= 10;
        }
        if (this.Traits.VeryUnderweight.isSet()) {
            n += 20;
        }
        if (this.Traits.Underweight.isSet()) {
            n += 10;
        }
        if (this.Traits.Obese.isSet()) {
            n -= 10;
        }
        if (this.Traits.Overweight.isSet()) {
            n -= 5;
        }
        n = Math.max(5, n);
        this.clearVariable("BumpFallType");
        this.setBumpType("stagger");
        if (Rand.Next(100) < n) {
            bl2 = true;
        }
        this.setBumpDone(false);
        this.setBumpFall(bl2);
        if (isoZombie.isBehind(this)) {
            this.setBumpFallType("pushedBehind");
        } else {
            this.setBumpFallType("pushedFront");
        }
        this.actionContext.reportEvent("wasBumped");
    }

    public boolean DoSwingCollisionBoneCheck(IsoGameCharacter isoGameCharacter, int n, float f) {
        Model.BoneToWorldCoords(isoGameCharacter, n, tempVectorBonePos);
        float f2 = IsoUtils.DistanceToSquared(IsoGameCharacter.tempVectorBonePos.x, IsoGameCharacter.tempVectorBonePos.y, this.x, this.y);
        return f2 < f * f;
    }

    public boolean isInvincible() {
        return this.invincible;
    }

    public void setInvincible(boolean bl) {
        this.invincible = bl;
    }

    public BaseVehicle getNearVehicle() {
        if (this.getVehicle() != null) {
            return null;
        }
        int n = ((int)this.x - 4) / 10 - 1;
        int n2 = ((int)this.y - 4) / 10 - 1;
        int n3 = (int)Math.ceil((this.x + 4.0f) / 10.0f) + 1;
        int n4 = (int)Math.ceil((this.y + 4.0f) / 10.0f) + 1;
        for (int i = n2; i < n4; ++i) {
            for (int j = n; j < n3; ++j) {
                IsoChunk isoChunk;
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(j, i) : IsoWorld.instance.CurrentCell.getChunk(j, i);
                if (isoChunk == null) continue;
                for (int k = 0; k < isoChunk.vehicles.size(); ++k) {
                    BaseVehicle baseVehicle = isoChunk.vehicles.get(k);
                    if (baseVehicle.getScript() == null || (int)this.getZ() != (int)baseVehicle.getZ() || this instanceof IsoPlayer && ((IsoPlayer)this).isLocalPlayer() && baseVehicle.getTargetAlpha(((IsoPlayer)this).PlayerIndex) == 0.0f || this.DistToSquared((int)baseVehicle.x, (int)baseVehicle.y) >= 16.0f) continue;
                    return baseVehicle;
                }
            }
        }
        return null;
    }

    private IsoGridSquare getSolidFloorAt(int n, int n2, int n3) {
        while (n3 >= 0) {
            IsoGridSquare isoGridSquare = this.getCell().getGridSquare(n, n2, n3);
            if (isoGridSquare != null && isoGridSquare.TreatAsSolidFloor()) {
                return isoGridSquare;
            }
            --n3;
        }
        return null;
    }

    public void dropHeavyItems() {
        float f;
        float f2;
        float f3;
        boolean bl;
        IsoGridSquare isoGridSquare = this.getCurrentSquare();
        if (isoGridSquare == null) {
            return;
        }
        InventoryItem inventoryItem = this.getPrimaryHandItem();
        InventoryItem inventoryItem2 = this.getSecondaryHandItem();
        if (inventoryItem == null && inventoryItem2 == null) {
            return;
        }
        isoGridSquare = this.getSolidFloorAt(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z);
        if (isoGridSquare == null) {
            return;
        }
        boolean bl2 = bl = inventoryItem == inventoryItem2;
        if (this.isHeavyItem(inventoryItem)) {
            f3 = Rand.Next(0.1f, 0.9f);
            f2 = Rand.Next(0.1f, 0.9f);
            f = isoGridSquare.getApparentZ(f3, f2) - (float)isoGridSquare.getZ();
            this.setPrimaryHandItem(null);
            this.getInventory().DoRemoveItem(inventoryItem);
            isoGridSquare.AddWorldInventoryItem(inventoryItem, f3, f2, f);
            LuaEventManager.triggerEvent("OnContainerUpdate");
            LuaEventManager.triggerEvent("onItemFall", inventoryItem);
        }
        if (this.isHeavyItem(inventoryItem2)) {
            this.setSecondaryHandItem(null);
            if (!bl) {
                f3 = Rand.Next(0.1f, 0.9f);
                f2 = Rand.Next(0.1f, 0.9f);
                f = isoGridSquare.getApparentZ(f3, f2) - (float)isoGridSquare.getZ();
                this.getInventory().DoRemoveItem(inventoryItem2);
                isoGridSquare.AddWorldInventoryItem(inventoryItem2, f3, f2, f);
                LuaEventManager.triggerEvent("OnContainerUpdate");
                LuaEventManager.triggerEvent("onItemFall", inventoryItem2);
            }
        }
    }

    public boolean isHeavyItem(InventoryItem inventoryItem) {
        if (inventoryItem == null) {
            return false;
        }
        if (inventoryItem instanceof InventoryContainer) {
            return true;
        }
        if (inventoryItem.hasTag("HeavyItem")) {
            return true;
        }
        if (inventoryItem.getType().equals("CorpseMale") || inventoryItem.getType().equals("CorpseFemale")) {
            return true;
        }
        return inventoryItem.getType().equals("Generator");
    }

    public boolean isCanShout() {
        return this.canShout;
    }

    public void setCanShout(boolean bl) {
        this.canShout = bl;
    }

    public boolean isUnlimitedEndurance() {
        return this.unlimitedEndurance;
    }

    public void setUnlimitedEndurance(boolean bl) {
        this.unlimitedEndurance = bl;
    }

    private void addActiveLightItem(InventoryItem inventoryItem, ArrayList<InventoryItem> arrayList) {
        if (inventoryItem != null && inventoryItem.isEmittingLight() && !arrayList.contains(inventoryItem)) {
            arrayList.add(inventoryItem);
        }
    }

    public ArrayList<InventoryItem> getActiveLightItems(ArrayList<InventoryItem> arrayList) {
        this.addActiveLightItem(this.getSecondaryHandItem(), arrayList);
        this.addActiveLightItem(this.getPrimaryHandItem(), arrayList);
        AttachedItems attachedItems = this.getAttachedItems();
        for (int i = 0; i < attachedItems.size(); ++i) {
            InventoryItem inventoryItem = attachedItems.getItemByIndex(i);
            this.addActiveLightItem(inventoryItem, arrayList);
        }
        return arrayList;
    }

    public SleepingEventData getOrCreateSleepingEventData() {
        if (this.m_sleepingEventData == null) {
            this.m_sleepingEventData = new SleepingEventData();
        }
        return this.m_sleepingEventData;
    }

    public void playEmote(String string) {
        this.setVariable("emote", string);
        this.actionContext.reportEvent("EventEmote");
    }

    public String getAnimationStateName() {
        return this.advancedAnimator.getCurrentStateName();
    }

    public String getActionStateName() {
        return this.actionContext.getCurrentStateName();
    }

    public boolean shouldWaitToStartTimedAction() {
        if (this.isSitOnGround()) {
            AdvancedAnimator advancedAnimator = this.getAdvancedAnimator();
            if (advancedAnimator.getRootLayer() == null) {
                return false;
            }
            if (advancedAnimator.animSet == null || !advancedAnimator.animSet.containsState("sitonground")) {
                return false;
            }
            AnimState animState = advancedAnimator.animSet.GetState("sitonground");
            if (!PZArrayUtil.contains(animState.m_Nodes, animNode -> "sit_action".equalsIgnoreCase(animNode.m_Name))) {
                return false;
            }
            LiveAnimNode liveAnimNode2 = PZArrayUtil.find(advancedAnimator.getRootLayer().getLiveAnimNodes(), liveAnimNode -> liveAnimNode.isActive() && "sit_action".equalsIgnoreCase(liveAnimNode.getName()));
            return liveAnimNode2 == null || !liveAnimNode2.isMainAnimActive();
        }
        return false;
    }

    public void setPersistentOutfitID(int n) {
        this.setPersistentOutfitID(n, false);
    }

    public void setPersistentOutfitID(int n, boolean bl) {
        this.m_persistentOutfitId = n;
        this.m_bPersistentOutfitInit = bl;
    }

    public int getPersistentOutfitID() {
        return this.m_persistentOutfitId;
    }

    public boolean isPersistentOutfitInit() {
        return this.m_bPersistentOutfitInit;
    }

    public boolean isDoingActionThatCanBeCancelled() {
        return false;
    }

    public boolean isDoDeathSound() {
        return this.doDeathSound;
    }

    public void setDoDeathSound(boolean bl) {
        this.doDeathSound = bl;
    }

    public void updateEquippedRadioFreq() {
        int n;
        this.invRadioFreq.clear();
        for (n = 0; n < this.getInventory().getItems().size(); ++n) {
            Radio radio;
            InventoryItem inventoryItem = this.getInventory().getItems().get(n);
            if (!(inventoryItem instanceof Radio) || (radio = (Radio)inventoryItem).getDeviceData() == null || !radio.getDeviceData().getIsTurnedOn() || radio.getDeviceData().getMicIsMuted() || this.invRadioFreq.contains(radio.getDeviceData().getChannel())) continue;
            this.invRadioFreq.add(radio.getDeviceData().getChannel());
        }
        for (n = 0; n < this.invRadioFreq.size(); ++n) {
            System.out.println(this.invRadioFreq.get(n));
        }
        if (this instanceof IsoPlayer && GameClient.bClient) {
            GameClient.sendEquippedRadioFreq((IsoPlayer)this);
        }
    }

    public FMODParameterList getFMODParameters() {
        return this.fmodParameters;
    }

    public void startEvent(long l, GameSoundClip gameSoundClip, BitSet bitSet) {
        FMODParameterList fMODParameterList = this.getFMODParameters();
        ArrayList arrayList = gameSoundClip.eventDescription.parameters;
        for (int i = 0; i < arrayList.size(); ++i) {
            FMODParameter fMODParameter;
            FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION = (FMOD_STUDIO_PARAMETER_DESCRIPTION)arrayList.get(i);
            if (bitSet.get(fMOD_STUDIO_PARAMETER_DESCRIPTION.globalIndex) || (fMODParameter = fMODParameterList.get(fMOD_STUDIO_PARAMETER_DESCRIPTION)) == null) continue;
            fMODParameter.startEventInstance(l);
        }
    }

    public void updateEvent(long l, GameSoundClip gameSoundClip) {
    }

    public void stopEvent(long l, GameSoundClip gameSoundClip, BitSet bitSet) {
        FMODParameterList fMODParameterList = this.getFMODParameters();
        ArrayList arrayList = gameSoundClip.eventDescription.parameters;
        for (int i = 0; i < arrayList.size(); ++i) {
            FMODParameter fMODParameter;
            FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION = (FMOD_STUDIO_PARAMETER_DESCRIPTION)arrayList.get(i);
            if (bitSet.get(fMOD_STUDIO_PARAMETER_DESCRIPTION.globalIndex) || (fMODParameter = fMODParameterList.get(fMOD_STUDIO_PARAMETER_DESCRIPTION)) == null) continue;
            fMODParameter.stopEventInstance(l);
        }
    }

    public void playBloodSplatterSound() {
        if (this.getEmitter().isPlaying("BloodSplatter")) {
            // empty if block
        }
        this.getEmitter().playSoundImpl("BloodSplatter", this);
    }

    public void setIgnoreAimingInput(boolean bl) {
        this.ignoreAimingInput = bl;
    }

    public void addBlood(float f) {
        if ((float)Rand.Next(10) > f) {
            return;
        }
        if (SandboxOptions.instance.BloodLevel.getValue() > 1) {
            int n = Rand.Next(4, 10);
            if (n < 1) {
                n = 1;
            }
            if (Core.bLastStand) {
                n *= 3;
            }
            switch (SandboxOptions.instance.BloodLevel.getValue()) {
                case 2: {
                    n /= 2;
                    break;
                }
                case 4: {
                    n *= 2;
                    break;
                }
                case 5: {
                    n *= 5;
                }
            }
            for (int i = 0; i < n; ++i) {
                this.splatBlood(2, 0.3f);
            }
        }
        if (SandboxOptions.instance.BloodLevel.getValue() > 1) {
            this.splatBloodFloorBig();
            this.playBloodSplatterSound();
        }
    }

    public boolean isKnockedDown() {
        return this.bKnockedDown;
    }

    public void setKnockedDown(boolean bl) {
        this.bKnockedDown = bl;
    }

    public void writeInventory(ByteBuffer byteBuffer) {
        String string = this.isFemale() ? "inventoryfemale" : "inventorymale";
        GameWindow.WriteString(byteBuffer, string);
        if (this.getInventory() != null) {
            byteBuffer.put((byte)1);
            try {
                Object object;
                int n;
                ArrayList<InventoryItem> arrayList = this.getInventory().save(byteBuffer);
                WornItems wornItems = this.getWornItems();
                if (wornItems == null) {
                    var4_6 = 0;
                    byteBuffer.put((byte)var4_6);
                } else {
                    var4_6 = wornItems.size();
                    if (var4_6 > 127) {
                        DebugLog.Multiplayer.warn("Too many worn items");
                        var4_6 = 127;
                    }
                    byteBuffer.put((byte)var4_6);
                    for (n = 0; n < var4_6; ++n) {
                        object = wornItems.get(n);
                        GameWindow.WriteString(byteBuffer, ((WornItem)object).getLocation());
                        byteBuffer.putShort((short)arrayList.indexOf(((WornItem)object).getItem()));
                    }
                }
                object = this.getAttachedItems();
                if (object == null) {
                    n = 0;
                    byteBuffer.put((byte)0);
                }
                n = ((AttachedItems)object).size();
                if (n > 127) {
                    DebugLog.Multiplayer.warn("Too many attached items");
                    n = 127;
                }
                byteBuffer.put((byte)n);
                for (int i = 0; i < n; ++i) {
                    AttachedItem attachedItem = ((AttachedItems)object).get(i);
                    GameWindow.WriteString(byteBuffer, attachedItem.getLocation());
                    byteBuffer.putShort((short)arrayList.indexOf(attachedItem.getItem()));
                }
            }
            catch (IOException iOException) {
                DebugLog.Multiplayer.printException(iOException, "WriteInventory error for character " + this.getOnlineID(), LogSeverity.Error);
            }
        } else {
            byteBuffer.put((byte)0);
        }
    }

    public String readInventory(ByteBuffer byteBuffer) {
        boolean bl;
        String string = GameWindow.ReadString(byteBuffer);
        boolean bl2 = bl = byteBuffer.get() == 1;
        if (bl) {
            try {
                int n;
                ArrayList<InventoryItem> arrayList = this.getInventory().load(byteBuffer, IsoWorld.getWorldVersion());
                int n2 = byteBuffer.get();
                for (n = 0; n < n2; ++n) {
                    String string2 = GameWindow.ReadStringUTF(byteBuffer);
                    short s = byteBuffer.getShort();
                    if (s < 0 || s >= arrayList.size() || this.getBodyLocationGroup().getLocation(string2) == null) continue;
                    this.getWornItems().setItem(string2, arrayList.get(s));
                }
                n = byteBuffer.get();
                for (int i = 0; i < n; ++i) {
                    String string3 = GameWindow.ReadStringUTF(byteBuffer);
                    short s = byteBuffer.getShort();
                    if (s < 0 || s >= arrayList.size() || this.getAttachedLocationGroup().getLocation(string3) == null) continue;
                    this.getAttachedItems().setItem(string3, arrayList.get(s));
                }
            }
            catch (IOException iOException) {
                DebugLog.Multiplayer.printException(iOException, "ReadInventory error for character " + this.getOnlineID(), LogSeverity.Error);
            }
        }
        return string;
    }

    public void Kill(IsoGameCharacter isoGameCharacter) {
        DebugLog.Death.trace("id=%d", this.getOnlineID());
        this.setAttackedBy(isoGameCharacter);
        this.setHealth(0.0f);
        this.setOnKillDone(true);
    }

    public boolean shouldDoInventory() {
        return true;
    }

    public void die() {
        if (!this.isOnDeathDone()) {
            if (GameClient.bClient) {
                if (this.shouldDoInventory()) {
                    this.becomeCorpse();
                } else {
                    this.getNetworkCharacterAI().processDeadBody();
                }
            } else {
                this.becomeCorpse();
            }
        }
    }

    public void becomeCorpse() {
        DebugLog.Death.trace("id=%d", this.getOnlineID());
        this.Kill(this.getAttackedBy());
        this.setOnDeathDone(true);
    }

    public boolean shouldBecomeCorpse() {
        if (GameClient.bClient || GameServer.bServer) {
            if (this.getHitReactionNetworkAI().isSetup() || this.getHitReactionNetworkAI().isStarted()) {
                return false;
            }
            if (GameServer.bServer) {
                return this.getNetworkCharacterAI().isSetDeadBody();
            }
            if (GameClient.bClient) {
                return this.isCurrentState(ZombieOnGroundState.instance()) || this.isCurrentState(PlayerOnGroundState.instance());
            }
        }
        return true;
    }

    public HitReactionNetworkAI getHitReactionNetworkAI() {
        return null;
    }

    public NetworkCharacterAI getNetworkCharacterAI() {
        return null;
    }

    public boolean isLocal() {
        return !GameClient.bClient && !GameServer.bServer;
    }

    public boolean isVehicleCollisionActive(BaseVehicle baseVehicle) {
        if (!GameClient.bClient) {
            return false;
        }
        if (!this.isAlive()) {
            return false;
        }
        if (baseVehicle == null) {
            return false;
        }
        if (!baseVehicle.shouldCollideWithCharacters()) {
            return false;
        }
        if (baseVehicle.isNetPlayerAuthorization(BaseVehicle.Authorization.Server)) {
            return false;
        }
        if (!(baseVehicle.isEngineRunning() || baseVehicle.getVehicleTowing() != null && baseVehicle.getVehicleTowing().isEngineRunning() || baseVehicle.getVehicleTowedBy() != null && baseVehicle.getVehicleTowedBy().isEngineRunning())) {
            return false;
        }
        if (!(baseVehicle.getDriver() != null || baseVehicle.getVehicleTowing() != null && baseVehicle.getVehicleTowing().getDriver() != null || baseVehicle.getVehicleTowedBy() != null && baseVehicle.getVehicleTowedBy().getDriver() != null)) {
            return false;
        }
        if (Math.abs(baseVehicle.x - this.x) < 0.01f || Math.abs(baseVehicle.y - this.y) < 0.01f) {
            return false;
        }
        return (!this.isKnockedDown() || this.isOnFloor()) && (this.getHitReactionNetworkAI() == null || !this.getHitReactionNetworkAI().isStarted());
    }

    public void doHitByVehicle(BaseVehicle baseVehicle, BaseVehicle.HitVars hitVars) {
        if (GameClient.bClient) {
            IsoPlayer isoPlayer = GameClient.IDToPlayerMap.get(baseVehicle.getNetPlayerId());
            if (isoPlayer != null) {
                if (isoPlayer.isLocal()) {
                    SoundManager.instance.PlayWorldSound("VehicleHitCharacter", this.getCurrentSquare(), 0.0f, 20.0f, 0.9f, true);
                    float f = this.Hit(baseVehicle, hitVars.hitSpeed, hitVars.isTargetHitFromBehind, -hitVars.targetImpulse.x, -hitVars.targetImpulse.z);
                    GameClient.sendHitVehicle(isoPlayer, this, baseVehicle, f, hitVars.isTargetHitFromBehind, hitVars.vehicleDamage, hitVars.hitSpeed, hitVars.isVehicleHitFromFront);
                } else {
                    this.getNetworkCharacterAI().resetVehicleHitTimeout();
                }
            }
        } else if (!GameServer.bServer) {
            BaseSoundEmitter baseSoundEmitter = IsoWorld.instance.getFreeEmitter(this.x, this.y, this.z);
            long l = baseSoundEmitter.playSound("VehicleHitCharacter");
            baseSoundEmitter.setParameterValue(l, FMODManager.instance.getParameterDescription("VehicleSpeed"), baseVehicle.getCurrentSpeedKmHour());
            this.Hit(baseVehicle, hitVars.hitSpeed, hitVars.isTargetHitFromBehind, -hitVars.targetImpulse.x, -hitVars.targetImpulse.z);
        }
    }

    public boolean isSkipResolveCollision() {
        return this instanceof IsoZombie && (this.isCurrentState(ZombieHitReactionState.instance()) || this.isCurrentState(ZombieFallDownState.instance()) || this.isCurrentState(ZombieOnGroundState.instance()) || this.isCurrentState(StaggerBackState.instance())) || this instanceof IsoPlayer && !this.isLocal() && (this.isCurrentState(PlayerFallDownState.instance()) || this.isCurrentState(BumpedState.instance()) || this.isCurrentState(PlayerKnockedDown.instance()) || this.isCurrentState(PlayerHitReactionState.instance()) || this.isCurrentState(PlayerHitReactionPVPState.instance()) || this.isCurrentState(PlayerOnGroundState.instance()));
    }

    public boolean isAttackAnim() {
        return this.attackAnim;
    }

    public void setAttackAnim(boolean bl) {
        this.attackAnim = bl;
    }

    public Float getNextAnimationTranslationLength() {
        ActionState actionState;
        if (this.getActionContext() != null && this.getAnimationPlayer() != null && this.getAdvancedAnimator() != null && (actionState = this.getActionContext().getNextState()) != null && !StringUtils.isNullOrEmpty(actionState.getName())) {
            ArrayList<AnimNode> arrayList = new ArrayList<AnimNode>();
            this.getAdvancedAnimator().animSet.GetState(actionState.getName()).getAnimNodes(this, arrayList);
            for (AnimNode animNode : arrayList) {
                AnimationClip animationClip;
                if (StringUtils.isNullOrEmpty(animNode.m_AnimName) || (animationClip = this.getAnimationPlayer().getSkinningData().AnimationClips.get(animNode.m_AnimName)) == null) continue;
                return Float.valueOf(animationClip.getTranslationLength(animNode.m_deferredBoneAxis));
            }
        }
        return null;
    }

    public Float calcHitDir(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon, Vector2 vector22) {
        Float f = this.getNextAnimationTranslationLength();
        vector22.set(this.getX() - isoGameCharacter.getX(), this.getY() - isoGameCharacter.getY()).normalize();
        if (f == null) {
            vector22.setLength(this.getHitForce() * 0.1f);
            vector22.scale(handWeapon.getPushBackMod());
            vector22.rotate(handWeapon.HitAngleMod);
        } else {
            vector22.scale(f.floatValue());
        }
        return null;
    }

    public void calcHitDir(Vector2 vector22) {
        vector22.set(this.getHitDir());
        vector22.setLength(this.getHitForce());
    }

    @Override
    public Safety getSafety() {
        return this.safety;
    }

    @Override
    public void setSafety(Safety safety) {
        this.safety.copyFrom(safety);
    }

    public void burnCorpse(IsoDeadBody isoDeadBody) {
        if (GameClient.bClient) {
            GameClient.sendBurnCorpse(this.getOnlineID(), isoDeadBody.getObjectID());
            return;
        }
        IsoFireManager.StartFire(isoDeadBody.getCell(), isoDeadBody.getSquare(), true, 100, 700);
    }

    public class XP {
        public int level = 0;
        public int lastlevel = 0;
        public float TotalXP = 0.0f;
        public HashMap<PerkFactory.Perk, Float> XPMap = new HashMap();
        private float lastXPSumm = 0.0f;
        private long lastXPTime = System.currentTimeMillis();
        private float lastXPGrowthRate = 0.0f;
        public static final float MaxXPGrowthRate = 1000.0f;
        public HashMap<PerkFactory.Perk, XPMultiplier> XPMapMultiplier = new HashMap();
        IsoGameCharacter chr = null;

        public XP(IsoGameCharacter isoGameCharacter2) {
            this.chr = isoGameCharacter2;
        }

        public void update() {
            if (!GameServer.bServer || !(this.chr instanceof IsoPlayer)) {
                return;
            }
            if (System.currentTimeMillis() - this.lastXPTime > 60000L) {
                this.lastXPTime = System.currentTimeMillis();
                float f = 0.0f;
                for (Float f2 : this.XPMap.values()) {
                    f += f2.floatValue();
                }
                this.lastXPGrowthRate = f - this.lastXPSumm;
                this.lastXPSumm = f;
                if ((double)this.lastXPGrowthRate > 1000.0 * SandboxOptions.instance.XpMultiplier.getValue() * ServerOptions.instance.AntiCheatProtectionType9ThresholdMultiplier.getValue()) {
                    UdpConnection udpConnection = GameServer.getConnectionFromPlayer((IsoPlayer)this.chr);
                    if (ServerOptions.instance.AntiCheatProtectionType9.getValue() && PacketValidator.checkUser(udpConnection)) {
                        PacketValidator.doKickUser(udpConnection, this.getClass().getSimpleName(), "Type9", null);
                    } else if ((double)this.lastXPGrowthRate > 1000.0 * SandboxOptions.instance.XpMultiplier.getValue() * ServerOptions.instance.AntiCheatProtectionType9ThresholdMultiplier.getValue() / 2.0) {
                        PacketValidator.doLogUser(udpConnection, Userlog.UserlogType.SuspiciousActivity, this.getClass().getSimpleName(), "Type9");
                    }
                }
            }
        }

        public void addXpMultiplier(PerkFactory.Perk perk, float f, int n, int n2) {
            XPMultiplier xPMultiplier = this.XPMapMultiplier.get(perk);
            if (xPMultiplier == null) {
                xPMultiplier = new XPMultiplier();
            }
            xPMultiplier.multiplier = f;
            xPMultiplier.minLevel = n;
            xPMultiplier.maxLevel = n2;
            this.XPMapMultiplier.put(perk, xPMultiplier);
        }

        public HashMap<PerkFactory.Perk, XPMultiplier> getMultiplierMap() {
            return this.XPMapMultiplier;
        }

        public float getMultiplier(PerkFactory.Perk perk) {
            XPMultiplier xPMultiplier = this.XPMapMultiplier.get(perk);
            if (xPMultiplier == null) {
                return 0.0f;
            }
            return xPMultiplier.multiplier;
        }

        public int getPerkBoost(PerkFactory.Perk perk) {
            if (IsoGameCharacter.this.getDescriptor().getXPBoostMap().get(perk) != null) {
                return IsoGameCharacter.this.getDescriptor().getXPBoostMap().get(perk);
            }
            return 0;
        }

        public void setPerkBoost(PerkFactory.Perk perk, int n) {
            if (perk == null || perk == PerkFactory.Perks.None || perk == PerkFactory.Perks.MAX) {
                return;
            }
            if ((n = PZMath.clamp(n, 0, 10)) == 0) {
                IsoGameCharacter.this.getDescriptor().getXPBoostMap().remove(perk);
                return;
            }
            IsoGameCharacter.this.getDescriptor().getXPBoostMap().put(perk, n);
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int n) {
            this.level = n;
        }

        public float getTotalXp() {
            return this.TotalXP;
        }

        public void AddXP(PerkFactory.Perk perk, float f) {
            if (this.chr instanceof IsoPlayer && ((IsoPlayer)this.chr).isLocalPlayer()) {
                this.AddXP(perk, f, true, true, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void AddXPNoMultiplier(PerkFactory.Perk perk, float f) {
            XPMultiplier xPMultiplier = this.getMultiplierMap().remove(perk);
            try {
                this.AddXP(perk, f);
            }
            finally {
                if (xPMultiplier != null) {
                    this.getMultiplierMap().put(perk, xPMultiplier);
                }
            }
        }

        public void AddXP(PerkFactory.Perk perk, float f, boolean bl, boolean bl2, boolean bl3) {
            float f2;
            float f3;
            Map.Entry<PerkFactory.Perk, Integer> entry2;
            if (!bl3 && GameClient.bClient && this.chr instanceof IsoPlayer) {
                GameClient.instance.sendAddXp((IsoPlayer)this.chr, perk, (int)f);
            }
            PerkFactory.Perk perk2 = null;
            for (int i = 0; i < PerkFactory.PerkList.size(); ++i) {
                PerkFactory.Perk perk3 = PerkFactory.PerkList.get(i);
                if (perk3.getType() != perk) continue;
                perk2 = perk3;
                break;
            }
            if (perk2.getType() == PerkFactory.Perks.Fitness && this.chr instanceof IsoPlayer && !((IsoPlayer)this.chr).getNutrition().canAddFitnessXp()) {
                return;
            }
            if (perk2.getType() == PerkFactory.Perks.Strength && this.chr instanceof IsoPlayer) {
                if (((IsoPlayer)this.chr).getNutrition().getProteins() > 50.0f && ((IsoPlayer)this.chr).getNutrition().getProteins() < 300.0f) {
                    f = (float)((double)f * 1.5);
                }
                if (((IsoPlayer)this.chr).getNutrition().getProteins() < -300.0f) {
                    f = (float)((double)f * 0.7);
                }
            }
            float f4 = this.getXP(perk);
            float f5 = perk2.getTotalXpForLevel(10);
            if (f >= 0.0f && f4 >= f5) {
                return;
            }
            float f6 = 1.0f;
            if (bl2) {
                boolean bl4 = false;
                for (Map.Entry<PerkFactory.Perk, Integer> entry2 : IsoGameCharacter.this.getDescriptor().getXPBoostMap().entrySet()) {
                    if (entry2.getKey() != perk2.getType()) continue;
                    bl4 = true;
                    if (entry2.getValue() == 0 && !this.isSkillExcludedFromSpeedReduction(entry2.getKey())) {
                        f6 *= 0.25f;
                        continue;
                    }
                    if (entry2.getValue() == 1 && entry2.getKey() == PerkFactory.Perks.Sprinting) {
                        f6 = (float)((double)f6 * 1.25);
                        continue;
                    }
                    if (entry2.getValue() == 1) {
                        f6 = (float)((double)f6 * 1.0);
                        continue;
                    }
                    if ((Integer)entry2.getValue() == 2 && !this.isSkillExcludedFromSpeedIncrease((PerkFactory.Perk)entry2.getKey())) {
                        f6 = (float)((double)f6 * 1.33);
                        continue;
                    }
                    if ((Integer)entry2.getValue() < 3 || this.isSkillExcludedFromSpeedIncrease((PerkFactory.Perk)entry2.getKey())) continue;
                    f6 = (float)((double)f6 * 1.66);
                }
                if (!bl4 && !this.isSkillExcludedFromSpeedReduction(perk2.getType())) {
                    f6 = 0.25f;
                }
                if (IsoGameCharacter.this.Traits.FastLearner.isSet() && !this.isSkillExcludedFromSpeedIncrease(perk2.getType())) {
                    f6 *= 1.3f;
                }
                if (IsoGameCharacter.this.Traits.SlowLearner.isSet() && !this.isSkillExcludedFromSpeedReduction(perk2.getType())) {
                    f6 *= 0.7f;
                }
                if (IsoGameCharacter.this.Traits.Pacifist.isSet()) {
                    if (perk2.getType() == PerkFactory.Perks.SmallBlade || perk2.getType() == PerkFactory.Perks.LongBlade || perk2.getType() == PerkFactory.Perks.SmallBlunt || perk2.getType() == PerkFactory.Perks.Spear || perk2.getType() == PerkFactory.Perks.Maintenance || perk2.getType() == PerkFactory.Perks.Blunt || perk2.getType() == PerkFactory.Perks.Axe) {
                        f6 *= 0.75f;
                    } else if (perk2.getType() == PerkFactory.Perks.Aiming) {
                        f6 *= 0.75f;
                    }
                }
                f *= f6;
                f3 = this.getMultiplier(perk);
                if (f3 > 1.0f) {
                    f *= f3;
                }
                if (!perk2.isPassiv()) {
                    f = (float)((double)f * SandboxOptions.instance.XpMultiplier.getValue());
                } else if (perk2.isPassiv() && SandboxOptions.instance.XpMultiplierAffectsPassive.getValue()) {
                    f = (float)((double)f * SandboxOptions.instance.XpMultiplier.getValue());
                }
            }
            if ((f2 = f4 + f) < 0.0f) {
                f2 = 0.0f;
                f = -f4;
            }
            if (f2 > f5) {
                f2 = f5;
                f = f2 - f4;
            }
            this.XPMap.put(perk, Float.valueOf(f2));
            f3 = perk2.getTotalXpForLevel(this.chr.getPerkLevel(perk2) + 1);
            while (f4 < f3 && f2 >= f3) {
                IsoGameCharacter.this.LevelPerk(perk);
                if (this.chr instanceof IsoPlayer && ((IsoPlayer)this.chr).isLocalPlayer() && !this.chr.getEmitter().isPlaying("GainExperienceLevel")) {
                    this.chr.getEmitter().playSoundImpl("GainExperienceLevel", null);
                }
                if (this.chr.getPerkLevel(perk2) >= 10) break;
                f3 = perk2.getTotalXpForLevel(this.chr.getPerkLevel(perk2) + 1);
            }
            if ((entry2 = this.getMultiplierMap().get(perk2)) != null) {
                float f7 = perk2.getTotalXpForLevel(((XPMultiplier)((Object)entry2)).minLevel - 1);
                float f8 = perk2.getTotalXpForLevel(((XPMultiplier)((Object)entry2)).maxLevel);
                if (f4 >= f7 && f2 < f7 || f4 < f8 && f2 >= f8) {
                    this.getMultiplierMap().remove(perk2);
                }
            }
            if (bl) {
                LuaEventManager.triggerEventGarbage("AddXP", this.chr, perk, Float.valueOf(f));
            }
        }

        private boolean isSkillExcludedFromSpeedReduction(PerkFactory.Perk perk) {
            if (perk == PerkFactory.Perks.Sprinting) {
                return true;
            }
            if (perk == PerkFactory.Perks.Fitness) {
                return true;
            }
            return perk == PerkFactory.Perks.Strength;
        }

        private boolean isSkillExcludedFromSpeedIncrease(PerkFactory.Perk perk) {
            if (perk == PerkFactory.Perks.Fitness) {
                return true;
            }
            return perk == PerkFactory.Perks.Strength;
        }

        public float getXP(PerkFactory.Perk perk) {
            if (this.XPMap.containsKey(perk)) {
                return this.XPMap.get(perk).floatValue();
            }
            return 0.0f;
        }

        @Deprecated
        public void AddXP(HandWeapon handWeapon, int n) {
        }

        public void setTotalXP(float f) {
            this.TotalXP = f;
        }

        private void savePerk(ByteBuffer byteBuffer, PerkFactory.Perk perk) throws IOException {
            GameWindow.WriteStringUTF(byteBuffer, perk == null ? "" : perk.getId());
        }

        private PerkFactory.Perk loadPerk(ByteBuffer byteBuffer, int n) throws IOException {
            if (n >= 152) {
                String string = GameWindow.ReadStringUTF(byteBuffer);
                PerkFactory.Perk perk = PerkFactory.Perks.FromString(string);
                return perk == PerkFactory.Perks.MAX ? null : perk;
            }
            int n2 = byteBuffer.getInt();
            if (n2 < 0 || n2 >= PerkFactory.Perks.MAX.index()) {
                return null;
            }
            PerkFactory.Perk perk = PerkFactory.Perks.fromIndex(n2);
            return perk == PerkFactory.Perks.MAX ? null : perk;
        }

        public void recalcSumm() {
            float f = 0.0f;
            for (Float f2 : this.XPMap.values()) {
                f += f2.floatValue();
            }
            this.lastXPSumm = f;
            this.lastXPTime = System.currentTimeMillis();
            this.lastXPGrowthRate = 0.0f;
        }

        public void load(ByteBuffer byteBuffer, int n) throws IOException {
            int n2;
            int n3;
            int n4;
            int n5 = byteBuffer.getInt();
            this.chr.Traits.clear();
            for (n4 = 0; n4 < n5; ++n4) {
                String string = GameWindow.ReadString(byteBuffer);
                if (TraitFactory.getTrait(string) != null) {
                    if (this.chr.Traits.contains(string)) continue;
                    this.chr.Traits.add(string);
                    continue;
                }
                DebugLog.General.error("unknown trait \"" + string + "\"");
            }
            this.TotalXP = byteBuffer.getFloat();
            this.level = byteBuffer.getInt();
            this.lastlevel = byteBuffer.getInt();
            this.XPMap.clear();
            n4 = byteBuffer.getInt();
            for (n3 = 0; n3 < n4; ++n3) {
                PerkFactory.Perk perk = this.loadPerk(byteBuffer, n);
                float f = byteBuffer.getFloat();
                if (perk == null) continue;
                this.XPMap.put(perk, Float.valueOf(f));
            }
            if (n < 162) {
                n3 = byteBuffer.getInt();
                for (int i = 0; i < n3; ++i) {
                    PerkFactory.Perk perk = this.loadPerk(byteBuffer, n);
                }
            }
            IsoGameCharacter.this.PerkList.clear();
            n3 = byteBuffer.getInt();
            for (n2 = 0; n2 < n3; ++n2) {
                PerkFactory.Perk perk = this.loadPerk(byteBuffer, n);
                int n6 = byteBuffer.getInt();
                if (perk == null) continue;
                PerkInfo perkInfo = new PerkInfo();
                perkInfo.perk = perk;
                perkInfo.level = n6;
                IsoGameCharacter.this.PerkList.add(perkInfo);
            }
            n2 = byteBuffer.getInt();
            for (int i = 0; i < n2; ++i) {
                PerkFactory.Perk perk = this.loadPerk(byteBuffer, n);
                float f = byteBuffer.getFloat();
                byte by = byteBuffer.get();
                byte by2 = byteBuffer.get();
                if (perk == null) continue;
                this.addXpMultiplier(perk, f, by, by2);
            }
            if (this.TotalXP > (float)IsoGameCharacter.this.getXpForLevel(this.getLevel() + 1)) {
                this.setTotalXP(this.chr.getXpForLevel(this.getLevel()));
            }
            this.recalcSumm();
        }

        public void save(ByteBuffer byteBuffer) throws IOException {
            Object object;
            byteBuffer.putInt(this.chr.Traits.size());
            for (int i = 0; i < this.chr.Traits.size(); ++i) {
                GameWindow.WriteString(byteBuffer, this.chr.Traits.get(i));
            }
            byteBuffer.putFloat(this.TotalXP);
            byteBuffer.putInt(this.level);
            byteBuffer.putInt(this.lastlevel);
            byteBuffer.putInt(this.XPMap.size());
            Iterator<Map.Entry<PerkFactory.Perk, Float>> iterator = this.XPMap.entrySet().iterator();
            while (iterator != null && iterator.hasNext()) {
                Map.Entry<PerkFactory.Perk, Float> entry = iterator.next();
                this.savePerk(byteBuffer, entry.getKey());
                byteBuffer.putFloat(entry.getValue().floatValue());
            }
            byteBuffer.putInt(IsoGameCharacter.this.PerkList.size());
            for (int i = 0; i < IsoGameCharacter.this.PerkList.size(); ++i) {
                object = IsoGameCharacter.this.PerkList.get(i);
                this.savePerk(byteBuffer, ((PerkInfo)object).perk);
                byteBuffer.putInt(((PerkInfo)object).level);
            }
            byteBuffer.putInt(this.XPMapMultiplier.size());
            Iterator<Map.Entry<PerkFactory.Perk, XPMultiplier>> iterator2 = this.XPMapMultiplier.entrySet().iterator();
            while (iterator2 != null && iterator2.hasNext()) {
                object = iterator2.next();
                this.savePerk(byteBuffer, (PerkFactory.Perk)object.getKey());
                byteBuffer.putFloat(((XPMultiplier)object.getValue()).multiplier);
                byteBuffer.put((byte)((XPMultiplier)object.getValue()).minLevel);
                byteBuffer.put((byte)((XPMultiplier)object.getValue()).maxLevel);
            }
        }

        public void setXPToLevel(PerkFactory.Perk perk, int n) {
            PerkFactory.Perk perk2 = null;
            for (int i = 0; i < PerkFactory.PerkList.size(); ++i) {
                PerkFactory.Perk perk3 = PerkFactory.PerkList.get(i);
                if (perk3.getType() != perk) continue;
                perk2 = perk3;
                break;
            }
            if (perk2 != null) {
                this.XPMap.put(perk, Float.valueOf(perk2.getTotalXpForLevel(n)));
            }
        }
    }

    public class CharacterTraits
    extends TraitCollection {
        public final TraitCollection.TraitSlot Obese = this.getTraitSlot("Obese");
        public final TraitCollection.TraitSlot Athletic = this.getTraitSlot("Athletic");
        public final TraitCollection.TraitSlot Overweight = this.getTraitSlot("Overweight");
        public final TraitCollection.TraitSlot Unfit = this.getTraitSlot("Unfit");
        public final TraitCollection.TraitSlot Emaciated = this.getTraitSlot("Emaciated");
        public final TraitCollection.TraitSlot Graceful = this.getTraitSlot("Graceful");
        public final TraitCollection.TraitSlot Clumsy = this.getTraitSlot("Clumsy");
        public final TraitCollection.TraitSlot Strong = this.getTraitSlot("Strong");
        public final TraitCollection.TraitSlot Weak = this.getTraitSlot("Weak");
        public final TraitCollection.TraitSlot VeryUnderweight = this.getTraitSlot("Very Underweight");
        public final TraitCollection.TraitSlot Underweight = this.getTraitSlot("Underweight");
        public final TraitCollection.TraitSlot FastHealer = this.getTraitSlot("FastHealer");
        public final TraitCollection.TraitSlot SlowHealer = this.getTraitSlot("SlowHealer");
        public final TraitCollection.TraitSlot ShortSighted = this.getTraitSlot("ShortSighted");
        public final TraitCollection.TraitSlot EagleEyed = this.getTraitSlot("EagleEyed");
        public final TraitCollection.TraitSlot Agoraphobic = this.getTraitSlot("Agoraphobic");
        public final TraitCollection.TraitSlot Claustophobic = this.getTraitSlot("Claustophobic");
        public final TraitCollection.TraitSlot AdrenalineJunkie = this.getTraitSlot("AdrenalineJunkie");
        public final TraitCollection.TraitSlot OutOfShape = this.getTraitSlot("Out of Shape");
        public final TraitCollection.TraitSlot HighThirst = this.getTraitSlot("HighThirst");
        public final TraitCollection.TraitSlot LowThirst = this.getTraitSlot("LowThirst");
        public final TraitCollection.TraitSlot HeartyAppitite = this.getTraitSlot("HeartyAppitite");
        public final TraitCollection.TraitSlot LightEater = this.getTraitSlot("LightEater");
        public final TraitCollection.TraitSlot Cowardly = this.getTraitSlot("Cowardly");
        public final TraitCollection.TraitSlot Brave = this.getTraitSlot("Brave");
        public final TraitCollection.TraitSlot Brooding = this.getTraitSlot("Brooding");
        public final TraitCollection.TraitSlot Insomniac = this.getTraitSlot("Insomniac");
        public final TraitCollection.TraitSlot NeedsLessSleep = this.getTraitSlot("NeedsLessSleep");
        public final TraitCollection.TraitSlot NeedsMoreSleep = this.getTraitSlot("NeedsMoreSleep");
        public final TraitCollection.TraitSlot Asthmatic = this.getTraitSlot("Asthmatic");
        public final TraitCollection.TraitSlot PlaysFootball = this.getTraitSlot("PlaysFootball");
        public final TraitCollection.TraitSlot Jogger = this.getTraitSlot("Jogger");
        public final TraitCollection.TraitSlot NightVision = this.getTraitSlot("NightVision");
        public final TraitCollection.TraitSlot FastLearner = this.getTraitSlot("FastLearner");
        public final TraitCollection.TraitSlot SlowLearner = this.getTraitSlot("SlowLearner");
        public final TraitCollection.TraitSlot Pacifist = this.getTraitSlot("Pacifist");
        public final TraitCollection.TraitSlot Feeble = this.getTraitSlot("Feeble");
        public final TraitCollection.TraitSlot Stout = this.getTraitSlot("Stout");
        public final TraitCollection.TraitSlot ShortTemper = this.getTraitSlot("ShortTemper");
        public final TraitCollection.TraitSlot Patient = this.getTraitSlot("Patient");
        public final TraitCollection.TraitSlot Injured = this.getTraitSlot("Injured");
        public final TraitCollection.TraitSlot Inconspicuous = this.getTraitSlot("Inconspicuous");
        public final TraitCollection.TraitSlot Conspicuous = this.getTraitSlot("Conspicuous");
        public final TraitCollection.TraitSlot Desensitized = this.getTraitSlot("Desensitized");
        public final TraitCollection.TraitSlot NightOwl = this.getTraitSlot("NightOwl");
        public final TraitCollection.TraitSlot Hemophobic = this.getTraitSlot("Hemophobic");
        public final TraitCollection.TraitSlot Burglar = this.getTraitSlot("Burglar");
        public final TraitCollection.TraitSlot KeenHearing = this.getTraitSlot("KeenHearing");
        public final TraitCollection.TraitSlot Deaf = this.getTraitSlot("Deaf");
        public final TraitCollection.TraitSlot HardOfHearing = this.getTraitSlot("HardOfHearing");
        public final TraitCollection.TraitSlot ThinSkinned = this.getTraitSlot("ThinSkinned");
        public final TraitCollection.TraitSlot ThickSkinned = this.getTraitSlot("ThickSkinned");
        public final TraitCollection.TraitSlot Marksman = this.getTraitSlot("Marksman");
        public final TraitCollection.TraitSlot Outdoorsman = this.getTraitSlot("Outdoorsman");
        public final TraitCollection.TraitSlot Lucky = this.getTraitSlot("Lucky");
        public final TraitCollection.TraitSlot Unlucky = this.getTraitSlot("Unlucky");
        public final TraitCollection.TraitSlot Nutritionist = this.getTraitSlot("Nutritionist");
        public final TraitCollection.TraitSlot Nutritionist2 = this.getTraitSlot("Nutritionist2");
        public final TraitCollection.TraitSlot Organized = this.getTraitSlot("Organized");
        public final TraitCollection.TraitSlot Disorganized = this.getTraitSlot("Disorganized");
        public final TraitCollection.TraitSlot Axeman = this.getTraitSlot("Axeman");
        public final TraitCollection.TraitSlot IronGut = this.getTraitSlot("IronGut");
        public final TraitCollection.TraitSlot WeakStomach = this.getTraitSlot("WeakStomach");
        public final TraitCollection.TraitSlot HeavyDrinker = this.getTraitSlot("HeavyDrinker");
        public final TraitCollection.TraitSlot LightDrinker = this.getTraitSlot("LightDrinker");
        public final TraitCollection.TraitSlot Resilient = this.getTraitSlot("Resilient");
        public final TraitCollection.TraitSlot ProneToIllness = this.getTraitSlot("ProneToIllness");
        public final TraitCollection.TraitSlot SpeedDemon = this.getTraitSlot("SpeedDemon");
        public final TraitCollection.TraitSlot SundayDriver = this.getTraitSlot("SundayDriver");
        public final TraitCollection.TraitSlot Smoker = this.getTraitSlot("Smoker");
        public final TraitCollection.TraitSlot Hypercondriac = this.getTraitSlot("Hypercondriac");
        public final TraitCollection.TraitSlot Illiterate = this.getTraitSlot("Illiterate");

        public boolean isIlliterate() {
            return this.Illiterate.isSet();
        }
    }

    public static class Location {
        public int x;
        public int y;
        public int z;

        public Location() {
        }

        public Location(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.z = n3;
        }

        public Location set(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.z = n3;
            return this;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public boolean equals(Object object) {
            if (object instanceof Location) {
                Location location = (Location)object;
                return this.x == location.x && this.y == location.y && this.z == location.z;
            }
            return false;
        }
    }

    public static class LightInfo {
        public IsoGridSquare square;
        public float x;
        public float y;
        public float z;
        public float angleX;
        public float angleY;
        public ArrayList<TorchInfo> torches = new ArrayList();
        public long time;
        public float night;
        public float rmod;
        public float gmod;
        public float bmod;

        public void initFrom(LightInfo lightInfo) {
            this.square = lightInfo.square;
            this.x = lightInfo.x;
            this.y = lightInfo.y;
            this.z = lightInfo.z;
            this.angleX = lightInfo.angleX;
            this.angleY = lightInfo.angleY;
            this.torches.clear();
            this.torches.addAll(lightInfo.torches);
            this.time = (long)((double)System.nanoTime() / 1000000.0);
            this.night = lightInfo.night;
            this.rmod = lightInfo.rmod;
            this.gmod = lightInfo.gmod;
            this.bmod = lightInfo.bmod;
        }
    }

    private static final class L_getDotWithForwardDirection {
        static final Vector2 v1 = new Vector2();
        static final Vector2 v2 = new Vector2();

        private L_getDotWithForwardDirection() {
        }
    }

    public class PerkInfo {
        public int level = 0;
        public PerkFactory.Perk perk;

        public int getLevel() {
            return this.level;
        }
    }

    private static class ReadBook {
        String fullType;
        int alreadyReadPages;

        private ReadBook() {
        }
    }

    private static final class L_renderShadow {
        static final Vector3f forward = new Vector3f();
        static final Vector3 v1 = new Vector3();
        static final Vector3f v3 = new Vector3f();

        private L_renderShadow() {
        }
    }

    private static final class L_renderLast {
        static final Color color = new Color();

        private L_renderLast() {
        }
    }

    private static class s_performance {
        static final PerformanceProfileProbe postUpdate = new PerformanceProfileProbe("IsoGameCharacter.postUpdate");
        public static PerformanceProfileProbe update = new PerformanceProfileProbe("IsoGameCharacter.update");

        private s_performance() {
        }
    }

    public static class TorchInfo {
        private static final ObjectPool<TorchInfo> TorchInfoPool = new ObjectPool<TorchInfo>(TorchInfo::new);
        private static final Vector3f tempVector3f = new Vector3f();
        public int id;
        public float x;
        public float y;
        public float z;
        public float angleX;
        public float angleY;
        public float dist;
        public float strength;
        public boolean bCone;
        public float dot;
        public int focusing;

        public static TorchInfo alloc() {
            return TorchInfoPool.alloc();
        }

        public static void release(TorchInfo torchInfo) {
            TorchInfoPool.release(torchInfo);
        }

        public TorchInfo set(IsoPlayer isoPlayer, InventoryItem inventoryItem) {
            this.x = isoPlayer.getX();
            this.y = isoPlayer.getY();
            this.z = isoPlayer.getZ();
            Vector2 vector22 = isoPlayer.getLookVector(tempVector2);
            this.angleX = vector22.x;
            this.angleY = vector22.y;
            this.dist = inventoryItem.getLightDistance();
            this.strength = inventoryItem.getLightStrength();
            this.bCone = inventoryItem.isTorchCone();
            this.dot = inventoryItem.getTorchDot();
            this.focusing = 0;
            return this;
        }

        public TorchInfo set(VehiclePart vehiclePart) {
            BaseVehicle baseVehicle = vehiclePart.getVehicle();
            VehicleLight vehicleLight = vehiclePart.getLight();
            VehicleScript vehicleScript = baseVehicle.getScript();
            Vector3f vector3f = tempVector3f;
            vector3f.set(vehicleLight.offset.x * vehicleScript.getExtents().x / 2.0f, 0.0f, vehicleLight.offset.y * vehicleScript.getExtents().z / 2.0f);
            baseVehicle.getWorldPos(vector3f, vector3f);
            this.x = vector3f.x;
            this.y = vector3f.y;
            this.z = vector3f.z;
            vector3f = baseVehicle.getForwardVector(vector3f);
            this.angleX = vector3f.x;
            this.angleY = vector3f.z;
            this.dist = vehiclePart.getLightDistance();
            this.strength = vehiclePart.getLightIntensity();
            this.bCone = true;
            this.dot = vehicleLight.dot;
            this.focusing = (int)vehiclePart.getLightFocusing();
            return this;
        }
    }

    private static class L_postUpdate {
        static final MoveDeltaModifiers moveDeltas = new MoveDeltaModifiers();

        private L_postUpdate() {
        }
    }

    private static final class L_actionStateChanged {
        static final ArrayList<String> stateNames = new ArrayList();
        static final ArrayList<State> states = new ArrayList();

        private L_actionStateChanged() {
        }
    }

    protected static final class l_testDotSide {
        static final Vector2 v1 = new Vector2();
        static final Vector2 v2 = new Vector2();
        static final Vector2 v3 = new Vector2();

        protected l_testDotSide() {
        }
    }

    private static final class Bandages {
        final HashMap<String, String> bandageTypeMap = new HashMap();
        final THashMap<String, InventoryItem> itemMap = new THashMap();

        private Bandages() {
        }

        String getBloodBandageType(String string) {
            Object object = this.bandageTypeMap.get(string);
            if (object == null) {
                object = string + "_Blood";
                this.bandageTypeMap.put(string, (String)object);
            }
            return object;
        }

        void update(IsoGameCharacter isoGameCharacter) {
            Object object;
            int n;
            if (GameServer.bServer) {
                return;
            }
            BodyDamage bodyDamage = isoGameCharacter.getBodyDamage();
            WornItems wornItems = isoGameCharacter.getWornItems();
            if (bodyDamage == null || wornItems == null) {
                return;
            }
            assert (!(isoGameCharacter instanceof IsoZombie));
            this.itemMap.clear();
            for (n = 0; n < wornItems.size(); ++n) {
                object = wornItems.getItemByIndex(n);
                if (object == null) continue;
                this.itemMap.put((Object)((InventoryItem)object).getFullType(), object);
            }
            for (n = 0; n < BodyPartType.ToIndex(BodyPartType.MAX); ++n) {
                String string;
                object = bodyDamage.getBodyPart(BodyPartType.FromIndex(n));
                BodyPartLast bodyPartLast = bodyDamage.getBodyPartsLastState(BodyPartType.FromIndex(n));
                String string2 = ((BodyPart)object).getType().getBandageModel();
                if (StringUtils.isNullOrWhitespace(string2)) continue;
                String string3 = this.getBloodBandageType(string2);
                if (((BodyPart)object).bandaged() != bodyPartLast.bandaged()) {
                    if (((BodyPart)object).bandaged()) {
                        if (((BodyPart)object).isBandageDirty()) {
                            this.removeBandageModel(isoGameCharacter, string2);
                            this.addBandageModel(isoGameCharacter, string3);
                        } else {
                            this.removeBandageModel(isoGameCharacter, string3);
                            this.addBandageModel(isoGameCharacter, string2);
                        }
                    } else {
                        this.removeBandageModel(isoGameCharacter, string2);
                        this.removeBandageModel(isoGameCharacter, string3);
                    }
                }
                if (((BodyPart)object).bitten() != bodyPartLast.bitten()) {
                    if (((BodyPart)object).bitten()) {
                        string = ((BodyPart)object).getType().getBiteWoundModel(isoGameCharacter.isFemale());
                        if (StringUtils.isNullOrWhitespace(string)) continue;
                        this.addBandageModel(isoGameCharacter, string);
                    } else {
                        this.removeBandageModel(isoGameCharacter, ((BodyPart)object).getType().getBiteWoundModel(isoGameCharacter.isFemale()));
                    }
                }
                if (((BodyPart)object).scratched() != bodyPartLast.scratched()) {
                    if (((BodyPart)object).scratched()) {
                        string = ((BodyPart)object).getType().getScratchWoundModel(isoGameCharacter.isFemale());
                        if (StringUtils.isNullOrWhitespace(string)) continue;
                        this.addBandageModel(isoGameCharacter, string);
                    } else {
                        this.removeBandageModel(isoGameCharacter, ((BodyPart)object).getType().getScratchWoundModel(isoGameCharacter.isFemale()));
                    }
                }
                if (((BodyPart)object).isCut() == bodyPartLast.isCut()) continue;
                if (((BodyPart)object).isCut()) {
                    string = ((BodyPart)object).getType().getCutWoundModel(isoGameCharacter.isFemale());
                    if (StringUtils.isNullOrWhitespace(string)) continue;
                    this.addBandageModel(isoGameCharacter, string);
                    continue;
                }
                this.removeBandageModel(isoGameCharacter, ((BodyPart)object).getType().getCutWoundModel(isoGameCharacter.isFemale()));
            }
        }

        protected void addBandageModel(IsoGameCharacter isoGameCharacter, String string) {
            if (this.itemMap.containsKey((Object)string)) {
                return;
            }
            InventoryItem inventoryItem = InventoryItemFactory.CreateItem(string);
            if (!(inventoryItem instanceof Clothing)) {
                return;
            }
            Clothing clothing = (Clothing)inventoryItem;
            isoGameCharacter.getInventory().addItem(clothing);
            isoGameCharacter.setWornItem(clothing.getBodyLocation(), clothing);
            isoGameCharacter.resetModelNextFrame();
        }

        protected void removeBandageModel(IsoGameCharacter isoGameCharacter, String string) {
            InventoryItem inventoryItem = (InventoryItem)this.itemMap.get((Object)string);
            if (inventoryItem == null) {
                return;
            }
            isoGameCharacter.getWornItems().remove(inventoryItem);
            isoGameCharacter.getInventory().Remove(inventoryItem);
            isoGameCharacter.resetModelNextFrame();
            isoGameCharacter.onWornItemsChanged();
            if (GameClient.bClient && isoGameCharacter instanceof IsoPlayer && ((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
                GameClient.instance.sendClothing((IsoPlayer)isoGameCharacter, inventoryItem.getBodyLocation(), inventoryItem);
            }
        }
    }

    public static class XPMultiplier {
        public float multiplier;
        public int minLevel;
        public int maxLevel;
    }

    public static enum BodyLocation {
        Head,
        Leg,
        Arm,
        Chest,
        Stomach,
        Foot,
        Hand;

    }
}

