/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import zombie.GameTime;
import zombie.characters.IsoPlayer;

public class HaloTextHelper {
    public static final ColorRGB COLOR_WHITE = new ColorRGB(255, 255, 255);
    public static final ColorRGB COLOR_GREEN = new ColorRGB(137, 232, 148);
    public static final ColorRGB COLOR_RED = new ColorRGB(255, 105, 97);
    private static String[] queuedLines = new String[4];
    private static String[] currentLines = new String[4];
    private static boolean ignoreOverheadCheckOnce = false;

    public static ColorRGB getColorWhite() {
        return COLOR_WHITE;
    }

    public static ColorRGB getColorGreen() {
        return COLOR_GREEN;
    }

    public static ColorRGB getColorRed() {
        return COLOR_RED;
    }

    public static void forceNextAddText() {
        ignoreOverheadCheckOnce = true;
    }

    public static void addTextWithArrow(IsoPlayer isoPlayer, String string, boolean bl, ColorRGB colorRGB) {
        HaloTextHelper.addTextWithArrow(isoPlayer, string, bl, colorRGB.r, colorRGB.g, colorRGB.b, colorRGB.r, colorRGB.g, colorRGB.b);
    }

    public static void addTextWithArrow(IsoPlayer isoPlayer, String string, boolean bl, int n, int n2, int n3) {
        HaloTextHelper.addTextWithArrow(isoPlayer, string, bl, n, n2, n3, n, n2, n3);
    }

    public static void addTextWithArrow(IsoPlayer isoPlayer, String string, boolean bl, ColorRGB colorRGB, ColorRGB colorRGB2) {
        HaloTextHelper.addTextWithArrow(isoPlayer, string, bl, colorRGB.r, colorRGB.g, colorRGB.b, colorRGB2.r, colorRGB2.g, colorRGB2.b);
    }

    public static void addTextWithArrow(IsoPlayer isoPlayer, String string, boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        HaloTextHelper.addText(isoPlayer, "[col=" + n + "," + n2 + "," + n3 + "]" + string + "[/] [img=media/ui/" + (bl ? "ArrowUp.png" : "ArrowDown.png") + "," + n4 + "," + n5 + "," + n6 + "]");
    }

    public static void addText(IsoPlayer isoPlayer, String string, ColorRGB colorRGB) {
        HaloTextHelper.addText(isoPlayer, string, colorRGB.r, colorRGB.g, colorRGB.b);
    }

    public static void addText(IsoPlayer isoPlayer, String string, int n, int n2, int n3) {
        HaloTextHelper.addText(isoPlayer, "[col=" + n + "," + n2 + "," + n3 + "]" + string + "[/]");
    }

    public static void addText(IsoPlayer isoPlayer, String string) {
        int n = isoPlayer.getPlayerNum();
        if (HaloTextHelper.overheadContains(n, string)) {
            return;
        }
        Object object = queuedLines[n];
        if (object == null) {
            object = string;
        } else {
            if (((String)object).contains(string)) {
                return;
            }
            object = (String)object + "[col=175,175,175], [/]" + string;
        }
        HaloTextHelper.queuedLines[n] = object;
    }

    private static boolean overheadContains(int n, String string) {
        if (ignoreOverheadCheckOnce) {
            ignoreOverheadCheckOnce = false;
            return false;
        }
        return currentLines[n] != null && currentLines[n].contains(string);
    }

    public static void update() {
        for (int i = 0; i < 4; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer != null) {
                if (currentLines[i] != null && isoPlayer.getHaloTimerCount() <= 0.2f * GameTime.getInstance().getMultiplier()) {
                    HaloTextHelper.currentLines[i] = null;
                }
                if (queuedLines[i] == null || !(isoPlayer.getHaloTimerCount() <= 0.2f * GameTime.getInstance().getMultiplier())) continue;
                isoPlayer.setHaloNote(queuedLines[i]);
                HaloTextHelper.currentLines[i] = queuedLines[i];
                HaloTextHelper.queuedLines[i] = null;
                continue;
            }
            if (queuedLines[i] != null) {
                HaloTextHelper.queuedLines[i] = null;
            }
            if (currentLines[i] == null) continue;
            HaloTextHelper.currentLines[i] = null;
        }
    }

    public static class ColorRGB {
        public int r;
        public int g;
        public int b;
        public int a = 255;

        public ColorRGB(int n, int n2, int n3) {
            this.r = n;
            this.g = n2;
            this.b = n3;
        }
    }
}

