/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.BodyDamage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.GameTime;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characterTextures.BloodClothingType;
import zombie.characters.BodyDamage.BodyDamage;
import zombie.characters.BodyDamage.BodyPart;
import zombie.characters.BodyDamage.BodyPartContacts;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.characters.BodyDamage.Metabolics;
import zombie.characters.BodyDamage.Nutrition;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.Moodles.MoodleType;
import zombie.characters.Stats;
import zombie.core.math.PZMath;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.debug.DebugLog;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.Clothing;
import zombie.inventory.types.WeaponType;
import zombie.iso.weather.ClimateManager;
import zombie.iso.weather.Temperature;

public final class Thermoregulator {
    private static final boolean DISABLE_ENERGY_MULTIPLIER = false;
    private final BodyDamage bodyDamage;
    private final IsoGameCharacter character;
    private final IsoPlayer player;
    private final Stats stats;
    private final Nutrition nutrition;
    private final ClimateManager climate;
    private static final ItemVisuals itemVisuals = new ItemVisuals();
    private static final ItemVisuals itemVisualsCache = new ItemVisuals();
    private static final ArrayList<BloodBodyPartType> coveredParts = new ArrayList();
    private static float SIMULATION_MULTIPLIER = 1.0f;
    private float setPoint = 37.0f;
    private float metabolicRate;
    private float metabolicRateReal = this.metabolicRate = Metabolics.Default.getMet();
    private float metabolicTarget = Metabolics.Default.getMet();
    private double fluidsMultiplier = 1.0;
    private double energyMultiplier = 1.0;
    private double fatigueMultiplier = 1.0;
    private float bodyHeatDelta = 0.0f;
    private float coreHeatDelta = 0.0f;
    private boolean thermalChevronUp = true;
    private ThermalNode core;
    private ThermalNode[] nodes;
    private float totalHeatRaw = 0.0f;
    private float totalHeat = 0.0f;
    private float primTotal = 0.0f;
    private float secTotal = 0.0f;
    private float externalAirTemperature = 27.0f;
    private float airTemperature;
    private float airAndWindTemp;
    private float rateOfChangeCounter = 0.0f;
    private float coreCelciusCache = 37.0f;
    private float coreRateOfChange = 0.0f;
    private float thermalDamage = 0.0f;
    private float damageCounter = 0.0f;

    public Thermoregulator(BodyDamage bodyDamage) {
        this.bodyDamage = bodyDamage;
        this.character = bodyDamage.getParentChar();
        this.stats = this.character.getStats();
        if (this.character instanceof IsoPlayer) {
            this.player = (IsoPlayer)this.character;
            this.nutrition = ((IsoPlayer)this.character).getNutrition();
        } else {
            this.player = null;
            this.nutrition = null;
        }
        this.climate = ClimateManager.getInstance();
        this.initNodes();
    }

    public static void setSimulationMultiplier(float f) {
        SIMULATION_MULTIPLIER = f;
    }

    public void save(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.putFloat(this.setPoint);
        byteBuffer.putFloat(this.metabolicRate);
        byteBuffer.putFloat(this.metabolicTarget);
        byteBuffer.putFloat(this.bodyHeatDelta);
        byteBuffer.putFloat(this.coreHeatDelta);
        byteBuffer.putFloat(this.thermalDamage);
        byteBuffer.putFloat(this.damageCounter);
        byteBuffer.putInt(this.nodes.length);
        for (int i = 0; i < this.nodes.length; ++i) {
            ThermalNode thermalNode = this.nodes[i];
            byteBuffer.putInt(BodyPartType.ToIndex(thermalNode.bodyPartType));
            byteBuffer.putFloat(thermalNode.celcius);
            byteBuffer.putFloat(thermalNode.skinCelcius);
            byteBuffer.putFloat(thermalNode.heatDelta);
            byteBuffer.putFloat(thermalNode.primaryDelta);
            byteBuffer.putFloat(thermalNode.secondaryDelta);
        }
    }

    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        this.setPoint = byteBuffer.getFloat();
        this.metabolicRate = byteBuffer.getFloat();
        this.metabolicTarget = byteBuffer.getFloat();
        this.bodyHeatDelta = byteBuffer.getFloat();
        this.coreHeatDelta = byteBuffer.getFloat();
        this.thermalDamage = byteBuffer.getFloat();
        this.damageCounter = byteBuffer.getFloat();
        int n2 = byteBuffer.getInt();
        for (int i = 0; i < n2; ++i) {
            int n3 = byteBuffer.getInt();
            float f = byteBuffer.getFloat();
            float f2 = byteBuffer.getFloat();
            float f3 = byteBuffer.getFloat();
            float f4 = byteBuffer.getFloat();
            float f5 = byteBuffer.getFloat();
            ThermalNode thermalNode = this.getNodeForType(BodyPartType.FromIndex(n3));
            if (thermalNode != null) {
                thermalNode.celcius = f;
                thermalNode.skinCelcius = f2;
                thermalNode.heatDelta = f3;
                thermalNode.primaryDelta = f4;
                thermalNode.secondaryDelta = f5;
                continue;
            }
            DebugLog.log("Couldnt load node: " + BodyPartType.ToString(BodyPartType.FromIndex(n3)));
        }
    }

    public void reset() {
        this.setPoint = 37.0f;
        this.metabolicTarget = this.metabolicRate = Metabolics.Default.getMet();
        this.core.celcius = 37.0f;
        this.bodyHeatDelta = 0.0f;
        this.coreHeatDelta = 0.0f;
        this.thermalDamage = 0.0f;
        for (int i = 0; i < this.nodes.length; ++i) {
            ThermalNode thermalNode = this.nodes[i];
            if (thermalNode != this.core) {
                thermalNode.celcius = 35.0f;
            }
            thermalNode.primaryDelta = 0.0f;
            thermalNode.secondaryDelta = 0.0f;
            thermalNode.skinCelcius = 33.0f;
            thermalNode.heatDelta = 0.0f;
        }
    }

    private void initNodes() {
        Object object;
        Object object2;
        int n;
        ArrayList<ThermalNode> arrayList = new ArrayList<ThermalNode>();
        for (n = 0; n < this.bodyDamage.getBodyParts().size(); ++n) {
            object2 = this.bodyDamage.getBodyParts().get(n);
            object = null;
            switch (((BodyPart)object2).getType()) {
                case Torso_Upper: {
                    this.core = object = new ThermalNode(true, 37.0f, (BodyPart)object2, 0.25f);
                    break;
                }
                case Head: {
                    object = new ThermalNode(37.0f, (BodyPart)object2, 1.0f);
                    break;
                }
                case Neck: {
                    object = new ThermalNode(37.0f, (BodyPart)object2, 0.5f);
                    break;
                }
                case Torso_Lower: {
                    object = new ThermalNode(37.0f, (BodyPart)object2, 0.25f);
                    break;
                }
                case Groin: {
                    object = new ThermalNode(37.0f, (BodyPart)object2, 0.5f);
                    break;
                }
                case UpperLeg_L: 
                case UpperLeg_R: {
                    object = new ThermalNode(37.0f, (BodyPart)object2, 0.5f);
                    break;
                }
                case LowerLeg_L: 
                case LowerLeg_R: {
                    object = new ThermalNode(37.0f, (BodyPart)object2, 0.5f);
                    break;
                }
                case Foot_L: 
                case Foot_R: {
                    object = new ThermalNode(37.0f, (BodyPart)object2, 0.5f);
                    break;
                }
                case UpperArm_L: 
                case UpperArm_R: {
                    object = new ThermalNode(37.0f, (BodyPart)object2, 0.25f);
                    break;
                }
                case ForeArm_L: 
                case ForeArm_R: {
                    object = new ThermalNode(37.0f, (BodyPart)object2, 0.25f);
                    break;
                }
                case Hand_L: 
                case Hand_R: {
                    object = new ThermalNode(37.0f, (BodyPart)object2, 1.0f);
                    break;
                }
                default: {
                    DebugLog.log("Warning: couldnt init thermal node for body part '" + this.bodyDamage.getBodyParts().get(n).getType() + "'.");
                }
            }
            if (object == null) continue;
            ((BodyPart)object2).thermalNode = object;
            arrayList.add((ThermalNode)object);
        }
        this.nodes = new ThermalNode[arrayList.size()];
        arrayList.toArray(this.nodes);
        for (n = 0; n < this.nodes.length; ++n) {
            BodyPartType[] bodyPartTypeArray;
            object2 = this.nodes[n];
            object = BodyPartContacts.getParent(((ThermalNode)object2).bodyPartType);
            if (object != null) {
                ((ThermalNode)object2).upstream = this.getNodeForType((BodyPartType)((Object)object));
            }
            if ((bodyPartTypeArray = BodyPartContacts.getChildren(((ThermalNode)object2).bodyPartType)) == null || bodyPartTypeArray.length <= 0) continue;
            ((ThermalNode)object2).downstream = new ThermalNode[bodyPartTypeArray.length];
            for (int i = 0; i < bodyPartTypeArray.length; ++i) {
                ((ThermalNode)object2).downstream[i] = this.getNodeForType(bodyPartTypeArray[i]);
            }
        }
        this.core.celcius = this.setPoint;
    }

    public int getNodeSize() {
        return this.nodes.length;
    }

    public ThermalNode getNode(int n) {
        return this.nodes[n];
    }

    public ThermalNode getNodeForType(BodyPartType bodyPartType) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i].bodyPartType != bodyPartType) continue;
            return this.nodes[i];
        }
        return null;
    }

    public ThermalNode getNodeForBloodType(BloodBodyPartType bloodBodyPartType) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i].bloodBPT != bloodBodyPartType) continue;
            return this.nodes[i];
        }
        return null;
    }

    public float getBodyHeatDelta() {
        return this.bodyHeatDelta;
    }

    public double getFluidsMultiplier() {
        return this.fluidsMultiplier;
    }

    public double getEnergyMultiplier() {
        return this.energyMultiplier;
    }

    public double getFatigueMultiplier() {
        return this.fatigueMultiplier;
    }

    public float getMovementModifier() {
        float f = 1.0f;
        if (this.player != null) {
            int n = this.player.getMoodles().getMoodleLevel(MoodleType.Hypothermia);
            if (n == 2) {
                f = 0.66f;
            } else if (n == 3) {
                f = 0.33f;
            } else if (n == 4) {
                f = 0.0f;
            }
            n = this.player.getMoodles().getMoodleLevel(MoodleType.Hyperthermia);
            if (n == 2) {
                f = 0.66f;
            } else if (n == 3) {
                f = 0.33f;
            } else if (n == 4) {
                f = 0.0f;
            }
        }
        return f;
    }

    public float getCombatModifier() {
        float f = 1.0f;
        if (this.player != null) {
            int n = this.player.getMoodles().getMoodleLevel(MoodleType.Hypothermia);
            if (n == 2) {
                f = 0.66f;
            } else if (n == 3) {
                f = 0.33f;
            } else if (n == 4) {
                f = 0.1f;
            }
            n = this.player.getMoodles().getMoodleLevel(MoodleType.Hyperthermia);
            if (n == 2) {
                f = 0.66f;
            } else if (n == 3) {
                f = 0.33f;
            } else if (n == 4) {
                f = 0.1f;
            }
        }
        return f;
    }

    public float getCoreTemperature() {
        return this.core.celcius;
    }

    public float getHeatGeneration() {
        return this.metabolicRateReal;
    }

    public float getMetabolicRate() {
        return this.metabolicRate;
    }

    public float getMetabolicTarget() {
        return this.metabolicTarget;
    }

    public float getMetabolicRateReal() {
        return this.metabolicRateReal;
    }

    public float getSetPoint() {
        return this.setPoint;
    }

    public float getCoreHeatDelta() {
        return this.coreHeatDelta;
    }

    public float getCoreRateOfChange() {
        return this.coreRateOfChange;
    }

    public float getExternalAirTemperature() {
        return this.externalAirTemperature;
    }

    public float getCoreTemperatureUI() {
        float f = PZMath.clamp(this.core.celcius, 20.0f, 42.0f);
        f = f < 37.0f ? (f - 20.0f) / 17.0f * 0.5f : 0.5f + (f - 37.0f) / 5.0f * 0.5f;
        return f;
    }

    public float getHeatGenerationUI() {
        float f = PZMath.clamp(this.metabolicRateReal, 0.0f, Metabolics.MAX.getMet());
        f = f < Metabolics.Default.getMet() ? f / Metabolics.Default.getMet() * 0.5f : 0.5f + (f - Metabolics.Default.getMet()) / (Metabolics.MAX.getMet() - Metabolics.Default.getMet()) * 0.5f;
        return f;
    }

    public boolean thermalChevronUp() {
        return this.thermalChevronUp;
    }

    public int thermalChevronCount() {
        if (this.coreRateOfChange > 0.01f) {
            return 3;
        }
        if (this.coreRateOfChange > 0.001f) {
            return 2;
        }
        if (this.coreRateOfChange > 1.0E-4f) {
            return 1;
        }
        return 0;
    }

    public float getCatchAColdDelta() {
        float f = 0.0f;
        if (this.player.getMoodles().getMoodleLevel(MoodleType.Hypothermia) < 1) {
            return f;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            ThermalNode thermalNode = this.nodes[i];
            float f2 = 0.0f;
            if (thermalNode.skinCelcius < 33.0f) {
                f2 = (thermalNode.skinCelcius - 20.0f) / 13.0f;
                f2 = 1.0f - f2;
                f2 *= f2;
            }
            float f3 = 0.25f * f2 * thermalNode.skinSurface;
            if (thermalNode.bodyWetness > 0.0f) {
                f3 *= 1.0f + thermalNode.bodyWetness * 1.0f;
            }
            if (thermalNode.clothingWetness > 0.5f) {
                f3 *= 1.0f + (thermalNode.clothingWetness - 0.5f) * 2.0f;
            }
            if (thermalNode.bodyPartType == BodyPartType.Neck) {
                f3 *= 8.0f;
            } else if (thermalNode.bodyPartType == BodyPartType.Torso_Upper) {
                f3 *= 16.0f;
            } else if (thermalNode.bodyPartType == BodyPartType.Head) {
                f3 *= 4.0f;
            }
            f += f3;
        }
        if (this.player.getMoodles().getMoodleLevel(MoodleType.Hypothermia) > 1) {
            f *= (float)this.player.getMoodles().getMoodleLevel(MoodleType.Hypothermia);
        }
        return f;
    }

    public float getTimedActionTimeModifier() {
        float f = 1.0f;
        for (int i = 0; i < this.nodes.length; ++i) {
            ThermalNode thermalNode = this.nodes[i];
            float f2 = 0.0f;
            if (thermalNode.skinCelcius < 33.0f) {
                f2 = (thermalNode.skinCelcius - 20.0f) / 13.0f;
                f2 = 1.0f - f2;
                f2 *= f2;
            }
            float f3 = 0.25f * f2 * thermalNode.skinSurface;
            if (thermalNode.bodyPartType == BodyPartType.Hand_R || thermalNode.bodyPartType == BodyPartType.Hand_L) {
                f += 0.3f * f3;
                continue;
            }
            if (thermalNode.bodyPartType == BodyPartType.ForeArm_R || thermalNode.bodyPartType == BodyPartType.ForeArm_L) {
                f += 0.15f * f3;
                continue;
            }
            if (thermalNode.bodyPartType != BodyPartType.UpperArm_R && thermalNode.bodyPartType != BodyPartType.UpperArm_L) continue;
            f += 0.1f * f3;
        }
        return f;
    }

    public static float getSkinCelciusMin() {
        return 20.0f;
    }

    public static float getSkinCelciusFavorable() {
        return 33.0f;
    }

    public static float getSkinCelciusMax() {
        return 42.0f;
    }

    public void setMetabolicTarget(Metabolics metabolics) {
        this.setMetabolicTarget(metabolics.getMet());
    }

    public void setMetabolicTarget(float f) {
        if (f < 0.0f || f < this.metabolicTarget) {
            return;
        }
        this.metabolicTarget = f;
        if (this.metabolicTarget > Metabolics.MAX.getMet()) {
            this.metabolicTarget = Metabolics.MAX.getMet();
        }
    }

    private void updateCoreRateOfChange() {
        this.rateOfChangeCounter += GameTime.instance.getMultiplier();
        if (this.rateOfChangeCounter > 100.0f) {
            this.rateOfChangeCounter = 0.0f;
            this.coreRateOfChange = this.core.celcius - this.coreCelciusCache;
            this.thermalChevronUp = this.coreRateOfChange >= 0.0f;
            this.coreRateOfChange = PZMath.abs(this.coreRateOfChange);
            this.coreCelciusCache = this.core.celcius;
        }
    }

    public float getSimulationMultiplier() {
        return SIMULATION_MULTIPLIER;
    }

    public float getDefaultMultiplier() {
        return this.getSimulationMultiplier(Multiplier.Default);
    }

    public float getMetabolicRateIncMultiplier() {
        return this.getSimulationMultiplier(Multiplier.MetabolicRateInc);
    }

    public float getMetabolicRateDecMultiplier() {
        return this.getSimulationMultiplier(Multiplier.MetabolicRateDec);
    }

    public float getBodyHeatMultiplier() {
        return this.getSimulationMultiplier(Multiplier.BodyHeat);
    }

    public float getCoreHeatExpandMultiplier() {
        return this.getSimulationMultiplier(Multiplier.CoreHeatExpand);
    }

    public float getCoreHeatContractMultiplier() {
        return this.getSimulationMultiplier(Multiplier.CoreHeatContract);
    }

    public float getSkinCelciusMultiplier() {
        return this.getSimulationMultiplier(Multiplier.SkinCelcius);
    }

    public float getTemperatureAir() {
        return this.climate.getAirTemperatureForCharacter(this.character, false);
    }

    public float getTemperatureAirAndWind() {
        return this.climate.getAirTemperatureForCharacter(this.character, true);
    }

    public float getDbg_totalHeatRaw() {
        return this.totalHeatRaw;
    }

    public float getDbg_totalHeat() {
        return this.totalHeat;
    }

    public float getCoreCelcius() {
        return this.core != null ? this.core.celcius : 0.0f;
    }

    public float getDbg_primTotal() {
        return this.primTotal;
    }

    public float getDbg_secTotal() {
        return this.secTotal;
    }

    private float getSimulationMultiplier(Multiplier multiplier) {
        float f = GameTime.instance.getMultiplier();
        switch (multiplier) {
            case MetabolicRateInc: {
                f *= 0.001f;
                break;
            }
            case MetabolicRateDec: {
                f *= 4.0E-4f;
                break;
            }
            case BodyHeat: {
                f *= 2.5E-4f;
                break;
            }
            case CoreHeatExpand: {
                f *= 5.0E-5f;
                break;
            }
            case CoreHeatContract: {
                f *= 5.0E-4f;
                break;
            }
            case SkinCelcius: 
            case SkinCelciusExpand: {
                f *= 0.0025f;
                break;
            }
            case SkinCelciusContract: {
                f *= 0.005f;
                break;
            }
            case PrimaryDelta: {
                f *= 5.0E-4f;
                break;
            }
            case SecondaryDelta: {
                f *= 2.5E-4f;
                break;
            }
        }
        return f * SIMULATION_MULTIPLIER;
    }

    public float getThermalDamage() {
        return this.thermalDamage;
    }

    private void updateThermalDamage(float f) {
        this.damageCounter += GameTime.instance.getRealworldSecondsSinceLastUpdate();
        if (this.damageCounter > 1.0f) {
            this.damageCounter = 0.0f;
            if (this.player.getMoodles().getMoodleLevel(MoodleType.Hypothermia) == 4 && f < 0.0f && this.core.celcius - this.coreCelciusCache <= 0.0f) {
                float f2 = (this.core.celcius - 20.0f) / 5.0f;
                f2 = 1.0f - f2;
                float f3 = 120.0f;
                this.thermalDamage += 1.0f / (f3 += 480.0f * f2) * PZMath.clamp_01(PZMath.abs(f) / 10.0f);
            } else if (this.player.getMoodles().getMoodleLevel(MoodleType.Hyperthermia) == 4 && f > 37.0f && this.core.celcius - this.coreCelciusCache >= 0.0f) {
                float f4 = (this.core.celcius - 41.0f) / 1.0f;
                float f5 = 120.0f;
                this.thermalDamage += 1.0f / (f5 += 480.0f * f4) * PZMath.clamp_01((f - 37.0f) / 8.0f);
                this.thermalDamage = Math.min(this.thermalDamage, 0.3f);
            } else {
                this.thermalDamage -= 0.011111111f;
            }
            this.thermalDamage = PZMath.clamp_01(this.thermalDamage);
        }
        this.player.getBodyDamage().ColdDamageStage = this.thermalDamage;
    }

    public void update() {
        this.airTemperature = this.climate.getAirTemperatureForCharacter(this.character, false);
        this.airAndWindTemp = this.climate.getAirTemperatureForCharacter(this.character, true);
        this.externalAirTemperature = this.airTemperature;
        this.updateSetPoint();
        this.updateCoreRateOfChange();
        this.updateMetabolicRate();
        this.updateClothing();
        this.updateNodesHeatDelta();
        this.updateHeatDeltas();
        this.updateNodes();
        this.updateBodyMultipliers();
        this.updateThermalDamage(this.airAndWindTemp);
    }

    private float getSicknessValue() {
        return this.stats.getSickness();
    }

    private void updateSetPoint() {
        this.setPoint = 37.0f;
        if (this.stats.getSickness() > 0.0f) {
            float f = 2.0f;
            this.setPoint += this.stats.getSickness() * f;
        }
    }

    private void updateMetabolicRate() {
        float f;
        this.setMetabolicTarget(Metabolics.Default.getMet());
        if (this.player != null) {
            if (this.player.isAttacking()) {
                WeaponType weaponType = WeaponType.getWeaponType(this.player);
                switch (weaponType) {
                    case barehand: {
                        this.setMetabolicTarget(Metabolics.MediumWork);
                        break;
                    }
                    case twohanded: {
                        this.setMetabolicTarget(Metabolics.HeavyWork);
                        break;
                    }
                    case onehanded: {
                        this.setMetabolicTarget(Metabolics.MediumWork);
                        break;
                    }
                    case heavy: {
                        this.setMetabolicTarget(Metabolics.Running15kmh);
                        break;
                    }
                    case knife: {
                        this.setMetabolicTarget(Metabolics.LightWork);
                        break;
                    }
                    case spear: {
                        this.setMetabolicTarget(Metabolics.MediumWork);
                        break;
                    }
                    case handgun: {
                        this.setMetabolicTarget(Metabolics.UsingTools);
                        break;
                    }
                    case firearm: {
                        this.setMetabolicTarget(Metabolics.LightWork);
                        break;
                    }
                    case throwing: {
                        this.setMetabolicTarget(Metabolics.MediumWork);
                        break;
                    }
                    case chainsaw: {
                        this.setMetabolicTarget(Metabolics.Running15kmh);
                    }
                }
            }
            if (this.player.isPlayerMoving()) {
                if (this.player.isSprinting()) {
                    this.setMetabolicTarget(Metabolics.Running15kmh);
                } else if (this.player.isRunning()) {
                    this.setMetabolicTarget(Metabolics.Running10kmh);
                } else if (this.player.isSneaking()) {
                    this.setMetabolicTarget(Metabolics.Walking2kmh);
                } else if (this.player.CurrentSpeed > 0.0f) {
                    this.setMetabolicTarget(Metabolics.Walking5kmh);
                }
            }
        }
        float f2 = PZMath.clamp_01(1.0f - this.stats.getEndurance()) * Metabolics.DefaultExercise.getMet();
        this.setMetabolicTarget(f2 * this.getEnergy());
        float f3 = PZMath.clamp_01(this.player.getInventory().getCapacityWeight() / (float)this.player.getMaxWeight());
        float f4 = 1.0f + f3 * f3 * 0.35f;
        this.setMetabolicTarget(this.metabolicTarget * f4);
        if (!PZMath.equal(this.metabolicRate, this.metabolicTarget)) {
            f = this.metabolicTarget - this.metabolicRate;
            this.metabolicRate = this.metabolicTarget > this.metabolicRate ? (this.metabolicRate += f * this.getSimulationMultiplier(Multiplier.MetabolicRateInc)) : (this.metabolicRate += f * this.getSimulationMultiplier(Multiplier.MetabolicRateDec));
        }
        f = 1.0f;
        if (this.player.getMoodles().getMoodleLevel(MoodleType.Hypothermia) >= 1) {
            f = this.getMovementModifier();
        }
        this.metabolicRateReal = this.metabolicRate * (0.2f + 0.8f * this.getEnergy() * f);
        this.metabolicTarget = -1.0f;
    }

    private void updateNodesHeatDelta() {
        float f;
        float f2 = PZMath.clamp_01((float)((this.player.getNutrition().getWeight() / 75.0 - 0.5) * (double)0.666f));
        f2 = (f2 - 0.5f) * 2.0f;
        float f3 = this.stats.getFitness();
        float f4 = 1.0f;
        if (this.airAndWindTemp > this.setPoint - 2.0f) {
            if (this.airTemperature < this.setPoint + 2.0f) {
                f4 = (this.airTemperature - (this.setPoint - 2.0f)) / 4.0f;
                f4 = 1.0f - f4;
            } else {
                f4 = 0.0f;
            }
        }
        float f5 = 1.0f;
        if (this.climate.getHumidity() > 0.5f) {
            f = (this.climate.getHumidity() - 0.5f) * 2.0f;
            f5 -= f;
        }
        f = 1.0f;
        if (this.core.celcius < 37.0f) {
            f = (this.core.celcius - 20.0f) / 17.0f;
            f *= f;
        }
        float f6 = 0.0f;
        for (int i = 0; i < this.nodes.length; ++i) {
            float f7;
            float f8;
            float f9;
            ThermalNode thermalNode = this.nodes[i];
            thermalNode.calculateInsulation();
            float f10 = this.airTemperature;
            if (this.airAndWindTemp < this.airTemperature) {
                f10 -= (this.airTemperature - this.airAndWindTemp) / (1.0f + thermalNode.windresist);
            }
            f9 = (f9 = f10 - thermalNode.skinCelcius) <= 0.0f ? (f9 *= 1.0f + 0.75f * thermalNode.bodyWetness) : (f9 /= 1.0f + 3.0f * thermalNode.bodyWetness);
            f9 *= 0.3f;
            thermalNode.heatDelta = (f9 /= 1.0f + thermalNode.insulation) * thermalNode.skinSurface;
            if (thermalNode.primaryDelta > 0.0f) {
                f8 = 0.2f + 0.8f * this.getBodyFluids();
                f7 = Metabolics.Default.getMet() * thermalNode.primaryDelta * thermalNode.skinSurface / (1.0f + thermalNode.insulation);
                f7 *= f8 * (0.1f + 0.9f * f4);
                f7 *= f5;
                f7 *= 1.0f - 0.2f * f2;
                thermalNode.heatDelta -= (f7 *= 1.0f + 0.2f * f3);
            } else {
                f8 = 0.2f + 0.8f * this.getEnergy();
                f7 = Metabolics.Default.getMet() * PZMath.abs(thermalNode.primaryDelta) * thermalNode.skinSurface;
                f7 *= f8;
                f7 *= 1.0f + 0.2f * f2;
                thermalNode.heatDelta += (f7 *= 1.0f + 0.2f * f3);
            }
            if (thermalNode.secondaryDelta > 0.0f) {
                f8 = 0.1f + 0.9f * this.getBodyFluids();
                f7 = Metabolics.MAX.getMet() * 0.75f * thermalNode.secondaryDelta * thermalNode.skinSurface / (1.0f + thermalNode.insulation);
                f7 *= f8;
                f7 *= 0.85f + 0.15f * f5;
                f7 *= 1.0f - 0.2f * f2;
                thermalNode.heatDelta -= (f7 *= 1.0f + 0.2f * f3);
            } else {
                f8 = 0.1f + 0.9f * this.getEnergy();
                f7 = Metabolics.Default.getMet() * PZMath.abs(thermalNode.secondaryDelta) * thermalNode.skinSurface;
                f7 *= f8;
                f7 *= 1.0f + 0.2f * f2;
                thermalNode.heatDelta += (f7 *= 1.0f + 0.2f * f3);
            }
            f6 += thermalNode.heatDelta;
        }
        this.totalHeatRaw = f6;
        this.totalHeat = f6 += this.metabolicRateReal;
    }

    private void updateHeatDeltas() {
        this.coreHeatDelta = this.totalHeat * this.getSimulationMultiplier(Multiplier.BodyHeat);
        if (this.coreHeatDelta < 0.0f) {
            if (this.core.celcius > this.setPoint) {
                this.coreHeatDelta *= 1.0f + (this.core.celcius - this.setPoint) / 2.0f;
            }
        } else if (this.core.celcius < this.setPoint) {
            this.coreHeatDelta *= 1.0f + (this.setPoint - this.core.celcius) / 4.0f;
        }
        this.core.celcius += this.coreHeatDelta;
        this.core.celcius = PZMath.clamp(this.core.celcius, 20.0f, 42.0f);
        this.bodyDamage.setTemperature(this.core.celcius);
        this.bodyHeatDelta = 0.0f;
        if (this.core.celcius > this.setPoint) {
            this.bodyHeatDelta = this.core.celcius - this.setPoint;
        } else if (this.core.celcius < this.setPoint) {
            this.bodyHeatDelta = this.core.celcius - this.setPoint;
        }
        if (this.bodyHeatDelta < 0.0f) {
            float f = PZMath.abs(this.bodyHeatDelta);
            if (f <= 1.0f) {
                this.bodyHeatDelta *= 0.8f;
            } else {
                f = PZMath.clamp(f, 1.0f, 11.0f) - 1.0f;
                this.bodyHeatDelta = -0.8f + -0.2f * (f /= 10.0f);
            }
        }
        this.bodyHeatDelta = PZMath.clamp(this.bodyHeatDelta, -1.0f, 1.0f);
    }

    private void updateNodes() {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < this.nodes.length; ++i) {
            float f3;
            float f4;
            float f5;
            float f6;
            ThermalNode thermalNode = this.nodes[i];
            float f7 = 1.0f + thermalNode.insulation;
            float f8 = this.metabolicRateReal / Metabolics.MAX.getMet();
            f8 *= f8;
            if (this.bodyHeatDelta < 0.0f) {
                f6 = thermalNode.distToCore;
                thermalNode.primaryDelta = this.bodyHeatDelta * (1.0f + f6);
            } else {
                thermalNode.primaryDelta = this.bodyHeatDelta * (1.0f + (1.0f - thermalNode.distToCore));
            }
            thermalNode.primaryDelta = PZMath.clamp(thermalNode.primaryDelta, -1.0f, 1.0f);
            thermalNode.secondaryDelta = thermalNode.primaryDelta * PZMath.abs(thermalNode.primaryDelta) * PZMath.abs(thermalNode.primaryDelta);
            f += thermalNode.primaryDelta * thermalNode.skinSurface;
            f2 += thermalNode.secondaryDelta * thermalNode.skinSurface;
            if (this.stats.getDrunkenness() > 0.0f) {
                thermalNode.primaryDelta += this.stats.getDrunkenness() * 0.02f;
            }
            thermalNode.primaryDelta = PZMath.clamp(thermalNode.primaryDelta, -1.0f, 1.0f);
            f6 = this.core.celcius - 20.0f;
            float f9 = this.core.celcius;
            if (f6 < this.airTemperature) {
                if (this.airTemperature < 33.0f) {
                    f6 = this.airTemperature;
                } else {
                    f5 = 0.4f + 0.6f * (1.0f - thermalNode.distToCore);
                    f4 = (this.airTemperature - 33.0f) / 6.0f;
                    f6 = 33.0f;
                    f6 += 4.0f * f4 * f5;
                    if ((f6 = PZMath.clamp(f6, 33.0f, this.airTemperature)) > f9) {
                        f6 = f9 - 0.25f;
                    }
                }
            }
            f5 = this.core.celcius - 4.0f;
            if (thermalNode.primaryDelta < 0.0f) {
                f4 = 0.4f + 0.6f * thermalNode.distToCore;
                f3 = f5 - 12.0f * f4 / f7;
                f5 = PZMath.c_lerp(f5, f3, PZMath.abs(thermalNode.primaryDelta));
            } else {
                f4 = 0.4f + 0.6f * (1.0f - thermalNode.distToCore);
                f3 = f5;
                float f10 = 4.0f * f4;
                f3 = Math.min(f3 + (f10 *= Math.max(f7 * 0.5f * f4, 1.0f)), f9);
                f5 = PZMath.c_lerp(f5, f3, thermalNode.primaryDelta);
            }
            f5 = PZMath.clamp(f5, f6, f9);
            f4 = f5 - thermalNode.skinCelcius;
            f3 = this.getSimulationMultiplier(Multiplier.SkinCelcius);
            if (f4 < 0.0f && thermalNode.skinCelcius > 33.0f) {
                f3 *= 3.0f;
            } else if (f4 > 0.0f && thermalNode.skinCelcius < 33.0f) {
                f3 *= 3.0f;
            }
            if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            thermalNode.skinCelcius += f4 * f3;
            if (thermalNode == this.core) continue;
            thermalNode.celcius = thermalNode.skinCelcius >= this.core.celcius ? this.core.celcius : PZMath.lerp(thermalNode.skinCelcius, this.core.celcius, 0.5f);
        }
        this.primTotal = f;
        this.secTotal = f2;
    }

    private void updateBodyMultipliers() {
        this.energyMultiplier = 1.0;
        this.fluidsMultiplier = 1.0;
        this.fatigueMultiplier = 1.0;
        float f = PZMath.abs(this.primTotal);
        f *= f;
        if (this.primTotal < 0.0f) {
            this.energyMultiplier += (double)(0.05f * f);
            this.fatigueMultiplier += (double)(0.25f * f);
        } else if (this.primTotal > 0.0f) {
            this.fluidsMultiplier += (double)(0.25f * f);
            this.fatigueMultiplier += (double)(0.25f * f);
        }
        f = PZMath.abs(this.secTotal);
        f *= f;
        if (this.secTotal < 0.0f) {
            this.energyMultiplier += (double)(0.1f * f);
            this.fatigueMultiplier += (double)(0.75f * f);
        } else if (this.secTotal > 0.0f) {
            this.fluidsMultiplier += (double)(3.75f * f);
            this.fatigueMultiplier += (double)(1.75f * f);
        }
    }

    private void updateClothing() {
        int n;
        boolean bl;
        this.character.getItemVisuals(itemVisuals);
        boolean bl2 = bl = itemVisuals.size() != itemVisualsCache.size();
        if (!bl) {
            for (n = 0; n < itemVisuals.size(); ++n) {
                if (n < itemVisualsCache.size() && itemVisuals.get(n) == itemVisualsCache.get(n)) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            for (n = 0; n < this.nodes.length; ++n) {
                this.nodes[n].clothing.clear();
            }
            itemVisualsCache.clear();
            for (n = 0; n < itemVisuals.size(); ++n) {
                Clothing clothing;
                ItemVisual itemVisual = (ItemVisual)itemVisuals.get(n);
                InventoryItem inventoryItem = itemVisual.getInventoryItem();
                itemVisualsCache.add(itemVisual);
                if (!(inventoryItem instanceof Clothing) || !((clothing = (Clothing)inventoryItem).getInsulation() > 0.0f) && !(clothing.getWindresistance() > 0.0f)) continue;
                boolean bl3 = false;
                ArrayList<BloodClothingType> arrayList = inventoryItem.getBloodClothingType();
                if (arrayList != null) {
                    coveredParts.clear();
                    BloodClothingType.getCoveredParts(arrayList, coveredParts);
                    for (int i = 0; i < coveredParts.size(); ++i) {
                        BloodBodyPartType bloodBodyPartType = coveredParts.get(i);
                        if (bloodBodyPartType.index() < 0 || bloodBodyPartType.index() >= this.nodes.length) continue;
                        bl3 = true;
                        this.nodes[bloodBodyPartType.index()].clothing.add(clothing);
                    }
                }
                if (bl3 || clothing.getBodyLocation() == null) continue;
                switch (clothing.getBodyLocation().toLowerCase()) {
                    case "hat": 
                    case "mask": {
                        this.nodes[BodyPartType.ToIndex((BodyPartType)BodyPartType.Head)].clothing.add(clothing);
                    }
                }
            }
        }
    }

    public float getEnergy() {
        float f = 1.0f - (0.4f * this.stats.getHunger() + 0.6f * this.stats.getHunger() * this.stats.getHunger());
        float f2 = 1.0f - (0.4f * this.stats.getFatigue() + 0.6f * this.stats.getFatigue() * this.stats.getFatigue());
        return 0.6f * f + 0.4f * f2;
    }

    public float getBodyFluids() {
        return 1.0f - this.stats.getThirst();
    }

    public class ThermalNode {
        private final float distToCore;
        private final float skinSurface;
        private final BodyPartType bodyPartType;
        private final BloodBodyPartType bloodBPT;
        private final BodyPart bodyPart;
        private final boolean isCore;
        private final float insulationLayerMultiplierUI;
        private ThermalNode upstream;
        private ThermalNode[] downstream;
        private float insulation;
        private float windresist;
        private float celcius = 37.0f;
        private float skinCelcius = 33.0f;
        private float heatDelta = 0.0f;
        private float primaryDelta = 0.0f;
        private float secondaryDelta = 0.0f;
        private float clothingWetness = 0.0f;
        private float bodyWetness = 0.0f;
        private ArrayList<Clothing> clothing = new ArrayList();

        public ThermalNode(float f, BodyPart bodyPart, float f2) {
            this(false, f, bodyPart, f2);
        }

        public ThermalNode(boolean bl, float f, BodyPart bodyPart, float f2) {
            this.isCore = bl;
            this.celcius = f;
            this.distToCore = BodyPartType.GetDistToCore(bodyPart.Type);
            this.skinSurface = BodyPartType.GetSkinSurface(bodyPart.Type);
            this.bodyPartType = bodyPart.Type;
            this.bloodBPT = BloodBodyPartType.FromIndex(BodyPartType.ToIndex(bodyPart.Type));
            this.bodyPart = bodyPart;
            this.insulationLayerMultiplierUI = f2;
        }

        private void calculateInsulation() {
            int n = this.clothing.size();
            this.insulation = 0.0f;
            this.windresist = 0.0f;
            this.clothingWetness = 0.0f;
            this.bodyWetness = this.bodyPart != null ? this.bodyPart.getWetness() * 0.01f : 0.0f;
            this.bodyWetness = PZMath.clamp_01(this.bodyWetness);
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    boolean bl;
                    Clothing clothing = this.clothing.get(i);
                    ItemVisual itemVisual = clothing.getVisual();
                    float f = PZMath.clamp(clothing.getWetness() * 0.01f, 0.0f, 1.0f);
                    this.clothingWetness += f;
                    boolean bl2 = bl = itemVisual.getHole(this.bloodBPT) > 0.0f;
                    if (bl) continue;
                    float f2 = Temperature.getTrueInsulationValue(clothing.getInsulation());
                    float f3 = Temperature.getTrueWindresistanceValue(clothing.getWindresistance());
                    float f4 = PZMath.clamp(clothing.getCurrentCondition() * 0.01f, 0.0f, 1.0f);
                    f4 = 0.5f + 0.5f * f4;
                    this.insulation += (f2 *= (1.0f - f * 0.75f) * f4);
                    this.windresist += (f3 *= (1.0f - f * 0.45f) * f4);
                }
                this.clothingWetness /= (float)n;
                this.insulation += (float)n * 0.05f;
                this.windresist += (float)n * 0.05f;
            }
        }

        public String getName() {
            return this.bodyPartType.toString();
        }

        public boolean hasUpstream() {
            return this.upstream != null;
        }

        public boolean hasDownstream() {
            return this.downstream != null && this.downstream.length > 0;
        }

        public float getDistToCore() {
            return this.distToCore;
        }

        public float getSkinSurface() {
            return this.skinSurface;
        }

        public boolean isCore() {
            return this.isCore;
        }

        public float getInsulation() {
            return this.insulation;
        }

        public float getWindresist() {
            return this.windresist;
        }

        public float getCelcius() {
            return this.celcius;
        }

        public float getSkinCelcius() {
            return this.skinCelcius;
        }

        public float getHeatDelta() {
            return this.heatDelta;
        }

        public float getPrimaryDelta() {
            return this.primaryDelta;
        }

        public float getSecondaryDelta() {
            return this.secondaryDelta;
        }

        public float getClothingWetness() {
            return this.clothingWetness;
        }

        public float getBodyWetness() {
            return this.bodyWetness;
        }

        public float getBodyResponse() {
            return PZMath.lerp(this.primaryDelta, this.secondaryDelta, 0.5f);
        }

        public float getSkinCelciusUI() {
            float f = PZMath.clamp(this.getSkinCelcius(), 20.0f, 42.0f);
            f = f < 33.0f ? (f - 20.0f) / 13.0f * 0.5f : 0.5f + (f - 33.0f) / 9.0f;
            return f;
        }

        public float getHeatDeltaUI() {
            return PZMath.clamp((this.heatDelta * 0.2f + 1.0f) / 2.0f, 0.0f, 1.0f);
        }

        public float getPrimaryDeltaUI() {
            return PZMath.clamp((this.primaryDelta + 1.0f) / 2.0f, 0.0f, 1.0f);
        }

        public float getSecondaryDeltaUI() {
            return PZMath.clamp((this.secondaryDelta + 1.0f) / 2.0f, 0.0f, 1.0f);
        }

        public float getInsulationUI() {
            return PZMath.clamp(this.insulation * this.insulationLayerMultiplierUI, 0.0f, 1.0f);
        }

        public float getWindresistUI() {
            return PZMath.clamp(this.windresist * this.insulationLayerMultiplierUI, 0.0f, 1.0f);
        }

        public float getClothingWetnessUI() {
            return PZMath.clamp(this.clothingWetness, 0.0f, 1.0f);
        }

        public float getBodyWetnessUI() {
            return PZMath.clamp(this.bodyWetness, 0.0f, 1.0f);
        }

        public float getBodyResponseUI() {
            return PZMath.clamp((this.getBodyResponse() + 1.0f) / 2.0f, 0.0f, 1.0f);
        }
    }

    private static enum Multiplier {
        Default,
        MetabolicRateInc,
        MetabolicRateDec,
        BodyHeat,
        CoreHeatExpand,
        CoreHeatContract,
        SkinCelcius,
        SkinCelciusContract,
        SkinCelciusExpand,
        PrimaryDelta,
        SecondaryDelta;

    }
}

