/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.BodyDamage;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.krka.kahlua.j2se.KahluaTableImpl;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaManager;
import zombie.characters.BodyDamage.BodyPart;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.characters.BodyDamage.Metabolics;
import zombie.characters.IsoGameCharacter;
import zombie.characters.Moodles.MoodleType;
import zombie.characters.skills.PerkFactory;
import zombie.core.Rand;

public final class Fitness {
    private IsoGameCharacter parent = null;
    private HashMap<String, Float> regularityMap = new HashMap();
    private int fitnessLvl = 0;
    private int strLvl = 0;
    private final HashMap<String, Integer> stiffnessTimerMap = new HashMap();
    private final HashMap<String, Float> stiffnessIncMap = new HashMap();
    private final ArrayList<String> bodypartToIncStiffness = new ArrayList();
    private final HashMap<String, FitnessExercise> exercises = new HashMap();
    private final HashMap<String, Long> exeTimer = new HashMap();
    private int lastUpdate = -1;
    private FitnessExercise currentExe;
    private static final int HOURS_FOR_STIFFNESS = 12;
    private static final float BASE_STIFFNESS_INC = 0.5f;
    private static final float BASE_ENDURANCE_RED = 0.015f;
    private static final float BASE_REGULARITY_INC = 0.08f;
    private static final float BASE_REGULARITY_DEC = 0.002f;
    private static final float BASE_PAIN_INC = 2.5f;

    public Fitness(IsoGameCharacter isoGameCharacter) {
        this.setParent(isoGameCharacter);
    }

    public void update() {
        int n = GameTime.getInstance().getMinutes() / 10;
        if (this.lastUpdate == -1) {
            this.lastUpdate = n;
        }
        if (n != this.lastUpdate) {
            int n2;
            Number number;
            Object object;
            this.lastUpdate = n;
            ArrayList<String> arrayList = new ArrayList<String>();
            this.decreaseRegularity();
            for (String string : this.stiffnessTimerMap.keySet()) {
                object = this.stiffnessTimerMap.get(string);
                number = object;
                object = (Integer)object - 1;
                if ((Integer)object <= 0) {
                    arrayList.add(string);
                    this.bodypartToIncStiffness.add(string);
                    continue;
                }
                this.stiffnessTimerMap.put(string, (Integer)object);
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                this.stiffnessTimerMap.remove(arrayList.get(n2));
            }
            for (n2 = 0; n2 < this.bodypartToIncStiffness.size(); ++n2) {
                object = this.bodypartToIncStiffness.get(n2);
                number = this.stiffnessIncMap.get(object);
                if (number == null) {
                    return;
                }
                Number number2 = number;
                number = Float.valueOf(((Float)number).floatValue() - 1.0f);
                this.increasePain((String)object);
                if (((Float)number).floatValue() <= 0.0f) {
                    this.bodypartToIncStiffness.remove(n2);
                    this.stiffnessIncMap.remove(object);
                    --n2;
                    continue;
                }
                this.stiffnessIncMap.put((String)object, (Float)number);
            }
        }
    }

    private void decreaseRegularity() {
        for (String string : this.regularityMap.keySet()) {
            if (!this.exeTimer.containsKey(string) || GameTime.getInstance().getCalender().getTimeInMillis() - this.exeTimer.get(string) <= 86400000L) continue;
            float f = this.regularityMap.get(string).floatValue();
            this.regularityMap.put(string, Float.valueOf(f -= 0.002f));
        }
    }

    private void increasePain(String string) {
        BodyPart bodyPart;
        int n;
        if ("arms".equals(string)) {
            for (n = BodyPartType.ForeArm_L.index(); n < BodyPartType.UpperArm_R.index() + 1; ++n) {
                bodyPart = this.parent.getBodyDamage().getBodyPart(BodyPartType.FromIndex(n));
                bodyPart.setStiffness(bodyPart.getStiffness() + 2.5f);
            }
        }
        if ("legs".equals(string)) {
            for (n = BodyPartType.UpperLeg_L.index(); n < BodyPartType.LowerLeg_R.index() + 1; ++n) {
                bodyPart = this.parent.getBodyDamage().getBodyPart(BodyPartType.FromIndex(n));
                bodyPart.setStiffness(bodyPart.getStiffness() + 2.5f);
            }
        }
        if ("chest".equals(string)) {
            BodyPart bodyPart2 = this.parent.getBodyDamage().getBodyPart(BodyPartType.Torso_Upper);
            bodyPart2.setStiffness(bodyPart2.getStiffness() + 2.5f);
        }
        if ("abs".equals(string)) {
            BodyPart bodyPart3 = this.parent.getBodyDamage().getBodyPart(BodyPartType.Torso_Lower);
            bodyPart3.setStiffness(bodyPart3.getStiffness() + 2.5f);
        }
    }

    public void setCurrentExercise(String string) {
        this.currentExe = this.exercises.get(string);
    }

    public void exerciseRepeat() {
        this.fitnessLvl = this.parent.getPerkLevel(PerkFactory.Perks.Fitness);
        this.strLvl = this.parent.getPerkLevel(PerkFactory.Perks.Strength);
        this.incRegularity();
        this.reduceEndurance();
        this.incFutureStiffness();
        this.incStats();
        this.updateExeTimer();
    }

    private void updateExeTimer() {
        this.exeTimer.put(this.currentExe.type, GameTime.getInstance().getCalender().getTimeInMillis());
    }

    public void incRegularity() {
        float f = 0.08f;
        int n = 4;
        double d = Math.log((float)this.fitnessLvl / 5.0f + (float)n);
        f = (float)((double)f * (Math.log(n + 1) / d));
        Float f2 = this.regularityMap.get(this.currentExe.type);
        if (f2 == null) {
            f2 = Float.valueOf(0.0f);
        }
        f2 = Float.valueOf(f2.floatValue() + f);
        f2 = Float.valueOf(Math.min(Math.max(f2.floatValue(), 0.0f), 100.0f));
        this.regularityMap.put(this.currentExe.type, f2);
    }

    public void reduceEndurance() {
        float f = 0.015f;
        Float f2 = this.regularityMap.get(this.currentExe.type);
        if (f2 == null) {
            f2 = Float.valueOf(0.0f);
        }
        int n = 50;
        double d = Math.log(f2.floatValue() / 50.0f + (float)n);
        f = (float)((double)f * (d / Math.log(n + 1)));
        if (this.currentExe.metabolics == Metabolics.FitnessHeavy) {
            f *= 1.3f;
        }
        this.parent.getStats().setEndurance(this.parent.getStats().getEndurance() - (f *= (float)(1 + this.parent.getMoodles().getMoodleLevel(MoodleType.HeavyLoad) / 3)));
    }

    public void incFutureStiffness() {
        Float f = this.regularityMap.get(this.currentExe.type);
        if (f == null) {
            f = Float.valueOf(0.0f);
        }
        for (int i = 0; i < this.currentExe.stiffnessInc.size(); ++i) {
            Float f2;
            float f3 = 0.5f;
            String string = this.currentExe.stiffnessInc.get(i);
            if (!this.stiffnessTimerMap.containsKey(string) && !this.bodypartToIncStiffness.contains(string)) {
                this.stiffnessTimerMap.put(string, 72);
            }
            if ((f2 = this.stiffnessIncMap.get(string)) == null) {
                f2 = Float.valueOf(0.0f);
            }
            f3 *= (120.0f - f.floatValue()) / 170.0f;
            if (this.currentExe.metabolics == Metabolics.FitnessHeavy) {
                f3 *= 1.3f;
            }
            f2 = Float.valueOf(f2.floatValue() + (f3 *= (float)(1 + this.parent.getMoodles().getMoodleLevel(MoodleType.Tired) / 3)));
            f2 = Float.valueOf(Math.min(f2.floatValue(), 150.0f));
            this.stiffnessIncMap.put(string, f2);
        }
    }

    public void incStats() {
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < this.currentExe.stiffnessInc.size(); ++i) {
            String string = this.currentExe.stiffnessInc.get(i);
            if ("arms".equals(string)) {
                f += 4.0f;
            }
            if ("chest".equals(string)) {
                f += 2.0f;
            }
            if ("legs".equals(string)) {
                f2 += 4.0f;
            }
            if (!"abs".equals(string)) continue;
            f2 += 2.0f;
        }
        if (this.strLvl > 5) {
            f *= (float)(1 + (this.strLvl - 5) / 10);
        }
        if (this.fitnessLvl > 5) {
            f2 *= (float)(1 + (this.fitnessLvl - 5) / 10);
        }
        this.parent.getXp().AddXP(PerkFactory.Perks.Strength, f *= this.currentExe.xpModifier);
        this.parent.getXp().AddXP(PerkFactory.Perks.Fitness, f2 *= this.currentExe.xpModifier);
    }

    public void resetValues() {
        this.stiffnessIncMap.clear();
        this.stiffnessTimerMap.clear();
        this.regularityMap.clear();
    }

    public void removeStiffnessValue(String string) {
        this.stiffnessIncMap.remove(string);
        this.stiffnessTimerMap.remove(string);
    }

    public void save(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.stiffnessIncMap.size());
        for (String string : this.stiffnessIncMap.keySet()) {
            GameWindow.WriteString(byteBuffer, string);
            byteBuffer.putFloat(this.stiffnessIncMap.get(string).floatValue());
        }
        byteBuffer.putInt(this.stiffnessTimerMap.size());
        for (String string : this.stiffnessTimerMap.keySet()) {
            GameWindow.WriteString(byteBuffer, string);
            byteBuffer.putInt(this.stiffnessTimerMap.get(string));
        }
        byteBuffer.putInt(this.regularityMap.size());
        for (String string : this.regularityMap.keySet()) {
            GameWindow.WriteString(byteBuffer, string);
            byteBuffer.putFloat(this.regularityMap.get(string).floatValue());
        }
        byteBuffer.putInt(this.bodypartToIncStiffness.size());
        for (int i = 0; i < this.bodypartToIncStiffness.size(); ++i) {
            GameWindow.WriteString(byteBuffer, this.bodypartToIncStiffness.get(i));
        }
        byteBuffer.putInt(this.exeTimer.size());
        for (String string : this.exeTimer.keySet()) {
            GameWindow.WriteString(byteBuffer, string);
            byteBuffer.putLong(this.exeTimer.get(string));
        }
    }

    public void load(ByteBuffer byteBuffer, int n) {
        int n2;
        if (n < 167) {
            return;
        }
        int n3 = byteBuffer.getInt();
        if (n3 > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                this.stiffnessIncMap.put(GameWindow.ReadString(byteBuffer), Float.valueOf(byteBuffer.getFloat()));
            }
        }
        if ((n3 = byteBuffer.getInt()) > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                this.stiffnessTimerMap.put(GameWindow.ReadString(byteBuffer), byteBuffer.getInt());
            }
        }
        if ((n3 = byteBuffer.getInt()) > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                this.regularityMap.put(GameWindow.ReadString(byteBuffer), Float.valueOf(byteBuffer.getFloat()));
            }
        }
        if ((n3 = byteBuffer.getInt()) > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                this.bodypartToIncStiffness.add(GameWindow.ReadString(byteBuffer));
            }
        }
        if (n < 169) {
            return;
        }
        n3 = byteBuffer.getInt();
        if (n3 > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                this.exeTimer.put(GameWindow.ReadString(byteBuffer), byteBuffer.getLong());
            }
        }
    }

    public boolean onGoingStiffness() {
        return !this.bodypartToIncStiffness.isEmpty();
    }

    public int getCurrentExeStiffnessTimer(String string) {
        return this.stiffnessTimerMap.get(string = string.split(",")[0]) != null ? this.stiffnessTimerMap.get(string) : 0;
    }

    public float getCurrentExeStiffnessInc(String string) {
        return this.stiffnessIncMap.get(string = string.split(",")[0]) != null ? this.stiffnessIncMap.get(string).floatValue() : 0.0f;
    }

    public IsoGameCharacter getParent() {
        return this.parent;
    }

    public void setParent(IsoGameCharacter isoGameCharacter) {
        this.parent = isoGameCharacter;
    }

    public float getRegularity(String string) {
        Float f = this.regularityMap.get(string);
        if (f == null) {
            f = Float.valueOf(0.0f);
        }
        return f.floatValue();
    }

    public HashMap<String, Float> getRegularityMap() {
        return this.regularityMap;
    }

    public void setRegularityMap(HashMap<String, Float> hashMap) {
        this.regularityMap = hashMap;
    }

    public void init() {
        if (!this.exercises.isEmpty()) {
            return;
        }
        KahluaTableImpl kahluaTableImpl = (KahluaTableImpl)LuaManager.env.rawget((Object)"FitnessExercises");
        KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)kahluaTableImpl.rawget((Object)"exercisesType");
        for (Map.Entry entry : kahluaTableImpl2.delegate.entrySet()) {
            this.exercises.put((String)entry.getKey(), new FitnessExercise((KahluaTableImpl)entry.getValue()));
        }
        this.initRegularityMapProfession();
    }

    public void initRegularityMapProfession() {
        if (!this.regularityMap.isEmpty()) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.parent.getDescriptor().getProfession().equals("fitnessInstructor")) {
            bl2 = true;
        }
        if (this.parent.getDescriptor().getProfession().equals("fireofficer")) {
            bl = true;
        }
        if (this.parent.getDescriptor().getProfession().equals("securityguard")) {
            bl3 = true;
        }
        if (!(bl || bl2 || bl3)) {
            return;
        }
        Iterator<String> iterator = this.exercises.keySet().iterator();
        while (iterator.hasNext()) {
            float f = Rand.Next(7, 12);
            if (bl) {
                f = Rand.Next(10, 20);
            }
            if (bl2) {
                f = Rand.Next(40, 60);
            }
            this.regularityMap.put(iterator.next(), Float.valueOf(f));
        }
    }

    public static final class FitnessExercise {
        String type = null;
        Metabolics metabolics = null;
        ArrayList<String> stiffnessInc = null;
        float xpModifier = 1.0f;

        public FitnessExercise(KahluaTableImpl kahluaTableImpl) {
            this.type = kahluaTableImpl.rawgetStr((Object)"type");
            this.metabolics = (Metabolics)((Object)kahluaTableImpl.rawget((Object)"metabolics"));
            this.stiffnessInc = new ArrayList<String>(Arrays.asList(kahluaTableImpl.rawgetStr((Object)"stiffness").split(",")));
            if (kahluaTableImpl.rawgetFloat((Object)"xpMod") > 0.0f) {
                this.xpModifier = kahluaTableImpl.rawgetFloat((Object)"xpMod");
            }
        }
    }
}

