/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.BodyDamage;

import zombie.core.Translator;
import zombie.core.skinnedmodel.population.OutfitRNG;
import zombie.debug.DebugLog;

public enum BodyPartType {
    Hand_L,
    Hand_R,
    ForeArm_L,
    ForeArm_R,
    UpperArm_L,
    UpperArm_R,
    Torso_Upper,
    Torso_Lower,
    Head,
    Neck,
    Groin,
    UpperLeg_L,
    UpperLeg_R,
    LowerLeg_L,
    LowerLeg_R,
    Foot_L,
    Foot_R,
    MAX;


    public static BodyPartType FromIndex(int n) {
        switch (n) {
            case 0: {
                return Hand_L;
            }
            case 1: {
                return Hand_R;
            }
            case 2: {
                return ForeArm_L;
            }
            case 3: {
                return ForeArm_R;
            }
            case 4: {
                return UpperArm_L;
            }
            case 5: {
                return UpperArm_R;
            }
            case 6: {
                return Torso_Upper;
            }
            case 7: {
                return Torso_Lower;
            }
            case 8: {
                return Head;
            }
            case 9: {
                return Neck;
            }
            case 10: {
                return Groin;
            }
            case 11: {
                return UpperLeg_L;
            }
            case 12: {
                return UpperLeg_R;
            }
            case 13: {
                return LowerLeg_L;
            }
            case 14: {
                return LowerLeg_R;
            }
            case 15: {
                return Foot_L;
            }
            case 16: {
                return Foot_R;
            }
        }
        return MAX;
    }

    public int index() {
        return BodyPartType.ToIndex(this);
    }

    public static BodyPartType FromString(String string) {
        if (string.equals("Hand_L")) {
            return Hand_L;
        }
        if (string.equals("Hand_R")) {
            return Hand_R;
        }
        if (string.equals("ForeArm_L")) {
            return ForeArm_L;
        }
        if (string.equals("ForeArm_R")) {
            return ForeArm_R;
        }
        if (string.equals("UpperArm_L")) {
            return UpperArm_L;
        }
        if (string.equals("UpperArm_R")) {
            return UpperArm_R;
        }
        if (string.equals("Torso_Upper")) {
            return Torso_Upper;
        }
        if (string.equals("Torso_Lower")) {
            return Torso_Lower;
        }
        if (string.equals("Head")) {
            return Head;
        }
        if (string.equals("Neck")) {
            return Neck;
        }
        if (string.equals("Groin")) {
            return Groin;
        }
        if (string.equals("UpperLeg_L")) {
            return UpperLeg_L;
        }
        if (string.equals("UpperLeg_R")) {
            return UpperLeg_R;
        }
        if (string.equals("LowerLeg_L")) {
            return LowerLeg_L;
        }
        if (string.equals("LowerLeg_R")) {
            return LowerLeg_R;
        }
        if (string.equals("Foot_L")) {
            return Foot_L;
        }
        if (string.equals("Foot_R")) {
            return Foot_R;
        }
        return MAX;
    }

    public static float getPainModifyer(int n) {
        switch (n) {
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 0.5f;
            }
            case 2: {
                return 0.6f;
            }
            case 3: {
                return 0.6f;
            }
            case 4: {
                return 0.6f;
            }
            case 5: {
                return 0.6f;
            }
            case 6: {
                return 0.7f;
            }
            case 7: {
                return 0.78f;
            }
            case 8: {
                return 0.8f;
            }
            case 9: {
                return 0.8f;
            }
            case 10: {
                return 0.7f;
            }
            case 11: {
                return 0.7f;
            }
            case 12: {
                return 0.7f;
            }
            case 13: {
                return 0.6f;
            }
            case 14: {
                return 0.6f;
            }
            case 15: {
                return 0.5f;
            }
            case 16: {
                return 0.5f;
            }
        }
        return 1.0f;
    }

    public static String getDisplayName(BodyPartType bodyPartType) {
        if (bodyPartType == Hand_L) {
            return Translator.getText("IGUI_health_Left_Hand");
        }
        if (bodyPartType == Hand_R) {
            return Translator.getText("IGUI_health_Right_Hand");
        }
        if (bodyPartType == ForeArm_L) {
            return Translator.getText("IGUI_health_Left_Forearm");
        }
        if (bodyPartType == ForeArm_R) {
            return Translator.getText("IGUI_health_Right_Forearm");
        }
        if (bodyPartType == UpperArm_L) {
            return Translator.getText("IGUI_health_Left_Upper_Arm");
        }
        if (bodyPartType == UpperArm_R) {
            return Translator.getText("IGUI_health_Right_Upper_Arm");
        }
        if (bodyPartType == Torso_Upper) {
            return Translator.getText("IGUI_health_Upper_Torso");
        }
        if (bodyPartType == Torso_Lower) {
            return Translator.getText("IGUI_health_Lower_Torso");
        }
        if (bodyPartType == Head) {
            return Translator.getText("IGUI_health_Head");
        }
        if (bodyPartType == Neck) {
            return Translator.getText("IGUI_health_Neck");
        }
        if (bodyPartType == Groin) {
            return Translator.getText("IGUI_health_Groin");
        }
        if (bodyPartType == UpperLeg_L) {
            return Translator.getText("IGUI_health_Left_Thigh");
        }
        if (bodyPartType == UpperLeg_R) {
            return Translator.getText("IGUI_health_Right_Thigh");
        }
        if (bodyPartType == LowerLeg_L) {
            return Translator.getText("IGUI_health_Left_Shin");
        }
        if (bodyPartType == LowerLeg_R) {
            return Translator.getText("IGUI_health_Right_Shin");
        }
        if (bodyPartType == Foot_L) {
            return Translator.getText("IGUI_health_Left_Foot");
        }
        if (bodyPartType == Foot_R) {
            return Translator.getText("IGUI_health_Right_Foot");
        }
        return Translator.getText("IGUI_health_Unknown_Body_Part");
    }

    public static int ToIndex(BodyPartType bodyPartType) {
        if (bodyPartType == null) {
            return 0;
        }
        switch (bodyPartType) {
            case Hand_L: {
                return 0;
            }
            case Hand_R: {
                return 1;
            }
            case ForeArm_L: {
                return 2;
            }
            case ForeArm_R: {
                return 3;
            }
            case UpperArm_L: {
                return 4;
            }
            case UpperArm_R: {
                return 5;
            }
            case Torso_Upper: {
                return 6;
            }
            case Torso_Lower: {
                return 7;
            }
            case Head: {
                return 8;
            }
            case Neck: {
                return 9;
            }
            case Groin: {
                return 10;
            }
            case UpperLeg_L: {
                return 11;
            }
            case UpperLeg_R: {
                return 12;
            }
            case LowerLeg_L: {
                return 13;
            }
            case LowerLeg_R: {
                return 14;
            }
            case Foot_L: {
                return 15;
            }
            case Foot_R: {
                return 16;
            }
            case MAX: {
                return 17;
            }
        }
        return 17;
    }

    public static String ToString(BodyPartType bodyPartType) {
        if (bodyPartType == Hand_L) {
            return "Hand_L";
        }
        if (bodyPartType == Hand_R) {
            return "Hand_R";
        }
        if (bodyPartType == ForeArm_L) {
            return "ForeArm_L";
        }
        if (bodyPartType == ForeArm_R) {
            return "ForeArm_R";
        }
        if (bodyPartType == UpperArm_L) {
            return "UpperArm_L";
        }
        if (bodyPartType == UpperArm_R) {
            return "UpperArm_R";
        }
        if (bodyPartType == Torso_Upper) {
            return "Torso_Upper";
        }
        if (bodyPartType == Torso_Lower) {
            return "Torso_Lower";
        }
        if (bodyPartType == Head) {
            return "Head";
        }
        if (bodyPartType == Neck) {
            return "Neck";
        }
        if (bodyPartType == Groin) {
            return "Groin";
        }
        if (bodyPartType == UpperLeg_L) {
            return "UpperLeg_L";
        }
        if (bodyPartType == UpperLeg_R) {
            return "UpperLeg_R";
        }
        if (bodyPartType == LowerLeg_L) {
            return "LowerLeg_L";
        }
        if (bodyPartType == LowerLeg_R) {
            return "LowerLeg_R";
        }
        if (bodyPartType == Foot_L) {
            return "Foot_L";
        }
        if (bodyPartType == Foot_R) {
            return "Foot_R";
        }
        return "Unkown Body Part";
    }

    public static float getDamageModifyer(int n) {
        switch (n) {
            case 0: {
                return 0.1f;
            }
            case 1: {
                return 0.1f;
            }
            case 2: {
                return 0.2f;
            }
            case 3: {
                return 0.2f;
            }
            case 4: {
                return 0.3f;
            }
            case 5: {
                return 0.3f;
            }
            case 6: {
                return 0.35f;
            }
            case 7: {
                return 0.4f;
            }
            case 8: {
                return 0.6f;
            }
            case 9: {
                return 0.7f;
            }
            case 10: {
                return 0.4f;
            }
            case 11: {
                return 0.3f;
            }
            case 12: {
                return 0.3f;
            }
            case 13: {
                return 0.2f;
            }
            case 14: {
                return 0.2f;
            }
            case 15: {
                return 0.2f;
            }
            case 16: {
                return 0.2f;
            }
        }
        return 1.0f;
    }

    public static float getBleedingTimeModifyer(int n) {
        switch (n) {
            case 0: {
                return 0.2f;
            }
            case 1: {
                return 0.2f;
            }
            case 2: {
                return 0.3f;
            }
            case 3: {
                return 0.3f;
            }
            case 4: {
                return 0.4f;
            }
            case 5: {
                return 0.4f;
            }
            case 6: {
                return 0.5f;
            }
            case 7: {
                return 0.9f;
            }
            case 8: {
                return 1.0f;
            }
            case 9: {
                return 1.5f;
            }
            case 10: {
                return 0.5f;
            }
            case 11: {
                return 0.4f;
            }
            case 12: {
                return 0.4f;
            }
            case 13: {
                return 0.3f;
            }
            case 14: {
                return 0.3f;
            }
            case 15: {
                return 0.2f;
            }
            case 16: {
                return 0.2f;
            }
        }
        return 1.0f;
    }

    public static float GetSkinSurface(BodyPartType bodyPartType) {
        if (bodyPartType == null) {
            return 0.001f;
        }
        switch (bodyPartType) {
            case Torso_Upper: {
                return 0.18f;
            }
            case Head: {
                return 0.08f;
            }
            case Neck: {
                return 0.02f;
            }
            case Torso_Lower: {
                return 0.12f;
            }
            case Groin: {
                return 0.06f;
            }
            case UpperLeg_L: 
            case UpperLeg_R: {
                return 0.09f;
            }
            case LowerLeg_L: 
            case LowerLeg_R: {
                return 0.07f;
            }
            case Foot_L: 
            case Foot_R: {
                return 0.02f;
            }
            case UpperArm_L: 
            case UpperArm_R: {
                return 0.045f;
            }
            case ForeArm_L: 
            case ForeArm_R: {
                return 0.035f;
            }
            case Hand_L: 
            case Hand_R: {
                return 0.01f;
            }
        }
        DebugLog.log("Warning: couldnt get skinSurface for body part '" + bodyPartType + "'.");
        return 0.001f;
    }

    public static float GetDistToCore(BodyPartType bodyPartType) {
        if (bodyPartType == null) {
            return 0.0f;
        }
        switch (bodyPartType) {
            case Torso_Upper: {
                return 0.0f;
            }
            case Head: {
                return 0.05f;
            }
            case Neck: {
                return 0.02f;
            }
            case Torso_Lower: {
                return 0.05f;
            }
            case Groin: {
                return 0.3f;
            }
            case UpperLeg_L: 
            case UpperLeg_R: {
                return 0.45f;
            }
            case LowerLeg_L: 
            case LowerLeg_R: {
                return 0.75f;
            }
            case Foot_L: 
            case Foot_R: {
                return 1.0f;
            }
            case UpperArm_L: 
            case UpperArm_R: {
                return 0.3f;
            }
            case ForeArm_L: 
            case ForeArm_R: {
                return 0.6f;
            }
            case Hand_L: 
            case Hand_R: {
                return 0.8f;
            }
        }
        DebugLog.log("Warning: couldnt get distToCore for body part '" + bodyPartType + "'.");
        return 0.0f;
    }

    public static float GetUmbrellaMod(BodyPartType bodyPartType) {
        if (bodyPartType == null) {
            return 1.0f;
        }
        switch (bodyPartType) {
            case Torso_Upper: {
                return 0.2f;
            }
            case Head: {
                return 0.05f;
            }
            case Neck: {
                return 0.1f;
            }
            case Torso_Lower: {
                return 0.25f;
            }
            case Groin: {
                return 0.3f;
            }
            case UpperLeg_L: 
            case UpperLeg_R: {
                return 0.55f;
            }
            case LowerLeg_L: 
            case LowerLeg_R: {
                return 0.75f;
            }
            case Foot_L: 
            case Foot_R: {
                return 1.0f;
            }
            case UpperArm_L: 
            case UpperArm_R: {
                return 0.25f;
            }
            case ForeArm_L: 
            case ForeArm_R: {
                return 0.3f;
            }
            case Hand_L: 
            case Hand_R: {
                return 0.35f;
            }
        }
        return 1.0f;
    }

    public static float GetMaxActionPenalty(BodyPartType bodyPartType) {
        if (bodyPartType == null) {
            return 0.0f;
        }
        switch (bodyPartType) {
            case Torso_Upper: {
                return 0.2f;
            }
            case Head: {
                return 0.4f;
            }
            case Neck: {
                return 0.05f;
            }
            case Torso_Lower: {
                return 0.1f;
            }
            case Groin: {
                return 0.05f;
            }
            case UpperLeg_L: 
            case UpperLeg_R: {
                return 0.1f;
            }
            case LowerLeg_L: 
            case LowerLeg_R: {
                return 0.1f;
            }
            case Foot_L: 
            case Foot_R: {
                return 0.1f;
            }
            case UpperArm_L: 
            case UpperArm_R: {
                return 0.4f;
            }
            case ForeArm_L: 
            case ForeArm_R: {
                return 0.6f;
            }
            case Hand_L: 
            case Hand_R: {
                return 1.0f;
            }
        }
        DebugLog.log("Warning: couldnt get maxActionPenalty for body part '" + bodyPartType + "'.");
        return 0.0f;
    }

    public static float GetMaxMovementPenalty(BodyPartType bodyPartType) {
        if (bodyPartType == null) {
            return 0.0f;
        }
        switch (bodyPartType) {
            case Torso_Upper: {
                return 0.05f;
            }
            case Head: {
                return 0.25f;
            }
            case Neck: {
                return 0.05f;
            }
            case Torso_Lower: {
                return 0.05f;
            }
            case Groin: {
                return 0.15f;
            }
            case UpperLeg_L: 
            case UpperLeg_R: {
                return 0.4f;
            }
            case LowerLeg_L: 
            case LowerLeg_R: {
                return 0.6f;
            }
            case Foot_L: 
            case Foot_R: {
                return 1.0f;
            }
            case UpperArm_L: 
            case UpperArm_R: {
                return 0.1f;
            }
            case ForeArm_L: 
            case ForeArm_R: {
                return 0.1f;
            }
            case Hand_L: 
            case Hand_R: {
                return 0.05f;
            }
        }
        DebugLog.log("Warning: couldnt get maxMovementPenalty for body part '" + bodyPartType + "'.");
        return 0.0f;
    }

    public String getBandageModel() {
        switch (this) {
            case Torso_Upper: {
                return "Base.Bandage_Chest";
            }
            case Head: {
                return "Base.Bandage_Head";
            }
            case Neck: {
                return "Base.Bandage_Neck";
            }
            case Torso_Lower: {
                return "Base.Bandage_Abdomen";
            }
            case Groin: {
                return "Base.Bandage_Groin";
            }
            case UpperLeg_L: {
                return "Base.Bandage_LeftUpperLeg";
            }
            case UpperLeg_R: {
                return "Base.Bandage_RightUpperLeg";
            }
            case LowerLeg_L: {
                return "Base.Bandage_LeftLowerLeg";
            }
            case LowerLeg_R: {
                return "Base.Bandage_RightLowerLeg";
            }
            case Foot_L: {
                return "Base.Bandage_LeftFoot";
            }
            case Foot_R: {
                return "Base.Bandage_RightFoot";
            }
            case UpperArm_L: {
                return "Base.Bandage_LeftUpperArm";
            }
            case UpperArm_R: {
                return "Base.Bandage_RightUpperArm";
            }
            case ForeArm_L: {
                return "Base.Bandage_LeftLowerArm";
            }
            case ForeArm_R: {
                return "Base.Bandage_RightLowerArm";
            }
            case Hand_L: {
                return "Base.Bandage_LeftHand";
            }
            case Hand_R: {
                return "Base.Bandage_RightHand";
            }
        }
        return null;
    }

    public String getBiteWoundModel(boolean bl) {
        String string = "Female";
        if (!bl) {
            string = "Male";
        }
        switch (this) {
            case Torso_Upper: {
                return "Base.Wound_Chest_Bite_" + string;
            }
            case Head: {
                return "Base.Wound_Neck_Bite_" + string;
            }
            case Neck: {
                return "Base.Wound_Neck_Bite_" + string;
            }
            case Torso_Lower: {
                return "Base.Wound_Abdomen_Bite_" + string;
            }
            case Groin: {
                return "Base.Wound_Groin_Bite_" + string;
            }
            case UpperLeg_L: {
                return null;
            }
            case UpperLeg_R: {
                return null;
            }
            case LowerLeg_L: {
                return null;
            }
            case LowerLeg_R: {
                return null;
            }
            case Foot_L: {
                return null;
            }
            case Foot_R: {
                return null;
            }
            case UpperArm_L: {
                return "Base.Wound_LUArm_Bite_" + string;
            }
            case UpperArm_R: {
                return "Base.Wound_RUArm_Bite_" + string;
            }
            case ForeArm_L: {
                return "Base.Wound_LForearm_Bite_" + string;
            }
            case ForeArm_R: {
                return "Base.Wound_RForearm_Bite_" + string;
            }
            case Hand_L: {
                return "Base.Wound_LHand_Bite_" + string;
            }
            case Hand_R: {
                return "Base.Wound_RHand_Bite_" + string;
            }
        }
        return null;
    }

    public String getScratchWoundModel(boolean bl) {
        String string = "Female";
        if (!bl) {
            string = "Male";
        }
        switch (this) {
            case Torso_Upper: {
                return "Base.Wound_Chest_Scratch_" + string;
            }
            case Head: {
                return "Base.Wound_Neck_Scratch_" + string;
            }
            case Neck: {
                return "Base.Wound_Neck_Scratch_" + string;
            }
            case Torso_Lower: {
                return "Base.Wound_Abdomen_Scratch_" + string;
            }
            case Groin: {
                return "Base.Wound_Groin_Scratch_" + string;
            }
            case UpperLeg_L: {
                return null;
            }
            case UpperLeg_R: {
                return null;
            }
            case LowerLeg_L: {
                return null;
            }
            case LowerLeg_R: {
                return null;
            }
            case Foot_L: {
                return null;
            }
            case Foot_R: {
                return null;
            }
            case UpperArm_L: {
                return "Base.Wound_LUArm_Scratch_" + string;
            }
            case UpperArm_R: {
                return "Base.Wound_RUArm_Scratch_" + string;
            }
            case ForeArm_L: {
                return "Base.Wound_LForearm_Scratch_" + string;
            }
            case ForeArm_R: {
                return "Base.Wound_RForearm_Scratch_" + string;
            }
            case Hand_L: {
                return "Base.Wound_LHand_Scratch_" + string;
            }
            case Hand_R: {
                return "Base.Wound_RHand_Scratch_" + string;
            }
        }
        return null;
    }

    public String getCutWoundModel(boolean bl) {
        String string = "Female";
        if (!bl) {
            string = "Male";
        }
        switch (this) {
            case Torso_Upper: {
                return "Base.Wound_Chest_Laceration_" + string;
            }
            case Head: {
                return "Base.Wound_Neck_Laceration_" + string;
            }
            case Neck: {
                return "Base.Wound_Neck_Laceration_" + string;
            }
            case Torso_Lower: {
                return "Base.Wound_Abdomen_Laceration_" + string;
            }
            case Groin: {
                return "Base.Wound_Groin_Laceration_" + string;
            }
            case UpperLeg_L: {
                return null;
            }
            case UpperLeg_R: {
                return null;
            }
            case LowerLeg_L: {
                return null;
            }
            case LowerLeg_R: {
                return null;
            }
            case Foot_L: {
                return null;
            }
            case Foot_R: {
                return null;
            }
            case UpperArm_L: {
                return "Base.Wound_LUArm_Laceration_" + string;
            }
            case UpperArm_R: {
                return "Base.Wound_RUArm_Laceration_" + string;
            }
            case ForeArm_L: {
                return "Base.Wound_LForearm_Laceration_" + string;
            }
            case ForeArm_R: {
                return "Base.Wound_RForearm_Laceration_" + string;
            }
            case Hand_L: {
                return "Base.Wound_LHand_Laceration_" + string;
            }
            case Hand_R: {
                return "Base.Wound_RHand_Laceration_" + string;
            }
        }
        return null;
    }

    public static BodyPartType getRandom() {
        return BodyPartType.FromIndex(OutfitRNG.Next(0, MAX.index()));
    }
}

