/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.BodyDamage;

import java.util.ArrayList;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.debug.DebugLog;

public final class BodyPartContacts {
    private static final ContactNode root;
    private static final ContactNode[] nodes;

    public static BodyPartType[] getAllContacts(BodyPartType bodyPartType) {
        for (int i = 0; i < nodes.length; ++i) {
            ContactNode contactNode = nodes[i];
            if (contactNode.bodyPart != bodyPartType) continue;
            return contactNode.bodyPartAllContacts;
        }
        return null;
    }

    public static BodyPartType[] getChildren(BodyPartType bodyPartType) {
        for (int i = 0; i < nodes.length; ++i) {
            ContactNode contactNode = nodes[i];
            if (contactNode.bodyPart != bodyPartType) continue;
            return contactNode.bodyPartChildren;
        }
        return null;
    }

    public static BodyPartType getParent(BodyPartType bodyPartType) {
        for (int i = 0; i < nodes.length; ++i) {
            ContactNode contactNode = nodes[i];
            if (contactNode.bodyPart != bodyPartType) continue;
            if (contactNode.depth == 0) {
                DebugLog.log("Warning, root node parent is always null.");
            }
            return contactNode.bodyPartParent;
        }
        return null;
    }

    public static int getNodeDepth(BodyPartType bodyPartType) {
        for (int i = 0; i < nodes.length; ++i) {
            ContactNode contactNode = nodes[i];
            if (contactNode.bodyPart != bodyPartType) continue;
            if (!contactNode.initialised) {
                DebugLog.log("Warning: attempting to get depth for non initialised node '" + contactNode.bodyPart.toString() + "'.");
            }
            return contactNode.depth;
        }
        return -1;
    }

    private static ContactNode getNodeForBodyPart(BodyPartType bodyPartType) {
        for (int i = 0; i < nodes.length; ++i) {
            if (BodyPartContacts.nodes[i].bodyPart != bodyPartType) continue;
            return nodes[i];
        }
        return null;
    }

    private static void initNodes(ContactNode contactNode, int n, ContactNode contactNode2) {
        contactNode.parent = contactNode2;
        contactNode.depth = n;
        ArrayList<ContactNode> arrayList = new ArrayList<ContactNode>();
        if (contactNode.parent != null) {
            arrayList.add(contactNode.parent);
        }
        if (contactNode.children != null) {
            for (ContactNode contactNode3 : contactNode.children) {
                arrayList.add(contactNode3);
                BodyPartContacts.initNodes(contactNode3, n + 1, contactNode);
            }
        }
        contactNode.allContacts = new ContactNode[arrayList.size()];
        arrayList.toArray(contactNode.allContacts);
        contactNode.initialised = true;
    }

    private static void postInit() {
        for (ContactNode contactNode : nodes) {
            int n;
            if (contactNode.parent != null) {
                contactNode.bodyPartParent = contactNode.parent.bodyPart;
            }
            if (contactNode.children != null && contactNode.children.length > 0) {
                contactNode.bodyPartChildren = new BodyPartType[contactNode.children.length];
                for (n = 0; n < contactNode.children.length; ++n) {
                    contactNode.bodyPartChildren[n] = contactNode.children[n].bodyPart;
                }
            } else {
                contactNode.bodyPartChildren = new BodyPartType[0];
            }
            if (contactNode.allContacts != null && contactNode.allContacts.length > 0) {
                contactNode.bodyPartAllContacts = new BodyPartType[contactNode.allContacts.length];
                for (n = 0; n < contactNode.allContacts.length; ++n) {
                    contactNode.bodyPartAllContacts[n] = contactNode.allContacts[n].bodyPart;
                }
            } else {
                contactNode.bodyPartAllContacts = new BodyPartType[0];
            }
            if (contactNode.initialised) continue;
            DebugLog.log("Warning: node for '" + contactNode.bodyPart.toString() + "' is not initialised!");
        }
    }

    static {
        int n = BodyPartType.ToIndex(BodyPartType.MAX);
        nodes = new ContactNode[n];
        for (int i = 0; i < n; ++i) {
            BodyPartContacts.nodes[i] = new ContactNode(BodyPartType.FromIndex(i));
        }
        root = BodyPartContacts.getNodeForBodyPart(BodyPartType.Torso_Upper);
        BodyPartContacts.root.children = new ContactNode[]{BodyPartContacts.getNodeForBodyPart(BodyPartType.Neck), BodyPartContacts.getNodeForBodyPart(BodyPartType.Torso_Lower), BodyPartContacts.getNodeForBodyPart(BodyPartType.UpperArm_L), BodyPartContacts.getNodeForBodyPart(BodyPartType.UpperArm_R)};
        ContactNode contactNode = BodyPartContacts.getNodeForBodyPart(BodyPartType.Neck);
        contactNode.children = new ContactNode[]{BodyPartContacts.getNodeForBodyPart(BodyPartType.Head)};
        contactNode = BodyPartContacts.getNodeForBodyPart(BodyPartType.UpperArm_L);
        contactNode.children = new ContactNode[]{BodyPartContacts.getNodeForBodyPart(BodyPartType.ForeArm_L)};
        contactNode = BodyPartContacts.getNodeForBodyPart(BodyPartType.ForeArm_L);
        contactNode.children = new ContactNode[]{BodyPartContacts.getNodeForBodyPart(BodyPartType.Hand_L)};
        contactNode = BodyPartContacts.getNodeForBodyPart(BodyPartType.UpperArm_R);
        contactNode.children = new ContactNode[]{BodyPartContacts.getNodeForBodyPart(BodyPartType.ForeArm_R)};
        contactNode = BodyPartContacts.getNodeForBodyPart(BodyPartType.ForeArm_R);
        contactNode.children = new ContactNode[]{BodyPartContacts.getNodeForBodyPart(BodyPartType.Hand_R)};
        contactNode = BodyPartContacts.getNodeForBodyPart(BodyPartType.Torso_Lower);
        contactNode.children = new ContactNode[]{BodyPartContacts.getNodeForBodyPart(BodyPartType.Groin)};
        contactNode = BodyPartContacts.getNodeForBodyPart(BodyPartType.Groin);
        contactNode.children = new ContactNode[]{BodyPartContacts.getNodeForBodyPart(BodyPartType.UpperLeg_L), BodyPartContacts.getNodeForBodyPart(BodyPartType.UpperLeg_R)};
        contactNode = BodyPartContacts.getNodeForBodyPart(BodyPartType.UpperLeg_L);
        contactNode.children = new ContactNode[]{BodyPartContacts.getNodeForBodyPart(BodyPartType.LowerLeg_L)};
        contactNode = BodyPartContacts.getNodeForBodyPart(BodyPartType.LowerLeg_L);
        contactNode.children = new ContactNode[]{BodyPartContacts.getNodeForBodyPart(BodyPartType.Foot_L)};
        contactNode = BodyPartContacts.getNodeForBodyPart(BodyPartType.UpperLeg_R);
        contactNode.children = new ContactNode[]{BodyPartContacts.getNodeForBodyPart(BodyPartType.LowerLeg_R)};
        contactNode = BodyPartContacts.getNodeForBodyPart(BodyPartType.LowerLeg_R);
        contactNode.children = new ContactNode[]{BodyPartContacts.getNodeForBodyPart(BodyPartType.Foot_R)};
        BodyPartContacts.initNodes(root, 0, null);
        BodyPartContacts.postInit();
    }

    private static class ContactNode {
        BodyPartType bodyPart;
        int depth = -1;
        ContactNode parent;
        ContactNode[] children;
        ContactNode[] allContacts;
        BodyPartType bodyPartParent;
        BodyPartType[] bodyPartChildren;
        BodyPartType[] bodyPartAllContacts;
        boolean initialised = false;

        public ContactNode(BodyPartType bodyPartType) {
            this.bodyPart = bodyPartType;
        }
    }
}

