/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters;

import java.util.ArrayList;
import java.util.Comparator;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.iso.IsoUtils;

public abstract class BaseZombieSoundManager {
    protected final ArrayList<IsoZombie> characters = new ArrayList();
    private final long[] soundTime;
    private final int staleSlotMS;
    private final Comparator<IsoZombie> comp = new Comparator<IsoZombie>(){

        @Override
        public int compare(IsoZombie isoZombie, IsoZombie isoZombie2) {
            float f;
            float f2 = BaseZombieSoundManager.this.getClosestListener(isoZombie.x, isoZombie.y, isoZombie.z);
            if (f2 > (f = BaseZombieSoundManager.this.getClosestListener(isoZombie2.x, isoZombie2.y, isoZombie2.z))) {
                return 1;
            }
            if (f2 < f) {
                return -1;
            }
            return 0;
        }
    };

    public BaseZombieSoundManager(int n, int n2) {
        this.soundTime = new long[n];
        this.staleSlotMS = n2;
    }

    public void addCharacter(IsoZombie isoZombie) {
        if (!this.characters.contains(isoZombie)) {
            this.characters.add(isoZombie);
        }
    }

    public void update() {
        if (this.characters.isEmpty()) {
            return;
        }
        this.characters.sort(this.comp);
        long l = System.currentTimeMillis();
        for (int i = 0; i < this.soundTime.length && i < this.characters.size(); ++i) {
            IsoZombie isoZombie = this.characters.get(i);
            if (isoZombie.getCurrentSquare() == null) continue;
            int n = this.getFreeSoundSlot(l);
            if (n == -1) break;
            this.playSound(isoZombie);
            this.soundTime[n] = l;
        }
        this.postUpdate();
        this.characters.clear();
    }

    public abstract void playSound(IsoZombie var1);

    public abstract void postUpdate();

    private float getClosestListener(float f, float f2, float f3) {
        float f4 = Float.MAX_VALUE;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoPlayer.getCurrentSquare() == null) continue;
            float f5 = isoPlayer.getX();
            float f6 = isoPlayer.getY();
            float f7 = isoPlayer.getZ();
            float f8 = IsoUtils.DistanceToSquared(f5, f6, f7 * 3.0f, f, f2, f3 * 3.0f);
            if (isoPlayer.Traits.HardOfHearing.isSet()) {
                f8 *= 4.5f;
            }
            if (!(f8 < f4)) continue;
            f4 = f8;
        }
        return f4;
    }

    private int getFreeSoundSlot(long l) {
        long l2 = Long.MAX_VALUE;
        int n = -1;
        for (int i = 0; i < this.soundTime.length; ++i) {
            if (this.soundTime[i] >= l2) continue;
            l2 = this.soundTime[i];
            n = i;
        }
        if (l - l2 < (long)this.staleSlotMS) {
            return -1;
        }
        return n;
    }
}

