/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.AttachedItems;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import se.krka.kahlua.j2se.KahluaTableImpl;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.Lua.LuaManager;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characters.AttachedItems.AttachedWeaponCustomOutfit;
import zombie.characters.AttachedItems.AttachedWeaponDefinition;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.skinnedmodel.population.Outfit;
import zombie.core.skinnedmodel.population.OutfitRNG;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.types.HandWeapon;
import zombie.iso.IsoWorld;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.util.StringUtils;

public final class AttachedWeaponDefinitions {
    public static final AttachedWeaponDefinitions instance = new AttachedWeaponDefinitions();
    public boolean m_dirty = true;
    public int m_chanceOfAttachedWeapon;
    public final ArrayList<AttachedWeaponDefinition> m_definitions = new ArrayList();
    public final ArrayList<AttachedWeaponCustomOutfit> m_outfitDefinitions = new ArrayList();

    public void checkDirty() {
        if (this.m_dirty) {
            this.m_dirty = false;
            this.init();
        }
    }

    public void addRandomAttachedWeapon(IsoZombie isoZombie) {
        if ("Tutorial".equals(Core.getInstance().getGameMode())) {
            return;
        }
        this.checkDirty();
        if (this.m_definitions.isEmpty()) {
            return;
        }
        ArrayList<AttachedWeaponDefinition> arrayList = L_addRandomAttachedWeapon.definitions;
        arrayList.clear();
        int n = 1;
        AttachedWeaponCustomOutfit attachedWeaponCustomOutfit = null;
        Outfit outfit = isoZombie.getHumanVisual().getOutfit();
        if (outfit != null) {
            for (int i = 0; i < this.m_outfitDefinitions.size(); ++i) {
                attachedWeaponCustomOutfit = this.m_outfitDefinitions.get(i);
                if (attachedWeaponCustomOutfit.outfit.equals(outfit.m_Name) && OutfitRNG.Next(100) < attachedWeaponCustomOutfit.chance) {
                    arrayList.addAll(attachedWeaponCustomOutfit.weapons);
                    n = attachedWeaponCustomOutfit.maxitem > -1 ? attachedWeaponCustomOutfit.maxitem : 1;
                    break;
                }
                attachedWeaponCustomOutfit = null;
            }
        }
        if (arrayList.isEmpty()) {
            if (OutfitRNG.Next(100) > this.m_chanceOfAttachedWeapon) {
                return;
            }
            arrayList.addAll(this.m_definitions);
        }
        while (n > 0) {
            AttachedWeaponDefinition attachedWeaponDefinition = this.pickRandomInList(arrayList, isoZombie);
            if (attachedWeaponDefinition == null) {
                return;
            }
            arrayList.remove(attachedWeaponDefinition);
            --n;
            this.addAttachedWeapon(attachedWeaponDefinition, isoZombie);
            if (attachedWeaponCustomOutfit == null || OutfitRNG.Next(100) < attachedWeaponCustomOutfit.chance) continue;
            return;
        }
    }

    private void addAttachedWeapon(AttachedWeaponDefinition attachedWeaponDefinition, IsoZombie isoZombie) {
        String string = OutfitRNG.pickRandom(attachedWeaponDefinition.weapons);
        InventoryItem inventoryItem = InventoryItemFactory.CreateItem(string);
        if (inventoryItem == null) {
            return;
        }
        if (inventoryItem instanceof HandWeapon) {
            ((HandWeapon)inventoryItem).randomizeBullets();
        }
        inventoryItem.setCondition(OutfitRNG.Next(Math.max(2, inventoryItem.getConditionMax() - 5), inventoryItem.getConditionMax()));
        isoZombie.setAttachedItem(OutfitRNG.pickRandom(attachedWeaponDefinition.weaponLocation), inventoryItem);
        if (attachedWeaponDefinition.ensureItem != null && !this.outfitHasItem(isoZombie, attachedWeaponDefinition.ensureItem)) {
            Item item = ScriptManager.instance.FindItem(attachedWeaponDefinition.ensureItem);
            if (item != null && item.getClothingItemAsset() != null) {
                isoZombie.getHumanVisual().addClothingItem(isoZombie.getItemVisuals(), item);
            } else {
                isoZombie.addItemToSpawnAtDeath(InventoryItemFactory.CreateItem(attachedWeaponDefinition.ensureItem));
            }
        }
        if (!attachedWeaponDefinition.bloodLocations.isEmpty()) {
            for (int i = 0; i < attachedWeaponDefinition.bloodLocations.size(); ++i) {
                BloodBodyPartType bloodBodyPartType = attachedWeaponDefinition.bloodLocations.get(i);
                isoZombie.addBlood(bloodBodyPartType, true, true, true);
                isoZombie.addBlood(bloodBodyPartType, true, true, true);
                isoZombie.addBlood(bloodBodyPartType, true, true, true);
                if (!attachedWeaponDefinition.addHoles) continue;
                isoZombie.addHole(bloodBodyPartType);
                isoZombie.addHole(bloodBodyPartType);
                isoZombie.addHole(bloodBodyPartType);
                isoZombie.addHole(bloodBodyPartType);
            }
        }
    }

    private AttachedWeaponDefinition pickRandomInList(ArrayList<AttachedWeaponDefinition> arrayList, IsoZombie isoZombie) {
        int n;
        AttachedWeaponDefinition attachedWeaponDefinition = null;
        int n2 = 0;
        ArrayList<AttachedWeaponDefinition> arrayList2 = L_addRandomAttachedWeapon.possibilities;
        arrayList2.clear();
        for (n = 0; n < arrayList.size(); ++n) {
            AttachedWeaponDefinition attachedWeaponDefinition2 = arrayList.get(n);
            if (attachedWeaponDefinition2.daySurvived > 0) {
                if (!(IsoWorld.instance.getWorldAgeDays() > (float)attachedWeaponDefinition2.daySurvived)) continue;
                n2 += attachedWeaponDefinition2.chance;
                arrayList2.add(attachedWeaponDefinition2);
                continue;
            }
            if (!attachedWeaponDefinition2.outfit.isEmpty()) {
                if (isoZombie.getHumanVisual().getOutfit() == null || !attachedWeaponDefinition2.outfit.contains(isoZombie.getHumanVisual().getOutfit().m_Name)) continue;
                n2 += attachedWeaponDefinition2.chance;
                arrayList2.add(attachedWeaponDefinition2);
                continue;
            }
            n2 += attachedWeaponDefinition2.chance;
            arrayList2.add(attachedWeaponDefinition2);
        }
        n = OutfitRNG.Next(n2);
        int n3 = 0;
        for (int i = 0; i < arrayList2.size(); ++i) {
            AttachedWeaponDefinition attachedWeaponDefinition3 = arrayList2.get(i);
            if (n >= (n3 += attachedWeaponDefinition3.chance)) continue;
            attachedWeaponDefinition = attachedWeaponDefinition3;
            break;
        }
        return attachedWeaponDefinition;
    }

    public boolean outfitHasItem(IsoZombie isoZombie, String string) {
        assert (string.contains("."));
        ItemVisuals itemVisuals = isoZombie.getItemVisuals();
        for (int i = 0; i < itemVisuals.size(); ++i) {
            ItemVisual itemVisual = (ItemVisual)itemVisuals.get(i);
            if (StringUtils.equals(itemVisual.getItemType(), string)) {
                return true;
            }
            if ("Base.HolsterSimple".equals(string) && StringUtils.equals(itemVisual.getItemType(), "Base.HolsterDouble")) {
                return true;
            }
            if (!"Base.HolsterDouble".equals(string) || !StringUtils.equals(itemVisual.getItemType(), "Base.HolsterSimple")) continue;
            return true;
        }
        return false;
    }

    private void init() {
        this.m_definitions.clear();
        this.m_outfitDefinitions.clear();
        KahluaTableImpl kahluaTableImpl = (KahluaTableImpl)LuaManager.env.rawget((Object)"AttachedWeaponDefinitions");
        if (kahluaTableImpl == null) {
            return;
        }
        this.m_chanceOfAttachedWeapon = kahluaTableImpl.rawgetInt((Object)"chanceOfAttachedWeapon");
        for (Map.Entry entry : kahluaTableImpl.delegate.entrySet()) {
            Object object;
            if (!(entry.getValue() instanceof KahluaTableImpl)) continue;
            KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)entry.getValue();
            if ("attachedWeaponCustomOutfit".equals(entry.getKey())) {
                object = (KahluaTableImpl)entry.getValue();
                for (Map.Entry entry2 : object.delegate.entrySet()) {
                    AttachedWeaponCustomOutfit attachedWeaponCustomOutfit = this.initOutfit((String)entry2.getKey(), (KahluaTableImpl)entry2.getValue());
                    if (attachedWeaponCustomOutfit == null) continue;
                    this.m_outfitDefinitions.add(attachedWeaponCustomOutfit);
                }
                continue;
            }
            object = this.init((String)entry.getKey(), kahluaTableImpl2);
            if (object == null) continue;
            this.m_definitions.add((AttachedWeaponDefinition)object);
        }
        Collections.sort(this.m_definitions, (attachedWeaponDefinition, attachedWeaponDefinition2) -> attachedWeaponDefinition.id.compareTo(attachedWeaponDefinition2.id));
    }

    private AttachedWeaponCustomOutfit initOutfit(String string, KahluaTableImpl kahluaTableImpl) {
        AttachedWeaponCustomOutfit attachedWeaponCustomOutfit = new AttachedWeaponCustomOutfit();
        attachedWeaponCustomOutfit.outfit = string;
        attachedWeaponCustomOutfit.chance = kahluaTableImpl.rawgetInt((Object)"chance");
        attachedWeaponCustomOutfit.maxitem = kahluaTableImpl.rawgetInt((Object)"maxitem");
        KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)kahluaTableImpl.rawget((Object)"weapons");
        for (Map.Entry entry : kahluaTableImpl2.delegate.entrySet()) {
            KahluaTableImpl kahluaTableImpl3 = (KahluaTableImpl)entry.getValue();
            AttachedWeaponDefinition attachedWeaponDefinition = this.init(kahluaTableImpl3.rawgetStr((Object)"id"), kahluaTableImpl3);
            if (attachedWeaponDefinition == null) continue;
            attachedWeaponCustomOutfit.weapons.add(attachedWeaponDefinition);
        }
        return attachedWeaponCustomOutfit;
    }

    private AttachedWeaponDefinition init(String string, KahluaTableImpl kahluaTableImpl) {
        AttachedWeaponDefinition attachedWeaponDefinition = new AttachedWeaponDefinition();
        attachedWeaponDefinition.id = string;
        attachedWeaponDefinition.chance = kahluaTableImpl.rawgetInt((Object)"chance");
        this.tableToArrayList((KahluaTable)kahluaTableImpl, "outfit", attachedWeaponDefinition.outfit);
        this.tableToArrayList((KahluaTable)kahluaTableImpl, "weaponLocation", attachedWeaponDefinition.weaponLocation);
        KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)kahluaTableImpl.rawget((Object)"bloodLocations");
        if (kahluaTableImpl2 != null) {
            KahluaTableIterator kahluaTableIterator = kahluaTableImpl2.iterator();
            while (kahluaTableIterator.advance()) {
                BloodBodyPartType bloodBodyPartType = BloodBodyPartType.FromString(kahluaTableIterator.getValue().toString());
                if (bloodBodyPartType == BloodBodyPartType.MAX) continue;
                attachedWeaponDefinition.bloodLocations.add(bloodBodyPartType);
            }
        }
        attachedWeaponDefinition.addHoles = kahluaTableImpl.rawgetBool((Object)"addHoles");
        attachedWeaponDefinition.daySurvived = kahluaTableImpl.rawgetInt((Object)"daySurvived");
        attachedWeaponDefinition.ensureItem = kahluaTableImpl.rawgetStr((Object)"ensureItem");
        this.tableToArrayList((KahluaTable)kahluaTableImpl, "weapons", attachedWeaponDefinition.weapons);
        Collections.sort(attachedWeaponDefinition.weaponLocation);
        Collections.sort(attachedWeaponDefinition.bloodLocations);
        Collections.sort(attachedWeaponDefinition.weapons);
        return attachedWeaponDefinition;
    }

    private void tableToArrayList(KahluaTable kahluaTable, String string, ArrayList<String> arrayList) {
        KahluaTableImpl kahluaTableImpl = (KahluaTableImpl)kahluaTable.rawget((Object)string);
        if (kahluaTableImpl == null) {
            return;
        }
        int n = kahluaTableImpl.len();
        for (int i = 1; i <= n; ++i) {
            Object object = kahluaTableImpl.rawget(i);
            if (object == null) continue;
            arrayList.add(object.toString());
        }
    }

    private static final class L_addRandomAttachedWeapon {
        static final ArrayList<AttachedWeaponDefinition> possibilities = new ArrayList();
        static final ArrayList<AttachedWeaponDefinition> definitions = new ArrayList();

        private L_addRandomAttachedWeapon() {
        }
    }
}

