/*
 * Decompiled with CFR 0.152.
 */
package zombie.characters.AttachedItems;

import java.util.ArrayList;
import zombie.characters.AttachedItems.AttachedItem;
import zombie.characters.AttachedItems.AttachedItems;
import zombie.characters.AttachedItems.AttachedLocationGroup;
import zombie.characters.AttachedItems.AttachedModelName;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.WeaponPart;
import zombie.scripting.objects.ModelWeaponPart;
import zombie.util.StringUtils;
import zombie.util.Type;

public final class AttachedModelNames {
    protected AttachedLocationGroup group;
    protected final ArrayList<AttachedModelName> models = new ArrayList();

    AttachedLocationGroup getGroup() {
        return this.group;
    }

    public void copyFrom(AttachedModelNames attachedModelNames) {
        this.models.clear();
        for (int i = 0; i < attachedModelNames.models.size(); ++i) {
            AttachedModelName attachedModelName = attachedModelNames.models.get(i);
            this.models.add(new AttachedModelName(attachedModelName));
        }
    }

    public void initFrom(AttachedItems attachedItems) {
        this.group = attachedItems.getGroup();
        this.models.clear();
        for (int i = 0; i < attachedItems.size(); ++i) {
            ArrayList<ModelWeaponPart> arrayList;
            AttachedItem attachedItem = attachedItems.get(i);
            String string = attachedItem.getItem().getStaticModel();
            if (StringUtils.isNullOrWhitespace(string)) continue;
            String string2 = this.group.getLocation(attachedItem.getLocation()).getAttachmentName();
            HandWeapon handWeapon = Type.tryCastTo(attachedItem.getItem(), HandWeapon.class);
            float f = handWeapon == null ? 0.0f : handWeapon.getBloodLevel();
            AttachedModelName attachedModelName = new AttachedModelName(string2, string, f);
            this.models.add(attachedModelName);
            if (handWeapon == null || (arrayList = handWeapon.getModelWeaponPart()) == null) continue;
            ArrayList<WeaponPart> arrayList2 = handWeapon.getAllWeaponParts();
            block1: for (int j = 0; j < arrayList2.size(); ++j) {
                WeaponPart weaponPart = arrayList2.get(j);
                for (int k = 0; k < arrayList.size(); ++k) {
                    ModelWeaponPart modelWeaponPart = arrayList.get(k);
                    if (!weaponPart.getFullType().equals(modelWeaponPart.partType)) continue;
                    AttachedModelName attachedModelName2 = new AttachedModelName(modelWeaponPart.attachmentNameSelf, modelWeaponPart.attachmentParent, modelWeaponPart.modelName, 0.0f);
                    attachedModelName.addChild(attachedModelName2);
                    continue block1;
                }
            }
        }
    }

    public int size() {
        return this.models.size();
    }

    public AttachedModelName get(int n) {
        return this.models.get(n);
    }

    public void clear() {
        this.models.clear();
    }
}

