/*
 * Decompiled with CFR 0.152.
 */
package zombie.characterTextures;

import org.lwjgl.opengl.GL11;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characters.IsoGameCharacter;
import zombie.core.textures.SmartTexture;
import zombie.core.textures.TextureCombinerCommand;
import zombie.core.textures.TextureCombinerShaderParam;

public final class CharacterSmartTexture
extends SmartTexture {
    public static int BodyCategory = 0;
    public static int ClothingBottomCategory = 1;
    public static int ClothingTopCategory = 2;
    public static int ClothingItemCategory = 3;
    public static int DecalOverlayCategory = 300;
    public static int DirtOverlayCategory = 400;
    public static final String[] MaskFiles = new String[]{"BloodMaskHandL", "BloodMaskHandR", "BloodMaskLArmL", "BloodMaskLArmR", "BloodMaskUArmL", "BloodMaskUArmR", "BloodMaskChest", "BloodMaskStomach", "BloodMaskHead", "BloodMaskNeck", "BloodMaskGroin", "BloodMaskULegL", "BloodMaskULegR", "BloodMaskLLegL", "BloodMaskLLegR", "BloodMaskFootL", "BloodMaskFootR", "BloodMaskBack"};
    public static final String[] BasicPatchesMaskFiles = new String[]{"patches_left_hand_sheet", "patches_right_hand_sheet", "patches_left_lower_arm_sheet", "patches_right_lower_arm_sheet", "patches_left_upper_arm_sheet", "patches_right_upper_arm_sheet", "patches_chest_sheet", "patches_abdomen_sheet", "", "", "patches_groin_sheet", "patches_left_upper_leg_sheet", "patches_right_upper_leg_sheet", "patches_left_lower_leg_sheet", "patches_right_lower_leg_sheet", "", "", "patches_back_sheet"};
    public static final String[] DenimPatchesMaskFiles = new String[]{"patches_left_hand_denim", "patches_right_hand_denim", "patches_left_lower_arm_denim", "patches_right_lower_arm_denim", "patches_left_upper_arm_denim", "patches_right_upper_arm_denim", "patches_chest_denim", "patches_abdomen_denim", "", "", "patches_groin_denim", "patches_left_upper_leg_denim", "patches_right_upper_leg_denim", "patches_left_lower_leg_denim", "patches_right_lower_leg_denim", "", "", "patches_back_denim"};
    public static final String[] LeatherPatchesMaskFiles = new String[]{"patches_left_hand_leather", "patches_right_hand_leather", "patches_left_lower_arm_leather", "patches_right_lower_arm_leather", "patches_left_upper_arm_leather", "patches_right_upper_arm_leather", "patches_chest_leather", "patches_abdomen_leather", "", "", "patches_groin_leather", "patches_left_upper_leg_leather", "patches_right_upper_leg_leather", "patches_left_lower_leg_leather", "patches_right_lower_leg_leather", "", "", "patches_back_leather"};

    public void setBlood(BloodBodyPartType bloodBodyPartType, float f) {
        f = Math.max(0.0f, Math.min(1.0f, f));
        int n = DecalOverlayCategory + bloodBodyPartType.index();
        TextureCombinerCommand textureCombinerCommand = this.getFirstFromCategory(n);
        if (textureCombinerCommand != null) {
            for (int i = 0; i < textureCombinerCommand.shaderParams.size(); ++i) {
                TextureCombinerShaderParam textureCombinerShaderParam = textureCombinerCommand.shaderParams.get(i);
                if (!textureCombinerShaderParam.name.equals("intensity") || textureCombinerShaderParam.min == f && textureCombinerShaderParam.max == f) continue;
                textureCombinerShaderParam.min = textureCombinerShaderParam.max = f;
                this.setDirty();
            }
        } else if (f > 0.0f) {
            String string = "media/textures/BloodTextures/" + MaskFiles[bloodBodyPartType.index()] + ".png";
            this.addOverlay("media/textures/BloodTextures/BloodOverlay.png", string, f, n);
        }
    }

    public void setDirt(BloodBodyPartType bloodBodyPartType, float f) {
        f = Math.max(0.0f, Math.min(1.0f, f));
        int n = DirtOverlayCategory + bloodBodyPartType.index();
        TextureCombinerCommand textureCombinerCommand = this.getFirstFromCategory(n);
        if (textureCombinerCommand != null) {
            for (int i = 0; i < textureCombinerCommand.shaderParams.size(); ++i) {
                TextureCombinerShaderParam textureCombinerShaderParam = textureCombinerCommand.shaderParams.get(i);
                if (!textureCombinerShaderParam.name.equals("intensity") || textureCombinerShaderParam.min == f && textureCombinerShaderParam.max == f) continue;
                textureCombinerShaderParam.min = textureCombinerShaderParam.max = f;
                this.setDirty();
            }
        } else if (f > 0.0f) {
            String string = "media/textures/BloodTextures/" + MaskFiles[bloodBodyPartType.index()] + ".png";
            this.addDirtOverlay("media/textures/BloodTextures/GrimeOverlay.png", string, f, n);
        }
    }

    public void removeBlood() {
        for (int i = 0; i < BloodBodyPartType.MAX.index(); ++i) {
            this.removeBlood(BloodBodyPartType.FromIndex(i));
        }
    }

    public void removeBlood(BloodBodyPartType bloodBodyPartType) {
        TextureCombinerCommand textureCombinerCommand = this.getFirstFromCategory(DecalOverlayCategory + bloodBodyPartType.index());
        if (textureCombinerCommand != null) {
            for (int i = 0; i < textureCombinerCommand.shaderParams.size(); ++i) {
                TextureCombinerShaderParam textureCombinerShaderParam = textureCombinerCommand.shaderParams.get(i);
                if (!textureCombinerShaderParam.name.equals("intensity") || textureCombinerShaderParam.min == 0.0f && textureCombinerShaderParam.max == 0.0f) continue;
                textureCombinerShaderParam.max = 0.0f;
                textureCombinerShaderParam.min = 0.0f;
                this.setDirty();
            }
        }
    }

    public float addBlood(BloodBodyPartType bloodBodyPartType, float f, IsoGameCharacter isoGameCharacter) {
        int n = DecalOverlayCategory + bloodBodyPartType.index();
        TextureCombinerCommand textureCombinerCommand = this.getFirstFromCategory(n);
        if (bloodBodyPartType == BloodBodyPartType.Head && isoGameCharacter != null) {
            if (isoGameCharacter.hair != null) {
                isoGameCharacter.hair.tintR -= 0.022f;
                if (isoGameCharacter.hair.tintR < 0.0f) {
                    isoGameCharacter.hair.tintR = 0.0f;
                }
                isoGameCharacter.hair.tintG -= 0.03f;
                if (isoGameCharacter.hair.tintG < 0.0f) {
                    isoGameCharacter.hair.tintG = 0.0f;
                }
                isoGameCharacter.hair.tintB -= 0.03f;
                if (isoGameCharacter.hair.tintB < 0.0f) {
                    isoGameCharacter.hair.tintB = 0.0f;
                }
            }
            if (isoGameCharacter.beard != null) {
                isoGameCharacter.beard.tintR -= 0.022f;
                if (isoGameCharacter.beard.tintR < 0.0f) {
                    isoGameCharacter.beard.tintR = 0.0f;
                }
                isoGameCharacter.beard.tintG -= 0.03f;
                if (isoGameCharacter.beard.tintG < 0.0f) {
                    isoGameCharacter.beard.tintG = 0.0f;
                }
                isoGameCharacter.beard.tintB -= 0.03f;
                if (isoGameCharacter.beard.tintB < 0.0f) {
                    isoGameCharacter.beard.tintB = 0.0f;
                }
            }
        }
        if (textureCombinerCommand != null) {
            for (int i = 0; i < textureCombinerCommand.shaderParams.size(); ++i) {
                TextureCombinerShaderParam textureCombinerShaderParam = textureCombinerCommand.shaderParams.get(i);
                if (!textureCombinerShaderParam.name.equals("intensity")) continue;
                float f2 = textureCombinerShaderParam.min;
                f2 += f;
                if (textureCombinerShaderParam.min != (f2 = Math.min(1.0f, f2)) || textureCombinerShaderParam.max != f2) {
                    textureCombinerShaderParam.min = textureCombinerShaderParam.max = f2;
                    this.setDirty();
                }
                return f2;
            }
        } else {
            String string = "media/textures/BloodTextures/" + MaskFiles[bloodBodyPartType.index()] + ".png";
            this.addOverlay("media/textures/BloodTextures/BloodOverlay.png", string, f, n);
        }
        return f;
    }

    public float addDirt(BloodBodyPartType bloodBodyPartType, float f, IsoGameCharacter isoGameCharacter) {
        int n = DirtOverlayCategory + bloodBodyPartType.index();
        TextureCombinerCommand textureCombinerCommand = this.getFirstFromCategory(n);
        if (bloodBodyPartType == BloodBodyPartType.Head && isoGameCharacter != null) {
            if (isoGameCharacter.hair != null) {
                isoGameCharacter.hair.tintR -= 0.022f;
                if (isoGameCharacter.hair.tintR < 0.0f) {
                    isoGameCharacter.hair.tintR = 0.0f;
                }
                isoGameCharacter.hair.tintG -= 0.03f;
                if (isoGameCharacter.hair.tintG < 0.0f) {
                    isoGameCharacter.hair.tintG = 0.0f;
                }
                isoGameCharacter.hair.tintB -= 0.03f;
                if (isoGameCharacter.hair.tintB < 0.0f) {
                    isoGameCharacter.hair.tintB = 0.0f;
                }
            }
            if (isoGameCharacter.beard != null) {
                isoGameCharacter.beard.tintR -= 0.022f;
                if (isoGameCharacter.beard.tintR < 0.0f) {
                    isoGameCharacter.beard.tintR = 0.0f;
                }
                isoGameCharacter.beard.tintG -= 0.03f;
                if (isoGameCharacter.beard.tintG < 0.0f) {
                    isoGameCharacter.beard.tintG = 0.0f;
                }
                isoGameCharacter.beard.tintB -= 0.03f;
                if (isoGameCharacter.beard.tintB < 0.0f) {
                    isoGameCharacter.beard.tintB = 0.0f;
                }
            }
        }
        if (textureCombinerCommand != null) {
            for (int i = 0; i < textureCombinerCommand.shaderParams.size(); ++i) {
                TextureCombinerShaderParam textureCombinerShaderParam = textureCombinerCommand.shaderParams.get(i);
                if (!textureCombinerShaderParam.name.equals("intensity")) continue;
                float f2 = textureCombinerShaderParam.min;
                f2 += f;
                if (textureCombinerShaderParam.min != (f2 = Math.min(1.0f, f2)) || textureCombinerShaderParam.max != f2) {
                    textureCombinerShaderParam.min = textureCombinerShaderParam.max = f2;
                    this.setDirty();
                }
                return f2;
            }
        } else {
            String string = "media/textures/BloodTextures/" + MaskFiles[bloodBodyPartType.index()] + ".png";
            this.addDirtOverlay("media/textures/BloodTextures/GrimeOverlay.png", string, f, n);
        }
        return f;
    }

    public void addShirtDecal(String string) {
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        this.addRect(string, 102, 118, 52, 52);
    }
}

