/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio.parameters;

import zombie.audio.FMODGlobalParameter;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.math.PZMath;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoWorld;

public final class ParameterZoneWaterSide
extends FMODGlobalParameter {
    private int m_playerX = -1;
    private int m_playerY = -1;
    private int m_distance = 40;

    public ParameterZoneWaterSide() {
        super("ZoneWaterSide");
    }

    @Override
    public float calculateCurrentValue() {
        IsoGameCharacter isoGameCharacter = this.getCharacter();
        if (isoGameCharacter == null) {
            return 40.0f;
        }
        int n = (int)isoGameCharacter.getX();
        int n2 = (int)isoGameCharacter.getY();
        if (n != this.m_playerX || n2 != this.m_playerY) {
            this.m_playerX = n;
            this.m_playerY = n2;
            this.m_distance = this.calculate(isoGameCharacter);
            if (this.m_distance < 40) {
                this.m_distance = PZMath.clamp(this.m_distance - 5, 0, 40);
            }
        }
        return this.m_distance;
    }

    private int calculate(IsoGameCharacter isoGameCharacter) {
        if (IsoWorld.instance == null || IsoWorld.instance.CurrentCell == null || IsoWorld.instance.CurrentCell.ChunkMap[0] == null) {
            return 40;
        }
        IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.ChunkMap[0];
        float f = Float.MAX_VALUE;
        for (int i = 0; i < IsoChunkMap.ChunkGridWidth; ++i) {
            for (int j = 0; j < IsoChunkMap.ChunkGridWidth; ++j) {
                float f2;
                float f3;
                float f4;
                float f5;
                IsoChunk isoChunk = isoChunkMap.getChunk(j, i);
                if (isoChunk == null || isoChunk.getNumberOfWaterTiles() != 100 || !((f5 = isoGameCharacter.x - (f4 = (float)(isoChunk.wx * 10) + 5.0f)) * f5 + (f3 = isoGameCharacter.y - (f2 = (float)(isoChunk.wy * 10) + 5.0f)) * f3 < f)) continue;
                f = f5 * f5 + f3 * f3;
            }
        }
        return (int)PZMath.clamp(PZMath.sqrt(f), 0.0f, 40.0f);
    }

    private IsoGameCharacter getCharacter() {
        IsoGameCharacter isoGameCharacter = null;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoGameCharacter != null && (!isoGameCharacter.isDead() || !isoPlayer.isAlive()) && (!isoGameCharacter.Traits.Deaf.isSet() || isoPlayer.Traits.Deaf.isSet())) continue;
            isoGameCharacter = isoPlayer;
        }
        return isoGameCharacter;
    }
}

