/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio.parameters;

import java.util.ArrayList;
import zombie.audio.FMODGlobalParameter;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.math.PZMath;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoWorld;

public final class ParameterZone
extends FMODGlobalParameter {
    private final String m_zoneName;
    private final ArrayList<IsoMetaGrid.Zone> m_zones = new ArrayList();

    public ParameterZone(String string, String string2) {
        super(string);
        this.m_zoneName = string2;
    }

    @Override
    public float calculateCurrentValue() {
        IsoGameCharacter isoGameCharacter = this.getCharacter();
        if (isoGameCharacter == null) {
            return 40.0f;
        }
        int n = 0;
        this.m_zones.clear();
        IsoWorld.instance.MetaGrid.getZonesIntersecting((int)isoGameCharacter.x - 40, (int)isoGameCharacter.y - 40, n, 80, 80, this.m_zones);
        float f = Float.MAX_VALUE;
        for (int i = 0; i < this.m_zones.size(); ++i) {
            IsoMetaGrid.Zone zone = this.m_zones.get(i);
            if (!this.m_zoneName.equalsIgnoreCase(zone.getType())) continue;
            if (zone.contains((int)isoGameCharacter.x, (int)isoGameCharacter.y, n)) {
                return 0.0f;
            }
            float f2 = (float)zone.x + (float)zone.w / 2.0f;
            float f3 = (float)zone.y + (float)zone.h / 2.0f;
            float f4 = PZMath.max(PZMath.abs(isoGameCharacter.x - f2) - (float)zone.w / 2.0f, 0.0f);
            float f5 = PZMath.max(PZMath.abs(isoGameCharacter.y - f3) - (float)zone.h / 2.0f, 0.0f);
            f = PZMath.min(f, f4 * f4 + f5 * f5);
        }
        return (int)PZMath.clamp(PZMath.sqrt(f), 0.0f, 40.0f);
    }

    private IsoGameCharacter getCharacter() {
        IsoGameCharacter isoGameCharacter = null;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoGameCharacter != null && (!isoGameCharacter.isDead() || !isoPlayer.isAlive()) && (!isoGameCharacter.Traits.Deaf.isSet() || isoPlayer.Traits.Deaf.isSet())) continue;
            isoGameCharacter = isoPlayer;
        }
        return isoGameCharacter;
    }
}

