/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio.parameters;

import zombie.audio.FMODLocalParameter;
import zombie.core.math.PZMath;
import zombie.scripting.objects.VehicleScript;
import zombie.vehicles.BaseVehicle;

public class ParameterVehicleSteer
extends FMODLocalParameter {
    private final BaseVehicle vehicle;

    public ParameterVehicleSteer(BaseVehicle baseVehicle) {
        super("VehicleSteer");
        this.vehicle = baseVehicle;
    }

    @Override
    public float calculateCurrentValue() {
        float f = 0.0f;
        if (!this.vehicle.isEngineRunning()) {
            return f;
        }
        VehicleScript vehicleScript = this.vehicle.getScript();
        if (vehicleScript == null) {
            return f;
        }
        BaseVehicle.WheelInfo[] wheelInfoArray = this.vehicle.wheelInfo;
        int n = vehicleScript.getWheelCount();
        for (int i = 0; i < n; ++i) {
            f = PZMath.max(f, Math.abs(wheelInfoArray[i].steering));
        }
        return (float)((int)(PZMath.clamp(f, 0.0f, 1.0f) * 100.0f)) / 100.0f;
    }
}

