/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio.parameters;

import zombie.audio.FMODLocalParameter;
import zombie.core.math.PZMath;
import zombie.network.GameClient;
import zombie.scripting.objects.VehicleScript;
import zombie.vehicles.BaseVehicle;

public class ParameterVehicleSkid
extends FMODLocalParameter {
    private final BaseVehicle vehicle;
    private final BaseVehicle.WheelInfo[] wheelInfo;

    public ParameterVehicleSkid(BaseVehicle baseVehicle) {
        super("VehicleSkid");
        this.vehicle = baseVehicle;
        this.wheelInfo = baseVehicle.wheelInfo;
    }

    @Override
    public float calculateCurrentValue() {
        float f = 1.0f;
        if (GameClient.bClient && !this.vehicle.isLocalPhysicSim()) {
            return f;
        }
        VehicleScript vehicleScript = this.vehicle.getScript();
        if (vehicleScript == null) {
            return f;
        }
        int n = vehicleScript.getWheelCount();
        for (int i = 0; i < n; ++i) {
            f = PZMath.min(f, this.wheelInfo[i].skidInfo);
        }
        return (float)((int)(100.0f - PZMath.clamp(f, 0.0f, 1.0f) * 100.0f)) / 100.0f;
    }
}

