/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio.parameters;

import org.joml.Vector3f;
import zombie.audio.FMODLocalParameter;
import zombie.scripting.objects.VehicleScript;
import zombie.vehicles.BaseVehicle;

public class ParameterVehicleHitLocation
extends FMODLocalParameter {
    private HitLocation location = HitLocation.Front;

    public ParameterVehicleHitLocation() {
        super("VehicleHitLocation");
    }

    @Override
    public float calculateCurrentValue() {
        return this.location.label;
    }

    public static HitLocation calculateLocation(BaseVehicle baseVehicle, float f, float f2, float f3) {
        VehicleScript vehicleScript = baseVehicle.getScript();
        if (vehicleScript == null) {
            return HitLocation.Front;
        }
        Vector3f vector3f = baseVehicle.getLocalPos(f, f2, f3, (Vector3f)BaseVehicle.TL_vector3f_pool.get().alloc());
        Vector3f vector3f2 = vehicleScript.getExtents();
        Vector3f vector3f3 = vehicleScript.getCenterOfMassOffset();
        float f4 = vector3f3.z - vector3f2.z / 2.0f;
        float f5 = vector3f3.z + vector3f2.z / 2.0f;
        HitLocation hitLocation = vector3f.z >= (f4 *= 0.9f) && vector3f.z <= (f5 *= 0.9f) ? HitLocation.Side : (vector3f.z > 0.0f ? HitLocation.Front : HitLocation.Rear);
        BaseVehicle.TL_vector3f_pool.get().release(vector3f);
        return hitLocation;
    }

    public void setLocation(HitLocation hitLocation) {
        this.location = hitLocation;
    }

    public static enum HitLocation {
        Front(0),
        Rear(1),
        Side(2);

        final int label;

        private HitLocation(int n2) {
            this.label = n2;
        }
    }
}

