/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio.parameters;

import zombie.audio.FMODGlobalParameter;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.math.PZMath;
import zombie.iso.BuildingDef;
import zombie.iso.IsoMetaCell;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoWorld;
import zombie.iso.RoomDef;

public final class ParameterRoomType
extends FMODGlobalParameter {
    static ParameterRoomType instance;
    static RoomType roomType;

    public ParameterRoomType() {
        super("RoomType");
        instance = this;
    }

    @Override
    public float calculateCurrentValue() {
        return this.getRoomType().label;
    }

    private RoomType getRoomType() {
        if (roomType != null) {
            return roomType;
        }
        IsoGameCharacter isoGameCharacter = this.getCharacter();
        if (isoGameCharacter == null) {
            return RoomType.Generic;
        }
        BuildingDef buildingDef = isoGameCharacter.getCurrentBuildingDef();
        if (buildingDef == null) {
            return RoomType.Generic;
        }
        IsoMetaGrid isoMetaGrid = IsoWorld.instance.getMetaGrid();
        IsoMetaCell isoMetaCell = isoMetaGrid.getCellData(PZMath.fastfloor(isoGameCharacter.x / 300.0f), PZMath.fastfloor(isoGameCharacter.y / 300.0f));
        if (isoMetaCell == null || isoMetaCell.roomTones.isEmpty()) {
            return RoomType.Generic;
        }
        RoomDef roomDef = isoGameCharacter.getCurrentRoomDef();
        IsoMetaGrid.RoomTone roomTone = null;
        for (int i = 0; i < isoMetaCell.roomTones.size(); ++i) {
            IsoMetaGrid.RoomTone roomTone2 = isoMetaCell.roomTones.get(i);
            RoomDef roomDef2 = isoMetaGrid.getRoomAt(roomTone2.x, roomTone2.y, roomTone2.z);
            if (roomDef2 == null) continue;
            if (roomDef2 == roomDef) {
                return RoomType.valueOf(roomTone2.enumValue);
            }
            if (!roomTone2.entireBuilding || roomDef2.building != buildingDef) continue;
            roomTone = roomTone2;
        }
        if (roomTone != null) {
            return RoomType.valueOf(roomTone.enumValue);
        }
        return RoomType.Generic;
    }

    private IsoGameCharacter getCharacter() {
        IsoGameCharacter isoGameCharacter = null;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoGameCharacter != null && (!isoGameCharacter.isDead() || !isoPlayer.isAlive()) && (!isoGameCharacter.Traits.Deaf.isSet() || isoPlayer.Traits.Deaf.isSet())) continue;
            isoGameCharacter = isoPlayer;
        }
        return isoGameCharacter;
    }

    public static void setRoomType(int n) {
        try {
            roomType = RoomType.values()[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            roomType = null;
        }
    }

    public static void render(IsoPlayer isoPlayer) {
        if (instance == null) {
            return;
        }
        if (isoPlayer != instance.getCharacter()) {
            return;
        }
        isoPlayer.drawDebugTextBelow("RoomType : " + instance.getRoomType().name());
    }

    static {
        roomType = null;
    }

    private static enum RoomType {
        Generic(0),
        Barn(1),
        Mall(2),
        Warehouse(3),
        Prison(4),
        Church(5),
        Office(6),
        Factory(7);

        final int label;

        private RoomType(int n2) {
            this.label = n2;
        }
    }
}

