/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio.parameters;

import fmod.fmod.FMODSoundEmitter;
import zombie.audio.FMODLocalParameter;
import zombie.characters.IsoPlayer;
import zombie.core.math.PZMath;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;

public final class ParameterOcclusion
extends FMODLocalParameter {
    private final FMODSoundEmitter emitter;
    private float currentValue = Float.NaN;

    public ParameterOcclusion(FMODSoundEmitter fMODSoundEmitter) {
        super("Occlusion");
        this.emitter = fMODSoundEmitter;
    }

    @Override
    public float calculateCurrentValue() {
        float f = 1.0f;
        for (int i = 0; i < 4; ++i) {
            float f2 = this.calculateValueForPlayer(i);
            f = PZMath.min(f, f2);
        }
        this.currentValue = f;
        return (float)((int)(this.currentValue * 1000.0f)) / 1000.0f;
    }

    @Override
    public void resetToDefault() {
        this.currentValue = Float.NaN;
    }

    private float calculateValueForPlayer(int n) {
        IsoPlayer isoPlayer = IsoPlayer.players[n];
        if (isoPlayer == null) {
            return 1.0f;
        }
        IsoGridSquare isoGridSquare = isoPlayer.getCurrentSquare();
        IsoGridSquare isoGridSquare2 = IsoWorld.instance.getCell().getGridSquare(this.emitter.x, this.emitter.y, this.emitter.z);
        if (isoGridSquare2 == null) {
            boolean bl = true;
        }
        float f = 0.0f;
        if (isoGridSquare != null && isoGridSquare2 != null && !isoGridSquare2.isCouldSee(n)) {
            f = 1.0f;
        }
        return f;
    }
}

