/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio.parameters;

import zombie.audio.FMODGlobalParameter;
import zombie.characters.IsoPlayer;

public final class ParameterMusicWakeState
extends FMODGlobalParameter {
    private int m_playerIndex = -1;
    private State m_state = State.Awake;

    public ParameterMusicWakeState() {
        super("MusicWakeState");
    }

    @Override
    public float calculateCurrentValue() {
        IsoPlayer isoPlayer = this.choosePlayer();
        if (isoPlayer != null && this.m_state == State.Awake && isoPlayer.isAsleep()) {
            this.m_state = State.Sleeping;
        }
        return this.m_state.label;
    }

    public void setState(IsoPlayer isoPlayer, State state) {
        if (isoPlayer == this.choosePlayer()) {
            this.m_state = state;
        }
    }

    private IsoPlayer choosePlayer() {
        IsoPlayer isoPlayer;
        if (this.m_playerIndex != -1 && ((isoPlayer = IsoPlayer.players[this.m_playerIndex]) == null || isoPlayer.isDead())) {
            this.m_playerIndex = -1;
        }
        if (this.m_playerIndex != -1) {
            return IsoPlayer.players[this.m_playerIndex];
        }
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer2 = IsoPlayer.players[i];
            if (isoPlayer2 == null || isoPlayer2.isDead()) continue;
            this.m_playerIndex = i;
            this.m_state = isoPlayer2.isAsleep() ? State.Sleeping : State.Awake;
            return isoPlayer2;
        }
        return null;
    }

    public static enum State {
        Awake(0),
        Sleeping(1),
        WakeNormal(2),
        WakeNightmare(3),
        WakeZombies(4);

        final int label;

        private State(int n2) {
            this.label = n2;
        }
    }
}

