/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio.parameters;

import zombie.audio.FMODGlobalParameter;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;

public final class ParameterInside
extends FMODGlobalParameter {
    public ParameterInside() {
        super("Inside");
    }

    @Override
    public float calculateCurrentValue() {
        IsoGameCharacter isoGameCharacter = this.getCharacter();
        if (isoGameCharacter == null) {
            return 0.0f;
        }
        if (isoGameCharacter.getCurrentSquare() == null) {
            return 0.0f;
        }
        if (isoGameCharacter.getCurrentSquare().isInARoom()) {
            return 1.0f;
        }
        if (isoGameCharacter.getVehicle() == null) {
            return 0.0f;
        }
        return -1.0f;
    }

    private IsoGameCharacter getCharacter() {
        IsoGameCharacter isoGameCharacter = null;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoGameCharacter != null && (!isoGameCharacter.isDead() || !isoPlayer.isAlive()) && (!isoGameCharacter.Traits.Deaf.isSet() || isoPlayer.Traits.Deaf.isSet())) continue;
            isoGameCharacter = isoPlayer;
        }
        return isoGameCharacter;
    }
}

