/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio.parameters;

import zombie.audio.FMODLocalParameter;
import zombie.characters.IsoGameCharacter;
import zombie.iso.objects.IsoBrokenGlass;

public final class ParameterFootstepMaterial2
extends FMODLocalParameter {
    private final IsoGameCharacter character;

    public ParameterFootstepMaterial2(IsoGameCharacter isoGameCharacter) {
        super("FootstepMaterial2");
        this.character = isoGameCharacter;
    }

    @Override
    public float calculateCurrentValue() {
        return this.getMaterial().label;
    }

    private FootstepMaterial2 getMaterial() {
        if (this.character.getCurrentSquare() == null) {
            return FootstepMaterial2.None;
        }
        IsoBrokenGlass isoBrokenGlass = this.character.getCurrentSquare().getBrokenGlass();
        if (isoBrokenGlass != null) {
            return FootstepMaterial2.BrokenGlass;
        }
        float f = this.character.getCurrentSquare().getPuddlesInGround();
        if (f > 0.5f) {
            return FootstepMaterial2.PuddleDeep;
        }
        if (f > 0.1f) {
            return FootstepMaterial2.PuddleShallow;
        }
        return FootstepMaterial2.None;
    }

    static enum FootstepMaterial2 {
        None(0),
        BrokenGlass(1),
        PuddleShallow(2),
        PuddleDeep(3);

        final int label;

        private FootstepMaterial2(int n2) {
            this.label = n2;
        }
    }
}

