/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio.parameters;

import zombie.audio.FMODLocalParameter;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoObject;

public final class ParameterCurrentZone
extends FMODLocalParameter {
    private final IsoObject object;
    private IsoMetaGrid.Zone metaZone;
    private Zone zone = Zone.None;

    public ParameterCurrentZone(IsoObject isoObject) {
        super("CurrentZone");
        this.object = isoObject;
    }

    @Override
    public float calculateCurrentValue() {
        IsoGridSquare isoGridSquare = this.object.getSquare();
        if (isoGridSquare == null) {
            this.zone = Zone.None;
            return this.zone.label;
        }
        if (isoGridSquare.zone == this.metaZone) {
            return this.zone.label;
        }
        this.metaZone = isoGridSquare.zone;
        if (this.metaZone == null) {
            this.zone = Zone.None;
            return this.zone.label;
        }
        this.zone = switch (this.metaZone.type) {
            case "DeepForest" -> Zone.DeepForest;
            case "Farm" -> Zone.Farm;
            case "Forest" -> Zone.Forest;
            case "Nav" -> Zone.Nav;
            case "TownZone" -> Zone.Town;
            case "TrailerPark" -> Zone.TrailerPark;
            case "Vegitation" -> Zone.Vegetation;
            default -> Zone.None;
        };
        return this.zone.label;
    }

    static enum Zone {
        None(0),
        DeepForest(1),
        Farm(2),
        Forest(3),
        Nav(4),
        Town(5),
        TrailerPark(6),
        Vegetation(7);

        final int label;

        private Zone(int n2) {
            this.label = n2;
        }
    }
}

