/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio.parameters;

import zombie.audio.FMODGlobalParameter;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;

public final class ParameterCameraZoom
extends FMODGlobalParameter {
    public ParameterCameraZoom() {
        super("CameraZoom");
    }

    @Override
    public float calculateCurrentValue() {
        IsoPlayer isoPlayer = this.getPlayer();
        if (isoPlayer == null) {
            return 0.0f;
        }
        float f = Core.getInstance().getZoom(isoPlayer.PlayerIndex) - Core.getInstance().OffscreenBuffer.getMinZoom();
        float f2 = Core.getInstance().OffscreenBuffer.getMaxZoom() - Core.getInstance().OffscreenBuffer.getMinZoom();
        return f / f2;
    }

    private IsoPlayer getPlayer() {
        IsoGameCharacter isoGameCharacter = null;
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoGameCharacter != null && (!isoGameCharacter.isDead() || !isoPlayer.isAlive())) continue;
            isoGameCharacter = isoPlayer;
        }
        return isoGameCharacter;
    }
}

