/*
 * Decompiled with CFR 0.152.
 */
package zombie.audio;

import fmod.fmod.FMOD_STUDIO_EVENT_DESCRIPTION;
import fmod.fmod.FMOD_STUDIO_PARAMETER_DESCRIPTION;
import zombie.SoundManager;
import zombie.audio.GameSound;
import zombie.core.Core;

public final class GameSoundClip {
    public static short INIT_FLAG_DISTANCE_MIN = 1;
    public static short INIT_FLAG_DISTANCE_MAX = (short)2;
    public final GameSound gameSound;
    public String event;
    public FMOD_STUDIO_EVENT_DESCRIPTION eventDescription;
    public FMOD_STUDIO_EVENT_DESCRIPTION eventDescriptionMP;
    public String file;
    public float volume = 1.0f;
    public float pitch = 1.0f;
    public float distanceMin = 10.0f;
    public float distanceMax = 10.0f;
    public float reverbMaxRange = 10.0f;
    public float reverbFactor = 0.0f;
    public int priority = 5;
    public short initFlags = 0;
    public short reloadEpoch;

    public GameSoundClip(GameSound gameSound) {
        this.gameSound = gameSound;
        this.reloadEpoch = gameSound.reloadEpoch;
    }

    public String getEvent() {
        return this.event;
    }

    public String getFile() {
        return this.file;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean hasMinDistance() {
        return (this.initFlags & INIT_FLAG_DISTANCE_MIN) != 0;
    }

    public boolean hasMaxDistance() {
        return (this.initFlags & INIT_FLAG_DISTANCE_MAX) != 0;
    }

    public float getMinDistance() {
        return this.distanceMin;
    }

    public float getMaxDistance() {
        return this.distanceMax;
    }

    public float getEffectiveVolume() {
        float f = 1.0f;
        switch (this.gameSound.master) {
            case Primary: {
                f = SoundManager.instance.getSoundVolume();
                break;
            }
            case Ambient: {
                f = SoundManager.instance.getAmbientVolume();
                break;
            }
            case Music: {
                f = SoundManager.instance.getMusicVolume();
                break;
            }
            case VehicleEngine: {
                f = SoundManager.instance.getVehicleEngineVolume();
            }
        }
        f *= this.volume;
        return f *= this.gameSound.getUserVolume();
    }

    public float getEffectiveVolumeInMenu() {
        float f = 1.0f;
        switch (this.gameSound.master) {
            case Primary: {
                f = (float)Core.getInstance().getOptionSoundVolume() / 10.0f;
                break;
            }
            case Ambient: {
                f = (float)Core.getInstance().getOptionAmbientVolume() / 10.0f;
                break;
            }
            case Music: {
                f = (float)Core.getInstance().getOptionMusicVolume() / 10.0f;
                break;
            }
            case VehicleEngine: {
                f = (float)Core.getInstance().getOptionVehicleEngineVolume() / 10.0f;
            }
        }
        f *= this.volume;
        return f *= this.gameSound.getUserVolume();
    }

    public GameSoundClip checkReloaded() {
        if (this.reloadEpoch == this.gameSound.reloadEpoch) {
            return this;
        }
        GameSoundClip gameSoundClip = null;
        for (int i = 0; i < this.gameSound.clips.size(); ++i) {
            GameSoundClip gameSoundClip2 = this.gameSound.clips.get(i);
            if (gameSoundClip2 == this) {
                return this;
            }
            if (gameSoundClip2.event != null && gameSoundClip2.event.equals(this.event)) {
                gameSoundClip = gameSoundClip2;
            }
            if (gameSoundClip2.file == null || !gameSoundClip2.file.equals(this.file)) continue;
            gameSoundClip = gameSoundClip2;
        }
        if (gameSoundClip == null) {
            this.reloadEpoch = this.gameSound.reloadEpoch;
            return this;
        }
        return gameSoundClip;
    }

    public boolean hasSustainPoints() {
        return this.eventDescription != null && this.eventDescription.bHasSustainPoints;
    }

    public boolean hasParameter(FMOD_STUDIO_PARAMETER_DESCRIPTION fMOD_STUDIO_PARAMETER_DESCRIPTION) {
        return this.eventDescription != null && this.eventDescription.hasParameter(fMOD_STUDIO_PARAMETER_DESCRIPTION);
    }
}

