/*
 * Decompiled with CFR 0.152.
 */
package zombie.asset;

import zombie.asset.Asset;
import zombie.asset.AssetTask;
import zombie.fileSystem.FileSystem;
import zombie.fileSystem.IFile;
import zombie.fileSystem.IFileTask2Callback;

final class AssetTask_LoadFromFileAsync
extends AssetTask
implements IFileTask2Callback {
    int m_async_op = -1;
    boolean bStream;

    AssetTask_LoadFromFileAsync(Asset asset, boolean bl) {
        super(asset);
        this.bStream = bl;
    }

    @Override
    public void execute() {
        FileSystem fileSystem = this.m_asset.getAssetManager().getOwner().getFileSystem();
        int n = 4 | (this.bStream ? 16 : 1);
        this.m_async_op = fileSystem.openAsync(fileSystem.getDefaultDevice(), this.m_asset.getPath().m_path, n, this);
    }

    @Override
    public void cancel() {
        FileSystem fileSystem = this.m_asset.getAssetManager().getOwner().getFileSystem();
        fileSystem.cancelAsync(this.m_async_op);
        this.m_async_op = -1;
    }

    @Override
    public void onFileTaskFinished(IFile iFile, Object object) {
        this.m_async_op = -1;
        if (this.m_asset.m_priv.m_desired_state != Asset.State.READY) {
            return;
        }
        if (object != Boolean.TRUE) {
            this.m_asset.m_priv.onLoadingFailed();
            return;
        }
        if (!this.m_asset.getAssetManager().loadDataFromFile(this.m_asset, iFile)) {
            this.m_asset.m_priv.onLoadingFailed();
            return;
        }
        this.m_asset.m_priv.onLoadingSucceeded();
    }
}

