/*
 * Decompiled with CFR 0.152.
 */
package zombie.asset;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import zombie.asset.Asset;
import zombie.asset.AssetManagers;
import zombie.asset.AssetPath;
import zombie.asset.AssetStateObserver;
import zombie.asset.AssetTask;
import zombie.asset.AssetTask_LoadFromFileAsync;
import zombie.asset.AssetType;
import zombie.debug.DebugLog;
import zombie.fileSystem.IFile;

public abstract class AssetManager
implements AssetStateObserver {
    private final AssetTable m_assets = new AssetTable();
    private AssetManagers m_owner;
    private boolean m_is_unload_enabled = false;

    public void create(AssetType assetType, AssetManagers assetManagers) {
        assetManagers.add(assetType, this);
        this.m_owner = assetManagers;
    }

    public void destroy() {
        this.m_assets.forEachValue(asset -> {
            if (!asset.isEmpty()) {
                DebugLog.Asset.println("Leaking asset " + asset.getPath());
            }
            this.destroyAsset((Asset)asset);
            return true;
        });
    }

    public void removeUnreferenced() {
        if (!this.m_is_unload_enabled) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        this.m_assets.forEachValue(asset -> {
            if (asset.getRefCount() == 0) {
                arrayList.add(asset);
            }
            return true;
        });
        for (Asset asset2 : arrayList) {
            this.m_assets.remove(asset2.getPath());
            this.destroyAsset(asset2);
        }
    }

    public Asset load(AssetPath assetPath) {
        return this.load(assetPath, null);
    }

    public Asset load(AssetPath assetPath, AssetParams assetParams) {
        if (!assetPath.isValid()) {
            return null;
        }
        Asset asset = this.get(assetPath);
        if (asset == null) {
            asset = this.createAsset(assetPath, assetParams);
            this.m_assets.put(assetPath.getPath(), asset);
        }
        if (asset.isEmpty() && asset.m_priv.m_desired_state == Asset.State.EMPTY) {
            this.doLoad(asset, assetParams);
        }
        asset.addRef();
        return asset;
    }

    public void load(Asset asset) {
        if (asset.isEmpty() && asset.m_priv.m_desired_state == Asset.State.EMPTY) {
            this.doLoad(asset, null);
        }
        asset.addRef();
    }

    public void unload(AssetPath assetPath) {
        Asset asset = this.get(assetPath);
        if (asset != null) {
            this.unload(asset);
        }
    }

    public void unload(Asset asset) {
        int n = asset.rmRef();
        assert (n >= 0);
        if (n == 0 && this.m_is_unload_enabled) {
            this.doUnload(asset);
        }
    }

    public void reload(AssetPath assetPath) {
        Asset asset = this.get(assetPath);
        if (asset != null) {
            this.reload(asset);
        }
    }

    public void reload(Asset asset) {
        this.reload(asset, null);
    }

    public void reload(Asset asset, AssetParams assetParams) {
        this.doUnload(asset);
        this.doLoad(asset, assetParams);
    }

    public void enableUnload(boolean bl) {
        this.m_is_unload_enabled = bl;
        if (!bl) {
            return;
        }
        this.m_assets.forEachValue(asset -> {
            if (asset.getRefCount() == 0) {
                this.doUnload((Asset)asset);
            }
            return true;
        });
    }

    private void doLoad(Asset asset, AssetParams assetParams) {
        if (asset.m_priv.m_desired_state == Asset.State.READY) {
            return;
        }
        asset.m_priv.m_desired_state = Asset.State.READY;
        asset.setAssetParams(assetParams);
        this.startLoading(asset);
    }

    private void doUnload(Asset asset) {
        if (asset.m_priv.m_task != null) {
            asset.m_priv.m_task.cancel();
            asset.m_priv.m_task = null;
        }
        asset.m_priv.m_desired_state = Asset.State.EMPTY;
        this.unloadData(asset);
        assert (asset.m_priv.m_empty_dep_count <= 1);
        asset.m_priv.m_empty_dep_count = 1;
        asset.m_priv.m_failed_dep_count = 0;
        asset.m_priv.checkState();
    }

    @Override
    public void onStateChanged(Asset.State state, Asset.State state2, Asset asset) {
    }

    protected void startLoading(Asset asset) {
        if (asset.m_priv.m_task != null) {
            return;
        }
        asset.m_priv.m_task = new AssetTask_LoadFromFileAsync(asset, false);
        asset.m_priv.m_task.execute();
    }

    protected final void onLoadingSucceeded(Asset asset) {
        asset.m_priv.onLoadingSucceeded();
    }

    protected final void onLoadingFailed(Asset asset) {
        asset.m_priv.onLoadingFailed();
    }

    protected final void setTask(Asset asset, AssetTask assetTask) {
        if (asset.m_priv.m_task != null) {
            if (assetTask == null) {
                asset.m_priv.m_task = null;
            }
            return;
        }
        asset.m_priv.m_task = assetTask;
    }

    protected boolean loadDataFromFile(Asset asset, IFile iFile) {
        throw new RuntimeException("not implemented");
    }

    protected void unloadData(Asset asset) {
    }

    public AssetTable getAssetTable() {
        return this.m_assets;
    }

    public AssetManagers getOwner() {
        return this.m_owner;
    }

    protected abstract Asset createAsset(AssetPath var1, AssetParams var2);

    protected abstract void destroyAsset(Asset var1);

    protected Asset get(AssetPath assetPath) {
        return (Asset)this.m_assets.get(assetPath.getPath());
    }

    public static final class AssetTable
    extends THashMap<String, Asset> {
    }

    public static class AssetParams {
    }
}

