/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import org.joml.Vector3f;
import zombie.ai.State;
import zombie.ai.states.ZombieIdleState;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.gameStates.IngameState;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoWorld;
import zombie.iso.Vector2;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.util.Type;
import zombie.vehicles.PolygonalMap2;

public final class WalkTowardState
extends State {
    private static final WalkTowardState _instance = new WalkTowardState();
    private static final Integer PARAM_IGNORE_OFFSET = 0;
    private static final Integer PARAM_IGNORE_TIME = 1;
    private static final Integer PARAM_TICK_COUNT = 2;
    private final Vector2 temp = new Vector2();
    private final Vector3f worldPos = new Vector3f();

    public static WalkTowardState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        if (hashMap.get(PARAM_IGNORE_OFFSET) == null) {
            hashMap.put(PARAM_IGNORE_OFFSET, Boolean.FALSE);
            hashMap.put(PARAM_IGNORE_TIME, 0L);
        }
        if (hashMap.get(PARAM_IGNORE_OFFSET) == Boolean.TRUE && System.currentTimeMillis() - (Long)hashMap.get(PARAM_IGNORE_TIME) > 3000L) {
            hashMap.put(PARAM_IGNORE_OFFSET, Boolean.FALSE);
            hashMap.put(PARAM_IGNORE_TIME, 0L);
        }
        hashMap.put(PARAM_TICK_COUNT, IngameState.instance.numberTicks);
        if (((IsoZombie)isoGameCharacter).isUseless()) {
            isoGameCharacter.changeState(ZombieIdleState.instance());
        }
        isoGameCharacter.getPathFindBehavior2().walkingOnTheSpot.reset(isoGameCharacter.x, isoGameCharacter.y);
        ((IsoZombie)isoGameCharacter).networkAI.extraUpdate();
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        long l;
        float f;
        float f2;
        float f3;
        boolean bl;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        if (!isoZombie.bCrawling) {
            isoGameCharacter.setOnFloor(false);
        }
        IsoGameCharacter isoGameCharacter2 = Type.tryCastTo(isoZombie.target, IsoGameCharacter.class);
        if (isoZombie.target != null) {
            if (isoZombie.isTargetLocationKnown()) {
                if (isoGameCharacter2 != null) {
                    isoZombie.getPathFindBehavior2().pathToCharacter(isoGameCharacter2);
                    if (isoGameCharacter2.getVehicle() != null && isoZombie.DistToSquared(isoZombie.target) < 16.0f) {
                        Vector3f vector3f = isoGameCharacter2.getVehicle().chooseBestAttackPosition(isoGameCharacter2, isoZombie, this.worldPos);
                        if (vector3f == null) {
                            isoZombie.setVariable("bMoving", false);
                            return;
                        }
                        if (Math.abs(isoGameCharacter.x - isoZombie.getPathFindBehavior2().getTargetX()) > 0.1f || Math.abs(isoGameCharacter.y - isoZombie.getPathFindBehavior2().getTargetY()) > 0.1f) {
                            isoZombie.setVariable("bPathfind", true);
                            isoZombie.setVariable("bMoving", false);
                            return;
                        }
                    }
                }
            } else if (isoZombie.LastTargetSeenX != -1 && !isoGameCharacter.getPathFindBehavior2().isTargetLocation((float)isoZombie.LastTargetSeenX + 0.5f, (float)isoZombie.LastTargetSeenY + 0.5f, isoZombie.LastTargetSeenZ)) {
                isoGameCharacter.pathToLocation(isoZombie.LastTargetSeenX, isoZombie.LastTargetSeenY, isoZombie.LastTargetSeenZ);
            }
        }
        if (isoGameCharacter.getPathTargetX() == (int)isoGameCharacter.getX() && isoGameCharacter.getPathTargetY() == (int)isoGameCharacter.getY()) {
            if (isoZombie.target == null) {
                isoZombie.setVariable("bPathfind", false);
                isoZombie.setVariable("bMoving", false);
                return;
            }
            if ((int)isoZombie.target.getZ() != (int)isoGameCharacter.getZ()) {
                isoZombie.setVariable("bPathfind", true);
                isoZombie.setVariable("bMoving", false);
                return;
            }
        }
        boolean bl2 = isoGameCharacter.isCollidedWithVehicle();
        if (isoGameCharacter2 != null && isoGameCharacter2.getVehicle() != null && isoGameCharacter2.getVehicle().isCharacterAdjacentTo(isoGameCharacter)) {
            bl2 = false;
        }
        if ((bl = isoGameCharacter.isCollidedThisFrame()) && hashMap.get(PARAM_IGNORE_OFFSET) == Boolean.FALSE) {
            hashMap.put(PARAM_IGNORE_OFFSET, Boolean.TRUE);
            hashMap.put(PARAM_IGNORE_TIME, System.currentTimeMillis());
            f3 = isoZombie.getPathFindBehavior2().getTargetX();
            f2 = isoZombie.getPathFindBehavior2().getTargetY();
            f = isoZombie.z;
            boolean bl3 = bl = !this.isPathClear(isoGameCharacter, f3, f2, f);
        }
        if (bl || bl2) {
            isoZombie.AllowRepathDelay = 0.0f;
            isoZombie.pathToLocation(isoGameCharacter.getPathTargetX(), isoGameCharacter.getPathTargetY(), isoGameCharacter.getPathTargetZ());
            if (!isoZombie.getVariableBoolean("bPathfind")) {
                isoZombie.setVariable("bPathfind", true);
                isoZombie.setVariable("bMoving", false);
            }
            return;
        }
        this.temp.x = isoZombie.getPathFindBehavior2().getTargetX();
        this.temp.y = isoZombie.getPathFindBehavior2().getTargetY();
        this.temp.x -= isoZombie.getX();
        this.temp.y -= isoZombie.getY();
        f3 = this.temp.getLength();
        if (f3 < 0.25f) {
            isoGameCharacter.x = isoZombie.getPathFindBehavior2().getTargetX();
            isoGameCharacter.y = isoZombie.getPathFindBehavior2().getTargetY();
            isoGameCharacter.nx = isoGameCharacter.x;
            isoGameCharacter.ny = isoGameCharacter.y;
            f3 = 0.0f;
        }
        if (f3 < 0.025f) {
            isoZombie.setVariable("bPathfind", false);
            isoZombie.setVariable("bMoving", false);
            return;
        }
        if (!GameServer.bServer && !isoZombie.bCrawling && hashMap.get(PARAM_IGNORE_OFFSET) == Boolean.FALSE) {
            f2 = Math.min(f3 / 2.0f, 4.0f);
            f = (float)((isoGameCharacter.getID() + isoZombie.ZombieID) % 20) / 10.0f - 1.0f;
            float f4 = (float)((isoZombie.getID() + isoZombie.ZombieID) % 20) / 10.0f - 1.0f;
            this.temp.x += isoZombie.getX();
            this.temp.y += isoZombie.getY();
            this.temp.x += f * f2;
            this.temp.y += f4 * f2;
            this.temp.x -= isoZombie.getX();
            this.temp.y -= isoZombie.getY();
        }
        isoZombie.bRunning = false;
        this.temp.normalize();
        if (isoZombie.bCrawling) {
            if (isoZombie.getVariableString("TurnDirection").isEmpty()) {
                isoZombie.setForwardDirection(this.temp);
            }
        } else {
            isoZombie.setDir(IsoDirections.fromAngle(this.temp));
            isoZombie.setForwardDirection(this.temp);
        }
        if (isoGameCharacter.getPathFindBehavior2().walkingOnTheSpot.check(isoGameCharacter.x, isoGameCharacter.y)) {
            isoGameCharacter.setVariable("bMoving", false);
        }
        if (IngameState.instance.numberTicks - (l = ((Long)hashMap.get(PARAM_TICK_COUNT)).longValue()) == 2L) {
            isoZombie.parameterZombieState.setState(ParameterZombieState.State.Idle);
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setVariable("bMoving", false);
        ((IsoZombie)isoGameCharacter).networkAI.extraUpdate();
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
    }

    @Override
    public boolean isMoving(IsoGameCharacter isoGameCharacter) {
        return true;
    }

    private boolean isPathClear(IsoGameCharacter isoGameCharacter, float f, float f2, float f3) {
        IsoChunk isoChunk;
        int n = (int)f / 10;
        int n2 = (int)f2 / 10;
        IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(n, n2) : IsoWorld.instance.CurrentCell.getChunkForGridSquare((int)f, (int)f2, (int)f3);
        if (isoChunk != null) {
            int n3 = 1;
            return !PolygonalMap2.instance.lineClearCollide(isoGameCharacter.getX(), isoGameCharacter.getY(), f, f2, (int)f3, isoGameCharacter.getPathFindBehavior2().getTargetChar(), n3 |= 2);
        }
        return false;
    }

    public boolean calculateTargetLocation(IsoZombie isoZombie, Vector2 vector22) {
        assert (isoZombie.isCurrentState(this));
        HashMap<Object, Object> hashMap = isoZombie.getStateMachineParams(this);
        vector22.x = isoZombie.getPathFindBehavior2().getTargetX();
        vector22.y = isoZombie.getPathFindBehavior2().getTargetY();
        this.temp.set(vector22);
        this.temp.x -= isoZombie.getX();
        this.temp.y -= isoZombie.getY();
        float f = this.temp.getLength();
        if (f < 0.025f) {
            return false;
        }
        if (!GameServer.bServer && !isoZombie.bCrawling && hashMap.get(PARAM_IGNORE_OFFSET) == Boolean.FALSE) {
            float f2 = Math.min(f / 2.0f, 4.0f);
            float f3 = (float)((isoZombie.getID() + isoZombie.ZombieID) % 20) / 10.0f - 1.0f;
            float f4 = (float)((isoZombie.getID() + isoZombie.ZombieID) % 20) / 10.0f - 1.0f;
            vector22.x += f3 * f2;
            vector22.y += f4 * f2;
            return true;
        }
        return false;
    }
}

