/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import zombie.ai.State;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.inventory.types.HandWeapon;
import zombie.iso.IsoDirections;
import zombie.iso.objects.IsoWindow;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehicleWindow;

public final class SmashWindowState
extends State {
    private static final SmashWindowState _instance = new SmashWindowState();

    public static SmashWindowState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(true);
        isoGameCharacter.setVariable("bSmashWindow", true);
        HandWeapon handWeapon = Type.tryCastTo(isoGameCharacter.getPrimaryHandItem(), HandWeapon.class);
        if (handWeapon != null && handWeapon.isRanged()) {
            isoGameCharacter.playSound("AttackShove");
        } else if (handWeapon != null && !StringUtils.isNullOrWhitespace(handWeapon.getSwingSound())) {
            isoGameCharacter.playSound(handWeapon.getSwingSound());
        }
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        if (!(hashMap.get(0) instanceof IsoWindow) && !(hashMap.get(0) instanceof VehicleWindow)) {
            isoGameCharacter.setVariable("bSmashWindow", false);
            return;
        }
        IsoPlayer isoPlayer = Type.tryCastTo(isoGameCharacter, IsoPlayer.class);
        if (isoPlayer.pressedMovement(false) || isoPlayer.pressedCancelAction()) {
            isoGameCharacter.setVariable("bSmashWindow", false);
            return;
        }
        if (hashMap.get(0) instanceof IsoWindow) {
            IsoWindow isoWindow = (IsoWindow)hashMap.get(0);
            if (isoWindow.getObjectIndex() == -1 || isoWindow.isDestroyed() && !"true".equals(isoGameCharacter.getVariableString("OwnerSmashedIt"))) {
                isoGameCharacter.setVariable("bSmashWindow", false);
                return;
            }
            if (isoWindow.north) {
                if ((float)isoWindow.getSquare().getY() < isoGameCharacter.getY()) {
                    isoGameCharacter.setDir(IsoDirections.N);
                } else {
                    isoGameCharacter.setDir(IsoDirections.S);
                }
            } else if ((float)isoWindow.getSquare().getX() < isoGameCharacter.getX()) {
                isoGameCharacter.setDir(IsoDirections.W);
            } else {
                isoGameCharacter.setDir(IsoDirections.E);
            }
        } else if (hashMap.get(0) instanceof VehicleWindow) {
            VehicleWindow vehicleWindow = (VehicleWindow)hashMap.get(0);
            isoGameCharacter.faceThisObject((BaseVehicle)hashMap.get(1));
            if (vehicleWindow.isDestroyed() && !"true".equals(isoGameCharacter.getVariableString("OwnerSmashedIt"))) {
                isoGameCharacter.setVariable("bSmashWindow", false);
                return;
            }
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(false);
        isoGameCharacter.clearVariable("bSmashWindow");
        isoGameCharacter.clearVariable("OwnerSmashedIt");
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        if (hashMap.get(0) instanceof IsoWindow) {
            IsoWindow isoWindow = (IsoWindow)hashMap.get(0);
            if (animEvent.m_EventName.equalsIgnoreCase("AttackCollisionCheck")) {
                isoGameCharacter.setVariable("OwnerSmashedIt", true);
                IsoPlayer.getInstance().ContextPanic = 0.0f;
                isoWindow.WeaponHit(isoGameCharacter, null);
                if (!(isoGameCharacter.getPrimaryHandItem() instanceof HandWeapon) && !(isoGameCharacter.getSecondaryHandItem() instanceof HandWeapon)) {
                    isoGameCharacter.getBodyDamage().setScratchedWindow();
                }
            } else if (animEvent.m_EventName.equalsIgnoreCase("ActiveAnimFinishing")) {
                isoGameCharacter.setVariable("bSmashWindow", false);
                if (Boolean.TRUE == hashMap.get(3)) {
                    isoGameCharacter.climbThroughWindow(isoWindow);
                }
            }
        } else if (hashMap.get(0) instanceof VehicleWindow) {
            VehicleWindow vehicleWindow = (VehicleWindow)hashMap.get(0);
            if (animEvent.m_EventName.equalsIgnoreCase("AttackCollisionCheck")) {
                isoGameCharacter.setVariable("OwnerSmashedIt", true);
                IsoPlayer.getInstance().ContextPanic = 0.0f;
                vehicleWindow.hit(isoGameCharacter);
                if (!(isoGameCharacter.getPrimaryHandItem() instanceof HandWeapon) && !(isoGameCharacter.getSecondaryHandItem() instanceof HandWeapon)) {
                    isoGameCharacter.getBodyDamage().setScratchedWindow();
                }
            } else if (animEvent.m_EventName.equalsIgnoreCase("ActiveAnimFinishing")) {
                isoGameCharacter.setVariable("bSmashWindow", false);
            }
        }
    }

    @Override
    public boolean isDoingActionThatCanBeCancelled() {
        return true;
    }
}

