/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.GameTime;
import zombie.ai.State;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.network.GameServer;

public final class PlayerOnGroundState
extends State {
    private static final PlayerOnGroundState _instance = new PlayerOnGroundState();

    public static PlayerOnGroundState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(true);
        ((IsoPlayer)isoGameCharacter).setBlockMovement(true);
        isoGameCharacter.setVariable("bAnimEnd", false);
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        if (!GameServer.bServer && isoGameCharacter.isDead()) {
            isoGameCharacter.die();
        } else {
            isoGameCharacter.setReanimateTimer(isoGameCharacter.getReanimateTimer() - GameTime.getInstance().getMultiplier() / 1.6f);
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(false);
        ((IsoPlayer)isoGameCharacter).setBlockMovement(false);
    }
}

