/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.GameTime;
import zombie.ai.State;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.network.GameClient;
import zombie.network.GameServer;

public final class PlayerKnockedDown
extends State {
    private static final PlayerKnockedDown _instance = new PlayerKnockedDown();

    public static PlayerKnockedDown instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(true);
        ((IsoPlayer)isoGameCharacter).setBlockMovement(true);
        isoGameCharacter.setHitReaction("");
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter.isDead()) {
            if (!GameServer.bServer && !GameClient.bClient) {
                isoGameCharacter.Kill(null);
            }
        } else {
            isoGameCharacter.setReanimateTimer(isoGameCharacter.getReanimateTimer() - GameTime.getInstance().getMultiplier() / 1.6f);
        }
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        if (animEvent.m_EventName.equalsIgnoreCase("FallOnFront")) {
            isoGameCharacter.setFallOnFront(Boolean.parseBoolean(animEvent.m_ParameterValue));
        }
        if (animEvent.m_EventName.equalsIgnoreCase("FallOnBack")) {
            isoGameCharacter.setFallOnFront(Boolean.parseBoolean(animEvent.m_ParameterValue));
        }
        if (animEvent.m_EventName.equalsIgnoreCase("setSitOnGround")) {
            isoGameCharacter.setSitOnGround(Boolean.parseBoolean(animEvent.m_ParameterValue));
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(false);
        ((IsoPlayer)isoGameCharacter).setBlockMovement(false);
        ((IsoPlayer)isoGameCharacter).setKnockedDown(false);
        isoGameCharacter.setOnFloor(true);
    }
}

