/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.ai.State;
import zombie.characters.CharacterTimedActions.BaseAction;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.debug.DebugLog;
import zombie.network.GameClient;
import zombie.network.GameServer;

public final class PlayerHitReactionState
extends State {
    private static final PlayerHitReactionState _instance = new PlayerHitReactionState();

    public static PlayerHitReactionState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(true);
        if (!isoGameCharacter.getCharacterActions().isEmpty()) {
            ((BaseAction)isoGameCharacter.getCharacterActions().get(0)).forceStop();
        }
        isoGameCharacter.setIsAiming(false);
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(false);
        isoGameCharacter.setHitReaction("");
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        if (isoGameCharacter.getAttackedBy() == null || !(isoGameCharacter.getAttackedBy() instanceof IsoZombie)) {
            DebugLog.log("PlayerHitReactionState.animEvent (" + animEvent.m_EventName + ") zombie is null");
            return;
        }
        if (animEvent.m_EventName.equalsIgnoreCase("PushAwayZombie")) {
            isoGameCharacter.getAttackedBy().setHitForce(0.03f);
            ((IsoZombie)isoGameCharacter.getAttackedBy()).setPlayerAttackPosition(null);
            ((IsoZombie)isoGameCharacter.getAttackedBy()).setStaggerBack(true);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("Defend")) {
            isoGameCharacter.getAttackedBy().setHitReaction("BiteDefended");
            if (GameClient.bClient) {
                GameClient.sendHitCharacter(isoGameCharacter.getAttackedBy(), isoGameCharacter, null, 0.0f, false, 1.0f, false, false, false);
            }
        }
        if (animEvent.m_EventName.equalsIgnoreCase("DeathSound")) {
            if (isoGameCharacter.isPlayingDeathSound()) {
                return;
            }
            isoGameCharacter.setPlayingDeathSound(true);
            Object object = "Male";
            if (isoGameCharacter.isFemale()) {
                object = "Female";
            }
            object = (String)object + "BeingEatenDeath";
            isoGameCharacter.playSound((String)object);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("Death")) {
            isoGameCharacter.setOnFloor(true);
            if (!GameServer.bServer) {
                isoGameCharacter.Kill(isoGameCharacter.getAttackedBy());
            }
        }
    }
}

