/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.ai.State;
import zombie.characters.CharacterTimedActions.BaseAction;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.network.GameServer;

public final class PlayerHitReactionPVPState
extends State {
    private static final PlayerHitReactionPVPState _instance = new PlayerHitReactionPVPState();

    public static PlayerHitReactionPVPState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        if (!isoGameCharacter.getCharacterActions().isEmpty()) {
            ((BaseAction)isoGameCharacter.getCharacterActions().get(0)).forceStop();
        }
        isoGameCharacter.setSitOnGround(false);
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(false);
        isoGameCharacter.setHitReaction("");
        isoGameCharacter.setVariable("hitpvp", false);
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        if (animEvent.m_EventName.equalsIgnoreCase("PushAwayZombie")) {
            isoGameCharacter.getAttackedBy().setHitForce(0.03f);
            if (isoGameCharacter.getAttackedBy() instanceof IsoZombie) {
                ((IsoZombie)isoGameCharacter.getAttackedBy()).setPlayerAttackPosition(null);
                ((IsoZombie)isoGameCharacter.getAttackedBy()).setStaggerBack(true);
            }
        }
        if (animEvent.m_EventName.equalsIgnoreCase("Defend")) {
            isoGameCharacter.getAttackedBy().setHitReaction("BiteDefended");
        }
        if (animEvent.m_EventName.equalsIgnoreCase("DeathSound")) {
            if (isoGameCharacter.isPlayingDeathSound()) {
                return;
            }
            isoGameCharacter.setPlayingDeathSound(true);
            Object object = "Male";
            if (isoGameCharacter.isFemale()) {
                object = "Female";
            }
            object = (String)object + "BeingEatenDeath";
            isoGameCharacter.playSound((String)object);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("Death")) {
            isoGameCharacter.setOnFloor(true);
            if (!GameServer.bServer) {
                isoGameCharacter.Kill(isoGameCharacter.getAttackedBy());
            }
        }
    }
}

