/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import zombie.ai.State;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.Moodles.MoodleType;
import zombie.network.GameClient;

public final class PlayerGetUpState
extends State {
    private static final PlayerGetUpState _instance = new PlayerGetUpState();

    public static PlayerGetUpState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        isoGameCharacter.setIgnoreMovement(true);
        IsoPlayer isoPlayer = (IsoPlayer)isoGameCharacter;
        isoPlayer.setInitiateAttack(false);
        isoPlayer.attackStarted = false;
        isoPlayer.setAttackType(null);
        isoPlayer.setBlockMovement(true);
        isoPlayer.setForceRun(false);
        isoPlayer.setForceSprint(false);
        isoGameCharacter.setVariable("getUpQuick", isoGameCharacter.getVariableBoolean("pressedRunButton"));
        if (isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.Panic) > 1) {
            isoGameCharacter.setVariable("getUpQuick", true);
        }
        if (isoGameCharacter.getVariableBoolean("pressedMovement")) {
            isoGameCharacter.setVariable("getUpWalk", true);
        }
        if (GameClient.bClient) {
            isoGameCharacter.setKnockedDown(false);
        }
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.clearVariable("getUpWalk");
        if (isoGameCharacter.getVariableBoolean("sitonground")) {
            isoGameCharacter.setHideWeaponModel(false);
        }
        isoGameCharacter.setIgnoreMovement(false);
        isoGameCharacter.setFallOnFront(false);
        isoGameCharacter.setOnFloor(false);
        ((IsoPlayer)isoGameCharacter).setBlockMovement(false);
        isoGameCharacter.setSitOnGround(false);
    }
}

