/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.ai.State;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;

public final class PlayerEmoteState
extends State {
    private static final PlayerEmoteState _instance = new PlayerEmoteState();

    public static PlayerEmoteState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setVariable("EmotePlaying", true);
        isoGameCharacter.resetModelNextFrame();
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        IsoPlayer isoPlayer = (IsoPlayer)isoGameCharacter;
        if (isoPlayer.pressedCancelAction()) {
            isoGameCharacter.setVariable("EmotePlaying", false);
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.clearVariable("EmotePlaying");
        isoGameCharacter.resetModelNextFrame();
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        if ("EmoteFinishing".equalsIgnoreCase(animEvent.m_EventName)) {
            isoGameCharacter.setVariable("EmotePlaying", false);
        }
        if ("EmoteLooped".equalsIgnoreCase(animEvent.m_EventName)) {
            // empty if block
        }
    }

    @Override
    public boolean isDoingActionThatCanBeCancelled() {
        return true;
    }
}

