/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.ai.State;
import zombie.characters.CharacterTimedActions.BaseAction;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.HandWeapon;
import zombie.network.GameClient;
import zombie.util.StringUtils;

public final class PlayerActionsState
extends State {
    private static final PlayerActionsState _instance = new PlayerActionsState();

    public static PlayerActionsState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        InventoryItem inventoryItem = isoGameCharacter.getPrimaryHandItem();
        InventoryItem inventoryItem2 = isoGameCharacter.getSecondaryHandItem();
        if (!(inventoryItem instanceof HandWeapon) && !(inventoryItem2 instanceof HandWeapon)) {
            isoGameCharacter.setHideWeaponModel(true);
        }
        String string = isoGameCharacter.getVariableString("PerformingAction");
        if (GameClient.bClient && isoGameCharacter instanceof IsoPlayer && isoGameCharacter.isLocal() && !isoGameCharacter.getCharacterActions().isEmpty() && isoGameCharacter.getNetworkCharacterAI().getAction() == null) {
            isoGameCharacter.getNetworkCharacterAI().setAction((BaseAction)isoGameCharacter.getCharacterActions().get(0));
            GameClient.sendAction(isoGameCharacter.getNetworkCharacterAI().getAction(), true);
            isoGameCharacter.getNetworkCharacterAI().setPerformingAction(string);
        }
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        if (GameClient.bClient && isoGameCharacter instanceof IsoPlayer && isoGameCharacter.isLocal()) {
            String string = isoGameCharacter.getVariableString("PerformingAction");
            if (!isoGameCharacter.getCharacterActions().isEmpty() && (isoGameCharacter.getNetworkCharacterAI().getAction() != isoGameCharacter.getCharacterActions().get(0) || string != null && !string.equals(isoGameCharacter.getNetworkCharacterAI().getPerformingAction()))) {
                GameClient.sendAction(isoGameCharacter.getNetworkCharacterAI().getAction(), false);
                isoGameCharacter.getNetworkCharacterAI().setAction((BaseAction)isoGameCharacter.getCharacterActions().get(0));
                GameClient.sendAction(isoGameCharacter.getNetworkCharacterAI().getAction(), true);
                isoGameCharacter.getNetworkCharacterAI().setPerformingAction(string);
            }
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setHideWeaponModel(false);
        if (GameClient.bClient && isoGameCharacter instanceof IsoPlayer && isoGameCharacter.isLocal() && isoGameCharacter.getNetworkCharacterAI().getAction() != null) {
            GameClient.sendAction(isoGameCharacter.getNetworkCharacterAI().getAction(), false);
            isoGameCharacter.getNetworkCharacterAI().setAction(null);
        }
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        if (GameClient.bClient && animEvent != null && isoGameCharacter instanceof IsoPlayer && isoGameCharacter.getNetworkCharacterAI().getAction() != null && !isoGameCharacter.isLocal() && "changeWeaponSprite".equalsIgnoreCase(animEvent.m_EventName) && !StringUtils.isNullOrEmpty(animEvent.m_ParameterValue)) {
            if ("original".equals(animEvent.m_ParameterValue)) {
                isoGameCharacter.getNetworkCharacterAI().setOverride(false, null, null);
            } else {
                isoGameCharacter.getNetworkCharacterAI().setOverride(true, animEvent.m_ParameterValue, null);
            }
        }
    }
}

