/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import zombie.GameTime;
import zombie.ai.State;
import zombie.ai.states.SmashWindowState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.skills.PerkFactory;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.debug.DebugOptions;
import zombie.iso.IsoDirections;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.objects.IsoWindow;

public final class OpenWindowState
extends State {
    private static final OpenWindowState _instance = new OpenWindowState();
    private static final Integer PARAM_WINDOW = 1;

    public static OpenWindowState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(true);
        isoGameCharacter.setHideWeaponModel(true);
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        IsoWindow isoWindow = (IsoWindow)hashMap.get(PARAM_WINDOW);
        if (Core.bDebug && DebugOptions.instance.CheatWindowUnlock.getValue() && isoWindow.getSprite() != null && !isoWindow.getSprite().getProperties().Is("WindowLocked")) {
            isoWindow.Locked = false;
            isoWindow.PermaLocked = false;
        }
        if (isoWindow.north) {
            if ((float)isoWindow.getSquare().getY() < isoGameCharacter.getY()) {
                isoGameCharacter.setDir(IsoDirections.N);
            } else {
                isoGameCharacter.setDir(IsoDirections.S);
            }
        } else if ((float)isoWindow.getSquare().getX() < isoGameCharacter.getX()) {
            isoGameCharacter.setDir(IsoDirections.W);
        } else {
            isoGameCharacter.setDir(IsoDirections.E);
        }
        isoGameCharacter.setVariable("bOpenWindow", true);
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        if (!isoGameCharacter.getVariableBoolean("bOpenWindow")) {
            return;
        }
        IsoPlayer isoPlayer = (IsoPlayer)isoGameCharacter;
        if (isoPlayer.pressedMovement(false) || isoPlayer.pressedCancelAction()) {
            isoGameCharacter.setVariable("bOpenWindow", false);
            return;
        }
        IsoWindow isoWindow = (IsoWindow)hashMap.get(PARAM_WINDOW);
        if (isoWindow == null || isoWindow.getObjectIndex() == -1) {
            isoGameCharacter.setVariable("bOpenWindow", false);
            return;
        }
        if (IsoPlayer.getInstance().ContextPanic > 5.0f) {
            IsoPlayer.getInstance().ContextPanic = 0.0f;
            isoGameCharacter.setVariable("bOpenWindow", false);
            isoGameCharacter.smashWindow(isoWindow);
            isoGameCharacter.getStateMachineParams(SmashWindowState.instance()).put(3, Boolean.TRUE);
            return;
        }
        isoPlayer.setCollidable(true);
        isoPlayer.updateLOS();
        if (isoWindow.north) {
            if ((float)isoWindow.getSquare().getY() < isoGameCharacter.getY()) {
                isoGameCharacter.setDir(IsoDirections.N);
            } else {
                isoGameCharacter.setDir(IsoDirections.S);
            }
        } else if ((float)isoWindow.getSquare().getX() < isoGameCharacter.getX()) {
            isoGameCharacter.setDir(IsoDirections.W);
        } else {
            isoGameCharacter.setDir(IsoDirections.E);
        }
        if (Core.bTutorial) {
            if (isoGameCharacter.x != isoWindow.getX() + 0.5f && isoWindow.north) {
                this.slideX(isoGameCharacter, isoWindow.getX() + 0.5f);
            }
            if (isoGameCharacter.y != isoWindow.getY() + 0.5f && !isoWindow.north) {
                this.slideY(isoGameCharacter, isoWindow.getY() + 0.5f);
            }
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(false);
        isoGameCharacter.clearVariable("bOpenWindow");
        isoGameCharacter.clearVariable("OpenWindowOutcome");
        isoGameCharacter.clearVariable("StopAfterAnimLooped");
        isoGameCharacter.setHideWeaponModel(false);
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        if (!isoGameCharacter.getVariableBoolean("bOpenWindow")) {
            return;
        }
        IsoWindow isoWindow = (IsoWindow)hashMap.get(PARAM_WINDOW);
        if (isoWindow == null) {
            isoGameCharacter.setVariable("bOpenWindow", false);
            return;
        }
        if (animEvent.m_EventName.equalsIgnoreCase("WindowAnimLooped")) {
            if ("start".equalsIgnoreCase(animEvent.m_ParameterValue)) {
                if (!(isoWindow.isPermaLocked() || isoWindow.Locked && isoGameCharacter.getCurrentSquare().Is(IsoFlagType.exterior))) {
                    isoGameCharacter.setVariable("OpenWindowOutcome", "success");
                } else {
                    isoGameCharacter.setVariable("OpenWindowOutcome", "struggle");
                }
                return;
            }
            if (animEvent.m_ParameterValue.equalsIgnoreCase(isoGameCharacter.getVariableString("StopAfterAnimLooped"))) {
                isoGameCharacter.setVariable("bOpenWindow", false);
            }
        }
        if (animEvent.m_EventName.equalsIgnoreCase("WindowOpenAttempt")) {
            this.onAttemptFinished(isoGameCharacter, isoWindow);
        } else if (animEvent.m_EventName.equalsIgnoreCase("WindowOpenSuccess")) {
            this.onSuccess(isoGameCharacter, isoWindow);
        } else if (animEvent.m_EventName.equalsIgnoreCase("WindowStruggleSound") && "struggle".equals(isoGameCharacter.getVariableString("OpenWindowOutcome"))) {
            isoGameCharacter.playSound("WindowIsLocked");
        }
    }

    @Override
    public boolean isDoingActionThatCanBeCancelled() {
        return true;
    }

    private void onAttemptFinished(IsoGameCharacter isoGameCharacter, IsoWindow isoWindow) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        this.exert(isoGameCharacter);
        if (isoWindow.isPermaLocked()) {
            if (!isoGameCharacter.getEmitter().isPlaying("WindowIsLocked")) {
                // empty if block
            }
            isoGameCharacter.setVariable("OpenWindowOutcome", "fail");
            isoGameCharacter.setVariable("StopAfterAnimLooped", "fail");
            return;
        }
        int n = 10;
        if (isoGameCharacter.Traits.Burglar.isSet()) {
            n = 5;
        }
        if (isoWindow.Locked && isoGameCharacter.getCurrentSquare().Is(IsoFlagType.exterior)) {
            if (Rand.Next(100) < n) {
                isoGameCharacter.getEmitter().playSound("BreakLockOnWindow", isoWindow);
                isoWindow.setPermaLocked(true);
                isoWindow.syncIsoObject(false, (byte)0, null, null);
                hashMap.put(PARAM_WINDOW, null);
                isoGameCharacter.setVariable("OpenWindowOutcome", "fail");
                isoGameCharacter.setVariable("StopAfterAnimLooped", "fail");
                return;
            }
            boolean bl = false;
            if (isoGameCharacter.getPerkLevel(PerkFactory.Perks.Strength) > 7 && Rand.Next(100) < 20) {
                bl = true;
            } else if (isoGameCharacter.getPerkLevel(PerkFactory.Perks.Strength) > 5 && Rand.Next(100) < 10) {
                bl = true;
            } else if (isoGameCharacter.getPerkLevel(PerkFactory.Perks.Strength) > 3 && Rand.Next(100) < 6) {
                bl = true;
            } else if (isoGameCharacter.getPerkLevel(PerkFactory.Perks.Strength) > 1 && Rand.Next(100) < 4) {
                bl = true;
            } else if (Rand.Next(100) <= 1) {
                bl = true;
            }
            if (bl) {
                isoGameCharacter.setVariable("OpenWindowOutcome", "success");
            }
        } else {
            isoGameCharacter.setVariable("OpenWindowOutcome", "success");
        }
    }

    private void onSuccess(IsoGameCharacter isoGameCharacter, IsoWindow isoWindow) {
        isoGameCharacter.setVariable("StopAfterAnimLooped", "success");
        IsoPlayer.getInstance().ContextPanic = 0.0f;
        if (isoWindow.getObjectIndex() != -1 && !isoWindow.open) {
            isoWindow.ToggleWindow(isoGameCharacter);
        }
    }

    private void exert(IsoGameCharacter isoGameCharacter) {
        float f = GameTime.getInstance().getMultiplier() / 1.6f;
        switch (isoGameCharacter.getPerkLevel(PerkFactory.Perks.Fitness)) {
            case 1: {
                isoGameCharacter.exert(0.01f * f);
                break;
            }
            case 2: {
                isoGameCharacter.exert(0.009f * f);
                break;
            }
            case 3: {
                isoGameCharacter.exert(0.008f * f);
                break;
            }
            case 4: {
                isoGameCharacter.exert(0.007f * f);
                break;
            }
            case 5: {
                isoGameCharacter.exert(0.006f * f);
                break;
            }
            case 6: {
                isoGameCharacter.exert(0.005f * f);
                break;
            }
            case 7: {
                isoGameCharacter.exert(0.004f * f);
                break;
            }
            case 8: {
                isoGameCharacter.exert(0.003f * f);
                break;
            }
            case 9: {
                isoGameCharacter.exert(0.0025f * f);
                break;
            }
            case 10: {
                isoGameCharacter.exert(0.002f * f);
            }
        }
    }

    private void slideX(IsoGameCharacter isoGameCharacter, float f) {
        float f2 = 0.05f * GameTime.getInstance().getMultiplier() / 1.6f;
        f2 = f > isoGameCharacter.x ? Math.min(f2, f - isoGameCharacter.x) : Math.max(-f2, f - isoGameCharacter.x);
        isoGameCharacter.x += f2;
        isoGameCharacter.nx = isoGameCharacter.x;
    }

    private void slideY(IsoGameCharacter isoGameCharacter, float f) {
        float f2 = 0.05f * GameTime.getInstance().getMultiplier() / 1.6f;
        f2 = f > isoGameCharacter.y ? Math.min(f2, f - isoGameCharacter.y) : Math.max(-f2, f - isoGameCharacter.y);
        isoGameCharacter.y += f2;
        isoGameCharacter.ny = isoGameCharacter.y;
    }

    public void setParams(IsoGameCharacter isoGameCharacter, IsoWindow isoWindow) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        hashMap.clear();
        hashMap.put(PARAM_WINDOW, isoWindow);
    }
}

