/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import zombie.GameTime;
import zombie.ai.State;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.gameStates.IngameState;
import zombie.iso.Vector2;
import zombie.network.GameServer;
import zombie.util.Type;

public final class LungeState
extends State {
    private static final LungeState _instance = new LungeState();
    private final Vector2 temp = new Vector2();
    private static final Integer PARAM_TICK_COUNT = 0;

    public static LungeState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        if (System.currentTimeMillis() - isoZombie.LungeSoundTime > 5000L) {
            String string = "MaleZombieAttack";
            if (isoZombie.isFemale()) {
                string = "FemaleZombieAttack";
            }
            if (GameServer.bServer) {
                GameServer.sendZombieSound(IsoZombie.ZombieSound.Lunge, isoZombie);
            }
            isoZombie.LungeSoundTime = System.currentTimeMillis();
        }
        isoZombie.LungeTimer = 180.0f;
        hashMap.put(PARAM_TICK_COUNT, IngameState.instance.numberTicks);
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        long l;
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        isoGameCharacter.setOnFloor(false);
        isoGameCharacter.setShootable(true);
        if (isoZombie.bLunger) {
            isoZombie.walkVariantUse = "ZombieWalk3";
        }
        isoZombie.LungeTimer -= GameTime.getInstance().getMultiplier() / 1.6f;
        IsoPlayer isoPlayer = Type.tryCastTo(isoZombie.getTarget(), IsoPlayer.class);
        if (isoPlayer != null && isoPlayer.isGhostMode()) {
            isoZombie.LungeTimer = 0.0f;
        }
        if (isoZombie.LungeTimer < 0.0f) {
            isoZombie.LungeTimer = 0.0f;
        }
        if (isoZombie.LungeTimer <= 0.0f) {
            isoZombie.AllowRepathDelay = 0.0f;
        }
        this.temp.x = isoZombie.vectorToTarget.x;
        this.temp.y = isoZombie.vectorToTarget.y;
        isoZombie.getZombieLungeSpeed();
        this.temp.normalize();
        isoZombie.setForwardDirection(this.temp);
        isoZombie.DirectionFromVector(this.temp);
        isoZombie.getVectorFromDirection(isoZombie.getForwardDirection());
        isoZombie.setForwardDirection(this.temp);
        if (!isoZombie.isTargetLocationKnown() && isoZombie.LastTargetSeenX != -1 && !isoGameCharacter.getPathFindBehavior2().isTargetLocation((float)isoZombie.LastTargetSeenX + 0.5f, (float)isoZombie.LastTargetSeenY + 0.5f, isoZombie.LastTargetSeenZ)) {
            isoZombie.LungeTimer = 0.0f;
            isoGameCharacter.pathToLocation(isoZombie.LastTargetSeenX, isoZombie.LastTargetSeenY, isoZombie.LastTargetSeenZ);
        }
        if (IngameState.instance.numberTicks - (l = ((Long)hashMap.get(PARAM_TICK_COUNT)).longValue()) == 2L) {
            ((IsoZombie)isoGameCharacter).parameterZombieState.setState(ParameterZombieState.State.LockTarget);
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
    }

    @Override
    public boolean isMoving(IsoGameCharacter isoGameCharacter) {
        return true;
    }
}

