/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.ai.State;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.network.GameClient;

public final class FitnessState
extends State {
    private static final FitnessState _instance = new FitnessState();

    public static FitnessState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(true);
        isoGameCharacter.setVariable("FitnessFinished", false);
        isoGameCharacter.clearVariable("ExerciseStarted");
        isoGameCharacter.clearVariable("ExerciseEnded");
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        if (GameClient.bClient && isoGameCharacter instanceof IsoPlayer && ((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
            GameClient.sendEvent((IsoPlayer)isoGameCharacter, "EventUpdateFitness");
        }
        isoGameCharacter.setIgnoreMovement(false);
        isoGameCharacter.clearVariable("FitnessFinished");
        isoGameCharacter.clearVariable("ExerciseStarted");
        isoGameCharacter.clearVariable("ExerciseHand");
        isoGameCharacter.clearVariable("FitnessStruggle");
        isoGameCharacter.setVariable("ExerciseEnded", true);
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
    }
}

