/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.ai.State;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.iso.objects.IsoDeadBody;
import zombie.network.GameClient;

public final class FakeDeadZombieState
extends State {
    private static final FakeDeadZombieState _instance = new FakeDeadZombieState();

    public static FakeDeadZombieState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setVisibleToNPCs(false);
        isoGameCharacter.setCollidable(false);
        ((IsoZombie)isoGameCharacter).setFakeDead(true);
        isoGameCharacter.setOnFloor(true);
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter.isDead()) {
            if (GameClient.bClient && isoGameCharacter instanceof IsoZombie) {
                GameClient.sendZombieDeath((IsoZombie)isoGameCharacter);
            }
            if (!GameClient.bClient) {
                IsoDeadBody isoDeadBody = new IsoDeadBody(isoGameCharacter);
            }
        } else if (Core.bLastStand) {
            ((IsoZombie)isoGameCharacter).setFakeDead(false);
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        ((IsoZombie)isoGameCharacter).setFakeDead(false);
    }
}

