/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.ai.State;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;

public final class FakeDeadAttackState
extends State {
    private static final FakeDeadAttackState _instance = new FakeDeadAttackState();

    public static FakeDeadAttackState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        isoZombie.DirectionFromVector(isoZombie.vectorToTarget);
        isoZombie.setFakeDead(false);
        isoGameCharacter.setVisibleToNPCs(true);
        isoGameCharacter.setCollidable(true);
        String string = "MaleZombieAttack";
        if (isoGameCharacter.isFemale()) {
            string = "FemaleZombieAttack";
        }
        isoGameCharacter.getEmitter().playSound(string);
        if (isoZombie.target instanceof IsoPlayer && !((IsoPlayer)isoZombie.target).getCharacterTraits().Desensitized.isSet()) {
            IsoPlayer isoPlayer = (IsoPlayer)isoZombie.target;
            isoPlayer.getStats().Panic += isoPlayer.getBodyDamage().getPanicIncreaseValue() * 3.0f;
        }
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        IsoGameCharacter isoGameCharacter2;
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        if (animEvent.m_EventName.equalsIgnoreCase("AttackCollisionCheck") && isoGameCharacter.isAlive() && isoZombie.isTargetInCone(1.5f, 0.9f) && isoZombie.target instanceof IsoGameCharacter && ((isoGameCharacter2 = (IsoGameCharacter)isoZombie.target).getVehicle() == null || isoGameCharacter2.getVehicle().couldCrawlerAttackPassenger(isoGameCharacter2))) {
            isoGameCharacter2.getBodyDamage().AddRandomDamageFromZombie((IsoZombie)isoGameCharacter, null);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("FallOnFront")) {
            isoZombie.setFallOnFront(Boolean.parseBoolean(animEvent.m_ParameterValue));
        }
        if (animEvent.m_EventName.equalsIgnoreCase("ActiveAnimFinishing")) {
            isoZombie.setCrawler(true);
        }
    }
}

