/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.ai.State;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.core.math.PZMath;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.iso.IsoDirections;
import zombie.iso.Vector2;

public final class CrawlingZombieTurnState
extends State {
    private static final CrawlingZombieTurnState _instance = new CrawlingZombieTurnState();
    private static final Vector2 tempVector2_1 = new Vector2();
    private static final Vector2 tempVector2_2 = new Vector2();

    public static CrawlingZombieTurnState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        ((IsoZombie)isoGameCharacter).AllowRepathDelay = 0.0f;
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        if (animEvent.m_EventName.equalsIgnoreCase("TurnSome")) {
            Vector2 vector22 = tempVector2_1.set(isoGameCharacter.dir.ToVector());
            Vector2 vector23 = "left".equalsIgnoreCase(animEvent.m_ParameterValue) ? IsoDirections.fromIndex(isoGameCharacter.dir.index() + 1).ToVector() : IsoDirections.fromIndex(isoGameCharacter.dir.index() - 1).ToVector();
            Vector2 vector24 = PZMath.lerp(tempVector2_2, vector22, vector23, animEvent.m_TimePc);
            isoGameCharacter.setForwardDirection(vector24);
            return;
        }
        if (animEvent.m_EventName.equalsIgnoreCase("TurnComplete")) {
            isoGameCharacter.dir = "left".equalsIgnoreCase(animEvent.m_ParameterValue) ? IsoDirections.fromIndex(isoGameCharacter.dir.index() + 1) : IsoDirections.fromIndex(isoGameCharacter.dir.index() - 1);
            isoGameCharacter.getVectorFromDirection(isoGameCharacter.getForwardDirection());
        }
    }

    public static boolean calculateDir(IsoGameCharacter isoGameCharacter, IsoDirections isoDirections) {
        if (isoDirections.index() > isoGameCharacter.dir.index()) {
            return isoDirections.index() - isoGameCharacter.dir.index() <= 4;
        }
        return isoDirections.index() - isoGameCharacter.dir.index() < -4;
    }
}

