/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import fmod.fmod.FMODManager;
import zombie.ai.State;
import zombie.audio.parameters.ParameterCharacterMovementSpeed;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.iso.IsoDirections;

public final class CollideWithWallState
extends State {
    private static final CollideWithWallState _instance = new CollideWithWallState();

    public static CollideWithWallState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(true);
        if (isoGameCharacter instanceof IsoPlayer) {
            ((IsoPlayer)isoGameCharacter).setIsAiming(false);
        }
        if (isoGameCharacter.isCollidedN()) {
            isoGameCharacter.setDir(IsoDirections.N);
        }
        if (isoGameCharacter.isCollidedS()) {
            isoGameCharacter.setDir(IsoDirections.S);
        }
        if (isoGameCharacter.isCollidedE()) {
            isoGameCharacter.setDir(IsoDirections.E);
        }
        if (isoGameCharacter.isCollidedW()) {
            isoGameCharacter.setDir(IsoDirections.W);
        }
        isoGameCharacter.setCollideType("wall");
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setLastCollideTime(70.0f);
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setCollideType(null);
        isoGameCharacter.setIgnoreMovement(false);
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        if ("PlayCollideSound".equalsIgnoreCase(animEvent.m_EventName)) {
            long l = isoGameCharacter.playSound(animEvent.m_ParameterValue);
            ParameterCharacterMovementSpeed parameterCharacterMovementSpeed = ((IsoPlayer)isoGameCharacter).getParameterCharacterMovementSpeed();
            isoGameCharacter.getEmitter().setParameterValue(l, parameterCharacterMovementSpeed.getParameterDescription(), ParameterCharacterMovementSpeed.MovementType.Sprint.label);
            isoGameCharacter.getEmitter().setParameterValue(l, FMODManager.instance.getParameterDescription("TripObstacleType"), 7.0f);
        }
    }
}

