/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import fmod.fmod.FMODManager;
import java.util.HashMap;
import zombie.GameTime;
import zombie.SoundManager;
import zombie.ai.State;
import zombie.ai.states.PathFindState;
import zombie.ai.states.WalkTowardNetworkState;
import zombie.ai.states.WalkTowardState;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.characters.MoveDeltaModifiers;
import zombie.characters.skills.PerkFactory;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.Vector2;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.IsoWindowFrame;
import zombie.util.Type;

public final class ClimbThroughWindowState
extends State {
    private static final ClimbThroughWindowState _instance = new ClimbThroughWindowState();
    static final Integer PARAM_START_X = 0;
    static final Integer PARAM_START_Y = 1;
    static final Integer PARAM_Z = 2;
    static final Integer PARAM_OPPOSITE_X = 3;
    static final Integer PARAM_OPPOSITE_Y = 4;
    static final Integer PARAM_DIR = 5;
    static final Integer PARAM_ZOMBIE_ON_FLOOR = 6;
    static final Integer PARAM_PREV_STATE = 7;
    static final Integer PARAM_SCRATCH = 8;
    static final Integer PARAM_COUNTER = 9;
    static final Integer PARAM_SOLID_FLOOR = 10;
    static final Integer PARAM_SHEET_ROPE = 11;
    static final Integer PARAM_END_X = 12;
    static final Integer PARAM_END_Y = 13;

    public static ClimbThroughWindowState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(true);
        isoGameCharacter.setHideWeaponModel(true);
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        boolean bl = hashMap.get(PARAM_COUNTER) == Boolean.TRUE;
        isoGameCharacter.setVariable("ClimbWindowStarted", false);
        isoGameCharacter.setVariable("ClimbWindowEnd", false);
        isoGameCharacter.setVariable("ClimbWindowFinished", false);
        isoGameCharacter.clearVariable("ClimbWindowGetUpBack");
        isoGameCharacter.clearVariable("ClimbWindowGetUpFront");
        isoGameCharacter.setVariable("ClimbWindowOutcome", bl ? "obstacle" : "success");
        isoGameCharacter.clearVariable("ClimbWindowFlopped");
        IsoZombie isoZombie = Type.tryCastTo(isoGameCharacter, IsoZombie.class);
        if (!bl && isoZombie != null && isoZombie.shouldDoFenceLunge()) {
            this.setLungeXVars(isoZombie);
            isoGameCharacter.setVariable("ClimbWindowOutcome", "lunge");
        }
        if (hashMap.get(PARAM_SOLID_FLOOR) == Boolean.FALSE) {
            isoGameCharacter.setVariable("ClimbWindowOutcome", "fall");
        }
        if (!(isoGameCharacter instanceof IsoZombie) && hashMap.get(PARAM_SHEET_ROPE) == Boolean.TRUE) {
            isoGameCharacter.setVariable("ClimbWindowOutcome", "rope");
        }
        if (isoGameCharacter instanceof IsoPlayer && ((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
            ((IsoPlayer)isoGameCharacter).dirtyRecalcGridStackTime = 20.0f;
        }
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        int n;
        IsoGridSquare isoGridSquare;
        float f;
        float f2;
        int n2;
        int n3;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        if (this.isWindowClosing(isoGameCharacter)) {
            return;
        }
        IsoDirections isoDirections = (IsoDirections)((Object)hashMap.get(PARAM_DIR));
        isoGameCharacter.setDir(isoDirections);
        String string = isoGameCharacter.getVariableString("ClimbWindowOutcome");
        if (isoGameCharacter instanceof IsoZombie) {
            int n4;
            IsoGridSquare isoGridSquare2;
            boolean bl;
            boolean bl2 = bl = hashMap.get(PARAM_ZOMBIE_ON_FLOOR) == Boolean.TRUE;
            if (!isoGameCharacter.isFallOnFront() && bl && (isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(n4 = ((Integer)hashMap.get(PARAM_OPPOSITE_X)).intValue(), n3 = ((Integer)hashMap.get(PARAM_OPPOSITE_Y)).intValue(), n2 = ((Integer)hashMap.get(PARAM_Z)).intValue())) != null && isoGridSquare2.getBrokenGlass() != null) {
                isoGameCharacter.addBlood(BloodBodyPartType.Head, true, true, true);
                isoGameCharacter.addBlood(BloodBodyPartType.Head, true, true, true);
                isoGameCharacter.addBlood(BloodBodyPartType.Head, true, true, true);
                isoGameCharacter.addBlood(BloodBodyPartType.Head, true, true, true);
                isoGameCharacter.addBlood(BloodBodyPartType.Head, true, true, true);
                isoGameCharacter.addBlood(BloodBodyPartType.Neck, true, true, true);
                isoGameCharacter.addBlood(BloodBodyPartType.Neck, true, true, true);
                isoGameCharacter.addBlood(BloodBodyPartType.Neck, true, true, true);
                isoGameCharacter.addBlood(BloodBodyPartType.Neck, true, true, true);
                isoGameCharacter.addBlood(BloodBodyPartType.Torso_Upper, true, true, true);
                isoGameCharacter.addBlood(BloodBodyPartType.Torso_Upper, true, true, true);
                isoGameCharacter.addBlood(BloodBodyPartType.Torso_Upper, true, true, true);
            }
            isoGameCharacter.setOnFloor(bl);
            ((IsoZombie)isoGameCharacter).setKnockedDown(bl);
            isoGameCharacter.setFallOnFront(bl);
        }
        float f3 = (float)((Integer)hashMap.get(PARAM_START_X)).intValue() + 0.5f;
        float f4 = (float)((Integer)hashMap.get(PARAM_START_Y)).intValue() + 0.5f;
        if (!isoGameCharacter.getVariableBoolean("ClimbWindowStarted")) {
            if (isoGameCharacter.x != f3 && (isoDirections == IsoDirections.N || isoDirections == IsoDirections.S)) {
                this.slideX(isoGameCharacter, f3);
            }
            if (isoGameCharacter.y != f4 && (isoDirections == IsoDirections.W || isoDirections == IsoDirections.E)) {
                this.slideY(isoGameCharacter, f4);
            }
        }
        if (isoGameCharacter instanceof IsoPlayer && string.equalsIgnoreCase("obstacle") && isoGameCharacter.DistToSquared(f2 = (float)((Integer)hashMap.get(PARAM_END_X)).intValue() + 0.5f, f = (float)((Integer)hashMap.get(PARAM_END_Y)).intValue() + 0.5f) < 0.5625f) {
            isoGameCharacter.setVariable("ClimbWindowOutcome", "obstacleEnd");
        }
        if (!(!(isoGameCharacter instanceof IsoPlayer) || isoGameCharacter.getVariableBoolean("ClimbWindowEnd") || "fallfront".equals(string) || "back".equals(string) || "fallback".equals(string) || (isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n3 = ((Integer)hashMap.get(PARAM_OPPOSITE_X)).intValue(), n2 = ((Integer)hashMap.get(PARAM_OPPOSITE_Y)).intValue(), n = ((Integer)hashMap.get(PARAM_Z)).intValue())) == null)) {
            this.checkForFallingBack(isoGridSquare, isoGameCharacter);
            if (isoGridSquare != isoGameCharacter.getSquare() && isoGridSquare.TreatAsSolidFloor()) {
                this.checkForFallingFront(isoGameCharacter.getSquare(), isoGameCharacter);
            }
        }
        if (!(!isoGameCharacter.getVariableBoolean("ClimbWindowStarted") || "back".equals(string) || "fallback".equals(string) || "lunge".equals(string) || "obstacle".equals(string) || "obstacleEnd".equals(string))) {
            float f5 = ((Integer)hashMap.get(PARAM_START_X)).intValue();
            float f6 = ((Integer)hashMap.get(PARAM_START_Y)).intValue();
            switch (isoDirections) {
                case N: {
                    f6 -= 0.1f;
                    break;
                }
                case S: {
                    f6 += 1.1f;
                    break;
                }
                case W: {
                    f5 -= 0.1f;
                    break;
                }
                case E: {
                    f5 += 1.1f;
                }
            }
            if ((int)isoGameCharacter.x != (int)f5 && (isoDirections == IsoDirections.W || isoDirections == IsoDirections.E)) {
                this.slideX(isoGameCharacter, f5);
            }
            if ((int)isoGameCharacter.y != (int)f6 && (isoDirections == IsoDirections.N || isoDirections == IsoDirections.S)) {
                this.slideY(isoGameCharacter, f6);
            }
        }
        if (isoGameCharacter.getVariableBoolean("ClimbWindowStarted") && hashMap.get(PARAM_SCRATCH) == Boolean.TRUE) {
            hashMap.put(PARAM_SCRATCH, Boolean.FALSE);
            isoGameCharacter.getBodyDamage().setScratchedWindow();
        }
    }

    private void checkForFallingBack(IsoGridSquare isoGridSquare, IsoGameCharacter isoGameCharacter) {
        for (int i = 0; i < isoGridSquare.getMovingObjects().size(); ++i) {
            IsoMovingObject isoMovingObject = isoGridSquare.getMovingObjects().get(i);
            IsoZombie isoZombie = Type.tryCastTo(isoMovingObject, IsoZombie.class);
            if (isoZombie == null || isoZombie.isOnFloor() || isoZombie.isSitAgainstWall()) continue;
            if (isoZombie.isVariable("AttackOutcome", "success") || Rand.Next(5 + isoGameCharacter.getPerkLevel(PerkFactory.Perks.Fitness)) == 0) {
                isoZombie.playHurtSound();
                isoGameCharacter.setVariable("ClimbWindowOutcome", "fallback");
                continue;
            }
            isoZombie.playHurtSound();
            isoGameCharacter.setVariable("ClimbWindowOutcome", "back");
        }
    }

    private void checkForFallingFront(IsoGridSquare isoGridSquare, IsoGameCharacter isoGameCharacter) {
        for (int i = 0; i < isoGridSquare.getMovingObjects().size(); ++i) {
            IsoMovingObject isoMovingObject = isoGridSquare.getMovingObjects().get(i);
            IsoZombie isoZombie = Type.tryCastTo(isoMovingObject, IsoZombie.class);
            if (isoZombie == null || isoZombie.isOnFloor() || isoZombie.isSitAgainstWall() || !isoZombie.isVariable("AttackOutcome", "success")) continue;
            isoZombie.playHurtSound();
            isoGameCharacter.setVariable("ClimbWindowOutcome", "fallfront");
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie;
        isoGameCharacter.setIgnoreMovement(false);
        isoGameCharacter.setHideWeaponModel(false);
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        if (isoGameCharacter.isVariable("ClimbWindowOutcome", "fall") || isoGameCharacter.isVariable("ClimbWindowOutcome", "fallback") || isoGameCharacter.isVariable("ClimbWindowOutcome", "fallfront")) {
            isoGameCharacter.setHitReaction("");
        }
        isoGameCharacter.clearVariable("ClimbWindowFinished");
        isoGameCharacter.clearVariable("ClimbWindowOutcome");
        isoGameCharacter.clearVariable("ClimbWindowStarted");
        isoGameCharacter.clearVariable("ClimbWindowFlopped");
        if (isoGameCharacter instanceof IsoZombie) {
            isoGameCharacter.setOnFloor(false);
            ((IsoZombie)isoGameCharacter).setKnockedDown(false);
        }
        if ((isoZombie = Type.tryCastTo(isoGameCharacter, IsoZombie.class)) != null) {
            isoZombie.AllowRepathDelay = 0.0f;
            if (hashMap.get(PARAM_PREV_STATE) == PathFindState.instance()) {
                if (isoGameCharacter.getPathFindBehavior2().getTargetChar() == null) {
                    isoGameCharacter.setVariable("bPathFind", true);
                    isoGameCharacter.setVariable("bMoving", false);
                } else if (isoZombie.isTargetLocationKnown()) {
                    isoGameCharacter.pathToCharacter(isoGameCharacter.getPathFindBehavior2().getTargetChar());
                } else if (isoZombie.LastTargetSeenX != -1) {
                    isoGameCharacter.pathToLocation(isoZombie.LastTargetSeenX, isoZombie.LastTargetSeenY, isoZombie.LastTargetSeenZ);
                }
            } else if (hashMap.get(PARAM_PREV_STATE) == WalkTowardState.instance() || hashMap.get(PARAM_PREV_STATE) == WalkTowardNetworkState.instance()) {
                isoGameCharacter.setVariable("bPathFind", false);
                isoGameCharacter.setVariable("bMoving", true);
            }
        }
        if (isoGameCharacter instanceof IsoZombie) {
            ((IsoZombie)isoGameCharacter).networkAI.isClimbing = false;
        }
    }

    public void slideX(IsoGameCharacter isoGameCharacter, float f) {
        float f2 = 0.05f * GameTime.getInstance().getMultiplier() / 1.6f;
        f2 = f > isoGameCharacter.x ? Math.min(f2, f - isoGameCharacter.x) : Math.max(-f2, f - isoGameCharacter.x);
        isoGameCharacter.x += f2;
        isoGameCharacter.nx = isoGameCharacter.x;
    }

    public void slideY(IsoGameCharacter isoGameCharacter, float f) {
        float f2 = 0.05f * GameTime.getInstance().getMultiplier() / 1.6f;
        f2 = f > isoGameCharacter.y ? Math.min(f2, f - isoGameCharacter.y) : Math.max(-f2, f - isoGameCharacter.y);
        isoGameCharacter.y += f2;
        isoGameCharacter.ny = isoGameCharacter.y;
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        IsoZombie isoZombie = Type.tryCastTo(isoGameCharacter, IsoZombie.class);
        if (animEvent.m_EventName.equalsIgnoreCase("CheckAttack") && isoZombie != null && isoZombie.target instanceof IsoGameCharacter) {
            ((IsoGameCharacter)isoZombie.target).attackFromWindowsLunge(isoZombie);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("OnFloor") && isoZombie != null) {
            boolean bl = Boolean.parseBoolean(animEvent.m_ParameterValue);
            hashMap.put(PARAM_ZOMBIE_ON_FLOOR, bl);
            if (bl) {
                this.setLungeXVars(isoZombie);
                IsoThumpable isoThumpable = Type.tryCastTo(this.getWindow(isoGameCharacter), IsoThumpable.class);
                if (isoThumpable != null && isoThumpable.getSquare() != null && isoZombie.target != null) {
                    isoThumpable.Health -= Rand.Next(10, 20);
                    if (isoThumpable.Health <= 0) {
                        isoThumpable.destroy();
                    }
                }
                isoGameCharacter.setVariable("ClimbWindowFlopped", true);
            }
        }
        if (animEvent.m_EventName.equalsIgnoreCase("PlayWindowSound")) {
            if (!SoundManager.instance.isListenerInRange(isoGameCharacter.getX(), isoGameCharacter.getY(), 10.0f)) {
                return;
            }
            long l = isoGameCharacter.getEmitter().playSoundImpl(animEvent.m_ParameterValue, null);
            isoGameCharacter.getEmitter().setParameterValue(l, FMODManager.instance.getParameterDescription("TripObstacleType"), 9.0f);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("SetState")) {
            if (isoZombie == null) {
                return;
            }
            try {
                ParameterZombieState.State state = ParameterZombieState.State.valueOf(animEvent.m_ParameterValue);
                isoZombie.parameterZombieState.setState(state);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isIgnoreCollide(IsoGameCharacter isoGameCharacter, int n, int n2, int n3, int n4, int n5, int n6) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        int n7 = (Integer)hashMap.get(PARAM_START_X);
        int n8 = (Integer)hashMap.get(PARAM_START_Y);
        int n9 = (Integer)hashMap.get(PARAM_END_X);
        int n10 = (Integer)hashMap.get(PARAM_END_Y);
        int n11 = (Integer)hashMap.get(PARAM_Z);
        if (n11 != n3 || n11 != n6) {
            return false;
        }
        int n12 = PZMath.min(n7, n9);
        int n13 = PZMath.min(n8, n10);
        int n14 = PZMath.max(n7, n9);
        int n15 = PZMath.max(n8, n10);
        int n16 = PZMath.min(n, n4);
        int n17 = PZMath.min(n2, n5);
        int n18 = PZMath.max(n, n4);
        int n19 = PZMath.max(n2, n5);
        return n12 <= n16 && n13 <= n17 && n14 >= n18 && n15 >= n19;
    }

    public IsoObject getWindow(IsoGameCharacter isoGameCharacter) {
        if (!isoGameCharacter.isCurrentState(this)) {
            return null;
        }
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        int n = (Integer)hashMap.get(PARAM_START_X);
        int n2 = (Integer)hashMap.get(PARAM_START_Y);
        int n3 = (Integer)hashMap.get(PARAM_Z);
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        int n4 = (Integer)hashMap.get(PARAM_END_X);
        int n5 = (Integer)hashMap.get(PARAM_END_Y);
        IsoGridSquare isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(n4, n5, n3);
        if (isoGridSquare == null || isoGridSquare2 == null) {
            return null;
        }
        IsoObject isoObject = isoGridSquare.getWindowTo(isoGridSquare2);
        if (isoObject == null) {
            isoObject = isoGridSquare.getWindowThumpableTo(isoGridSquare2);
        }
        if (isoObject == null) {
            isoObject = isoGridSquare.getHoppableTo(isoGridSquare2);
        }
        return isoObject;
    }

    public boolean isWindowClosing(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        if (isoGameCharacter.getVariableBoolean("ClimbWindowStarted")) {
            return false;
        }
        int n = (Integer)hashMap.get(PARAM_START_X);
        int n2 = (Integer)hashMap.get(PARAM_START_Y);
        int n3 = (Integer)hashMap.get(PARAM_Z);
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        if (isoGameCharacter.getCurrentSquare() != isoGridSquare) {
            return false;
        }
        IsoWindow isoWindow = Type.tryCastTo(this.getWindow(isoGameCharacter), IsoWindow.class);
        if (isoWindow == null) {
            return false;
        }
        IsoGameCharacter isoGameCharacter2 = isoWindow.getFirstCharacterClosing();
        if (isoGameCharacter2 == null || !isoGameCharacter2.isVariable("CloseWindowOutcome", "success")) {
            return false;
        }
        if (isoGameCharacter.isZombie()) {
            isoGameCharacter.setHitReaction("HeadLeft");
        } else {
            isoGameCharacter.setVariable("ClimbWindowFinished", true);
        }
        return true;
    }

    @Override
    public void getDeltaModifiers(IsoGameCharacter isoGameCharacter, MoveDeltaModifiers moveDeltaModifiers) {
        boolean bl = isoGameCharacter.getPath2() != null;
        boolean bl2 = isoGameCharacter instanceof IsoPlayer;
        if (bl && bl2) {
            moveDeltaModifiers.turnDelta = Math.max(moveDeltaModifiers.turnDelta, 10.0f);
        }
        if (bl2 && isoGameCharacter.getVariableBoolean("isTurning")) {
            moveDeltaModifiers.turnDelta = Math.max(moveDeltaModifiers.turnDelta, 5.0f);
        }
    }

    private boolean isFreeSquare(IsoGridSquare isoGridSquare) {
        return isoGridSquare != null && isoGridSquare.TreatAsSolidFloor() && !isoGridSquare.Is(IsoFlagType.solid) && !isoGridSquare.Is(IsoFlagType.solidtrans);
    }

    private boolean isObstacleSquare(IsoGridSquare isoGridSquare) {
        return isoGridSquare != null && isoGridSquare.TreatAsSolidFloor() && !isoGridSquare.Is(IsoFlagType.solid) && isoGridSquare.Is(IsoFlagType.solidtrans) && !isoGridSquare.Is(IsoFlagType.water);
    }

    private IsoGridSquare getFreeSquareAfterObstacles(IsoGridSquare isoGridSquare, IsoDirections isoDirections) {
        IsoGridSquare isoGridSquare2;
        while ((isoGridSquare2 = isoGridSquare.getAdjacentSquare(isoDirections)) != null && !isoGridSquare.isSomethingTo(isoGridSquare2) && isoGridSquare.getWindowFrameTo(isoGridSquare2) == null && isoGridSquare.getWindowThumpableTo(isoGridSquare2) == null) {
            if (this.isFreeSquare(isoGridSquare2)) {
                return isoGridSquare2;
            }
            if (!this.isObstacleSquare(isoGridSquare2)) {
                return null;
            }
            isoGridSquare = isoGridSquare2;
        }
        return null;
    }

    private void setLungeXVars(IsoZombie isoZombie) {
        IsoMovingObject isoMovingObject = isoZombie.getTarget();
        if (isoMovingObject == null) {
            return;
        }
        isoZombie.setVariable("FenceLungeX", 0.0f);
        isoZombie.setVariable("FenceLungeY", 0.0f);
        float f = 0.0f;
        Vector2 vector22 = isoZombie.getForwardDirection();
        PZMath.SideOfLine sideOfLine = PZMath.testSideOfLine(isoZombie.x, isoZombie.y, isoZombie.x + vector22.x, isoZombie.y + vector22.y, isoMovingObject.x, isoMovingObject.y);
        float f2 = (float)Math.acos(isoZombie.getDotWithForwardDirection(isoMovingObject.x, isoMovingObject.y));
        float f3 = PZMath.clamp(PZMath.radToDeg(f2), 0.0f, 90.0f);
        switch (sideOfLine) {
            case Left: {
                f = -f3 / 90.0f;
                break;
            }
            case OnLine: {
                f = 0.0f;
                break;
            }
            case Right: {
                f = f3 / 90.0f;
            }
        }
        isoZombie.setVariable("FenceLungeX", f);
    }

    public boolean isPastInnerEdgeOfSquare(IsoGameCharacter isoGameCharacter, int n, int n2, IsoDirections isoDirections) {
        if (isoDirections == IsoDirections.N) {
            return isoGameCharacter.y < (float)(n2 + 1) - 0.3f;
        }
        if (isoDirections == IsoDirections.S) {
            return isoGameCharacter.y > (float)n2 + 0.3f;
        }
        if (isoDirections == IsoDirections.W) {
            return isoGameCharacter.x < (float)(n + 1) - 0.3f;
        }
        if (isoDirections == IsoDirections.E) {
            return isoGameCharacter.x > (float)n + 0.3f;
        }
        throw new IllegalArgumentException("unhandled direction");
    }

    public boolean isPastOuterEdgeOfSquare(IsoGameCharacter isoGameCharacter, int n, int n2, IsoDirections isoDirections) {
        if (isoDirections == IsoDirections.N) {
            return isoGameCharacter.y < (float)n2 - 0.3f;
        }
        if (isoDirections == IsoDirections.S) {
            return isoGameCharacter.y > (float)(n2 + 1) + 0.3f;
        }
        if (isoDirections == IsoDirections.W) {
            return isoGameCharacter.x < (float)n - 0.3f;
        }
        if (isoDirections == IsoDirections.E) {
            return isoGameCharacter.x > (float)(n + 1) + 0.3f;
        }
        throw new IllegalArgumentException("unhandled direction");
    }

    public void setParams(IsoGameCharacter isoGameCharacter, IsoObject isoObject) {
        IsoGridSquare isoGridSquare;
        boolean bl;
        Object object;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        hashMap.clear();
        boolean bl2 = false;
        if (isoObject instanceof IsoWindow) {
            object = (IsoWindow)isoObject;
            bl = object.north;
            if (isoGameCharacter instanceof IsoPlayer && object.isDestroyed() && !object.isGlassRemoved() && Rand.Next(2) == 0) {
                bl2 = true;
            }
        } else if (isoObject instanceof IsoThumpable) {
            object = (IsoThumpable)isoObject;
            bl = ((IsoThumpable)object).north;
            if (isoGameCharacter instanceof IsoPlayer && object.getName().equals("Barbed Fence") && Rand.Next(101) > 75) {
                bl2 = true;
            }
        } else if (IsoWindowFrame.isWindowFrame(isoObject)) {
            bl = IsoWindowFrame.isWindowFrame(isoObject, true);
        } else {
            throw new IllegalArgumentException("expected thumpable, window, or window-frame");
        }
        int n = isoObject.getSquare().getX();
        int n2 = isoObject.getSquare().getY();
        int n3 = isoObject.getSquare().getZ();
        int n4 = n;
        int n5 = n2;
        int n6 = n;
        int n7 = n2;
        if (bl) {
            if ((float)n2 < isoGameCharacter.getY()) {
                --n7;
                object = IsoDirections.N;
            } else {
                --n5;
                object = IsoDirections.S;
            }
        } else if ((float)n < isoGameCharacter.getX()) {
            --n6;
            object = IsoDirections.W;
        } else {
            --n4;
            object = IsoDirections.E;
        }
        IsoGridSquare isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(n6, n7, n3);
        boolean bl3 = isoGridSquare2 != null && isoGridSquare2.Is(IsoFlagType.solidtrans);
        boolean bl4 = isoGridSquare2 != null && isoGridSquare2.TreatAsSolidFloor();
        boolean bl5 = isoGridSquare2 != null && isoGameCharacter.canClimbDownSheetRope(isoGridSquare2);
        int n8 = n6;
        int n9 = n7;
        if (bl3 && isoGameCharacter.isZombie()) {
            isoGridSquare = isoGridSquare2.getAdjacentSquare((IsoDirections)((Object)object));
            if (!this.isFreeSquare(isoGridSquare) || isoGridSquare2.isSomethingTo(isoGridSquare) || isoGridSquare2.getWindowFrameTo(isoGridSquare) != null || isoGridSquare2.getWindowThumpableTo(isoGridSquare) != null) {
                bl3 = false;
            } else {
                n8 = isoGridSquare.x;
                n9 = isoGridSquare.y;
            }
        }
        if (bl3 && !isoGameCharacter.isZombie()) {
            isoGridSquare = this.getFreeSquareAfterObstacles(isoGridSquare2, (IsoDirections)((Object)object));
            if (isoGridSquare == null) {
                bl3 = false;
            } else {
                n8 = isoGridSquare.x;
                n9 = isoGridSquare.y;
            }
        }
        hashMap.put(PARAM_START_X, n4);
        hashMap.put(PARAM_START_Y, n5);
        hashMap.put(PARAM_Z, n3);
        hashMap.put(PARAM_OPPOSITE_X, n6);
        hashMap.put(PARAM_OPPOSITE_Y, n7);
        hashMap.put(PARAM_END_X, n8);
        hashMap.put(PARAM_END_Y, n9);
        hashMap.put(PARAM_DIR, object);
        hashMap.put(PARAM_ZOMBIE_ON_FLOOR, Boolean.FALSE);
        hashMap.put(PARAM_PREV_STATE, isoGameCharacter.getCurrentState());
        hashMap.put(PARAM_SCRATCH, bl2 ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put(PARAM_COUNTER, bl3 ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put(PARAM_SOLID_FLOOR, bl4 ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put(PARAM_SHEET_ROPE, bl5 ? Boolean.TRUE : Boolean.FALSE);
    }
}

