/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import zombie.GameTime;
import zombie.ai.State;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.skills.PerkFactory;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.IsoWindowFrame;

public final class ClimbSheetRopeState
extends State {
    public static final float CLIMB_SPEED = 0.16f;
    private static final float CLIMB_SLOWDOWN = 0.5f;
    private static final ClimbSheetRopeState _instance = new ClimbSheetRopeState();

    public static ClimbSheetRopeState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(true);
        isoGameCharacter.setbClimbing(true);
        isoGameCharacter.setVariable("ClimbRope", true);
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        float f;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (isoGameCharacter.getCurrentSquare().getProperties().Is(IsoFlagType.climbSheetN) || isoGameCharacter.getCurrentSquare().getProperties().Is(IsoFlagType.climbSheetTopN)) {
            isoGameCharacter.setDir(IsoDirections.N);
            f2 = 0.54f;
            f3 = 0.39f;
        }
        if (isoGameCharacter.getCurrentSquare().getProperties().Is(IsoFlagType.climbSheetS) || isoGameCharacter.getCurrentSquare().getProperties().Is(IsoFlagType.climbSheetTopS)) {
            isoGameCharacter.setDir(IsoDirections.S);
            f2 = 0.118f;
            f3 = 0.5756f;
        }
        if (isoGameCharacter.getCurrentSquare().getProperties().Is(IsoFlagType.climbSheetW) || isoGameCharacter.getCurrentSquare().getProperties().Is(IsoFlagType.climbSheetTopW)) {
            isoGameCharacter.setDir(IsoDirections.W);
            f2 = 0.4f;
            f3 = 0.7f;
        }
        if (isoGameCharacter.getCurrentSquare().getProperties().Is(IsoFlagType.climbSheetE) || isoGameCharacter.getCurrentSquare().getProperties().Is(IsoFlagType.climbSheetTopE)) {
            isoGameCharacter.setDir(IsoDirections.E);
            f2 = 0.5417f;
            f3 = 0.3144f;
        }
        float f4 = isoGameCharacter.x - (float)((int)isoGameCharacter.x);
        float f5 = isoGameCharacter.y - (float)((int)isoGameCharacter.y);
        if (f4 != f2) {
            f = (f2 - f4) / 4.0f;
            isoGameCharacter.x = (float)((int)isoGameCharacter.x) + (f4 += f);
        }
        if (f5 != f3) {
            f = (f3 - f5) / 4.0f;
            isoGameCharacter.y = (float)((int)isoGameCharacter.y) + (f5 += f);
        }
        isoGameCharacter.nx = isoGameCharacter.x;
        isoGameCharacter.ny = isoGameCharacter.y;
        isoGameCharacter.getSpriteDef().AnimFrameIncrease = f = this.getClimbSheetRopeSpeed(isoGameCharacter);
        float f6 = isoGameCharacter.z + f / 10.0f * GameTime.instance.getMultiplier();
        f6 = Math.min(f6, 7.0f);
        int n = (int)isoGameCharacter.z;
        while ((float)n <= f6) {
            IsoCell isoCell = IsoWorld.instance.getCell();
            IsoGridSquare isoGridSquare = isoCell.getGridSquare(isoGameCharacter.getX(), isoGameCharacter.getY(), (double)n);
            if (IsoWindow.isTopOfSheetRopeHere(isoGridSquare)) {
                isoGameCharacter.z = n;
                isoGameCharacter.setCurrent(isoGridSquare);
                isoGameCharacter.setCollidable(true);
                IsoGridSquare isoGridSquare2 = isoGridSquare.nav[isoGameCharacter.dir.index()];
                if (isoGridSquare2 != null) {
                    if (!isoGridSquare2.TreatAsSolidFloor()) {
                        isoGameCharacter.climbDownSheetRope();
                        return;
                    }
                    IsoWindow isoWindow = isoGridSquare.getWindowTo(isoGridSquare2);
                    if (isoWindow != null) {
                        if (!isoWindow.open) {
                            isoWindow.ToggleWindow(isoGameCharacter);
                        }
                        if (!isoWindow.canClimbThrough(isoGameCharacter)) {
                            isoGameCharacter.climbDownSheetRope();
                            return;
                        }
                        isoGameCharacter.climbThroughWindow(isoWindow, (Integer)4);
                        return;
                    }
                    IsoThumpable isoThumpable = isoGridSquare.getWindowThumpableTo(isoGridSquare2);
                    if (isoThumpable != null) {
                        if (!isoThumpable.canClimbThrough(isoGameCharacter)) {
                            isoGameCharacter.climbDownSheetRope();
                            return;
                        }
                        isoGameCharacter.climbThroughWindow(isoThumpable, (Integer)4);
                        return;
                    }
                    isoThumpable = isoGridSquare.getHoppableThumpableTo(isoGridSquare2);
                    if (isoThumpable != null) {
                        if (!IsoWindow.canClimbThroughHelper(isoGameCharacter, isoGridSquare, isoGridSquare2, isoGameCharacter.dir == IsoDirections.N || isoGameCharacter.dir == IsoDirections.S)) {
                            isoGameCharacter.climbDownSheetRope();
                            return;
                        }
                        isoGameCharacter.climbOverFence(isoGameCharacter.dir);
                        return;
                    }
                    IsoObject isoObject = isoGridSquare.getWindowFrameTo(isoGridSquare2);
                    if (isoObject != null) {
                        if (!IsoWindowFrame.canClimbThrough(isoObject, isoGameCharacter)) {
                            isoGameCharacter.climbDownSheetRope();
                            return;
                        }
                        isoGameCharacter.climbThroughWindowFrame(isoObject);
                        return;
                    }
                    IsoObject isoObject2 = isoGridSquare.getWallHoppableTo(isoGridSquare2);
                    if (isoObject2 != null) {
                        if (!IsoWindow.canClimbThroughHelper(isoGameCharacter, isoGridSquare, isoGridSquare2, isoGameCharacter.dir == IsoDirections.N || isoGameCharacter.dir == IsoDirections.S)) {
                            isoGameCharacter.climbDownSheetRope();
                            return;
                        }
                        isoGameCharacter.climbOverFence(isoGameCharacter.dir);
                        return;
                    }
                }
                return;
            }
            ++n;
        }
        isoGameCharacter.z = f6;
        if (isoGameCharacter.z >= 7.0f) {
            isoGameCharacter.setCollidable(true);
            isoGameCharacter.clearVariable("ClimbRope");
        }
        if (!IsoWindow.isSheetRopeHere(isoGameCharacter.getCurrentSquare())) {
            isoGameCharacter.setCollidable(true);
            isoGameCharacter.setbClimbing(false);
            isoGameCharacter.setbFalling(true);
            isoGameCharacter.clearVariable("ClimbRope");
        }
        if (isoGameCharacter instanceof IsoPlayer && ((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
            ((IsoPlayer)isoGameCharacter).dirtyRecalcGridStackTime = 2.0f;
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setIgnoreMovement(false);
        isoGameCharacter.setbClimbing(false);
        isoGameCharacter.clearVariable("ClimbRope");
    }

    public float getClimbSheetRopeSpeed(IsoGameCharacter isoGameCharacter) {
        float f = 0.16f;
        switch (isoGameCharacter.getPerkLevel(PerkFactory.Perks.Strength)) {
            case 0: {
                f -= 0.12f;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                f -= 0.09f;
                break;
            }
            case 6: 
            case 7: {
                f += 0.05f;
                break;
            }
            case 8: 
            case 9: {
                f += 0.09f;
                break;
            }
            case 10: {
                f += 0.12f;
            }
        }
        return f *= 0.5f;
    }
}

