/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import fmod.fmod.FMODManager;
import java.util.HashMap;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.GameTime;
import zombie.SoundManager;
import zombie.ZomboidGlobals;
import zombie.ai.State;
import zombie.ai.states.PathFindState;
import zombie.ai.states.WalkTowardNetworkState;
import zombie.ai.states.WalkTowardState;
import zombie.audio.parameters.ParameterCharacterMovementSpeed;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characters.BodyDamage.BodyPart;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.characters.Moodles.MoodleType;
import zombie.characters.MoveDeltaModifiers;
import zombie.characters.skills.PerkFactory;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.core.properties.PropertyContainer;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.debug.DebugOptions;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.Vector2;
import zombie.iso.objects.IsoThumpable;
import zombie.util.StringUtils;
import zombie.util.Type;

public final class ClimbOverFenceState
extends State {
    private static final ClimbOverFenceState _instance = new ClimbOverFenceState();
    static final Integer PARAM_START_X = 0;
    static final Integer PARAM_START_Y = 1;
    static final Integer PARAM_Z = 2;
    static final Integer PARAM_END_X = 3;
    static final Integer PARAM_END_Y = 4;
    static final Integer PARAM_DIR = 5;
    static final Integer PARAM_ZOMBIE_ON_FLOOR = 6;
    static final Integer PARAM_PREV_STATE = 7;
    static final Integer PARAM_SCRATCH = 8;
    static final Integer PARAM_COUNTER = 9;
    static final Integer PARAM_SOLID_FLOOR = 10;
    static final Integer PARAM_SHEET_ROPE = 11;
    static final Integer PARAM_RUN = 12;
    static final Integer PARAM_SPRINT = 13;
    static final Integer PARAM_COLLIDABLE = 14;
    static final int FENCE_TYPE_WOOD = 0;
    static final int FENCE_TYPE_METAL = 1;
    static final int FENCE_TYPE_SANDBAG = 2;
    static final int FENCE_TYPE_GRAVELBAG = 3;
    static final int FENCE_TYPE_BARBWIRE = 4;
    static final int FENCE_TYPE_ROADBLOCK = 5;
    static final int FENCE_TYPE_METAL_BARS = 6;
    static final int TRIP_WOOD = 0;
    static final int TRIP_METAL = 1;
    static final int TRIP_SANDBAG = 2;
    static final int TRIP_GRAVELBAG = 3;
    static final int TRIP_BARBWIRE = 4;
    public static final int TRIP_TREE = 5;
    public static final int TRIP_ZOMBIE = 6;
    public static final int COLLIDE_WITH_WALL = 7;
    public static final int TRIP_METAL_BARS = 8;
    public static final int TRIP_WINDOW = 9;

    public static ClimbOverFenceState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setVariable("FenceLungeX", 0.0f);
        isoGameCharacter.setVariable("FenceLungeY", 0.0f);
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        isoGameCharacter.setIgnoreMovement(true);
        if (hashMap.get(PARAM_RUN) == Boolean.TRUE) {
            isoGameCharacter.setVariable("VaultOverRun", true);
            isoGameCharacter.getStats().endurance = (float)((double)isoGameCharacter.getStats().endurance - ZomboidGlobals.RunningEnduranceReduce * 300.0);
        } else if (hashMap.get(PARAM_SPRINT) == Boolean.TRUE) {
            isoGameCharacter.setVariable("VaultOverSprint", true);
            isoGameCharacter.getStats().endurance = (float)((double)isoGameCharacter.getStats().endurance - ZomboidGlobals.RunningEnduranceReduce * 700.0);
        }
        boolean bl = hashMap.get(PARAM_COUNTER) == Boolean.TRUE;
        isoGameCharacter.setVariable("ClimbingFence", true);
        isoGameCharacter.setVariable("ClimbFenceStarted", false);
        isoGameCharacter.setVariable("ClimbFenceFinished", false);
        isoGameCharacter.setVariable("ClimbFenceOutcome", bl ? "obstacle" : "success");
        isoGameCharacter.clearVariable("ClimbFenceFlopped");
        if ((isoGameCharacter.getVariableBoolean("VaultOverRun") || isoGameCharacter.getVariableBoolean("VaultOverSprint")) && this.shouldFallAfterVaultOver(isoGameCharacter)) {
            isoGameCharacter.setVariable("ClimbFenceOutcome", "fall");
        }
        IsoZombie isoZombie = Type.tryCastTo(isoGameCharacter, IsoZombie.class);
        if (!bl && isoZombie != null && isoZombie.shouldDoFenceLunge()) {
            isoGameCharacter.setVariable("ClimbFenceOutcome", "lunge");
            this.setLungeXVars(isoZombie);
        }
        if (hashMap.get(PARAM_SOLID_FLOOR) == Boolean.FALSE) {
            isoGameCharacter.setVariable("ClimbFenceOutcome", "falling");
        }
        if (!(isoGameCharacter instanceof IsoZombie) && hashMap.get(PARAM_SHEET_ROPE) == Boolean.TRUE) {
            isoGameCharacter.setVariable("ClimbFenceOutcome", "rope");
        }
        if (isoGameCharacter instanceof IsoPlayer && ((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
            ((IsoPlayer)isoGameCharacter).dirtyRecalcGridStackTime = 20.0f;
        }
    }

    private void setLungeXVars(IsoZombie isoZombie) {
        IsoMovingObject isoMovingObject = isoZombie.getTarget();
        if (isoMovingObject == null) {
            return;
        }
        isoZombie.setVariable("FenceLungeX", 0.0f);
        isoZombie.setVariable("FenceLungeY", 0.0f);
        float f = 0.0f;
        Vector2 vector22 = isoZombie.getForwardDirection();
        PZMath.SideOfLine sideOfLine = PZMath.testSideOfLine(isoZombie.x, isoZombie.y, isoZombie.x + vector22.x, isoZombie.y + vector22.y, isoMovingObject.x, isoMovingObject.y);
        float f2 = (float)Math.acos(isoZombie.getDotWithForwardDirection(isoMovingObject.x, isoMovingObject.y));
        float f3 = PZMath.clamp(PZMath.radToDeg(f2), 0.0f, 90.0f);
        switch (sideOfLine) {
            case Left: {
                f = -f3 / 90.0f;
                break;
            }
            case OnLine: {
                f = 0.0f;
                break;
            }
            case Right: {
                f = f3 / 90.0f;
            }
        }
        isoZombie.setVariable("FenceLungeX", f);
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        float f;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        IsoDirections isoDirections = Type.tryCastTo(hashMap.get(PARAM_DIR), IsoDirections.class);
        int n = (Integer)hashMap.get(PARAM_END_X);
        int n2 = (Integer)hashMap.get(PARAM_END_Y);
        isoGameCharacter.setAnimated(true);
        if (isoDirections == IsoDirections.N) {
            isoGameCharacter.setDir(IsoDirections.N);
        } else if (isoDirections == IsoDirections.S) {
            isoGameCharacter.setDir(IsoDirections.S);
        } else if (isoDirections == IsoDirections.W) {
            isoGameCharacter.setDir(IsoDirections.W);
        } else if (isoDirections == IsoDirections.E) {
            isoGameCharacter.setDir(IsoDirections.E);
        }
        String string = isoGameCharacter.getVariableString("ClimbFenceOutcome");
        if (!"lunge".equals(string)) {
            f = 0.05f;
            if (isoDirections == IsoDirections.N || isoDirections == IsoDirections.S) {
                isoGameCharacter.x = isoGameCharacter.nx = PZMath.clamp(isoGameCharacter.x, (float)n + f, (float)(n + 1) - f);
            } else if (isoDirections == IsoDirections.W || isoDirections == IsoDirections.E) {
                isoGameCharacter.y = isoGameCharacter.ny = PZMath.clamp(isoGameCharacter.y, (float)n2 + f, (float)(n2 + 1) - f);
            }
        }
        if (!(!isoGameCharacter.getVariableBoolean("ClimbFenceStarted") || "back".equals(string) || "fallback".equals(string) || "lunge".equalsIgnoreCase(string) || "obstacle".equals(string) || "obstacleEnd".equals(string))) {
            f = ((Integer)hashMap.get(PARAM_START_X)).intValue();
            float f2 = ((Integer)hashMap.get(PARAM_START_Y)).intValue();
            switch (isoDirections) {
                case N: {
                    f2 -= 0.1f;
                    break;
                }
                case S: {
                    f2 += 1.1f;
                    break;
                }
                case W: {
                    f -= 0.1f;
                    break;
                }
                case E: {
                    f += 1.1f;
                }
            }
            if ((int)isoGameCharacter.x != (int)f && (isoDirections == IsoDirections.W || isoDirections == IsoDirections.E)) {
                this.slideX(isoGameCharacter, f);
            }
            if ((int)isoGameCharacter.y != (int)f2 && (isoDirections == IsoDirections.N || isoDirections == IsoDirections.S)) {
                this.slideY(isoGameCharacter, f2);
            }
        }
        if (isoGameCharacter instanceof IsoZombie) {
            boolean bl = hashMap.get(PARAM_ZOMBIE_ON_FLOOR) == Boolean.TRUE;
            isoGameCharacter.setOnFloor(bl);
            ((IsoZombie)isoGameCharacter).setKnockedDown(bl);
            isoGameCharacter.setFallOnFront(bl);
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        if (isoGameCharacter instanceof IsoPlayer && "fall".equals(isoGameCharacter.getVariableString("ClimbFenceOutcome"))) {
            isoGameCharacter.setSprinting(false);
        }
        isoGameCharacter.clearVariable("ClimbingFence");
        isoGameCharacter.clearVariable("ClimbFenceFinished");
        isoGameCharacter.clearVariable("ClimbFenceOutcome");
        isoGameCharacter.clearVariable("ClimbFenceStarted");
        isoGameCharacter.clearVariable("ClimbFenceFlopped");
        isoGameCharacter.ClearVariable("VaultOverSprint");
        isoGameCharacter.ClearVariable("VaultOverRun");
        isoGameCharacter.setIgnoreMovement(false);
        IsoZombie isoZombie = Type.tryCastTo(isoGameCharacter, IsoZombie.class);
        if (isoZombie != null) {
            isoZombie.AllowRepathDelay = 0.0f;
            if (hashMap.get(PARAM_PREV_STATE) == PathFindState.instance()) {
                if (isoGameCharacter.getPathFindBehavior2().getTargetChar() == null) {
                    isoGameCharacter.setVariable("bPathfind", true);
                    isoGameCharacter.setVariable("bMoving", false);
                } else if (isoZombie.isTargetLocationKnown()) {
                    isoGameCharacter.pathToCharacter(isoGameCharacter.getPathFindBehavior2().getTargetChar());
                } else if (isoZombie.LastTargetSeenX != -1) {
                    isoGameCharacter.pathToLocation(isoZombie.LastTargetSeenX, isoZombie.LastTargetSeenY, isoZombie.LastTargetSeenZ);
                }
            } else if (hashMap.get(PARAM_PREV_STATE) == WalkTowardState.instance() || hashMap.get(PARAM_PREV_STATE) == WalkTowardNetworkState.instance()) {
                isoGameCharacter.setVariable("bPathFind", false);
                isoGameCharacter.setVariable("bMoving", true);
            }
        }
        if (isoGameCharacter instanceof IsoZombie) {
            ((IsoZombie)isoGameCharacter).networkAI.isClimbing = false;
        }
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        ParameterCharacterMovementSpeed parameterCharacterMovementSpeed;
        long l;
        Object object;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        IsoZombie isoZombie = Type.tryCastTo(isoGameCharacter, IsoZombie.class);
        if (animEvent.m_EventName.equalsIgnoreCase("CheckAttack") && isoZombie != null && isoZombie.target instanceof IsoGameCharacter) {
            ((IsoGameCharacter)isoZombie.target).attackFromWindowsLunge(isoZombie);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("ActiveAnimFinishing")) {
            // empty if block
        }
        if (animEvent.m_EventName.equalsIgnoreCase("VaultSprintFallLanded")) {
            isoGameCharacter.dropHandItems();
            isoGameCharacter.fallenOnKnees();
        }
        if (animEvent.m_EventName.equalsIgnoreCase("FallenOnKnees")) {
            isoGameCharacter.fallenOnKnees();
        }
        if (animEvent.m_EventName.equalsIgnoreCase("OnFloor")) {
            hashMap.put(PARAM_ZOMBIE_ON_FLOOR, Boolean.parseBoolean(animEvent.m_ParameterValue));
            if (Boolean.parseBoolean(animEvent.m_ParameterValue)) {
                this.setLungeXVars((IsoZombie)isoGameCharacter);
                object = this.getFence(isoGameCharacter);
                if (this.countZombiesClimbingOver((IsoObject)object) >= 2) {
                    ((IsoObject)object).Damage = (short)(((IsoObject)object).Damage - Rand.Next(7, 12) / (this.isMetalFence((IsoObject)object) ? 2 : 1));
                    if (((IsoObject)object).Damage <= 0) {
                        IsoDirections isoDirections = Type.tryCastTo(hashMap.get(PARAM_DIR), IsoDirections.class);
                        ((IsoObject)object).destroyFence(isoDirections);
                    }
                }
                isoGameCharacter.setVariable("ClimbFenceFlopped", true);
            }
        }
        if (animEvent.m_EventName.equalsIgnoreCase("PlayFenceSound")) {
            if (!SoundManager.instance.isListenerInRange(isoGameCharacter.getX(), isoGameCharacter.getY(), 10.0f)) {
                return;
            }
            object = this.getFence(isoGameCharacter);
            if (object == null) {
                return;
            }
            int n = this.getFenceType((IsoObject)object);
            l = isoGameCharacter.getEmitter().playSoundImpl(animEvent.m_ParameterValue, null);
            if (isoGameCharacter instanceof IsoPlayer) {
                parameterCharacterMovementSpeed = ((IsoPlayer)isoGameCharacter).getParameterCharacterMovementSpeed();
                isoGameCharacter.getEmitter().setParameterValue(l, parameterCharacterMovementSpeed.getParameterDescription(), parameterCharacterMovementSpeed.calculateCurrentValue());
            }
            isoGameCharacter.getEmitter().setParameterValue(l, FMODManager.instance.getParameterDescription("FenceTypeLow"), n);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("PlayTripSound")) {
            if (!SoundManager.instance.isListenerInRange(isoGameCharacter.getX(), isoGameCharacter.getY(), 10.0f)) {
                return;
            }
            object = this.getFence(isoGameCharacter);
            if (object == null) {
                return;
            }
            int n = this.getTripType((IsoObject)object);
            l = isoGameCharacter.getEmitter().playSoundImpl(animEvent.m_ParameterValue, null);
            parameterCharacterMovementSpeed = ((IsoPlayer)isoGameCharacter).getParameterCharacterMovementSpeed();
            isoGameCharacter.getEmitter().setParameterValue(l, parameterCharacterMovementSpeed.getParameterDescription(), parameterCharacterMovementSpeed.calculateCurrentValue());
            isoGameCharacter.getEmitter().setParameterValue(l, FMODManager.instance.getParameterDescription("TripObstacleType"), n);
        }
        if (animEvent.m_EventName.equalsIgnoreCase("SetCollidable")) {
            hashMap.put(PARAM_COLLIDABLE, Boolean.parseBoolean(animEvent.m_ParameterValue));
        }
        if (animEvent.m_EventName.equalsIgnoreCase("SetState")) {
            if (isoZombie == null) {
                return;
            }
            try {
                object = ParameterZombieState.State.valueOf(animEvent.m_ParameterValue);
                isoZombie.parameterZombieState.setState((ParameterZombieState.State)((Object)object));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (animEvent.m_EventName.equalsIgnoreCase("VaultOverStarted")) {
            if (isoGameCharacter instanceof IsoPlayer && !((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
                return;
            }
            if (isoGameCharacter.isVariable("ClimbFenceOutcome", "fall")) {
                isoGameCharacter.reportEvent("EventFallClimb");
                isoGameCharacter.setVariable("BumpDone", true);
                isoGameCharacter.setFallOnFront(true);
            }
        }
    }

    @Override
    public void getDeltaModifiers(IsoGameCharacter isoGameCharacter, MoveDeltaModifiers moveDeltaModifiers) {
        boolean bl = isoGameCharacter.getPath2() != null;
        boolean bl2 = isoGameCharacter instanceof IsoPlayer;
        if (bl && bl2) {
            moveDeltaModifiers.turnDelta = Math.max(moveDeltaModifiers.turnDelta, 10.0f);
        }
    }

    @Override
    public boolean isIgnoreCollide(IsoGameCharacter isoGameCharacter, int n, int n2, int n3, int n4, int n5, int n6) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        int n7 = (Integer)hashMap.get(PARAM_START_X);
        int n8 = (Integer)hashMap.get(PARAM_START_Y);
        int n9 = (Integer)hashMap.get(PARAM_END_X);
        int n10 = (Integer)hashMap.get(PARAM_END_Y);
        int n11 = (Integer)hashMap.get(PARAM_Z);
        if (n11 != n3 || n11 != n6) {
            return false;
        }
        int n12 = PZMath.min(n7, n9);
        int n13 = PZMath.min(n8, n10);
        int n14 = PZMath.max(n7, n9);
        int n15 = PZMath.max(n8, n10);
        int n16 = PZMath.min(n, n4);
        int n17 = PZMath.min(n2, n5);
        int n18 = PZMath.max(n, n4);
        int n19 = PZMath.max(n2, n5);
        return n12 <= n16 && n13 <= n17 && n14 >= n18 && n15 >= n19;
    }

    private void slideX(IsoGameCharacter isoGameCharacter, float f) {
        float f2 = 0.05f * GameTime.getInstance().getMultiplier() / 1.6f;
        f2 = f > isoGameCharacter.x ? Math.min(f2, f - isoGameCharacter.x) : Math.max(-f2, f - isoGameCharacter.x);
        isoGameCharacter.x += f2;
        isoGameCharacter.nx = isoGameCharacter.x;
    }

    private void slideY(IsoGameCharacter isoGameCharacter, float f) {
        float f2 = 0.05f * GameTime.getInstance().getMultiplier() / 1.6f;
        f2 = f > isoGameCharacter.y ? Math.min(f2, f - isoGameCharacter.y) : Math.max(-f2, f - isoGameCharacter.y);
        isoGameCharacter.y += f2;
        isoGameCharacter.ny = isoGameCharacter.y;
    }

    private IsoObject getFence(IsoGameCharacter isoGameCharacter) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        int n = (Integer)hashMap.get(PARAM_START_X);
        int n2 = (Integer)hashMap.get(PARAM_START_Y);
        int n3 = (Integer)hashMap.get(PARAM_Z);
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n, n2, n3);
        int n4 = (Integer)hashMap.get(PARAM_END_X);
        int n5 = (Integer)hashMap.get(PARAM_END_Y);
        IsoGridSquare isoGridSquare2 = IsoWorld.instance.CurrentCell.getGridSquare(n4, n5, n3);
        if (isoGridSquare == null || isoGridSquare2 == null) {
            return null;
        }
        return isoGridSquare.getHoppableTo(isoGridSquare2);
    }

    private int getFenceType(IsoObject isoObject) {
        if (isoObject.getSprite() == null) {
            return 0;
        }
        PropertyContainer propertyContainer = isoObject.getSprite().getProperties();
        String string = propertyContainer.Val("FenceTypeLow");
        if (string != null) {
            if ("Sandbag".equals(string) && isoObject.getName() != null && StringUtils.containsIgnoreCase(isoObject.getName(), "Gravel")) {
                string = "Gravelbag";
            }
            return switch (string) {
                case "Wood" -> 0;
                case "Metal" -> 1;
                case "Sandbag" -> 2;
                case "Gravelbag" -> 3;
                case "Barbwire" -> 4;
                case "RoadBlock" -> 5;
                case "MetalGate" -> 6;
                default -> 0;
            };
        }
        return 0;
    }

    private int getTripType(IsoObject isoObject) {
        if (isoObject.getSprite() == null) {
            return 0;
        }
        PropertyContainer propertyContainer = isoObject.getSprite().getProperties();
        String string = propertyContainer.Val("FenceTypeLow");
        if (string != null) {
            if ("Sandbag".equals(string) && isoObject.getName() != null && StringUtils.containsIgnoreCase(isoObject.getName(), "Gravel")) {
                string = "Gravelbag";
            }
            return switch (string) {
                case "Wood" -> 0;
                case "Metal" -> 1;
                case "Sandbag" -> 2;
                case "Gravelbag" -> 3;
                case "Barbwire" -> 4;
                case "MetalGate" -> 8;
                default -> 0;
            };
        }
        return 0;
    }

    private boolean shouldFallAfterVaultOver(IsoGameCharacter isoGameCharacter) {
        BodyPart bodyPart;
        if (isoGameCharacter instanceof IsoPlayer && !((IsoPlayer)isoGameCharacter).isLocalPlayer()) {
            return ((IsoPlayer)isoGameCharacter).networkAI.climbFenceOutcomeFall;
        }
        if (DebugOptions.instance.Character.Debug.AlwaysTripOverFence.getValue()) {
            return true;
        }
        float f = 0.0f;
        if (isoGameCharacter.getVariableBoolean("VaultOverSprint")) {
            f = 10.0f;
        }
        if (isoGameCharacter.getMoodles() != null) {
            f += (float)(isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.Endurance) * 10);
            f += (float)(isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.HeavyLoad) * 13);
            f += (float)(isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.Pain) * 5);
        }
        if ((bodyPart = isoGameCharacter.getBodyDamage().getBodyPart(BodyPartType.Torso_Lower)).getAdditionalPain(true) > 20.0f) {
            f += (bodyPart.getAdditionalPain(true) - 20.0f) / 10.0f;
        }
        if (isoGameCharacter.Traits.Clumsy.isSet()) {
            f += 10.0f;
        }
        if (isoGameCharacter.Traits.Graceful.isSet()) {
            f -= 10.0f;
        }
        if (isoGameCharacter.Traits.VeryUnderweight.isSet()) {
            f += 20.0f;
        }
        if (isoGameCharacter.Traits.Underweight.isSet()) {
            f += 10.0f;
        }
        if (isoGameCharacter.Traits.Obese.isSet()) {
            f += 20.0f;
        }
        if (isoGameCharacter.Traits.Overweight.isSet()) {
            f += 10.0f;
        }
        return (float)Rand.Next(100) < (f -= (float)isoGameCharacter.getPerkLevel(PerkFactory.Perks.Fitness));
    }

    private int countZombiesClimbingOver(IsoObject isoObject) {
        if (isoObject == null || isoObject.getSquare() == null) {
            return 0;
        }
        int n = 0;
        IsoGridSquare isoGridSquare = isoObject.getSquare();
        n += this.countZombiesClimbingOver(isoObject, isoGridSquare);
        isoGridSquare = isoObject.getProperties().Is(IsoFlagType.HoppableN) ? isoGridSquare.getAdjacentSquare(IsoDirections.N) : isoGridSquare.getAdjacentSquare(IsoDirections.W);
        return n += this.countZombiesClimbingOver(isoObject, isoGridSquare);
    }

    private int countZombiesClimbingOver(IsoObject isoObject, IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < isoGridSquare.getMovingObjects().size(); ++i) {
            IsoZombie isoZombie = Type.tryCastTo(isoGridSquare.getMovingObjects().get(i), IsoZombie.class);
            if (isoZombie == null || isoZombie.target == null || !isoZombie.isCurrentState(this) || this.getFence(isoZombie) != isoObject) continue;
            ++n;
        }
        return n;
    }

    private boolean isMetalFence(IsoObject isoObject) {
        if (isoObject == null || isoObject.getProperties() == null) {
            return false;
        }
        PropertyContainer propertyContainer = isoObject.getProperties();
        String string = propertyContainer.Val("Material");
        String string2 = propertyContainer.Val("Material2");
        String string3 = propertyContainer.Val("Material3");
        if ("MetalBars".equals(string) || "MetalBars".equals(string2) || "MetalBars".equals(string3)) {
            return true;
        }
        if ("MetalWire".equals(string) || "MetalWire".equals(string2) || "MetalWire".equals(string3)) {
            return true;
        }
        if (isoObject instanceof IsoThumpable && isoObject.hasModData()) {
            KahluaTableIterator kahluaTableIterator = isoObject.getModData().iterator();
            while (kahluaTableIterator.advance()) {
                String string4 = Type.tryCastTo(kahluaTableIterator.getKey(), String.class);
                if (string4 == null || !string4.contains("MetalPipe")) continue;
                return true;
            }
        }
        return false;
    }

    public void setParams(IsoGameCharacter isoGameCharacter, IsoDirections isoDirections) {
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        int n = isoGameCharacter.getSquare().getX();
        int n2 = isoGameCharacter.getSquare().getY();
        int n3 = isoGameCharacter.getSquare().getZ();
        int n4 = n;
        int n5 = n2;
        int n6 = n;
        int n7 = n2;
        switch (isoDirections) {
            case N: {
                --n7;
                break;
            }
            case S: {
                ++n7;
                break;
            }
            case W: {
                --n6;
                break;
            }
            case E: {
                ++n6;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid direction");
            }
        }
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n6, n7, n3);
        boolean bl = false;
        boolean bl2 = isoGridSquare != null && isoGridSquare.Is(IsoFlagType.solidtrans);
        boolean bl3 = isoGridSquare != null && isoGridSquare.TreatAsSolidFloor();
        boolean bl4 = isoGridSquare != null && isoGameCharacter.canClimbDownSheetRope(isoGridSquare);
        hashMap.put(PARAM_START_X, n4);
        hashMap.put(PARAM_START_Y, n5);
        hashMap.put(PARAM_Z, n3);
        hashMap.put(PARAM_END_X, n6);
        hashMap.put(PARAM_END_Y, n7);
        hashMap.put(PARAM_DIR, (Object)isoDirections);
        hashMap.put(PARAM_ZOMBIE_ON_FLOOR, Boolean.FALSE);
        hashMap.put(PARAM_PREV_STATE, isoGameCharacter.getCurrentState());
        hashMap.put(PARAM_SCRATCH, bl ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put(PARAM_COUNTER, bl2 ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put(PARAM_SOLID_FLOOR, bl3 ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put(PARAM_SHEET_ROPE, bl4 ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put(PARAM_RUN, isoGameCharacter.isRunning() ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put(PARAM_SPRINT, isoGameCharacter.isSprinting() ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put(PARAM_COLLIDABLE, Boolean.FALSE);
    }
}

