/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import zombie.ai.State;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoSurvivor;
import zombie.characters.IsoZombie;
import zombie.iso.IsoDirections;
import zombie.iso.objects.IsoDeadBody;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.ui.TutorialManager;

public final class BurntToDeath
extends State {
    private static final BurntToDeath _instance = new BurntToDeath();

    public static BurntToDeath instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter instanceof IsoSurvivor) {
            isoGameCharacter.getDescriptor().bDead = true;
        }
        if (!(isoGameCharacter instanceof IsoZombie)) {
            isoGameCharacter.PlayAnimUnlooped("Die");
        } else {
            isoGameCharacter.PlayAnimUnlooped("ZombieDeath");
        }
        isoGameCharacter.def.AnimFrameIncrease = 0.25f;
        isoGameCharacter.setStateMachineLocked(true);
        String string = isoGameCharacter.isFemale() ? "FemaleZombieDeath" : "MaleZombieDeath";
        isoGameCharacter.getEmitter().playVocals(string);
        if (GameServer.bServer && isoGameCharacter instanceof IsoZombie) {
            GameServer.sendZombieSound(IsoZombie.ZombieSound.Burned, (IsoZombie)isoGameCharacter);
        }
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        if ((int)isoGameCharacter.def.Frame == isoGameCharacter.sprite.CurrentAnim.Frames.size() - 1) {
            if (isoGameCharacter == TutorialManager.instance.wife) {
                isoGameCharacter.dir = IsoDirections.S;
            }
            isoGameCharacter.RemoveAttachedAnims();
            if (GameClient.bClient && isoGameCharacter instanceof IsoZombie) {
                GameClient.sendZombieDeath((IsoZombie)isoGameCharacter);
            }
            if (!GameClient.bClient) {
                IsoDeadBody isoDeadBody = new IsoDeadBody(isoGameCharacter);
            }
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
    }
}

