/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import fmod.fmod.FMODManager;
import zombie.ai.State;
import zombie.audio.parameters.ParameterCharacterMovementSpeed;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.util.Type;

public final class BumpedState
extends State {
    private static final BumpedState _instance = new BumpedState();

    public static BumpedState instance() {
        return _instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.setBumpDone(false);
        isoGameCharacter.setVariable("BumpFallAnimFinished", false);
        isoGameCharacter.getAnimationPlayer().setTargetToAngle();
        isoGameCharacter.getForwardDirection().setLengthAndDirection(isoGameCharacter.getAnimationPlayer().getAngle(), 1.0f);
        this.setCharacterBlockMovement(isoGameCharacter, true);
        if (isoGameCharacter.getVariableBoolean("BumpFall")) {
            long l = isoGameCharacter.playSound("TripOverObstacle");
            ParameterCharacterMovementSpeed parameterCharacterMovementSpeed = ((IsoPlayer)isoGameCharacter).getParameterCharacterMovementSpeed();
            isoGameCharacter.getEmitter().setParameterValue(l, parameterCharacterMovementSpeed.getParameterDescription(), parameterCharacterMovementSpeed.calculateCurrentValue());
            String string = isoGameCharacter.getVariableString("TripObstacleType");
            if (string == null) {
                string = "zombie";
            }
            isoGameCharacter.clearVariable("TripObstacleType");
            int n = switch (string) {
                case "tree" -> 5;
                default -> 6;
            };
            isoGameCharacter.getEmitter().setParameterValue(l, FMODManager.instance.getParameterDescription("TripObstacleType"), n);
        }
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        boolean bl = isoGameCharacter.isBumpFall() || isoGameCharacter.isBumpStaggered();
        this.setCharacterBlockMovement(isoGameCharacter, bl);
    }

    private void setCharacterBlockMovement(IsoGameCharacter isoGameCharacter, boolean bl) {
        IsoPlayer isoPlayer = Type.tryCastTo(isoGameCharacter, IsoPlayer.class);
        if (isoPlayer != null) {
            isoPlayer.setBlockMovement(bl);
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        isoGameCharacter.clearVariable("BumpFallType");
        isoGameCharacter.clearVariable("BumpFallAnimFinished");
        isoGameCharacter.clearVariable("BumpAnimFinished");
        isoGameCharacter.setBumpType("");
        isoGameCharacter.setBumpedChr(null);
        IsoPlayer isoPlayer = Type.tryCastTo(isoGameCharacter, IsoPlayer.class);
        if (isoPlayer != null) {
            isoPlayer.setInitiateAttack(false);
            isoPlayer.attackStarted = false;
            isoPlayer.setAttackType(null);
        }
        if (isoPlayer != null && isoGameCharacter.isBumpFall()) {
            isoGameCharacter.fallenOnKnees();
        }
        isoGameCharacter.setOnFloor(false);
        isoGameCharacter.setBumpFall(false);
        this.setCharacterBlockMovement(isoGameCharacter, false);
        if (isoGameCharacter instanceof IsoZombie && ((IsoZombie)isoGameCharacter).target != null) {
            isoGameCharacter.pathToLocation((int)((IsoZombie)isoGameCharacter).target.getX(), (int)((IsoZombie)isoGameCharacter).target.getY(), (int)((IsoZombie)isoGameCharacter).target.getZ());
        }
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        if (animEvent.m_EventName.equalsIgnoreCase("FallOnFront")) {
            isoGameCharacter.setFallOnFront(Boolean.parseBoolean(animEvent.m_ParameterValue));
            isoGameCharacter.setOnFloor(isoGameCharacter.isFallOnFront());
        }
        if (animEvent.m_EventName.equalsIgnoreCase("FallOnBack")) {
            isoGameCharacter.setOnFloor(Boolean.parseBoolean(animEvent.m_ParameterValue));
        }
    }
}

