/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.states;

import java.util.HashMap;
import zombie.ai.State;
import zombie.audio.parameters.ParameterZombieState;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.skinnedmodel.advancedanimation.AnimEvent;
import zombie.network.GameClient;
import zombie.util.StringUtils;

public class AttackNetworkState
extends State {
    private static final AttackNetworkState s_instance = new AttackNetworkState();
    private String attackOutcome;

    public static AttackNetworkState instance() {
        return s_instance;
    }

    @Override
    public void enter(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        hashMap.clear();
        hashMap.put(0, Boolean.FALSE);
        this.attackOutcome = isoGameCharacter.getVariableString("AttackOutcome");
        isoGameCharacter.setVariable("AttackOutcome", "start");
        isoGameCharacter.clearVariable("AttackDidDamage");
        isoGameCharacter.clearVariable("ZombieBiteDone");
        isoZombie.setTargetSeenTime(1.0f);
        if (!isoZombie.bCrawling) {
            isoZombie.setVariable("AttackType", "bite");
        }
    }

    @Override
    public void execute(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        HashMap<Object, Object> hashMap = isoGameCharacter.getStateMachineParams(this);
        IsoGameCharacter isoGameCharacter2 = (IsoGameCharacter)isoZombie.target;
        if (isoGameCharacter2 != null && "Chainsaw".equals(isoGameCharacter2.getVariableString("ZombieHitReaction"))) {
            return;
        }
        String string = isoGameCharacter.getVariableString("AttackOutcome");
        if (!(!"success".equals(string) || isoGameCharacter.getVariableBoolean("bAttack") || isoGameCharacter2 != null && isoGameCharacter2.isGodMod() || isoGameCharacter.getVariableBoolean("AttackDidDamage") || isoGameCharacter.getVariableString("ZombieBiteDone") == "true")) {
            isoGameCharacter.setVariable("AttackOutcome", "interrupted");
        }
        if (isoGameCharacter2 == null || isoGameCharacter2.isDead()) {
            isoZombie.setTargetSeenTime(10.0f);
        }
        if (isoGameCharacter2 != null && hashMap.get(0) == Boolean.FALSE && !"started".equals(string) && !StringUtils.isNullOrEmpty(isoGameCharacter.getVariableString("PlayerHitReaction"))) {
            hashMap.put(0, Boolean.TRUE);
        }
        isoZombie.setShootable(true);
        if (isoZombie.target != null && !isoZombie.bCrawling) {
            if (!"fail".equals(string) && !"interrupted".equals(string)) {
                isoZombie.faceThisObject(isoZombie.target);
            }
            isoZombie.setOnFloor(false);
        }
        if (isoZombie.target != null) {
            isoZombie.target.setTimeSinceZombieAttack(0);
            isoZombie.target.setLastTargettedBy(isoZombie);
        }
        if (!isoZombie.bCrawling) {
            isoZombie.setVariable("AttackType", "bite");
        }
    }

    @Override
    public void exit(IsoGameCharacter isoGameCharacter) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        isoGameCharacter.clearVariable("AttackOutcome");
        isoGameCharacter.clearVariable("AttackType");
        isoGameCharacter.clearVariable("PlayerHitReaction");
        isoGameCharacter.setStateMachineLocked(false);
        if (isoZombie.target != null && isoZombie.target.isOnFloor()) {
            isoZombie.setEatBodyTarget(isoZombie.target, true);
            isoZombie.setTarget(null);
        }
        isoZombie.AllowRepathDelay = 0.0f;
    }

    @Override
    public void animEvent(IsoGameCharacter isoGameCharacter, AnimEvent animEvent) {
        IsoZombie isoZombie = (IsoZombie)isoGameCharacter;
        if (GameClient.bClient && isoZombie.isRemoteZombie()) {
            if (animEvent.m_EventName.equalsIgnoreCase("SetAttackOutcome")) {
                isoZombie.setVariable("AttackOutcome", "fail".equals(this.attackOutcome) ? "fail" : "success");
            }
            if (animEvent.m_EventName.equalsIgnoreCase("AttackCollisionCheck") && isoZombie.target instanceof IsoPlayer) {
                IsoPlayer isoPlayer = (IsoPlayer)isoZombie.target;
                if (isoZombie.scratch) {
                    isoZombie.getEmitter().playSoundImpl("ZombieScratch", isoZombie);
                } else if (isoZombie.laceration) {
                    isoZombie.getEmitter().playSoundImpl("ZombieScratch", isoZombie);
                } else {
                    isoZombie.getEmitter().playSoundImpl("ZombieBite", isoZombie);
                    isoPlayer.splatBloodFloorBig();
                    isoPlayer.splatBloodFloorBig();
                    isoPlayer.splatBloodFloorBig();
                }
            }
            if (animEvent.m_EventName.equalsIgnoreCase("EatBody")) {
                isoGameCharacter.setVariable("EatingStarted", true);
                ((IsoZombie)isoGameCharacter).setEatBodyTarget(((IsoZombie)isoGameCharacter).target, true);
                ((IsoZombie)isoGameCharacter).setTarget(null);
            }
        }
        if (animEvent.m_EventName.equalsIgnoreCase("SetState")) {
            isoZombie.parameterZombieState.setState(ParameterZombieState.State.Attack);
        }
    }

    @Override
    public boolean isAttacking(IsoGameCharacter isoGameCharacter) {
        return true;
    }
}

