/*
 * Decompiled with CFR 0.152.
 */
package zombie.ai.sadisticAIDirector;

import zombie.GameTime;
import zombie.GameWindow;
import zombie.SandboxOptions;
import zombie.SoundManager;
import zombie.VirtualZombieManager;
import zombie.WorldSoundManager;
import zombie.ZombieSpawnRecorder;
import zombie.ai.sadisticAIDirector.SleepingEventData;
import zombie.characters.BodyDamage.BodyPart;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.characters.Moodles.MoodleType;
import zombie.core.Rand;
import zombie.core.logger.ExceptionLogger;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoBarricade;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoRadio;
import zombie.iso.objects.IsoStove;
import zombie.iso.objects.IsoTelevision;
import zombie.iso.objects.IsoWindow;
import zombie.iso.weather.ClimateManager;
import zombie.network.GameClient;
import zombie.ui.UIManager;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;

public final class SleepingEvent {
    public static final SleepingEvent instance = new SleepingEvent();
    public static boolean zombiesInvasion = false;

    public void setPlayerFallAsleep(IsoPlayer isoPlayer, int n) {
        SleepingEventData sleepingEventData = isoPlayer.getOrCreateSleepingEventData();
        sleepingEventData.reset();
        if (IsoWorld.getZombiesEnabled()) {
            return;
        }
        if (ClimateManager.getInstance().isRaining() && this.isExposedToPrecipitation(isoPlayer)) {
            sleepingEventData.bRaining = true;
            sleepingEventData.bWasRainingAtStart = true;
            sleepingEventData.rainTimeStartHours = GameTime.getInstance().getWorldAgeHours();
        }
        sleepingEventData.sleepingTime = n;
        isoPlayer.setTimeOfSleep(GameTime.instance.getTimeOfDay());
        this.doDelayToSleep(isoPlayer);
        this.checkNightmare(isoPlayer, n);
        if (sleepingEventData.nightmareWakeUp > -1) {
            return;
        }
        if (SandboxOptions.instance.SleepingEvent.getValue() == 1 || !zombiesInvasion) {
            return;
        }
        if (isoPlayer.getCurrentSquare() != null && isoPlayer.getCurrentSquare().getZone() != null && isoPlayer.getCurrentSquare().getZone().haveConstruction) {
            return;
        }
        boolean bl = false;
        if ((GameTime.instance.getHour() >= 0 && GameTime.instance.getHour() < 5 || GameTime.instance.getHour() > 18) && n >= 4) {
            bl = true;
        }
        int n2 = 20;
        if (SandboxOptions.instance.SleepingEvent.getValue() == 3) {
            n2 = 45;
        }
        if (Rand.Next(100) <= n2 && isoPlayer.getCell().getZombieList().size() >= 1 && n >= 4) {
            int n3 = 0;
            if (isoPlayer.getCurrentBuilding() != null) {
                IsoGridSquare isoGridSquare = null;
                IsoWindow isoWindow = null;
                for (int i = 0; i < 3; ++i) {
                    for (int j = isoPlayer.getCurrentBuilding().getDef().getX() - 2; j < isoPlayer.getCurrentBuilding().getDef().getX2() + 2; ++j) {
                        for (int k = isoPlayer.getCurrentBuilding().getDef().getY() - 2; k < isoPlayer.getCurrentBuilding().getDef().getY2() + 2; ++k) {
                            IsoDoor isoDoor;
                            boolean bl2;
                            isoGridSquare = IsoWorld.instance.getCell().getGridSquare(j, k, i);
                            if (isoGridSquare == null) continue;
                            boolean bl3 = bl2 = isoGridSquare.haveElectricity() || IsoWorld.instance.isHydroPowerOn();
                            if (bl2) {
                                for (int i2 = 0; i2 < isoGridSquare.getObjects().size(); ++i2) {
                                    IsoObject isoObject = isoGridSquare.getObjects().get(i2);
                                    if (isoObject.getContainer() != null && (isoObject.getContainer().getType().equals("fridge") || isoObject.getContainer().getType().equals("freezer"))) {
                                        n3 += 3;
                                    }
                                    if (isoObject instanceof IsoStove && ((IsoStove)isoObject).Activated()) {
                                        n3 += 5;
                                    }
                                    if (isoObject instanceof IsoTelevision && ((IsoTelevision)isoObject).getDeviceData().getIsTurnedOn()) {
                                        n3 += 30;
                                    }
                                    if (!(isoObject instanceof IsoRadio) || !((IsoRadio)isoObject).getDeviceData().getIsTurnedOn()) continue;
                                    n3 += 30;
                                }
                            }
                            if ((isoWindow = isoGridSquare.getWindow()) != null) {
                                n3 += this.checkWindowStatus(isoWindow);
                            }
                            if ((isoDoor = isoGridSquare.getIsoDoor()) == null || !isoDoor.isExteriorDoor(null) || !isoDoor.IsOpen()) continue;
                            n3 += 25;
                            sleepingEventData.openDoor = isoDoor;
                        }
                    }
                }
                if (SandboxOptions.instance.SleepingEvent.getValue() == 3) {
                    n3 = (int)((double)n3 * 1.5);
                }
                if (n3 > 70) {
                    n3 = 70;
                }
                if (!bl) {
                    n3 /= 2;
                }
                if (Rand.Next(100) <= n3) {
                    sleepingEventData.forceWakeUpTime = Rand.Next(n - 4, n - 1);
                    sleepingEventData.zombiesIntruders = true;
                }
            }
        }
    }

    private void doDelayToSleep(IsoPlayer isoPlayer) {
        float f = 0.3f;
        float f2 = 2.0f;
        if (isoPlayer.Traits.Insomniac.isSet()) {
            f = 1.0f;
        }
        if (isoPlayer.getMoodles().getMoodleLevel(MoodleType.Pain) > 0) {
            f += 1.0f + (float)isoPlayer.getMoodles().getMoodleLevel(MoodleType.Pain) * 0.2f;
        }
        if (isoPlayer.getMoodles().getMoodleLevel(MoodleType.Stress) > 0) {
            f *= 1.2f;
        }
        if ("badBed".equals(isoPlayer.getBedType())) {
            f *= 1.3f;
        } else if ("goodBed".equals(isoPlayer.getBedType())) {
            f *= 0.8f;
        } else if ("floor".equals(isoPlayer.getBedType())) {
            f *= 1.6f;
        }
        if (isoPlayer.Traits.NightOwl.isSet()) {
            f *= 0.5f;
        }
        if (isoPlayer.getSleepingTabletEffect() > 1000.0f) {
            f = 0.1f;
        }
        if (f > f2) {
            f = f2;
        }
        float f3 = Rand.Next(0.0f, f);
        isoPlayer.setDelayToSleep(GameTime.instance.getTimeOfDay() + f3);
    }

    private void checkNightmare(IsoPlayer isoPlayer, int n) {
        if (GameClient.bClient) {
            return;
        }
        SleepingEventData sleepingEventData = isoPlayer.getOrCreateSleepingEventData();
        if (n >= 3) {
            int n2 = 5 + isoPlayer.getMoodles().getMoodleLevel(MoodleType.Stress) * 10;
            if (Rand.Next(100) < n2) {
                sleepingEventData.nightmareWakeUp = Rand.Next(3, n - 2);
            }
        }
    }

    private int checkWindowStatus(IsoWindow isoWindow) {
        IsoBarricade isoBarricade;
        IsoGridSquare isoGridSquare = isoWindow.getSquare();
        if (isoWindow.getSquare().getRoom() == null) {
            isoGridSquare = !isoWindow.north ? isoWindow.getSquare().getCell().getGridSquare(isoWindow.getSquare().getX() - 1, isoWindow.getSquare().getY(), isoWindow.getSquare().getZ()) : isoWindow.getSquare().getCell().getGridSquare(isoWindow.getSquare().getX(), isoWindow.getSquare().getY() - 1, isoWindow.getSquare().getZ());
        }
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < isoGridSquare.getRoom().lightSwitches.size(); ++i) {
            if (!isoGridSquare.getRoom().lightSwitches.get(i).isActivated()) continue;
            bl = true;
            break;
        }
        if (bl) {
            IsoBarricade isoBarricade2;
            n = 20;
            if (isoWindow.HasCurtains() != null && !isoWindow.HasCurtains().open) {
                n -= 17;
            }
            if ((isoBarricade2 = isoWindow.getBarricadeOnOppositeSquare()) == null) {
                isoBarricade2 = isoWindow.getBarricadeOnSameSquare();
            }
            if (isoBarricade2 != null && (isoBarricade2.getNumPlanks() > 4 || isoBarricade2.isMetal())) {
                n -= 20;
            }
            if (n < 0) {
                n = 0;
            }
            if (isoGridSquare.getZ() > 0) {
                n /= 2;
            }
            return n;
        }
        n = 5;
        if (isoWindow.HasCurtains() != null && !isoWindow.HasCurtains().open) {
            n -= 5;
        }
        if ((isoBarricade = isoWindow.getBarricadeOnOppositeSquare()) == null) {
            isoBarricade = isoWindow.getBarricadeOnSameSquare();
        }
        if (isoBarricade != null && (isoBarricade.getNumPlanks() > 3 || isoBarricade.isMetal())) {
            n -= 5;
        }
        if (n < 0) {
            n = 0;
        }
        if (isoGridSquare.getZ() > 0) {
            n /= 2;
        }
        return n;
    }

    public void update(IsoPlayer isoPlayer) {
        if (isoPlayer == null) {
            return;
        }
        SleepingEventData sleepingEventData = isoPlayer.getOrCreateSleepingEventData();
        if (sleepingEventData.nightmareWakeUp == (int)isoPlayer.getAsleepTime()) {
            isoPlayer.getStats().Panic += 70.0f;
            isoPlayer.getStats().stress += 0.5f;
            WorldSoundManager.instance.addSound(isoPlayer, (int)isoPlayer.getX(), (int)isoPlayer.getY(), (int)isoPlayer.getZ(), 6, 1);
            SoundManager.instance.setMusicWakeState(isoPlayer, "WakeNightmare");
            this.wakeUp(isoPlayer);
        }
        if (sleepingEventData.forceWakeUpTime == (int)isoPlayer.getAsleepTime() && sleepingEventData.zombiesIntruders) {
            this.spawnZombieIntruders(isoPlayer);
            WorldSoundManager.instance.addSound(isoPlayer, (int)isoPlayer.getX(), (int)isoPlayer.getY(), (int)isoPlayer.getZ(), 6, 1);
            SoundManager.instance.setMusicWakeState(isoPlayer, "WakeZombies");
            this.wakeUp(isoPlayer);
        }
        this.updateRain(isoPlayer);
        this.updateSnow(isoPlayer);
        this.updateTemperature(isoPlayer);
        this.updateWetness(isoPlayer);
    }

    private void updateRain(IsoPlayer isoPlayer) {
        SleepingEventData sleepingEventData = isoPlayer.getOrCreateSleepingEventData();
        if (!ClimateManager.getInstance().isRaining()) {
            sleepingEventData.bRaining = false;
            sleepingEventData.bWasRainingAtStart = false;
            sleepingEventData.rainTimeStartHours = -1.0;
            return;
        }
        if (!this.isExposedToPrecipitation(isoPlayer)) {
            return;
        }
        double d = GameTime.getInstance().getWorldAgeHours();
        if (!sleepingEventData.bWasRainingAtStart) {
            if (!sleepingEventData.bRaining) {
                sleepingEventData.rainTimeStartHours = d;
            }
            if (sleepingEventData.getHoursSinceRainStarted() >= 0.16666666666666666) {
                // empty if block
            }
        }
        sleepingEventData.bRaining = true;
    }

    private void updateSnow(IsoPlayer isoPlayer) {
        if (!ClimateManager.getInstance().isSnowing()) {
            return;
        }
        if (!this.isExposedToPrecipitation(isoPlayer)) {
            return;
        }
    }

    private void updateTemperature(IsoPlayer isoPlayer) {
    }

    private void updateWetness(IsoPlayer isoPlayer) {
    }

    private boolean isExposedToPrecipitation(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter.getCurrentSquare() == null) {
            return false;
        }
        if (isoGameCharacter.getCurrentSquare().isInARoom() || isoGameCharacter.getCurrentSquare().haveRoof) {
            return false;
        }
        if (isoGameCharacter.getBed() != null && "Tent".equals(isoGameCharacter.getBed().getName())) {
            return false;
        }
        BaseVehicle baseVehicle = isoGameCharacter.getVehicle();
        return baseVehicle == null || !baseVehicle.hasRoof(baseVehicle.getSeat(isoGameCharacter));
    }

    private void spawnZombieIntruders(IsoPlayer isoPlayer) {
        SleepingEventData sleepingEventData = isoPlayer.getOrCreateSleepingEventData();
        IsoGridSquare isoGridSquare = null;
        if (sleepingEventData.openDoor != null) {
            isoGridSquare = sleepingEventData.openDoor.getSquare();
        } else {
            sleepingEventData.weakestWindow = this.getWeakestWindow(isoPlayer);
            if (sleepingEventData.weakestWindow != null && sleepingEventData.weakestWindow.getZ() == 0.0f) {
                isoGridSquare = !sleepingEventData.weakestWindow.north ? (sleepingEventData.weakestWindow.getSquare().getRoom() == null ? sleepingEventData.weakestWindow.getSquare() : sleepingEventData.weakestWindow.getSquare().getCell().getGridSquare(sleepingEventData.weakestWindow.getSquare().getX() - 1, sleepingEventData.weakestWindow.getSquare().getY(), sleepingEventData.weakestWindow.getSquare().getZ())) : (sleepingEventData.weakestWindow.getSquare().getRoom() == null ? sleepingEventData.weakestWindow.getSquare() : sleepingEventData.weakestWindow.getSquare().getCell().getGridSquare(sleepingEventData.weakestWindow.getSquare().getX(), sleepingEventData.weakestWindow.getSquare().getY() + 1, sleepingEventData.weakestWindow.getSquare().getZ()));
                IsoBarricade isoBarricade = sleepingEventData.weakestWindow.getBarricadeOnOppositeSquare();
                if (isoBarricade == null) {
                    isoBarricade = sleepingEventData.weakestWindow.getBarricadeOnSameSquare();
                }
                if (isoBarricade != null) {
                    isoBarricade.Damage(Rand.Next(500, 900));
                } else {
                    sleepingEventData.weakestWindow.Damage(200.0f);
                    sleepingEventData.weakestWindow.smashWindow();
                    if (sleepingEventData.weakestWindow.HasCurtains() != null) {
                        sleepingEventData.weakestWindow.removeSheet(null);
                    }
                    if (isoGridSquare != null) {
                        isoGridSquare.addBrokenGlass();
                    }
                }
            }
        }
        isoPlayer.getStats().setPanic(isoPlayer.getStats().getPanic() + (float)Rand.Next(30, 60));
        if (isoGridSquare == null) {
            return;
        }
        if (IsoWorld.getZombiesEnabled()) {
            int n = Rand.Next(3) + 1;
            for (int i = 0; i < n; ++i) {
                VirtualZombieManager.instance.choices.clear();
                VirtualZombieManager.instance.choices.add(isoGridSquare);
                IsoZombie isoZombie = VirtualZombieManager.instance.createRealZombieAlways(IsoDirections.fromIndex(Rand.Next(8)).index(), false);
                if (isoZombie == null) continue;
                isoZombie.setTarget(isoPlayer);
                isoZombie.pathToCharacter(isoPlayer);
                isoZombie.spotted(isoPlayer, true);
                ZombieSpawnRecorder.instance.record(isoZombie, this.getClass().getSimpleName());
            }
        }
    }

    private IsoWindow getWeakestWindow(IsoPlayer isoPlayer) {
        IsoGridSquare isoGridSquare = null;
        IsoWindow isoWindow = null;
        IsoWindow isoWindow2 = null;
        int n = 0;
        for (int i = isoPlayer.getCurrentBuilding().getDef().getX() - 2; i < isoPlayer.getCurrentBuilding().getDef().getX2() + 2; ++i) {
            for (int j = isoPlayer.getCurrentBuilding().getDef().getY() - 2; j < isoPlayer.getCurrentBuilding().getDef().getY2() + 2; ++j) {
                int n2;
                isoGridSquare = IsoWorld.instance.getCell().getGridSquare(i, j, 0);
                if (isoGridSquare == null || (isoWindow = isoGridSquare.getWindow()) == null || (n2 = this.checkWindowStatus(isoWindow)) <= n) continue;
                n = n2;
                isoWindow2 = isoWindow;
            }
        }
        return isoWindow2;
    }

    public void wakeUp(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter == null) {
            return;
        }
        this.wakeUp(isoGameCharacter, false);
    }

    public void wakeUp(IsoGameCharacter isoGameCharacter, boolean bl) {
        SleepingEventData sleepingEventData = isoGameCharacter.getOrCreateSleepingEventData();
        if (GameClient.bClient && !bl) {
            GameClient.instance.wakeUpPlayer((IsoPlayer)isoGameCharacter);
        }
        boolean bl2 = false;
        IsoPlayer isoPlayer = Type.tryCastTo(isoGameCharacter, IsoPlayer.class);
        if (isoPlayer != null && isoPlayer.isLocalPlayer()) {
            UIManager.setFadeBeforeUI(isoPlayer.getPlayerNum(), true);
            UIManager.FadeIn(isoPlayer.getPlayerNum(), 2.0);
            if (!GameClient.bClient && IsoPlayer.allPlayersAsleep()) {
                UIManager.getSpeedControls().SetCurrentGameSpeed(1);
                bl2 = true;
            }
            isoGameCharacter.setLastHourSleeped((int)isoPlayer.getHoursSurvived());
        }
        isoGameCharacter.setForceWakeUpTime(-1.0f);
        isoGameCharacter.setAsleep(false);
        if (bl2) {
            try {
                GameWindow.save(true);
            }
            catch (Throwable throwable) {
                ExceptionLogger.logException(throwable);
            }
        }
        BodyPart bodyPart = isoGameCharacter.getBodyDamage().getBodyPart(BodyPartType.Neck);
        float f = sleepingEventData.sleepingTime / 8.0f;
        if ("goodBed".equals(isoGameCharacter.getBedType())) {
            isoGameCharacter.getStats().setFatigue(isoGameCharacter.getStats().getFatigue() - Rand.Next(0.05f, 0.12f) * f);
            if (isoGameCharacter.getStats().getFatigue() < 0.0f) {
                isoGameCharacter.getStats().setFatigue(0.0f);
            }
        } else if ("badBed".equals(isoGameCharacter.getBedType())) {
            isoGameCharacter.getStats().setFatigue(isoGameCharacter.getStats().getFatigue() + Rand.Next(0.1f, 0.2f) * f);
            if (Rand.Next(5) == 0) {
                bodyPart.AddDamage(Rand.Next(5.0f, 15.0f));
                bodyPart.setAdditionalPain(bodyPart.getAdditionalPain() + Rand.Next(30.0f, 50.0f));
            }
        } else if ("floor".equals(isoGameCharacter.getBedType())) {
            isoGameCharacter.getStats().setFatigue(isoGameCharacter.getStats().getFatigue() + Rand.Next(0.15f, 0.25f) * f);
            if (Rand.Next(5) == 0) {
                bodyPart.AddDamage(Rand.Next(10.0f, 20.0f));
                bodyPart.setAdditionalPain(bodyPart.getAdditionalPain() + Rand.Next(30.0f, 50.0f));
            }
        } else if (Rand.Next(10) == 0) {
            bodyPart.AddDamage(Rand.Next(3.0f, 12.0f));
            bodyPart.setAdditionalPain(bodyPart.getAdditionalPain() + Rand.Next(10.0f, 30.0f));
        }
        sleepingEventData.reset();
    }
}

